/*******************************************************************
*   CA_SID_2001_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'CA_SID_2001_CORE.ASC' FIXED / 
 AGE                   1-   3
 AGEDAY                4-   6
 AGEMONTH              7-   9
 AMONTH               10-  11
 ASCHED               12-  13
 ASOURCE              14-  15
 ASOURCE_             16-  18 (A)
 AWEEKEND             19-  20
 DIED                 21-  22
 DISP_X               23-  24 (A)
 DISPUNIF             25-  26
 DNR                  27-  28
 DQTR                 29-  30
 DRG                  31-  33
 DRG18                34-  36
 DRGVER               37-  38
 DX1                  39-  43 (A)
 DX2                  44-  48 (A)
 DX3                  49-  53 (A)
 DX4                  54-  58 (A)
 DX5                  59-  63 (A)
 DX6                  64-  68 (A)
 DX7                  69-  73 (A)
 DX8                  74-  78 (A)
 DX9                  79-  83 (A)
 DX10                 84-  88 (A)
 DX11                 89-  93 (A)
 DX12                 94-  98 (A)
 DX13                 99- 103 (A)
 DX14                104- 108 (A)
 DX15                109- 113 (A)
 DX16                114- 118 (A)
 DX17                119- 123 (A)
 DX18                124- 128 (A)
 DX19                129- 133 (A)
 DX20                134- 138 (A)
 DX21                139- 143 (A)
 DX22                144- 148 (A)
 DX23                149- 153 (A)
 DX24                154- 158 (A)
 DX25                159- 163 (A)
 DX26                164- 168 (A)
 DX27                169- 173 (A)
 DX28                174- 178 (A)
 DX29                179- 183 (A)
 DX30                184- 188 (A)
 DXATAD1             189- 190
 DXATAD2             191- 192
 DXATAD3             193- 194
 DXATAD4             195- 196
 DXATAD5             197- 198
 DXATAD6             199- 200
 DXATAD7             201- 202
 DXATAD8             203- 204
 DXATAD9             205- 206
 DXATAD10            207- 208
 DXATAD11            209- 210
 DXATAD12            211- 212
 DXATAD13            213- 214
 DXATAD14            215- 216
 DXATAD15            217- 218
 DXATAD16            219- 220
 DXATAD17            221- 222
 DXATAD18            223- 224
 DXATAD19            225- 226
 DXATAD20            227- 228
 DXATAD21            229- 230
 DXATAD22            231- 232
 DXATAD23            233- 234
 DXATAD24            235- 236
 DXATAD25            237- 238
 DXCCS1              239- 242
 DXCCS2              243- 246
 DXCCS3              247- 250
 DXCCS4              251- 254
 DXCCS5              255- 258
 DXCCS6              259- 262
 DXCCS7              263- 266
 DXCCS8              267- 270
 DXCCS9              271- 274
 DXCCS10             275- 278
 DXCCS11             279- 282
 DXCCS12             283- 286
 DXCCS13             287- 290
 DXCCS14             291- 294
 DXCCS15             295- 298
 DXCCS16             299- 302
 DXCCS17             303- 306
 DXCCS18             307- 310
 DXCCS19             311- 314
 DXCCS20             315- 318
 DXCCS21             319- 322
 DXCCS22             323- 326
 DXCCS23             327- 330
 DXCCS24             331- 334
 DXCCS25             335- 338
 DXCCS26             339- 342
 DXCCS27             343- 346
 DXCCS28             347- 350
 DXCCS29             351- 354
 DXCCS30             355- 358
 FEMALE              359- 360
 HISPANIC            361     (A)
 HOSPST              362- 363 (A)
 LEVELCAR            364     (A)
 LOS                 365- 369
 LOS_X               370- 375
 MDC                 376- 377
 MDC18               378- 379
 NDX                 380- 381
 NEOMAT              382- 383
 NPR                 384- 385
 PAY1                386- 387
 PAY1_X              388- 390 (A)
 PAYER1_X            391- 394 (A)
 PNUM_S              395- 411 (A)
 PR1                 412- 415 (A)
 PR2                 416- 419 (A)
 PR3                 420- 423 (A)
 PR4                 424- 427 (A)
 PR5                 428- 431 (A)
 PR6                 432- 435 (A)
 PR7                 436- 439 (A)
 PR8                 440- 443 (A)
 PR9                 444- 447 (A)
 PR10                448- 451 (A)
 PR11                452- 455 (A)
 PR12                456- 459 (A)
 PR13                460- 463 (A)
 PR14                464- 467 (A)
 PR15                468- 471 (A)
 PR16                472- 475 (A)
 PR17                476- 479 (A)
 PR18                480- 483 (A)
 PR19                484- 487 (A)
 PR20                488- 491 (A)
 PR21                492- 495 (A)
 PRCCS1              496- 498
 PRCCS2              499- 501
 PRCCS3              502- 504
 PRCCS4              505- 507
 PRCCS5              508- 510
 PRCCS6              511- 513
 PRCCS7              514- 516
 PRCCS8              517- 519
 PRCCS9              520- 522
 PRCCS10             523- 525
 PRCCS11             526- 528
 PRCCS12             529- 531
 PRCCS13             532- 534
 PRCCS14             535- 537
 PRCCS15             538- 540
 PRCCS16             541- 543
 PRCCS17             544- 546
 PRCCS18             547- 549
 PRCCS19             550- 552
 PRCCS20             553- 555
 PRCCS21             556- 558
 PRDAY1              559- 563
 PRDAY2              564- 568
 PRDAY3              569- 573
 PRDAY4              574- 578
 PRDAY5              579- 583
 PRDAY6              584- 588
 PRDAY7              589- 593
 PRDAY8              594- 598
 PRDAY9              599- 603
 PRDAY10             604- 608
 PRDAY11             609- 613
 PRDAY12             614- 618
 PRDAY13             619- 623
 PRDAY14             624- 628
 PRDAY15             629- 633
 PRDAY16             634- 638
 PRDAY17             639- 643
 PRDAY18             644- 648
 PRDAY19             649- 653
 PRDAY20             654- 658
 PRDAY21             659- 663
 RACE                664- 665
 RACE_X              666     (A)
 TOTCHG              667- 676
 TOTCHG_X            677- 691
 YEAR                692- 695.


***  Specify write formats  ***.
FORMATS
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 AMONTH              (F3.0) /
 ASCHED              (F3.0) /
 ASOURCE             (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISPUNIF            (F3.0) /
 DNR                 (F3.0) /
 DQTR                (F3.0) /
 DRG                 (F3.0) /
 DRG18               (F3.0) /
 DRGVER              (F3.0) /
 DXATAD1             (F3.0) /
 DXATAD2             (F3.0) /
 DXATAD3             (F3.0) /
 DXATAD4             (F3.0) /
 DXATAD5             (F3.0) /
 DXATAD6             (F3.0) /
 DXATAD7             (F3.0) /
 DXATAD8             (F3.0) /
 DXATAD9             (F3.0) /
 DXATAD10            (F3.0) /
 DXATAD11            (F3.0) /
 DXATAD12            (F3.0) /
 DXATAD13            (F3.0) /
 DXATAD14            (F3.0) /
 DXATAD15            (F3.0) /
 DXATAD16            (F3.0) /
 DXATAD17            (F3.0) /
 DXATAD18            (F3.0) /
 DXATAD19            (F3.0) /
 DXATAD20            (F3.0) /
 DXATAD21            (F3.0) /
 DXATAD22            (F3.0) /
 DXATAD23            (F3.0) /
 DXATAD24            (F3.0) /
 DXATAD25            (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 DXCCS12             (F4.0) /
 DXCCS13             (F4.0) /
 DXCCS14             (F4.0) /
 DXCCS15             (F4.0) /
 DXCCS16             (F4.0) /
 DXCCS17             (F4.0) /
 DXCCS18             (F4.0) /
 DXCCS19             (F4.0) /
 DXCCS20             (F4.0) /
 DXCCS21             (F4.0) /
 DXCCS22             (F4.0) /
 DXCCS23             (F4.0) /
 DXCCS24             (F4.0) /
 DXCCS25             (F4.0) /
 DXCCS26             (F4.0) /
 DXCCS27             (F4.0) /
 DXCCS28             (F4.0) /
 DXCCS29             (F4.0) /
 DXCCS30             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 MDC                 (F3.0) /
 MDC18               (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 PRCCS9              (F3.0) /
 PRCCS10             (F3.0) /
 PRCCS11             (F3.0) /
 PRCCS12             (F3.0) /
 PRCCS13             (F3.0) /
 PRCCS14             (F3.0) /
 PRCCS15             (F3.0) /
 PRCCS16             (F3.0) /
 PRCCS17             (F3.0) /
 PRCCS18             (F3.0) /
 PRCCS19             (F3.0) /
 PRCCS20             (F3.0) /
 PRCCS21             (F3.0) /
 PRDAY1              (F4.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PRDAY7              (F4.0) /
 PRDAY8              (F4.0) /
 PRDAY9              (F4.0) /
 PRDAY10             (F4.0) /
 PRDAY11             (F4.0) /
 PRDAY12             (F4.0) /
 PRDAY13             (F4.0) /
 PRDAY14             (F4.0) /
 PRDAY15             (F4.0) /
 PRDAY16             (F4.0) /
 PRDAY17             (F4.0) /
 PRDAY18             (F4.0) /
 PRDAY19             (F4.0) /
 PRDAY20             (F4.0) /
 PRDAY21             (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASCHED    "Admission scheduled vs. unscheduled"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 AWEEKEND  "Admission day is a weekend"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUNIF  "Disposition of patient (uniform)"
 DNR       "Do not resuscitate indicator"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRGVER    "DRG grouper version used on discharge date"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DX26      "Diagnosis 26"
 DX27      "Diagnosis 27"
 DX28      "Diagnosis 28"
 DX29      "Diagnosis 29"
 DX30      "Diagnosis 30"
 DXATAD1   "Principal diagnosis present at admission"
 DXATAD2   "Diagnosis 2 present at admission"
 DXATAD3   "Diagnosis 3 present at admission"
 DXATAD4   "Diagnosis 4 present at admission"
 DXATAD5   "Diagnosis 5 present at admission"
 DXATAD6   "Diagnosis 6 present at admission"
 DXATAD7   "Diagnosis 7 present at admission"
 DXATAD8   "Diagnosis 8 present at admission"
 DXATAD9   "Diagnosis 9 present at admission"
 DXATAD10  "Diagnosis 10 present at admission"
 DXATAD11  "Diagnosis 11 present at admission"
 DXATAD12  "Diagnosis 12 present at admission"
 DXATAD13  "Diagnosis 13 present at admission"
 DXATAD14  "Diagnosis 14 present at admission"
 DXATAD15  "Diagnosis 15 present at admission"
 DXATAD16  "Diagnosis 16 present at admission"
 DXATAD17  "Diagnosis 17 present at admission"
 DXATAD18  "Diagnosis 18 present at admission"
 DXATAD19  "Diagnosis 19 present at admission"
 DXATAD20  "Diagnosis 20 present at admission"
 DXATAD21  "Diagnosis 21 present at admission"
 DXATAD22  "Diagnosis 22 present at admission"
 DXATAD23  "Diagnosis 23 present at admission"
 DXATAD24  "Diagnosis 24 present at admission"
 DXATAD25  "Diagnosis 25 present at admission"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXCCS26   "CCS: diagnosis 26"
 DXCCS27   "CCS: diagnosis 27"
 DXCCS28   "CCS: diagnosis 28"
 DXCCS29   "CCS: diagnosis 29"
 DXCCS30   "CCS: diagnosis 30"
 FEMALE    "Indicator of sex"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPST    "Hospital state postal code"
 LEVELCAR  "Level of patient care (as received from source)"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAYER1_X  "Primary expected payer plan identifier (as received from source)"
 PNUM_S    "Person number (synthetic)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 PRDAY16   "Number of days from admission to PR16"
 PRDAY17   "Number of days from admission to PR17"
 PRDAY18   "Number of days from admission to PR18"
 PRDAY19   "Number of days from admission to PR19"
 PRDAY20   "Number of days from admission to PR20"
 PRDAY21   "Number of days from admission to PR21"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASCHED
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD1
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD2
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD3
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD4
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD5
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD6
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD7
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD8
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD9
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD10
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD11
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD12
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD13
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD14
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD15
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD16
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD17
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD18
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD19
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD20
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD21
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD22
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD23
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD24
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD25
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).



SAVE OUTFILE = 'CA_SID_2001_CORE.SAV' /COMPRESSED.
