/*******************************************************************
*   CO_SID_1993_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'CO_SID_1993_CORE.ASC' FIXED / 
 AGE                   1-   3
 AGEDAY                4-   6
 SEX                   7-   9
 RACE                 10-  11
 DQTR                 12-  13
 LOS                  14-  18
 DISP                 19-  20
 DIED                 21-  22
 ATYPE                23-  24
 ASOURCE              25-  26
 NDX                  27-  28
 DX1                  29-  33 (A)
 DXV1                 34-  37
 DCCHPR1              38-  41
 NPR                  42-  43
 PR1                  44-  47 (A)
 PRV1                 48-  50
 PCCHPR1              51-  54
 DRG                  55-  57
 MDC                  58-  59
 DRGVER               60-  61
 DRG10                62-  64
 MDC10                65-  66
 PAY1                 67-  68
 TOTCHG               69-  78
 PROCESS              79-  89
 YEAR                 90-  93
 DSHOSPID             94- 106 (A)
 DSNUM               107- 109
 DSTYPE              110- 112
 HOSPST              113- 114 (A)
 MDID_S              115- 130 (A)
 SURGID_S            131- 146 (A)
 ADAYWK              147- 149
 AMONTH              150- 151
 LOS_X               152- 156
 NEOMAT              157- 158
 DXSYS               159- 161
 DSNDX               162- 164
 PRSYS               165- 167
 DSNPR               168- 170
 PRDAY1              171- 175
 PAY1_N              176- 178
 TOTCHG_X            179- 190
 DX2                 191- 195 (A)
 DX3                 196- 200 (A)
 DX4                 201- 205 (A)
 DX5                 206- 210 (A)
 DX6                 211- 215 (A)
 DX7                 216- 220 (A)
 DX8                 221- 225 (A)
 DX9                 226- 230 (A)
 DX10                231- 235 (A)
 DX11                236- 240 (A)
 DX12                241- 245 (A)
 DX13                246- 250 (A)
 DX14                251- 255 (A)
 DX15                256- 260 (A)
 DXV2                261- 264
 DXV3                265- 268
 DXV4                269- 272
 DXV5                273- 276
 DXV6                277- 280
 DXV7                281- 284
 DXV8                285- 288
 DXV9                289- 292
 DXV10               293- 296
 DXV11               297- 300
 DXV12               301- 304
 DXV13               305- 308
 DXV14               309- 312
 DXV15               313- 316
 DCCHPR2             317- 320
 DCCHPR3             321- 324
 DCCHPR4             325- 328
 DCCHPR5             329- 332
 DCCHPR6             333- 336
 DCCHPR7             337- 340
 DCCHPR8             341- 344
 DCCHPR9             345- 348
 DCCHPR10            349- 352
 DCCHPR11            353- 356
 DCCHPR12            357- 360
 DCCHPR13            361- 364
 DCCHPR14            365- 368
 DCCHPR15            369- 372
 PR2                 373- 376 (A)
 PR3                 377- 380 (A)
 PR4                 381- 384 (A)
 PR5                 385- 388 (A)
 PR6                 389- 392 (A)
 PR7                 393- 396 (A)
 PR8                 397- 400 (A)
 PR9                 401- 404 (A)
 PR10                405- 408 (A)
 PR11                409- 412 (A)
 PR12                413- 416 (A)
 PR13                417- 420 (A)
 PR14                421- 424 (A)
 PR15                425- 428 (A)
 PRV2                429- 431
 PRV3                432- 434
 PRV4                435- 437
 PRV5                438- 440
 PRV6                441- 443
 PRV7                444- 446
 PRV8                447- 449
 PRV9                450- 452
 PRV10               453- 455
 PRV11               456- 458
 PRV12               459- 461
 PRV13               462- 464
 PRV14               465- 467
 PRV15               468- 470
 PCCHPR2             471- 474
 PCCHPR3             475- 478
 PCCHPR4             479- 482
 PCCHPR5             483- 486
 PCCHPR6             487- 490
 PCCHPR7             491- 494
 PCCHPR8             495- 498
 PCCHPR9             499- 502
 PCCHPR10            503- 506
 PCCHPR11            507- 510
 PCCHPR12            511- 514
 PCCHPR13            515- 518
 PCCHPR14            519- 522
 PCCHPR15            523- 526
 ZIP                 527- 531 (A)
 MRN_S               532- 548 (A)
 PSTCO               549- 553
 BWT                 554- 557
 PAY1_X              558- 559 (A)
 AYEAR               560- 563
 DMONTH              564- 565
 PRMNTH1             566- 567
 PRYEAR1             568- 571.


***  Specify write formats  ***.
FORMATS
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 SEX                 (F3.0) /
 RACE                (F3.0) /
 DQTR                (F3.0) /
 LOS                 (F4.0) /
 DISP                (F3.0) /
 DIED                (F3.0) /
 ATYPE               (F3.0) /
 ASOURCE             (F3.0) /
 NDX                 (F3.0) /
 DXV1                (F3.0) /
 DCCHPR1             (F3.0) /
 NPR                 (F3.0) /
 PRV1                (F3.0) /
 PCCHPR1             (F3.0) /
 DRG                 (F3.0) /
 MDC                 (F3.0) /
 DRGVER              (F3.0) /
 DRG10               (F3.0) /
 MDC10               (F3.0) /
 PAY1                (F3.0) /
 TOTCHG              (F6.0) /
 PROCESS             (F6.0) /
 YEAR                (F3.0) /
 DSNUM               (F3.0) /
 DSTYPE              (F3.0) /
 ADAYWK              (F3.0) /
 AMONTH              (F3.0) /
 LOS_X               (F3.0) /
 NEOMAT              (F3.0) /
 DXSYS               (F3.0) /
 DSNDX               (F3.0) /
 PRSYS               (F3.0) /
 DSNPR               (F3.0) /
 PRDAY1              (F3.0) /
 PAY1_N              (F3.0) /
 TOTCHG_X            (F6.2) /
 DXV2                (F3.0) /
 DXV3                (F3.0) /
 DXV4                (F3.0) /
 DXV5                (F3.0) /
 DXV6                (F3.0) /
 DXV7                (F3.0) /
 DXV8                (F3.0) /
 DXV9                (F3.0) /
 DXV10               (F3.0) /
 DXV11               (F3.0) /
 DXV12               (F3.0) /
 DXV13               (F3.0) /
 DXV14               (F3.0) /
 DXV15               (F3.0) /
 DCCHPR2             (F3.0) /
 DCCHPR3             (F3.0) /
 DCCHPR4             (F3.0) /
 DCCHPR5             (F3.0) /
 DCCHPR6             (F3.0) /
 DCCHPR7             (F3.0) /
 DCCHPR8             (F3.0) /
 DCCHPR9             (F3.0) /
 DCCHPR10            (F3.0) /
 DCCHPR11            (F3.0) /
 DCCHPR12            (F3.0) /
 DCCHPR13            (F3.0) /
 DCCHPR14            (F3.0) /
 DCCHPR15            (F3.0) /
 PRV2                (F3.0) /
 PRV3                (F3.0) /
 PRV4                (F3.0) /
 PRV5                (F3.0) /
 PRV6                (F3.0) /
 PRV7                (F3.0) /
 PRV8                (F3.0) /
 PRV9                (F3.0) /
 PRV10               (F3.0) /
 PRV11               (F3.0) /
 PRV12               (F3.0) /
 PRV13               (F3.0) /
 PRV14               (F3.0) /
 PRV15               (F3.0) /
 PCCHPR2             (F3.0) /
 PCCHPR3             (F3.0) /
 PCCHPR4             (F3.0) /
 PCCHPR5             (F3.0) /
 PCCHPR6             (F3.0) /
 PCCHPR7             (F3.0) /
 PCCHPR8             (F3.0) /
 PCCHPR9             (F3.0) /
 PCCHPR10            (F3.0) /
 PCCHPR11            (F3.0) /
 PCCHPR12            (F3.0) /
 PCCHPR13            (F3.0) /
 PCCHPR14            (F3.0) /
 PCCHPR15            (F3.0) /
 PSTCO               (F4.0) /
 BWT                 (F3.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 PRMNTH1             (F3.0) /
 PRYEAR1             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "I:Age in years at admission"
 AGEDAY    "I:Age in days (when < 1 year)"
 SEX       "I:Sex"
 RACE      "I:Race"
 DQTR      "I:Discharge quarter"
 LOS       "I:Length of stay (cleaned)"
 DISP      "I:Disposition of patient"
 DIED      "I:Died during hospitalization"
 ATYPE     "I:Admission type"
 ASOURCE   "I:Admission source"
 NDX       "I:Number of diagnoses on this discharge"
 DX1       "I:Principal diagnosis"
 DXV1      "I:Validity flag: principal diagnosis"
 DCCHPR1   "I:CCHPR: principal diagnosis"
 NPR       "I:Number of procedures on this discharge"
 PR1       "I:Principal procedure"
 PRV1      "I:Validity flag: principal procedure"
 PCCHPR1   "I:CCHPR: principal procedure"
 DRG       "I:DRG in effect on discharge date"
 MDC       "I:MDC in effect on discharge date"
 DRGVER    "I:DRG grouper version used on disch date"
 DRG10     "I:DRG, Version 10"
 MDC10     "I:MDC, Version 10"
 PAY1      "I:Primary expected payer, uniform"
 TOTCHG    "I:Total charges (cleaned)"
 PROCESS   "I:HCUP-3 discharge processing ID number"
 YEAR      "Calendar year"
 DSHOSPID  "I:Data source hospital ID number"
 DSNUM     "I:Data source ID number"
 DSTYPE    "I:Data source type"
 HOSPST    "Hospital state postal code"
 MDID_S    "I:Attending physician number (synthetic)"
 SURGID_S  "I:Primary surgeon number (synthetic)"
 ADAYWK    "I:Admission day of week"
 AMONTH    "I:Admission month"
 LOS_X     "I:Length of stay (uncleaned)"
 NEOMAT    "I:Neonatal and/or maternal DX and/or PR"
 DXSYS     "I:Diagnosis coding system"
 DSNDX     "I:Max number of diagnoses from source"
 PRSYS     "I:Procedure coding system"
 DSNPR     "I:Max number of procedures from source"
 PRDAY1    "I:No. of days from admission to PR1"
 PAY1_N    "I:Primary expected payer, nonuniform"
 TOTCHG_X  "I:Total charges (from data source)"
 DX2       "I:Diagnosis 2"
 DX3       "I:Diagnosis 3"
 DX4       "I:Diagnosis 4"
 DX5       "I:Diagnosis 5"
 DX6       "I:Diagnosis 6"
 DX7       "I:Diagnosis 7"
 DX8       "I:Diagnosis 8"
 DX9       "I:Diagnosis 9"
 DX10      "I:Diagnosis 10"
 DX11      "I:Diagnosis 11"
 DX12      "I:Diagnosis 12"
 DX13      "I:Diagnosis 13"
 DX14      "I:Diagnosis 14"
 DX15      "I:Diagnosis 15"
 DXV2      "I:Validity flag: diagnosis 2"
 DXV3      "I:Validity flag: diagnosis 3"
 DXV4      "I:Validity flag: diagnosis 4"
 DXV5      "I:Validity flag: diagnosis 5"
 DXV6      "I:Validity flag: diagnosis 6"
 DXV7      "I:Validity flag: diagnosis 7"
 DXV8      "I:Validity flag: diagnosis 8"
 DXV9      "I:Validity flag: diagnosis 9"
 DXV10     "I:Validity flag: diagnosis 10"
 DXV11     "I:Validity flag: diagnosis 11"
 DXV12     "I:Validity flag: diagnosis 12"
 DXV13     "I:Validity flag: diagnosis 13"
 DXV14     "I:Validity flag: diagnosis 14"
 DXV15     "I:Validity flag: diagnosis 15"
 DCCHPR2   "I:CCHPR: diagnosis 2"
 DCCHPR3   "I:CCHPR: diagnosis 3"
 DCCHPR4   "I:CCHPR: diagnosis 4"
 DCCHPR5   "I:CCHPR: diagnosis 5"
 DCCHPR6   "I:CCHPR: diagnosis 6"
 DCCHPR7   "I:CCHPR: diagnosis 7"
 DCCHPR8   "I:CCHPR: diagnosis 8"
 DCCHPR9   "I:CCHPR: diagnosis 9"
 DCCHPR10  "I:CCHPR: diagnosis 10"
 DCCHPR11  "I:CCHPR: diagnosis 11"
 DCCHPR12  "I:CCHPR: diagnosis 12"
 DCCHPR13  "I:CCHPR: diagnosis 13"
 DCCHPR14  "I:CCHPR: diagnosis 14"
 DCCHPR15  "I:CCHPR: diagnosis 15"
 PR2       "I:Procedure 2"
 PR3       "I:Procedure 3"
 PR4       "I:Procedure 4"
 PR5       "I:Procedure 5"
 PR6       "I:Procedure 6"
 PR7       "I:Procedure 7"
 PR8       "I:Procedure 8"
 PR9       "I:Procedure 9"
 PR10      "I:Procedure 10"
 PR11      "I:Procedure 11"
 PR12      "I:Procedure 12"
 PR13      "I:Procedure 13"
 PR14      "I:Procedure 14"
 PR15      "I:Procedure 15"
 PRV2      "I:Validity flag: procedure 2"
 PRV3      "I:Validity flag: procedure 3"
 PRV4      "I:Validity flag: procedure 4"
 PRV5      "I:Validity flag: procedure 5"
 PRV6      "I:Validity flag: procedure 6"
 PRV7      "I:Validity flag: procedure 7"
 PRV8      "I:Validity flag: procedure 8"
 PRV9      "I:Validity flag: procedure 9"
 PRV10     "I:Validity flag: procedure 10"
 PRV11     "I:Validity flag: procedure 11"
 PRV12     "I:Validity flag: procedure 12"
 PRV13     "I:Validity flag: procedure 13"
 PRV14     "I:Validity flag: procedure 14"
 PRV15     "I:Validity flag: procedure 15"
 PCCHPR2   "I:CCHPR: procedure 2"
 PCCHPR3   "I:CCHPR: procedure 3"
 PCCHPR4   "I:CCHPR: procedure 4"
 PCCHPR5   "I:CCHPR: procedure 5"
 PCCHPR6   "I:CCHPR: procedure 6"
 PCCHPR7   "I:CCHPR: procedure 7"
 PCCHPR8   "I:CCHPR: procedure 8"
 PCCHPR9   "I:CCHPR: procedure 9"
 PCCHPR10  "I:CCHPR: procedure 10"
 PCCHPR11  "I:CCHPR: procedure 11"
 PCCHPR12  "I:CCHPR: procedure 12"
 PCCHPR13  "I:CCHPR: procedure 13"
 PCCHPR14  "I:CCHPR: procedure 14"
 PCCHPR15  "I:CCHPR: procedure 15"
 ZIP       "I:Patient zip code"
 MRN_S     "I:Medical record number (synthetic)"
 PSTCO     "I:Patient state/county FIPS code"
 BWT       "I:Birthweight in grams"
 PAY1_X    "I:Primary exp. payer (from data source)"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE SEX
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE DISP
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE DXV1
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PRV1
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE DSNUM
 (-99,-88,-66,-55=SYSMIS).
RECODE DSTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE ADAYWK
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS_X
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE DXSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNDX
 (-99,-88,-66,-55=SYSMIS).
RECODE PRSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNPR
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PAY1_N
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG_X
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE DXV2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV15
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR11
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR12
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR13
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR14
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRV2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV15
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'CO_SID_1993_CORE.SAV' /COMPRESSED.
