/*******************************************************************
*   CO_SID_2012_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'CO_SID_2012_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ATYPE                     12-  13
 AWEEKEND                  14-  15
 BWT                       16-  19
 DIED                      20-  21
 DISPUB04                  22-  23
 DISPUNIFORM               24-  25
 DISP_X                    26-  27 (A)
 DQTR                      28-  29
 DRG                       30-  32
 DRG24                     33-  35
 DRGVER                    36-  37
 DRG_NoPOA                 38-  40
 DSHOSPID                  41-  57 (A)
 DX1                       58-  62 (A)
 DX2                       63-  67 (A)
 DX3                       68-  72 (A)
 DX4                       73-  77 (A)
 DX5                       78-  82 (A)
 DX6                       83-  87 (A)
 DX7                       88-  92 (A)
 DX8                       93-  97 (A)
 DX9                       98- 102 (A)
 DX10                     103- 107 (A)
 DX11                     108- 112 (A)
 DX12                     113- 117 (A)
 DX13                     118- 122 (A)
 DX14                     123- 127 (A)
 DX15                     128- 132 (A)
 DX16                     133- 137 (A)
 DX17                     138- 142 (A)
 DX18                     143- 147 (A)
 DX19                     148- 152 (A)
 DX20                     153- 157 (A)
 DX21                     158- 162 (A)
 DX22                     163- 167 (A)
 DX23                     168- 172 (A)
 DX24                     173- 177 (A)
 DX25                     178- 182 (A)
 DX26                     183- 187 (A)
 DX27                     188- 192 (A)
 DX28                     193- 197 (A)
 DX29                     198- 202 (A)
 DX30                     203- 207 (A)
 DXCCS1                   208- 211
 DXCCS2                   212- 215
 DXCCS3                   216- 219
 DXCCS4                   220- 223
 DXCCS5                   224- 227
 DXCCS6                   228- 231
 DXCCS7                   232- 235
 DXCCS8                   236- 239
 DXCCS9                   240- 243
 DXCCS10                  244- 247
 DXCCS11                  248- 251
 DXCCS12                  252- 255
 DXCCS13                  256- 259
 DXCCS14                  260- 263
 DXCCS15                  264- 267
 DXCCS16                  268- 271
 DXCCS17                  272- 275
 DXCCS18                  276- 279
 DXCCS19                  280- 283
 DXCCS20                  284- 287
 DXCCS21                  288- 291
 DXCCS22                  292- 295
 DXCCS23                  296- 299
 DXCCS24                  300- 303
 DXCCS25                  304- 307
 DXCCS26                  308- 311
 DXCCS27                  312- 315
 DXCCS28                  316- 319
 DXCCS29                  320- 323
 DXCCS30                  324- 327
 ECODE1                   328- 332 (A)
 ECODE2                   333- 337 (A)
 ECODE3                   338- 342 (A)
 ECODE4                   343- 347 (A)
 ECODE5                   348- 352 (A)
 ECODE6                   353- 357 (A)
 ECODE7                   358- 362 (A)
 ECODE8                   363- 367 (A)
 ECODE9                   368- 372 (A)
 ECODE10                  373- 377 (A)
 ECODE11                  378- 382 (A)
 ECODE12                  383- 387 (A)
 ECODE13                  388- 392 (A)
 ECODE14                  393- 397 (A)
 ECODE15                  398- 402 (A)
 ECODE16                  403- 407 (A)
 E_CCS1                   408- 411
 E_CCS2                   412- 415
 E_CCS3                   416- 419
 E_CCS4                   420- 423
 E_CCS5                   424- 427
 E_CCS6                   428- 431
 E_CCS7                   432- 435
 E_CCS8                   436- 439
 E_CCS9                   440- 443
 E_CCS10                  444- 447
 E_CCS11                  448- 451
 E_CCS12                  452- 455
 E_CCS13                  456- 459
 E_CCS14                  460- 463
 E_CCS15                  464- 467
 E_CCS16                  468- 471
 FEMALE                   472- 473
 HCUP_ED                  474- 475
 HCUP_OS                  476- 477
 HOSPBRTH                 478- 480
 HOSPST                   481- 482 (A)
 Homeless                 483- 484
 KEY                      485- 499
 LOS                      500- 504
 LOS_X                    505- 510
 MDC                      511- 512
 MDC24                    513- 514
 MDC_NoPOA                515- 516
 MDNUM1_R                 517- 525
 MDNUM2_R                 526- 534
 MEDINCSTQ                535- 536
 MRN_R                    537- 545
 NCHRONIC                 546- 548
 NDX                      549- 550
 NECODE                   551- 552
 NEOMAT                   553- 554
 NPR                      555- 556
 ORPROC                   557- 558
 PAY1                     559- 560
 PAY1_X                   561- 562 (A)
 PL_CBSA                  563- 565
 PL_MSA1993               566- 568
 PL_NCHS2006              569- 570
 PL_RUCA10_2005           571- 572
 PL_RUCA2005              573- 576
 PL_RUCA4_2005            577- 578
 PL_RUCC2003              579- 580
 PL_UIC2003               581- 582
 PL_UR_CAT4               583- 584
 PR1                      585- 588 (A)
 PR2                      589- 592 (A)
 PR3                      593- 596 (A)
 PR4                      597- 600 (A)
 PR5                      601- 604 (A)
 PR6                      605- 608 (A)
 PR7                      609- 612 (A)
 PR8                      613- 616 (A)
 PR9                      617- 620 (A)
 PR10                     621- 624 (A)
 PR11                     625- 628 (A)
 PR12                     629- 632 (A)
 PR13                     633- 636 (A)
 PR14                     637- 640 (A)
 PR15                     641- 644 (A)
 PR16                     645- 648 (A)
 PR17                     649- 652 (A)
 PR18                     653- 656 (A)
 PR19                     657- 660 (A)
 PR20                     661- 664 (A)
 PR21                     665- 668 (A)
 PR22                     669- 672 (A)
 PR23                     673- 676 (A)
 PR24                     677- 680 (A)
 PR25                     681- 684 (A)
 PR26                     685- 688 (A)
 PR27                     689- 692 (A)
 PR28                     693- 696 (A)
 PR29                     697- 700 (A)
 PR30                     701- 704 (A)
 PRCCS1                   705- 707
 PRCCS2                   708- 710
 PRCCS3                   711- 713
 PRCCS4                   714- 716
 PRCCS5                   717- 719
 PRCCS6                   720- 722
 PRCCS7                   723- 725
 PRCCS8                   726- 728
 PRCCS9                   729- 731
 PRCCS10                  732- 734
 PRCCS11                  735- 737
 PRCCS12                  738- 740
 PRCCS13                  741- 743
 PRCCS14                  744- 746
 PRCCS15                  747- 749
 PRCCS16                  750- 752
 PRCCS17                  753- 755
 PRCCS18                  756- 758
 PRCCS19                  759- 761
 PRCCS20                  762- 764
 PRCCS21                  765- 767
 PRCCS22                  768- 770
 PRCCS23                  771- 773
 PRCCS24                  774- 776
 PRCCS25                  777- 779
 PRCCS26                  780- 782
 PRCCS27                  783- 785
 PRCCS28                  786- 788
 PRCCS29                  789- 791
 PRCCS30                  792- 794
 PRDAY1                   795- 799
 PRDAY2                   800- 804
 PRDAY3                   805- 809
 PRDAY4                   810- 814
 PRDAY5                   815- 819
 PRDAY6                   820- 824
 PRDAY7                   825- 829
 PRDAY8                   830- 834
 PRDAY9                   835- 839
 PRDAY10                  840- 844
 PRDAY11                  845- 849
 PRDAY12                  850- 854
 PRDAY13                  855- 859
 PRDAY14                  860- 864
 PRDAY15                  865- 869
 PRDAY16                  870- 874
 PRDAY17                  875- 879
 PRDAY18                  880- 884
 PRDAY19                  885- 889
 PRDAY20                  890- 894
 PRDAY21                  895- 899
 PRDAY22                  900- 904
 PRDAY23                  905- 909
 PRDAY24                  910- 914
 PRDAY25                  915- 919
 PRDAY26                  920- 924
 PRDAY27                  925- 929
 PRDAY28                  930- 934
 PRDAY29                  935- 939
 PRDAY30                  940- 944
 PROCTYPE                 945- 947
 PSTATE                   948- 949 (A)
 PSTCO                    950- 954
 PSTCO2                   955- 959
 PointOfOriginUB04        960     (A)
 PointOfOrigin_X          961     (A)
 RACE                     962- 963
 RACE_X                   964     (A)
 TOTCHG                   965- 974
 TOTCHG_X                 975- 989
 TRAN_IN                  990- 991
 TRAN_OUT                 992- 993
 YEAR                     994- 997
 ZIP3                     998-1000 (A)
 ZIPINC_QRTL             1001-1003
 ZIP                     1004-1008 (A)
 AYEAR                   1009-1012
 DMONTH                  1013-1014
 BMONTH                  1015-1016
 BYEAR                   1017-1020
 PRMONTH1                1021-1022
 PRMONTH2                1023-1024
 PRMONTH3                1025-1026
 PRMONTH4                1027-1028
 PRMONTH5                1029-1030
 PRMONTH6                1031-1032
 PRMONTH7                1033-1034
 PRMONTH8                1035-1036
 PRMONTH9                1037-1038
 PRMONTH10               1039-1040
 PRMONTH11               1041-1042
 PRMONTH12               1043-1044
 PRMONTH13               1045-1046
 PRMONTH14               1047-1048
 PRMONTH15               1049-1050
 PRMONTH16               1051-1052
 PRMONTH17               1053-1054
 PRMONTH18               1055-1056
 PRMONTH19               1057-1058
 PRMONTH20               1059-1060
 PRMONTH21               1061-1062
 PRMONTH22               1063-1064
 PRMONTH23               1065-1066
 PRMONTH24               1067-1068
 PRMONTH25               1069-1070
 PRMONTH26               1071-1072
 PRMONTH27               1073-1074
 PRMONTH28               1075-1076
 PRMONTH29               1077-1078
 PRMONTH30               1079-1080
 PRYEAR1                 1081-1084
 PRYEAR2                 1085-1088
 PRYEAR3                 1089-1092
 PRYEAR4                 1093-1096
 PRYEAR5                 1097-1100
 PRYEAR6                 1101-1104
 PRYEAR7                 1105-1108
 PRYEAR8                 1109-1112
 PRYEAR9                 1113-1116
 PRYEAR10                1117-1120
 PRYEAR11                1121-1124
 PRYEAR12                1125-1128
 PRYEAR13                1129-1132
 PRYEAR14                1133-1136
 PRYEAR15                1137-1140
 PRYEAR16                1141-1144
 PRYEAR17                1145-1148
 PRYEAR18                1149-1152
 PRYEAR19                1153-1156
 PRYEAR20                1157-1160
 PRYEAR21                1161-1164
 PRYEAR22                1165-1168
 PRYEAR23                1169-1172
 PRYEAR24                1173-1176
 PRYEAR25                1177-1180
 PRYEAR26                1181-1184
 PRYEAR27                1185-1188
 PRYEAR28                1189-1192
 PRYEAR29                1193-1196
 PRYEAR30                1197-1200.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPOA               (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 E_CCS10                 (F3.0) /
 E_CCS11                 (F3.0) /
 E_CCS12                 (F3.0) /
 E_CCS13                 (F3.0) /
 E_CCS14                 (F3.0) /
 E_CCS15                 (F3.0) /
 E_CCS16                 (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDC_NoPOA               (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCSTQ               (F3.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PRDAY24                 (F4.0) /
 PRDAY25                 (F4.0) /
 PRDAY26                 (F4.0) /
 PRDAY27                 (F4.0) /
 PRDAY28                 (F4.0) /
 PRDAY29                 (F4.0) /
 PRDAY30                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TRAN_IN                 (F3.0) /
 TRAN_OUT                (F3.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRMONTH16               (F3.0) /
 PRMONTH17               (F3.0) /
 PRMONTH18               (F3.0) /
 PRMONTH19               (F3.0) /
 PRMONTH20               (F3.0) /
 PRMONTH21               (F3.0) /
 PRMONTH22               (F3.0) /
 PRMONTH23               (F3.0) /
 PRMONTH24               (F3.0) /
 PRMONTH25               (F3.0) /
 PRMONTH26               (F3.0) /
 PRMONTH27               (F3.0) /
 PRMONTH28               (F3.0) /
 PRMONTH29               (F3.0) /
 PRMONTH30               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) /
 PRYEAR24                (F3.0) /
 PRYEAR25                (F3.0) /
 PRYEAR26                (F3.0) /
 PRYEAR27                (F3.0) /
 PRYEAR28                (F3.0) /
 PRYEAR29                (F3.0) /
 PRYEAR30                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMONTH                  "Admission month"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BWT                     "Birth weight in grams"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DRG_NoPOA               "DRG in use on discharge date, calculated without POA"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DX26                    "Diagnosis 26"
 DX27                    "Diagnosis 27"
 DX28                    "Diagnosis 28"
 DX29                    "Diagnosis 29"
 DX30                    "Diagnosis 30"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXCCS26                 "CCS: diagnosis 26"
 DXCCS27                 "CCS: diagnosis 27"
 DXCCS28                 "CCS: diagnosis 28"
 DXCCS29                 "CCS: diagnosis 29"
 DXCCS30                 "CCS: diagnosis 30"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 ECODE9                  "E code 9"
 ECODE10                 "E code 10"
 ECODE11                 "E code 11"
 ECODE12                 "E code 12"
 ECODE13                 "E code 13"
 ECODE14                 "E code 14"
 ECODE15                 "E code 15"
 ECODE16                 "E code 16"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 E_CCS9                  "CCS: E Code 9"
 E_CCS10                 "CCS: E Code 10"
 E_CCS11                 "CCS: E Code 11"
 E_CCS12                 "CCS: E Code 12"
 E_CCS13                 "CCS: E Code 13"
 E_CCS14                 "CCS: E Code 14"
 E_CCS15                 "CCS: E Code 15"
 E_CCS16                 "CCS: E Code 16"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 Homeless                "Indicator that patient is homeless"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MDC                     "MDC in effect on discharge date"
 MDC24                   "MDC, version 24"
 MDC_NoPOA               "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                "Physician 1 number (re-identified)"
 MDNUM2_R                "Physician 2 number (re-identified)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PR21                    "Procedure 21"
 PR22                    "Procedure 22"
 PR23                    "Procedure 23"
 PR24                    "Procedure 24"
 PR25                    "Procedure 25"
 PR26                    "Procedure 26"
 PR27                    "Procedure 27"
 PR28                    "Procedure 28"
 PR29                    "Procedure 29"
 PR30                    "Procedure 30"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRCCS21                 "CCS: procedure 21"
 PRCCS22                 "CCS: procedure 22"
 PRCCS23                 "CCS: procedure 23"
 PRCCS24                 "CCS: procedure 24"
 PRCCS25                 "CCS: procedure 25"
 PRCCS26                 "CCS: procedure 26"
 PRCCS27                 "CCS: procedure 27"
 PRCCS28                 "CCS: procedure 28"
 PRCCS29                 "CCS: procedure 29"
 PRCCS30                 "CCS: procedure 30"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PRDAY16                 "Number of days from admission to PR16"
 PRDAY17                 "Number of days from admission to PR17"
 PRDAY18                 "Number of days from admission to PR18"
 PRDAY19                 "Number of days from admission to PR19"
 PRDAY20                 "Number of days from admission to PR20"
 PRDAY21                 "Number of days from admission to PR21"
 PRDAY22                 "Number of days from admission to PR22"
 PRDAY23                 "Number of days from admission to PR23"
 PRDAY24                 "Number of days from admission to PR24"
 PRDAY25                 "Number of days from admission to PR25"
 PRDAY26                 "Number of days from admission to PR26"
 PRDAY27                 "Number of days from admission to PR27"
 PRDAY28                 "Number of days from admission to PR28"
 PRDAY29                 "Number of days from admission to PR29"
 PRDAY30                 "Number of days from admission to PR30"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TRAN_IN                 "Transfer in indicator"
 TRAN_OUT                "Transfer out indicator"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRMONTH16               "Month of procedure 16"
 PRMONTH17               "Month of procedure 17"
 PRMONTH18               "Month of procedure 18"
 PRMONTH19               "Month of procedure 19"
 PRMONTH20               "Month of procedure 20"
 PRMONTH21               "Month of procedure 21"
 PRMONTH22               "Month of procedure 22"
 PRMONTH23               "Month of procedure 23"
 PRMONTH24               "Month of procedure 24"
 PRMONTH25               "Month of procedure 25"
 PRMONTH26               "Month of procedure 26"
 PRMONTH27               "Month of procedure 27"
 PRMONTH28               "Month of procedure 28"
 PRMONTH29               "Month of procedure 29"
 PRMONTH30               "Month of procedure 30"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15"
 PRYEAR16                "Year of procedure 16"
 PRYEAR17                "Year of procedure 17"
 PRYEAR18                "Year of procedure 18"
 PRYEAR19                "Year of procedure 19"
 PRYEAR20                "Year of procedure 20"
 PRYEAR21                "Year of procedure 21"
 PRYEAR22                "Year of procedure 22"
 PRYEAR23                "Year of procedure 23"
 PRYEAR24                "Year of procedure 24"
 PRYEAR25                "Year of procedure 25"
 PRYEAR26                "Year of procedure 26"
 PRYEAR27                "Year of procedure 27"
 PRYEAR28                "Year of procedure 28"
 PRYEAR29                "Year of procedure 29"
 PRYEAR30                "Year of procedure 30" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'CO_SID_2012_CORE.SAV' /COMPRESSED.
