/*******************************************************************
* Creation Date: 07/25/2018   
*   CO_SID_2016_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'CO_SID_2016_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEMONTH                        4-   6
 AMONTH                          7-   8
 ATYPE                           9-  10
 AWEEKEND                       11-  12
 BWT                            13-  16
 DIED                           17-  18
 DISP_X                         19-  20 (A)
 DISPUB04                       21-  22
 DISPUNIFORM                    23-  24
 DMONTH                         25-  26
 DQTR                           27-  28
 DRG                            29-  31
 DRG_NoPOA                      32-  34
 DRGVER                         35-  36
 DSHOSPID                       37-  53 (A)
 DXVER                          54-  56
 FEMALE                         57-  58
 HCUP_ED                        59-  60
 HCUP_OS                        61-  62
 Homeless                       63-  64
 HOSPST                         65-  66 (A)
 I10_DX1                        67-  73 (A)
 I10_DX2                        74-  80 (A)
 I10_DX3                        81-  87 (A)
 I10_DX4                        88-  94 (A)
 I10_DX5                        95- 101 (A)
 I10_DX6                       102- 108 (A)
 I10_DX7                       109- 115 (A)
 I10_DX8                       116- 122 (A)
 I10_DX9                       123- 129 (A)
 I10_DX10                      130- 136 (A)
 I10_DX11                      137- 143 (A)
 I10_DX12                      144- 150 (A)
 I10_DX13                      151- 157 (A)
 I10_DX14                      158- 164 (A)
 I10_DX15                      165- 171 (A)
 I10_DX16                      172- 178 (A)
 I10_DX17                      179- 185 (A)
 I10_DX18                      186- 192 (A)
 I10_DX19                      193- 199 (A)
 I10_DX20                      200- 206 (A)
 I10_DX21                      207- 213 (A)
 I10_DX22                      214- 220 (A)
 I10_DX23                      221- 227 (A)
 I10_DX24                      228- 234 (A)
 I10_DX25                      235- 241 (A)
 I10_DX26                      242- 248 (A)
 I10_DX27                      249- 255 (A)
 I10_DX28                      256- 262 (A)
 I10_DX29                      263- 269 (A)
 I10_DX30                      270- 276 (A)
 I10_DX31                      277- 283 (A)
 I10_DX32                      284- 290 (A)
 I10_DX33                      291- 297 (A)
 I10_ECAUSE1                   298- 304 (A)
 I10_ECAUSE2                   305- 311 (A)
 I10_ECAUSE3                   312- 318 (A)
 I10_ECAUSE4                   319- 325 (A)
 I10_ECAUSE5                   326- 332 (A)
 I10_ECAUSE6                   333- 339 (A)
 I10_ECAUSE7                   340- 346 (A)
 I10_ECAUSE8                   347- 353 (A)
 I10_ECAUSE9                   354- 360 (A)
 I10_ECAUSE10                  361- 367 (A)
 I10_ECAUSE11                  368- 374 (A)
 I10_ECAUSE12                  375- 381 (A)
 I10_ECAUSE13                  382- 388 (A)
 I10_ECAUSE14                  389- 395 (A)
 I10_NDX                       396- 398
 I10_NECAUSE                   399- 400
 I10_NPR                       401- 403
 I10_PR1                       404- 410 (A)
 I10_PR2                       411- 417 (A)
 I10_PR3                       418- 424 (A)
 I10_PR4                       425- 431 (A)
 I10_PR5                       432- 438 (A)
 I10_PR6                       439- 445 (A)
 I10_PR7                       446- 452 (A)
 I10_PR8                       453- 459 (A)
 I10_PR9                       460- 466 (A)
 I10_PR10                      467- 473 (A)
 I10_PR11                      474- 480 (A)
 I10_PR12                      481- 487 (A)
 I10_PR13                      488- 494 (A)
 I10_PR14                      495- 501 (A)
 I10_PR15                      502- 508 (A)
 I10_PR16                      509- 515 (A)
 I10_PR17                      516- 522 (A)
 I10_PR18                      523- 529 (A)
 I10_PR19                      530- 536 (A)
 I10_PR20                      537- 543 (A)
 I10_PR21                      544- 550 (A)
 I10_PR22                      551- 557 (A)
 I10_PR23                      558- 564 (A)
 I10_PR24                      565- 571 (A)
 I10_PR25                      572- 578 (A)
 I10_PR26                      579- 585 (A)
 I10_PR27                      586- 592 (A)
 I10_PR28                      593- 599 (A)
 I10_PR29                      600- 606 (A)
 I10_PR30                      607- 613 (A)
 I10_PROCTYPE                  614- 616
 KEY                           617- 631
 LOS                           632- 636
 LOS_X                         637- 642
 MDC                           643- 644
 MDC_NoPOA                     645- 646
 MDNUM1_R                      647- 655
 MDNUM2_R                      656- 664
 MEDINCSTQ                     665- 666
 P7EDSRC_X                     667- 668 (A)
 PAY1                          669- 670
 PAY1_X                        671- 672 (A)
 PL_CBSA                       673- 675
 PL_NCHS                       676- 677
 PL_RUCC                       678- 679
 PL_UIC                        680- 681
 PL_UR_CAT4                    682- 683
 PointOfOrigin_X               684     (A)
 PointOfOriginUB04             685     (A)
 PRDAY1                        686- 690
 PRDAY2                        691- 695
 PRDAY3                        696- 700
 PRDAY4                        701- 705
 PRDAY5                        706- 710
 PRDAY6                        711- 715
 PRDAY7                        716- 720
 PRDAY8                        721- 725
 PRDAY9                        726- 730
 PRDAY10                       731- 735
 PRDAY11                       736- 740
 PRDAY12                       741- 745
 PRDAY13                       746- 750
 PRDAY14                       751- 755
 PRDAY15                       756- 760
 PRDAY16                       761- 765
 PRDAY17                       766- 770
 PRDAY18                       771- 775
 PRDAY19                       776- 780
 PRDAY20                       781- 785
 PRDAY21                       786- 790
 PRDAY22                       791- 795
 PRDAY23                       796- 800
 PRDAY24                       801- 805
 PRDAY25                       806- 810
 PRDAY26                       811- 815
 PRDAY27                       816- 820
 PRDAY28                       821- 825
 PRDAY29                       826- 830
 PRDAY30                       831- 835
 PRVER                         836- 838
 PSTATE                        839- 840 (A)
 PSTCO                         841- 845
 PSTCO2                        846- 850
 RACE                          851- 852
 RACE_X                        853     (A)
 TOTCHG                        854- 863
 TOTCHG_X                      864- 878
 TRAN_IN                       879- 880
 TRAN_OUT                      881- 882
 YEAR                          883- 886
 ZIP                           887- 891 (A)
 ZIP3                          892- 894 (A)
 ZIPINC_QRTL                   895- 897
 AYEAR                         898- 901
 BMONTH                        902- 903
 BYEAR                         904- 907
 PRMONTH1                      908- 909
 PRMONTH2                      910- 911
 PRMONTH3                      912- 913
 PRMONTH4                      914- 915
 PRMONTH5                      916- 917
 PRMONTH6                      918- 919
 PRMONTH7                      920- 921
 PRMONTH8                      922- 923
 PRMONTH9                      924- 925
 PRMONTH10                     926- 927
 PRMONTH11                     928- 929
 PRMONTH12                     930- 931
 PRMONTH13                     932- 933
 PRMONTH14                     934- 935
 PRMONTH15                     936- 937
 PRMONTH16                     938- 939
 PRMONTH17                     940- 941
 PRMONTH18                     942- 943
 PRMONTH19                     944- 945
 PRMONTH20                     946- 947
 PRMONTH21                     948- 949
 PRMONTH22                     950- 951
 PRMONTH23                     952- 953
 PRMONTH24                     954- 955
 PRMONTH25                     956- 957
 PRMONTH26                     958- 959
 PRMONTH27                     960- 961
 PRMONTH28                     962- 963
 PRMONTH29                     964- 965
 PRMONTH30                     966- 967
 PRYEAR1                       968- 971
 PRYEAR2                       972- 975
 PRYEAR3                       976- 979
 PRYEAR4                       980- 983
 PRYEAR5                       984- 987
 PRYEAR6                       988- 991
 PRYEAR7                       992- 995
 PRYEAR8                       996- 999
 PRYEAR9                      1000-1003
 PRYEAR10                     1004-1007
 PRYEAR11                     1008-1011
 PRYEAR12                     1012-1015
 PRYEAR13                     1016-1019
 PRYEAR14                     1020-1023
 PRYEAR15                     1024-1027
 PRYEAR16                     1028-1031
 PRYEAR17                     1032-1035
 PRYEAR18                     1036-1039
 PRYEAR19                     1040-1043
 PRYEAR20                     1044-1047
 PRYEAR21                     1048-1051
 PRYEAR22                     1052-1055
 PRYEAR23                     1056-1059
 PRYEAR24                     1060-1063
 PRYEAR25                     1064-1067
 PRYEAR26                     1068-1071
 PRYEAR27                     1072-1075
 PRYEAR28                     1076-1079
 PRYEAR29                     1080-1083
 PRYEAR30                     1084-1087.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 Homeless                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 PAY1                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXVER                        "Diagnosis Version"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 Homeless                     "Indicator that patient is homeless"
 HOSPST                       "Hospital state postal code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_ECAUSE1                  "ICD-10-CM External cause 1"
 I10_ECAUSE2                  "ICD-10-CM External cause 2"
 I10_ECAUSE3                  "ICD-10-CM External cause 3"
 I10_ECAUSE4                  "ICD-10-CM External cause 4"
 I10_ECAUSE5                  "ICD-10-CM External cause 5"
 I10_ECAUSE6                  "ICD-10-CM External cause 6"
 I10_ECAUSE7                  "ICD-10-CM External cause 7"
 I10_ECAUSE8                  "ICD-10-CM External cause 8"
 I10_ECAUSE9                  "ICD-10-CM External cause 9"
 I10_ECAUSE10                 "ICD-10-CM External cause 10"
 I10_ECAUSE11                 "ICD-10-CM External cause 11"
 I10_ECAUSE12                 "ICD-10-CM External cause 12"
 I10_ECAUSE13                 "ICD-10-CM External cause 13"
 I10_ECAUSE14                 "ICD-10-CM External cause 14"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of External cause codes on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'CO_SID_2016_CORE.SAV' /COMPRESSED.
