/*******************************************************************
* Creation Date: 11/29/2017   
*   DC_SID_2015q4_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'DC_SID_2015q4_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BILLTYPE                       20-  23 (A)
 BWT                            24-  27
 DHOUR                          28-  31
 DIED                           32-  33
 DISP_X                         34-  35 (A)
 DISPUB04                       36-  37
 DISPUNIFORM                    38-  39
 DMONTH                         40-  41
 DQTR                           42-  43
 DRG                            44-  46
 DRG_NoPOA                      47-  49
 DRG32                          50-  52
 DRGVER                         53-  54
 DXPOA1                         55     (A)
 DXPOA2                         56     (A)
 DXPOA3                         57     (A)
 DXPOA4                         58     (A)
 DXPOA5                         59     (A)
 DXPOA6                         60     (A)
 DXPOA7                         61     (A)
 DXPOA8                         62     (A)
 DXPOA9                         63     (A)
 DXPOA10                        64     (A)
 DXPOA11                        65     (A)
 DXPOA12                        66     (A)
 DXPOA13                        67     (A)
 DXPOA14                        68     (A)
 DXPOA15                        69     (A)
 DXPOA16                        70     (A)
 DXPOA17                        71     (A)
 DXPOA18                        72     (A)
 DXPOA19                        73     (A)
 DXPOA20                        74     (A)
 DXPOA21                        75     (A)
 DXPOA22                        76     (A)
 DXPOA23                        77     (A)
 DXPOA24                        78     (A)
 DXPOA25                        79     (A)
 DXPOA26                        80     (A)
 DXPOA27                        81     (A)
 DXPOA28                        82     (A)
 DXPOA29                        83     (A)
 DXPOA30                        84     (A)
 DXPOA31                        85     (A)
 DXPOA32                        86     (A)
 DXPOA33                        87     (A)
 DXPOA34                        88     (A)
 DXPOA35                        89     (A)
 DXPOA36                        90     (A)
 DXPOA37                        91     (A)
 DXPOA38                        92     (A)
 DXPOA39                        93     (A)
 DXPOA40                        94     (A)
 DXPOA41                        95     (A)
 DXPOA42                        96     (A)
 DXPOA43                        97     (A)
 DXPOA44                        98     (A)
 DXPOA45                        99     (A)
 DXPOA46                       100     (A)
 DXPOA47                       101     (A)
 DXPOA48                       102     (A)
 DXPOA49                       103     (A)
 DXPOA50                       104     (A)
 DXVER                         105- 107
 E_POA1                        108     (A)
 E_POA2                        109     (A)
 E_POA3                        110     (A)
 E_POA4                        111     (A)
 E_POA5                        112     (A)
 E_POA6                        113     (A)
 E_POA7                        114     (A)
 FEMALE                        115- 116
 HCUP_ED                       117- 118
 HCUP_OS                       119- 120
 HOSPST                        121- 122 (A)
 I10_DX_Admitting              123- 129 (A)
 I10_DX1                       130- 136 (A)
 I10_DX2                       137- 143 (A)
 I10_DX3                       144- 150 (A)
 I10_DX4                       151- 157 (A)
 I10_DX5                       158- 164 (A)
 I10_DX6                       165- 171 (A)
 I10_DX7                       172- 178 (A)
 I10_DX8                       179- 185 (A)
 I10_DX9                       186- 192 (A)
 I10_DX10                      193- 199 (A)
 I10_DX11                      200- 206 (A)
 I10_DX12                      207- 213 (A)
 I10_DX13                      214- 220 (A)
 I10_DX14                      221- 227 (A)
 I10_DX15                      228- 234 (A)
 I10_DX16                      235- 241 (A)
 I10_DX17                      242- 248 (A)
 I10_DX18                      249- 255 (A)
 I10_DX19                      256- 262 (A)
 I10_DX20                      263- 269 (A)
 I10_DX21                      270- 276 (A)
 I10_DX22                      277- 283 (A)
 I10_DX23                      284- 290 (A)
 I10_DX24                      291- 297 (A)
 I10_DX25                      298- 304 (A)
 I10_DX26                      305- 311 (A)
 I10_DX27                      312- 318 (A)
 I10_DX28                      319- 325 (A)
 I10_DX29                      326- 332 (A)
 I10_DX30                      333- 339 (A)
 I10_DX31                      340- 346 (A)
 I10_DX32                      347- 353 (A)
 I10_DX33                      354- 360 (A)
 I10_DX34                      361- 367 (A)
 I10_DX35                      368- 374 (A)
 I10_DX36                      375- 381 (A)
 I10_DX37                      382- 388 (A)
 I10_DX38                      389- 395 (A)
 I10_DX39                      396- 402 (A)
 I10_DX40                      403- 409 (A)
 I10_DX41                      410- 416 (A)
 I10_DX42                      417- 423 (A)
 I10_DX43                      424- 430 (A)
 I10_DX44                      431- 437 (A)
 I10_DX45                      438- 444 (A)
 I10_DX46                      445- 451 (A)
 I10_DX47                      452- 458 (A)
 I10_DX48                      459- 465 (A)
 I10_DX49                      466- 472 (A)
 I10_DX50                      473- 479 (A)
 I10_DXCCS1                    480- 483
 I10_DXCCS2                    484- 487
 I10_DXCCS3                    488- 491
 I10_DXCCS4                    492- 495
 I10_DXCCS5                    496- 499
 I10_DXCCS6                    500- 503
 I10_DXCCS7                    504- 507
 I10_DXCCS8                    508- 511
 I10_DXCCS9                    512- 515
 I10_DXCCS10                   516- 519
 I10_DXCCS11                   520- 523
 I10_DXCCS12                   524- 527
 I10_DXCCS13                   528- 531
 I10_DXCCS14                   532- 535
 I10_DXCCS15                   536- 539
 I10_DXCCS16                   540- 543
 I10_DXCCS17                   544- 547
 I10_DXCCS18                   548- 551
 I10_DXCCS19                   552- 555
 I10_DXCCS20                   556- 559
 I10_DXCCS21                   560- 563
 I10_DXCCS22                   564- 567
 I10_DXCCS23                   568- 571
 I10_DXCCS24                   572- 575
 I10_DXCCS25                   576- 579
 I10_DXCCS26                   580- 583
 I10_DXCCS27                   584- 587
 I10_DXCCS28                   588- 591
 I10_DXCCS29                   592- 595
 I10_DXCCS30                   596- 599
 I10_DXCCS31                   600- 603
 I10_DXCCS32                   604- 607
 I10_DXCCS33                   608- 611
 I10_DXCCS34                   612- 615
 I10_DXCCS35                   616- 619
 I10_DXCCS36                   620- 623
 I10_DXCCS37                   624- 627
 I10_DXCCS38                   628- 631
 I10_DXCCS39                   632- 635
 I10_DXCCS40                   636- 639
 I10_DXCCS41                   640- 643
 I10_DXCCS42                   644- 647
 I10_DXCCS43                   648- 651
 I10_DXCCS44                   652- 655
 I10_DXCCS45                   656- 659
 I10_DXCCS46                   660- 663
 I10_DXCCS47                   664- 667
 I10_DXCCS48                   668- 671
 I10_DXCCS49                   672- 675
 I10_DXCCS50                   676- 679
 I10_ECAUSE1                   680- 686 (A)
 I10_ECAUSE2                   687- 693 (A)
 I10_ECAUSE3                   694- 700 (A)
 I10_ECAUSE4                   701- 707 (A)
 I10_ECAUSE5                   708- 714 (A)
 I10_ECAUSE6                   715- 721 (A)
 I10_ECAUSE7                   722- 728 (A)
 I10_ECauseCCS1                729- 732
 I10_ECauseCCS2                733- 736
 I10_ECauseCCS3                737- 740
 I10_ECauseCCS4                741- 744
 I10_ECauseCCS5                745- 748
 I10_ECauseCCS6                749- 752
 I10_ECauseCCS7                753- 756
 I10_HOSPBRTH                  757- 759
 I10_NCHRONIC                  760- 762
 I10_NDX                       763- 765
 I10_NECAUSE                   766- 767
 I10_NEOMAT                    768- 769
 I10_NPR                       770- 772
 I10_ORPROC                    773- 774
 I10_PR1                       775- 781 (A)
 I10_PR2                       782- 788 (A)
 I10_PR3                       789- 795 (A)
 I10_PR4                       796- 802 (A)
 I10_PR5                       803- 809 (A)
 I10_PR6                       810- 816 (A)
 I10_PR7                       817- 823 (A)
 I10_PR8                       824- 830 (A)
 I10_PR9                       831- 837 (A)
 I10_PR10                      838- 844 (A)
 I10_PR11                      845- 851 (A)
 I10_PR12                      852- 858 (A)
 I10_PR13                      859- 865 (A)
 I10_PR14                      866- 872 (A)
 I10_PR15                      873- 879 (A)
 I10_PR16                      880- 886 (A)
 I10_PR17                      887- 893 (A)
 I10_PR18                      894- 900 (A)
 I10_PR19                      901- 907 (A)
 I10_PR20                      908- 914 (A)
 I10_PR21                      915- 921 (A)
 I10_PR22                      922- 928 (A)
 I10_PR23                      929- 935 (A)
 I10_PR24                      936- 942 (A)
 I10_PR25                      943- 949 (A)
 I10_PR26                      950- 956 (A)
 I10_PR27                      957- 963 (A)
 I10_PR28                      964- 970 (A)
 I10_PR29                      971- 977 (A)
 I10_PR30                      978- 984 (A)
 I10_PR31                      985- 991 (A)
 I10_PR32                      992- 998 (A)
 I10_PR33                      999-1005 (A)
 I10_PR34                     1006-1012 (A)
 I10_PR35                     1013-1019 (A)
 I10_PR36                     1020-1026 (A)
 I10_PR37                     1027-1033 (A)
 I10_PR38                     1034-1040 (A)
 I10_PR39                     1041-1047 (A)
 I10_PR40                     1048-1054 (A)
 I10_PR41                     1055-1061 (A)
 I10_PR42                     1062-1068 (A)
 I10_PR43                     1069-1075 (A)
 I10_PR44                     1076-1082 (A)
 I10_PR45                     1083-1089 (A)
 I10_PR46                     1090-1096 (A)
 I10_PR47                     1097-1103 (A)
 I10_PR48                     1104-1110 (A)
 I10_PR49                     1111-1117 (A)
 I10_PR50                     1118-1124 (A)
 I10_PRCCS1                   1125-1127
 I10_PRCCS2                   1128-1130
 I10_PRCCS3                   1131-1133
 I10_PRCCS4                   1134-1136
 I10_PRCCS5                   1137-1139
 I10_PRCCS6                   1140-1142
 I10_PRCCS7                   1143-1145
 I10_PRCCS8                   1146-1148
 I10_PRCCS9                   1149-1151
 I10_PRCCS10                  1152-1154
 I10_PRCCS11                  1155-1157
 I10_PRCCS12                  1158-1160
 I10_PRCCS13                  1161-1163
 I10_PRCCS14                  1164-1166
 I10_PRCCS15                  1167-1169
 I10_PRCCS16                  1170-1172
 I10_PRCCS17                  1173-1175
 I10_PRCCS18                  1176-1178
 I10_PRCCS19                  1179-1181
 I10_PRCCS20                  1182-1184
 I10_PRCCS21                  1185-1187
 I10_PRCCS22                  1188-1190
 I10_PRCCS23                  1191-1193
 I10_PRCCS24                  1194-1196
 I10_PRCCS25                  1197-1199
 I10_PRCCS26                  1200-1202
 I10_PRCCS27                  1203-1205
 I10_PRCCS28                  1206-1208
 I10_PRCCS29                  1209-1211
 I10_PRCCS30                  1212-1214
 I10_PRCCS31                  1215-1217
 I10_PRCCS32                  1218-1220
 I10_PRCCS33                  1221-1223
 I10_PRCCS34                  1224-1226
 I10_PRCCS35                  1227-1229
 I10_PRCCS36                  1230-1232
 I10_PRCCS37                  1233-1235
 I10_PRCCS38                  1236-1238
 I10_PRCCS39                  1239-1241
 I10_PRCCS40                  1242-1244
 I10_PRCCS41                  1245-1247
 I10_PRCCS42                  1248-1250
 I10_PRCCS43                  1251-1253
 I10_PRCCS44                  1254-1256
 I10_PRCCS45                  1257-1259
 I10_PRCCS46                  1260-1262
 I10_PRCCS47                  1263-1265
 I10_PRCCS48                  1266-1268
 I10_PRCCS49                  1269-1271
 I10_PRCCS50                  1272-1274
 I10_PROCTYPE                 1275-1277
 I10_SERVICELINE              1278-1279
 KEY                          1280-1294
 LOS                          1295-1299
 LOS_X                        1300-1305
 MDC                          1306-1307
 MDC_NoPOA                    1308-1309
 MDC32                        1310-1311
 MDNUM1_R                     1312-1320
 MDNUM2_R                     1321-1329
 MDNUM3_R                     1330-1338
 MDNUM4_R                     1339-1347
 MEDINCSTQ                    1348-1349
 PAY1                         1350-1351
 PAY1_X                       1352-1359 (A)
 PAY2                         1360-1361
 PAY2_X                       1362-1369 (A)
 PAY3                         1370-1371
 PAY3_X                       1372-1379 (A)
 PL_CBSA                      1380-1382
 PL_NCHS                      1383-1384
 PL_RUCC                      1385-1386
 PL_UIC                       1387-1388
 PL_UR_CAT4                   1389-1390
 POA_Disch_Edit1              1391-1392
 POA_Disch_Edit2              1393-1394
 POA_Hosp_Edit1               1395-1396
 POA_Hosp_Edit2               1397-1398
 POA_Hosp_Edit3               1399-1400
 POA_Hosp_Edit3_Value         1401-1408
 PointOfOrigin_X              1409-1411 (A)
 PointOfOriginUB04            1412     (A)
 PRDAY1                       1413-1417
 PRDAY2                       1418-1422
 PRDAY3                       1423-1427
 PRDAY4                       1428-1432
 PRDAY5                       1433-1437
 PRDAY6                       1438-1442
 PRDAY7                       1443-1447
 PRDAY8                       1448-1452
 PRDAY9                       1453-1457
 PRDAY10                      1458-1462
 PRDAY11                      1463-1467
 PRDAY12                      1468-1472
 PRDAY13                      1473-1477
 PRDAY14                      1478-1482
 PRDAY15                      1483-1487
 PRDAY16                      1488-1492
 PRDAY17                      1493-1497
 PRDAY18                      1498-1502
 PRDAY19                      1503-1507
 PRDAY20                      1508-1512
 PRDAY21                      1513-1517
 PRDAY22                      1518-1522
 PRDAY23                      1523-1527
 PRDAY24                      1528-1532
 PRDAY25                      1533-1537
 PRDAY26                      1538-1542
 PRDAY27                      1543-1547
 PRDAY28                      1548-1552
 PRDAY29                      1553-1557
 PRDAY30                      1558-1562
 PRDAY31                      1563-1567
 PRDAY32                      1568-1572
 PRDAY33                      1573-1577
 PRDAY34                      1578-1582
 PRDAY35                      1583-1587
 PRDAY36                      1588-1592
 PRDAY37                      1593-1597
 PRDAY38                      1598-1602
 PRDAY39                      1603-1607
 PRDAY40                      1608-1612
 PRDAY41                      1613-1617
 PRDAY42                      1618-1622
 PRDAY43                      1623-1627
 PRDAY44                      1628-1632
 PRDAY45                      1633-1637
 PRDAY46                      1638-1642
 PRDAY47                      1643-1647
 PRDAY48                      1648-1652
 PRDAY49                      1653-1657
 PRDAY50                      1658-1662
 PRVER                        1663-1665
 PSTATE                       1666-1667 (A)
 PSTCO                        1668-1672
 PSTCO2                       1673-1677
 RACE                         1678-1679
 RACE_X                       1680-1682 (A)
 TOTCHG                       1683-1692
 TOTCHG_X                     1693-1707
 TRAN_IN                      1708-1709
 TRAN_OUT                     1710-1711
 YEAR                         1712-1715
 ZIP                          1716-1720 (A)
 ZIP3                         1721-1723 (A)
 ZIPINC_QRTL                  1724-1726
 HOSPID                       1727-1731
 AYEAR                        1732-1735
 BMONTH                       1736-1737
 BYEAR                        1738-1741.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRG32                        (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 I10_DXCCS1                   (F4.0) /
 I10_DXCCS2                   (F4.0) /
 I10_DXCCS3                   (F4.0) /
 I10_DXCCS4                   (F4.0) /
 I10_DXCCS5                   (F4.0) /
 I10_DXCCS6                   (F4.0) /
 I10_DXCCS7                   (F4.0) /
 I10_DXCCS8                   (F4.0) /
 I10_DXCCS9                   (F4.0) /
 I10_DXCCS10                  (F4.0) /
 I10_DXCCS11                  (F4.0) /
 I10_DXCCS12                  (F4.0) /
 I10_DXCCS13                  (F4.0) /
 I10_DXCCS14                  (F4.0) /
 I10_DXCCS15                  (F4.0) /
 I10_DXCCS16                  (F4.0) /
 I10_DXCCS17                  (F4.0) /
 I10_DXCCS18                  (F4.0) /
 I10_DXCCS19                  (F4.0) /
 I10_DXCCS20                  (F4.0) /
 I10_DXCCS21                  (F4.0) /
 I10_DXCCS22                  (F4.0) /
 I10_DXCCS23                  (F4.0) /
 I10_DXCCS24                  (F4.0) /
 I10_DXCCS25                  (F4.0) /
 I10_DXCCS26                  (F4.0) /
 I10_DXCCS27                  (F4.0) /
 I10_DXCCS28                  (F4.0) /
 I10_DXCCS29                  (F4.0) /
 I10_DXCCS30                  (F4.0) /
 I10_DXCCS31                  (F4.0) /
 I10_DXCCS32                  (F4.0) /
 I10_DXCCS33                  (F4.0) /
 I10_DXCCS34                  (F4.0) /
 I10_DXCCS35                  (F4.0) /
 I10_DXCCS36                  (F4.0) /
 I10_DXCCS37                  (F4.0) /
 I10_DXCCS38                  (F4.0) /
 I10_DXCCS39                  (F4.0) /
 I10_DXCCS40                  (F4.0) /
 I10_DXCCS41                  (F4.0) /
 I10_DXCCS42                  (F4.0) /
 I10_DXCCS43                  (F4.0) /
 I10_DXCCS44                  (F4.0) /
 I10_DXCCS45                  (F4.0) /
 I10_DXCCS46                  (F4.0) /
 I10_DXCCS47                  (F4.0) /
 I10_DXCCS48                  (F4.0) /
 I10_DXCCS49                  (F4.0) /
 I10_DXCCS50                  (F4.0) /
 I10_ECauseCCS1               (F3.0) /
 I10_ECauseCCS2               (F3.0) /
 I10_ECauseCCS3               (F3.0) /
 I10_ECauseCCS4               (F3.0) /
 I10_ECauseCCS5               (F3.0) /
 I10_ECauseCCS6               (F3.0) /
 I10_ECauseCCS7               (F3.0) /
 I10_HOSPBRTH                 (F3.0) /
 I10_NCHRONIC                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NEOMAT                   (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PRCCS1                   (F3.0) /
 I10_PRCCS2                   (F3.0) /
 I10_PRCCS3                   (F3.0) /
 I10_PRCCS4                   (F3.0) /
 I10_PRCCS5                   (F3.0) /
 I10_PRCCS6                   (F3.0) /
 I10_PRCCS7                   (F3.0) /
 I10_PRCCS8                   (F3.0) /
 I10_PRCCS9                   (F3.0) /
 I10_PRCCS10                  (F3.0) /
 I10_PRCCS11                  (F3.0) /
 I10_PRCCS12                  (F3.0) /
 I10_PRCCS13                  (F3.0) /
 I10_PRCCS14                  (F3.0) /
 I10_PRCCS15                  (F3.0) /
 I10_PRCCS16                  (F3.0) /
 I10_PRCCS17                  (F3.0) /
 I10_PRCCS18                  (F3.0) /
 I10_PRCCS19                  (F3.0) /
 I10_PRCCS20                  (F3.0) /
 I10_PRCCS21                  (F3.0) /
 I10_PRCCS22                  (F3.0) /
 I10_PRCCS23                  (F3.0) /
 I10_PRCCS24                  (F3.0) /
 I10_PRCCS25                  (F3.0) /
 I10_PRCCS26                  (F3.0) /
 I10_PRCCS27                  (F3.0) /
 I10_PRCCS28                  (F3.0) /
 I10_PRCCS29                  (F3.0) /
 I10_PRCCS30                  (F3.0) /
 I10_PRCCS31                  (F3.0) /
 I10_PRCCS32                  (F3.0) /
 I10_PRCCS33                  (F3.0) /
 I10_PRCCS34                  (F3.0) /
 I10_PRCCS35                  (F3.0) /
 I10_PRCCS36                  (F3.0) /
 I10_PRCCS37                  (F3.0) /
 I10_PRCCS38                  (F3.0) /
 I10_PRCCS39                  (F3.0) /
 I10_PRCCS40                  (F3.0) /
 I10_PRCCS41                  (F3.0) /
 I10_PRCCS42                  (F3.0) /
 I10_PRCCS43                  (F3.0) /
 I10_PRCCS44                  (F3.0) /
 I10_PRCCS45                  (F3.0) /
 I10_PRCCS46                  (F3.0) /
 I10_PRCCS47                  (F3.0) /
 I10_PRCCS48                  (F3.0) /
 I10_PRCCS49                  (F3.0) /
 I10_PRCCS50                  (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDC32                        (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 BWT                          "Birth weight in grams"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRG32                        "DRG, version 32"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "E Cause 1, present on admission indicator"
 E_POA2                       "E Cause 2, present on admission indicator"
 E_POA3                       "E Cause 3, present on admission indicator"
 E_POA4                       "E Cause 4, present on admission indicator"
 E_POA5                       "E Cause 5, present on admission indicator"
 E_POA6                       "E Cause 6, present on admission indicator"
 E_POA7                       "E Cause 7, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DXCCS1                   "ICD-10-CM CCS: diagnosis 1"
 I10_DXCCS2                   "ICD-10-CM CCS: diagnosis 2"
 I10_DXCCS3                   "ICD-10-CM CCS: diagnosis 3"
 I10_DXCCS4                   "ICD-10-CM CCS: diagnosis 4"
 I10_DXCCS5                   "ICD-10-CM CCS: diagnosis 5"
 I10_DXCCS6                   "ICD-10-CM CCS: diagnosis 6"
 I10_DXCCS7                   "ICD-10-CM CCS: diagnosis 7"
 I10_DXCCS8                   "ICD-10-CM CCS: diagnosis 8"
 I10_DXCCS9                   "ICD-10-CM CCS: diagnosis 9"
 I10_DXCCS10                  "ICD-10-CM CCS: diagnosis 10"
 I10_DXCCS11                  "ICD-10-CM CCS: diagnosis 11"
 I10_DXCCS12                  "ICD-10-CM CCS: diagnosis 12"
 I10_DXCCS13                  "ICD-10-CM CCS: diagnosis 13"
 I10_DXCCS14                  "ICD-10-CM CCS: diagnosis 14"
 I10_DXCCS15                  "ICD-10-CM CCS: diagnosis 15"
 I10_DXCCS16                  "ICD-10-CM CCS: diagnosis 16"
 I10_DXCCS17                  "ICD-10-CM CCS: diagnosis 17"
 I10_DXCCS18                  "ICD-10-CM CCS: diagnosis 18"
 I10_DXCCS19                  "ICD-10-CM CCS: diagnosis 19"
 I10_DXCCS20                  "ICD-10-CM CCS: diagnosis 20"
 I10_DXCCS21                  "ICD-10-CM CCS: diagnosis 21"
 I10_DXCCS22                  "ICD-10-CM CCS: diagnosis 22"
 I10_DXCCS23                  "ICD-10-CM CCS: diagnosis 23"
 I10_DXCCS24                  "ICD-10-CM CCS: diagnosis 24"
 I10_DXCCS25                  "ICD-10-CM CCS: diagnosis 25"
 I10_DXCCS26                  "ICD-10-CM CCS: diagnosis 26"
 I10_DXCCS27                  "ICD-10-CM CCS: diagnosis 27"
 I10_DXCCS28                  "ICD-10-CM CCS: diagnosis 28"
 I10_DXCCS29                  "ICD-10-CM CCS: diagnosis 29"
 I10_DXCCS30                  "ICD-10-CM CCS: diagnosis 30"
 I10_DXCCS31                  "ICD-10-CM CCS: diagnosis 31"
 I10_DXCCS32                  "ICD-10-CM CCS: diagnosis 32"
 I10_DXCCS33                  "ICD-10-CM CCS: diagnosis 33"
 I10_DXCCS34                  "ICD-10-CM CCS: diagnosis 34"
 I10_DXCCS35                  "ICD-10-CM CCS: diagnosis 35"
 I10_DXCCS36                  "ICD-10-CM CCS: diagnosis 36"
 I10_DXCCS37                  "ICD-10-CM CCS: diagnosis 37"
 I10_DXCCS38                  "ICD-10-CM CCS: diagnosis 38"
 I10_DXCCS39                  "ICD-10-CM CCS: diagnosis 39"
 I10_DXCCS40                  "ICD-10-CM CCS: diagnosis 40"
 I10_DXCCS41                  "ICD-10-CM CCS: diagnosis 41"
 I10_DXCCS42                  "ICD-10-CM CCS: diagnosis 42"
 I10_DXCCS43                  "ICD-10-CM CCS: diagnosis 43"
 I10_DXCCS44                  "ICD-10-CM CCS: diagnosis 44"
 I10_DXCCS45                  "ICD-10-CM CCS: diagnosis 45"
 I10_DXCCS46                  "ICD-10-CM CCS: diagnosis 46"
 I10_DXCCS47                  "ICD-10-CM CCS: diagnosis 47"
 I10_DXCCS48                  "ICD-10-CM CCS: diagnosis 48"
 I10_DXCCS49                  "ICD-10-CM CCS: diagnosis 49"
 I10_DXCCS50                  "ICD-10-CM CCS: diagnosis 50"
 I10_ECAUSE1                  "ICD-10-CM E Cause 1"
 I10_ECAUSE2                  "ICD-10-CM E Cause 2"
 I10_ECAUSE3                  "ICD-10-CM E Cause 3"
 I10_ECAUSE4                  "ICD-10-CM E Cause 4"
 I10_ECAUSE5                  "ICD-10-CM E Cause 5"
 I10_ECAUSE6                  "ICD-10-CM E Cause 6"
 I10_ECAUSE7                  "ICD-10-CM E Cause 7"
 I10_ECauseCCS1               "ICD-10-CM CCS: E Cause 1"
 I10_ECauseCCS2               "ICD-10-CM CCS: E Cause 2"
 I10_ECauseCCS3               "ICD-10-CM CCS: E Cause 3"
 I10_ECauseCCS4               "ICD-10-CM CCS: E Cause 4"
 I10_ECauseCCS5               "ICD-10-CM CCS: E Cause 5"
 I10_ECauseCCS6               "ICD-10-CM CCS: E Cause 6"
 I10_ECauseCCS7               "ICD-10-CM CCS: E Cause 7"
 I10_HOSPBRTH                 "ICD-10-CM Indicator of birth in this hospital"
 I10_NCHRONIC                 "ICD-10-CM Number of chronic conditions"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of E Causes on this record"
 I10_NEOMAT                   "ICD-10-CM/PCS Neonatal and/or maternal I10_DX and/or I10_PR"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PRCCS1                   "ICD-10-PCS CCS: procedure 1"
 I10_PRCCS2                   "ICD-10-PCS CCS: procedure 2"
 I10_PRCCS3                   "ICD-10-PCS CCS: procedure 3"
 I10_PRCCS4                   "ICD-10-PCS CCS: procedure 4"
 I10_PRCCS5                   "ICD-10-PCS CCS: procedure 5"
 I10_PRCCS6                   "ICD-10-PCS CCS: procedure 6"
 I10_PRCCS7                   "ICD-10-PCS CCS: procedure 7"
 I10_PRCCS8                   "ICD-10-PCS CCS: procedure 8"
 I10_PRCCS9                   "ICD-10-PCS CCS: procedure 9"
 I10_PRCCS10                  "ICD-10-PCS CCS: procedure 10"
 I10_PRCCS11                  "ICD-10-PCS CCS: procedure 11"
 I10_PRCCS12                  "ICD-10-PCS CCS: procedure 12"
 I10_PRCCS13                  "ICD-10-PCS CCS: procedure 13"
 I10_PRCCS14                  "ICD-10-PCS CCS: procedure 14"
 I10_PRCCS15                  "ICD-10-PCS CCS: procedure 15"
 I10_PRCCS16                  "ICD-10-PCS CCS: procedure 16"
 I10_PRCCS17                  "ICD-10-PCS CCS: procedure 17"
 I10_PRCCS18                  "ICD-10-PCS CCS: procedure 18"
 I10_PRCCS19                  "ICD-10-PCS CCS: procedure 19"
 I10_PRCCS20                  "ICD-10-PCS CCS: procedure 20"
 I10_PRCCS21                  "ICD-10-PCS CCS: procedure 21"
 I10_PRCCS22                  "ICD-10-PCS CCS: procedure 22"
 I10_PRCCS23                  "ICD-10-PCS CCS: procedure 23"
 I10_PRCCS24                  "ICD-10-PCS CCS: procedure 24"
 I10_PRCCS25                  "ICD-10-PCS CCS: procedure 25"
 I10_PRCCS26                  "ICD-10-PCS CCS: procedure 26"
 I10_PRCCS27                  "ICD-10-PCS CCS: procedure 27"
 I10_PRCCS28                  "ICD-10-PCS CCS: procedure 28"
 I10_PRCCS29                  "ICD-10-PCS CCS: procedure 29"
 I10_PRCCS30                  "ICD-10-PCS CCS: procedure 30"
 I10_PRCCS31                  "ICD-10-PCS CCS: procedure 31"
 I10_PRCCS32                  "ICD-10-PCS CCS: procedure 32"
 I10_PRCCS33                  "ICD-10-PCS CCS: procedure 33"
 I10_PRCCS34                  "ICD-10-PCS CCS: procedure 34"
 I10_PRCCS35                  "ICD-10-PCS CCS: procedure 35"
 I10_PRCCS36                  "ICD-10-PCS CCS: procedure 36"
 I10_PRCCS37                  "ICD-10-PCS CCS: procedure 37"
 I10_PRCCS38                  "ICD-10-PCS CCS: procedure 38"
 I10_PRCCS39                  "ICD-10-PCS CCS: procedure 39"
 I10_PRCCS40                  "ICD-10-PCS CCS: procedure 40"
 I10_PRCCS41                  "ICD-10-PCS CCS: procedure 41"
 I10_PRCCS42                  "ICD-10-PCS CCS: procedure 42"
 I10_PRCCS43                  "ICD-10-PCS CCS: procedure 43"
 I10_PRCCS44                  "ICD-10-PCS CCS: procedure 44"
 I10_PRCCS45                  "ICD-10-PCS CCS: procedure 45"
 I10_PRCCS46                  "ICD-10-PCS CCS: procedure 46"
 I10_PRCCS47                  "ICD-10-PCS CCS: procedure 47"
 I10_PRCCS48                  "ICD-10-PCS CCS: procedure 48"
 I10_PRCCS49                  "ICD-10-PCS CCS: procedure 49"
 I10_PRCCS50                  "ICD-10-PCS CCS: procedure 50"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDC32                        "MDC, version 32"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PRDAY46                      "Number of days from admission to I10_PR46"
 PRDAY47                      "Number of days from admission to I10_PR47"
 PRDAY48                      "Number of days from admission to I10_PR48"
 PRDAY49                      "Number of days from admission to I10_PR49"
 PRDAY50                      "Number of days from admission to I10_PR50"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG32
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC32
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'DC_SID_2015q4_CORE.SAV' /COMPRESSED.
