/*******************************************************************
* Creation Date: 07/25/2018   
*   DC_SID_2016_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'DC_SID_2016_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BILLTYPE                       20-  23 (A)
 BWT                            24-  27
 DHOUR                          28-  31
 DIED                           32-  33
 DISP_X                         34-  35 (A)
 DISPUB04                       36-  37
 DISPUNIFORM                    38-  39
 DMONTH                         40-  41
 DQTR                           42-  43
 DRG                            44-  46
 DRG_NoPOA                      47-  49
 DRGVER                         50-  51
 DXPOA1                         52     (A)
 DXPOA2                         53     (A)
 DXPOA3                         54     (A)
 DXPOA4                         55     (A)
 DXPOA5                         56     (A)
 DXPOA6                         57     (A)
 DXPOA7                         58     (A)
 DXPOA8                         59     (A)
 DXPOA9                         60     (A)
 DXPOA10                        61     (A)
 DXPOA11                        62     (A)
 DXPOA12                        63     (A)
 DXPOA13                        64     (A)
 DXPOA14                        65     (A)
 DXPOA15                        66     (A)
 DXPOA16                        67     (A)
 DXPOA17                        68     (A)
 DXPOA18                        69     (A)
 DXPOA19                        70     (A)
 DXPOA20                        71     (A)
 DXPOA21                        72     (A)
 DXPOA22                        73     (A)
 DXPOA23                        74     (A)
 DXPOA24                        75     (A)
 DXPOA25                        76     (A)
 DXPOA26                        77     (A)
 DXPOA27                        78     (A)
 DXPOA28                        79     (A)
 DXPOA29                        80     (A)
 DXPOA30                        81     (A)
 DXPOA31                        82     (A)
 DXPOA32                        83     (A)
 DXPOA33                        84     (A)
 DXPOA34                        85     (A)
 DXPOA35                        86     (A)
 DXPOA36                        87     (A)
 DXPOA37                        88     (A)
 DXPOA38                        89     (A)
 DXPOA39                        90     (A)
 DXPOA40                        91     (A)
 DXPOA41                        92     (A)
 DXPOA42                        93     (A)
 DXPOA43                        94     (A)
 DXPOA44                        95     (A)
 DXPOA45                        96     (A)
 DXPOA46                        97     (A)
 DXPOA47                        98     (A)
 DXPOA48                        99     (A)
 DXPOA49                       100     (A)
 DXPOA50                       101     (A)
 DXVER                         102- 104
 E_POA1                        105     (A)
 E_POA2                        106     (A)
 E_POA3                        107     (A)
 E_POA4                        108     (A)
 E_POA5                        109     (A)
 E_POA6                        110     (A)
 E_POA7                        111     (A)
 E_POA8                        112     (A)
 E_POA9                        113     (A)
 E_POA10                       114     (A)
 E_POA11                       115     (A)
 E_POA12                       116     (A)
 FEMALE                        117- 118
 HCUP_ED                       119- 120
 HCUP_OS                       121- 122
 HOSPST                        123- 124 (A)
 I10_DX_Admitting              125- 131 (A)
 I10_DX1                       132- 138 (A)
 I10_DX2                       139- 145 (A)
 I10_DX3                       146- 152 (A)
 I10_DX4                       153- 159 (A)
 I10_DX5                       160- 166 (A)
 I10_DX6                       167- 173 (A)
 I10_DX7                       174- 180 (A)
 I10_DX8                       181- 187 (A)
 I10_DX9                       188- 194 (A)
 I10_DX10                      195- 201 (A)
 I10_DX11                      202- 208 (A)
 I10_DX12                      209- 215 (A)
 I10_DX13                      216- 222 (A)
 I10_DX14                      223- 229 (A)
 I10_DX15                      230- 236 (A)
 I10_DX16                      237- 243 (A)
 I10_DX17                      244- 250 (A)
 I10_DX18                      251- 257 (A)
 I10_DX19                      258- 264 (A)
 I10_DX20                      265- 271 (A)
 I10_DX21                      272- 278 (A)
 I10_DX22                      279- 285 (A)
 I10_DX23                      286- 292 (A)
 I10_DX24                      293- 299 (A)
 I10_DX25                      300- 306 (A)
 I10_DX26                      307- 313 (A)
 I10_DX27                      314- 320 (A)
 I10_DX28                      321- 327 (A)
 I10_DX29                      328- 334 (A)
 I10_DX30                      335- 341 (A)
 I10_DX31                      342- 348 (A)
 I10_DX32                      349- 355 (A)
 I10_DX33                      356- 362 (A)
 I10_DX34                      363- 369 (A)
 I10_DX35                      370- 376 (A)
 I10_DX36                      377- 383 (A)
 I10_DX37                      384- 390 (A)
 I10_DX38                      391- 397 (A)
 I10_DX39                      398- 404 (A)
 I10_DX40                      405- 411 (A)
 I10_DX41                      412- 418 (A)
 I10_DX42                      419- 425 (A)
 I10_DX43                      426- 432 (A)
 I10_DX44                      433- 439 (A)
 I10_DX45                      440- 446 (A)
 I10_DX46                      447- 453 (A)
 I10_DX47                      454- 460 (A)
 I10_DX48                      461- 467 (A)
 I10_DX49                      468- 474 (A)
 I10_DX50                      475- 481 (A)
 I10_ECAUSE1                   482- 488 (A)
 I10_ECAUSE2                   489- 495 (A)
 I10_ECAUSE3                   496- 502 (A)
 I10_ECAUSE4                   503- 509 (A)
 I10_ECAUSE5                   510- 516 (A)
 I10_ECAUSE6                   517- 523 (A)
 I10_ECAUSE7                   524- 530 (A)
 I10_ECAUSE8                   531- 537 (A)
 I10_ECAUSE9                   538- 544 (A)
 I10_ECAUSE10                  545- 551 (A)
 I10_ECAUSE11                  552- 558 (A)
 I10_ECAUSE12                  559- 565 (A)
 I10_NDX                       566- 568
 I10_NECAUSE                   569- 570
 I10_NPR                       571- 573
 I10_PR1                       574- 580 (A)
 I10_PR2                       581- 587 (A)
 I10_PR3                       588- 594 (A)
 I10_PR4                       595- 601 (A)
 I10_PR5                       602- 608 (A)
 I10_PR6                       609- 615 (A)
 I10_PR7                       616- 622 (A)
 I10_PR8                       623- 629 (A)
 I10_PR9                       630- 636 (A)
 I10_PR10                      637- 643 (A)
 I10_PR11                      644- 650 (A)
 I10_PR12                      651- 657 (A)
 I10_PR13                      658- 664 (A)
 I10_PR14                      665- 671 (A)
 I10_PR15                      672- 678 (A)
 I10_PR16                      679- 685 (A)
 I10_PR17                      686- 692 (A)
 I10_PR18                      693- 699 (A)
 I10_PR19                      700- 706 (A)
 I10_PR20                      707- 713 (A)
 I10_PR21                      714- 720 (A)
 I10_PR22                      721- 727 (A)
 I10_PR23                      728- 734 (A)
 I10_PR24                      735- 741 (A)
 I10_PR25                      742- 748 (A)
 I10_PR26                      749- 755 (A)
 I10_PR27                      756- 762 (A)
 I10_PR28                      763- 769 (A)
 I10_PR29                      770- 776 (A)
 I10_PR30                      777- 783 (A)
 I10_PR31                      784- 790 (A)
 I10_PR32                      791- 797 (A)
 I10_PR33                      798- 804 (A)
 I10_PR34                      805- 811 (A)
 I10_PR35                      812- 818 (A)
 I10_PR36                      819- 825 (A)
 I10_PR37                      826- 832 (A)
 I10_PR38                      833- 839 (A)
 I10_PR39                      840- 846 (A)
 I10_PR40                      847- 853 (A)
 I10_PR41                      854- 860 (A)
 I10_PR42                      861- 867 (A)
 I10_PR43                      868- 874 (A)
 I10_PR44                      875- 881 (A)
 I10_PR45                      882- 888 (A)
 I10_PR46                      889- 895 (A)
 I10_PR47                      896- 902 (A)
 I10_PR48                      903- 909 (A)
 I10_PR49                      910- 916 (A)
 I10_PR50                      917- 923 (A)
 I10_PROCTYPE                  924- 926
 KEY                           927- 941
 LOS                           942- 946
 LOS_X                         947- 952
 MDC                           953- 954
 MDC_NoPOA                     955- 956
 MDNUM1_R                      957- 965
 MDNUM2_R                      966- 974
 MDNUM3_R                      975- 983
 MDNUM4_R                      984- 992
 MEDINCSTQ                     993- 994
 PAY1                          995- 996
 PAY1_X                        997-1004 (A)
 PAY2                         1005-1006
 PAY2_X                       1007-1014 (A)
 PAY3                         1015-1016
 PAY3_X                       1017-1024 (A)
 PL_CBSA                      1025-1027
 PL_NCHS                      1028-1029
 PL_RUCC                      1030-1031
 PL_UIC                       1032-1033
 PL_UR_CAT4                   1034-1035
 POA_Disch_Edit1              1036-1037
 POA_Disch_Edit2              1038-1039
 POA_Hosp_Edit1               1040-1041
 POA_Hosp_Edit2               1042-1043
 POA_Hosp_Edit3               1044-1045
 POA_Hosp_Edit3_Value         1046-1053
 PointOfOrigin_X              1054-1056 (A)
 PointOfOriginUB04            1057     (A)
 PRDAY1                       1058-1062
 PRDAY2                       1063-1067
 PRDAY3                       1068-1072
 PRDAY4                       1073-1077
 PRDAY5                       1078-1082
 PRDAY6                       1083-1087
 PRDAY7                       1088-1092
 PRDAY8                       1093-1097
 PRDAY9                       1098-1102
 PRDAY10                      1103-1107
 PRDAY11                      1108-1112
 PRDAY12                      1113-1117
 PRDAY13                      1118-1122
 PRDAY14                      1123-1127
 PRDAY15                      1128-1132
 PRDAY16                      1133-1137
 PRDAY17                      1138-1142
 PRDAY18                      1143-1147
 PRDAY19                      1148-1152
 PRDAY20                      1153-1157
 PRDAY21                      1158-1162
 PRDAY22                      1163-1167
 PRDAY23                      1168-1172
 PRDAY24                      1173-1177
 PRDAY25                      1178-1182
 PRDAY26                      1183-1187
 PRDAY27                      1188-1192
 PRDAY28                      1193-1197
 PRDAY29                      1198-1202
 PRDAY30                      1203-1207
 PRDAY31                      1208-1212
 PRDAY32                      1213-1217
 PRDAY33                      1218-1222
 PRDAY34                      1223-1227
 PRDAY35                      1228-1232
 PRDAY36                      1233-1237
 PRDAY37                      1238-1242
 PRDAY38                      1243-1247
 PRDAY39                      1248-1252
 PRDAY40                      1253-1257
 PRDAY41                      1258-1262
 PRDAY42                      1263-1267
 PRDAY43                      1268-1272
 PRDAY44                      1273-1277
 PRDAY45                      1278-1282
 PRDAY46                      1283-1287
 PRDAY47                      1288-1292
 PRDAY48                      1293-1297
 PRDAY49                      1298-1302
 PRDAY50                      1303-1307
 PRVER                        1308-1310
 PSTATE                       1311-1312 (A)
 PSTCO                        1313-1317
 PSTCO2                       1318-1322
 RACE_X                       1323-1325 (A)
 TOTCHG                       1326-1335
 TOTCHG_X                     1336-1350
 TRAN_IN                      1351-1352
 TRAN_OUT                     1353-1354
 YEAR                         1355-1358
 ZIP                          1359-1363 (A)
 ZIP3                         1364-1366 (A)
 ZIPINC_QRTL                  1367-1369
 HOSPID                       1370-1374
 AYEAR                        1375-1378
 BMONTH                       1379-1380
 BYEAR                        1381-1384.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 BWT                          "Birth weight in grams"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "External cause 1, present on admission indicator"
 E_POA2                       "External cause 2, present on admission indicator"
 E_POA3                       "External cause 3, present on admission indicator"
 E_POA4                       "External cause 4, present on admission indicator"
 E_POA5                       "External cause 5, present on admission indicator"
 E_POA6                       "External cause 6, present on admission indicator"
 E_POA7                       "External cause 7, present on admission indicator"
 E_POA8                       "External cause 8, present on admission indicator"
 E_POA9                       "External cause 9, present on admission indicator"
 E_POA10                      "External cause 10, present on admission indicator"
 E_POA11                      "External cause 11, present on admission indicator"
 E_POA12                      "External cause 12, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_ECAUSE1                  "ICD-10-CM External cause 1"
 I10_ECAUSE2                  "ICD-10-CM External cause 2"
 I10_ECAUSE3                  "ICD-10-CM External cause 3"
 I10_ECAUSE4                  "ICD-10-CM External cause 4"
 I10_ECAUSE5                  "ICD-10-CM External cause 5"
 I10_ECAUSE6                  "ICD-10-CM External cause 6"
 I10_ECAUSE7                  "ICD-10-CM External cause 7"
 I10_ECAUSE8                  "ICD-10-CM External cause 8"
 I10_ECAUSE9                  "ICD-10-CM External cause 9"
 I10_ECAUSE10                 "ICD-10-CM External cause 10"
 I10_ECAUSE11                 "ICD-10-CM External cause 11"
 I10_ECAUSE12                 "ICD-10-CM External cause 12"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of External cause codes on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PRDAY46                      "Number of days from admission to I10_PR46"
 PRDAY47                      "Number of days from admission to I10_PR47"
 PRDAY48                      "Number of days from admission to I10_PR48"
 PRDAY49                      "Number of days from admission to I10_PR49"
 PRDAY50                      "Number of days from admission to I10_PR50"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'DC_SID_2016_CORE.SAV' /COMPRESSED.
