/*******************************************************************
* Creation Date: 04/20/2021   
*   DC_SID_2019_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'DC_SID_2019_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BILLTYPE                       20-  23 (A)
 BWT                            24-  27
 DHOUR                          28-  31
 DIED                           32-  33
 DISPUB04                       34-  35
 DISPUNIFORM                    36-  37
 DISP_X                         38-  39 (A)
 DMONTH                         40-  41
 DQTR                           42-  43
 DRG                            44-  46
 DRGVER                         47-  48
 DRG_NoPOA                      49-  51
 DXPOA1                         52     (A)
 DXPOA2                         53     (A)
 DXPOA3                         54     (A)
 DXPOA4                         55     (A)
 DXPOA5                         56     (A)
 DXPOA6                         57     (A)
 DXPOA7                         58     (A)
 DXPOA8                         59     (A)
 DXPOA9                         60     (A)
 DXPOA10                        61     (A)
 DXPOA11                        62     (A)
 DXPOA12                        63     (A)
 DXPOA13                        64     (A)
 DXPOA14                        65     (A)
 DXPOA15                        66     (A)
 DXPOA16                        67     (A)
 DXPOA17                        68     (A)
 DXPOA18                        69     (A)
 DXPOA19                        70     (A)
 DXPOA20                        71     (A)
 DXPOA21                        72     (A)
 DXPOA22                        73     (A)
 DXPOA23                        74     (A)
 DXPOA24                        75     (A)
 DXPOA25                        76     (A)
 DXPOA26                        77     (A)
 DXPOA27                        78     (A)
 DXPOA28                        79     (A)
 DXPOA29                        80     (A)
 DXPOA30                        81     (A)
 DXPOA31                        82     (A)
 DXPOA32                        83     (A)
 DXPOA33                        84     (A)
 DXPOA34                        85     (A)
 DXPOA35                        86     (A)
 DXPOA36                        87     (A)
 DXPOA37                        88     (A)
 DXPOA38                        89     (A)
 DXPOA39                        90     (A)
 DXPOA40                        91     (A)
 DXPOA41                        92     (A)
 DXPOA42                        93     (A)
 DXPOA43                        94     (A)
 DXPOA44                        95     (A)
 DXPOA45                        96     (A)
 DXPOA46                        97     (A)
 DXPOA47                        98     (A)
 DXPOA48                        99     (A)
 DXPOA49                       100     (A)
 DXPOA50                       101     (A)
 DXPOA51                       102     (A)
 DXPOA52                       103     (A)
 DXPOA53                       104     (A)
 DXPOA54                       105     (A)
 DXPOA55                       106     (A)
 DXPOA56                       107     (A)
 DXPOA57                       108     (A)
 DXPOA58                       109     (A)
 DXPOA59                       110     (A)
 DXPOA60                       111     (A)
 DXPOA61                       112     (A)
 DXPOA62                       113     (A)
 DXPOA63                       114     (A)
 DXPOA64                       115     (A)
 DXPOA65                       116     (A)
 DXPOA66                       117     (A)
 DXPOA67                       118     (A)
 DXPOA68                       119     (A)
 DXPOA69                       120     (A)
 DXPOA70                       121     (A)
 DXPOA71                       122     (A)
 DXPOA72                       123     (A)
 DXPOA73                       124     (A)
 DXPOA74                       125     (A)
 DXPOA75                       126     (A)
 DXPOA76                       127     (A)
 DXPOA77                       128     (A)
 DXPOA78                       129     (A)
 DXPOA79                       130     (A)
 DXPOA80                       131     (A)
 DXPOA81                       132     (A)
 DXPOA82                       133     (A)
 DXPOA83                       134     (A)
 DXPOA84                       135     (A)
 DXPOA85                       136     (A)
 DXPOA86                       137     (A)
 DXPOA87                       138     (A)
 DXPOA88                       139     (A)
 DXPOA89                       140     (A)
 DXPOA90                       141     (A)
 DXPOA91                       142     (A)
 DXPOA92                       143     (A)
 DXPOA93                       144     (A)
 DXPOA94                       145     (A)
 DXPOA95                       146     (A)
 DXPOA96                       147     (A)
 DXPOA97                       148     (A)
 DXPOA98                       149     (A)
 DXPOA99                       150     (A)
 FEMALE                        151- 152
 HCUP_ED                       153- 154
 HCUP_OS                       155- 156
 HOSPST                        157- 158 (A)
 I10_BIRTH                     159- 160
 I10_DELIVERY                  161- 162
 I10_DX1                       163- 169 (A)
 I10_DX2                       170- 176 (A)
 I10_DX3                       177- 183 (A)
 I10_DX4                       184- 190 (A)
 I10_DX5                       191- 197 (A)
 I10_DX6                       198- 204 (A)
 I10_DX7                       205- 211 (A)
 I10_DX8                       212- 218 (A)
 I10_DX9                       219- 225 (A)
 I10_DX10                      226- 232 (A)
 I10_DX11                      233- 239 (A)
 I10_DX12                      240- 246 (A)
 I10_DX13                      247- 253 (A)
 I10_DX14                      254- 260 (A)
 I10_DX15                      261- 267 (A)
 I10_DX16                      268- 274 (A)
 I10_DX17                      275- 281 (A)
 I10_DX18                      282- 288 (A)
 I10_DX19                      289- 295 (A)
 I10_DX20                      296- 302 (A)
 I10_DX21                      303- 309 (A)
 I10_DX22                      310- 316 (A)
 I10_DX23                      317- 323 (A)
 I10_DX24                      324- 330 (A)
 I10_DX25                      331- 337 (A)
 I10_DX26                      338- 344 (A)
 I10_DX27                      345- 351 (A)
 I10_DX28                      352- 358 (A)
 I10_DX29                      359- 365 (A)
 I10_DX30                      366- 372 (A)
 I10_DX31                      373- 379 (A)
 I10_DX32                      380- 386 (A)
 I10_DX33                      387- 393 (A)
 I10_DX34                      394- 400 (A)
 I10_DX35                      401- 407 (A)
 I10_DX36                      408- 414 (A)
 I10_DX37                      415- 421 (A)
 I10_DX38                      422- 428 (A)
 I10_DX39                      429- 435 (A)
 I10_DX40                      436- 442 (A)
 I10_DX41                      443- 449 (A)
 I10_DX42                      450- 456 (A)
 I10_DX43                      457- 463 (A)
 I10_DX44                      464- 470 (A)
 I10_DX45                      471- 477 (A)
 I10_DX46                      478- 484 (A)
 I10_DX47                      485- 491 (A)
 I10_DX48                      492- 498 (A)
 I10_DX49                      499- 505 (A)
 I10_DX50                      506- 512 (A)
 I10_DX51                      513- 519 (A)
 I10_DX52                      520- 526 (A)
 I10_DX53                      527- 533 (A)
 I10_DX54                      534- 540 (A)
 I10_DX55                      541- 547 (A)
 I10_DX56                      548- 554 (A)
 I10_DX57                      555- 561 (A)
 I10_DX58                      562- 568 (A)
 I10_DX59                      569- 575 (A)
 I10_DX60                      576- 582 (A)
 I10_DX61                      583- 589 (A)
 I10_DX62                      590- 596 (A)
 I10_DX63                      597- 603 (A)
 I10_DX64                      604- 610 (A)
 I10_DX65                      611- 617 (A)
 I10_DX66                      618- 624 (A)
 I10_DX67                      625- 631 (A)
 I10_DX68                      632- 638 (A)
 I10_DX69                      639- 645 (A)
 I10_DX70                      646- 652 (A)
 I10_DX71                      653- 659 (A)
 I10_DX72                      660- 666 (A)
 I10_DX73                      667- 673 (A)
 I10_DX74                      674- 680 (A)
 I10_DX75                      681- 687 (A)
 I10_DX76                      688- 694 (A)
 I10_DX77                      695- 701 (A)
 I10_DX78                      702- 708 (A)
 I10_DX79                      709- 715 (A)
 I10_DX80                      716- 722 (A)
 I10_DX81                      723- 729 (A)
 I10_DX82                      730- 736 (A)
 I10_DX83                      737- 743 (A)
 I10_DX84                      744- 750 (A)
 I10_DX85                      751- 757 (A)
 I10_DX86                      758- 764 (A)
 I10_DX87                      765- 771 (A)
 I10_DX88                      772- 778 (A)
 I10_DX89                      779- 785 (A)
 I10_DX90                      786- 792 (A)
 I10_DX91                      793- 799 (A)
 I10_DX92                      800- 806 (A)
 I10_DX93                      807- 813 (A)
 I10_DX94                      814- 820 (A)
 I10_DX95                      821- 827 (A)
 I10_DX96                      828- 834 (A)
 I10_DX97                      835- 841 (A)
 I10_DX98                      842- 848 (A)
 I10_DX99                      849- 855 (A)
 I10_DX_Admitting              856- 862 (A)
 I10_NDX                       863- 865
 I10_NPR                       866- 868
 I10_ORPROC                    869- 870
 I10_PR1                       871- 877 (A)
 I10_PR2                       878- 884 (A)
 I10_PR3                       885- 891 (A)
 I10_PR4                       892- 898 (A)
 I10_PR5                       899- 905 (A)
 I10_PR6                       906- 912 (A)
 I10_PR7                       913- 919 (A)
 I10_PR8                       920- 926 (A)
 I10_PR9                       927- 933 (A)
 I10_PR10                      934- 940 (A)
 I10_PR11                      941- 947 (A)
 I10_PR12                      948- 954 (A)
 I10_PR13                      955- 961 (A)
 I10_PR14                      962- 968 (A)
 I10_PR15                      969- 975 (A)
 I10_PR16                      976- 982 (A)
 I10_PR17                      983- 989 (A)
 I10_PR18                      990- 996 (A)
 I10_PR19                      997-1003 (A)
 I10_PR20                     1004-1010 (A)
 I10_PR21                     1011-1017 (A)
 I10_PR22                     1018-1024 (A)
 I10_PR23                     1025-1031 (A)
 I10_PR24                     1032-1038 (A)
 I10_PR25                     1039-1045 (A)
 I10_PR26                     1046-1052 (A)
 I10_PR27                     1053-1059 (A)
 I10_PR28                     1060-1066 (A)
 I10_PR29                     1067-1073 (A)
 I10_PR30                     1074-1080 (A)
 I10_PR31                     1081-1087 (A)
 I10_PR32                     1088-1094 (A)
 I10_PR33                     1095-1101 (A)
 I10_PR34                     1102-1108 (A)
 I10_PR35                     1109-1115 (A)
 I10_PR36                     1116-1122 (A)
 I10_PR37                     1123-1129 (A)
 I10_PR38                     1130-1136 (A)
 I10_PR39                     1137-1143 (A)
 I10_PR40                     1144-1150 (A)
 I10_PR41                     1151-1157 (A)
 I10_PR42                     1158-1164 (A)
 I10_PR43                     1165-1171 (A)
 I10_PR44                     1172-1178 (A)
 I10_PR45                     1179-1185 (A)
 I10_PR46                     1186-1192 (A)
 I10_PR47                     1193-1199 (A)
 I10_PR48                     1200-1206 (A)
 I10_PR49                     1207-1213 (A)
 I10_PR50                     1214-1220 (A)
 I10_PR51                     1221-1227 (A)
 I10_PR52                     1228-1234 (A)
 I10_PR53                     1235-1241 (A)
 I10_PR54                     1242-1248 (A)
 I10_PR55                     1249-1255 (A)
 I10_PR56                     1256-1262 (A)
 I10_PR57                     1263-1269 (A)
 I10_PR58                     1270-1276 (A)
 I10_PR59                     1277-1283 (A)
 I10_PR60                     1284-1290 (A)
 I10_PR61                     1291-1297 (A)
 I10_PR62                     1298-1304 (A)
 I10_PR63                     1305-1311 (A)
 I10_PR64                     1312-1318 (A)
 I10_PR65                     1319-1325 (A)
 I10_PR66                     1326-1332 (A)
 I10_PR67                     1333-1339 (A)
 I10_PR68                     1340-1346 (A)
 I10_PR69                     1347-1353 (A)
 I10_PR70                     1354-1360 (A)
 I10_PR71                     1361-1367 (A)
 I10_PR72                     1368-1374 (A)
 I10_PR73                     1375-1381 (A)
 I10_PR74                     1382-1388 (A)
 I10_PR75                     1389-1395 (A)
 I10_PR76                     1396-1402 (A)
 I10_PR77                     1403-1409 (A)
 I10_PR78                     1410-1416 (A)
 I10_PR79                     1417-1423 (A)
 I10_PR80                     1424-1430 (A)
 I10_PR81                     1431-1437 (A)
 I10_PR82                     1438-1444 (A)
 I10_PR83                     1445-1451 (A)
 I10_PR84                     1452-1458 (A)
 I10_PR85                     1459-1465 (A)
 I10_PR86                     1466-1472 (A)
 I10_PR87                     1473-1479 (A)
 I10_PR88                     1480-1486 (A)
 I10_PR89                     1487-1493 (A)
 I10_PR90                     1494-1500 (A)
 I10_PR91                     1501-1507 (A)
 I10_PR92                     1508-1514 (A)
 I10_PR93                     1515-1521 (A)
 I10_PR94                     1522-1528 (A)
 I10_PR95                     1529-1535 (A)
 I10_PR96                     1536-1542 (A)
 I10_PR97                     1543-1549 (A)
 I10_PR98                     1550-1556 (A)
 I10_PR99                     1557-1563 (A)
 I10_PR100                    1564-1570 (A)
 I10_PROCTYPE                 1571-1573
 I10_SERVICELINE              1574-1575
 KEY                          1576-1590
 LOS                          1591-1595
 LOS_X                        1596-1601
 MDC                          1602-1603
 MDC_NoPOA                    1604-1605
 MDNUM1_R                     1606-1614
 MDNUM2_R                     1615-1623
 MDNUM3_R                     1624-1632
 MDNUM4_R                     1633-1641
 MEDINCSTQ                    1642-1643
 PAY1                         1644-1645
 PAY1_X                       1646-1653 (A)
 PAY2                         1654-1655
 PAY2_X                       1656-1663 (A)
 PAY3                         1664-1665
 PAY3_X                       1666-1673 (A)
 PL_CBSA                      1674-1676
 PL_NCHS                      1677-1678
 PL_RUCC                      1679-1680
 PL_UIC                       1681-1682
 PL_UR_CAT4                   1683-1684
 POA_Disch_Edit1              1685-1686
 POA_Disch_Edit2              1687-1688
 POA_Hosp_Edit1               1689-1690
 POA_Hosp_Edit2               1691-1692
 POA_Hosp_Edit3               1693-1694
 POA_Hosp_Edit3_Value         1695-1702
 PRDAY1                       1703-1707
 PRDAY2                       1708-1712
 PRDAY3                       1713-1717
 PRDAY4                       1718-1722
 PRDAY5                       1723-1727
 PRDAY6                       1728-1732
 PRDAY7                       1733-1737
 PRDAY8                       1738-1742
 PRDAY9                       1743-1747
 PRDAY10                      1748-1752
 PRDAY11                      1753-1757
 PRDAY12                      1758-1762
 PRDAY13                      1763-1767
 PRDAY14                      1768-1772
 PRDAY15                      1773-1777
 PRDAY16                      1778-1782
 PRDAY17                      1783-1787
 PRDAY18                      1788-1792
 PRDAY19                      1793-1797
 PRDAY20                      1798-1802
 PRDAY21                      1803-1807
 PRDAY22                      1808-1812
 PRDAY23                      1813-1817
 PRDAY24                      1818-1822
 PRDAY25                      1823-1827
 PRDAY26                      1828-1832
 PRDAY27                      1833-1837
 PRDAY28                      1838-1842
 PRDAY29                      1843-1847
 PRDAY30                      1848-1852
 PRDAY31                      1853-1857
 PRDAY32                      1858-1862
 PRDAY33                      1863-1867
 PRDAY34                      1868-1872
 PRDAY35                      1873-1877
 PRDAY36                      1878-1882
 PRDAY37                      1883-1887
 PRDAY38                      1888-1892
 PRDAY39                      1893-1897
 PRDAY40                      1898-1902
 PRDAY41                      1903-1907
 PRDAY42                      1908-1912
 PRDAY43                      1913-1917
 PRDAY44                      1918-1922
 PRDAY45                      1923-1927
 PRDAY46                      1928-1932
 PRDAY47                      1933-1937
 PRDAY48                      1938-1942
 PRDAY49                      1943-1947
 PRDAY50                      1948-1952
 PRDAY51                      1953-1957
 PRDAY52                      1958-1962
 PRDAY53                      1963-1967
 PRDAY54                      1968-1972
 PRDAY55                      1973-1977
 PRDAY56                      1978-1982
 PRDAY57                      1983-1987
 PRDAY58                      1988-1992
 PRDAY59                      1993-1997
 PRDAY60                      1998-2002
 PRDAY61                      2003-2007
 PRDAY62                      2008-2012
 PRDAY63                      2013-2017
 PRDAY64                      2018-2022
 PRDAY65                      2023-2027
 PRDAY66                      2028-2032
 PRDAY67                      2033-2037
 PRDAY68                      2038-2042
 PRDAY69                      2043-2047
 PRDAY70                      2048-2052
 PRDAY71                      2053-2057
 PRDAY72                      2058-2062
 PRDAY73                      2063-2067
 PRDAY74                      2068-2072
 PRDAY75                      2073-2077
 PRDAY76                      2078-2082
 PRDAY77                      2083-2087
 PRDAY78                      2088-2092
 PRDAY79                      2093-2097
 PRDAY80                      2098-2102
 PRDAY81                      2103-2107
 PRDAY82                      2108-2112
 PRDAY83                      2113-2117
 PRDAY84                      2118-2122
 PRDAY85                      2123-2127
 PRDAY86                      2128-2132
 PRDAY87                      2133-2137
 PRDAY88                      2138-2142
 PRDAY89                      2143-2147
 PRDAY90                      2148-2152
 PRDAY91                      2153-2157
 PRDAY92                      2158-2162
 PRDAY93                      2163-2167
 PRDAY94                      2168-2172
 PRDAY95                      2173-2177
 PRDAY96                      2178-2182
 PRDAY97                      2183-2187
 PRDAY98                      2188-2192
 PRDAY99                      2193-2197
 PRDAY100                     2198-2202
 PSTATE                       2203-2204 (A)
 PSTATE_GEO                   2205-2206 (A)
 PSTCO                        2207-2211
 PSTCO_GEO                    2212-2216
 PointOfOriginUB04            2217     (A)
 PointOfOrigin_X              2218-2220 (A)
 RACE                         2221-2222
 RACE_EDIT                    2223-2224
 RACE_X                       2225-2227 (A)
 TOTCHG                       2228-2237
 TOTCHG_X                     2238-2252
 TRAN_IN                      2253-2254
 TRAN_OUT                     2255-2256
 YEAR                         2257-2260
 ZIP                          2261-2265 (A)
 ZIP3                         2266-2268 (A)
 ZIPINC_QRTL                  2269-2271
 HOSPID                       2272-2276
 AYEAR                        2277-2280
 BMONTH                       2281-2282
 BYEAR                        2283-2286.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRGVER                       (F3.0) /
 DRG_NoPOA                    (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 I10_BIRTH                    (F3.0) /
 I10_DELIVERY                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRDAY51                      (F4.0) /
 PRDAY52                      (F4.0) /
 PRDAY53                      (F4.0) /
 PRDAY54                      (F4.0) /
 PRDAY55                      (F4.0) /
 PRDAY56                      (F4.0) /
 PRDAY57                      (F4.0) /
 PRDAY58                      (F4.0) /
 PRDAY59                      (F4.0) /
 PRDAY60                      (F4.0) /
 PRDAY61                      (F4.0) /
 PRDAY62                      (F4.0) /
 PRDAY63                      (F4.0) /
 PRDAY64                      (F4.0) /
 PRDAY65                      (F4.0) /
 PRDAY66                      (F4.0) /
 PRDAY67                      (F4.0) /
 PRDAY68                      (F4.0) /
 PRDAY69                      (F4.0) /
 PRDAY70                      (F4.0) /
 PRDAY71                      (F4.0) /
 PRDAY72                      (F4.0) /
 PRDAY73                      (F4.0) /
 PRDAY74                      (F4.0) /
 PRDAY75                      (F4.0) /
 PRDAY76                      (F4.0) /
 PRDAY77                      (F4.0) /
 PRDAY78                      (F4.0) /
 PRDAY79                      (F4.0) /
 PRDAY80                      (F4.0) /
 PRDAY81                      (F4.0) /
 PRDAY82                      (F4.0) /
 PRDAY83                      (F4.0) /
 PRDAY84                      (F4.0) /
 PRDAY85                      (F4.0) /
 PRDAY86                      (F4.0) /
 PRDAY87                      (F4.0) /
 PRDAY88                      (F4.0) /
 PRDAY89                      (F4.0) /
 PRDAY90                      (F4.0) /
 PRDAY91                      (F4.0) /
 PRDAY92                      (F4.0) /
 PRDAY93                      (F4.0) /
 PRDAY94                      (F4.0) /
 PRDAY95                      (F4.0) /
 PRDAY96                      (F4.0) /
 PRDAY97                      (F4.0) /
 PRDAY98                      (F4.0) /
 PRDAY99                      (F4.0) /
 PRDAY100                     (F4.0) /
 PSTCO                        (F4.0) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 RACE_EDIT                    (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 BWT                          "Birth weight in grams"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRGVER                       "DRG grouper version used on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXPOA61                      "Diagnosis 61, present on admission indicator"
 DXPOA62                      "Diagnosis 62, present on admission indicator"
 DXPOA63                      "Diagnosis 63, present on admission indicator"
 DXPOA64                      "Diagnosis 64, present on admission indicator"
 DXPOA65                      "Diagnosis 65, present on admission indicator"
 DXPOA66                      "Diagnosis 66, present on admission indicator"
 DXPOA67                      "Diagnosis 67, present on admission indicator"
 DXPOA68                      "Diagnosis 68, present on admission indicator"
 DXPOA69                      "Diagnosis 69, present on admission indicator"
 DXPOA70                      "Diagnosis 70, present on admission indicator"
 DXPOA71                      "Diagnosis 71, present on admission indicator"
 DXPOA72                      "Diagnosis 72, present on admission indicator"
 DXPOA73                      "Diagnosis 73, present on admission indicator"
 DXPOA74                      "Diagnosis 74, present on admission indicator"
 DXPOA75                      "Diagnosis 75, present on admission indicator"
 DXPOA76                      "Diagnosis 76, present on admission indicator"
 DXPOA77                      "Diagnosis 77, present on admission indicator"
 DXPOA78                      "Diagnosis 78, present on admission indicator"
 DXPOA79                      "Diagnosis 79, present on admission indicator"
 DXPOA80                      "Diagnosis 80, present on admission indicator"
 DXPOA81                      "Diagnosis 81, present on admission indicator"
 DXPOA82                      "Diagnosis 82, present on admission indicator"
 DXPOA83                      "Diagnosis 83, present on admission indicator"
 DXPOA84                      "Diagnosis 84, present on admission indicator"
 DXPOA85                      "Diagnosis 85, present on admission indicator"
 DXPOA86                      "Diagnosis 86, present on admission indicator"
 DXPOA87                      "Diagnosis 87, present on admission indicator"
 DXPOA88                      "Diagnosis 88, present on admission indicator"
 DXPOA89                      "Diagnosis 89, present on admission indicator"
 DXPOA90                      "Diagnosis 90, present on admission indicator"
 DXPOA91                      "Diagnosis 91, present on admission indicator"
 DXPOA92                      "Diagnosis 92, present on admission indicator"
 DXPOA93                      "Diagnosis 93, present on admission indicator"
 DXPOA94                      "Diagnosis 94, present on admission indicator"
 DXPOA95                      "Diagnosis 95, present on admission indicator"
 DXPOA96                      "Diagnosis 96, present on admission indicator"
 DXPOA97                      "Diagnosis 97, present on admission indicator"
 DXPOA98                      "Diagnosis 98, present on admission indicator"
 DXPOA99                      "Diagnosis 99, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HOSPST                       "Hospital state postal code"
 I10_BIRTH                    "ICD-10-CM Birth Indicator"
 I10_DELIVERY                 "ICD-10-CM Delivery Indicator"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_DX61                     "ICD-10-CM Diagnosis 61"
 I10_DX62                     "ICD-10-CM Diagnosis 62"
 I10_DX63                     "ICD-10-CM Diagnosis 63"
 I10_DX64                     "ICD-10-CM Diagnosis 64"
 I10_DX65                     "ICD-10-CM Diagnosis 65"
 I10_DX66                     "ICD-10-CM Diagnosis 66"
 I10_DX67                     "ICD-10-CM Diagnosis 67"
 I10_DX68                     "ICD-10-CM Diagnosis 68"
 I10_DX69                     "ICD-10-CM Diagnosis 69"
 I10_DX70                     "ICD-10-CM Diagnosis 70"
 I10_DX71                     "ICD-10-CM Diagnosis 71"
 I10_DX72                     "ICD-10-CM Diagnosis 72"
 I10_DX73                     "ICD-10-CM Diagnosis 73"
 I10_DX74                     "ICD-10-CM Diagnosis 74"
 I10_DX75                     "ICD-10-CM Diagnosis 75"
 I10_DX76                     "ICD-10-CM Diagnosis 76"
 I10_DX77                     "ICD-10-CM Diagnosis 77"
 I10_DX78                     "ICD-10-CM Diagnosis 78"
 I10_DX79                     "ICD-10-CM Diagnosis 79"
 I10_DX80                     "ICD-10-CM Diagnosis 80"
 I10_DX81                     "ICD-10-CM Diagnosis 81"
 I10_DX82                     "ICD-10-CM Diagnosis 82"
 I10_DX83                     "ICD-10-CM Diagnosis 83"
 I10_DX84                     "ICD-10-CM Diagnosis 84"
 I10_DX85                     "ICD-10-CM Diagnosis 85"
 I10_DX86                     "ICD-10-CM Diagnosis 86"
 I10_DX87                     "ICD-10-CM Diagnosis 87"
 I10_DX88                     "ICD-10-CM Diagnosis 88"
 I10_DX89                     "ICD-10-CM Diagnosis 89"
 I10_DX90                     "ICD-10-CM Diagnosis 90"
 I10_DX91                     "ICD-10-CM Diagnosis 91"
 I10_DX92                     "ICD-10-CM Diagnosis 92"
 I10_DX93                     "ICD-10-CM Diagnosis 93"
 I10_DX94                     "ICD-10-CM Diagnosis 94"
 I10_DX95                     "ICD-10-CM Diagnosis 95"
 I10_DX96                     "ICD-10-CM Diagnosis 96"
 I10_DX97                     "ICD-10-CM Diagnosis 97"
 I10_DX98                     "ICD-10-CM Diagnosis 98"
 I10_DX99                     "ICD-10-CM Diagnosis 99"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PR51                     "ICD-10-PCS Procedure 51"
 I10_PR52                     "ICD-10-PCS Procedure 52"
 I10_PR53                     "ICD-10-PCS Procedure 53"
 I10_PR54                     "ICD-10-PCS Procedure 54"
 I10_PR55                     "ICD-10-PCS Procedure 55"
 I10_PR56                     "ICD-10-PCS Procedure 56"
 I10_PR57                     "ICD-10-PCS Procedure 57"
 I10_PR58                     "ICD-10-PCS Procedure 58"
 I10_PR59                     "ICD-10-PCS Procedure 59"
 I10_PR60                     "ICD-10-PCS Procedure 60"
 I10_PR61                     "ICD-10-PCS Procedure 61"
 I10_PR62                     "ICD-10-PCS Procedure 62"
 I10_PR63                     "ICD-10-PCS Procedure 63"
 I10_PR64                     "ICD-10-PCS Procedure 64"
 I10_PR65                     "ICD-10-PCS Procedure 65"
 I10_PR66                     "ICD-10-PCS Procedure 66"
 I10_PR67                     "ICD-10-PCS Procedure 67"
 I10_PR68                     "ICD-10-PCS Procedure 68"
 I10_PR69                     "ICD-10-PCS Procedure 69"
 I10_PR70                     "ICD-10-PCS Procedure 70"
 I10_PR71                     "ICD-10-PCS Procedure 71"
 I10_PR72                     "ICD-10-PCS Procedure 72"
 I10_PR73                     "ICD-10-PCS Procedure 73"
 I10_PR74                     "ICD-10-PCS Procedure 74"
 I10_PR75                     "ICD-10-PCS Procedure 75"
 I10_PR76                     "ICD-10-PCS Procedure 76"
 I10_PR77                     "ICD-10-PCS Procedure 77"
 I10_PR78                     "ICD-10-PCS Procedure 78"
 I10_PR79                     "ICD-10-PCS Procedure 79"
 I10_PR80                     "ICD-10-PCS Procedure 80"
 I10_PR81                     "ICD-10-PCS Procedure 81"
 I10_PR82                     "ICD-10-PCS Procedure 82"
 I10_PR83                     "ICD-10-PCS Procedure 83"
 I10_PR84                     "ICD-10-PCS Procedure 84"
 I10_PR85                     "ICD-10-PCS Procedure 85"
 I10_PR86                     "ICD-10-PCS Procedure 86"
 I10_PR87                     "ICD-10-PCS Procedure 87"
 I10_PR88                     "ICD-10-PCS Procedure 88"
 I10_PR89                     "ICD-10-PCS Procedure 89"
 I10_PR90                     "ICD-10-PCS Procedure 90"
 I10_PR91                     "ICD-10-PCS Procedure 91"
 I10_PR92                     "ICD-10-PCS Procedure 92"
 I10_PR93                     "ICD-10-PCS Procedure 93"
 I10_PR94                     "ICD-10-PCS Procedure 94"
 I10_PR95                     "ICD-10-PCS Procedure 95"
 I10_PR96                     "ICD-10-PCS Procedure 96"
 I10_PR97                     "ICD-10-PCS Procedure 97"
 I10_PR98                     "ICD-10-PCS Procedure 98"
 I10_PR99                     "ICD-10-PCS Procedure 99"
 I10_PR100                    "ICD-10-PCS Procedure 100"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PRDAY46                      "Number of days from admission to I10_PR46"
 PRDAY47                      "Number of days from admission to I10_PR47"
 PRDAY48                      "Number of days from admission to I10_PR48"
 PRDAY49                      "Number of days from admission to I10_PR49"
 PRDAY50                      "Number of days from admission to I10_PR50"
 PRDAY51                      "Number of days from admission to I10_PR51"
 PRDAY52                      "Number of days from admission to I10_PR52"
 PRDAY53                      "Number of days from admission to I10_PR53"
 PRDAY54                      "Number of days from admission to I10_PR54"
 PRDAY55                      "Number of days from admission to I10_PR55"
 PRDAY56                      "Number of days from admission to I10_PR56"
 PRDAY57                      "Number of days from admission to I10_PR57"
 PRDAY58                      "Number of days from admission to I10_PR58"
 PRDAY59                      "Number of days from admission to I10_PR59"
 PRDAY60                      "Number of days from admission to I10_PR60"
 PRDAY61                      "Number of days from admission to I10_PR61"
 PRDAY62                      "Number of days from admission to I10_PR62"
 PRDAY63                      "Number of days from admission to I10_PR63"
 PRDAY64                      "Number of days from admission to I10_PR64"
 PRDAY65                      "Number of days from admission to I10_PR65"
 PRDAY66                      "Number of days from admission to I10_PR66"
 PRDAY67                      "Number of days from admission to I10_PR67"
 PRDAY68                      "Number of days from admission to I10_PR68"
 PRDAY69                      "Number of days from admission to I10_PR69"
 PRDAY70                      "Number of days from admission to I10_PR70"
 PRDAY71                      "Number of days from admission to I10_PR71"
 PRDAY72                      "Number of days from admission to I10_PR72"
 PRDAY73                      "Number of days from admission to I10_PR73"
 PRDAY74                      "Number of days from admission to I10_PR74"
 PRDAY75                      "Number of days from admission to I10_PR75"
 PRDAY76                      "Number of days from admission to I10_PR76"
 PRDAY77                      "Number of days from admission to I10_PR77"
 PRDAY78                      "Number of days from admission to I10_PR78"
 PRDAY79                      "Number of days from admission to I10_PR79"
 PRDAY80                      "Number of days from admission to I10_PR80"
 PRDAY81                      "Number of days from admission to I10_PR81"
 PRDAY82                      "Number of days from admission to I10_PR82"
 PRDAY83                      "Number of days from admission to I10_PR83"
 PRDAY84                      "Number of days from admission to I10_PR84"
 PRDAY85                      "Number of days from admission to I10_PR85"
 PRDAY86                      "Number of days from admission to I10_PR86"
 PRDAY87                      "Number of days from admission to I10_PR87"
 PRDAY88                      "Number of days from admission to I10_PR88"
 PRDAY89                      "Number of days from admission to I10_PR89"
 PRDAY90                      "Number of days from admission to I10_PR90"
 PRDAY91                      "Number of days from admission to I10_PR91"
 PRDAY92                      "Number of days from admission to I10_PR92"
 PRDAY93                      "Number of days from admission to I10_PR93"
 PRDAY94                      "Number of days from admission to I10_PR94"
 PRDAY95                      "Number of days from admission to I10_PR95"
 PRDAY96                      "Number of days from admission to I10_PR96"
 PRDAY97                      "Number of days from admission to I10_PR97"
 PRDAY98                      "Number of days from admission to I10_PR98"
 PRDAY99                      "Number of days from admission to I10_PR99"
 PRDAY100                     "Number of days from admission to I10_PR100"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 RACE                         "Race (uniform)"
 RACE_EDIT                    "Race Edit Checks"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BIRTH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DELIVERY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY51
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY52
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY53
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY54
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY55
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY56
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY57
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY58
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY59
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY60
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY61
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY62
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY63
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY64
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY65
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY66
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY67
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY68
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY69
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY70
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY71
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY72
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY73
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY74
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY75
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY76
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY77
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY78
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY79
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY80
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY81
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY82
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY83
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY84
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY85
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY86
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY87
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY88
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY89
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY90
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY91
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY92
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY93
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY94
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY95
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY96
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY97
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY98
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY99
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY100
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_EDIT
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'DC_SID_2019_CORE.SAV' /COMPRESSED.
