/*******************************************************************
*   FL_SID_1993_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'FL_SID_1993_CORE.ASC' FIXED / 
 AGE                   1-   3
 SEX                   4-   6
 RACE                  7-   8
 DQTR                  9-  10
 LOS                  11-  15
 DISP                 16-  17
 DIED                 18-  19
 ATYPE                20-  21
 ASOURCE              22-  23
 NDX                  24-  25
 DX1                  26-  30 (A)
 DXV1                 31-  34
 DCCHPR1              35-  38
 NPR                  39-  40
 PR1                  41-  44 (A)
 PRV1                 45-  47
 PCCHPR1              48-  51
 DRG                  52-  54
 MDC                  55-  56
 DRGVER               57-  58
 DRG10                59-  61
 MDC10                62-  63
 PAY1                 64-  65
 TOTCHG               66-  75
 YEAR                 76-  79
 DSHOSPID             80-  92 (A)
 DSTYPE               93-  95
 HOSPST               96-  97 (A)
 MDID_S               98- 113 (A)
 SURGID_S            114- 129 (A)
 LOS_X               130- 134
 NEOMAT              135- 136
 DXSYS               137- 139
 DSNDX               140- 142
 PRSYS               143- 145
 DSNPR               146- 148
 PRDAY1              149- 153
 PAY1_N              154- 156
 TOTCHG_X            157- 168
 DX2                 169- 173 (A)
 DX3                 174- 178 (A)
 DX4                 179- 183 (A)
 DX5                 184- 188 (A)
 DX6                 189- 193 (A)
 DX7                 194- 198 (A)
 DX8                 199- 203 (A)
 DX9                 204- 208 (A)
 DX10                209- 213 (A)
 DXV2                214- 217
 DXV3                218- 221
 DXV4                222- 225
 DXV5                226- 229
 DXV6                230- 233
 DXV7                234- 237
 DXV8                238- 241
 DXV9                242- 245
 DXV10               246- 249
 DCCHPR2             250- 253
 DCCHPR3             254- 257
 DCCHPR4             258- 261
 DCCHPR5             262- 265
 DCCHPR6             266- 269
 DCCHPR7             270- 273
 DCCHPR8             274- 277
 DCCHPR9             278- 281
 DCCHPR10            282- 285
 PR2                 286- 289 (A)
 PR3                 290- 293 (A)
 PR4                 294- 297 (A)
 PR5                 298- 301 (A)
 PR6                 302- 305 (A)
 PR7                 306- 309 (A)
 PR8                 310- 313 (A)
 PR9                 314- 317 (A)
 PR10                318- 321 (A)
 PRV2                322- 324
 PRV3                325- 327
 PRV4                328- 330
 PRV5                331- 333
 PRV6                334- 336
 PRV7                337- 339
 PRV8                340- 342
 PRV9                343- 345
 PRV10               346- 348
 PCCHPR2             349- 352
 PCCHPR3             353- 356
 PCCHPR4             357- 360
 PCCHPR5             361- 364
 PCCHPR6             365- 368
 PCCHPR7             369- 372
 PCCHPR8             373- 376
 PCCHPR9             377- 380
 PCCHPR10            381- 384
 ZIP                 385- 389 (A)
 PAY1_X              390     (A)
 CHG1                391- 402
 CHG2                403- 414
 CHG3                415- 426
 CHG4                427- 438
 CHG5                439- 450
 CHG6                451- 462
 CHG7                463- 474
 CHG8                475- 486
 CHG9                487- 498
 CHG10               499- 510
 CHG11               511- 522
 CHG12               523- 534
 CHG13               535- 546
 CHG14               547- 558
 CHG15               559- 570
 CHG16               571- 582
 CHG17               583- 594
 CHG18               595- 606
 CHG19               607- 618
 CHG20               619- 630
 CHG21               631- 642
 CHG22               643- 654
 CHG23               655- 666
 CHG24               667- 678.


***  Specify write formats  ***.
FORMATS
 AGE                 (F3.0) /
 SEX                 (F3.0) /
 RACE                (F3.0) /
 DQTR                (F3.0) /
 LOS                 (F4.0) /
 DISP                (F3.0) /
 DIED                (F3.0) /
 ATYPE               (F3.0) /
 ASOURCE             (F3.0) /
 NDX                 (F3.0) /
 DXV1                (F3.0) /
 DCCHPR1             (F3.0) /
 NPR                 (F3.0) /
 PRV1                (F3.0) /
 PCCHPR1             (F3.0) /
 DRG                 (F3.0) /
 MDC                 (F3.0) /
 DRGVER              (F3.0) /
 DRG10               (F3.0) /
 MDC10               (F3.0) /
 PAY1                (F3.0) /
 TOTCHG              (F6.0) /
 YEAR                (F3.0) /
 DSTYPE              (F3.0) /
 LOS_X               (F3.0) /
 NEOMAT              (F3.0) /
 DXSYS               (F3.0) /
 DSNDX               (F3.0) /
 PRSYS               (F3.0) /
 DSNPR               (F3.0) /
 PRDAY1              (F3.0) /
 PAY1_N              (F3.0) /
 TOTCHG_X            (F6.2) /
 DXV2                (F3.0) /
 DXV3                (F3.0) /
 DXV4                (F3.0) /
 DXV5                (F3.0) /
 DXV6                (F3.0) /
 DXV7                (F3.0) /
 DXV8                (F3.0) /
 DXV9                (F3.0) /
 DXV10               (F3.0) /
 DCCHPR2             (F3.0) /
 DCCHPR3             (F3.0) /
 DCCHPR4             (F3.0) /
 DCCHPR5             (F3.0) /
 DCCHPR6             (F3.0) /
 DCCHPR7             (F3.0) /
 DCCHPR8             (F3.0) /
 DCCHPR9             (F3.0) /
 DCCHPR10            (F3.0) /
 PRV2                (F3.0) /
 PRV3                (F3.0) /
 PRV4                (F3.0) /
 PRV5                (F3.0) /
 PRV6                (F3.0) /
 PRV7                (F3.0) /
 PRV8                (F3.0) /
 PRV9                (F3.0) /
 PRV10               (F3.0) /
 PCCHPR2             (F3.0) /
 PCCHPR3             (F3.0) /
 PCCHPR4             (F3.0) /
 PCCHPR5             (F3.0) /
 PCCHPR6             (F3.0) /
 PCCHPR7             (F3.0) /
 PCCHPR8             (F3.0) /
 PCCHPR9             (F3.0) /
 PCCHPR10            (F3.0) /
 CHG1                (F6.2) /
 CHG2                (F6.2) /
 CHG3                (F6.2) /
 CHG4                (F6.2) /
 CHG5                (F6.2) /
 CHG6                (F6.2) /
 CHG7                (F6.2) /
 CHG8                (F6.2) /
 CHG9                (F6.2) /
 CHG10               (F6.2) /
 CHG11               (F6.2) /
 CHG12               (F6.2) /
 CHG13               (F6.2) /
 CHG14               (F6.2) /
 CHG15               (F6.2) /
 CHG16               (F6.2) /
 CHG17               (F6.2) /
 CHG18               (F6.2) /
 CHG19               (F6.2) /
 CHG20               (F6.2) /
 CHG21               (F6.2) /
 CHG22               (F6.2) /
 CHG23               (F6.2) /
 CHG24               (F6.2) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "I:Age in years at admission"
 SEX       "I:Sex"
 RACE      "I:Race"
 DQTR      "I:Discharge quarter"
 LOS       "I:Length of stay (cleaned)"
 DISP      "I:Disposition of patient"
 DIED      "I:Died during hospitalization"
 ATYPE     "I:Admission type"
 ASOURCE   "I:Admission source"
 NDX       "I:Number of diagnoses on this discharge"
 DX1       "I:Principal diagnosis"
 DXV1      "I:Validity flag: principal diagnosis"
 DCCHPR1   "I:CCHPR: principal diagnosis"
 NPR       "I:Number of procedures on this discharge"
 PR1       "I:Principal procedure"
 PRV1      "I:Validity flag: principal procedure"
 PCCHPR1   "I:CCHPR: principal procedure"
 DRG       "I:DRG in effect on discharge date"
 MDC       "I:MDC in effect on discharge date"
 DRGVER    "I:DRG grouper version used on disch date"
 DRG10     "I:DRG, Version 10"
 MDC10     "I:MDC, Version 10"
 PAY1      "I:Primary expected payer, uniform"
 TOTCHG    "I:Total charges (cleaned)"
 YEAR      "Calendar year"
 DSHOSPID  "I:Data source hospital ID number"
 DSTYPE    "I:Data source type"
 HOSPST    "Hospital state postal code"
 MDID_S    "I:Attending physician number (synthetic)"
 SURGID_S  "I:Primary surgeon number (synthetic)"
 LOS_X     "I:Length of stay (uncleaned)"
 NEOMAT    "I:Neonatal and/or maternal DX and/or PR"
 DXSYS     "I:Diagnosis coding system"
 DSNDX     "I:Max number of diagnoses from source"
 PRSYS     "I:Procedure coding system"
 DSNPR     "I:Max number of procedures from source"
 PRDAY1    "I:No. of days from admission to PR1"
 PAY1_N    "I:Primary expected payer, nonuniform"
 TOTCHG_X  "I:Total charges (from data source)"
 DX2       "I:Diagnosis 2"
 DX3       "I:Diagnosis 3"
 DX4       "I:Diagnosis 4"
 DX5       "I:Diagnosis 5"
 DX6       "I:Diagnosis 6"
 DX7       "I:Diagnosis 7"
 DX8       "I:Diagnosis 8"
 DX9       "I:Diagnosis 9"
 DX10      "I:Diagnosis 10"
 DXV2      "I:Validity flag: diagnosis 2"
 DXV3      "I:Validity flag: diagnosis 3"
 DXV4      "I:Validity flag: diagnosis 4"
 DXV5      "I:Validity flag: diagnosis 5"
 DXV6      "I:Validity flag: diagnosis 6"
 DXV7      "I:Validity flag: diagnosis 7"
 DXV8      "I:Validity flag: diagnosis 8"
 DXV9      "I:Validity flag: diagnosis 9"
 DXV10     "I:Validity flag: diagnosis 10"
 DCCHPR2   "I:CCHPR: diagnosis 2"
 DCCHPR3   "I:CCHPR: diagnosis 3"
 DCCHPR4   "I:CCHPR: diagnosis 4"
 DCCHPR5   "I:CCHPR: diagnosis 5"
 DCCHPR6   "I:CCHPR: diagnosis 6"
 DCCHPR7   "I:CCHPR: diagnosis 7"
 DCCHPR8   "I:CCHPR: diagnosis 8"
 DCCHPR9   "I:CCHPR: diagnosis 9"
 DCCHPR10  "I:CCHPR: diagnosis 10"
 PR2       "I:Procedure 2"
 PR3       "I:Procedure 3"
 PR4       "I:Procedure 4"
 PR5       "I:Procedure 5"
 PR6       "I:Procedure 6"
 PR7       "I:Procedure 7"
 PR8       "I:Procedure 8"
 PR9       "I:Procedure 9"
 PR10      "I:Procedure 10"
 PRV2      "I:Validity flag: procedure 2"
 PRV3      "I:Validity flag: procedure 3"
 PRV4      "I:Validity flag: procedure 4"
 PRV5      "I:Validity flag: procedure 5"
 PRV6      "I:Validity flag: procedure 6"
 PRV7      "I:Validity flag: procedure 7"
 PRV8      "I:Validity flag: procedure 8"
 PRV9      "I:Validity flag: procedure 9"
 PRV10     "I:Validity flag: procedure 10"
 PCCHPR2   "I:CCHPR: procedure 2"
 PCCHPR3   "I:CCHPR: procedure 3"
 PCCHPR4   "I:CCHPR: procedure 4"
 PCCHPR5   "I:CCHPR: procedure 5"
 PCCHPR6   "I:CCHPR: procedure 6"
 PCCHPR7   "I:CCHPR: procedure 7"
 PCCHPR8   "I:CCHPR: procedure 8"
 PCCHPR9   "I:CCHPR: procedure 9"
 PCCHPR10  "I:CCHPR: procedure 10"
 ZIP       "I:Patient zip code"
 PAY1_X    "I:Primary exp. payer (from data source)"
 CHG1      "I:Detailed charges 1 (from data source)"
 CHG2      "I:Detailed charges 2 (from data source)"
 CHG3      "I:Detailed charges 3 (from data source)"
 CHG4      "I:Detailed charges 4 (from data source)"
 CHG5      "I:Detailed charges 5 (from data source)"
 CHG6      "I:Detailed charges 6 (from data source)"
 CHG7      "I:Detailed charges 7 (from data source)"
 CHG8      "I:Detailed charges 8 (from data source)"
 CHG9      "I:Detailed charges 9 (from data source)"
 CHG10     "I:Detailed charges 10 (from data source)"
 CHG11     "I:Detailed charges 11 (from data source)"
 CHG12     "I:Detailed charges 12 (from data source)"
 CHG13     "I:Detailed charges 13 (from data source)"
 CHG14     "I:Detailed charges 14 (from data source)"
 CHG15     "I:Detailed charges 15 (from data source)"
 CHG16     "I:Detailed charges 16 (from data source)"
 CHG17     "I:Detailed charges 17 (from data source)"
 CHG18     "I:Detailed charges 18 (from data source)"
 CHG19     "I:Detailed charges 19 (from data source)"
 CHG20     "I:Detailed charges 20 (from data source)"
 CHG21     "I:Detailed charges 21 (from data source)"
 CHG22     "I:Detailed charges 22 (from data source)"
 CHG23     "I:Detailed charges 23 (from data source)"
 CHG24     "I:Detailed charges 24 (from data source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE SEX
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE DISP
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE DXV1
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PRV1
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE DSTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS_X
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE DXSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNDX
 (-99,-88,-66,-55=SYSMIS).
RECODE PRSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNPR
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PAY1_N
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG_X
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE DXV2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV10
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRV2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV10
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG4
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG5
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG6
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG7
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG8
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG9
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG10
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG11
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG12
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG13
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG14
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG15
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG16
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG17
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG18
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG19
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG20
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG21
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG22
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG23
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG24
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).



SAVE OUTFILE = 'FL_SID_1993_CORE.SAV' /COMPRESSED.
