/*******************************************************************
*   FL_SID_1994_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'FL_SID_1994_CORE.ASC' FIXED / 
 SEQ_SID               1-  13
 AGE                  14-  16
 SEX                  17-  19
 RACE                 20-  21
 DQTR                 22-  23
 LOS                  24-  28
 DISP                 29-  30
 DIED                 31-  32
 ATYPE                33-  34
 ASOURCE              35-  36
 NDX                  37-  38
 DX1                  39-  43 (A)
 DXV1                 44-  47
 DCCHPR1              48-  51
 NPR                  52-  53
 PR1                  54-  57 (A)
 PRV1                 58-  60
 PCCHPR1              61-  64
 DRG                  65-  67
 MDC                  68-  69
 DRGVER               70-  71
 DRG10                72-  74
 MDC10                75-  76
 PAY1                 77-  78
 TOTCHG               79-  88
 YEAR                 89-  92
 DSHOSPID             93- 105 (A)
 DSTYPE              106- 108
 HOSPST              109- 110 (A)
 MDID_S              111- 126 (A)
 SURGID_S            127- 142 (A)
 LOS_X               143- 147
 NEOMAT              148- 149
 DXSYS               150- 152
 DSNDX               153- 155
 PRSYS               156- 158
 DSNPR               159- 161
 PRDAY1              162- 166
 PAY1_N              167- 169
 TOTCHG_X            170- 181
 DX2                 182- 186 (A)
 DX3                 187- 191 (A)
 DX4                 192- 196 (A)
 DX5                 197- 201 (A)
 DX6                 202- 206 (A)
 DX7                 207- 211 (A)
 DX8                 212- 216 (A)
 DX9                 217- 221 (A)
 DX10                222- 226 (A)
 DXV2                227- 230
 DXV3                231- 234
 DXV4                235- 238
 DXV5                239- 242
 DXV6                243- 246
 DXV7                247- 250
 DXV8                251- 254
 DXV9                255- 258
 DXV10               259- 262
 DCCHPR2             263- 266
 DCCHPR3             267- 270
 DCCHPR4             271- 274
 DCCHPR5             275- 278
 DCCHPR6             279- 282
 DCCHPR7             283- 286
 DCCHPR8             287- 290
 DCCHPR9             291- 294
 DCCHPR10            295- 298
 PR2                 299- 302 (A)
 PR3                 303- 306 (A)
 PR4                 307- 310 (A)
 PR5                 311- 314 (A)
 PR6                 315- 318 (A)
 PR7                 319- 322 (A)
 PR8                 323- 326 (A)
 PR9                 327- 330 (A)
 PR10                331- 334 (A)
 PRV2                335- 337
 PRV3                338- 340
 PRV4                341- 343
 PRV5                344- 346
 PRV6                347- 349
 PRV7                350- 352
 PRV8                353- 355
 PRV9                356- 358
 PRV10               359- 361
 PCCHPR2             362- 365
 PCCHPR3             366- 369
 PCCHPR4             370- 373
 PCCHPR5             374- 377
 PCCHPR6             378- 381
 PCCHPR7             382- 385
 PCCHPR8             386- 389
 PCCHPR9             390- 393
 PCCHPR10            394- 397
 ZIP                 398- 402 (A)
 PAY1_X              403     (A).


***  Specify write formats  ***.
FORMATS
 SEQ_SID             (F7.0) /
 AGE                 (F3.0) /
 SEX                 (F3.0) /
 RACE                (F3.0) /
 DQTR                (F3.0) /
 LOS                 (F4.0) /
 DISP                (F3.0) /
 DIED                (F3.0) /
 ATYPE               (F3.0) /
 ASOURCE             (F3.0) /
 NDX                 (F3.0) /
 DXV1                (F3.0) /
 DCCHPR1             (F3.0) /
 NPR                 (F3.0) /
 PRV1                (F3.0) /
 PCCHPR1             (F3.0) /
 DRG                 (F3.0) /
 MDC                 (F3.0) /
 DRGVER              (F3.0) /
 DRG10               (F3.0) /
 MDC10               (F3.0) /
 PAY1                (F3.0) /
 TOTCHG              (F6.0) /
 YEAR                (F3.0) /
 DSTYPE              (F3.0) /
 LOS_X               (F4.0) /
 NEOMAT              (F3.0) /
 DXSYS               (F3.0) /
 DSNDX               (F3.0) /
 PRSYS               (F3.0) /
 DSNPR               (F3.0) /
 PRDAY1              (F4.0) /
 PAY1_N              (F3.0) /
 TOTCHG_X            (F6.2) /
 DXV2                (F3.0) /
 DXV3                (F3.0) /
 DXV4                (F3.0) /
 DXV5                (F3.0) /
 DXV6                (F3.0) /
 DXV7                (F3.0) /
 DXV8                (F3.0) /
 DXV9                (F3.0) /
 DXV10               (F3.0) /
 DCCHPR2             (F3.0) /
 DCCHPR3             (F3.0) /
 DCCHPR4             (F3.0) /
 DCCHPR5             (F3.0) /
 DCCHPR6             (F3.0) /
 DCCHPR7             (F3.0) /
 DCCHPR8             (F3.0) /
 DCCHPR9             (F3.0) /
 DCCHPR10            (F3.0) /
 PRV2                (F3.0) /
 PRV3                (F3.0) /
 PRV4                (F3.0) /
 PRV5                (F3.0) /
 PRV6                (F3.0) /
 PRV7                (F3.0) /
 PRV8                (F3.0) /
 PRV9                (F3.0) /
 PRV10               (F3.0) /
 PCCHPR2             (F3.0) /
 PCCHPR3             (F3.0) /
 PCCHPR4             (F3.0) /
 PCCHPR5             (F3.0) /
 PCCHPR6             (F3.0) /
 PCCHPR7             (F3.0) /
 PCCHPR8             (F3.0) /
 PCCHPR9             (F3.0) /
 PCCHPR10            (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 SEQ_SID   "I:HCUP-3 SID record sequence number"
 AGE       "I:Age in years at admission"
 SEX       "I:Sex"
 RACE      "I:Race"
 DQTR      "I:Discharge quarter"
 LOS       "I:Length of stay (cleaned)"
 DISP      "I:Disposition of patient"
 DIED      "I:Died during hospitalization"
 ATYPE     "I:Admission type"
 ASOURCE   "I:Admission source"
 NDX       "I:Number of diagnoses on this discharge"
 DX1       "I:Principal diagnosis"
 DXV1      "I:Validity flag: principal diagnosis"
 DCCHPR1   "I:CCHPR: principal diagnosis"
 NPR       "I:Number of procedures on this discharge"
 PR1       "I:Principal procedure"
 PRV1      "I:Validity flag: principal procedure"
 PCCHPR1   "I:CCHPR: principal procedure"
 DRG       "I:DRG in effect on discharge date"
 MDC       "I:MDC in effect on discharge date"
 DRGVER    "I:DRG grouper version used on disch date"
 DRG10     "I:DRG, Version 10"
 MDC10     "I:MDC, Version 10"
 PAY1      "I:Primary expected payer, uniform"
 TOTCHG    "I:Total charges (cleaned)"
 YEAR      "Calendar year"
 DSHOSPID  "I:Data source hospital ID number"
 DSTYPE    "I:Data source type"
 HOSPST    "Hospital state postal code"
 MDID_S    "I:Attending physician number (synthetic)"
 SURGID_S  "I:Primary surgeon number (synthetic)"
 LOS_X     "I:Length of stay (uncleaned)"
 NEOMAT    "I:Neonatal and/or maternal DX and/or PR"
 DXSYS     "I:Diagnosis coding system"
 DSNDX     "I:Max number of diagnoses from source"
 PRSYS     "I:Procedure coding system"
 DSNPR     "I:Max number of procedures from source"
 PRDAY1    "I:No. of days from admission to PR1"
 PAY1_N    "I:Primary expected payer, nonuniform"
 TOTCHG_X  "I:Total charges (from data source)"
 DX2       "I:Diagnosis 2"
 DX3       "I:Diagnosis 3"
 DX4       "I:Diagnosis 4"
 DX5       "I:Diagnosis 5"
 DX6       "I:Diagnosis 6"
 DX7       "I:Diagnosis 7"
 DX8       "I:Diagnosis 8"
 DX9       "I:Diagnosis 9"
 DX10      "I:Diagnosis 10"
 DXV2      "I:Validity flag: diagnosis 2"
 DXV3      "I:Validity flag: diagnosis 3"
 DXV4      "I:Validity flag: diagnosis 4"
 DXV5      "I:Validity flag: diagnosis 5"
 DXV6      "I:Validity flag: diagnosis 6"
 DXV7      "I:Validity flag: diagnosis 7"
 DXV8      "I:Validity flag: diagnosis 8"
 DXV9      "I:Validity flag: diagnosis 9"
 DXV10     "I:Validity flag: diagnosis 10"
 DCCHPR2   "I:CCHPR: diagnosis 2"
 DCCHPR3   "I:CCHPR: diagnosis 3"
 DCCHPR4   "I:CCHPR: diagnosis 4"
 DCCHPR5   "I:CCHPR: diagnosis 5"
 DCCHPR6   "I:CCHPR: diagnosis 6"
 DCCHPR7   "I:CCHPR: diagnosis 7"
 DCCHPR8   "I:CCHPR: diagnosis 8"
 DCCHPR9   "I:CCHPR: diagnosis 9"
 DCCHPR10  "I:CCHPR: diagnosis 10"
 PR2       "I:Procedure 2"
 PR3       "I:Procedure 3"
 PR4       "I:Procedure 4"
 PR5       "I:Procedure 5"
 PR6       "I:Procedure 6"
 PR7       "I:Procedure 7"
 PR8       "I:Procedure 8"
 PR9       "I:Procedure 9"
 PR10      "I:Procedure 10"
 PRV2      "I:Validity flag: procedure 2"
 PRV3      "I:Validity flag: procedure 3"
 PRV4      "I:Validity flag: procedure 4"
 PRV5      "I:Validity flag: procedure 5"
 PRV6      "I:Validity flag: procedure 6"
 PRV7      "I:Validity flag: procedure 7"
 PRV8      "I:Validity flag: procedure 8"
 PRV9      "I:Validity flag: procedure 9"
 PRV10     "I:Validity flag: procedure 10"
 PCCHPR2   "I:CCHPR: procedure 2"
 PCCHPR3   "I:CCHPR: procedure 3"
 PCCHPR4   "I:CCHPR: procedure 4"
 PCCHPR5   "I:CCHPR: procedure 5"
 PCCHPR6   "I:CCHPR: procedure 6"
 PCCHPR7   "I:CCHPR: procedure 7"
 PCCHPR8   "I:CCHPR: procedure 8"
 PCCHPR9   "I:CCHPR: procedure 9"
 PCCHPR10  "I:CCHPR: procedure 10"
 ZIP       "I:Patient zip code"
 PAY1_X    "I:Primary exp. payer (from data source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE SEX
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE DISP
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE DXV1
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PRV1
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE DSTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS_X
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE DXSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNDX
 (-99,-88,-66,-55=SYSMIS).
RECODE PRSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNPR
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PAY1_N
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG_X
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE DXV2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV10
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRV2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV10
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR10
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'FL_SID_1994_CORE.SAV' /COMPRESSED.
