/*******************************************************************
*   FL_SID_2011_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'FL_SID_2011_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRON11                   21-  22
 CHRON12                   23-  24
 CHRON13                   25-  26
 CHRON14                   27-  28
 CHRON15                   29-  30
 CHRON16                   31-  32
 CHRON17                   33-  34
 CHRON18                   35-  36
 CHRON19                   37-  38
 CHRON20                   39-  40
 CHRON21                   41-  42
 CHRON22                   43-  44
 CHRON23                   45-  46
 CHRON24                   47-  48
 CHRON25                   49-  50
 CHRON26                   51-  52
 CHRON27                   53-  54
 CHRON28                   55-  56
 CHRON29                   57-  58
 CHRON30                   59-  60
 CHRON31                   61-  62
 CHRONB1                   63-  64
 CHRONB2                   65-  66
 CHRONB3                   67-  68
 CHRONB4                   69-  70
 CHRONB5                   71-  72
 CHRONB6                   73-  74
 CHRONB7                   75-  76
 CHRONB8                   77-  78
 CHRONB9                   79-  80
 CHRONB10                  81-  82
 CHRONB11                  83-  84
 CHRONB12                  85-  86
 CHRONB13                  87-  88
 CHRONB14                  89-  90
 CHRONB15                  91-  92
 CHRONB16                  93-  94
 CHRONB17                  95-  96
 CHRONB18                  97-  98
 CHRONB19                  99- 100
 CHRONB20                 101- 102
 CHRONB21                 103- 104
 CHRONB22                 105- 106
 CHRONB23                 107- 108
 CHRONB24                 109- 110
 CHRONB25                 111- 112
 CHRONB26                 113- 114
 CHRONB27                 115- 116
 CHRONB28                 117- 118
 CHRONB29                 119- 120
 CHRONB30                 121- 122
 CHRONB31                 123- 124
 DXMCCS1                  125- 135 (A)
 DXMCCS2                  136- 146 (A)
 DXMCCS3                  147- 157 (A)
 DXMCCS4                  158- 168 (A)
 DXMCCS5                  169- 179 (A)
 DXMCCS6                  180- 190 (A)
 DXMCCS7                  191- 201 (A)
 DXMCCS8                  202- 212 (A)
 DXMCCS9                  213- 223 (A)
 DXMCCS10                 224- 234 (A)
 DXMCCS11                 235- 245 (A)
 DXMCCS12                 246- 256 (A)
 DXMCCS13                 257- 267 (A)
 DXMCCS14                 268- 278 (A)
 DXMCCS15                 279- 289 (A)
 DXMCCS16                 290- 300 (A)
 DXMCCS17                 301- 311 (A)
 DXMCCS18                 312- 322 (A)
 DXMCCS19                 323- 333 (A)
 DXMCCS20                 334- 344 (A)
 DXMCCS21                 345- 355 (A)
 DXMCCS22                 356- 366 (A)
 DXMCCS23                 367- 377 (A)
 DXMCCS24                 378- 388 (A)
 DXMCCS25                 389- 399 (A)
 DXMCCS26                 400- 410 (A)
 DXMCCS27                 411- 421 (A)
 DXMCCS28                 422- 432 (A)
 DXMCCS29                 433- 443 (A)
 DXMCCS30                 444- 454 (A)
 DXMCCS31                 455- 465 (A)
 E_MCCS1                  466- 476 (A)
 E_MCCS2                  477- 487 (A)
 E_MCCS3                  488- 498 (A)
 INJURY                   499- 500
 INJURY_CUT               501- 502
 INJURY_DROWN             503- 504
 INJURY_FALL              505- 506
 INJURY_FIRE              507- 508
 INJURY_FIREARM           509- 510
 INJURY_MACHINERY         511- 512
 INJURY_MVT               513- 514
 INJURY_NATURE            515- 516
 INJURY_POISON            517- 518
 INJURY_STRUCK            519- 520
 INJURY_SUFFOCATION       521- 522
 INTENT_ASSAULT           523- 524
 INTENT_SELF_HARM         525- 526
 INTENT_UNINTENTIONAL     527- 528
 KEY                      529- 546
 MULTINJURY               547- 548
 PCLASS1                  549- 550
 PCLASS2                  551- 552
 PCLASS3                  553- 554
 PCLASS4                  555- 556
 PCLASS5                  557- 558
 PCLASS6                  559- 560
 PCLASS7                  561- 562
 PCLASS8                  563- 564
 PCLASS9                  565- 566
 PCLASS10                 567- 568
 PCLASS11                 569- 570
 PCLASS12                 571- 572
 PCLASS13                 573- 574
 PCLASS14                 575- 576
 PCLASS15                 577- 578
 PCLASS16                 579- 580
 PCLASS17                 581- 582
 PCLASS18                 583- 584
 PCLASS19                 585- 586
 PCLASS20                 587- 588
 PCLASS21                 589- 590
 PCLASS22                 591- 592
 PCLASS23                 593- 594
 PCLASS24                 595- 596
 PCLASS25                 597- 598
 PCLASS26                 599- 600
 PCLASS27                 601- 602
 PCLASS28                 603- 604
 PCLASS29                 605- 606
 PCLASS30                 607- 608
 PCLASS31                 609- 610
 PRMCCS1                  611- 618 (A)
 PRMCCS2                  619- 626 (A)
 PRMCCS3                  627- 634 (A)
 PRMCCS4                  635- 642 (A)
 PRMCCS5                  643- 650 (A)
 PRMCCS6                  651- 658 (A)
 PRMCCS7                  659- 666 (A)
 PRMCCS8                  667- 674 (A)
 PRMCCS9                  675- 682 (A)
 PRMCCS10                 683- 690 (A)
 PRMCCS11                 691- 698 (A)
 PRMCCS12                 699- 706 (A)
 PRMCCS13                 707- 714 (A)
 PRMCCS14                 715- 722 (A)
 PRMCCS15                 723- 730 (A)
 PRMCCS16                 731- 738 (A)
 PRMCCS17                 739- 746 (A)
 PRMCCS18                 747- 754 (A)
 PRMCCS19                 755- 762 (A)
 PRMCCS20                 763- 770 (A)
 PRMCCS21                 771- 778 (A)
 PRMCCS22                 779- 786 (A)
 PRMCCS23                 787- 794 (A)
 PRMCCS24                 795- 802 (A)
 PRMCCS25                 803- 810 (A)
 PRMCCS26                 811- 818 (A)
 PRMCCS27                 819- 826 (A)
 PRMCCS28                 827- 834 (A)
 PRMCCS29                 835- 842 (A)
 PRMCCS30                 843- 850 (A)
 PRMCCS31                 851- 858 (A).


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRON11                 (F3.0) /
 CHRON12                 (F3.0) /
 CHRON13                 (F3.0) /
 CHRON14                 (F3.0) /
 CHRON15                 (F3.0) /
 CHRON16                 (F3.0) /
 CHRON17                 (F3.0) /
 CHRON18                 (F3.0) /
 CHRON19                 (F3.0) /
 CHRON20                 (F3.0) /
 CHRON21                 (F3.0) /
 CHRON22                 (F3.0) /
 CHRON23                 (F3.0) /
 CHRON24                 (F3.0) /
 CHRON25                 (F3.0) /
 CHRON26                 (F3.0) /
 CHRON27                 (F3.0) /
 CHRON28                 (F3.0) /
 CHRON29                 (F3.0) /
 CHRON30                 (F3.0) /
 CHRON31                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 CHRONB11                (F3.0) /
 CHRONB12                (F3.0) /
 CHRONB13                (F3.0) /
 CHRONB14                (F3.0) /
 CHRONB15                (F3.0) /
 CHRONB16                (F3.0) /
 CHRONB17                (F3.0) /
 CHRONB18                (F3.0) /
 CHRONB19                (F3.0) /
 CHRONB20                (F3.0) /
 CHRONB21                (F3.0) /
 CHRONB22                (F3.0) /
 CHRONB23                (F3.0) /
 CHRONB24                (F3.0) /
 CHRONB25                (F3.0) /
 CHRONB26                (F3.0) /
 CHRONB27                (F3.0) /
 CHRONB28                (F3.0) /
 CHRONB29                (F3.0) /
 CHRONB30                (F3.0) /
 CHRONB31                (F3.0) /
 INJURY                  (F3.0) /
 INJURY_CUT              (F3.0) /
 INJURY_DROWN            (F3.0) /
 INJURY_FALL             (F3.0) /
 INJURY_FIRE             (F3.0) /
 INJURY_FIREARM          (F3.0) /
 INJURY_MACHINERY        (F3.0) /
 INJURY_MVT              (F3.0) /
 INJURY_NATURE           (F3.0) /
 INJURY_POISON           (F3.0) /
 INJURY_STRUCK           (F3.0) /
 INJURY_SUFFOCATION      (F3.0) /
 INTENT_ASSAULT          (F3.0) /
 INTENT_SELF_HARM        (F3.0) /
 INTENT_UNINTENTIONAL    (F3.0) /
 KEY                     (F8.0) /
 MULTINJURY              (F3.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
 PCLASS7                 (F3.0) /
 PCLASS8                 (F3.0) /
 PCLASS9                 (F3.0) /
 PCLASS10                (F3.0) /
 PCLASS11                (F3.0) /
 PCLASS12                (F3.0) /
 PCLASS13                (F3.0) /
 PCLASS14                (F3.0) /
 PCLASS15                (F3.0) /
 PCLASS16                (F3.0) /
 PCLASS17                (F3.0) /
 PCLASS18                (F3.0) /
 PCLASS19                (F3.0) /
 PCLASS20                (F3.0) /
 PCLASS21                (F3.0) /
 PCLASS22                (F3.0) /
 PCLASS23                (F3.0) /
 PCLASS24                (F3.0) /
 PCLASS25                (F3.0) /
 PCLASS26                (F3.0) /
 PCLASS27                (F3.0) /
 PCLASS28                (F3.0) /
 PCLASS29                (F3.0) /
 PCLASS30                (F3.0) /
 PCLASS31                (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                  "Chronic condition indicator 1"
 CHRON2                  "Chronic condition indicator 2"
 CHRON3                  "Chronic condition indicator 3"
 CHRON4                  "Chronic condition indicator 4"
 CHRON5                  "Chronic condition indicator 5"
 CHRON6                  "Chronic condition indicator 6"
 CHRON7                  "Chronic condition indicator 7"
 CHRON8                  "Chronic condition indicator 8"
 CHRON9                  "Chronic condition indicator 9"
 CHRON10                 "Chronic condition indicator 10"
 CHRON11                 "Chronic condition indicator 11"
 CHRON12                 "Chronic condition indicator 12"
 CHRON13                 "Chronic condition indicator 13"
 CHRON14                 "Chronic condition indicator 14"
 CHRON15                 "Chronic condition indicator 15"
 CHRON16                 "Chronic condition indicator 16"
 CHRON17                 "Chronic condition indicator 17"
 CHRON18                 "Chronic condition indicator 18"
 CHRON19                 "Chronic condition indicator 19"
 CHRON20                 "Chronic condition indicator 20"
 CHRON21                 "Chronic condition indicator 21"
 CHRON22                 "Chronic condition indicator 22"
 CHRON23                 "Chronic condition indicator 23"
 CHRON24                 "Chronic condition indicator 24"
 CHRON25                 "Chronic condition indicator 25"
 CHRON26                 "Chronic condition indicator 26"
 CHRON27                 "Chronic condition indicator 27"
 CHRON28                 "Chronic condition indicator 28"
 CHRON29                 "Chronic condition indicator 29"
 CHRON30                 "Chronic condition indicator 30"
 CHRON31                 "Chronic condition indicator 31"
 CHRONB1                 "Chronic condition body system 1"
 CHRONB2                 "Chronic condition body system 2"
 CHRONB3                 "Chronic condition body system 3"
 CHRONB4                 "Chronic condition body system 4"
 CHRONB5                 "Chronic condition body system 5"
 CHRONB6                 "Chronic condition body system 6"
 CHRONB7                 "Chronic condition body system 7"
 CHRONB8                 "Chronic condition body system 8"
 CHRONB9                 "Chronic condition body system 9"
 CHRONB10                "Chronic condition body system 10"
 CHRONB11                "Chronic condition body system 11"
 CHRONB12                "Chronic condition body system 12"
 CHRONB13                "Chronic condition body system 13"
 CHRONB14                "Chronic condition body system 14"
 CHRONB15                "Chronic condition body system 15"
 CHRONB16                "Chronic condition body system 16"
 CHRONB17                "Chronic condition body system 17"
 CHRONB18                "Chronic condition body system 18"
 CHRONB19                "Chronic condition body system 19"
 CHRONB20                "Chronic condition body system 20"
 CHRONB21                "Chronic condition body system 21"
 CHRONB22                "Chronic condition body system 22"
 CHRONB23                "Chronic condition body system 23"
 CHRONB24                "Chronic condition body system 24"
 CHRONB25                "Chronic condition body system 25"
 CHRONB26                "Chronic condition body system 26"
 CHRONB27                "Chronic condition body system 27"
 CHRONB28                "Chronic condition body system 28"
 CHRONB29                "Chronic condition body system 29"
 CHRONB30                "Chronic condition body system 30"
 CHRONB31                "Chronic condition body system 31"
 DXMCCS1                 "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                 "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                 "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                 "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                 "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                 "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                 "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                 "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                 "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                "Multi-Level CCS:  Diagnosis 31"
 E_MCCS1                 "Multi-Level CCS:  E Code 1"
 E_MCCS2                 "Multi-Level CCS:  E Code 2"
 E_MCCS3                 "Multi-Level CCS:  E Code 3"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT              "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN            "Injury by drowning or submersion (by E codes)"
 INJURY_FALL             "Injury by falling (by E codes)"
 INJURY_FIRE             "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM          "Injury by firearm (by E codes)"
 INJURY_MACHINERY        "Injury by machinery (by E codes)"
 INJURY_MVT              "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE           "Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON           "Injury by poison (by E codes)"
 INJURY_STRUCK           "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION      "Injury by suffocation (by E codes)"
 INTENT_ASSAULT          "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL    "Unintentional injury indicated on the record (by E codes)"
 KEY                     "HCUP record identifier"
 MULTINJURY              "More than one injury diagnosis reported on record"
 PCLASS1                 "Procedure class 1"
 PCLASS2                 "Procedure class 2"
 PCLASS3                 "Procedure class 3"
 PCLASS4                 "Procedure class 4"
 PCLASS5                 "Procedure class 5"
 PCLASS6                 "Procedure class 6"
 PCLASS7                 "Procedure class 7"
 PCLASS8                 "Procedure class 8"
 PCLASS9                 "Procedure class 9"
 PCLASS10                "Procedure class 10"
 PCLASS11                "Procedure class 11"
 PCLASS12                "Procedure class 12"
 PCLASS13                "Procedure class 13"
 PCLASS14                "Procedure class 14"
 PCLASS15                "Procedure class 15"
 PCLASS16                "Procedure class 16"
 PCLASS17                "Procedure class 17"
 PCLASS18                "Procedure class 18"
 PCLASS19                "Procedure class 19"
 PCLASS20                "Procedure class 20"
 PCLASS21                "Procedure class 21"
 PCLASS22                "Procedure class 22"
 PCLASS23                "Procedure class 23"
 PCLASS24                "Procedure class 24"
 PCLASS25                "Procedure class 25"
 PCLASS26                "Procedure class 26"
 PCLASS27                "Procedure class 27"
 PCLASS28                "Procedure class 28"
 PCLASS29                "Procedure class 29"
 PCLASS30                "Procedure class 30"
 PCLASS31                "Procedure class 31"
 PRMCCS1                 "Multi-Level CCS:  Procedure 1"
 PRMCCS2                 "Multi-Level CCS:  Procedure 2"
 PRMCCS3                 "Multi-Level CCS:  Procedure 3"
 PRMCCS4                 "Multi-Level CCS:  Procedure 4"
 PRMCCS5                 "Multi-Level CCS:  Procedure 5"
 PRMCCS6                 "Multi-Level CCS:  Procedure 6"
 PRMCCS7                 "Multi-Level CCS:  Procedure 7"
 PRMCCS8                 "Multi-Level CCS:  Procedure 8"
 PRMCCS9                 "Multi-Level CCS:  Procedure 9"
 PRMCCS10                "Multi-Level CCS:  Procedure 10"
 PRMCCS11                "Multi-Level CCS:  Procedure 11"
 PRMCCS12                "Multi-Level CCS:  Procedure 12"
 PRMCCS13                "Multi-Level CCS:  Procedure 13"
 PRMCCS14                "Multi-Level CCS:  Procedure 14"
 PRMCCS15                "Multi-Level CCS:  Procedure 15"
 PRMCCS16                "Multi-Level CCS:  Procedure 16"
 PRMCCS17                "Multi-Level CCS:  Procedure 17"
 PRMCCS18                "Multi-Level CCS:  Procedure 18"
 PRMCCS19                "Multi-Level CCS:  Procedure 19"
 PRMCCS20                "Multi-Level CCS:  Procedure 20"
 PRMCCS21                "Multi-Level CCS:  Procedure 21"
 PRMCCS22                "Multi-Level CCS:  Procedure 22"
 PRMCCS23                "Multi-Level CCS:  Procedure 23"
 PRMCCS24                "Multi-Level CCS:  Procedure 24"
 PRMCCS25                "Multi-Level CCS:  Procedure 25"
 PRMCCS26                "Multi-Level CCS:  Procedure 26"
 PRMCCS27                "Multi-Level CCS:  Procedure 27"
 PRMCCS28                "Multi-Level CCS:  Procedure 28"
 PRMCCS29                "Multi-Level CCS:  Procedure 29"
 PRMCCS30                "Multi-Level CCS:  Procedure 30"
 PRMCCS31                "Multi-Level CCS:  Procedure 31" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB31
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS26
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS27
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS28
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS29
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS30
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS31
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'FL_SID_2011_DX_PR_GRPS.SAV' /COMPRESSED.
