/*******************************************************************
* Creation Date: 07/25/2018   
*   GA_SID_2016_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'GA_SID_2016_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BILLTYPE                       16-  19 (A)
 BWT                            20-  23
 CPT1                           24-  28 (A)
 CPT2                           29-  33 (A)
 CPT3                           34-  38 (A)
 CPT4                           39-  43 (A)
 CPT5                           44-  48 (A)
 CPT6                           49-  53 (A)
 CPT7                           54-  58 (A)
 CPT8                           59-  63 (A)
 CPT9                           64-  68 (A)
 CPT10                          69-  73 (A)
 CPT11                          74-  78 (A)
 CPT12                          79-  83 (A)
 CPT13                          84-  88 (A)
 CPT14                          89-  93 (A)
 CPT15                          94-  98 (A)
 CPT16                          99- 103 (A)
 CPT17                         104- 108 (A)
 CPT18                         109- 113 (A)
 CPT19                         114- 118 (A)
 CPT20                         119- 123 (A)
 CPT21                         124- 128 (A)
 CPT22                         129- 133 (A)
 CPT23                         134- 138 (A)
 CPT24                         139- 143 (A)
 CPT25                         144- 148 (A)
 CPT26                         149- 153 (A)
 CPT27                         154- 158 (A)
 CPT28                         159- 163 (A)
 CPT29                         164- 168 (A)
 CPT30                         169- 173 (A)
 CPT31                         174- 178 (A)
 CPT32                         179- 183 (A)
 CPT33                         184- 188 (A)
 CPT34                         189- 193 (A)
 CPT35                         194- 198 (A)
 CPT36                         199- 203 (A)
 CPT37                         204- 208 (A)
 CPT38                         209- 213 (A)
 CPT39                         214- 218 (A)
 CPT40                         219- 223 (A)
 CPT41                         224- 228 (A)
 CPT42                         229- 233 (A)
 CPT43                         234- 238 (A)
 CPT44                         239- 243 (A)
 CPT45                         244- 248 (A)
 CPT46                         249- 253 (A)
 CPT47                         254- 258 (A)
 CPT48                         259- 263 (A)
 CPT49                         264- 268 (A)
 CPT50                         269- 273 (A)
 CPTCCS1                       274- 276
 CPTCCS2                       277- 279
 CPTCCS3                       280- 282
 CPTCCS4                       283- 285
 CPTCCS5                       286- 288
 CPTCCS6                       289- 291
 CPTCCS7                       292- 294
 CPTCCS8                       295- 297
 CPTCCS9                       298- 300
 CPTCCS10                      301- 303
 CPTCCS11                      304- 306
 CPTCCS12                      307- 309
 CPTCCS13                      310- 312
 CPTCCS14                      313- 315
 CPTCCS15                      316- 318
 CPTCCS16                      319- 321
 CPTCCS17                      322- 324
 CPTCCS18                      325- 327
 CPTCCS19                      328- 330
 CPTCCS20                      331- 333
 CPTCCS21                      334- 336
 CPTCCS22                      337- 339
 CPTCCS23                      340- 342
 CPTCCS24                      343- 345
 CPTCCS25                      346- 348
 CPTCCS26                      349- 351
 CPTCCS27                      352- 354
 CPTCCS28                      355- 357
 CPTCCS29                      358- 360
 CPTCCS30                      361- 363
 CPTCCS31                      364- 366
 CPTCCS32                      367- 369
 CPTCCS33                      370- 372
 CPTCCS34                      373- 375
 CPTCCS35                      376- 378
 CPTCCS36                      379- 381
 CPTCCS37                      382- 384
 CPTCCS38                      385- 387
 CPTCCS39                      388- 390
 CPTCCS40                      391- 393
 CPTCCS41                      394- 396
 CPTCCS42                      397- 399
 CPTCCS43                      400- 402
 CPTCCS44                      403- 405
 CPTCCS45                      406- 408
 CPTCCS46                      409- 411
 CPTCCS47                      412- 414
 CPTCCS48                      415- 417
 CPTCCS49                      418- 420
 CPTCCS50                      421- 423
 DaysToEvent                   424- 429
 DIED                          430- 431
 DISP_X                        432- 433 (A)
 DISPUB04                      434- 435
 DISPUNIFORM                   436- 437
 DMONTH                        438- 439
 DQTR                          440- 441
 DRG                           442- 444
 DRG_NoPOA                     445- 447
 DRGVER                        448- 449
 DXPOA1                        450     (A)
 DXPOA2                        451     (A)
 DXPOA3                        452     (A)
 DXPOA4                        453     (A)
 DXPOA5                        454     (A)
 DXPOA6                        455     (A)
 DXPOA7                        456     (A)
 DXPOA8                        457     (A)
 DXPOA9                        458     (A)
 DXPOA10                       459     (A)
 DXPOA11                       460     (A)
 DXPOA12                       461     (A)
 DXPOA13                       462     (A)
 DXPOA14                       463     (A)
 DXPOA15                       464     (A)
 DXPOA16                       465     (A)
 DXPOA17                       466     (A)
 DXPOA18                       467     (A)
 DXPOA19                       468     (A)
 DXPOA20                       469     (A)
 DXPOA21                       470     (A)
 DXPOA22                       471     (A)
 DXPOA23                       472     (A)
 DXPOA24                       473     (A)
 DXPOA25                       474     (A)
 DXPOA26                       475     (A)
 DXPOA27                       476     (A)
 DXPOA28                       477     (A)
 DXPOA29                       478     (A)
 DXPOA30                       479     (A)
 DXPOA31                       480     (A)
 DXPOA32                       481     (A)
 DXPOA33                       482     (A)
 DXPOA34                       483     (A)
 DXPOA35                       484     (A)
 DXPOA36                       485     (A)
 DXPOA37                       486     (A)
 DXPOA38                       487     (A)
 DXPOA39                       488     (A)
 DXPOA40                       489     (A)
 DXPOA41                       490     (A)
 DXPOA42                       491     (A)
 DXPOA43                       492     (A)
 DXPOA44                       493     (A)
 DXPOA45                       494     (A)
 DXPOA46                       495     (A)
 DXPOA47                       496     (A)
 DXPOA48                       497     (A)
 DXPOA49                       498     (A)
 DXPOA50                       499     (A)
 DXPOA51                       500     (A)
 DXPOA52                       501     (A)
 DXPOA53                       502     (A)
 DXPOA54                       503     (A)
 DXPOA55                       504     (A)
 DXPOA56                       505     (A)
 DXPOA57                       506     (A)
 DXPOA58                       507     (A)
 DXPOA59                       508     (A)
 DXPOA60                       509     (A)
 DXVER                         510- 512
 E_POA1                        513     (A)
 E_POA2                        514     (A)
 E_POA3                        515     (A)
 E_POA4                        516     (A)
 E_POA5                        517     (A)
 E_POA6                        518     (A)
 E_POA7                        519     (A)
 E_POA8                        520     (A)
 FEMALE                        521- 522
 HCUP_ED                       523- 524
 HCUP_OS                       525- 526
 HISPANIC                      527- 528
 HISPANIC_X                    529     (A)
 Homeless                      530- 531
 HOSPST                        532- 533 (A)
 I10_DX1                       534- 540 (A)
 I10_DX2                       541- 547 (A)
 I10_DX3                       548- 554 (A)
 I10_DX4                       555- 561 (A)
 I10_DX5                       562- 568 (A)
 I10_DX6                       569- 575 (A)
 I10_DX7                       576- 582 (A)
 I10_DX8                       583- 589 (A)
 I10_DX9                       590- 596 (A)
 I10_DX10                      597- 603 (A)
 I10_DX11                      604- 610 (A)
 I10_DX12                      611- 617 (A)
 I10_DX13                      618- 624 (A)
 I10_DX14                      625- 631 (A)
 I10_DX15                      632- 638 (A)
 I10_DX16                      639- 645 (A)
 I10_DX17                      646- 652 (A)
 I10_DX18                      653- 659 (A)
 I10_DX19                      660- 666 (A)
 I10_DX20                      667- 673 (A)
 I10_DX21                      674- 680 (A)
 I10_DX22                      681- 687 (A)
 I10_DX23                      688- 694 (A)
 I10_DX24                      695- 701 (A)
 I10_DX25                      702- 708 (A)
 I10_DX26                      709- 715 (A)
 I10_DX27                      716- 722 (A)
 I10_DX28                      723- 729 (A)
 I10_DX29                      730- 736 (A)
 I10_DX30                      737- 743 (A)
 I10_DX31                      744- 750 (A)
 I10_DX32                      751- 757 (A)
 I10_DX33                      758- 764 (A)
 I10_DX34                      765- 771 (A)
 I10_DX35                      772- 778 (A)
 I10_DX36                      779- 785 (A)
 I10_DX37                      786- 792 (A)
 I10_DX38                      793- 799 (A)
 I10_DX39                      800- 806 (A)
 I10_DX40                      807- 813 (A)
 I10_DX41                      814- 820 (A)
 I10_DX42                      821- 827 (A)
 I10_DX43                      828- 834 (A)
 I10_DX44                      835- 841 (A)
 I10_DX45                      842- 848 (A)
 I10_DX46                      849- 855 (A)
 I10_DX47                      856- 862 (A)
 I10_DX48                      863- 869 (A)
 I10_DX49                      870- 876 (A)
 I10_DX50                      877- 883 (A)
 I10_DX51                      884- 890 (A)
 I10_DX52                      891- 897 (A)
 I10_DX53                      898- 904 (A)
 I10_DX54                      905- 911 (A)
 I10_DX55                      912- 918 (A)
 I10_DX56                      919- 925 (A)
 I10_DX57                      926- 932 (A)
 I10_DX58                      933- 939 (A)
 I10_DX59                      940- 946 (A)
 I10_DX60                      947- 953 (A)
 I10_ECAUSE1                   954- 960 (A)
 I10_ECAUSE2                   961- 967 (A)
 I10_ECAUSE3                   968- 974 (A)
 I10_ECAUSE4                   975- 981 (A)
 I10_ECAUSE5                   982- 988 (A)
 I10_ECAUSE6                   989- 995 (A)
 I10_ECAUSE7                   996-1002 (A)
 I10_ECAUSE8                  1003-1009 (A)
 I10_NDX                      1010-1012
 I10_NECAUSE                  1013-1014
 I10_NPR                      1015-1017
 I10_PR1                      1018-1024 (A)
 I10_PR2                      1025-1031 (A)
 I10_PR3                      1032-1038 (A)
 I10_PR4                      1039-1045 (A)
 I10_PR5                      1046-1052 (A)
 I10_PR6                      1053-1059 (A)
 I10_PR7                      1060-1066 (A)
 I10_PR8                      1067-1073 (A)
 I10_PR9                      1074-1080 (A)
 I10_PR10                     1081-1087 (A)
 I10_PR11                     1088-1094 (A)
 I10_PR12                     1095-1101 (A)
 I10_PR13                     1102-1108 (A)
 I10_PR14                     1109-1115 (A)
 I10_PR15                     1116-1122 (A)
 I10_PR16                     1123-1129 (A)
 I10_PR17                     1130-1136 (A)
 I10_PR18                     1137-1143 (A)
 I10_PR19                     1144-1150 (A)
 I10_PR20                     1151-1157 (A)
 I10_PR21                     1158-1164 (A)
 I10_PR22                     1165-1171 (A)
 I10_PR23                     1172-1178 (A)
 I10_PR24                     1179-1185 (A)
 I10_PR25                     1186-1192 (A)
 I10_PR26                     1193-1199 (A)
 I10_PR27                     1200-1206 (A)
 I10_PR28                     1207-1213 (A)
 I10_PR29                     1214-1220 (A)
 I10_PR30                     1221-1227 (A)
 I10_PR31                     1228-1234 (A)
 I10_PR32                     1235-1241 (A)
 I10_PR33                     1242-1248 (A)
 I10_PR34                     1249-1255 (A)
 I10_PR35                     1256-1262 (A)
 I10_PR36                     1263-1269 (A)
 I10_PR37                     1270-1276 (A)
 I10_PR38                     1277-1283 (A)
 I10_PR39                     1284-1290 (A)
 I10_PR40                     1291-1297 (A)
 I10_PR41                     1298-1304 (A)
 I10_PR42                     1305-1311 (A)
 I10_PR43                     1312-1318 (A)
 I10_PR44                     1319-1325 (A)
 I10_PR45                     1326-1332 (A)
 I10_PR46                     1333-1339 (A)
 I10_PR47                     1340-1346 (A)
 I10_PR48                     1347-1353 (A)
 I10_PR49                     1354-1360 (A)
 I10_PR50                     1361-1367 (A)
 I10_PR51                     1368-1374 (A)
 I10_PR52                     1375-1381 (A)
 I10_PR53                     1382-1388 (A)
 I10_PR54                     1389-1395 (A)
 I10_PR55                     1396-1402 (A)
 I10_PR56                     1403-1409 (A)
 I10_PR57                     1410-1416 (A)
 I10_PR58                     1417-1423 (A)
 I10_PR59                     1424-1430 (A)
 I10_PR60                     1431-1437 (A)
 I10_PROCTYPE                 1438-1440
 KEY                          1441-1455
 LOS                          1456-1460
 LOS_X                        1461-1466
 MARITALSTATUS_X              1467     (A)
 MARITALSTATUSUB04            1468     (A)
 MDC                          1469-1470
 MDC_NoPOA                    1471-1472
 MDNUM1_R                     1473-1481
 MDNUM2_R                     1482-1490
 MDNUM3_R                     1491-1499
 MDNUM4_R                     1500-1508
 MEDINCSTQ                    1509-1510
 NCPT                         1511-1514
 OS_TIME                      1515-1525
 PAY1                         1526-1527
 PAY1_X                       1528-1531 (A)
 PAY2                         1532-1533
 PAY2_X                       1534-1537 (A)
 PAY3                         1538-1539
 PAY3_X                       1540-1543 (A)
 PL_CBSA                      1544-1546
 PL_NCHS                      1547-1548
 PL_RUCC                      1549-1550
 PL_UIC                       1551-1552
 PL_UR_CAT4                   1553-1554
 POA_Disch_Edit1              1555-1556
 POA_Disch_Edit2              1557-1558
 POA_Hosp_Edit1               1559-1560
 POA_Hosp_Edit2               1561-1562
 POA_Hosp_Edit3               1563-1564
 POA_Hosp_Edit3_Value         1565-1572
 PointOfOrigin_X              1573     (A)
 PointOfOriginUB04            1574     (A)
 PRDAY1                       1575-1579
 PRDAY2                       1580-1584
 PRDAY3                       1585-1589
 PRDAY4                       1590-1594
 PRDAY5                       1595-1599
 PRDAY6                       1600-1604
 PRDAY7                       1605-1609
 PRDAY8                       1610-1614
 PRDAY9                       1615-1619
 PRDAY10                      1620-1624
 PRDAY11                      1625-1629
 PRDAY12                      1630-1634
 PRDAY13                      1635-1639
 PRDAY14                      1640-1644
 PRDAY15                      1645-1649
 PRDAY16                      1650-1654
 PRDAY17                      1655-1659
 PRDAY18                      1660-1664
 PRDAY19                      1665-1669
 PRDAY20                      1670-1674
 PRDAY21                      1675-1679
 PRDAY22                      1680-1684
 PRDAY23                      1685-1689
 PRDAY24                      1690-1694
 PRDAY25                      1695-1699
 PRDAY26                      1700-1704
 PRDAY27                      1705-1709
 PRDAY28                      1710-1714
 PRDAY29                      1715-1719
 PRDAY30                      1720-1724
 PRDAY31                      1725-1729
 PRDAY32                      1730-1734
 PRDAY33                      1735-1739
 PRDAY34                      1740-1744
 PRDAY35                      1745-1749
 PRDAY36                      1750-1754
 PRDAY37                      1755-1759
 PRDAY38                      1760-1764
 PRDAY39                      1765-1769
 PRDAY40                      1770-1774
 PRDAY41                      1775-1779
 PRDAY42                      1780-1784
 PRDAY43                      1785-1789
 PRDAY44                      1790-1794
 PRDAY45                      1795-1799
 PRDAY46                      1800-1804
 PRDAY47                      1805-1809
 PRDAY48                      1810-1814
 PRDAY49                      1815-1819
 PRDAY50                      1820-1824
 PRDAY51                      1825-1829
 PRDAY52                      1830-1834
 PRDAY53                      1835-1839
 PRDAY54                      1840-1844
 PRDAY55                      1845-1849
 PRDAY56                      1850-1854
 PRDAY57                      1855-1859
 PRDAY58                      1860-1864
 PRDAY59                      1865-1869
 PRDAY60                      1870-1874
 PrimLang                     1875-1877 (A)
 PRVER                        1878-1880
 PSTATE                       1881-1882 (A)
 PSTCO                        1883-1887
 PSTCO2                       1888-1892
 RACE                         1893-1894
 RACE_X                       1895     (A)
 TOTCHG                       1896-1905
 TOTCHG_X                     1906-1920
 TRAN_IN                      1921-1922
 TRAN_OUT                     1923-1924
 VisitLink                    1925-1933
 YEAR                         1934-1937
 ZIP                          1938-1942 (A)
 ZIP3                         1943-1945 (A)
 ZIPINC_QRTL                  1946-1948
 HOSPID                       1949-1953
 AYEAR                        1954-1957
 BMONTH                       1958-1959
 BYEAR                        1960-1963
 PRMONTH1                     1964-1965
 PRMONTH2                     1966-1967
 PRMONTH3                     1968-1969
 PRMONTH4                     1970-1971
 PRMONTH5                     1972-1973
 PRMONTH6                     1974-1975
 PRMONTH7                     1976-1977
 PRMONTH8                     1978-1979
 PRMONTH9                     1980-1981
 PRMONTH10                    1982-1983
 PRMONTH11                    1984-1985
 PRMONTH12                    1986-1987
 PRMONTH13                    1988-1989
 PRMONTH14                    1990-1991
 PRMONTH15                    1992-1993
 PRMONTH16                    1994-1995
 PRMONTH17                    1996-1997
 PRMONTH18                    1998-1999
 PRMONTH19                    2000-2001
 PRMONTH20                    2002-2003
 PRMONTH21                    2004-2005
 PRMONTH22                    2006-2007
 PRMONTH23                    2008-2009
 PRMONTH24                    2010-2011
 PRMONTH25                    2012-2013
 PRMONTH26                    2014-2015
 PRMONTH27                    2016-2017
 PRMONTH28                    2018-2019
 PRMONTH29                    2020-2021
 PRMONTH30                    2022-2023
 PRMONTH31                    2024-2025
 PRMONTH32                    2026-2027
 PRMONTH33                    2028-2029
 PRMONTH34                    2030-2031
 PRMONTH35                    2032-2033
 PRMONTH36                    2034-2035
 PRMONTH37                    2036-2037
 PRMONTH38                    2038-2039
 PRMONTH39                    2040-2041
 PRMONTH40                    2042-2043
 PRMONTH41                    2044-2045
 PRMONTH42                    2046-2047
 PRMONTH43                    2048-2049
 PRMONTH44                    2050-2051
 PRMONTH45                    2052-2053
 PRMONTH46                    2054-2055
 PRMONTH47                    2056-2057
 PRMONTH48                    2058-2059
 PRMONTH49                    2060-2061
 PRMONTH50                    2062-2063
 PRMONTH51                    2064-2065
 PRMONTH52                    2066-2067
 PRMONTH53                    2068-2069
 PRMONTH54                    2070-2071
 PRMONTH55                    2072-2073
 PRMONTH56                    2074-2075
 PRMONTH57                    2076-2077
 PRMONTH58                    2078-2079
 PRMONTH59                    2080-2081
 PRMONTH60                    2082-2083
 PRYEAR1                      2084-2087
 PRYEAR2                      2088-2091
 PRYEAR3                      2092-2095
 PRYEAR4                      2096-2099
 PRYEAR5                      2100-2103
 PRYEAR6                      2104-2107
 PRYEAR7                      2108-2111
 PRYEAR8                      2112-2115
 PRYEAR9                      2116-2119
 PRYEAR10                     2120-2123
 PRYEAR11                     2124-2127
 PRYEAR12                     2128-2131
 PRYEAR13                     2132-2135
 PRYEAR14                     2136-2139
 PRYEAR15                     2140-2143
 PRYEAR16                     2144-2147
 PRYEAR17                     2148-2151
 PRYEAR18                     2152-2155
 PRYEAR19                     2156-2159
 PRYEAR20                     2160-2163
 PRYEAR21                     2164-2167
 PRYEAR22                     2168-2171
 PRYEAR23                     2172-2175
 PRYEAR24                     2176-2179
 PRYEAR25                     2180-2183
 PRYEAR26                     2184-2187
 PRYEAR27                     2188-2191
 PRYEAR28                     2192-2195
 PRYEAR29                     2196-2199
 PRYEAR30                     2200-2203
 PRYEAR31                     2204-2207
 PRYEAR32                     2208-2211
 PRYEAR33                     2212-2215
 PRYEAR34                     2216-2219
 PRYEAR35                     2220-2223
 PRYEAR36                     2224-2227
 PRYEAR37                     2228-2231
 PRYEAR38                     2232-2235
 PRYEAR39                     2236-2239
 PRYEAR40                     2240-2243
 PRYEAR41                     2244-2247
 PRYEAR42                     2248-2251
 PRYEAR43                     2252-2255
 PRYEAR44                     2256-2259
 PRYEAR45                     2260-2263
 PRYEAR46                     2264-2267
 PRYEAR47                     2268-2271
 PRYEAR48                     2272-2275
 PRYEAR49                     2276-2279
 PRYEAR50                     2280-2283
 PRYEAR51                     2284-2287
 PRYEAR52                     2288-2291
 PRYEAR53                     2292-2295
 PRYEAR54                     2296-2299
 PRYEAR55                     2300-2303
 PRYEAR56                     2304-2307
 PRYEAR57                     2308-2311
 PRYEAR58                     2312-2315
 PRYEAR59                     2316-2319
 PRYEAR60                     2320-2323.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 Homeless                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRDAY51                      (F4.0) /
 PRDAY52                      (F4.0) /
 PRDAY53                      (F4.0) /
 PRDAY54                      (F4.0) /
 PRDAY55                      (F4.0) /
 PRDAY56                      (F4.0) /
 PRDAY57                      (F4.0) /
 PRDAY58                      (F4.0) /
 PRDAY59                      (F4.0) /
 PRDAY60                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRMONTH31                    (F3.0) /
 PRMONTH32                    (F3.0) /
 PRMONTH33                    (F3.0) /
 PRMONTH34                    (F3.0) /
 PRMONTH35                    (F3.0) /
 PRMONTH36                    (F3.0) /
 PRMONTH37                    (F3.0) /
 PRMONTH38                    (F3.0) /
 PRMONTH39                    (F3.0) /
 PRMONTH40                    (F3.0) /
 PRMONTH41                    (F3.0) /
 PRMONTH42                    (F3.0) /
 PRMONTH43                    (F3.0) /
 PRMONTH44                    (F3.0) /
 PRMONTH45                    (F3.0) /
 PRMONTH46                    (F3.0) /
 PRMONTH47                    (F3.0) /
 PRMONTH48                    (F3.0) /
 PRMONTH49                    (F3.0) /
 PRMONTH50                    (F3.0) /
 PRMONTH51                    (F3.0) /
 PRMONTH52                    (F3.0) /
 PRMONTH53                    (F3.0) /
 PRMONTH54                    (F3.0) /
 PRMONTH55                    (F3.0) /
 PRMONTH56                    (F3.0) /
 PRMONTH57                    (F3.0) /
 PRMONTH58                    (F3.0) /
 PRMONTH59                    (F3.0) /
 PRMONTH60                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) /
 PRYEAR31                     (F3.0) /
 PRYEAR32                     (F3.0) /
 PRYEAR33                     (F3.0) /
 PRYEAR34                     (F3.0) /
 PRYEAR35                     (F3.0) /
 PRYEAR36                     (F3.0) /
 PRYEAR37                     (F3.0) /
 PRYEAR38                     (F3.0) /
 PRYEAR39                     (F3.0) /
 PRYEAR40                     (F3.0) /
 PRYEAR41                     (F3.0) /
 PRYEAR42                     (F3.0) /
 PRYEAR43                     (F3.0) /
 PRYEAR44                     (F3.0) /
 PRYEAR45                     (F3.0) /
 PRYEAR46                     (F3.0) /
 PRYEAR47                     (F3.0) /
 PRYEAR48                     (F3.0) /
 PRYEAR49                     (F3.0) /
 PRYEAR50                     (F3.0) /
 PRYEAR51                     (F3.0) /
 PRYEAR52                     (F3.0) /
 PRYEAR53                     (F3.0) /
 PRYEAR54                     (F3.0) /
 PRYEAR55                     (F3.0) /
 PRYEAR56                     (F3.0) /
 PRYEAR57                     (F3.0) /
 PRYEAR58                     (F3.0) /
 PRYEAR59                     (F3.0) /
 PRYEAR60                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 BWT                          "Birth weight in grams"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "External cause 1, present on admission indicator"
 E_POA2                       "External cause 2, present on admission indicator"
 E_POA3                       "External cause 3, present on admission indicator"
 E_POA4                       "External cause 4, present on admission indicator"
 E_POA5                       "External cause 5, present on admission indicator"
 E_POA6                       "External cause 6, present on admission indicator"
 E_POA7                       "External cause 7, present on admission indicator"
 E_POA8                       "External cause 8, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 Homeless                     "Indicator that patient is homeless"
 HOSPST                       "Hospital state postal code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_ECAUSE1                  "ICD-10-CM External cause 1"
 I10_ECAUSE2                  "ICD-10-CM External cause 2"
 I10_ECAUSE3                  "ICD-10-CM External cause 3"
 I10_ECAUSE4                  "ICD-10-CM External cause 4"
 I10_ECAUSE5                  "ICD-10-CM External cause 5"
 I10_ECAUSE6                  "ICD-10-CM External cause 6"
 I10_ECAUSE7                  "ICD-10-CM External cause 7"
 I10_ECAUSE8                  "ICD-10-CM External cause 8"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of External cause codes on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PR51                     "ICD-10-PCS Procedure 51"
 I10_PR52                     "ICD-10-PCS Procedure 52"
 I10_PR53                     "ICD-10-PCS Procedure 53"
 I10_PR54                     "ICD-10-PCS Procedure 54"
 I10_PR55                     "ICD-10-PCS Procedure 55"
 I10_PR56                     "ICD-10-PCS Procedure 56"
 I10_PR57                     "ICD-10-PCS Procedure 57"
 I10_PR58                     "ICD-10-PCS Procedure 58"
 I10_PR59                     "ICD-10-PCS Procedure 59"
 I10_PR60                     "ICD-10-PCS Procedure 60"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUS_X              "Patient's marital status (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PRDAY46                      "Number of days from admission to I10_PR46"
 PRDAY47                      "Number of days from admission to I10_PR47"
 PRDAY48                      "Number of days from admission to I10_PR48"
 PRDAY49                      "Number of days from admission to I10_PR49"
 PRDAY50                      "Number of days from admission to I10_PR50"
 PRDAY51                      "Number of days from admission to I10_PR51"
 PRDAY52                      "Number of days from admission to I10_PR52"
 PRDAY53                      "Number of days from admission to I10_PR53"
 PRDAY54                      "Number of days from admission to I10_PR54"
 PRDAY55                      "Number of days from admission to I10_PR55"
 PRDAY56                      "Number of days from admission to I10_PR56"
 PRDAY57                      "Number of days from admission to I10_PR57"
 PRDAY58                      "Number of days from admission to I10_PR58"
 PRDAY59                      "Number of days from admission to I10_PR59"
 PRDAY60                      "Number of days from admission to I10_PR60"
 PrimLang                     "Primary language of patient"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRMONTH31                    "Month of procedure 31"
 PRMONTH32                    "Month of procedure 32"
 PRMONTH33                    "Month of procedure 33"
 PRMONTH34                    "Month of procedure 34"
 PRMONTH35                    "Month of procedure 35"
 PRMONTH36                    "Month of procedure 36"
 PRMONTH37                    "Month of procedure 37"
 PRMONTH38                    "Month of procedure 38"
 PRMONTH39                    "Month of procedure 39"
 PRMONTH40                    "Month of procedure 40"
 PRMONTH41                    "Month of procedure 41"
 PRMONTH42                    "Month of procedure 42"
 PRMONTH43                    "Month of procedure 43"
 PRMONTH44                    "Month of procedure 44"
 PRMONTH45                    "Month of procedure 45"
 PRMONTH46                    "Month of procedure 46"
 PRMONTH47                    "Month of procedure 47"
 PRMONTH48                    "Month of procedure 48"
 PRMONTH49                    "Month of procedure 49"
 PRMONTH50                    "Month of procedure 50"
 PRMONTH51                    "Month of procedure 51"
 PRMONTH52                    "Month of procedure 52"
 PRMONTH53                    "Month of procedure 53"
 PRMONTH54                    "Month of procedure 54"
 PRMONTH55                    "Month of procedure 55"
 PRMONTH56                    "Month of procedure 56"
 PRMONTH57                    "Month of procedure 57"
 PRMONTH58                    "Month of procedure 58"
 PRMONTH59                    "Month of procedure 59"
 PRMONTH60                    "Month of procedure 60"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30"
 PRYEAR31                     "Year of procedure 31"
 PRYEAR32                     "Year of procedure 32"
 PRYEAR33                     "Year of procedure 33"
 PRYEAR34                     "Year of procedure 34"
 PRYEAR35                     "Year of procedure 35"
 PRYEAR36                     "Year of procedure 36"
 PRYEAR37                     "Year of procedure 37"
 PRYEAR38                     "Year of procedure 38"
 PRYEAR39                     "Year of procedure 39"
 PRYEAR40                     "Year of procedure 40"
 PRYEAR41                     "Year of procedure 41"
 PRYEAR42                     "Year of procedure 42"
 PRYEAR43                     "Year of procedure 43"
 PRYEAR44                     "Year of procedure 44"
 PRYEAR45                     "Year of procedure 45"
 PRYEAR46                     "Year of procedure 46"
 PRYEAR47                     "Year of procedure 47"
 PRYEAR48                     "Year of procedure 48"
 PRYEAR49                     "Year of procedure 49"
 PRYEAR50                     "Year of procedure 50"
 PRYEAR51                     "Year of procedure 51"
 PRYEAR52                     "Year of procedure 52"
 PRYEAR53                     "Year of procedure 53"
 PRYEAR54                     "Year of procedure 54"
 PRYEAR55                     "Year of procedure 55"
 PRYEAR56                     "Year of procedure 56"
 PRYEAR57                     "Year of procedure 57"
 PRYEAR58                     "Year of procedure 58"
 PRYEAR59                     "Year of procedure 59"
 PRYEAR60                     "Year of procedure 60" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY51
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY52
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY53
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY54
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY55
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY56
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY57
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY58
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY59
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY60
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH45
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH46
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH47
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH48
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH49
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH50
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH51
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH52
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH53
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH54
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH55
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH56
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH57
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH58
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH59
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH60
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR45
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR46
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR47
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR48
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR49
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR50
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR51
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR52
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR53
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR54
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR55
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR56
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR57
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR58
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR59
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR60
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'GA_SID_2016_CORE.SAV' /COMPRESSED.
