/*******************************************************************
* Creation Date: 07/05/2017   
*   HI_SID_2015q4_SEVERITY.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY SEVERITY FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'HI_SID_2015q4_SEVERITY.ASC' FIXED SKIP=2 / 
 KEY                             1-  15
 I10_CM_AIDS                    16-  17
 I10_CM_ALCOHOL                 18-  19
 I10_CM_ANEMDEF                 20-  21
 I10_CM_ARTH                    22-  23
 I10_CM_BLDLOSS                 24-  25
 I10_CM_CHF                     26-  27
 I10_CM_CHRNLUNG                28-  29
 I10_CM_COAG                    30-  31
 I10_CM_DEPRESS                 32-  33
 I10_CM_DM                      34-  35
 I10_CM_DMCX                    36-  37
 I10_CM_DRUG                    38-  39
 I10_CM_HTN_C                   40-  41
 I10_CM_HYPOTHY                 42-  43
 I10_CM_LIVER                   44-  45
 I10_CM_LYMPH                   46-  47
 I10_CM_LYTES                   48-  49
 I10_CM_METS                    50-  51
 I10_CM_NEURO                   52-  53
 I10_CM_OBESE                   54-  55
 I10_CM_PARA                    56-  57
 I10_CM_PERIVASC                58-  59
 I10_CM_PSYCH                   60-  61
 I10_CM_PULMCIRC                62-  63
 I10_CM_RENLFAIL                64-  65
 I10_CM_TUMOR                   66-  67
 I10_CM_ULCER                   68-  69
 I10_CM_VALVE                   70-  71
 I10_CM_WGHTLOSS                72-  73.


***  Specify write formats  ***.
FORMATS
 KEY                          (F8.0) /
 I10_CM_AIDS                  (F3.0) /
 I10_CM_ALCOHOL               (F3.0) /
 I10_CM_ANEMDEF               (F3.0) /
 I10_CM_ARTH                  (F3.0) /
 I10_CM_BLDLOSS               (F3.0) /
 I10_CM_CHF                   (F3.0) /
 I10_CM_CHRNLUNG              (F3.0) /
 I10_CM_COAG                  (F3.0) /
 I10_CM_DEPRESS               (F3.0) /
 I10_CM_DM                    (F3.0) /
 I10_CM_DMCX                  (F3.0) /
 I10_CM_DRUG                  (F3.0) /
 I10_CM_HTN_C                 (F3.0) /
 I10_CM_HYPOTHY               (F3.0) /
 I10_CM_LIVER                 (F3.0) /
 I10_CM_LYMPH                 (F3.0) /
 I10_CM_LYTES                 (F3.0) /
 I10_CM_METS                  (F3.0) /
 I10_CM_NEURO                 (F3.0) /
 I10_CM_OBESE                 (F3.0) /
 I10_CM_PARA                  (F3.0) /
 I10_CM_PERIVASC              (F3.0) /
 I10_CM_PSYCH                 (F3.0) /
 I10_CM_PULMCIRC              (F3.0) /
 I10_CM_RENLFAIL              (F3.0) /
 I10_CM_TUMOR                 (F3.0) /
 I10_CM_ULCER                 (F3.0) /
 I10_CM_VALVE                 (F3.0) /
 I10_CM_WGHTLOSS              (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY                          "HCUP record identifier"
 I10_CM_AIDS
"ICD-10-CM AHRQ comorbidity measure: Acquired immune deficiency syndrome"
 I10_CM_ALCOHOL               "ICD-10-CM AHRQ comorbidity measure: Alcohol abuse"
 I10_CM_ANEMDEF               "ICD-10-CM AHRQ comorbidity measure: Deficiency anemias"
 I10_CM_ARTH
"ICD-10-CM AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular diseases"
 I10_CM_BLDLOSS
"ICD-10-CM AHRQ comorbidity measure: Chronic blood loss anemia"
 I10_CM_CHF                   "ICD-10-CM AHRQ comorbidity measure: Congestive heart failure"
 I10_CM_CHRNLUNG
"ICD-10-CM AHRQ comorbidity measure: Chronic pulmonary disease"
 I10_CM_COAG                  "ICD-10-CM AHRQ comorbidity measure: Coagulopathy"
 I10_CM_DEPRESS               "ICD-10-CM AHRQ comorbidity measure: Depression"
 I10_CM_DM                    "ICD-10-CM AHRQ comorbidity measure: Diabetes, uncomplicated"
 I10_CM_DMCX
"ICD-10-CM AHRQ comorbidity measure: Diabetes with chronic complications"
 I10_CM_DRUG                  "ICD-10-CM AHRQ comorbidity measure: Drug abuse"
 I10_CM_HTN_C
"ICD-10-CM AHRQ comorbidity measure: Hypertension (combine uncomplicated and complicated)"
 I10_CM_HYPOTHY               "ICD-10-CM AHRQ comorbidity measure: Hypothyroidism"
 I10_CM_LIVER                 "ICD-10-CM AHRQ comorbidity measure: Liver disease"
 I10_CM_LYMPH                 "ICD-10-CM AHRQ comorbidity measure: Lymphoma"
 I10_CM_LYTES
"ICD-10-CM AHRQ comorbidity measure: Fluid and electrolyte disorders"
 I10_CM_METS                  "ICD-10-CM AHRQ comorbidity measure: Metastatic cancer"
 I10_CM_NEURO
"ICD-10-CM AHRQ comorbidity measure: Other neurological disorders"
 I10_CM_OBESE                 "ICD-10-CM AHRQ comorbidity measure: Obesity"
 I10_CM_PARA                  "ICD-10-CM AHRQ comorbidity measure: Paralysis"
 I10_CM_PERIVASC
"ICD-10-CM AHRQ comorbidity measure: Peripheral vascular disorders"
 I10_CM_PSYCH                 "ICD-10-CM AHRQ comorbidity measure: Psychoses"
 I10_CM_PULMCIRC
"ICD-10-CM AHRQ comorbidity measure: Pulmonary circulation disorders"
 I10_CM_RENLFAIL              "ICD-10-CM AHRQ comorbidity measure: Renal failure"
 I10_CM_TUMOR
"ICD-10-CM AHRQ comorbidity measure: Solid tumor without metastasis"
 I10_CM_ULCER
"ICD-10-CM AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding"
 I10_CM_VALVE                 "ICD-10-CM AHRQ comorbidity measure: Valvular disease"
 I10_CM_WGHTLOSS              "ICD-10-CM AHRQ comorbidity measure: Weight loss" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE I10_CM_AIDS
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_ALCOHOL
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_ANEMDEF
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_ARTH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_BLDLOSS
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_CHF
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_CHRNLUNG
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_COAG
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_DEPRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_DM
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_DMCX
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_DRUG
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_HTN_C
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_HYPOTHY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_LIVER
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_LYMPH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_LYTES
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_METS
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_NEURO
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_OBESE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_PARA
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_PERIVASC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_PSYCH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_PULMCIRC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_RENLFAIL
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_TUMOR
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_ULCER
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_VALVE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CM_WGHTLOSS
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'HI_SID_2015q4_SEVERITY.SAV' /COMPRESSED.
