/*******************************************************************
*   IA_SID_2000_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL CONVERT THE ASCII             
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'IA_SID_2000_CORE.ASC' FIXED / 
 KEY                  1- 14
 AGE                 15- 17
 AGEDAY              18- 20
 AGEMONTH            21- 23
 AMONTH              24- 25
 ASOURCE             26- 27
 ASOURCE_            28 (A)
 ATYPE               29- 30
 AWEEKEND            31- 32
 DIED                33- 34
 DISP_X              35 (A)
 DISPUB92            36- 37
 DISPUNIF            38- 39
 DQTR                40- 41
 DRG                 42- 44
 DRG18               45- 47
 DRGVER              48- 49
 DSHOSPID            50- 62 (A)
 DX1                 63- 67 (A)
 DX2                 68- 72 (A)
 DX3                 73- 77 (A)
 DX4                 78- 82 (A)
 DX5                 83- 87 (A)
 DX6                 88- 92 (A)
 DX7                 93- 97 (A)
 DX8                 98-102 (A)
 DX9                103-107 (A)
 DX10               108-112 (A)
 DX11               113-117 (A)
 DXCCS1             118-121
 DXCCS2             122-125
 DXCCS3             126-129
 DXCCS4             130-133
 DXCCS5             134-137
 DXCCS6             138-141
 DXCCS7             142-145
 DXCCS8             146-149
 DXCCS9             150-153
 DXCCS10            154-157
 DXCCS11            158-161
 FEMALE             162-163
 HOSPST             164-165 (A)
 LOS                166-170
 LOS_X              171-176
 MDC                177-178
 MDC18              179-180
 MDID_S             181-196 (A)
 MRN_S              197-213 (A)
 NDX                214-215
 NEOMAT             216-217
 NPR                218-219
 PAY1               220-221
 PAY1_X             222-223 (A)
 PR1                224-227 (A)
 PR2                228-231 (A)
 PR3                232-235 (A)
 PR4                236-239 (A)
 PR5                240-243 (A)
 PR6                244-247 (A)
 PRCCS1             248-250
 PRCCS2             251-253
 PRCCS3             254-256
 PRCCS4             257-259
 PRCCS5             260-262
 PRCCS6             263-265
 PRDAY1             266-268
 PRDAY2             269-271
 PRDAY3             272-274
 PRDAY4             275-277
 PRDAY5             278-280
 PRDAY6             281-283
 PSTCO              284-288
 RACE               289-290
 RACE_X             291 (A)
 SURGID_S           292-307 (A)
 TOTCHG             308-317
 TOTCHG_X           318-332
 YEAR               333-336
 ZIP                337-341 (A)
 AYEAR              342-345
 DMONTH             346-347
 BMONTH             348-349
 BYEAR              350-353
 PRMNTH1            354-355
 PRMNTH2            356-357
 PRMNTH3            358-359
 PRMNTH4            360-361
 PRMNTH5            362-363
 PRMNTH6            364-365
 PRYEAR1            366-369
 PRYEAR2            370-373
 PRYEAR3            374-377
 PRYEAR4            378-381
 PRYEAR5            382-385
 PRYEAR6            386-389.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 AMONTH              (F3.0) /
 ASOURCE             (F3.0) /
 ATYPE               (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DRG                 (F3.0) /
 DRG18               (F3.0) /
 DRGVER              (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 MDC                 (F3.0) /
 MDC18               (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRDAY1              (F4.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PSTCO               (F4.0) /
 RACE                (F3.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 BMONTH              (F3.0) /
 BYEAR               (F3.0) /
 PRMNTH1             (F3.0) /
 PRMNTH2             (F3.0) /
 PRMNTH3             (F3.0) /
 PRMNTH4             (F3.0) /
 PRMNTH5             (F3.0) /
 PRMNTH6             (F3.0) /
 PRYEAR1             (F3.0) /
 PRYEAR2             (F3.0) /
 PRYEAR3             (F3.0) /
 PRYEAR4             (F3.0) /
 PRYEAR5             (F3.0) /
 PRYEAR6             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY          "HCUP record identifier"
 AGE          "Age in years at admission"
 AGEDAY       "Age in days (when age < 1 year)"
 AGEMONTH     "Age in months (when age < 11 years)"
 AMONTH       "Admission month"
 ASOURCE      "Admission source (uniform)"
 ASOURCE_     "Admission source (as received from source)"
 ATYPE        "Admission type"
 AWEEKEND     "Admission day is a weekend"
 DIED         "Died during hospitalization"
 DISP_X       "Disposition of patient (as received from source)"
 DISPUB92     "Disposition of patient (UB-92 standard coding)"
 DISPUNIF     "Disposition of patient (uniform)"
 DQTR         "Discharge quarter"
 DRG          "DRG in effect on discharge date"
 DRG18        "DRG, version 18"
 DRGVER       "DRG grouper version used on discharge date"
 DSHOSPID     "Data source hospital identifier"
 DX1          "Principal diagnosis"
 DX2          "Diagnosis 2"
 DX3          "Diagnosis 3"
 DX4          "Diagnosis 4"
 DX5          "Diagnosis 5"
 DX6          "Diagnosis 6"
 DX7          "Diagnosis 7"
 DX8          "Diagnosis 8"
 DX9          "Diagnosis 9"
 DX10         "Diagnosis 10"
 DX11         "Diagnosis 11"
 DXCCS1       "CCS: principal diagnosis"
 DXCCS2       "CCS: diagnosis 2"
 DXCCS3       "CCS: diagnosis 3"
 DXCCS4       "CCS: diagnosis 4"
 DXCCS5       "CCS: diagnosis 5"
 DXCCS6       "CCS: diagnosis 6"
 DXCCS7       "CCS: diagnosis 7"
 DXCCS8       "CCS: diagnosis 8"
 DXCCS9       "CCS: diagnosis 9"
 DXCCS10      "CCS: diagnosis 10"
 DXCCS11      "CCS: diagnosis 11"
 FEMALE       "Indicator of sex"
 HOSPST       "Hospital state postal code"
 LOS          "Length of stay (cleaned)"
 LOS_X        "Length of stay (as received from source)"
 MDC          "MDC in effect on discharge date"
 MDC18        "MDC, version 18"
 MDID_S       "Attending physician number (synthetic)"
 MRN_S        "Medical record number (synthetic)"
 NDX          "Number of diagnoses on this record"
 NEOMAT       "Neonatal and/or maternal DX and/or PR"
 NPR          "Number of procedures on this record"
 PAY1         "Primary expected payer (uniform)"
 PAY1_X       "Primary expected payer (as received from source)"
 PR1          "Principal procedure"
 PR2          "Procedure 2"
 PR3          "Procedure 3"
 PR4          "Procedure 4"
 PR5          "Procedure 5"
 PR6          "Procedure 6"
 PRCCS1       "CCS: principal procedure"
 PRCCS2       "CCS: procedure 2"
 PRCCS3       "CCS: procedure 3"
 PRCCS4       "CCS: procedure 4"
 PRCCS5       "CCS: procedure 5"
 PRCCS6       "CCS: procedure 6"
 PRDAY1       "Number of days from admission to PR1"
 PRDAY2       "Number of days from admission to PR2"
 PRDAY3       "Number of days from admission to PR3"
 PRDAY4       "Number of days from admission to PR4"
 PRDAY5       "Number of days from admission to PR5"
 PRDAY6       "Number of days from admission to PR6"
 PSTCO        "Patient state/county FIPS code"
 RACE         "Race (uniform)"
 RACE_X       "Race (as received from source)"
 SURGID_S     "Primary surgeon number (synthetic)"
 TOTCHG       "Total charges (cleaned)"
 TOTCHG_X     "Total charges (as received from source)"
 YEAR         "Calendar year"
 ZIP          "Patient zip code"
 AYEAR        "Admission year"
 DMONTH       "Discharge month"
 BMONTH       "Birth month"
 BYEAR        "Birth year"
 PRMNTH1      "Month of procedure 1"
 PRMNTH2      "Month of procedure 2"
 PRMNTH3      "Month of procedure 3"
 PRMNTH4      "Month of procedure 4"
 PRMNTH5      "Month of procedure 5"
 PRMNTH6      "Month of procedure 6"
 PRYEAR1      "Year of procedure 1"
 PRYEAR2      "Year of procedure 2"
 PRYEAR3      "Year of procedure 3"
 PRYEAR4      "Year of procedure 4"
 PRYEAR5      "Year of procedure 5"
 PRYEAR6      "Year of procedure 6".


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'IA_SID_2000_CORE.SAV' /COMPRESSED.
