/*******************************************************************
*   IA_SID_2008_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'IA_SID_2008_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ATYPE                     12-  13
 AWEEKEND                  14-  15
 DIED                      16-  17
 DISPUB04                  18-  19
 DISPUNIF                  20-  21
 DISP_X                    22-  25 (A)
 DQTR                      26-  27
 DRG                       28-  30
 DRG24                     31-  33
 DRGVER                    34-  35
 DRG_NoPO                  36-  38
 DSHOSPID                  39-  51 (A)
 DX1                       52-  56 (A)
 DX2                       57-  61 (A)
 DX3                       62-  66 (A)
 DX4                       67-  71 (A)
 DX5                       72-  76 (A)
 DX6                       77-  81 (A)
 DX7                       82-  86 (A)
 DX8                       87-  91 (A)
 DX9                       92-  96 (A)
 DX10                      97- 101 (A)
 DX11                     102- 106 (A)
 DX12                     107- 111 (A)
 DX13                     112- 116 (A)
 DX14                     117- 121 (A)
 DX15                     122- 126 (A)
 DX16                     127- 131 (A)
 DX17                     132- 136 (A)
 DX18                     137- 141 (A)
 DX19                     142- 146 (A)
 DX20                     147- 151 (A)
 DX21                     152- 156 (A)
 DX22                     157- 161 (A)
 DX23                     162- 166 (A)
 DX24                     167- 171 (A)
 DX25                     172- 176 (A)
 DX26                     177- 181 (A)
 DX27                     182- 186 (A)
 DX28                     187- 191 (A)
 DX29                     192- 196 (A)
 DX30                     197- 201 (A)
 DX31                     202- 206 (A)
 DX32                     207- 211 (A)
 DX33                     212- 216 (A)
 DX34                     217- 221 (A)
 DX35                     222- 226 (A)
 DX36                     227- 231 (A)
 DX37                     232- 236 (A)
 DX38                     237- 241 (A)
 DX39                     242- 246 (A)
 DX40                     247- 251 (A)
 DX41                     252- 256 (A)
 DX42                     257- 261 (A)
 DX43                     262- 266 (A)
 DX44                     267- 271 (A)
 DX45                     272- 276 (A)
 DX46                     277- 281 (A)
 DX47                     282- 286 (A)
 DX48                     287- 291 (A)
 DX49                     292- 296 (A)
 DX50                     297- 301 (A)
 DX51                     302- 306 (A)
 DX52                     307- 311 (A)
 DX53                     312- 316 (A)
 DX54                     317- 321 (A)
 DX55                     322- 326 (A)
 DX56                     327- 331 (A)
 DX57                     332- 336 (A)
 DX58                     337- 341 (A)
 DX59                     342- 346 (A)
 DX60                     347- 351 (A)
 DX61                     352- 356 (A)
 DX62                     357- 361 (A)
 DX63                     362- 366 (A)
 DX64                     367- 371 (A)
 DX65                     372- 376 (A)
 DX66                     377- 381 (A)
 DXCCS1                   382- 385
 DXCCS2                   386- 389
 DXCCS3                   390- 393
 DXCCS4                   394- 397
 DXCCS5                   398- 401
 DXCCS6                   402- 405
 DXCCS7                   406- 409
 DXCCS8                   410- 413
 DXCCS9                   414- 417
 DXCCS10                  418- 421
 DXCCS11                  422- 425
 DXCCS12                  426- 429
 DXCCS13                  430- 433
 DXCCS14                  434- 437
 DXCCS15                  438- 441
 DXCCS16                  442- 445
 DXCCS17                  446- 449
 DXCCS18                  450- 453
 DXCCS19                  454- 457
 DXCCS20                  458- 461
 DXCCS21                  462- 465
 DXCCS22                  466- 469
 DXCCS23                  470- 473
 DXCCS24                  474- 477
 DXCCS25                  478- 481
 DXCCS26                  482- 485
 DXCCS27                  486- 489
 DXCCS28                  490- 493
 DXCCS29                  494- 497
 DXCCS30                  498- 501
 DXCCS31                  502- 505
 DXCCS32                  506- 509
 DXCCS33                  510- 513
 DXCCS34                  514- 517
 DXCCS35                  518- 521
 DXCCS36                  522- 525
 DXCCS37                  526- 529
 DXCCS38                  530- 533
 DXCCS39                  534- 537
 DXCCS40                  538- 541
 DXCCS41                  542- 545
 DXCCS42                  546- 549
 DXCCS43                  550- 553
 DXCCS44                  554- 557
 DXCCS45                  558- 561
 DXCCS46                  562- 565
 DXCCS47                  566- 569
 DXCCS48                  570- 573
 DXCCS49                  574- 577
 DXCCS50                  578- 581
 DXCCS51                  582- 585
 DXCCS52                  586- 589
 DXCCS53                  590- 593
 DXCCS54                  594- 597
 DXCCS55                  598- 601
 DXCCS56                  602- 605
 DXCCS57                  606- 609
 DXCCS58                  610- 613
 DXCCS59                  614- 617
 DXCCS60                  618- 621
 DXCCS61                  622- 625
 DXCCS62                  626- 629
 DXCCS63                  630- 633
 DXCCS64                  634- 637
 DXCCS65                  638- 641
 DXCCS66                  642- 645
 DXPOA1                   646     (A)
 DXPOA2                   647     (A)
 DXPOA3                   648     (A)
 DXPOA4                   649     (A)
 DXPOA5                   650     (A)
 DXPOA6                   651     (A)
 DXPOA7                   652     (A)
 DXPOA8                   653     (A)
 DXPOA9                   654     (A)
 DXPOA10                  655     (A)
 DXPOA11                  656     (A)
 DXPOA12                  657     (A)
 DXPOA13                  658     (A)
 DXPOA14                  659     (A)
 DXPOA15                  660     (A)
 DXPOA16                  661     (A)
 DXPOA17                  662     (A)
 DXPOA18                  663     (A)
 DXPOA19                  664     (A)
 DXPOA20                  665     (A)
 DXPOA21                  666     (A)
 DXPOA22                  667     (A)
 DXPOA23                  668     (A)
 DXPOA24                  669     (A)
 DXPOA25                  670     (A)
 DXPOA26                  671     (A)
 DXPOA27                  672     (A)
 DXPOA28                  673     (A)
 DXPOA29                  674     (A)
 DXPOA30                  675     (A)
 DXPOA31                  676     (A)
 DXPOA32                  677     (A)
 DXPOA33                  678     (A)
 DXPOA34                  679     (A)
 DXPOA35                  680     (A)
 DXPOA36                  681     (A)
 DXPOA37                  682     (A)
 DXPOA38                  683     (A)
 DXPOA39                  684     (A)
 DXPOA40                  685     (A)
 DXPOA41                  686     (A)
 DXPOA42                  687     (A)
 DXPOA43                  688     (A)
 DXPOA44                  689     (A)
 DXPOA45                  690     (A)
 DXPOA46                  691     (A)
 DXPOA47                  692     (A)
 DXPOA48                  693     (A)
 DXPOA49                  694     (A)
 DXPOA50                  695     (A)
 DXPOA51                  696     (A)
 DXPOA52                  697     (A)
 DXPOA53                  698     (A)
 DXPOA54                  699     (A)
 DXPOA55                  700     (A)
 DXPOA56                  701     (A)
 DXPOA57                  702     (A)
 DXPOA58                  703     (A)
 DXPOA59                  704     (A)
 DXPOA60                  705     (A)
 DXPOA61                  706     (A)
 DXPOA62                  707     (A)
 DXPOA63                  708     (A)
 DXPOA64                  709     (A)
 DXPOA65                  710     (A)
 DXPOA66                  711     (A)
 ECODE1                   712- 716 (A)
 ECODE2                   717- 721 (A)
 ECODE3                   722- 726 (A)
 ECODE4                   727- 731 (A)
 ECODE5                   732- 736 (A)
 ECODE6                   737- 741 (A)
 ECODE7                   742- 746 (A)
 E_CCS1                   747- 750
 E_CCS2                   751- 754
 E_CCS3                   755- 758
 E_CCS4                   759- 762
 E_CCS5                   763- 766
 E_CCS6                   767- 770
 E_CCS7                   771- 774
 E_POA1                   775     (A)
 E_POA2                   776     (A)
 E_POA3                   777     (A)
 E_POA4                   778     (A)
 E_POA5                   779     (A)
 E_POA6                   780     (A)
 E_POA7                   781     (A)
 FEMALE                   782- 783
 HCUP_ED                  784- 785
 HCUP_OS                  786- 787
 HOSPBRTH                 788- 790
 HOSPST                   791- 792 (A)
 Hospital                 793- 794
 KEY                      795- 808
 LOS                      809- 813
 LOS_X                    814- 819
 MDC                      820- 821
 MDC24                    822- 823
 MDNUM1_R                 824- 832
 MDNUM2_R                 833- 841
 MDNUM3_R                 842- 850
 MEDINCST                 851- 852
 MRN_R                    853- 861
 NDX                      862- 863
 NECODE                   864- 865
 NEOMAT                   866- 867
 NPR                      868- 869
 PAY1                     870- 871
 PAY1_X                   872- 875 (A)
 PL_CBSA                  876- 878
 PL_MSA19                 879- 881
 PL_NCHS2                 882- 883
 PL_RUCA1                 884- 885
 PL_RUCA2                 886- 889
 PL_RUCA4                 890- 891
 PL_RUCC2                 892- 893
 PL_UIC20                 894- 895
 PL_UR_CA                 896- 897
 PR1                      898- 901 (A)
 PR2                      902- 905 (A)
 PR3                      906- 909 (A)
 PR4                      910- 913 (A)
 PR5                      914- 917 (A)
 PR6                      918- 921 (A)
 PR7                      922- 925 (A)
 PR8                      926- 929 (A)
 PR9                      930- 933 (A)
 PR10                     934- 937 (A)
 PR11                     938- 941 (A)
 PR12                     942- 945 (A)
 PR13                     946- 949 (A)
 PR14                     950- 953 (A)
 PR15                     954- 957 (A)
 PR16                     958- 961 (A)
 PR17                     962- 965 (A)
 PR18                     966- 969 (A)
 PR19                     970- 973 (A)
 PR20                     974- 977 (A)
 PR21                     978- 981 (A)
 PR22                     982- 985 (A)
 PR23                     986- 989 (A)
 PR24                     990- 993 (A)
 PR25                     994- 997 (A)
 PR26                     998-1001 (A)
 PR27                    1002-1005 (A)
 PR28                    1006-1009 (A)
 PR29                    1010-1013 (A)
 PR30                    1014-1017 (A)
 PR31                    1018-1021 (A)
 PR32                    1022-1025 (A)
 PR33                    1026-1029 (A)
 PR34                    1030-1033 (A)
 PR35                    1034-1037 (A)
 PR36                    1038-1041 (A)
 PR37                    1042-1045 (A)
 PRCCS1                  1046-1048
 PRCCS2                  1049-1051
 PRCCS3                  1052-1054
 PRCCS4                  1055-1057
 PRCCS5                  1058-1060
 PRCCS6                  1061-1063
 PRCCS7                  1064-1066
 PRCCS8                  1067-1069
 PRCCS9                  1070-1072
 PRCCS10                 1073-1075
 PRCCS11                 1076-1078
 PRCCS12                 1079-1081
 PRCCS13                 1082-1084
 PRCCS14                 1085-1087
 PRCCS15                 1088-1090
 PRCCS16                 1091-1093
 PRCCS17                 1094-1096
 PRCCS18                 1097-1099
 PRCCS19                 1100-1102
 PRCCS20                 1103-1105
 PRCCS21                 1106-1108
 PRCCS22                 1109-1111
 PRCCS23                 1112-1114
 PRCCS24                 1115-1117
 PRCCS25                 1118-1120
 PRCCS26                 1121-1123
 PRCCS27                 1124-1126
 PRCCS28                 1127-1129
 PRCCS29                 1130-1132
 PRCCS30                 1133-1135
 PRCCS31                 1136-1138
 PRCCS32                 1139-1141
 PRCCS33                 1142-1144
 PRCCS34                 1145-1147
 PRCCS35                 1148-1150
 PRCCS36                 1151-1153
 PRCCS37                 1154-1156
 PRDAY1                  1157-1161
 PRDAY2                  1162-1166
 PRDAY3                  1167-1171
 PRDAY4                  1172-1176
 PRDAY5                  1177-1181
 PRDAY6                  1182-1186
 PRDAY7                  1187-1191
 PRDAY8                  1192-1196
 PRDAY9                  1197-1201
 PRDAY10                 1202-1206
 PRDAY11                 1207-1211
 PRDAY12                 1212-1216
 PRDAY13                 1217-1221
 PRDAY14                 1222-1226
 PRDAY15                 1227-1231
 PRDAY16                 1232-1236
 PRDAY17                 1237-1241
 PRDAY18                 1242-1246
 PRDAY19                 1247-1251
 PRDAY20                 1252-1256
 PRDAY21                 1257-1261
 PRDAY22                 1262-1266
 PRDAY23                 1267-1271
 PRDAY24                 1272-1276
 PRDAY25                 1277-1281
 PRDAY26                 1282-1286
 PRDAY27                 1287-1291
 PRDAY28                 1292-1296
 PRDAY29                 1297-1301
 PRDAY30                 1302-1306
 PRDAY31                 1307-1311
 PRDAY32                 1312-1316
 PRDAY33                 1317-1321
 PRDAY34                 1322-1326
 PRDAY35                 1327-1331
 PRDAY36                 1332-1336
 PRDAY37                 1337-1341
 PROCTYPE                1342-1344
 PSTATE                  1345-1346 (A)
 PSTCO                   1347-1351
 PSTCO2                  1352-1356
 POFOUB04                1357     (A)
 POFO_X                  1358     (A)
 RACE                    1359-1360
 RACE_X                  1361-1364 (A)
 TOTCHG                  1365-1374
 TOTCHG_X                1375-1389
 YEAR                    1390-1393
 ZIPINC_Q                1394-1396
 ZIP                     1397-1401 (A)
 AYEAR                   1402-1405
 DMONTH                  1406-1407
 BMONTH                  1408-1409
 BYEAR                   1410-1413
 PRMNTH1                 1414-1415
 PRMNTH2                 1416-1417
 PRMNTH3                 1418-1419
 PRMNTH4                 1420-1421
 PRMNTH5                 1422-1423
 PRMNTH6                 1424-1425
 PRMNTH7                 1426-1427
 PRMNTH8                 1428-1429
 PRMNTH9                 1430-1431
 PRMNTH10                1432-1433
 PRMNTH11                1434-1435
 PRMNTH12                1436-1437
 PRMNTH13                1438-1439
 PRMNTH14                1440-1441
 PRMNTH15                1442-1443
 PRMNTH16                1444-1445
 PRMNTH17                1446-1447
 PRMNTH18                1448-1449
 PRMNTH19                1450-1451
 PRMNTH20                1452-1453
 PRMNTH21                1454-1455
 PRMNTH22                1456-1457
 PRMNTH23                1458-1459
 PRMNTH24                1460-1461
 PRMNTH25                1462-1463
 PRMNTH26                1464-1465
 PRMNTH27                1466-1467
 PRMNTH28                1468-1469
 PRMNTH29                1470-1471
 PRMNTH30                1472-1473
 PRMNTH31                1474-1475
 PRMNTH32                1476-1477
 PRYEAR1                 1478-1481
 PRYEAR2                 1482-1485
 PRYEAR3                 1486-1489
 PRYEAR4                 1490-1493
 PRYEAR5                 1494-1497
 PRYEAR6                 1498-1501
 PRYEAR7                 1502-1505
 PRYEAR8                 1506-1509
 PRYEAR9                 1510-1513
 PRYEAR10                1514-1517
 PRYEAR11                1518-1521
 PRYEAR12                1522-1525
 PRYEAR13                1526-1529
 PRYEAR14                1530-1533
 PRYEAR15                1534-1537
 PRYEAR16                1538-1541
 PRYEAR17                1542-1545
 PRYEAR18                1546-1549
 PRYEAR19                1550-1553
 PRYEAR20                1554-1557
 PRYEAR21                1558-1561
 PRYEAR22                1562-1565
 PRYEAR23                1566-1569
 PRYEAR24                1570-1573
 PRYEAR25                1574-1577
 PRYEAR26                1578-1581
 PRYEAR27                1582-1585
 PRYEAR28                1586-1589
 PRYEAR29                1590-1593
 PRYEAR30                1594-1597
 PRYEAR31                1598-1601
 PRYEAR32                1602-1605.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPO                (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 DXCCS34                 (F4.0) /
 DXCCS35                 (F4.0) /
 DXCCS36                 (F4.0) /
 DXCCS37                 (F4.0) /
 DXCCS38                 (F4.0) /
 DXCCS39                 (F4.0) /
 DXCCS40                 (F4.0) /
 DXCCS41                 (F4.0) /
 DXCCS42                 (F4.0) /
 DXCCS43                 (F4.0) /
 DXCCS44                 (F4.0) /
 DXCCS45                 (F4.0) /
 DXCCS46                 (F4.0) /
 DXCCS47                 (F4.0) /
 DXCCS48                 (F4.0) /
 DXCCS49                 (F4.0) /
 DXCCS50                 (F4.0) /
 DXCCS51                 (F4.0) /
 DXCCS52                 (F4.0) /
 DXCCS53                 (F4.0) /
 DXCCS54                 (F4.0) /
 DXCCS55                 (F4.0) /
 DXCCS56                 (F4.0) /
 DXCCS57                 (F4.0) /
 DXCCS58                 (F4.0) /
 DXCCS59                 (F4.0) /
 DXCCS60                 (F4.0) /
 DXCCS61                 (F4.0) /
 DXCCS62                 (F4.0) /
 DXCCS63                 (F4.0) /
 DXCCS64                 (F4.0) /
 DXCCS65                 (F4.0) /
 DXCCS66                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Hospital                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MDNUM3_R                (F5.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRCCS31                 (F3.0) /
 PRCCS32                 (F3.0) /
 PRCCS33                 (F3.0) /
 PRCCS34                 (F3.0) /
 PRCCS35                 (F3.0) /
 PRCCS36                 (F3.0) /
 PRCCS37                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PRDAY24                 (F4.0) /
 PRDAY25                 (F4.0) /
 PRDAY26                 (F4.0) /
 PRDAY27                 (F4.0) /
 PRDAY28                 (F4.0) /
 PRDAY29                 (F4.0) /
 PRDAY30                 (F4.0) /
 PRDAY31                 (F4.0) /
 PRDAY32                 (F4.0) /
 PRDAY33                 (F4.0) /
 PRDAY34                 (F4.0) /
 PRDAY35                 (F4.0) /
 PRDAY36                 (F4.0) /
 PRDAY37                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRMNTH7                 (F3.0) /
 PRMNTH8                 (F3.0) /
 PRMNTH9                 (F3.0) /
 PRMNTH10                (F3.0) /
 PRMNTH11                (F3.0) /
 PRMNTH12                (F3.0) /
 PRMNTH13                (F3.0) /
 PRMNTH14                (F3.0) /
 PRMNTH15                (F3.0) /
 PRMNTH16                (F3.0) /
 PRMNTH17                (F3.0) /
 PRMNTH18                (F3.0) /
 PRMNTH19                (F3.0) /
 PRMNTH20                (F3.0) /
 PRMNTH21                (F3.0) /
 PRMNTH22                (F3.0) /
 PRMNTH23                (F3.0) /
 PRMNTH24                (F3.0) /
 PRMNTH25                (F3.0) /
 PRMNTH26                (F3.0) /
 PRMNTH27                (F3.0) /
 PRMNTH28                (F3.0) /
 PRMNTH29                (F3.0) /
 PRMNTH30                (F3.0) /
 PRMNTH31                (F3.0) /
 PRMNTH32                (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) /
 PRYEAR24                (F3.0) /
 PRYEAR25                (F3.0) /
 PRYEAR26                (F3.0) /
 PRYEAR27                (F3.0) /
 PRYEAR28                (F3.0) /
 PRYEAR29                (F3.0) /
 PRYEAR30                (F3.0) /
 PRYEAR31                (F3.0) /
 PRYEAR32                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG24     "DRG, version 24"
 DRGVER    "DRG grouper version used on discharge date"
 DRG_NoPO  "DRG in use on discharge date, calculated without POA"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DX26      "Diagnosis 26"
 DX27      "Diagnosis 27"
 DX28      "Diagnosis 28"
 DX29      "Diagnosis 29"
 DX30      "Diagnosis 30"
 DX31      "Diagnosis 31"
 DX32      "Diagnosis 32"
 DX33      "Diagnosis 33"
 DX34      "Diagnosis 34"
 DX35      "Diagnosis 35"
 DX36      "Diagnosis 36"
 DX37      "Diagnosis 37"
 DX38      "Diagnosis 38"
 DX39      "Diagnosis 39"
 DX40      "Diagnosis 40"
 DX41      "Diagnosis 41"
 DX42      "Diagnosis 42"
 DX43      "Diagnosis 43"
 DX44      "Diagnosis 44"
 DX45      "Diagnosis 45"
 DX46      "Diagnosis 46"
 DX47      "Diagnosis 47"
 DX48      "Diagnosis 48"
 DX49      "Diagnosis 49"
 DX50      "Diagnosis 50"
 DX51      "Diagnosis 51"
 DX52      "Diagnosis 52"
 DX53      "Diagnosis 53"
 DX54      "Diagnosis 54"
 DX55      "Diagnosis 55"
 DX56      "Diagnosis 56"
 DX57      "Diagnosis 57"
 DX58      "Diagnosis 58"
 DX59      "Diagnosis 59"
 DX60      "Diagnosis 60"
 DX61      "Diagnosis 61"
 DX62      "Diagnosis 62"
 DX63      "Diagnosis 63"
 DX64      "Diagnosis 64"
 DX65      "Diagnosis 65"
 DX66      "Diagnosis 66"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXCCS26   "CCS: diagnosis 26"
 DXCCS27   "CCS: diagnosis 27"
 DXCCS28   "CCS: diagnosis 28"
 DXCCS29   "CCS: diagnosis 29"
 DXCCS30   "CCS: diagnosis 30"
 DXCCS31   "CCS: diagnosis 31"
 DXCCS32   "CCS: diagnosis 32"
 DXCCS33   "CCS: diagnosis 33"
 DXCCS34   "CCS: diagnosis 34"
 DXCCS35   "CCS: diagnosis 35"
 DXCCS36   "CCS: diagnosis 36"
 DXCCS37   "CCS: diagnosis 37"
 DXCCS38   "CCS: diagnosis 38"
 DXCCS39   "CCS: diagnosis 39"
 DXCCS40   "CCS: diagnosis 40"
 DXCCS41   "CCS: diagnosis 41"
 DXCCS42   "CCS: diagnosis 42"
 DXCCS43   "CCS: diagnosis 43"
 DXCCS44   "CCS: diagnosis 44"
 DXCCS45   "CCS: diagnosis 45"
 DXCCS46   "CCS: diagnosis 46"
 DXCCS47   "CCS: diagnosis 47"
 DXCCS48   "CCS: diagnosis 48"
 DXCCS49   "CCS: diagnosis 49"
 DXCCS50   "CCS: diagnosis 50"
 DXCCS51   "CCS: diagnosis 51"
 DXCCS52   "CCS: diagnosis 52"
 DXCCS53   "CCS: diagnosis 53"
 DXCCS54   "CCS: diagnosis 54"
 DXCCS55   "CCS: diagnosis 55"
 DXCCS56   "CCS: diagnosis 56"
 DXCCS57   "CCS: diagnosis 57"
 DXCCS58   "CCS: diagnosis 58"
 DXCCS59   "CCS: diagnosis 59"
 DXCCS60   "CCS: diagnosis 60"
 DXCCS61   "CCS: diagnosis 61"
 DXCCS62   "CCS: diagnosis 62"
 DXCCS63   "CCS: diagnosis 63"
 DXCCS64   "CCS: diagnosis 64"
 DXCCS65   "CCS: diagnosis 65"
 DXCCS66   "CCS: diagnosis 66"
 DXPOA1    "Diagnosis 1, present on admission indicator"
 DXPOA2    "Diagnosis 2, present on admission indicator"
 DXPOA3    "Diagnosis 3, present on admission indicator"
 DXPOA4    "Diagnosis 4, present on admission indicator"
 DXPOA5    "Diagnosis 5, present on admission indicator"
 DXPOA6    "Diagnosis 6, present on admission indicator"
 DXPOA7    "Diagnosis 7, present on admission indicator"
 DXPOA8    "Diagnosis 8, present on admission indicator"
 DXPOA9    "Diagnosis 9, present on admission indicator"
 DXPOA10   "Diagnosis 10, present on admission indicator"
 DXPOA11   "Diagnosis 11, present on admission indicator"
 DXPOA12   "Diagnosis 12, present on admission indicator"
 DXPOA13   "Diagnosis 13, present on admission indicator"
 DXPOA14   "Diagnosis 14, present on admission indicator"
 DXPOA15   "Diagnosis 15, present on admission indicator"
 DXPOA16   "Diagnosis 16, present on admission indicator"
 DXPOA17   "Diagnosis 17, present on admission indicator"
 DXPOA18   "Diagnosis 18, present on admission indicator"
 DXPOA19   "Diagnosis 19, present on admission indicator"
 DXPOA20   "Diagnosis 20, present on admission indicator"
 DXPOA21   "Diagnosis 21, present on admission indicator"
 DXPOA22   "Diagnosis 22, present on admission indicator"
 DXPOA23   "Diagnosis 23, present on admission indicator"
 DXPOA24   "Diagnosis 24, present on admission indicator"
 DXPOA25   "Diagnosis 25, present on admission indicator"
 DXPOA26   "Diagnosis 26, present on admission indicator"
 DXPOA27   "Diagnosis 27, present on admission indicator"
 DXPOA28   "Diagnosis 28, present on admission indicator"
 DXPOA29   "Diagnosis 29, present on admission indicator"
 DXPOA30   "Diagnosis 30, present on admission indicator"
 DXPOA31   "Diagnosis 31, present on admission indicator"
 DXPOA32   "Diagnosis 32, present on admission indicator"
 DXPOA33   "Diagnosis 33, present on admission indicator"
 DXPOA34   "Diagnosis 34, present on admission indicator"
 DXPOA35   "Diagnosis 35, present on admission indicator"
 DXPOA36   "Diagnosis 36, present on admission indicator"
 DXPOA37   "Diagnosis 37, present on admission indicator"
 DXPOA38   "Diagnosis 38, present on admission indicator"
 DXPOA39   "Diagnosis 39, present on admission indicator"
 DXPOA40   "Diagnosis 40, present on admission indicator"
 DXPOA41   "Diagnosis 41, present on admission indicator"
 DXPOA42   "Diagnosis 42, present on admission indicator"
 DXPOA43   "Diagnosis 43, present on admission indicator"
 DXPOA44   "Diagnosis 44, present on admission indicator"
 DXPOA45   "Diagnosis 45, present on admission indicator"
 DXPOA46   "Diagnosis 46, present on admission indicator"
 DXPOA47   "Diagnosis 47, present on admission indicator"
 DXPOA48   "Diagnosis 48, present on admission indicator"
 DXPOA49   "Diagnosis 49, present on admission indicator"
 DXPOA50   "Diagnosis 50, present on admission indicator"
 DXPOA51   "Diagnosis 51, present on admission indicator"
 DXPOA52   "Diagnosis 52, present on admission indicator"
 DXPOA53   "Diagnosis 53, present on admission indicator"
 DXPOA54   "Diagnosis 54, present on admission indicator"
 DXPOA55   "Diagnosis 55, present on admission indicator"
 DXPOA56   "Diagnosis 56, present on admission indicator"
 DXPOA57   "Diagnosis 57, present on admission indicator"
 DXPOA58   "Diagnosis 58, present on admission indicator"
 DXPOA59   "Diagnosis 59, present on admission indicator"
 DXPOA60   "Diagnosis 60, present on admission indicator"
 DXPOA61   "Diagnosis 61, present on admission indicator"
 DXPOA62   "Diagnosis 62, present on admission indicator"
 DXPOA63   "Diagnosis 63, present on admission indicator"
 DXPOA64   "Diagnosis 64, present on admission indicator"
 DXPOA65   "Diagnosis 65, present on admission indicator"
 DXPOA66   "Diagnosis 66, present on admission indicator"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_POA1    "E Code 1, present on admission indicator"
 E_POA2    "E Code 2, present on admission indicator"
 E_POA3    "E Code 3, present on admission indicator"
 E_POA4    "E Code 4, present on admission indicator"
 E_POA5    "E Code 5, present on admission indicator"
 E_POA6    "E Code 6, present on admission indicator"
 E_POA7    "E Code 7, present on admission indicator"
 FEMALE    "Indicator of sex"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 Hospital
"Indicator that patient was discharged from a special unit within an acute care hospital (re
ported by source)"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC24     "MDC, version 24"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MDNUM3_R  "Physician 3 number (re-identified)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PR22      "Procedure 22"
 PR23      "Procedure 23"
 PR24      "Procedure 24"
 PR25      "Procedure 25"
 PR26      "Procedure 26"
 PR27      "Procedure 27"
 PR28      "Procedure 28"
 PR29      "Procedure 29"
 PR30      "Procedure 30"
 PR31      "Procedure 31"
 PR32      "Procedure 32"
 PR33      "Procedure 33"
 PR34      "Procedure 34"
 PR35      "Procedure 35"
 PR36      "Procedure 36"
 PR37      "Procedure 37"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRCCS22   "CCS: procedure 22"
 PRCCS23   "CCS: procedure 23"
 PRCCS24   "CCS: procedure 24"
 PRCCS25   "CCS: procedure 25"
 PRCCS26   "CCS: procedure 26"
 PRCCS27   "CCS: procedure 27"
 PRCCS28   "CCS: procedure 28"
 PRCCS29   "CCS: procedure 29"
 PRCCS30   "CCS: procedure 30"
 PRCCS31   "CCS: procedure 31"
 PRCCS32   "CCS: procedure 32"
 PRCCS33   "CCS: procedure 33"
 PRCCS34   "CCS: procedure 34"
 PRCCS35   "CCS: procedure 35"
 PRCCS36   "CCS: procedure 36"
 PRCCS37   "CCS: procedure 37"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 PRDAY16   "Number of days from admission to PR16"
 PRDAY17   "Number of days from admission to PR17"
 PRDAY18   "Number of days from admission to PR18"
 PRDAY19   "Number of days from admission to PR19"
 PRDAY20   "Number of days from admission to PR20"
 PRDAY21   "Number of days from admission to PR21"
 PRDAY22   "Number of days from admission to PR22"
 PRDAY23   "Number of days from admission to PR23"
 PRDAY24   "Number of days from admission to PR24"
 PRDAY25   "Number of days from admission to PR25"
 PRDAY26   "Number of days from admission to PR26"
 PRDAY27   "Number of days from admission to PR27"
 PRDAY28   "Number of days from admission to PR28"
 PRDAY29   "Number of days from admission to PR29"
 PRDAY30   "Number of days from admission to PR30"
 PRDAY31   "Number of days from admission to PR31"
 PRDAY32   "Number of days from admission to PR32"
 PRDAY33   "Number of days from admission to PR33"
 PRDAY34   "Number of days from admission to PR34"
 PRDAY35   "Number of days from admission to PR35"
 PRDAY36   "Number of days from admission to PR36"
 PRDAY37   "Number of days from admission to PR37"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 POFOUB04  "Point of origin for admission or visit, UB-04 standard coding"
 POFO_X    "Point of origin for admission or visit, as received from source"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRMNTH11  "Month of procedure 11"
 PRMNTH12  "Month of procedure 12"
 PRMNTH13  "Month of procedure 13"
 PRMNTH14  "Month of procedure 14"
 PRMNTH15  "Month of procedure 15"
 PRMNTH16  "Month of procedure 16"
 PRMNTH17  "Month of procedure 17"
 PRMNTH18  "Month of procedure 18"
 PRMNTH19  "Month of procedure 19"
 PRMNTH20  "Month of procedure 20"
 PRMNTH21  "Month of procedure 21"
 PRMNTH22  "Month of procedure 22"
 PRMNTH23  "Month of procedure 23"
 PRMNTH24  "Month of procedure 24"
 PRMNTH25  "Month of procedure 25"
 PRMNTH26  "Month of procedure 26"
 PRMNTH27  "Month of procedure 27"
 PRMNTH28  "Month of procedure 28"
 PRMNTH29  "Month of procedure 29"
 PRMNTH30  "Month of procedure 30"
 PRMNTH31  "Month of procedure 31"
 PRMNTH32  "Month of procedure 32"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10"
 PRYEAR11  "Year of procedure 11"
 PRYEAR12  "Year of procedure 12"
 PRYEAR13  "Year of procedure 13"
 PRYEAR14  "Year of procedure 14"
 PRYEAR15  "Year of procedure 15"
 PRYEAR16  "Year of procedure 16"
 PRYEAR17  "Year of procedure 17"
 PRYEAR18  "Year of procedure 18"
 PRYEAR19  "Year of procedure 19"
 PRYEAR20  "Year of procedure 20"
 PRYEAR21  "Year of procedure 21"
 PRYEAR22  "Year of procedure 22"
 PRYEAR23  "Year of procedure 23"
 PRYEAR24  "Year of procedure 24"
 PRYEAR25  "Year of procedure 25"
 PRYEAR26  "Year of procedure 26"
 PRYEAR27  "Year of procedure 27"
 PRYEAR28  "Year of procedure 28"
 PRYEAR29  "Year of procedure 29"
 PRYEAR30  "Year of procedure 30"
 PRYEAR31  "Year of procedure 31"
 PRYEAR32  "Year of procedure 32" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPO
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS51
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS52
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS53
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS54
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS55
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS56
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS57
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS58
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS59
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS60
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS61
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS62
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS63
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS64
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS65
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS66
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Hospital
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'IA_SID_2008_CORE.SAV' /COMPRESSED.
