/*******************************************************************
*   IA_SID_2009_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'IA_SID_2009_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ATYPE                     12-  13
 AWEEKEND                  14-  15
 DIED                      16-  17
 DISPUB04                  18-  19
 DISPUNIFORM               20-  21
 DISP_X                    22-  25 (A)
 DQTR                      26-  27
 DRG                       28-  30
 DRG24                     31-  33
 DRGVER                    34-  35
 DRG_NoPOA                 36-  38
 DSHOSPID                  39-  55 (A)
 DX1                       56-  60 (A)
 DX2                       61-  65 (A)
 DX3                       66-  70 (A)
 DX4                       71-  75 (A)
 DX5                       76-  80 (A)
 DX6                       81-  85 (A)
 DX7                       86-  90 (A)
 DX8                       91-  95 (A)
 DX9                       96- 100 (A)
 DX10                     101- 105 (A)
 DX11                     106- 110 (A)
 DX12                     111- 115 (A)
 DX13                     116- 120 (A)
 DX14                     121- 125 (A)
 DX15                     126- 130 (A)
 DX16                     131- 135 (A)
 DX17                     136- 140 (A)
 DX18                     141- 145 (A)
 DX19                     146- 150 (A)
 DX20                     151- 155 (A)
 DX21                     156- 160 (A)
 DX22                     161- 165 (A)
 DX23                     166- 170 (A)
 DX24                     171- 175 (A)
 DX25                     176- 180 (A)
 DX26                     181- 185 (A)
 DX27                     186- 190 (A)
 DX28                     191- 195 (A)
 DX29                     196- 200 (A)
 DX30                     201- 205 (A)
 DX31                     206- 210 (A)
 DX32                     211- 215 (A)
 DX33                     216- 220 (A)
 DX34                     221- 225 (A)
 DX35                     226- 230 (A)
 DX36                     231- 235 (A)
 DX37                     236- 240 (A)
 DX38                     241- 245 (A)
 DX39                     246- 250 (A)
 DX40                     251- 255 (A)
 DX41                     256- 260 (A)
 DX42                     261- 265 (A)
 DX43                     266- 270 (A)
 DX44                     271- 275 (A)
 DX45                     276- 280 (A)
 DX46                     281- 285 (A)
 DX47                     286- 290 (A)
 DX48                     291- 295 (A)
 DX49                     296- 300 (A)
 DX50                     301- 305 (A)
 DX51                     306- 310 (A)
 DX52                     311- 315 (A)
 DX53                     316- 320 (A)
 DX54                     321- 325 (A)
 DX55                     326- 330 (A)
 DX56                     331- 335 (A)
 DX57                     336- 340 (A)
 DX58                     341- 345 (A)
 DX59                     346- 350 (A)
 DX60                     351- 355 (A)
 DX61                     356- 360 (A)
 DX62                     361- 365 (A)
 DXCCS1                   366- 369
 DXCCS2                   370- 373
 DXCCS3                   374- 377
 DXCCS4                   378- 381
 DXCCS5                   382- 385
 DXCCS6                   386- 389
 DXCCS7                   390- 393
 DXCCS8                   394- 397
 DXCCS9                   398- 401
 DXCCS10                  402- 405
 DXCCS11                  406- 409
 DXCCS12                  410- 413
 DXCCS13                  414- 417
 DXCCS14                  418- 421
 DXCCS15                  422- 425
 DXCCS16                  426- 429
 DXCCS17                  430- 433
 DXCCS18                  434- 437
 DXCCS19                  438- 441
 DXCCS20                  442- 445
 DXCCS21                  446- 449
 DXCCS22                  450- 453
 DXCCS23                  454- 457
 DXCCS24                  458- 461
 DXCCS25                  462- 465
 DXCCS26                  466- 469
 DXCCS27                  470- 473
 DXCCS28                  474- 477
 DXCCS29                  478- 481
 DXCCS30                  482- 485
 DXCCS31                  486- 489
 DXCCS32                  490- 493
 DXCCS33                  494- 497
 DXCCS34                  498- 501
 DXCCS35                  502- 505
 DXCCS36                  506- 509
 DXCCS37                  510- 513
 DXCCS38                  514- 517
 DXCCS39                  518- 521
 DXCCS40                  522- 525
 DXCCS41                  526- 529
 DXCCS42                  530- 533
 DXCCS43                  534- 537
 DXCCS44                  538- 541
 DXCCS45                  542- 545
 DXCCS46                  546- 549
 DXCCS47                  550- 553
 DXCCS48                  554- 557
 DXCCS49                  558- 561
 DXCCS50                  562- 565
 DXCCS51                  566- 569
 DXCCS52                  570- 573
 DXCCS53                  574- 577
 DXCCS54                  578- 581
 DXCCS55                  582- 585
 DXCCS56                  586- 589
 DXCCS57                  590- 593
 DXCCS58                  594- 597
 DXCCS59                  598- 601
 DXCCS60                  602- 605
 DXCCS61                  606- 609
 DXCCS62                  610- 613
 DXPOA1                   614     (A)
 DXPOA2                   615     (A)
 DXPOA3                   616     (A)
 DXPOA4                   617     (A)
 DXPOA5                   618     (A)
 DXPOA6                   619     (A)
 DXPOA7                   620     (A)
 DXPOA8                   621     (A)
 DXPOA9                   622     (A)
 DXPOA10                  623     (A)
 DXPOA11                  624     (A)
 DXPOA12                  625     (A)
 DXPOA13                  626     (A)
 DXPOA14                  627     (A)
 DXPOA15                  628     (A)
 DXPOA16                  629     (A)
 DXPOA17                  630     (A)
 DXPOA18                  631     (A)
 DXPOA19                  632     (A)
 DXPOA20                  633     (A)
 DXPOA21                  634     (A)
 DXPOA22                  635     (A)
 DXPOA23                  636     (A)
 DXPOA24                  637     (A)
 DXPOA25                  638     (A)
 DXPOA26                  639     (A)
 DXPOA27                  640     (A)
 DXPOA28                  641     (A)
 DXPOA29                  642     (A)
 DXPOA30                  643     (A)
 DXPOA31                  644     (A)
 DXPOA32                  645     (A)
 DXPOA33                  646     (A)
 DXPOA34                  647     (A)
 DXPOA35                  648     (A)
 DXPOA36                  649     (A)
 DXPOA37                  650     (A)
 DXPOA38                  651     (A)
 DXPOA39                  652     (A)
 DXPOA40                  653     (A)
 DXPOA41                  654     (A)
 DXPOA42                  655     (A)
 DXPOA43                  656     (A)
 DXPOA44                  657     (A)
 DXPOA45                  658     (A)
 DXPOA46                  659     (A)
 DXPOA47                  660     (A)
 DXPOA48                  661     (A)
 DXPOA49                  662     (A)
 DXPOA50                  663     (A)
 DXPOA51                  664     (A)
 DXPOA52                  665     (A)
 DXPOA53                  666     (A)
 DXPOA54                  667     (A)
 DXPOA55                  668     (A)
 DXPOA56                  669     (A)
 DXPOA57                  670     (A)
 DXPOA58                  671     (A)
 DXPOA59                  672     (A)
 DXPOA60                  673     (A)
 DXPOA61                  674     (A)
 DXPOA62                  675     (A)
 DaysToEvent              676- 681
 ECODE1                   682- 686 (A)
 ECODE2                   687- 691 (A)
 ECODE3                   692- 696 (A)
 ECODE4                   697- 701 (A)
 ECODE5                   702- 706 (A)
 ECODE6                   707- 711 (A)
 ECODE7                   712- 716 (A)
 ECODE8                   717- 721 (A)
 ECODE9                   722- 726 (A)
 ECODE10                  727- 731 (A)
 ECODE11                  732- 736 (A)
 ECODE12                  737- 741 (A)
 E_CCS1                   742- 745
 E_CCS2                   746- 749
 E_CCS3                   750- 753
 E_CCS4                   754- 757
 E_CCS5                   758- 761
 E_CCS6                   762- 765
 E_CCS7                   766- 769
 E_CCS8                   770- 773
 E_CCS9                   774- 777
 E_CCS10                  778- 781
 E_CCS11                  782- 785
 E_CCS12                  786- 789
 E_POA1                   790     (A)
 E_POA2                   791     (A)
 E_POA3                   792     (A)
 E_POA4                   793     (A)
 E_POA5                   794     (A)
 E_POA6                   795     (A)
 E_POA7                   796     (A)
 E_POA8                   797     (A)
 E_POA9                   798     (A)
 E_POA10                  799     (A)
 E_POA11                  800     (A)
 E_POA12                  801     (A)
 FEMALE                   802- 803
 HCUP_ED                  804- 805
 HCUP_OS                  806- 807
 HOSPBRTH                 808- 810
 HOSPST                   811- 812 (A)
 HospitalUnit             813- 814
 KEY                      815- 832
 LOS                      833- 837
 LOS_X                    838- 843
 MDC                      844- 845
 MDC24                    846- 847
 MDNUM1_R                 848- 856
 MDNUM2_R                 857- 865
 MDNUM3_R                 866- 874
 MEDINCSTQ                875- 876
 MRN_R                    877- 885
 NCHRONIC                 886- 888
 NDX                      889- 890
 NECODE                   891- 892
 NEOMAT                   893- 894
 NPR                      895- 896
 ORPROC                   897- 898
 PAY1                     899- 900
 PAY1_X                   901- 904 (A)
 PL_CBSA                  905- 907
 PL_MSA1993               908- 910
 PL_NCHS2006              911- 912
 PL_RUCA10_2005           913- 914
 PL_RUCA2005              915- 918
 PL_RUCA4_2005            919- 920
 PL_RUCC2003              921- 922
 PL_UIC2003               923- 924
 PL_UR_CAT4               925- 926
 PNUM_R                   927- 935
 PR1                      936- 939 (A)
 PR2                      940- 943 (A)
 PR3                      944- 947 (A)
 PR4                      948- 951 (A)
 PR5                      952- 955 (A)
 PR6                      956- 959 (A)
 PR7                      960- 963 (A)
 PR8                      964- 967 (A)
 PR9                      968- 971 (A)
 PR10                     972- 975 (A)
 PR11                     976- 979 (A)
 PR12                     980- 983 (A)
 PR13                     984- 987 (A)
 PR14                     988- 991 (A)
 PR15                     992- 995 (A)
 PR16                     996- 999 (A)
 PR17                    1000-1003 (A)
 PR18                    1004-1007 (A)
 PR19                    1008-1011 (A)
 PR20                    1012-1015 (A)
 PR21                    1016-1019 (A)
 PR22                    1020-1023 (A)
 PR23                    1024-1027 (A)
 PR24                    1028-1031 (A)
 PR25                    1032-1035 (A)
 PR26                    1036-1039 (A)
 PR27                    1040-1043 (A)
 PR28                    1044-1047 (A)
 PR29                    1048-1051 (A)
 PR30                    1052-1055 (A)
 PR31                    1056-1059 (A)
 PR32                    1060-1063 (A)
 PR33                    1064-1067 (A)
 PR34                    1068-1071 (A)
 PR35                    1072-1075 (A)
 PR36                    1076-1079 (A)
 PR37                    1080-1083 (A)
 PRCCS1                  1084-1086
 PRCCS2                  1087-1089
 PRCCS3                  1090-1092
 PRCCS4                  1093-1095
 PRCCS5                  1096-1098
 PRCCS6                  1099-1101
 PRCCS7                  1102-1104
 PRCCS8                  1105-1107
 PRCCS9                  1108-1110
 PRCCS10                 1111-1113
 PRCCS11                 1114-1116
 PRCCS12                 1117-1119
 PRCCS13                 1120-1122
 PRCCS14                 1123-1125
 PRCCS15                 1126-1128
 PRCCS16                 1129-1131
 PRCCS17                 1132-1134
 PRCCS18                 1135-1137
 PRCCS19                 1138-1140
 PRCCS20                 1141-1143
 PRCCS21                 1144-1146
 PRCCS22                 1147-1149
 PRCCS23                 1150-1152
 PRCCS24                 1153-1155
 PRCCS25                 1156-1158
 PRCCS26                 1159-1161
 PRCCS27                 1162-1164
 PRCCS28                 1165-1167
 PRCCS29                 1168-1170
 PRCCS30                 1171-1173
 PRCCS31                 1174-1176
 PRCCS32                 1177-1179
 PRCCS33                 1180-1182
 PRCCS34                 1183-1185
 PRCCS35                 1186-1188
 PRCCS36                 1189-1191
 PRCCS37                 1192-1194
 PRDAY1                  1195-1199
 PRDAY2                  1200-1204
 PRDAY3                  1205-1209
 PRDAY4                  1210-1214
 PRDAY5                  1215-1219
 PRDAY6                  1220-1224
 PRDAY7                  1225-1229
 PRDAY8                  1230-1234
 PRDAY9                  1235-1239
 PRDAY10                 1240-1244
 PRDAY11                 1245-1249
 PRDAY12                 1250-1254
 PRDAY13                 1255-1259
 PRDAY14                 1260-1264
 PRDAY15                 1265-1269
 PRDAY16                 1270-1274
 PRDAY17                 1275-1279
 PRDAY18                 1280-1284
 PRDAY19                 1285-1289
 PRDAY20                 1290-1294
 PRDAY21                 1295-1299
 PRDAY22                 1300-1304
 PRDAY23                 1305-1309
 PRDAY24                 1310-1314
 PRDAY25                 1315-1319
 PRDAY26                 1320-1324
 PRDAY27                 1325-1329
 PRDAY28                 1330-1334
 PRDAY29                 1335-1339
 PRDAY30                 1340-1344
 PRDAY31                 1345-1349
 PRDAY32                 1350-1354
 PRDAY33                 1355-1359
 PRDAY34                 1360-1364
 PRDAY35                 1365-1369
 PRDAY36                 1370-1374
 PRDAY37                 1375-1379
 PROCTYPE                1380-1382
 PSTATE                  1383-1384 (A)
 PSTCO                   1385-1389
 PSTCO2                  1390-1394
 PointOfOriginUB04       1395     (A)
 PointOfOrigin_X         1396     (A)
 RACE                    1397-1398
 RACE_X                  1399-1402 (A)
 TOTCHG                  1403-1412
 TOTCHG_X                1413-1427
 TRAN_IN                 1428-1429
 TRAN_OUT                1430-1431
 VisitLink               1432-1440
 YEAR                    1441-1444
 ZIP3                    1445-1447 (A)
 ZIPINC_QRTL             1448-1450
 ZIP                     1451-1455 (A)
 AYEAR                   1456-1459
 DMONTH                  1460-1461
 BMONTH                  1462-1463
 BYEAR                   1464-1467
 PRMONTH1                1468-1469
 PRMONTH2                1470-1471
 PRMONTH3                1472-1473
 PRMONTH4                1474-1475
 PRMONTH5                1476-1477
 PRMONTH6                1478-1479
 PRMONTH7                1480-1481
 PRMONTH8                1482-1483
 PRMONTH9                1484-1485
 PRMONTH10               1486-1487
 PRMONTH11               1488-1489
 PRMONTH12               1490-1491
 PRMONTH13               1492-1493
 PRMONTH14               1494-1495
 PRMONTH15               1496-1497
 PRMONTH16               1498-1499
 PRMONTH17               1500-1501
 PRMONTH18               1502-1503
 PRMONTH19               1504-1505
 PRMONTH20               1506-1507
 PRMONTH21               1508-1509
 PRMONTH22               1510-1511
 PRMONTH23               1512-1513
 PRMONTH24               1514-1515
 PRMONTH25               1516-1517
 PRMONTH26               1518-1519
 PRMONTH27               1520-1521
 PRMONTH28               1522-1523
 PRMONTH29               1524-1525
 PRMONTH30               1526-1527
 PRMONTH31               1528-1529
 PRMONTH32               1530-1531
 PRYEAR1                 1532-1535
 PRYEAR2                 1536-1539
 PRYEAR3                 1540-1543
 PRYEAR4                 1544-1547
 PRYEAR5                 1548-1551
 PRYEAR6                 1552-1555
 PRYEAR7                 1556-1559
 PRYEAR8                 1560-1563
 PRYEAR9                 1564-1567
 PRYEAR10                1568-1571
 PRYEAR11                1572-1575
 PRYEAR12                1576-1579
 PRYEAR13                1580-1583
 PRYEAR14                1584-1587
 PRYEAR15                1588-1591
 PRYEAR16                1592-1595
 PRYEAR17                1596-1599
 PRYEAR18                1600-1603
 PRYEAR19                1604-1607
 PRYEAR20                1608-1611
 PRYEAR21                1612-1615
 PRYEAR22                1616-1619
 PRYEAR23                1620-1623
 PRYEAR24                1624-1627
 PRYEAR25                1628-1631
 PRYEAR26                1632-1635
 PRYEAR27                1636-1639
 PRYEAR28                1640-1643
 PRYEAR29                1644-1647
 PRYEAR30                1648-1651
 PRYEAR31                1652-1655
 PRYEAR32                1656-1659.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPOA               (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 DXCCS34                 (F4.0) /
 DXCCS35                 (F4.0) /
 DXCCS36                 (F4.0) /
 DXCCS37                 (F4.0) /
 DXCCS38                 (F4.0) /
 DXCCS39                 (F4.0) /
 DXCCS40                 (F4.0) /
 DXCCS41                 (F4.0) /
 DXCCS42                 (F4.0) /
 DXCCS43                 (F4.0) /
 DXCCS44                 (F4.0) /
 DXCCS45                 (F4.0) /
 DXCCS46                 (F4.0) /
 DXCCS47                 (F4.0) /
 DXCCS48                 (F4.0) /
 DXCCS49                 (F4.0) /
 DXCCS50                 (F4.0) /
 DXCCS51                 (F4.0) /
 DXCCS52                 (F4.0) /
 DXCCS53                 (F4.0) /
 DXCCS54                 (F4.0) /
 DXCCS55                 (F4.0) /
 DXCCS56                 (F4.0) /
 DXCCS57                 (F4.0) /
 DXCCS58                 (F4.0) /
 DXCCS59                 (F4.0) /
 DXCCS60                 (F4.0) /
 DXCCS61                 (F4.0) /
 DXCCS62                 (F4.0) /
 DaysToEvent             (F8.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 E_CCS10                 (F3.0) /
 E_CCS11                 (F3.0) /
 E_CCS12                 (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 HospitalUnit            (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MDNUM3_R                (F5.0) /
 MEDINCSTQ               (F3.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PNUM_R                  (F5.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRCCS31                 (F3.0) /
 PRCCS32                 (F3.0) /
 PRCCS33                 (F3.0) /
 PRCCS34                 (F3.0) /
 PRCCS35                 (F3.0) /
 PRCCS36                 (F3.0) /
 PRCCS37                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PRDAY24                 (F4.0) /
 PRDAY25                 (F4.0) /
 PRDAY26                 (F4.0) /
 PRDAY27                 (F4.0) /
 PRDAY28                 (F4.0) /
 PRDAY29                 (F4.0) /
 PRDAY30                 (F4.0) /
 PRDAY31                 (F4.0) /
 PRDAY32                 (F4.0) /
 PRDAY33                 (F4.0) /
 PRDAY34                 (F4.0) /
 PRDAY35                 (F4.0) /
 PRDAY36                 (F4.0) /
 PRDAY37                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TRAN_IN                 (F3.0) /
 TRAN_OUT                (F3.0) /
 VisitLink               (F8.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRMONTH16               (F3.0) /
 PRMONTH17               (F3.0) /
 PRMONTH18               (F3.0) /
 PRMONTH19               (F3.0) /
 PRMONTH20               (F3.0) /
 PRMONTH21               (F3.0) /
 PRMONTH22               (F3.0) /
 PRMONTH23               (F3.0) /
 PRMONTH24               (F3.0) /
 PRMONTH25               (F3.0) /
 PRMONTH26               (F3.0) /
 PRMONTH27               (F3.0) /
 PRMONTH28               (F3.0) /
 PRMONTH29               (F3.0) /
 PRMONTH30               (F3.0) /
 PRMONTH31               (F3.0) /
 PRMONTH32               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) /
 PRYEAR24                (F3.0) /
 PRYEAR25                (F3.0) /
 PRYEAR26                (F3.0) /
 PRYEAR27                (F3.0) /
 PRYEAR28                (F3.0) /
 PRYEAR29                (F3.0) /
 PRYEAR30                (F3.0) /
 PRYEAR31                (F3.0) /
 PRYEAR32                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMONTH                  "Admission month"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DRG_NoPOA               "DRG in use on discharge date, calculated without POA"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DX26                    "Diagnosis 26"
 DX27                    "Diagnosis 27"
 DX28                    "Diagnosis 28"
 DX29                    "Diagnosis 29"
 DX30                    "Diagnosis 30"
 DX31                    "Diagnosis 31"
 DX32                    "Diagnosis 32"
 DX33                    "Diagnosis 33"
 DX34                    "Diagnosis 34"
 DX35                    "Diagnosis 35"
 DX36                    "Diagnosis 36"
 DX37                    "Diagnosis 37"
 DX38                    "Diagnosis 38"
 DX39                    "Diagnosis 39"
 DX40                    "Diagnosis 40"
 DX41                    "Diagnosis 41"
 DX42                    "Diagnosis 42"
 DX43                    "Diagnosis 43"
 DX44                    "Diagnosis 44"
 DX45                    "Diagnosis 45"
 DX46                    "Diagnosis 46"
 DX47                    "Diagnosis 47"
 DX48                    "Diagnosis 48"
 DX49                    "Diagnosis 49"
 DX50                    "Diagnosis 50"
 DX51                    "Diagnosis 51"
 DX52                    "Diagnosis 52"
 DX53                    "Diagnosis 53"
 DX54                    "Diagnosis 54"
 DX55                    "Diagnosis 55"
 DX56                    "Diagnosis 56"
 DX57                    "Diagnosis 57"
 DX58                    "Diagnosis 58"
 DX59                    "Diagnosis 59"
 DX60                    "Diagnosis 60"
 DX61                    "Diagnosis 61"
 DX62                    "Diagnosis 62"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXCCS26                 "CCS: diagnosis 26"
 DXCCS27                 "CCS: diagnosis 27"
 DXCCS28                 "CCS: diagnosis 28"
 DXCCS29                 "CCS: diagnosis 29"
 DXCCS30                 "CCS: diagnosis 30"
 DXCCS31                 "CCS: diagnosis 31"
 DXCCS32                 "CCS: diagnosis 32"
 DXCCS33                 "CCS: diagnosis 33"
 DXCCS34                 "CCS: diagnosis 34"
 DXCCS35                 "CCS: diagnosis 35"
 DXCCS36                 "CCS: diagnosis 36"
 DXCCS37                 "CCS: diagnosis 37"
 DXCCS38                 "CCS: diagnosis 38"
 DXCCS39                 "CCS: diagnosis 39"
 DXCCS40                 "CCS: diagnosis 40"
 DXCCS41                 "CCS: diagnosis 41"
 DXCCS42                 "CCS: diagnosis 42"
 DXCCS43                 "CCS: diagnosis 43"
 DXCCS44                 "CCS: diagnosis 44"
 DXCCS45                 "CCS: diagnosis 45"
 DXCCS46                 "CCS: diagnosis 46"
 DXCCS47                 "CCS: diagnosis 47"
 DXCCS48                 "CCS: diagnosis 48"
 DXCCS49                 "CCS: diagnosis 49"
 DXCCS50                 "CCS: diagnosis 50"
 DXCCS51                 "CCS: diagnosis 51"
 DXCCS52                 "CCS: diagnosis 52"
 DXCCS53                 "CCS: diagnosis 53"
 DXCCS54                 "CCS: diagnosis 54"
 DXCCS55                 "CCS: diagnosis 55"
 DXCCS56                 "CCS: diagnosis 56"
 DXCCS57                 "CCS: diagnosis 57"
 DXCCS58                 "CCS: diagnosis 58"
 DXCCS59                 "CCS: diagnosis 59"
 DXCCS60                 "CCS: diagnosis 60"
 DXCCS61                 "CCS: diagnosis 61"
 DXCCS62                 "CCS: diagnosis 62"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DXPOA7                  "Diagnosis 7, present on admission indicator"
 DXPOA8                  "Diagnosis 8, present on admission indicator"
 DXPOA9                  "Diagnosis 9, present on admission indicator"
 DXPOA10                 "Diagnosis 10, present on admission indicator"
 DXPOA11                 "Diagnosis 11, present on admission indicator"
 DXPOA12                 "Diagnosis 12, present on admission indicator"
 DXPOA13                 "Diagnosis 13, present on admission indicator"
 DXPOA14                 "Diagnosis 14, present on admission indicator"
 DXPOA15                 "Diagnosis 15, present on admission indicator"
 DXPOA16                 "Diagnosis 16, present on admission indicator"
 DXPOA17                 "Diagnosis 17, present on admission indicator"
 DXPOA18                 "Diagnosis 18, present on admission indicator"
 DXPOA19                 "Diagnosis 19, present on admission indicator"
 DXPOA20                 "Diagnosis 20, present on admission indicator"
 DXPOA21                 "Diagnosis 21, present on admission indicator"
 DXPOA22                 "Diagnosis 22, present on admission indicator"
 DXPOA23                 "Diagnosis 23, present on admission indicator"
 DXPOA24                 "Diagnosis 24, present on admission indicator"
 DXPOA25                 "Diagnosis 25, present on admission indicator"
 DXPOA26                 "Diagnosis 26, present on admission indicator"
 DXPOA27                 "Diagnosis 27, present on admission indicator"
 DXPOA28                 "Diagnosis 28, present on admission indicator"
 DXPOA29                 "Diagnosis 29, present on admission indicator"
 DXPOA30                 "Diagnosis 30, present on admission indicator"
 DXPOA31                 "Diagnosis 31, present on admission indicator"
 DXPOA32                 "Diagnosis 32, present on admission indicator"
 DXPOA33                 "Diagnosis 33, present on admission indicator"
 DXPOA34                 "Diagnosis 34, present on admission indicator"
 DXPOA35                 "Diagnosis 35, present on admission indicator"
 DXPOA36                 "Diagnosis 36, present on admission indicator"
 DXPOA37                 "Diagnosis 37, present on admission indicator"
 DXPOA38                 "Diagnosis 38, present on admission indicator"
 DXPOA39                 "Diagnosis 39, present on admission indicator"
 DXPOA40                 "Diagnosis 40, present on admission indicator"
 DXPOA41                 "Diagnosis 41, present on admission indicator"
 DXPOA42                 "Diagnosis 42, present on admission indicator"
 DXPOA43                 "Diagnosis 43, present on admission indicator"
 DXPOA44                 "Diagnosis 44, present on admission indicator"
 DXPOA45                 "Diagnosis 45, present on admission indicator"
 DXPOA46                 "Diagnosis 46, present on admission indicator"
 DXPOA47                 "Diagnosis 47, present on admission indicator"
 DXPOA48                 "Diagnosis 48, present on admission indicator"
 DXPOA49                 "Diagnosis 49, present on admission indicator"
 DXPOA50                 "Diagnosis 50, present on admission indicator"
 DXPOA51                 "Diagnosis 51, present on admission indicator"
 DXPOA52                 "Diagnosis 52, present on admission indicator"
 DXPOA53                 "Diagnosis 53, present on admission indicator"
 DXPOA54                 "Diagnosis 54, present on admission indicator"
 DXPOA55                 "Diagnosis 55, present on admission indicator"
 DXPOA56                 "Diagnosis 56, present on admission indicator"
 DXPOA57                 "Diagnosis 57, present on admission indicator"
 DXPOA58                 "Diagnosis 58, present on admission indicator"
 DXPOA59                 "Diagnosis 59, present on admission indicator"
 DXPOA60                 "Diagnosis 60, present on admission indicator"
 DXPOA61                 "Diagnosis 61, present on admission indicator"
 DXPOA62                 "Diagnosis 62, present on admission indicator"
 DaysToEvent             "Days from 'start date' to admission"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 ECODE9                  "E code 9"
 ECODE10                 "E code 10"
 ECODE11                 "E code 11"
 ECODE12                 "E code 12"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 E_CCS9                  "CCS: E Code 9"
 E_CCS10                 "CCS: E Code 10"
 E_CCS11                 "CCS: E Code 11"
 E_CCS12                 "CCS: E Code 12"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 E_POA5                  "E Code 5, present on admission indicator"
 E_POA6                  "E Code 6, present on admission indicator"
 E_POA7                  "E Code 7, present on admission indicator"
 E_POA8                  "E Code 8, present on admission indicator"
 E_POA9                  "E Code 9, present on admission indicator"
 E_POA10                 "E Code 10, present on admission indicator"
 E_POA11                 "E Code 11, present on admission indicator"
 E_POA12                 "E Code 12, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 HospitalUnit

"Indicator that patient was discharged from a special unit within an acute care hospital (re
ported by source)"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MDC                     "MDC in effect on discharge date"
 MDC24                   "MDC, version 24"
 MDNUM1_R                "Physician 1 number (re-identified)"
 MDNUM2_R                "Physician 2 number (re-identified)"
 MDNUM3_R                "Physician 3 number (re-identified)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PNUM_R                  "Person number (re-identified)"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PR21                    "Procedure 21"
 PR22                    "Procedure 22"
 PR23                    "Procedure 23"
 PR24                    "Procedure 24"
 PR25                    "Procedure 25"
 PR26                    "Procedure 26"
 PR27                    "Procedure 27"
 PR28                    "Procedure 28"
 PR29                    "Procedure 29"
 PR30                    "Procedure 30"
 PR31                    "Procedure 31"
 PR32                    "Procedure 32"
 PR33                    "Procedure 33"
 PR34                    "Procedure 34"
 PR35                    "Procedure 35"
 PR36                    "Procedure 36"
 PR37                    "Procedure 37"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRCCS21                 "CCS: procedure 21"
 PRCCS22                 "CCS: procedure 22"
 PRCCS23                 "CCS: procedure 23"
 PRCCS24                 "CCS: procedure 24"
 PRCCS25                 "CCS: procedure 25"
 PRCCS26                 "CCS: procedure 26"
 PRCCS27                 "CCS: procedure 27"
 PRCCS28                 "CCS: procedure 28"
 PRCCS29                 "CCS: procedure 29"
 PRCCS30                 "CCS: procedure 30"
 PRCCS31                 "CCS: procedure 31"
 PRCCS32                 "CCS: procedure 32"
 PRCCS33                 "CCS: procedure 33"
 PRCCS34                 "CCS: procedure 34"
 PRCCS35                 "CCS: procedure 35"
 PRCCS36                 "CCS: procedure 36"
 PRCCS37                 "CCS: procedure 37"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PRDAY16                 "Number of days from admission to PR16"
 PRDAY17                 "Number of days from admission to PR17"
 PRDAY18                 "Number of days from admission to PR18"
 PRDAY19                 "Number of days from admission to PR19"
 PRDAY20                 "Number of days from admission to PR20"
 PRDAY21                 "Number of days from admission to PR21"
 PRDAY22                 "Number of days from admission to PR22"
 PRDAY23                 "Number of days from admission to PR23"
 PRDAY24                 "Number of days from admission to PR24"
 PRDAY25                 "Number of days from admission to PR25"
 PRDAY26                 "Number of days from admission to PR26"
 PRDAY27                 "Number of days from admission to PR27"
 PRDAY28                 "Number of days from admission to PR28"
 PRDAY29                 "Number of days from admission to PR29"
 PRDAY30                 "Number of days from admission to PR30"
 PRDAY31                 "Number of days from admission to PR31"
 PRDAY32                 "Number of days from admission to PR32"
 PRDAY33                 "Number of days from admission to PR33"
 PRDAY34                 "Number of days from admission to PR34"
 PRDAY35                 "Number of days from admission to PR35"
 PRDAY36                 "Number of days from admission to PR36"
 PRDAY37                 "Number of days from admission to PR37"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TRAN_IN                 "Transfer in indicator"
 TRAN_OUT                "Transfer out indicator"
 VisitLink               "Visit linkage variable"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRMONTH16               "Month of procedure 16"
 PRMONTH17               "Month of procedure 17"
 PRMONTH18               "Month of procedure 18"
 PRMONTH19               "Month of procedure 19"
 PRMONTH20               "Month of procedure 20"
 PRMONTH21               "Month of procedure 21"
 PRMONTH22               "Month of procedure 22"
 PRMONTH23               "Month of procedure 23"
 PRMONTH24               "Month of procedure 24"
 PRMONTH25               "Month of procedure 25"
 PRMONTH26               "Month of procedure 26"
 PRMONTH27               "Month of procedure 27"
 PRMONTH28               "Month of procedure 28"
 PRMONTH29               "Month of procedure 29"
 PRMONTH30               "Month of procedure 30"
 PRMONTH31               "Month of procedure 31"
 PRMONTH32               "Month of procedure 32"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15"
 PRYEAR16                "Year of procedure 16"
 PRYEAR17                "Year of procedure 17"
 PRYEAR18                "Year of procedure 18"
 PRYEAR19                "Year of procedure 19"
 PRYEAR20                "Year of procedure 20"
 PRYEAR21                "Year of procedure 21"
 PRYEAR22                "Year of procedure 22"
 PRYEAR23                "Year of procedure 23"
 PRYEAR24                "Year of procedure 24"
 PRYEAR25                "Year of procedure 25"
 PRYEAR26                "Year of procedure 26"
 PRYEAR27                "Year of procedure 27"
 PRYEAR28                "Year of procedure 28"
 PRYEAR29                "Year of procedure 29"
 PRYEAR30                "Year of procedure 30"
 PRYEAR31                "Year of procedure 31"
 PRYEAR32                "Year of procedure 32" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS51
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS52
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS53
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS54
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS55
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS56
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS57
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS58
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS59
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS60
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS61
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS62
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'IA_SID_2009_CORE.SAV' /COMPRESSED.
