/*******************************************************************
*   IA_SID_2012_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'IA_SID_2012_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRON11                   21-  22
 CHRON12                   23-  24
 CHRON13                   25-  26
 CHRON14                   27-  28
 CHRON15                   29-  30
 CHRON16                   31-  32
 CHRON17                   33-  34
 CHRON18                   35-  36
 CHRON19                   37-  38
 CHRON20                   39-  40
 CHRON21                   41-  42
 CHRON22                   43-  44
 CHRON23                   45-  46
 CHRON24                   47-  48
 CHRON25                   49-  50
 CHRON26                   51-  52
 CHRON27                   53-  54
 CHRON28                   55-  56
 CHRON29                   57-  58
 CHRON30                   59-  60
 CHRON31                   61-  62
 CHRON32                   63-  64
 CHRON33                   65-  66
 CHRON34                   67-  68
 CHRON35                   69-  70
 CHRON36                   71-  72
 CHRON37                   73-  74
 CHRON38                   75-  76
 CHRON39                   77-  78
 CHRON40                   79-  80
 CHRON41                   81-  82
 CHRON42                   83-  84
 CHRON43                   85-  86
 CHRON44                   87-  88
 CHRON45                   89-  90
 CHRON46                   91-  92
 CHRON47                   93-  94
 CHRON48                   95-  96
 CHRON49                   97-  98
 CHRON50                   99- 100
 CHRON51                  101- 102
 CHRON52                  103- 104
 CHRON53                  105- 106
 CHRON54                  107- 108
 CHRON55                  109- 110
 CHRON56                  111- 112
 CHRON57                  113- 114
 CHRONB1                  115- 116
 CHRONB2                  117- 118
 CHRONB3                  119- 120
 CHRONB4                  121- 122
 CHRONB5                  123- 124
 CHRONB6                  125- 126
 CHRONB7                  127- 128
 CHRONB8                  129- 130
 CHRONB9                  131- 132
 CHRONB10                 133- 134
 CHRONB11                 135- 136
 CHRONB12                 137- 138
 CHRONB13                 139- 140
 CHRONB14                 141- 142
 CHRONB15                 143- 144
 CHRONB16                 145- 146
 CHRONB17                 147- 148
 CHRONB18                 149- 150
 CHRONB19                 151- 152
 CHRONB20                 153- 154
 CHRONB21                 155- 156
 CHRONB22                 157- 158
 CHRONB23                 159- 160
 CHRONB24                 161- 162
 CHRONB25                 163- 164
 CHRONB26                 165- 166
 CHRONB27                 167- 168
 CHRONB28                 169- 170
 CHRONB29                 171- 172
 CHRONB30                 173- 174
 CHRONB31                 175- 176
 CHRONB32                 177- 178
 CHRONB33                 179- 180
 CHRONB34                 181- 182
 CHRONB35                 183- 184
 CHRONB36                 185- 186
 CHRONB37                 187- 188
 CHRONB38                 189- 190
 CHRONB39                 191- 192
 CHRONB40                 193- 194
 CHRONB41                 195- 196
 CHRONB42                 197- 198
 CHRONB43                 199- 200
 CHRONB44                 201- 202
 CHRONB45                 203- 204
 CHRONB46                 205- 206
 CHRONB47                 207- 208
 CHRONB48                 209- 210
 CHRONB49                 211- 212
 CHRONB50                 213- 214
 CHRONB51                 215- 216
 CHRONB52                 217- 218
 CHRONB53                 219- 220
 CHRONB54                 221- 222
 CHRONB55                 223- 224
 CHRONB56                 225- 226
 CHRONB57                 227- 228
 DXMCCS1                  229- 239 (A)
 DXMCCS2                  240- 250 (A)
 DXMCCS3                  251- 261 (A)
 DXMCCS4                  262- 272 (A)
 DXMCCS5                  273- 283 (A)
 DXMCCS6                  284- 294 (A)
 DXMCCS7                  295- 305 (A)
 DXMCCS8                  306- 316 (A)
 DXMCCS9                  317- 327 (A)
 DXMCCS10                 328- 338 (A)
 DXMCCS11                 339- 349 (A)
 DXMCCS12                 350- 360 (A)
 DXMCCS13                 361- 371 (A)
 DXMCCS14                 372- 382 (A)
 DXMCCS15                 383- 393 (A)
 DXMCCS16                 394- 404 (A)
 DXMCCS17                 405- 415 (A)
 DXMCCS18                 416- 426 (A)
 DXMCCS19                 427- 437 (A)
 DXMCCS20                 438- 448 (A)
 DXMCCS21                 449- 459 (A)
 DXMCCS22                 460- 470 (A)
 DXMCCS23                 471- 481 (A)
 DXMCCS24                 482- 492 (A)
 DXMCCS25                 493- 503 (A)
 DXMCCS26                 504- 514 (A)
 DXMCCS27                 515- 525 (A)
 DXMCCS28                 526- 536 (A)
 DXMCCS29                 537- 547 (A)
 DXMCCS30                 548- 558 (A)
 DXMCCS31                 559- 569 (A)
 DXMCCS32                 570- 580 (A)
 DXMCCS33                 581- 591 (A)
 DXMCCS34                 592- 602 (A)
 DXMCCS35                 603- 613 (A)
 DXMCCS36                 614- 624 (A)
 DXMCCS37                 625- 635 (A)
 DXMCCS38                 636- 646 (A)
 DXMCCS39                 647- 657 (A)
 DXMCCS40                 658- 668 (A)
 DXMCCS41                 669- 679 (A)
 DXMCCS42                 680- 690 (A)
 DXMCCS43                 691- 701 (A)
 DXMCCS44                 702- 712 (A)
 DXMCCS45                 713- 723 (A)
 DXMCCS46                 724- 734 (A)
 DXMCCS47                 735- 745 (A)
 DXMCCS48                 746- 756 (A)
 DXMCCS49                 757- 767 (A)
 DXMCCS50                 768- 778 (A)
 DXMCCS51                 779- 789 (A)
 DXMCCS52                 790- 800 (A)
 DXMCCS53                 801- 811 (A)
 DXMCCS54                 812- 822 (A)
 DXMCCS55                 823- 833 (A)
 DXMCCS56                 834- 844 (A)
 DXMCCS57                 845- 855 (A)
 E_MCCS1                  856- 866 (A)
 E_MCCS2                  867- 877 (A)
 E_MCCS3                  878- 888 (A)
 E_MCCS4                  889- 899 (A)
 E_MCCS5                  900- 910 (A)
 E_MCCS6                  911- 921 (A)
 E_MCCS7                  922- 932 (A)
 E_MCCS8                  933- 943 (A)
 E_MCCS9                  944- 954 (A)
 INJURY                   955- 956
 INJURY_CUT               957- 958
 INJURY_DROWN             959- 960
 INJURY_FALL              961- 962
 INJURY_FIRE              963- 964
 INJURY_FIREARM           965- 966
 INJURY_MACHINERY         967- 968
 INJURY_MVT               969- 970
 INJURY_NATURE            971- 972
 INJURY_POISON            973- 974
 INJURY_STRUCK            975- 976
 INJURY_SUFFOCATION       977- 978
 INTENT_ASSAULT           979- 980
 INTENT_SELF_HARM         981- 982
 INTENT_UNINTENTIONAL     983- 984
 KEY                      985- 999
 MULTINJURY              1000-1001
 PCLASS1                 1002-1003
 PCLASS2                 1004-1005
 PCLASS3                 1006-1007
 PCLASS4                 1008-1009
 PCLASS5                 1010-1011
 PCLASS6                 1012-1013
 PCLASS7                 1014-1015
 PCLASS8                 1016-1017
 PCLASS9                 1018-1019
 PCLASS10                1020-1021
 PCLASS11                1022-1023
 PCLASS12                1024-1025
 PCLASS13                1026-1027
 PCLASS14                1028-1029
 PCLASS15                1030-1031
 PCLASS16                1032-1033
 PCLASS17                1034-1035
 PCLASS18                1036-1037
 PCLASS19                1038-1039
 PCLASS20                1040-1041
 PCLASS21                1042-1043
 PCLASS22                1044-1045
 PCLASS23                1046-1047
 PCLASS24                1048-1049
 PCLASS25                1050-1051
 PCLASS26                1052-1053
 PCLASS27                1054-1055
 PCLASS28                1056-1057
 PCLASS29                1058-1059
 PCLASS30                1060-1061
 PCLASS31                1062-1063
 PCLASS32                1064-1065
 PCLASS33                1066-1067
 PCLASS34                1068-1069
 PCLASS35                1070-1071
 PCLASS36                1072-1073
 PCLASS37                1074-1075
 PCLASS38                1076-1077
 PCLASS39                1078-1079
 PCLASS40                1080-1081
 PCLASS41                1082-1083
 PCLASS42                1084-1085
 PCLASS43                1086-1087
 PCLASS44                1088-1089
 PCLASS45                1090-1091
 PCLASS46                1092-1093
 PCLASS47                1094-1095
 PCLASS48                1096-1097
 PCLASS49                1098-1099
 PCLASS50                1100-1101
 PRMCCS1                 1102-1109 (A)
 PRMCCS2                 1110-1117 (A)
 PRMCCS3                 1118-1125 (A)
 PRMCCS4                 1126-1133 (A)
 PRMCCS5                 1134-1141 (A)
 PRMCCS6                 1142-1149 (A)
 PRMCCS7                 1150-1157 (A)
 PRMCCS8                 1158-1165 (A)
 PRMCCS9                 1166-1173 (A)
 PRMCCS10                1174-1181 (A)
 PRMCCS11                1182-1189 (A)
 PRMCCS12                1190-1197 (A)
 PRMCCS13                1198-1205 (A)
 PRMCCS14                1206-1213 (A)
 PRMCCS15                1214-1221 (A)
 PRMCCS16                1222-1229 (A)
 PRMCCS17                1230-1237 (A)
 PRMCCS18                1238-1245 (A)
 PRMCCS19                1246-1253 (A)
 PRMCCS20                1254-1261 (A)
 PRMCCS21                1262-1269 (A)
 PRMCCS22                1270-1277 (A)
 PRMCCS23                1278-1285 (A)
 PRMCCS24                1286-1293 (A)
 PRMCCS25                1294-1301 (A)
 PRMCCS26                1302-1309 (A)
 PRMCCS27                1310-1317 (A)
 PRMCCS28                1318-1325 (A)
 PRMCCS29                1326-1333 (A)
 PRMCCS30                1334-1341 (A)
 PRMCCS31                1342-1349 (A)
 PRMCCS32                1350-1357 (A)
 PRMCCS33                1358-1365 (A)
 PRMCCS34                1366-1373 (A)
 PRMCCS35                1374-1381 (A)
 PRMCCS36                1382-1389 (A)
 PRMCCS37                1390-1397 (A)
 PRMCCS38                1398-1405 (A)
 PRMCCS39                1406-1413 (A)
 PRMCCS40                1414-1421 (A)
 PRMCCS41                1422-1429 (A)
 PRMCCS42                1430-1437 (A)
 PRMCCS43                1438-1445 (A)
 PRMCCS44                1446-1453 (A)
 PRMCCS45                1454-1461 (A)
 PRMCCS46                1462-1469 (A)
 PRMCCS47                1470-1477 (A)
 PRMCCS48                1478-1485 (A)
 PRMCCS49                1486-1493 (A)
 PRMCCS50                1494-1501 (A)
 U_BLOOD                 1502-1503
 U_CATH                  1504-1505
 U_CCU                   1506-1507
 U_CHESTXRAY             1508-1509
 U_CTSCAN                1510-1511
 U_DIALYSIS              1512-1513
 U_ECHO                  1514-1515
 U_ED                    1516-1517
 U_EEG                   1518-1519
 U_EKG                   1520-1521
 U_EPO                   1522-1523
 U_ICU                   1524-1525
 U_LITHOTRIPSY           1526-1527
 U_MHSA                  1528-1529
 U_MRT                   1530-1531
 U_NEWBN2L               1532-1533
 U_NEWBN3L               1534-1535
 U_NEWBN4L               1536-1537
 U_NUCMED                1538-1539
 U_OBSERVATION           1540-1541
 U_OCCTHERAPY            1542-1543
 U_ORGANACQ              1544-1545
 U_OTHIMPLANTS           1546-1547
 U_PACEMAKER             1548-1549
 U_PHYTHERAPY            1550-1551
 U_RADTHERAPY            1552-1553
 U_RESPTHERAPY           1554-1555
 U_SPEECHTHERAPY         1556-1557
 U_STRESS                1558-1559
 U_ULTRASOUND            1560-1561.


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRON11                 (F3.0) /
 CHRON12                 (F3.0) /
 CHRON13                 (F3.0) /
 CHRON14                 (F3.0) /
 CHRON15                 (F3.0) /
 CHRON16                 (F3.0) /
 CHRON17                 (F3.0) /
 CHRON18                 (F3.0) /
 CHRON19                 (F3.0) /
 CHRON20                 (F3.0) /
 CHRON21                 (F3.0) /
 CHRON22                 (F3.0) /
 CHRON23                 (F3.0) /
 CHRON24                 (F3.0) /
 CHRON25                 (F3.0) /
 CHRON26                 (F3.0) /
 CHRON27                 (F3.0) /
 CHRON28                 (F3.0) /
 CHRON29                 (F3.0) /
 CHRON30                 (F3.0) /
 CHRON31                 (F3.0) /
 CHRON32                 (F3.0) /
 CHRON33                 (F3.0) /
 CHRON34                 (F3.0) /
 CHRON35                 (F3.0) /
 CHRON36                 (F3.0) /
 CHRON37                 (F3.0) /
 CHRON38                 (F3.0) /
 CHRON39                 (F3.0) /
 CHRON40                 (F3.0) /
 CHRON41                 (F3.0) /
 CHRON42                 (F3.0) /
 CHRON43                 (F3.0) /
 CHRON44                 (F3.0) /
 CHRON45                 (F3.0) /
 CHRON46                 (F3.0) /
 CHRON47                 (F3.0) /
 CHRON48                 (F3.0) /
 CHRON49                 (F3.0) /
 CHRON50                 (F3.0) /
 CHRON51                 (F3.0) /
 CHRON52                 (F3.0) /
 CHRON53                 (F3.0) /
 CHRON54                 (F3.0) /
 CHRON55                 (F3.0) /
 CHRON56                 (F3.0) /
 CHRON57                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 CHRONB11                (F3.0) /
 CHRONB12                (F3.0) /
 CHRONB13                (F3.0) /
 CHRONB14                (F3.0) /
 CHRONB15                (F3.0) /
 CHRONB16                (F3.0) /
 CHRONB17                (F3.0) /
 CHRONB18                (F3.0) /
 CHRONB19                (F3.0) /
 CHRONB20                (F3.0) /
 CHRONB21                (F3.0) /
 CHRONB22                (F3.0) /
 CHRONB23                (F3.0) /
 CHRONB24                (F3.0) /
 CHRONB25                (F3.0) /
 CHRONB26                (F3.0) /
 CHRONB27                (F3.0) /
 CHRONB28                (F3.0) /
 CHRONB29                (F3.0) /
 CHRONB30                (F3.0) /
 CHRONB31                (F3.0) /
 CHRONB32                (F3.0) /
 CHRONB33                (F3.0) /
 CHRONB34                (F3.0) /
 CHRONB35                (F3.0) /
 CHRONB36                (F3.0) /
 CHRONB37                (F3.0) /
 CHRONB38                (F3.0) /
 CHRONB39                (F3.0) /
 CHRONB40                (F3.0) /
 CHRONB41                (F3.0) /
 CHRONB42                (F3.0) /
 CHRONB43                (F3.0) /
 CHRONB44                (F3.0) /
 CHRONB45                (F3.0) /
 CHRONB46                (F3.0) /
 CHRONB47                (F3.0) /
 CHRONB48                (F3.0) /
 CHRONB49                (F3.0) /
 CHRONB50                (F3.0) /
 CHRONB51                (F3.0) /
 CHRONB52                (F3.0) /
 CHRONB53                (F3.0) /
 CHRONB54                (F3.0) /
 CHRONB55                (F3.0) /
 CHRONB56                (F3.0) /
 CHRONB57                (F3.0) /
 INJURY                  (F3.0) /
 INJURY_CUT              (F3.0) /
 INJURY_DROWN            (F3.0) /
 INJURY_FALL             (F3.0) /
 INJURY_FIRE             (F3.0) /
 INJURY_FIREARM          (F3.0) /
 INJURY_MACHINERY        (F3.0) /
 INJURY_MVT              (F3.0) /
 INJURY_NATURE           (F3.0) /
 INJURY_POISON           (F3.0) /
 INJURY_STRUCK           (F3.0) /
 INJURY_SUFFOCATION      (F3.0) /
 INTENT_ASSAULT          (F3.0) /
 INTENT_SELF_HARM        (F3.0) /
 INTENT_UNINTENTIONAL    (F3.0) /
 KEY                     (F8.0) /
 MULTINJURY              (F3.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
 PCLASS7                 (F3.0) /
 PCLASS8                 (F3.0) /
 PCLASS9                 (F3.0) /
 PCLASS10                (F3.0) /
 PCLASS11                (F3.0) /
 PCLASS12                (F3.0) /
 PCLASS13                (F3.0) /
 PCLASS14                (F3.0) /
 PCLASS15                (F3.0) /
 PCLASS16                (F3.0) /
 PCLASS17                (F3.0) /
 PCLASS18                (F3.0) /
 PCLASS19                (F3.0) /
 PCLASS20                (F3.0) /
 PCLASS21                (F3.0) /
 PCLASS22                (F3.0) /
 PCLASS23                (F3.0) /
 PCLASS24                (F3.0) /
 PCLASS25                (F3.0) /
 PCLASS26                (F3.0) /
 PCLASS27                (F3.0) /
 PCLASS28                (F3.0) /
 PCLASS29                (F3.0) /
 PCLASS30                (F3.0) /
 PCLASS31                (F3.0) /
 PCLASS32                (F3.0) /
 PCLASS33                (F3.0) /
 PCLASS34                (F3.0) /
 PCLASS35                (F3.0) /
 PCLASS36                (F3.0) /
 PCLASS37                (F3.0) /
 PCLASS38                (F3.0) /
 PCLASS39                (F3.0) /
 PCLASS40                (F3.0) /
 PCLASS41                (F3.0) /
 PCLASS42                (F3.0) /
 PCLASS43                (F3.0) /
 PCLASS44                (F3.0) /
 PCLASS45                (F3.0) /
 PCLASS46                (F3.0) /
 PCLASS47                (F3.0) /
 PCLASS48                (F3.0) /
 PCLASS49                (F3.0) /
 PCLASS50                (F3.0) /
 U_BLOOD                 (F3.0) /
 U_CATH                  (F3.0) /
 U_CCU                   (F3.0) /
 U_CHESTXRAY             (F3.0) /
 U_CTSCAN                (F3.0) /
 U_DIALYSIS              (F3.0) /
 U_ECHO                  (F3.0) /
 U_ED                    (F3.0) /
 U_EEG                   (F3.0) /
 U_EKG                   (F3.0) /
 U_EPO                   (F3.0) /
 U_ICU                   (F3.0) /
 U_LITHOTRIPSY           (F3.0) /
 U_MHSA                  (F3.0) /
 U_MRT                   (F3.0) /
 U_NEWBN2L               (F3.0) /
 U_NEWBN3L               (F3.0) /
 U_NEWBN4L               (F3.0) /
 U_NUCMED                (F3.0) /
 U_OBSERVATION           (F3.0) /
 U_OCCTHERAPY            (F3.0) /
 U_ORGANACQ              (F3.0) /
 U_OTHIMPLANTS           (F3.0) /
 U_PACEMAKER             (F3.0) /
 U_PHYTHERAPY            (F3.0) /
 U_RADTHERAPY            (F3.0) /
 U_RESPTHERAPY           (F3.0) /
 U_SPEECHTHERAPY         (F3.0) /
 U_STRESS                (F3.0) /
 U_ULTRASOUND            (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                  "Chronic condition indicator 1"
 CHRON2                  "Chronic condition indicator 2"
 CHRON3                  "Chronic condition indicator 3"
 CHRON4                  "Chronic condition indicator 4"
 CHRON5                  "Chronic condition indicator 5"
 CHRON6                  "Chronic condition indicator 6"
 CHRON7                  "Chronic condition indicator 7"
 CHRON8                  "Chronic condition indicator 8"
 CHRON9                  "Chronic condition indicator 9"
 CHRON10                 "Chronic condition indicator 10"
 CHRON11                 "Chronic condition indicator 11"
 CHRON12                 "Chronic condition indicator 12"
 CHRON13                 "Chronic condition indicator 13"
 CHRON14                 "Chronic condition indicator 14"
 CHRON15                 "Chronic condition indicator 15"
 CHRON16                 "Chronic condition indicator 16"
 CHRON17                 "Chronic condition indicator 17"
 CHRON18                 "Chronic condition indicator 18"
 CHRON19                 "Chronic condition indicator 19"
 CHRON20                 "Chronic condition indicator 20"
 CHRON21                 "Chronic condition indicator 21"
 CHRON22                 "Chronic condition indicator 22"
 CHRON23                 "Chronic condition indicator 23"
 CHRON24                 "Chronic condition indicator 24"
 CHRON25                 "Chronic condition indicator 25"
 CHRON26                 "Chronic condition indicator 26"
 CHRON27                 "Chronic condition indicator 27"
 CHRON28                 "Chronic condition indicator 28"
 CHRON29                 "Chronic condition indicator 29"
 CHRON30                 "Chronic condition indicator 30"
 CHRON31                 "Chronic condition indicator 31"
 CHRON32                 "Chronic condition indicator 32"
 CHRON33                 "Chronic condition indicator 33"
 CHRON34                 "Chronic condition indicator 34"
 CHRON35                 "Chronic condition indicator 35"
 CHRON36                 "Chronic condition indicator 36"
 CHRON37                 "Chronic condition indicator 37"
 CHRON38                 "Chronic condition indicator 38"
 CHRON39                 "Chronic condition indicator 39"
 CHRON40                 "Chronic condition indicator 40"
 CHRON41                 "Chronic condition indicator 41"
 CHRON42                 "Chronic condition indicator 42"
 CHRON43                 "Chronic condition indicator 43"
 CHRON44                 "Chronic condition indicator 44"
 CHRON45                 "Chronic condition indicator 45"
 CHRON46                 "Chronic condition indicator 46"
 CHRON47                 "Chronic condition indicator 47"
 CHRON48                 "Chronic condition indicator 48"
 CHRON49                 "Chronic condition indicator 49"
 CHRON50                 "Chronic condition indicator 50"
 CHRON51                 "Chronic condition indicator 51"
 CHRON52                 "Chronic condition indicator 52"
 CHRON53                 "Chronic condition indicator 53"
 CHRON54                 "Chronic condition indicator 54"
 CHRON55                 "Chronic condition indicator 55"
 CHRON56                 "Chronic condition indicator 56"
 CHRON57                 "Chronic condition indicator 57"
 CHRONB1                 "Chronic condition body system 1"
 CHRONB2                 "Chronic condition body system 2"
 CHRONB3                 "Chronic condition body system 3"
 CHRONB4                 "Chronic condition body system 4"
 CHRONB5                 "Chronic condition body system 5"
 CHRONB6                 "Chronic condition body system 6"
 CHRONB7                 "Chronic condition body system 7"
 CHRONB8                 "Chronic condition body system 8"
 CHRONB9                 "Chronic condition body system 9"
 CHRONB10                "Chronic condition body system 10"
 CHRONB11                "Chronic condition body system 11"
 CHRONB12                "Chronic condition body system 12"
 CHRONB13                "Chronic condition body system 13"
 CHRONB14                "Chronic condition body system 14"
 CHRONB15                "Chronic condition body system 15"
 CHRONB16                "Chronic condition body system 16"
 CHRONB17                "Chronic condition body system 17"
 CHRONB18                "Chronic condition body system 18"
 CHRONB19                "Chronic condition body system 19"
 CHRONB20                "Chronic condition body system 20"
 CHRONB21                "Chronic condition body system 21"
 CHRONB22                "Chronic condition body system 22"
 CHRONB23                "Chronic condition body system 23"
 CHRONB24                "Chronic condition body system 24"
 CHRONB25                "Chronic condition body system 25"
 CHRONB26                "Chronic condition body system 26"
 CHRONB27                "Chronic condition body system 27"
 CHRONB28                "Chronic condition body system 28"
 CHRONB29                "Chronic condition body system 29"
 CHRONB30                "Chronic condition body system 30"
 CHRONB31                "Chronic condition body system 31"
 CHRONB32                "Chronic condition body system 32"
 CHRONB33                "Chronic condition body system 33"
 CHRONB34                "Chronic condition body system 34"
 CHRONB35                "Chronic condition body system 35"
 CHRONB36                "Chronic condition body system 36"
 CHRONB37                "Chronic condition body system 37"
 CHRONB38                "Chronic condition body system 38"
 CHRONB39                "Chronic condition body system 39"
 CHRONB40                "Chronic condition body system 40"
 CHRONB41                "Chronic condition body system 41"
 CHRONB42                "Chronic condition body system 42"
 CHRONB43                "Chronic condition body system 43"
 CHRONB44                "Chronic condition body system 44"
 CHRONB45                "Chronic condition body system 45"
 CHRONB46                "Chronic condition body system 46"
 CHRONB47                "Chronic condition body system 47"
 CHRONB48                "Chronic condition body system 48"
 CHRONB49                "Chronic condition body system 49"
 CHRONB50                "Chronic condition body system 50"
 CHRONB51                "Chronic condition body system 51"
 CHRONB52                "Chronic condition body system 52"
 CHRONB53                "Chronic condition body system 53"
 CHRONB54                "Chronic condition body system 54"
 CHRONB55                "Chronic condition body system 55"
 CHRONB56                "Chronic condition body system 56"
 CHRONB57                "Chronic condition body system 57"
 DXMCCS1                 "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                 "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                 "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                 "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                 "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                 "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                 "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                 "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                 "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                "Multi-Level CCS:  Diagnosis 31"
 DXMCCS32                "Multi-Level CCS:  Diagnosis 32"
 DXMCCS33                "Multi-Level CCS:  Diagnosis 33"
 DXMCCS34                "Multi-Level CCS:  Diagnosis 34"
 DXMCCS35                "Multi-Level CCS:  Diagnosis 35"
 DXMCCS36                "Multi-Level CCS:  Diagnosis 36"
 DXMCCS37                "Multi-Level CCS:  Diagnosis 37"
 DXMCCS38                "Multi-Level CCS:  Diagnosis 38"
 DXMCCS39                "Multi-Level CCS:  Diagnosis 39"
 DXMCCS40                "Multi-Level CCS:  Diagnosis 40"
 DXMCCS41                "Multi-Level CCS:  Diagnosis 41"
 DXMCCS42                "Multi-Level CCS:  Diagnosis 42"
 DXMCCS43                "Multi-Level CCS:  Diagnosis 43"
 DXMCCS44                "Multi-Level CCS:  Diagnosis 44"
 DXMCCS45                "Multi-Level CCS:  Diagnosis 45"
 DXMCCS46                "Multi-Level CCS:  Diagnosis 46"
 DXMCCS47                "Multi-Level CCS:  Diagnosis 47"
 DXMCCS48                "Multi-Level CCS:  Diagnosis 48"
 DXMCCS49                "Multi-Level CCS:  Diagnosis 49"
 DXMCCS50                "Multi-Level CCS:  Diagnosis 50"
 DXMCCS51                "Multi-Level CCS:  Diagnosis 51"
 DXMCCS52                "Multi-Level CCS:  Diagnosis 52"
 DXMCCS53                "Multi-Level CCS:  Diagnosis 53"
 DXMCCS54                "Multi-Level CCS:  Diagnosis 54"
 DXMCCS55                "Multi-Level CCS:  Diagnosis 55"
 DXMCCS56                "Multi-Level CCS:  Diagnosis 56"
 DXMCCS57                "Multi-Level CCS:  Diagnosis 57"
 E_MCCS1                 "Multi-Level CCS:  E Code 1"
 E_MCCS2                 "Multi-Level CCS:  E Code 2"
 E_MCCS3                 "Multi-Level CCS:  E Code 3"
 E_MCCS4                 "Multi-Level CCS:  E Code 4"
 E_MCCS5                 "Multi-Level CCS:  E Code 5"
 E_MCCS6                 "Multi-Level CCS:  E Code 6"
 E_MCCS7                 "Multi-Level CCS:  E Code 7"
 E_MCCS8                 "Multi-Level CCS:  E Code 8"
 E_MCCS9                 "Multi-Level CCS:  E Code 9"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT              "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN            "Injury by drowning or submersion (by E codes)"
 INJURY_FALL             "Injury by falling (by E codes)"
 INJURY_FIRE             "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM          "Injury by firearm (by E codes)"
 INJURY_MACHINERY        "Injury by machinery (by E codes)"
 INJURY_MVT              "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE           "Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON           "Injury by poison (by E codes)"
 INJURY_STRUCK           "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION      "Injury by suffocation (by E codes)"
 INTENT_ASSAULT          "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL    "Unintentional injury indicated on the record (by E codes)"
 KEY                     "HCUP record identifier"
 MULTINJURY              "More than one injury diagnosis reported on record"
 PCLASS1                 "Procedure class 1"
 PCLASS2                 "Procedure class 2"
 PCLASS3                 "Procedure class 3"
 PCLASS4                 "Procedure class 4"
 PCLASS5                 "Procedure class 5"
 PCLASS6                 "Procedure class 6"
 PCLASS7                 "Procedure class 7"
 PCLASS8                 "Procedure class 8"
 PCLASS9                 "Procedure class 9"
 PCLASS10                "Procedure class 10"
 PCLASS11                "Procedure class 11"
 PCLASS12                "Procedure class 12"
 PCLASS13                "Procedure class 13"
 PCLASS14                "Procedure class 14"
 PCLASS15                "Procedure class 15"
 PCLASS16                "Procedure class 16"
 PCLASS17                "Procedure class 17"
 PCLASS18                "Procedure class 18"
 PCLASS19                "Procedure class 19"
 PCLASS20                "Procedure class 20"
 PCLASS21                "Procedure class 21"
 PCLASS22                "Procedure class 22"
 PCLASS23                "Procedure class 23"
 PCLASS24                "Procedure class 24"
 PCLASS25                "Procedure class 25"
 PCLASS26                "Procedure class 26"
 PCLASS27                "Procedure class 27"
 PCLASS28                "Procedure class 28"
 PCLASS29                "Procedure class 29"
 PCLASS30                "Procedure class 30"
 PCLASS31                "Procedure class 31"
 PCLASS32                "Procedure class 32"
 PCLASS33                "Procedure class 33"
 PCLASS34                "Procedure class 34"
 PCLASS35                "Procedure class 35"
 PCLASS36                "Procedure class 36"
 PCLASS37                "Procedure class 37"
 PCLASS38                "Procedure class 38"
 PCLASS39                "Procedure class 39"
 PCLASS40                "Procedure class 40"
 PCLASS41                "Procedure class 41"
 PCLASS42                "Procedure class 42"
 PCLASS43                "Procedure class 43"
 PCLASS44                "Procedure class 44"
 PCLASS45                "Procedure class 45"
 PCLASS46                "Procedure class 46"
 PCLASS47                "Procedure class 47"
 PCLASS48                "Procedure class 48"
 PCLASS49                "Procedure class 49"
 PCLASS50                "Procedure class 50"
 PRMCCS1                 "Multi-Level CCS:  Procedure 1"
 PRMCCS2                 "Multi-Level CCS:  Procedure 2"
 PRMCCS3                 "Multi-Level CCS:  Procedure 3"
 PRMCCS4                 "Multi-Level CCS:  Procedure 4"
 PRMCCS5                 "Multi-Level CCS:  Procedure 5"
 PRMCCS6                 "Multi-Level CCS:  Procedure 6"
 PRMCCS7                 "Multi-Level CCS:  Procedure 7"
 PRMCCS8                 "Multi-Level CCS:  Procedure 8"
 PRMCCS9                 "Multi-Level CCS:  Procedure 9"
 PRMCCS10                "Multi-Level CCS:  Procedure 10"
 PRMCCS11                "Multi-Level CCS:  Procedure 11"
 PRMCCS12                "Multi-Level CCS:  Procedure 12"
 PRMCCS13                "Multi-Level CCS:  Procedure 13"
 PRMCCS14                "Multi-Level CCS:  Procedure 14"
 PRMCCS15                "Multi-Level CCS:  Procedure 15"
 PRMCCS16                "Multi-Level CCS:  Procedure 16"
 PRMCCS17                "Multi-Level CCS:  Procedure 17"
 PRMCCS18                "Multi-Level CCS:  Procedure 18"
 PRMCCS19                "Multi-Level CCS:  Procedure 19"
 PRMCCS20                "Multi-Level CCS:  Procedure 20"
 PRMCCS21                "Multi-Level CCS:  Procedure 21"
 PRMCCS22                "Multi-Level CCS:  Procedure 22"
 PRMCCS23                "Multi-Level CCS:  Procedure 23"
 PRMCCS24                "Multi-Level CCS:  Procedure 24"
 PRMCCS25                "Multi-Level CCS:  Procedure 25"
 PRMCCS26                "Multi-Level CCS:  Procedure 26"
 PRMCCS27                "Multi-Level CCS:  Procedure 27"
 PRMCCS28                "Multi-Level CCS:  Procedure 28"
 PRMCCS29                "Multi-Level CCS:  Procedure 29"
 PRMCCS30                "Multi-Level CCS:  Procedure 30"
 PRMCCS31                "Multi-Level CCS:  Procedure 31"
 PRMCCS32                "Multi-Level CCS:  Procedure 32"
 PRMCCS33                "Multi-Level CCS:  Procedure 33"
 PRMCCS34                "Multi-Level CCS:  Procedure 34"
 PRMCCS35                "Multi-Level CCS:  Procedure 35"
 PRMCCS36                "Multi-Level CCS:  Procedure 36"
 PRMCCS37                "Multi-Level CCS:  Procedure 37"
 PRMCCS38                "Multi-Level CCS:  Procedure 38"
 PRMCCS39                "Multi-Level CCS:  Procedure 39"
 PRMCCS40                "Multi-Level CCS:  Procedure 40"
 PRMCCS41                "Multi-Level CCS:  Procedure 41"
 PRMCCS42                "Multi-Level CCS:  Procedure 42"
 PRMCCS43                "Multi-Level CCS:  Procedure 43"
 PRMCCS44                "Multi-Level CCS:  Procedure 44"
 PRMCCS45                "Multi-Level CCS:  Procedure 45"
 PRMCCS46                "Multi-Level CCS:  Procedure 46"
 PRMCCS47                "Multi-Level CCS:  Procedure 47"
 PRMCCS48                "Multi-Level CCS:  Procedure 48"
 PRMCCS49                "Multi-Level CCS:  Procedure 49"
 PRMCCS50                "Multi-Level CCS:  Procedure 50"
 U_BLOOD                 "Utilization Flag: Blood"
 U_CATH                  "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                   "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY             "Utilization Flag: Chest X-Ray"
 U_CTSCAN                "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS              "Utilization Flag: Renal Dialysis"
 U_ECHO                  "Utilization Flag: Echocardiology"
 U_ED                    "Utilization Flag: Emergency Room"
 U_EEG                   "Utilization Flag: Electroencephalogram"
 U_EKG                   "Utilization Flag: Electrocardiogram"
 U_EPO                   "Utilization Flag: EPO"
 U_ICU                   "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY           "Utilization Flag: Lithotripsy"
 U_MHSA                  "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                   "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2L               "Utilization Flag: Nursery Level II"
 U_NEWBN3L               "Utilization Flag: Nursery Level III"
 U_NEWBN4L               "Utilization Flag: Nursery Level IV"
 U_NUCMED                "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION           "Utilization Flag: Observation Room"
 U_OCCTHERAPY            "Utilization Flag: Occupational Therapy"
 U_ORGANACQ              "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS           "Utilization Flag: Other Implants"
 U_PACEMAKER             "Utilization Flag: Pacemaker"
 U_PHYTHERAPY            "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY           "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY         "Utilization Flag: Speech - Language Pathology"
 U_STRESS                "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND            "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON35
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON36
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON37
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON38
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON39
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON40
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON41
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON42
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON43
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON44
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON45
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON46
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON47
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON48
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON49
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON50
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON51
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON52
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON53
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON54
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON55
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON56
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON57
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB35
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB36
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB37
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB38
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB39
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB40
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB41
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB42
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB43
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB44
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB45
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB46
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB47
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB48
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB49
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB50
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB51
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB52
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB53
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB54
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB55
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB56
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB57
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS26
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS27
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS28
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS29
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS30
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS31
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS32
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS33
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS34
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS35
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS36
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS37
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS38
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS39
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS40
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS41
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS42
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS43
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS44
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS45
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS46
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS47
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS48
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS49
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS50
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'IA_SID_2012_DX_PR_GRPS.SAV' /COMPRESSED.
