/*******************************************************************
* Creation Date: 06/25/2021   
*   IA_SID_2020_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'IA_SID_2020_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BWT                            16-  19
 DaysToEvent                    20-  25
 DIED                           26-  27
 DISP_X                         28-  29 (A)
 DISPUB04                       30-  31
 DISPUNIFORM                    32-  33
 DMONTH                         34-  35
 DQTR                           36-  37
 DRG                            38-  40
 DRG_NoPOA                      41-  43
 DRGVER                         44-  45
 DXPOA1                         46     (A)
 DXPOA2                         47     (A)
 DXPOA3                         48     (A)
 DXPOA4                         49     (A)
 DXPOA5                         50     (A)
 DXPOA6                         51     (A)
 DXPOA7                         52     (A)
 DXPOA8                         53     (A)
 DXPOA9                         54     (A)
 DXPOA10                        55     (A)
 DXPOA11                        56     (A)
 DXPOA12                        57     (A)
 DXPOA13                        58     (A)
 DXPOA14                        59     (A)
 DXPOA15                        60     (A)
 DXPOA16                        61     (A)
 DXPOA17                        62     (A)
 DXPOA18                        63     (A)
 DXPOA19                        64     (A)
 DXPOA20                        65     (A)
 DXPOA21                        66     (A)
 DXPOA22                        67     (A)
 DXPOA23                        68     (A)
 DXPOA24                        69     (A)
 DXPOA25                        70     (A)
 DXPOA26                        71     (A)
 DXPOA27                        72     (A)
 DXPOA28                        73     (A)
 DXPOA29                        74     (A)
 DXPOA30                        75     (A)
 DXPOA31                        76     (A)
 DXPOA32                        77     (A)
 DXPOA33                        78     (A)
 DXPOA34                        79     (A)
 DXPOA35                        80     (A)
 DXPOA36                        81     (A)
 DXPOA37                        82     (A)
 DXPOA38                        83     (A)
 DXPOA39                        84     (A)
 DXPOA40                        85     (A)
 DXPOA41                        86     (A)
 DXPOA42                        87     (A)
 DXPOA43                        88     (A)
 DXPOA44                        89     (A)
 DXPOA45                        90     (A)
 DXPOA46                        91     (A)
 DXPOA47                        92     (A)
 DXPOA48                        93     (A)
 DXPOA49                        94     (A)
 DXPOA50                        95     (A)
 DXPOA51                        96     (A)
 DXPOA52                        97     (A)
 DXPOA53                        98     (A)
 DXPOA54                        99     (A)
 DXPOA55                       100     (A)
 DXPOA56                       101     (A)
 DXPOA57                       102     (A)
 DXPOA58                       103     (A)
 DXPOA59                       104     (A)
 DXPOA60                       105     (A)
 DXPOA61                       106     (A)
 DXPOA62                       107     (A)
 DXPOA63                       108     (A)
 DXPOA64                       109     (A)
 DXPOA65                       110     (A)
 DXPOA66                       111     (A)
 DXPOA67                       112     (A)
 DXPOA68                       113     (A)
 DXPOA69                       114     (A)
 DXPOA70                       115     (A)
 DXPOA71                       116     (A)
 DXPOA72                       117     (A)
 DXPOA73                       118     (A)
 DXPOA74                       119     (A)
 DXPOA75                       120     (A)
 DXPOA76                       121     (A)
 DXPOA77                       122     (A)
 DXPOA78                       123     (A)
 DXPOA79                       124     (A)
 DXPOA80                       125     (A)
 DXPOA81                       126     (A)
 DXPOA82                       127     (A)
 DXPOA83                       128     (A)
 DXPOA84                       129     (A)
 DXPOA85                       130     (A)
 DXPOA86                       131     (A)
 DXPOA87                       132     (A)
 DXPOA88                       133     (A)
 DXPOA89                       134     (A)
 DXPOA90                       135     (A)
 DXPOA91                       136     (A)
 DXPOA92                       137     (A)
 DXPOA93                       138     (A)
 DXPOA94                       139     (A)
 DXPOA95                       140     (A)
 DXPOA96                       141     (A)
 DXPOA97                       142     (A)
 DXPOA98                       143     (A)
 DXPOA99                       144     (A)
 DXPOA100                      145     (A)
 DXPOA101                      146     (A)
 DXPOA102                      147     (A)
 DXPOA103                      148     (A)
 FEMALE                        149- 150
 HCUP_ED                       151- 152
 HCUP_OS                       153- 154
 HISPANIC                      155- 156
 HISPANIC_X                    157     (A)
 HospitalUnit                  158- 159
 HOSPST                        160- 161 (A)
 I10_BIRTH                     162- 164
 I10_DELIVERY                  165- 167
 I10_DX_Admitting              168- 174 (A)
 I10_DX1                       175- 181 (A)
 I10_DX2                       182- 188 (A)
 I10_DX3                       189- 195 (A)
 I10_DX4                       196- 202 (A)
 I10_DX5                       203- 209 (A)
 I10_DX6                       210- 216 (A)
 I10_DX7                       217- 223 (A)
 I10_DX8                       224- 230 (A)
 I10_DX9                       231- 237 (A)
 I10_DX10                      238- 244 (A)
 I10_DX11                      245- 251 (A)
 I10_DX12                      252- 258 (A)
 I10_DX13                      259- 265 (A)
 I10_DX14                      266- 272 (A)
 I10_DX15                      273- 279 (A)
 I10_DX16                      280- 286 (A)
 I10_DX17                      287- 293 (A)
 I10_DX18                      294- 300 (A)
 I10_DX19                      301- 307 (A)
 I10_DX20                      308- 314 (A)
 I10_DX21                      315- 321 (A)
 I10_DX22                      322- 328 (A)
 I10_DX23                      329- 335 (A)
 I10_DX24                      336- 342 (A)
 I10_DX25                      343- 349 (A)
 I10_DX26                      350- 356 (A)
 I10_DX27                      357- 363 (A)
 I10_DX28                      364- 370 (A)
 I10_DX29                      371- 377 (A)
 I10_DX30                      378- 384 (A)
 I10_DX31                      385- 391 (A)
 I10_DX32                      392- 398 (A)
 I10_DX33                      399- 405 (A)
 I10_DX34                      406- 412 (A)
 I10_DX35                      413- 419 (A)
 I10_DX36                      420- 426 (A)
 I10_DX37                      427- 433 (A)
 I10_DX38                      434- 440 (A)
 I10_DX39                      441- 447 (A)
 I10_DX40                      448- 454 (A)
 I10_DX41                      455- 461 (A)
 I10_DX42                      462- 468 (A)
 I10_DX43                      469- 475 (A)
 I10_DX44                      476- 482 (A)
 I10_DX45                      483- 489 (A)
 I10_DX46                      490- 496 (A)
 I10_DX47                      497- 503 (A)
 I10_DX48                      504- 510 (A)
 I10_DX49                      511- 517 (A)
 I10_DX50                      518- 524 (A)
 I10_DX51                      525- 531 (A)
 I10_DX52                      532- 538 (A)
 I10_DX53                      539- 545 (A)
 I10_DX54                      546- 552 (A)
 I10_DX55                      553- 559 (A)
 I10_DX56                      560- 566 (A)
 I10_DX57                      567- 573 (A)
 I10_DX58                      574- 580 (A)
 I10_DX59                      581- 587 (A)
 I10_DX60                      588- 594 (A)
 I10_DX61                      595- 601 (A)
 I10_DX62                      602- 608 (A)
 I10_DX63                      609- 615 (A)
 I10_DX64                      616- 622 (A)
 I10_DX65                      623- 629 (A)
 I10_DX66                      630- 636 (A)
 I10_DX67                      637- 643 (A)
 I10_DX68                      644- 650 (A)
 I10_DX69                      651- 657 (A)
 I10_DX70                      658- 664 (A)
 I10_DX71                      665- 671 (A)
 I10_DX72                      672- 678 (A)
 I10_DX73                      679- 685 (A)
 I10_DX74                      686- 692 (A)
 I10_DX75                      693- 699 (A)
 I10_DX76                      700- 706 (A)
 I10_DX77                      707- 713 (A)
 I10_DX78                      714- 720 (A)
 I10_DX79                      721- 727 (A)
 I10_DX80                      728- 734 (A)
 I10_DX81                      735- 741 (A)
 I10_DX82                      742- 748 (A)
 I10_DX83                      749- 755 (A)
 I10_DX84                      756- 762 (A)
 I10_DX85                      763- 769 (A)
 I10_DX86                      770- 776 (A)
 I10_DX87                      777- 783 (A)
 I10_DX88                      784- 790 (A)
 I10_DX89                      791- 797 (A)
 I10_DX90                      798- 804 (A)
 I10_DX91                      805- 811 (A)
 I10_DX92                      812- 818 (A)
 I10_DX93                      819- 825 (A)
 I10_DX94                      826- 832 (A)
 I10_DX95                      833- 839 (A)
 I10_DX96                      840- 846 (A)
 I10_DX97                      847- 853 (A)
 I10_DX98                      854- 860 (A)
 I10_DX99                      861- 867 (A)
 I10_DX100                     868- 874 (A)
 I10_DX101                     875- 881 (A)
 I10_DX102                     882- 888 (A)
 I10_DX103                     889- 895 (A)
 I10_NDX                       896- 898
 I10_NPR                       899- 901
 I10_PR1                       902- 908 (A)
 I10_PR2                       909- 915 (A)
 I10_PR3                       916- 922 (A)
 I10_PR4                       923- 929 (A)
 I10_PR5                       930- 936 (A)
 I10_PR6                       937- 943 (A)
 I10_PR7                       944- 950 (A)
 I10_PR8                       951- 957 (A)
 I10_PR9                       958- 964 (A)
 I10_PR10                      965- 971 (A)
 I10_PR11                      972- 978 (A)
 I10_PR12                      979- 985 (A)
 I10_PR13                      986- 992 (A)
 I10_PR14                      993- 999 (A)
 I10_PR15                     1000-1006 (A)
 I10_PR16                     1007-1013 (A)
 I10_PR17                     1014-1020 (A)
 I10_PR18                     1021-1027 (A)
 I10_PR19                     1028-1034 (A)
 I10_PR20                     1035-1041 (A)
 I10_PR21                     1042-1048 (A)
 I10_PR22                     1049-1055 (A)
 I10_PR23                     1056-1062 (A)
 I10_PR24                     1063-1069 (A)
 I10_PR25                     1070-1076 (A)
 I10_PR26                     1077-1083 (A)
 I10_PR27                     1084-1090 (A)
 I10_PR28                     1091-1097 (A)
 I10_PR29                     1098-1104 (A)
 I10_PR30                     1105-1111 (A)
 I10_PR31                     1112-1118 (A)
 I10_PR32                     1119-1125 (A)
 I10_PR33                     1126-1132 (A)
 I10_PR34                     1133-1139 (A)
 I10_PR35                     1140-1146 (A)
 I10_PR36                     1147-1153 (A)
 I10_PR37                     1154-1160 (A)
 I10_PR38                     1161-1167 (A)
 I10_PR39                     1168-1174 (A)
 I10_PR40                     1175-1181 (A)
 I10_PR41                     1182-1188 (A)
 I10_PR42                     1189-1195 (A)
 I10_PROCTYPE                 1196-1198
 I10_SERVICELINE              1199-1200
 KEY                          1201-1215
 LOS                          1216-1220
 LOS_X                        1221-1226
 MDC                          1227-1228
 MDC_NoPOA                    1229-1230
 MDNUM1_R                     1231-1239
 MDNUM2_R                     1240-1248
 MDNUM3_R                     1249-1257
 MEDINCSTQ                    1258-1259
 MRN_R                        1260-1268
 P7EDSRC_X                    1269-1270 (A)
 PAY1                         1271-1272
 PAY1_X                       1273-1276 (A)
 PAY2                         1277-1278
 PAY2_X                       1279-1282 (A)
 PAY3                         1283-1284
 PAY3_X                       1285-1288 (A)
 PCLASS_ORPROC                1289-1290
 PL_CBSA                      1291-1293
 PL_NCHS                      1294-1295
 PL_RUCC                      1296-1297
 PL_UIC                       1298-1299
 PL_UR_CAT4                   1300-1301
 POA_Disch_Edit1              1302-1303
 POA_Disch_Edit2              1304-1305
 POA_Hosp_Edit1               1306-1307
 POA_Hosp_Edit2               1308-1309
 POA_Hosp_Edit3               1310-1311
 POA_Hosp_Edit3_Value         1312-1319
 PointOfOrigin_X              1320     (A)
 PointOfOriginUB04            1321     (A)
 PRDAY1                       1322-1326
 PRDAY2                       1327-1331
 PRDAY3                       1332-1336
 PRDAY4                       1337-1341
 PRDAY5                       1342-1346
 PRDAY6                       1347-1351
 PRDAY7                       1352-1356
 PRDAY8                       1357-1361
 PRDAY9                       1362-1366
 PRDAY10                      1367-1371
 PRDAY11                      1372-1376
 PRDAY12                      1377-1381
 PRDAY13                      1382-1386
 PRDAY14                      1387-1391
 PRDAY15                      1392-1396
 PRDAY16                      1397-1401
 PRDAY17                      1402-1406
 PRDAY18                      1407-1411
 PRDAY19                      1412-1416
 PRDAY20                      1417-1421
 PRDAY21                      1422-1426
 PRDAY22                      1427-1431
 PRDAY23                      1432-1436
 PRDAY24                      1437-1441
 PRDAY25                      1442-1446
 PRDAY26                      1447-1451
 PRDAY27                      1452-1456
 PRDAY28                      1457-1461
 PRDAY29                      1462-1466
 PRDAY30                      1467-1471
 PRDAY31                      1472-1476
 PRDAY32                      1477-1481
 PRDAY33                      1482-1486
 PRDAY34                      1487-1491
 PRDAY35                      1492-1496
 PRDAY36                      1497-1501
 PRDAY37                      1502-1506
 PRDAY38                      1507-1511
 PRDAY39                      1512-1516
 PRDAY40                      1517-1521
 PRDAY41                      1522-1526
 PRDAY42                      1527-1531
 PrimLang                     1532-1534 (A)
 PSTATE                       1535-1536 (A)
 PSTATE_GEO                   1537-1538 (A)
 PSTCO                        1539-1543
 PSTCO_GEO                    1544-1548
 RACE                         1549-1550
 RACE_PCT_MISS_HOSP           1551-1557
 RACE_X                       1558-1561 (A)
 TOTCHG                       1562-1571
 TOTCHG_X                     1572-1586
 TRAN_IN                      1587-1588
 TRAN_OUT                     1589-1590
 VisitLink                    1591-1599
 YEAR                         1600-1603
 ZIP                          1604-1608 (A)
 ZIP3                         1609-1611 (A)
 ZIPINC_QRTL                  1612-1614
 AYEAR                        1615-1618
 BMONTH                       1619-1620
 BYEAR                        1621-1624
 PRMONTH1                     1625-1626
 PRMONTH2                     1627-1628
 PRMONTH3                     1629-1630
 PRMONTH4                     1631-1632
 PRMONTH5                     1633-1634
 PRMONTH6                     1635-1636
 PRMONTH7                     1637-1638
 PRMONTH8                     1639-1640
 PRMONTH9                     1641-1642
 PRMONTH10                    1643-1644
 PRMONTH11                    1645-1646
 PRMONTH12                    1647-1648
 PRMONTH13                    1649-1650
 PRMONTH14                    1651-1652
 PRMONTH15                    1653-1654
 PRMONTH16                    1655-1656
 PRMONTH17                    1657-1658
 PRMONTH18                    1659-1660
 PRMONTH19                    1661-1662
 PRMONTH20                    1663-1664
 PRMONTH21                    1665-1666
 PRMONTH22                    1667-1668
 PRMONTH23                    1669-1670
 PRMONTH24                    1671-1672
 PRMONTH25                    1673-1674
 PRMONTH26                    1675-1676
 PRMONTH27                    1677-1678
 PRMONTH28                    1679-1680
 PRMONTH29                    1681-1682
 PRMONTH30                    1683-1684
 PRMONTH31                    1685-1686
 PRMONTH32                    1687-1688
 PRMONTH33                    1689-1690
 PRMONTH34                    1691-1692
 PRMONTH35                    1693-1694
 PRMONTH36                    1695-1696
 PRMONTH37                    1697-1698
 PRMONTH38                    1699-1700
 PRMONTH39                    1701-1702
 PRMONTH40                    1703-1704
 PRMONTH41                    1705-1706
 PRMONTH42                    1707-1708
 PRYEAR1                      1709-1712
 PRYEAR2                      1713-1716
 PRYEAR3                      1717-1720
 PRYEAR4                      1721-1724
 PRYEAR5                      1725-1728
 PRYEAR6                      1729-1732
 PRYEAR7                      1733-1736
 PRYEAR8                      1737-1740
 PRYEAR9                      1741-1744
 PRYEAR10                     1745-1748
 PRYEAR11                     1749-1752
 PRYEAR12                     1753-1756
 PRYEAR13                     1757-1760
 PRYEAR14                     1761-1764
 PRYEAR15                     1765-1768
 PRYEAR16                     1769-1772
 PRYEAR17                     1773-1776
 PRYEAR18                     1777-1780
 PRYEAR19                     1781-1784
 PRYEAR20                     1785-1788
 PRYEAR21                     1789-1792
 PRYEAR22                     1793-1796
 PRYEAR23                     1797-1800
 PRYEAR24                     1801-1804
 PRYEAR25                     1805-1808
 PRYEAR26                     1809-1812
 PRYEAR27                     1813-1816
 PRYEAR28                     1817-1820
 PRYEAR29                     1821-1824
 PRYEAR30                     1825-1828
 PRYEAR31                     1829-1832
 PRYEAR32                     1833-1836
 PRYEAR33                     1837-1840
 PRYEAR34                     1841-1844
 PRYEAR35                     1845-1848
 PRYEAR36                     1849-1852
 PRYEAR37                     1853-1856
 PRYEAR38                     1857-1860
 PRYEAR39                     1861-1864
 PRYEAR40                     1865-1868
 PRYEAR41                     1869-1872
 PRYEAR42                     1873-1876.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 HospitalUnit                 (F3.0) /
 I10_BIRTH                    (F3.0) /
 I10_DELIVERY                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PCLASS_ORPROC                (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PSTCO                        (F4.0) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 RACE_PCT_MISS_HOSP           (F4.2) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRMONTH31                    (F3.0) /
 PRMONTH32                    (F3.0) /
 PRMONTH33                    (F3.0) /
 PRMONTH34                    (F3.0) /
 PRMONTH35                    (F3.0) /
 PRMONTH36                    (F3.0) /
 PRMONTH37                    (F3.0) /
 PRMONTH38                    (F3.0) /
 PRMONTH39                    (F3.0) /
 PRMONTH40                    (F3.0) /
 PRMONTH41                    (F3.0) /
 PRMONTH42                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) /
 PRYEAR31                     (F3.0) /
 PRYEAR32                     (F3.0) /
 PRYEAR33                     (F3.0) /
 PRYEAR34                     (F3.0) /
 PRYEAR35                     (F3.0) /
 PRYEAR36                     (F3.0) /
 PRYEAR37                     (F3.0) /
 PRYEAR38                     (F3.0) /
 PRYEAR39                     (F3.0) /
 PRYEAR40                     (F3.0) /
 PRYEAR41                     (F3.0) /
 PRYEAR42                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXPOA61                      "Diagnosis 61, present on admission indicator"
 DXPOA62                      "Diagnosis 62, present on admission indicator"
 DXPOA63                      "Diagnosis 63, present on admission indicator"
 DXPOA64                      "Diagnosis 64, present on admission indicator"
 DXPOA65                      "Diagnosis 65, present on admission indicator"
 DXPOA66                      "Diagnosis 66, present on admission indicator"
 DXPOA67                      "Diagnosis 67, present on admission indicator"
 DXPOA68                      "Diagnosis 68, present on admission indicator"
 DXPOA69                      "Diagnosis 69, present on admission indicator"
 DXPOA70                      "Diagnosis 70, present on admission indicator"
 DXPOA71                      "Diagnosis 71, present on admission indicator"
 DXPOA72                      "Diagnosis 72, present on admission indicator"
 DXPOA73                      "Diagnosis 73, present on admission indicator"
 DXPOA74                      "Diagnosis 74, present on admission indicator"
 DXPOA75                      "Diagnosis 75, present on admission indicator"
 DXPOA76                      "Diagnosis 76, present on admission indicator"
 DXPOA77                      "Diagnosis 77, present on admission indicator"
 DXPOA78                      "Diagnosis 78, present on admission indicator"
 DXPOA79                      "Diagnosis 79, present on admission indicator"
 DXPOA80                      "Diagnosis 80, present on admission indicator"
 DXPOA81                      "Diagnosis 81, present on admission indicator"
 DXPOA82                      "Diagnosis 82, present on admission indicator"
 DXPOA83                      "Diagnosis 83, present on admission indicator"
 DXPOA84                      "Diagnosis 84, present on admission indicator"
 DXPOA85                      "Diagnosis 85, present on admission indicator"
 DXPOA86                      "Diagnosis 86, present on admission indicator"
 DXPOA87                      "Diagnosis 87, present on admission indicator"
 DXPOA88                      "Diagnosis 88, present on admission indicator"
 DXPOA89                      "Diagnosis 89, present on admission indicator"
 DXPOA90                      "Diagnosis 90, present on admission indicator"
 DXPOA91                      "Diagnosis 91, present on admission indicator"
 DXPOA92                      "Diagnosis 92, present on admission indicator"
 DXPOA93                      "Diagnosis 93, present on admission indicator"
 DXPOA94                      "Diagnosis 94, present on admission indicator"
 DXPOA95                      "Diagnosis 95, present on admission indicator"
 DXPOA96                      "Diagnosis 96, present on admission indicator"
 DXPOA97                      "Diagnosis 97, present on admission indicator"
 DXPOA98                      "Diagnosis 98, present on admission indicator"
 DXPOA99                      "Diagnosis 99, present on admission indicator"
 DXPOA100                     "Diagnosis 100, present on admission indicator"
 DXPOA101                     "Diagnosis 101, present on admission indicator"
 DXPOA102                     "Diagnosis 102, present on admission indicator"
 DXPOA103                     "Diagnosis 103, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HospitalUnit
"Patient was discharged from a special unit within an acute care hospital (reported by source)"
 HOSPST                       "Hospital state postal code"
 I10_BIRTH                    "ICD-10-CM Birth Indicator"
 I10_DELIVERY                 "ICD-10-CM Delivery Indicator"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_DX61                     "ICD-10-CM Diagnosis 61"
 I10_DX62                     "ICD-10-CM Diagnosis 62"
 I10_DX63                     "ICD-10-CM Diagnosis 63"
 I10_DX64                     "ICD-10-CM Diagnosis 64"
 I10_DX65                     "ICD-10-CM Diagnosis 65"
 I10_DX66                     "ICD-10-CM Diagnosis 66"
 I10_DX67                     "ICD-10-CM Diagnosis 67"
 I10_DX68                     "ICD-10-CM Diagnosis 68"
 I10_DX69                     "ICD-10-CM Diagnosis 69"
 I10_DX70                     "ICD-10-CM Diagnosis 70"
 I10_DX71                     "ICD-10-CM Diagnosis 71"
 I10_DX72                     "ICD-10-CM Diagnosis 72"
 I10_DX73                     "ICD-10-CM Diagnosis 73"
 I10_DX74                     "ICD-10-CM Diagnosis 74"
 I10_DX75                     "ICD-10-CM Diagnosis 75"
 I10_DX76                     "ICD-10-CM Diagnosis 76"
 I10_DX77                     "ICD-10-CM Diagnosis 77"
 I10_DX78                     "ICD-10-CM Diagnosis 78"
 I10_DX79                     "ICD-10-CM Diagnosis 79"
 I10_DX80                     "ICD-10-CM Diagnosis 80"
 I10_DX81                     "ICD-10-CM Diagnosis 81"
 I10_DX82                     "ICD-10-CM Diagnosis 82"
 I10_DX83                     "ICD-10-CM Diagnosis 83"
 I10_DX84                     "ICD-10-CM Diagnosis 84"
 I10_DX85                     "ICD-10-CM Diagnosis 85"
 I10_DX86                     "ICD-10-CM Diagnosis 86"
 I10_DX87                     "ICD-10-CM Diagnosis 87"
 I10_DX88                     "ICD-10-CM Diagnosis 88"
 I10_DX89                     "ICD-10-CM Diagnosis 89"
 I10_DX90                     "ICD-10-CM Diagnosis 90"
 I10_DX91                     "ICD-10-CM Diagnosis 91"
 I10_DX92                     "ICD-10-CM Diagnosis 92"
 I10_DX93                     "ICD-10-CM Diagnosis 93"
 I10_DX94                     "ICD-10-CM Diagnosis 94"
 I10_DX95                     "ICD-10-CM Diagnosis 95"
 I10_DX96                     "ICD-10-CM Diagnosis 96"
 I10_DX97                     "ICD-10-CM Diagnosis 97"
 I10_DX98                     "ICD-10-CM Diagnosis 98"
 I10_DX99                     "ICD-10-CM Diagnosis 99"
 I10_DX100                    "ICD-10-CM Diagnosis 100"
 I10_DX101                    "ICD-10-CM Diagnosis 101"
 I10_DX102                    "ICD-10-CM Diagnosis 102"
 I10_DX103                    "ICD-10-CM Diagnosis 103"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PCLASS_ORPROC                "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PrimLang                     "Primary language of patient"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 RACE                         "Race (uniform)"
 RACE_PCT_MISS_HOSP           "Hospital percentage of missing or invalid race values"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRMONTH31                    "Month of procedure 31"
 PRMONTH32                    "Month of procedure 32"
 PRMONTH33                    "Month of procedure 33"
 PRMONTH34                    "Month of procedure 34"
 PRMONTH35                    "Month of procedure 35"
 PRMONTH36                    "Month of procedure 36"
 PRMONTH37                    "Month of procedure 37"
 PRMONTH38                    "Month of procedure 38"
 PRMONTH39                    "Month of procedure 39"
 PRMONTH40                    "Month of procedure 40"
 PRMONTH41                    "Month of procedure 41"
 PRMONTH42                    "Month of procedure 42"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30"
 PRYEAR31                     "Year of procedure 31"
 PRYEAR32                     "Year of procedure 32"
 PRYEAR33                     "Year of procedure 33"
 PRYEAR34                     "Year of procedure 34"
 PRYEAR35                     "Year of procedure 35"
 PRYEAR36                     "Year of procedure 36"
 PRYEAR37                     "Year of procedure 37"
 PRYEAR38                     "Year of procedure 38"
 PRYEAR39                     "Year of procedure 39"
 PRYEAR40                     "Year of procedure 40"
 PRYEAR41                     "Year of procedure 41"
 PRYEAR42                     "Year of procedure 42" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BIRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_DELIVERY
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_PCT_MISS_HOSP
 (-999.99,-888.88,-666.66,-555.55=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'IA_SID_2020_CORE.SAV' /COMPRESSED.
