/*******************************************************************
* Creation Date: 08/14/2025   
*   IA_SID_2024_CORE.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      SID CORE FILE INTO SPSS                                    
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'IA_SID_2024_CORE.asc' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BWT                            16-  19
 DaysToEvent                    20-  25
 DIED                           26-  27
 DISP_X                         28-  29 (A)
 DISPUB04                       30-  31
 DISPUNIFORM                    32-  33
 DMONTH                         34-  35
 DQTR                           36-  37
 DRG                            38-  40
 DRG_NoPOA                      41-  43
 DRGVER                         44-  45
 DXPOA1                         46     (A)
 DXPOA2                         47     (A)
 DXPOA3                         48     (A)
 DXPOA4                         49     (A)
 DXPOA5                         50     (A)
 DXPOA6                         51     (A)
 DXPOA7                         52     (A)
 DXPOA8                         53     (A)
 DXPOA9                         54     (A)
 DXPOA10                        55     (A)
 DXPOA11                        56     (A)
 DXPOA12                        57     (A)
 DXPOA13                        58     (A)
 DXPOA14                        59     (A)
 DXPOA15                        60     (A)
 DXPOA16                        61     (A)
 DXPOA17                        62     (A)
 DXPOA18                        63     (A)
 DXPOA19                        64     (A)
 DXPOA20                        65     (A)
 DXPOA21                        66     (A)
 DXPOA22                        67     (A)
 DXPOA23                        68     (A)
 DXPOA24                        69     (A)
 DXPOA25                        70     (A)
 DXPOA26                        71     (A)
 DXPOA27                        72     (A)
 DXPOA28                        73     (A)
 DXPOA29                        74     (A)
 DXPOA30                        75     (A)
 DXPOA31                        76     (A)
 DXPOA32                        77     (A)
 DXPOA33                        78     (A)
 DXPOA34                        79     (A)
 DXPOA35                        80     (A)
 DXPOA36                        81     (A)
 DXPOA37                        82     (A)
 DXPOA38                        83     (A)
 DXPOA39                        84     (A)
 DXPOA40                        85     (A)
 DXPOA41                        86     (A)
 DXPOA42                        87     (A)
 DXPOA43                        88     (A)
 DXPOA44                        89     (A)
 DXPOA45                        90     (A)
 DXPOA46                        91     (A)
 DXPOA47                        92     (A)
 DXPOA48                        93     (A)
 DXPOA49                        94     (A)
 DXPOA50                        95     (A)
 DXPOA51                        96     (A)
 DXPOA52                        97     (A)
 DXPOA53                        98     (A)
 DXPOA54                        99     (A)
 DXPOA55                       100     (A)
 DXPOA56                       101     (A)
 DXPOA57                       102     (A)
 DXPOA58                       103     (A)
 DXPOA59                       104     (A)
 DXPOA60                       105     (A)
 DXPOA61                       106     (A)
 DXPOA62                       107     (A)
 DXPOA63                       108     (A)
 DXPOA64                       109     (A)
 DXPOA65                       110     (A)
 DXPOA66                       111     (A)
 DXPOA67                       112     (A)
 DXPOA68                       113     (A)
 DXPOA69                       114     (A)
 DXPOA70                       115     (A)
 FEMALE                        116- 117
 HCUP_ED                       118- 119
 HCUP_OS                       120- 121
 HISPANIC                      122- 123
 HISPANIC_X                    124     (A)
 HospitalUnit                  125- 126
 HOSPST                        127- 128 (A)
 I10_BIRTH                     129- 131
 I10_DELIVERY                  132- 134
 I10_DX_Admitting              135- 141 (A)
 I10_DX1                       142- 148 (A)
 I10_DX2                       149- 155 (A)
 I10_DX3                       156- 162 (A)
 I10_DX4                       163- 169 (A)
 I10_DX5                       170- 176 (A)
 I10_DX6                       177- 183 (A)
 I10_DX7                       184- 190 (A)
 I10_DX8                       191- 197 (A)
 I10_DX9                       198- 204 (A)
 I10_DX10                      205- 211 (A)
 I10_DX11                      212- 218 (A)
 I10_DX12                      219- 225 (A)
 I10_DX13                      226- 232 (A)
 I10_DX14                      233- 239 (A)
 I10_DX15                      240- 246 (A)
 I10_DX16                      247- 253 (A)
 I10_DX17                      254- 260 (A)
 I10_DX18                      261- 267 (A)
 I10_DX19                      268- 274 (A)
 I10_DX20                      275- 281 (A)
 I10_DX21                      282- 288 (A)
 I10_DX22                      289- 295 (A)
 I10_DX23                      296- 302 (A)
 I10_DX24                      303- 309 (A)
 I10_DX25                      310- 316 (A)
 I10_DX26                      317- 323 (A)
 I10_DX27                      324- 330 (A)
 I10_DX28                      331- 337 (A)
 I10_DX29                      338- 344 (A)
 I10_DX30                      345- 351 (A)
 I10_DX31                      352- 358 (A)
 I10_DX32                      359- 365 (A)
 I10_DX33                      366- 372 (A)
 I10_DX34                      373- 379 (A)
 I10_DX35                      380- 386 (A)
 I10_DX36                      387- 393 (A)
 I10_DX37                      394- 400 (A)
 I10_DX38                      401- 407 (A)
 I10_DX39                      408- 414 (A)
 I10_DX40                      415- 421 (A)
 I10_DX41                      422- 428 (A)
 I10_DX42                      429- 435 (A)
 I10_DX43                      436- 442 (A)
 I10_DX44                      443- 449 (A)
 I10_DX45                      450- 456 (A)
 I10_DX46                      457- 463 (A)
 I10_DX47                      464- 470 (A)
 I10_DX48                      471- 477 (A)
 I10_DX49                      478- 484 (A)
 I10_DX50                      485- 491 (A)
 I10_DX51                      492- 498 (A)
 I10_DX52                      499- 505 (A)
 I10_DX53                      506- 512 (A)
 I10_DX54                      513- 519 (A)
 I10_DX55                      520- 526 (A)
 I10_DX56                      527- 533 (A)
 I10_DX57                      534- 540 (A)
 I10_DX58                      541- 547 (A)
 I10_DX59                      548- 554 (A)
 I10_DX60                      555- 561 (A)
 I10_DX61                      562- 568 (A)
 I10_DX62                      569- 575 (A)
 I10_DX63                      576- 582 (A)
 I10_DX64                      583- 589 (A)
 I10_DX65                      590- 596 (A)
 I10_DX66                      597- 603 (A)
 I10_DX67                      604- 610 (A)
 I10_DX68                      611- 617 (A)
 I10_DX69                      618- 624 (A)
 I10_DX70                      625- 631 (A)
 I10_NDX                       632- 634
 I10_NPR                       635- 637
 I10_PR1                       638- 644 (A)
 I10_PR2                       645- 651 (A)
 I10_PR3                       652- 658 (A)
 I10_PR4                       659- 665 (A)
 I10_PR5                       666- 672 (A)
 I10_PR6                       673- 679 (A)
 I10_PR7                       680- 686 (A)
 I10_PR8                       687- 693 (A)
 I10_PR9                       694- 700 (A)
 I10_PR10                      701- 707 (A)
 I10_PR11                      708- 714 (A)
 I10_PR12                      715- 721 (A)
 I10_PR13                      722- 728 (A)
 I10_PR14                      729- 735 (A)
 I10_PR15                      736- 742 (A)
 I10_PR16                      743- 749 (A)
 I10_PR17                      750- 756 (A)
 I10_PR18                      757- 763 (A)
 I10_PR19                      764- 770 (A)
 I10_PR20                      771- 777 (A)
 I10_PR21                      778- 784 (A)
 I10_PR22                      785- 791 (A)
 I10_PR23                      792- 798 (A)
 I10_PR24                      799- 805 (A)
 I10_PR25                      806- 812 (A)
 I10_PR26                      813- 819 (A)
 I10_PR27                      820- 826 (A)
 I10_PR28                      827- 833 (A)
 I10_PR29                      834- 840 (A)
 I10_PR30                      841- 847 (A)
 I10_PR31                      848- 854 (A)
 I10_PR32                      855- 861 (A)
 I10_PR33                      862- 868 (A)
 I10_PR34                      869- 875 (A)
 I10_PR35                      876- 882 (A)
 I10_PR36                      883- 889 (A)
 I10_PR37                      890- 896 (A)
 I10_PR38                      897- 903 (A)
 I10_PR39                      904- 910 (A)
 I10_PR40                      911- 917 (A)
 I10_PROCTYPE                  918- 920
 I10_SERVICELINE               921- 922
 KEY                           923- 937
 LOS                           938- 942
 LOS_X                         943- 948
 MDC                           949- 950
 MDC_NoPOA                     951- 952
 MDNUM1_R                      953- 961
 MDNUM2_R                      962- 970
 MDNUM3_R                      971- 979
 MEDINCSTQ                     980- 981
 MRN_R                         982- 990
 P7EDSRC_X                     991- 992 (A)
 PAY1                          993- 994
 PAY1_X                        995- 998 (A)
 PAY2                          999-1000
 PAY2_X                       1001-1004 (A)
 PAY3                         1005-1006
 PAY3_X                       1007-1010 (A)
 PCLASS_ORPROC                1011-1012
 PL_CBSA                      1013-1015
 PL_NCHS                      1016-1017
 PL_RUCC                      1018-1019
 PL_UIC2023                   1020-1021
 PL_UR_CAT4                   1022-1023
 POA_Disch_Edit1              1024-1025
 POA_Disch_Edit2              1026-1027
 POA_Hosp_Edit1               1028-1029
 POA_Hosp_Edit2               1030-1031
 POA_Hosp_Edit3               1032-1033
 POA_Hosp_Edit3_Value         1034-1041
 PointOfOrigin_X              1042     (A)
 PointOfOriginUB04            1043     (A)
 PRDAY1                       1044-1048
 PRDAY2                       1049-1053
 PRDAY3                       1054-1058
 PRDAY4                       1059-1063
 PRDAY5                       1064-1068
 PRDAY6                       1069-1073
 PRDAY7                       1074-1078
 PRDAY8                       1079-1083
 PRDAY9                       1084-1088
 PRDAY10                      1089-1093
 PRDAY11                      1094-1098
 PRDAY12                      1099-1103
 PRDAY13                      1104-1108
 PRDAY14                      1109-1113
 PRDAY15                      1114-1118
 PRDAY16                      1119-1123
 PRDAY17                      1124-1128
 PRDAY18                      1129-1133
 PRDAY19                      1134-1138
 PRDAY20                      1139-1143
 PRDAY21                      1144-1148
 PRDAY22                      1149-1153
 PRDAY23                      1154-1158
 PRDAY24                      1159-1163
 PRDAY25                      1164-1168
 PRDAY26                      1169-1173
 PRDAY27                      1174-1178
 PRDAY28                      1179-1183
 PRDAY29                      1184-1188
 PRDAY30                      1189-1193
 PRDAY31                      1194-1198
 PRDAY32                      1199-1203
 PRDAY33                      1204-1208
 PRDAY34                      1209-1213
 PRDAY35                      1214-1218
 PRDAY36                      1219-1223
 PRDAY37                      1224-1228
 PRDAY38                      1229-1233
 PRDAY39                      1234-1238
 PRDAY40                      1239-1243
 PrimLang                     1244-1246 (A)
 PSTATE                       1247-1248 (A)
 PSTATE_GEO                   1249-1250 (A)
 PSTCO                        1251-1255
 PSTCO_GEO                    1256-1260
 RACE                         1261-1262
 RACE_PCT_MISS_HOSP           1263-1269
 RACE_X                       1270-1273 (A)
 TOTCHG                       1274-1283
 TOTCHG_X                     1284-1298
 TRAN_IN                      1299-1300
 TRAN_OUT                     1301-1302
 VisitLink                    1303-1311
 YEAR                         1312-1315
 ZIP                          1316-1320 (A)
 ZIP3                         1321-1323 (A)
 ZIPINC_QRTL                  1324-1326
 AYEAR                        1327-1330
 BMONTH                       1331-1332
 BYEAR                        1333-1336
 PRMONTH1                     1337-1338
 PRMONTH2                     1339-1340
 PRMONTH3                     1341-1342
 PRMONTH4                     1343-1344
 PRMONTH5                     1345-1346
 PRMONTH6                     1347-1348
 PRMONTH7                     1349-1350
 PRMONTH8                     1351-1352
 PRMONTH9                     1353-1354
 PRMONTH10                    1355-1356
 PRMONTH11                    1357-1358
 PRMONTH12                    1359-1360
 PRMONTH13                    1361-1362
 PRMONTH14                    1363-1364
 PRMONTH15                    1365-1366
 PRMONTH16                    1367-1368
 PRMONTH17                    1369-1370
 PRMONTH18                    1371-1372
 PRMONTH19                    1373-1374
 PRMONTH20                    1375-1376
 PRMONTH21                    1377-1378
 PRMONTH22                    1379-1380
 PRMONTH23                    1381-1382
 PRMONTH24                    1383-1384
 PRMONTH25                    1385-1386
 PRMONTH26                    1387-1388
 PRMONTH27                    1389-1390
 PRMONTH28                    1391-1392
 PRMONTH29                    1393-1394
 PRMONTH30                    1395-1396
 PRMONTH31                    1397-1398
 PRMONTH32                    1399-1400
 PRMONTH33                    1401-1402
 PRMONTH34                    1403-1404
 PRMONTH35                    1405-1406
 PRMONTH36                    1407-1408
 PRMONTH37                    1409-1410
 PRMONTH38                    1411-1412
 PRMONTH39                    1413-1414
 PRMONTH40                    1415-1416
 PRYEAR1                      1417-1420
 PRYEAR2                      1421-1424
 PRYEAR3                      1425-1428
 PRYEAR4                      1429-1432
 PRYEAR5                      1433-1436
 PRYEAR6                      1437-1440
 PRYEAR7                      1441-1444
 PRYEAR8                      1445-1448
 PRYEAR9                      1449-1452
 PRYEAR10                     1453-1456
 PRYEAR11                     1457-1460
 PRYEAR12                     1461-1464
 PRYEAR13                     1465-1468
 PRYEAR14                     1469-1472
 PRYEAR15                     1473-1476
 PRYEAR16                     1477-1480
 PRYEAR17                     1481-1484
 PRYEAR18                     1485-1488
 PRYEAR19                     1489-1492
 PRYEAR20                     1493-1496
 PRYEAR21                     1497-1500
 PRYEAR22                     1501-1504
 PRYEAR23                     1505-1508
 PRYEAR24                     1509-1512
 PRYEAR25                     1513-1516
 PRYEAR26                     1517-1520
 PRYEAR27                     1521-1524
 PRYEAR28                     1525-1528
 PRYEAR29                     1529-1532
 PRYEAR30                     1533-1536
 PRYEAR31                     1537-1540
 PRYEAR32                     1541-1544
 PRYEAR33                     1545-1548
 PRYEAR34                     1549-1552
 PRYEAR35                     1553-1556
 PRYEAR36                     1557-1560
 PRYEAR37                     1561-1564
 PRYEAR38                     1565-1568
 PRYEAR39                     1569-1572
 PRYEAR40                     1573-1576.


/***  Specify write formats  ***/
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 HospitalUnit                 (F3.0) /
 I10_BIRTH                    (F3.0) /
 I10_DELIVERY                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PCLASS_ORPROC                (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC2023                   (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PSTCO                        (F4.0) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 RACE_PCT_MISS_HOSP           (F4.2) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRMONTH31                    (F3.0) /
 PRMONTH32                    (F3.0) /
 PRMONTH33                    (F3.0) /
 PRMONTH34                    (F3.0) /
 PRMONTH35                    (F3.0) /
 PRMONTH36                    (F3.0) /
 PRMONTH37                    (F3.0) /
 PRMONTH38                    (F3.0) /
 PRMONTH39                    (F3.0) /
 PRMONTH40                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) /
 PRYEAR31                     (F3.0) /
 PRYEAR32                     (F3.0) /
 PRYEAR33                     (F3.0) /
 PRYEAR34                     (F3.0) /
 PRYEAR35                     (F3.0) /
 PRYEAR36                     (F3.0) /
 PRYEAR37                     (F3.0) /
 PRYEAR38                     (F3.0) /
 PRYEAR39                     (F3.0) /
 PRYEAR40                     (F3.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXPOA61                      "Diagnosis 61, present on admission indicator"
 DXPOA62                      "Diagnosis 62, present on admission indicator"
 DXPOA63                      "Diagnosis 63, present on admission indicator"
 DXPOA64                      "Diagnosis 64, present on admission indicator"
 DXPOA65                      "Diagnosis 65, present on admission indicator"
 DXPOA66                      "Diagnosis 66, present on admission indicator"
 DXPOA67                      "Diagnosis 67, present on admission indicator"
 DXPOA68                      "Diagnosis 68, present on admission indicator"
 DXPOA69                      "Diagnosis 69, present on admission indicator"
 DXPOA70                      "Diagnosis 70, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HospitalUnit
"Patient was discharged from a special unit within an acute care hospital (reported by source)"
 HOSPST                       "Hospital state postal code"
 I10_BIRTH                    "ICD-10-CM Birth Indicator"
 I10_DELIVERY                 "ICD-10-CM Delivery Indicator"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_DX61                     "ICD-10-CM Diagnosis 61"
 I10_DX62                     "ICD-10-CM Diagnosis 62"
 I10_DX63                     "ICD-10-CM Diagnosis 63"
 I10_DX64                     "ICD-10-CM Diagnosis 64"
 I10_DX65                     "ICD-10-CM Diagnosis 65"
 I10_DX66                     "ICD-10-CM Diagnosis 66"
 I10_DX67                     "ICD-10-CM Diagnosis 67"
 I10_DX68                     "ICD-10-CM Diagnosis 68"
 I10_DX69                     "ICD-10-CM Diagnosis 69"
 I10_DX70                     "ICD-10-CM Diagnosis 70"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PCLASS_ORPROC                "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC2023                   "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PrimLang                     "Primary language of patient"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 RACE                         "Race (uniform)"
 RACE_PCT_MISS_HOSP           "Hospital percentage of missing or invalid race values"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRMONTH31                    "Month of procedure 31"
 PRMONTH32                    "Month of procedure 32"
 PRMONTH33                    "Month of procedure 33"
 PRMONTH34                    "Month of procedure 34"
 PRMONTH35                    "Month of procedure 35"
 PRMONTH36                    "Month of procedure 36"
 PRMONTH37                    "Month of procedure 37"
 PRMONTH38                    "Month of procedure 38"
 PRMONTH39                    "Month of procedure 39"
 PRMONTH40                    "Month of procedure 40"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30"
 PRYEAR31                     "Year of procedure 31"
 PRYEAR32                     "Year of procedure 32"
 PRYEAR33                     "Year of procedure 33"
 PRYEAR34                     "Year of procedure 34"
 PRYEAR35                     "Year of procedure 35"
 PRYEAR36                     "Year of procedure 36"
 PRYEAR37                     "Year of procedure 37"
 PRYEAR38                     "Year of procedure 38"
 PRYEAR39                     "Year of procedure 39"
 PRYEAR40                     "Year of procedure 40" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BIRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_DELIVERY
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2023
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_PCT_MISS_HOSP
 (-999.99,-888.88,-666.66,-555.55=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'IA_SID_2024_CORE.sav' /COMPRESSED.
