/*******************************************************************
* Creation Date: 05/24/2017   
*   KY_SID_2015q4_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'KY_SID_2015q4_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BILLTYPE                       16-  19 (A)
 BWT                            20-  23
 DIED                           24-  25
 DISP_X                         26-  27 (A)
 DISPUB04                       28-  29
 DISPUNIFORM                    30-  31
 DMONTH                         32-  33
 DNR                            34-  35
 DQTR                           36-  37
 DRG                            38-  40
 DRG_NoPOA                      41-  43
 DRG32                          44-  46
 DRGVER                         47-  48
 DSHOSPID                       49-  65 (A)
 DXPOA1                         66     (A)
 DXPOA2                         67     (A)
 DXPOA3                         68     (A)
 DXPOA4                         69     (A)
 DXPOA5                         70     (A)
 DXPOA6                         71     (A)
 DXPOA7                         72     (A)
 DXPOA8                         73     (A)
 DXPOA9                         74     (A)
 DXPOA10                        75     (A)
 DXPOA11                        76     (A)
 DXPOA12                        77     (A)
 DXPOA13                        78     (A)
 DXPOA14                        79     (A)
 DXPOA15                        80     (A)
 DXPOA16                        81     (A)
 DXPOA17                        82     (A)
 DXPOA18                        83     (A)
 DXPOA19                        84     (A)
 DXPOA20                        85     (A)
 DXPOA21                        86     (A)
 DXPOA22                        87     (A)
 DXPOA23                        88     (A)
 DXPOA24                        89     (A)
 DXPOA25                        90     (A)
 DXVER                          91-  93
 E_POA1                         94     (A)
 E_POA2                         95     (A)
 E_POA3                         96     (A)
 E_POA4                         97     (A)
 E_POA5                         98     (A)
 E_POA6                         99     (A)
 E_POA7                        100     (A)
 E_POA8                        101     (A)
 E_POA9                        102     (A)
 FEMALE                        103- 104
 HCUP_ED                       105- 106
 HCUP_OS                       107- 108
 HISPANIC                      109- 110
 HISPANIC_X                    111- 112 (A)
 HOSP_NPI                      113- 122 (A)
 HOSPST                        123- 124 (A)
 I10_DX_Admitting              125- 131 (A)
 I10_DX1                       132- 138 (A)
 I10_DX2                       139- 145 (A)
 I10_DX3                       146- 152 (A)
 I10_DX4                       153- 159 (A)
 I10_DX5                       160- 166 (A)
 I10_DX6                       167- 173 (A)
 I10_DX7                       174- 180 (A)
 I10_DX8                       181- 187 (A)
 I10_DX9                       188- 194 (A)
 I10_DX10                      195- 201 (A)
 I10_DX11                      202- 208 (A)
 I10_DX12                      209- 215 (A)
 I10_DX13                      216- 222 (A)
 I10_DX14                      223- 229 (A)
 I10_DX15                      230- 236 (A)
 I10_DX16                      237- 243 (A)
 I10_DX17                      244- 250 (A)
 I10_DX18                      251- 257 (A)
 I10_DX19                      258- 264 (A)
 I10_DX20                      265- 271 (A)
 I10_DX21                      272- 278 (A)
 I10_DX22                      279- 285 (A)
 I10_DX23                      286- 292 (A)
 I10_DX24                      293- 299 (A)
 I10_DX25                      300- 306 (A)
 I10_DXCCS1                    307- 310
 I10_DXCCS2                    311- 314
 I10_DXCCS3                    315- 318
 I10_DXCCS4                    319- 322
 I10_DXCCS5                    323- 326
 I10_DXCCS6                    327- 330
 I10_DXCCS7                    331- 334
 I10_DXCCS8                    335- 338
 I10_DXCCS9                    339- 342
 I10_DXCCS10                   343- 346
 I10_DXCCS11                   347- 350
 I10_DXCCS12                   351- 354
 I10_DXCCS13                   355- 358
 I10_DXCCS14                   359- 362
 I10_DXCCS15                   363- 366
 I10_DXCCS16                   367- 370
 I10_DXCCS17                   371- 374
 I10_DXCCS18                   375- 378
 I10_DXCCS19                   379- 382
 I10_DXCCS20                   383- 386
 I10_DXCCS21                   387- 390
 I10_DXCCS22                   391- 394
 I10_DXCCS23                   395- 398
 I10_DXCCS24                   399- 402
 I10_DXCCS25                   403- 406
 I10_ECAUSE1                   407- 413 (A)
 I10_ECAUSE2                   414- 420 (A)
 I10_ECAUSE3                   421- 427 (A)
 I10_ECAUSE4                   428- 434 (A)
 I10_ECAUSE5                   435- 441 (A)
 I10_ECAUSE6                   442- 448 (A)
 I10_ECAUSE7                   449- 455 (A)
 I10_ECAUSE8                   456- 462 (A)
 I10_ECAUSE9                   463- 469 (A)
 I10_ECauseCCS1                470- 473
 I10_ECauseCCS2                474- 477
 I10_ECauseCCS3                478- 481
 I10_ECauseCCS4                482- 485
 I10_ECauseCCS5                486- 489
 I10_ECauseCCS6                490- 493
 I10_ECauseCCS7                494- 497
 I10_ECauseCCS8                498- 501
 I10_ECauseCCS9                502- 505
 I10_HOSPBRTH                  506- 508
 I10_NCHRONIC                  509- 511
 I10_NDX                       512- 514
 I10_NECAUSE                   515- 516
 I10_NEOMAT                    517- 518
 I10_NPR                       519- 521
 I10_ORPROC                    522- 523
 I10_PR1                       524- 530 (A)
 I10_PR2                       531- 537 (A)
 I10_PR3                       538- 544 (A)
 I10_PR4                       545- 551 (A)
 I10_PR5                       552- 558 (A)
 I10_PR6                       559- 565 (A)
 I10_PR7                       566- 572 (A)
 I10_PR8                       573- 579 (A)
 I10_PR9                       580- 586 (A)
 I10_PR10                      587- 593 (A)
 I10_PR11                      594- 600 (A)
 I10_PR12                      601- 607 (A)
 I10_PR13                      608- 614 (A)
 I10_PR14                      615- 621 (A)
 I10_PR15                      622- 628 (A)
 I10_PR16                      629- 635 (A)
 I10_PR17                      636- 642 (A)
 I10_PR18                      643- 649 (A)
 I10_PR19                      650- 656 (A)
 I10_PR20                      657- 663 (A)
 I10_PR21                      664- 670 (A)
 I10_PR22                      671- 677 (A)
 I10_PR23                      678- 684 (A)
 I10_PR24                      685- 691 (A)
 I10_PR25                      692- 698 (A)
 I10_PRCCS1                    699- 701
 I10_PRCCS2                    702- 704
 I10_PRCCS3                    705- 707
 I10_PRCCS4                    708- 710
 I10_PRCCS5                    711- 713
 I10_PRCCS6                    714- 716
 I10_PRCCS7                    717- 719
 I10_PRCCS8                    720- 722
 I10_PRCCS9                    723- 725
 I10_PRCCS10                   726- 728
 I10_PRCCS11                   729- 731
 I10_PRCCS12                   732- 734
 I10_PRCCS13                   735- 737
 I10_PRCCS14                   738- 740
 I10_PRCCS15                   741- 743
 I10_PRCCS16                   744- 746
 I10_PRCCS17                   747- 749
 I10_PRCCS18                   750- 752
 I10_PRCCS19                   753- 755
 I10_PRCCS20                   756- 758
 I10_PRCCS21                   759- 761
 I10_PRCCS22                   762- 764
 I10_PRCCS23                   765- 767
 I10_PRCCS24                   768- 770
 I10_PRCCS25                   771- 773
 I10_PROCTYPE                  774- 776
 I10_SERVICELINE               777- 778
 KEY                           779- 793
 LOS                           794- 798
 LOS_X                         799- 804
 MDC                           805- 806
 MDC_NoPOA                     807- 808
 MDC32                         809- 810
 MEDINCSTQ                     811- 812
 OS_TIME                       813- 823
 PAY1                          824- 825
 PAY1_X                        826- 830 (A)
 PAY2                          831- 832
 PAY2_X                        833- 837 (A)
 PAY3                          838- 839
 PAY3_X                        840- 844 (A)
 PL_CBSA                       845- 847
 PL_NCHS                       848- 849
 PL_RUCC                       850- 851
 PL_UIC                        852- 853
 PL_UR_CAT4                    854- 855
 POA_Disch_Edit1               856- 857
 POA_Disch_Edit2               858- 859
 POA_Hosp_Edit1                860- 861
 POA_Hosp_Edit2                862- 863
 POA_Hosp_Edit3                864- 865
 POA_Hosp_Edit3_Value          866- 873
 PointOfOrigin_X               874     (A)
 PointOfOriginUB04             875     (A)
 PRDAY1                        876- 880
 PRDAY2                        881- 885
 PRDAY3                        886- 890
 PRDAY4                        891- 895
 PRDAY5                        896- 900
 PRDAY6                        901- 905
 PRDAY7                        906- 910
 PRDAY8                        911- 915
 PRDAY9                        916- 920
 PRDAY10                       921- 925
 PRDAY11                       926- 930
 PRDAY12                       931- 935
 PRDAY13                       936- 940
 PRDAY14                       941- 945
 PRDAY15                       946- 950
 PRDAY16                       951- 955
 PRDAY17                       956- 960
 PRDAY18                       961- 965
 PRDAY19                       966- 970
 PRDAY20                       971- 975
 PRDAY21                       976- 980
 PRDAY22                       981- 985
 PRDAY23                       986- 990
 PRDAY24                       991- 995
 PRDAY25                       996-1000
 PRVER                        1001-1003
 PSTATE                       1004-1005 (A)
 PSTCO                        1006-1010
 PSTCO2                       1011-1015
 RACE                         1016-1017
 RACE_X                       1018-1019 (A)
 TOTCHG                       1020-1029
 TOTCHG_X                     1030-1044
 TRAN_IN                      1045-1046
 TRAN_OUT                     1047-1048
 YEAR                         1049-1052
 ZIP                          1053-1057 (A)
 ZIPINC_QRTL                  1058-1060
 AYEAR                        1061-1064
 BMONTH                       1065-1066
 BYEAR                        1067-1070
 PRMONTH1                     1071-1072
 PRMONTH2                     1073-1074
 PRMONTH3                     1075-1076
 PRMONTH4                     1077-1078
 PRMONTH5                     1079-1080
 PRMONTH6                     1081-1082
 PRMONTH7                     1083-1084
 PRMONTH8                     1085-1086
 PRMONTH9                     1087-1088
 PRMONTH10                    1089-1090
 PRMONTH11                    1091-1092
 PRMONTH12                    1093-1094
 PRMONTH13                    1095-1096
 PRMONTH14                    1097-1098
 PRMONTH15                    1099-1100
 PRMONTH16                    1101-1102
 PRMONTH17                    1103-1104
 PRMONTH18                    1105-1106
 PRMONTH19                    1107-1108
 PRMONTH20                    1109-1110
 PRMONTH21                    1111-1112
 PRMONTH22                    1113-1114
 PRMONTH23                    1115-1116
 PRMONTH24                    1117-1118
 PRMONTH25                    1119-1120
 PRYEAR1                      1121-1124
 PRYEAR2                      1125-1128
 PRYEAR3                      1129-1132
 PRYEAR4                      1133-1136
 PRYEAR5                      1137-1140
 PRYEAR6                      1141-1144
 PRYEAR7                      1145-1148
 PRYEAR8                      1149-1152
 PRYEAR9                      1153-1156
 PRYEAR10                     1157-1160
 PRYEAR11                     1161-1164
 PRYEAR12                     1165-1168
 PRYEAR13                     1169-1172
 PRYEAR14                     1173-1176
 PRYEAR15                     1177-1180
 PRYEAR16                     1181-1184
 PRYEAR17                     1185-1188
 PRYEAR18                     1189-1192
 PRYEAR19                     1193-1196
 PRYEAR20                     1197-1200
 PRYEAR21                     1201-1204
 PRYEAR22                     1205-1208
 PRYEAR23                     1209-1212
 PRYEAR24                     1213-1216
 PRYEAR25                     1217-1220.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DNR                          (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRG32                        (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_DXCCS1                   (F4.0) /
 I10_DXCCS2                   (F4.0) /
 I10_DXCCS3                   (F4.0) /
 I10_DXCCS4                   (F4.0) /
 I10_DXCCS5                   (F4.0) /
 I10_DXCCS6                   (F4.0) /
 I10_DXCCS7                   (F4.0) /
 I10_DXCCS8                   (F4.0) /
 I10_DXCCS9                   (F4.0) /
 I10_DXCCS10                  (F4.0) /
 I10_DXCCS11                  (F4.0) /
 I10_DXCCS12                  (F4.0) /
 I10_DXCCS13                  (F4.0) /
 I10_DXCCS14                  (F4.0) /
 I10_DXCCS15                  (F4.0) /
 I10_DXCCS16                  (F4.0) /
 I10_DXCCS17                  (F4.0) /
 I10_DXCCS18                  (F4.0) /
 I10_DXCCS19                  (F4.0) /
 I10_DXCCS20                  (F4.0) /
 I10_DXCCS21                  (F4.0) /
 I10_DXCCS22                  (F4.0) /
 I10_DXCCS23                  (F4.0) /
 I10_DXCCS24                  (F4.0) /
 I10_DXCCS25                  (F4.0) /
 I10_ECauseCCS1               (F3.0) /
 I10_ECauseCCS2               (F3.0) /
 I10_ECauseCCS3               (F3.0) /
 I10_ECauseCCS4               (F3.0) /
 I10_ECauseCCS5               (F3.0) /
 I10_ECauseCCS6               (F3.0) /
 I10_ECauseCCS7               (F3.0) /
 I10_ECauseCCS8               (F3.0) /
 I10_ECauseCCS9               (F3.0) /
 I10_HOSPBRTH                 (F3.0) /
 I10_NCHRONIC                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NEOMAT                   (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PRCCS1                   (F3.0) /
 I10_PRCCS2                   (F3.0) /
 I10_PRCCS3                   (F3.0) /
 I10_PRCCS4                   (F3.0) /
 I10_PRCCS5                   (F3.0) /
 I10_PRCCS6                   (F3.0) /
 I10_PRCCS7                   (F3.0) /
 I10_PRCCS8                   (F3.0) /
 I10_PRCCS9                   (F3.0) /
 I10_PRCCS10                  (F3.0) /
 I10_PRCCS11                  (F3.0) /
 I10_PRCCS12                  (F3.0) /
 I10_PRCCS13                  (F3.0) /
 I10_PRCCS14                  (F3.0) /
 I10_PRCCS15                  (F3.0) /
 I10_PRCCS16                  (F3.0) /
 I10_PRCCS17                  (F3.0) /
 I10_PRCCS18                  (F3.0) /
 I10_PRCCS19                  (F3.0) /
 I10_PRCCS20                  (F3.0) /
 I10_PRCCS21                  (F3.0) /
 I10_PRCCS22                  (F3.0) /
 I10_PRCCS23                  (F3.0) /
 I10_PRCCS24                  (F3.0) /
 I10_PRCCS25                  (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDC32                        (F3.0) /
 MEDINCSTQ                    (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 BWT                          "Birth weight in grams"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DNR                          "Do not resuscitate indicator"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRG32                        "DRG, version 32"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "E Cause 1, present on admission indicator"
 E_POA2                       "E Cause 2, present on admission indicator"
 E_POA3                       "E Cause 3, present on admission indicator"
 E_POA4                       "E Cause 4, present on admission indicator"
 E_POA5                       "E Cause 5, present on admission indicator"
 E_POA6                       "E Cause 6, present on admission indicator"
 E_POA7                       "E Cause 7, present on admission indicator"
 E_POA8                       "E Cause 8, present on admission indicator"
 E_POA9                       "E Cause 9, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSP_NPI                     "Hospital NPI"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DXCCS1                   "ICD-10-CM CCS: diagnosis 1"
 I10_DXCCS2                   "ICD-10-CM CCS: diagnosis 2"
 I10_DXCCS3                   "ICD-10-CM CCS: diagnosis 3"
 I10_DXCCS4                   "ICD-10-CM CCS: diagnosis 4"
 I10_DXCCS5                   "ICD-10-CM CCS: diagnosis 5"
 I10_DXCCS6                   "ICD-10-CM CCS: diagnosis 6"
 I10_DXCCS7                   "ICD-10-CM CCS: diagnosis 7"
 I10_DXCCS8                   "ICD-10-CM CCS: diagnosis 8"
 I10_DXCCS9                   "ICD-10-CM CCS: diagnosis 9"
 I10_DXCCS10                  "ICD-10-CM CCS: diagnosis 10"
 I10_DXCCS11                  "ICD-10-CM CCS: diagnosis 11"
 I10_DXCCS12                  "ICD-10-CM CCS: diagnosis 12"
 I10_DXCCS13                  "ICD-10-CM CCS: diagnosis 13"
 I10_DXCCS14                  "ICD-10-CM CCS: diagnosis 14"
 I10_DXCCS15                  "ICD-10-CM CCS: diagnosis 15"
 I10_DXCCS16                  "ICD-10-CM CCS: diagnosis 16"
 I10_DXCCS17                  "ICD-10-CM CCS: diagnosis 17"
 I10_DXCCS18                  "ICD-10-CM CCS: diagnosis 18"
 I10_DXCCS19                  "ICD-10-CM CCS: diagnosis 19"
 I10_DXCCS20                  "ICD-10-CM CCS: diagnosis 20"
 I10_DXCCS21                  "ICD-10-CM CCS: diagnosis 21"
 I10_DXCCS22                  "ICD-10-CM CCS: diagnosis 22"
 I10_DXCCS23                  "ICD-10-CM CCS: diagnosis 23"
 I10_DXCCS24                  "ICD-10-CM CCS: diagnosis 24"
 I10_DXCCS25                  "ICD-10-CM CCS: diagnosis 25"
 I10_ECAUSE1                  "ICD-10-CM E Cause 1"
 I10_ECAUSE2                  "ICD-10-CM E Cause 2"
 I10_ECAUSE3                  "ICD-10-CM E Cause 3"
 I10_ECAUSE4                  "ICD-10-CM E Cause 4"
 I10_ECAUSE5                  "ICD-10-CM E Cause 5"
 I10_ECAUSE6                  "ICD-10-CM E Cause 6"
 I10_ECAUSE7                  "ICD-10-CM E Cause 7"
 I10_ECAUSE8                  "ICD-10-CM E Cause 8"
 I10_ECAUSE9                  "ICD-10-CM E Cause 9"
 I10_ECauseCCS1               "ICD-10-CM CCS: E Cause 1"
 I10_ECauseCCS2               "ICD-10-CM CCS: E Cause 2"
 I10_ECauseCCS3               "ICD-10-CM CCS: E Cause 3"
 I10_ECauseCCS4               "ICD-10-CM CCS: E Cause 4"
 I10_ECauseCCS5               "ICD-10-CM CCS: E Cause 5"
 I10_ECauseCCS6               "ICD-10-CM CCS: E Cause 6"
 I10_ECauseCCS7               "ICD-10-CM CCS: E Cause 7"
 I10_ECauseCCS8               "ICD-10-CM CCS: E Cause 8"
 I10_ECauseCCS9               "ICD-10-CM CCS: E Cause 9"
 I10_HOSPBRTH                 "ICD-10-CM Indicator of birth in this hospital"
 I10_NCHRONIC                 "ICD-10-CM Number of chronic conditions"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of E Causes on this record"
 I10_NEOMAT                   "ICD-10-CM/PCS Neonatal and/or maternal I10_DX and/or I10_PR"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PRCCS1                   "ICD-10-PCS CCS: procedure 1"
 I10_PRCCS2                   "ICD-10-PCS CCS: procedure 2"
 I10_PRCCS3                   "ICD-10-PCS CCS: procedure 3"
 I10_PRCCS4                   "ICD-10-PCS CCS: procedure 4"
 I10_PRCCS5                   "ICD-10-PCS CCS: procedure 5"
 I10_PRCCS6                   "ICD-10-PCS CCS: procedure 6"
 I10_PRCCS7                   "ICD-10-PCS CCS: procedure 7"
 I10_PRCCS8                   "ICD-10-PCS CCS: procedure 8"
 I10_PRCCS9                   "ICD-10-PCS CCS: procedure 9"
 I10_PRCCS10                  "ICD-10-PCS CCS: procedure 10"
 I10_PRCCS11                  "ICD-10-PCS CCS: procedure 11"
 I10_PRCCS12                  "ICD-10-PCS CCS: procedure 12"
 I10_PRCCS13                  "ICD-10-PCS CCS: procedure 13"
 I10_PRCCS14                  "ICD-10-PCS CCS: procedure 14"
 I10_PRCCS15                  "ICD-10-PCS CCS: procedure 15"
 I10_PRCCS16                  "ICD-10-PCS CCS: procedure 16"
 I10_PRCCS17                  "ICD-10-PCS CCS: procedure 17"
 I10_PRCCS18                  "ICD-10-PCS CCS: procedure 18"
 I10_PRCCS19                  "ICD-10-PCS CCS: procedure 19"
 I10_PRCCS20                  "ICD-10-PCS CCS: procedure 20"
 I10_PRCCS21                  "ICD-10-PCS CCS: procedure 21"
 I10_PRCCS22                  "ICD-10-PCS CCS: procedure 22"
 I10_PRCCS23                  "ICD-10-PCS CCS: procedure 23"
 I10_PRCCS24                  "ICD-10-PCS CCS: procedure 24"
 I10_PRCCS25                  "ICD-10-PCS CCS: procedure 25"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDC32                        "MDC, version 32"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2
"Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1
"Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2
"Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value
"Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG32
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC32
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'KY_SID_2015q4_CORE.SAV' /COMPRESSED.
