/*******************************************************************
*   MA_SID_2011_SEVERITY.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY SEVERITY FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MA_SID_2011_SEVERITY.ASC' FIXED / 
 KEY                        1-  18
 CM_ANEMDEF                19-  20
 CM_ARTH                   21-  22
 CM_BLDLOSS                23-  24
 CM_CHF                    25-  26
 CM_CHRNLUNG               27-  28
 CM_COAG                   29-  30
 CM_DM                     31-  32
 CM_DMCX                   33-  34
 CM_HTN_C                  35-  36
 CM_HYPOTHY                37-  38
 CM_LYMPH                  39-  40
 CM_LYTES                  41-  42
 CM_METS                   43-  44
 CM_NEURO                  45-  46
 CM_PARA                   47-  48
 CM_PERIVASC               49-  50
 CM_PULMCIRC               51-  52
 CM_RENLFAIL               53-  54
 CM_TUMOR                  55-  56
 CM_ULCER                  57-  58
 CM_VALVE                  59-  60
 CM_WGHTLOSS               61-  62.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 CM_ANEMDEF              (F3.0) /
 CM_ARTH                 (F3.0) /
 CM_BLDLOSS              (F3.0) /
 CM_CHF                  (F3.0) /
 CM_CHRNLUNG             (F3.0) /
 CM_COAG                 (F3.0) /
 CM_DM                   (F3.0) /
 CM_DMCX                 (F3.0) /
 CM_HTN_C                (F3.0) /
 CM_HYPOTHY              (F3.0) /
 CM_LYMPH                (F3.0) /
 CM_LYTES                (F3.0) /
 CM_METS                 (F3.0) /
 CM_NEURO                (F3.0) /
 CM_PARA                 (F3.0) /
 CM_PERIVASC             (F3.0) /
 CM_PULMCIRC             (F3.0) /
 CM_RENLFAIL             (F3.0) /
 CM_TUMOR                (F3.0) /
 CM_ULCER                (F3.0) /
 CM_VALVE                (F3.0) /
 CM_WGHTLOSS             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY                     "HCUP record identifier"
 CM_ANEMDEF              "AHRQ comorbidity measure: Deficiency anemias"
 CM_ARTH
"AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular diseases"
 CM_BLDLOSS              "AHRQ comorbidity measure: Chronic blood loss anemia"
 CM_CHF                  "AHRQ comorbidity measure: Congestive heart failure"
 CM_CHRNLUNG             "AHRQ comorbidity measure: Chronic pulmonary disease"
 CM_COAG                 "AHRQ comorbidity measure: Coagulopathy"
 CM_DM                   "AHRQ comorbidity measure: Diabetes, uncomplicated"
 CM_DMCX                 "AHRQ comorbidity measure: Diabetes with chronic complications"
 CM_HTN_C
"AHRQ comorbidity measure: Hypertension (combine uncomplicated and complicated)"
 CM_HYPOTHY              "AHRQ comorbidity measure: Hypothyroidism"
 CM_LYMPH                "AHRQ comorbidity measure: Lymphoma"
 CM_LYTES                "AHRQ comorbidity measure: Fluid and electrolyte disorders"
 CM_METS                 "AHRQ comorbidity measure: Metastatic cancer"
 CM_NEURO                "AHRQ comorbidity measure: Other neurological disorders"
 CM_PARA                 "AHRQ comorbidity measure: Paralysis"
 CM_PERIVASC             "AHRQ comorbidity measure: Peripheral vascular disorders"
 CM_PULMCIRC             "AHRQ comorbidity measure: Pulmonary circulation disorders"
 CM_RENLFAIL             "AHRQ comorbidity measure: Renal failure"
 CM_TUMOR                "AHRQ comorbidity measure: Solid tumor without metastasis"
 CM_ULCER                "AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding"
 CM_VALVE                "AHRQ comorbidity measure: Valvular disease"
 CM_WGHTLOSS             "AHRQ comorbidity measure: Weight loss" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CM_ANEMDEF
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ARTH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_BLDLOSS
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_CHF
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_CHRNLUNG
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_COAG
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DM
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DMCX
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_HTN_C
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_HYPOTHY
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LYMPH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LYTES
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_METS
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_NEURO
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PARA
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PERIVASC
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PULMCIRC
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_RENLFAIL
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_TUMOR
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ULCER
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_VALVE
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_WGHTLOSS
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MA_SID_2011_SEVERITY.SAV' /COMPRESSED.
