/*******************************************************************
*   MA_SID_2012_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MA_SID_2012_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRON10                   19-  20
 CHRON11                   21-  22
 CHRON12                   23-  24
 CHRON13                   25-  26
 CHRON14                   27-  28
 CHRON15                   29-  30
 CHRONB1                   31-  32
 CHRONB2                   33-  34
 CHRONB3                   35-  36
 CHRONB4                   37-  38
 CHRONB5                   39-  40
 CHRONB6                   41-  42
 CHRONB7                   43-  44
 CHRONB8                   45-  46
 CHRONB9                   47-  48
 CHRONB10                  49-  50
 CHRONB11                  51-  52
 CHRONB12                  53-  54
 CHRONB13                  55-  56
 CHRONB14                  57-  58
 CHRONB15                  59-  60
 DXMCCS1                   61-  71 (A)
 DXMCCS2                   72-  82 (A)
 DXMCCS3                   83-  93 (A)
 DXMCCS4                   94- 104 (A)
 DXMCCS5                  105- 115 (A)
 DXMCCS6                  116- 126 (A)
 DXMCCS7                  127- 137 (A)
 DXMCCS8                  138- 148 (A)
 DXMCCS9                  149- 159 (A)
 DXMCCS10                 160- 170 (A)
 DXMCCS11                 171- 181 (A)
 DXMCCS12                 182- 192 (A)
 DXMCCS13                 193- 203 (A)
 DXMCCS14                 204- 214 (A)
 DXMCCS15                 215- 225 (A)
 E_MCCS1                  226- 236 (A)
 E_MCCS2                  237- 247 (A)
 E_MCCS3                  248- 258 (A)
 E_MCCS4                  259- 269 (A)
 E_MCCS5                  270- 280 (A)
 E_MCCS6                  281- 291 (A)
 E_MCCS7                  292- 302 (A)
 E_MCCS8                  303- 313 (A)
 INJURY                   314- 315
 INJURY_CUT               316- 317
 INJURY_DROWN             318- 319
 INJURY_FALL              320- 321
 INJURY_FIRE              322- 323
 INJURY_FIREARM           324- 325
 INJURY_MACHINERY         326- 327
 INJURY_MVT               328- 329
 INJURY_NATURE            330- 331
 INJURY_POISON            332- 333
 INJURY_STRUCK            334- 335
 INJURY_SUFFOCATION       336- 337
 INTENT_ASSAULT           338- 339
 INTENT_SELF_HARM         340- 341
 INTENT_UNINTENTIONAL     342- 343
 KEY                      344- 358
 MULTINJURY               359- 360
 PCLASS1                  361- 362
 PCLASS2                  363- 364
 PCLASS3                  365- 366
 PCLASS4                  367- 368
 PCLASS5                  369- 370
 PCLASS6                  371- 372
 PCLASS7                  373- 374
 PCLASS8                  375- 376
 PCLASS9                  377- 378
 PCLASS10                 379- 380
 PCLASS11                 381- 382
 PCLASS12                 383- 384
 PCLASS13                 385- 386
 PCLASS14                 387- 388
 PCLASS15                 389- 390
 PRMCCS1                  391- 398 (A)
 PRMCCS2                  399- 406 (A)
 PRMCCS3                  407- 414 (A)
 PRMCCS4                  415- 422 (A)
 PRMCCS5                  423- 430 (A)
 PRMCCS6                  431- 438 (A)
 PRMCCS7                  439- 446 (A)
 PRMCCS8                  447- 454 (A)
 PRMCCS9                  455- 462 (A)
 PRMCCS10                 463- 470 (A)
 PRMCCS11                 471- 478 (A)
 PRMCCS12                 479- 486 (A)
 PRMCCS13                 487- 494 (A)
 PRMCCS14                 495- 502 (A)
 PRMCCS15                 503- 510 (A)
 U_BLOOD                  511- 512
 U_CATH                   513- 514
 U_CCU                    515- 516
 U_CHESTXRAY              517- 518
 U_CTSCAN                 519- 520
 U_DIALYSIS               521- 522
 U_ECHO                   523- 524
 U_ED                     525- 526
 U_EEG                    527- 528
 U_EKG                    529- 530
 U_EPO                    531- 532
 U_ICU                    533- 534
 U_LITHOTRIPSY            535- 536
 U_MHSA                   537- 538
 U_MRT                    539- 540
 U_NEWBN2L                541- 542
 U_NEWBN3L                543- 544
 U_NEWBN4L                545- 546
 U_NUCMED                 547- 548
 U_OBSERVATION            549- 550
 U_OCCTHERAPY             551- 552
 U_ORGANACQ               553- 554
 U_OTHIMPLANTS            555- 556
 U_PACEMAKER              557- 558
 U_PHYTHERAPY             559- 560
 U_RADTHERAPY             561- 562
 U_RESPTHERAPY            563- 564
 U_SPEECHTHERAPY          565- 566
 U_STRESS                 567- 568
 U_ULTRASOUND             569- 570.


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRON10                 (F3.0) /
 CHRON11                 (F3.0) /
 CHRON12                 (F3.0) /
 CHRON13                 (F3.0) /
 CHRON14                 (F3.0) /
 CHRON15                 (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 CHRONB10                (F3.0) /
 CHRONB11                (F3.0) /
 CHRONB12                (F3.0) /
 CHRONB13                (F3.0) /
 CHRONB14                (F3.0) /
 CHRONB15                (F3.0) /
 INJURY                  (F3.0) /
 INJURY_CUT              (F3.0) /
 INJURY_DROWN            (F3.0) /
 INJURY_FALL             (F3.0) /
 INJURY_FIRE             (F3.0) /
 INJURY_FIREARM          (F3.0) /
 INJURY_MACHINERY        (F3.0) /
 INJURY_MVT              (F3.0) /
 INJURY_NATURE           (F3.0) /
 INJURY_POISON           (F3.0) /
 INJURY_STRUCK           (F3.0) /
 INJURY_SUFFOCATION      (F3.0) /
 INTENT_ASSAULT          (F3.0) /
 INTENT_SELF_HARM        (F3.0) /
 INTENT_UNINTENTIONAL    (F3.0) /
 KEY                     (F8.0) /
 MULTINJURY              (F3.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
 PCLASS7                 (F3.0) /
 PCLASS8                 (F3.0) /
 PCLASS9                 (F3.0) /
 PCLASS10                (F3.0) /
 PCLASS11                (F3.0) /
 PCLASS12                (F3.0) /
 PCLASS13                (F3.0) /
 PCLASS14                (F3.0) /
 PCLASS15                (F3.0) /
 U_BLOOD                 (F3.0) /
 U_CATH                  (F3.0) /
 U_CCU                   (F3.0) /
 U_CHESTXRAY             (F3.0) /
 U_CTSCAN                (F3.0) /
 U_DIALYSIS              (F3.0) /
 U_ECHO                  (F3.0) /
 U_ED                    (F3.0) /
 U_EEG                   (F3.0) /
 U_EKG                   (F3.0) /
 U_EPO                   (F3.0) /
 U_ICU                   (F3.0) /
 U_LITHOTRIPSY           (F3.0) /
 U_MHSA                  (F3.0) /
 U_MRT                   (F3.0) /
 U_NEWBN2L               (F3.0) /
 U_NEWBN3L               (F3.0) /
 U_NEWBN4L               (F3.0) /
 U_NUCMED                (F3.0) /
 U_OBSERVATION           (F3.0) /
 U_OCCTHERAPY            (F3.0) /
 U_ORGANACQ              (F3.0) /
 U_OTHIMPLANTS           (F3.0) /
 U_PACEMAKER             (F3.0) /
 U_PHYTHERAPY            (F3.0) /
 U_RADTHERAPY            (F3.0) /
 U_RESPTHERAPY           (F3.0) /
 U_SPEECHTHERAPY         (F3.0) /
 U_STRESS                (F3.0) /
 U_ULTRASOUND            (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                  "Chronic condition indicator 1"
 CHRON2                  "Chronic condition indicator 2"
 CHRON3                  "Chronic condition indicator 3"
 CHRON4                  "Chronic condition indicator 4"
 CHRON5                  "Chronic condition indicator 5"
 CHRON6                  "Chronic condition indicator 6"
 CHRON7                  "Chronic condition indicator 7"
 CHRON8                  "Chronic condition indicator 8"
 CHRON9                  "Chronic condition indicator 9"
 CHRON10                 "Chronic condition indicator 10"
 CHRON11                 "Chronic condition indicator 11"
 CHRON12                 "Chronic condition indicator 12"
 CHRON13                 "Chronic condition indicator 13"
 CHRON14                 "Chronic condition indicator 14"
 CHRON15                 "Chronic condition indicator 15"
 CHRONB1                 "Chronic condition body system 1"
 CHRONB2                 "Chronic condition body system 2"
 CHRONB3                 "Chronic condition body system 3"
 CHRONB4                 "Chronic condition body system 4"
 CHRONB5                 "Chronic condition body system 5"
 CHRONB6                 "Chronic condition body system 6"
 CHRONB7                 "Chronic condition body system 7"
 CHRONB8                 "Chronic condition body system 8"
 CHRONB9                 "Chronic condition body system 9"
 CHRONB10                "Chronic condition body system 10"
 CHRONB11                "Chronic condition body system 11"
 CHRONB12                "Chronic condition body system 12"
 CHRONB13                "Chronic condition body system 13"
 CHRONB14                "Chronic condition body system 14"
 CHRONB15                "Chronic condition body system 15"
 DXMCCS1                 "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                 "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                 "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                 "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                 "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                 "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                 "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                 "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                 "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                "Multi-Level CCS:  Diagnosis 15"
 E_MCCS1                 "Multi-Level CCS:  E Code 1"
 E_MCCS2                 "Multi-Level CCS:  E Code 2"
 E_MCCS3                 "Multi-Level CCS:  E Code 3"
 E_MCCS4                 "Multi-Level CCS:  E Code 4"
 E_MCCS5                 "Multi-Level CCS:  E Code 5"
 E_MCCS6                 "Multi-Level CCS:  E Code 6"
 E_MCCS7                 "Multi-Level CCS:  E Code 7"
 E_MCCS8                 "Multi-Level CCS:  E Code 8"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT              "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN            "Injury by drowning or submersion (by E codes)"
 INJURY_FALL             "Injury by falling (by E codes)"
 INJURY_FIRE             "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM          "Injury by firearm (by E codes)"
 INJURY_MACHINERY        "Injury by machinery (by E codes)"
 INJURY_MVT              "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE           "Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON           "Injury by poison (by E codes)"
 INJURY_STRUCK           "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION      "Injury by suffocation (by E codes)"
 INTENT_ASSAULT          "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL    "Unintentional injury indicated on the record (by E codes)"
 KEY                     "HCUP record identifier"
 MULTINJURY              "More than one injury diagnosis reported on record"
 PCLASS1                 "Procedure class 1"
 PCLASS2                 "Procedure class 2"
 PCLASS3                 "Procedure class 3"
 PCLASS4                 "Procedure class 4"
 PCLASS5                 "Procedure class 5"
 PCLASS6                 "Procedure class 6"
 PCLASS7                 "Procedure class 7"
 PCLASS8                 "Procedure class 8"
 PCLASS9                 "Procedure class 9"
 PCLASS10                "Procedure class 10"
 PCLASS11                "Procedure class 11"
 PCLASS12                "Procedure class 12"
 PCLASS13                "Procedure class 13"
 PCLASS14                "Procedure class 14"
 PCLASS15                "Procedure class 15"
 PRMCCS1                 "Multi-Level CCS:  Procedure 1"
 PRMCCS2                 "Multi-Level CCS:  Procedure 2"
 PRMCCS3                 "Multi-Level CCS:  Procedure 3"
 PRMCCS4                 "Multi-Level CCS:  Procedure 4"
 PRMCCS5                 "Multi-Level CCS:  Procedure 5"
 PRMCCS6                 "Multi-Level CCS:  Procedure 6"
 PRMCCS7                 "Multi-Level CCS:  Procedure 7"
 PRMCCS8                 "Multi-Level CCS:  Procedure 8"
 PRMCCS9                 "Multi-Level CCS:  Procedure 9"
 PRMCCS10                "Multi-Level CCS:  Procedure 10"
 PRMCCS11                "Multi-Level CCS:  Procedure 11"
 PRMCCS12                "Multi-Level CCS:  Procedure 12"
 PRMCCS13                "Multi-Level CCS:  Procedure 13"
 PRMCCS14                "Multi-Level CCS:  Procedure 14"
 PRMCCS15                "Multi-Level CCS:  Procedure 15"
 U_BLOOD                 "Utilization Flag: Blood"
 U_CATH                  "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                   "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY             "Utilization Flag: Chest X-Ray"
 U_CTSCAN                "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS              "Utilization Flag: Renal Dialysis"
 U_ECHO                  "Utilization Flag: Echocardiology"
 U_ED                    "Utilization Flag: Emergency Room"
 U_EEG                   "Utilization Flag: Electroencephalogram"
 U_EKG                   "Utilization Flag: Electrocardiogram"
 U_EPO                   "Utilization Flag: EPO"
 U_ICU                   "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY           "Utilization Flag: Lithotripsy"
 U_MHSA                  "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                   "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2L               "Utilization Flag: Nursery Level II"
 U_NEWBN3L               "Utilization Flag: Nursery Level III"
 U_NEWBN4L               "Utilization Flag: Nursery Level IV"
 U_NUCMED                "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION           "Utilization Flag: Observation Room"
 U_OCCTHERAPY            "Utilization Flag: Occupational Therapy"
 U_ORGANACQ              "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS           "Utilization Flag: Other Implants"
 U_PACEMAKER             "Utilization Flag: Pacemaker"
 U_PHYTHERAPY            "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY           "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY         "Utilization Flag: Speech - Language Pathology"
 U_STRESS                "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND            "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MA_SID_2012_DX_PR_GRPS.SAV' /COMPRESSED.
