/*******************************************************************
*   MD_SID_1994_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MD_SID_1994_CORE.ASC' FIXED / 
 SEQ_SID               1-  13
 AGE                  14-  16
 AGEDAY               17-  19
 SEX                  20-  22
 RACE                 23-  24
 DQTR                 25-  26
 LOS                  27-  31
 DISP                 32-  33
 DIED                 34-  35
 ATYPE                36-  37
 ASOURCE              38-  39
 NDX                  40-  41
 DX1                  42-  46 (A)
 DXV1                 47-  50
 DCCHPR1              51-  54
 NPR                  55-  56
 PR1                  57-  60 (A)
 PRV1                 61-  63
 PCCHPR1              64-  67
 DRG                  68-  70
 MDC                  71-  72
 DRGVER               73-  74
 DRG10                75-  77
 MDC10                78-  79
 PAY1                 80-  81
 TOTCHG               82-  91
 PROCESS              92- 102
 YEAR                103- 106
 DSHOSPID            107- 119 (A)
 DSNUM               120- 122
 DSTYPE              123- 125
 HOSPST              126- 127 (A)
 MDID_S              128- 143 (A)
 SURGID_S            144- 159 (A)
 ADAYWK              160- 162
 LOS_X               163- 167
 NEOMAT              168- 169
 DXSYS               170- 172
 DSNDX               173- 175
 PRSYS               176- 178
 DSNPR               179- 181
 PRDAY1              182- 186
 PAY1_N              187- 189
 PAY2                190- 191
 PAY2_N              192- 194
 TOTCHG_X            195- 206
 DX2                 207- 211 (A)
 DX3                 212- 216 (A)
 DX4                 217- 221 (A)
 DX5                 222- 226 (A)
 DX6                 227- 231 (A)
 DX7                 232- 236 (A)
 DX8                 237- 241 (A)
 DX9                 242- 246 (A)
 DX10                247- 251 (A)
 DX11                252- 256 (A)
 DX12                257- 261 (A)
 DX13                262- 266 (A)
 DX14                267- 271 (A)
 DX15                272- 276 (A)
 DX16                277- 281 (A)
 DXV2                282- 285
 DXV3                286- 289
 DXV4                290- 293
 DXV5                294- 297
 DXV6                298- 301
 DXV7                302- 305
 DXV8                306- 309
 DXV9                310- 313
 DXV10               314- 317
 DXV11               318- 321
 DXV12               322- 325
 DXV13               326- 329
 DXV14               330- 333
 DXV15               334- 337
 DXV16               338- 341
 DCCHPR2             342- 345
 DCCHPR3             346- 349
 DCCHPR4             350- 353
 DCCHPR5             354- 357
 DCCHPR6             358- 361
 DCCHPR7             362- 365
 DCCHPR8             366- 369
 DCCHPR9             370- 373
 DCCHPR10            374- 377
 DCCHPR11            378- 381
 DCCHPR12            382- 385
 DCCHPR13            386- 389
 DCCHPR14            390- 393
 DCCHPR15            394- 397
 DCCHPR16            398- 401
 PR2                 402- 405 (A)
 PR3                 406- 409 (A)
 PR4                 410- 413 (A)
 PR5                 414- 417 (A)
 PR6                 418- 421 (A)
 PR7                 422- 425 (A)
 PR8                 426- 429 (A)
 PR9                 430- 433 (A)
 PR10                434- 437 (A)
 PR11                438- 441 (A)
 PR12                442- 445 (A)
 PR13                446- 449 (A)
 PR14                450- 453 (A)
 PR15                454- 457 (A)
 PRV2                458- 460
 PRV3                461- 463
 PRV4                464- 466
 PRV5                467- 469
 PRV6                470- 472
 PRV7                473- 475
 PRV8                476- 478
 PRV9                479- 481
 PRV10               482- 484
 PRV11               485- 487
 PRV12               488- 490
 PRV13               491- 493
 PRV14               494- 496
 PRV15               497- 499
 PCCHPR2             500- 503
 PCCHPR3             504- 507
 PCCHPR4             508- 511
 PCCHPR5             512- 515
 PCCHPR6             516- 519
 PCCHPR7             520- 523
 PCCHPR8             524- 527
 PCCHPR9             528- 531
 PCCHPR10            532- 535
 PCCHPR11            536- 539
 PCCHPR12            540- 543
 PCCHPR13            544- 547
 PCCHPR14            548- 551
 PCCHPR15            552- 555
 PRDAY2              556- 560
 PRDAY3              561- 565
 PRDAY4              566- 570
 PRDAY5              571- 575
 PRDAY6              576- 580
 PRDAY7              581- 585
 PRDAY8              586- 590
 PRDAY9              591- 595
 PRDAY10             596- 600
 PRDAY11             601- 605
 PRDAY12             606- 610
 PRDAY13             611- 615
 PRDAY14             616- 620
 PRDAY15             621- 625
 MRN_S               626- 642 (A)
 BWT                 643- 646
 PAY1_X              647- 648 (A)
 PAY2_X              649- 650 (A).


***  Specify write formats  ***.
FORMATS
 SEQ_SID             (F7.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 SEX                 (F3.0) /
 RACE                (F3.0) /
 DQTR                (F3.0) /
 LOS                 (F4.0) /
 DISP                (F3.0) /
 DIED                (F3.0) /
 ATYPE               (F3.0) /
 ASOURCE             (F3.0) /
 NDX                 (F3.0) /
 DXV1                (F3.0) /
 DCCHPR1             (F3.0) /
 NPR                 (F3.0) /
 PRV1                (F3.0) /
 PCCHPR1             (F3.0) /
 DRG                 (F3.0) /
 MDC                 (F3.0) /
 DRGVER              (F3.0) /
 DRG10               (F3.0) /
 MDC10               (F3.0) /
 PAY1                (F3.0) /
 TOTCHG              (F6.0) /
 PROCESS             (F6.0) /
 YEAR                (F3.0) /
 DSNUM               (F3.0) /
 DSTYPE              (F3.0) /
 ADAYWK              (F3.0) /
 LOS_X               (F3.0) /
 NEOMAT              (F3.0) /
 DXSYS               (F3.0) /
 DSNDX               (F3.0) /
 PRSYS               (F3.0) /
 DSNPR               (F3.0) /
 PRDAY1              (F3.0) /
 PAY1_N              (F3.0) /
 PAY2                (F3.0) /
 PAY2_N              (F3.0) /
 TOTCHG_X            (F6.2) /
 DXV2                (F3.0) /
 DXV3                (F3.0) /
 DXV4                (F3.0) /
 DXV5                (F3.0) /
 DXV6                (F3.0) /
 DXV7                (F3.0) /
 DXV8                (F3.0) /
 DXV9                (F3.0) /
 DXV10               (F3.0) /
 DXV11               (F3.0) /
 DXV12               (F3.0) /
 DXV13               (F3.0) /
 DXV14               (F3.0) /
 DXV15               (F3.0) /
 DXV16               (F3.0) /
 DCCHPR2             (F3.0) /
 DCCHPR3             (F3.0) /
 DCCHPR4             (F3.0) /
 DCCHPR5             (F3.0) /
 DCCHPR6             (F3.0) /
 DCCHPR7             (F3.0) /
 DCCHPR8             (F3.0) /
 DCCHPR9             (F3.0) /
 DCCHPR10            (F3.0) /
 DCCHPR11            (F3.0) /
 DCCHPR12            (F3.0) /
 DCCHPR13            (F3.0) /
 DCCHPR14            (F3.0) /
 DCCHPR15            (F3.0) /
 DCCHPR16            (F3.0) /
 PRV2                (F3.0) /
 PRV3                (F3.0) /
 PRV4                (F3.0) /
 PRV5                (F3.0) /
 PRV6                (F3.0) /
 PRV7                (F3.0) /
 PRV8                (F3.0) /
 PRV9                (F3.0) /
 PRV10               (F3.0) /
 PRV11               (F3.0) /
 PRV12               (F3.0) /
 PRV13               (F3.0) /
 PRV14               (F3.0) /
 PRV15               (F3.0) /
 PCCHPR2             (F3.0) /
 PCCHPR3             (F3.0) /
 PCCHPR4             (F3.0) /
 PCCHPR5             (F3.0) /
 PCCHPR6             (F3.0) /
 PCCHPR7             (F3.0) /
 PCCHPR8             (F3.0) /
 PCCHPR9             (F3.0) /
 PCCHPR10            (F3.0) /
 PCCHPR11            (F3.0) /
 PCCHPR12            (F3.0) /
 PCCHPR13            (F3.0) /
 PCCHPR14            (F3.0) /
 PCCHPR15            (F3.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PRDAY7              (F4.0) /
 PRDAY8              (F4.0) /
 PRDAY9              (F4.0) /
 PRDAY10             (F4.0) /
 PRDAY11             (F4.0) /
 PRDAY12             (F4.0) /
 PRDAY13             (F4.0) /
 PRDAY14             (F4.0) /
 PRDAY15             (F4.0) /
 BWT                 (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 SEQ_SID   "I:HCUP-3 SID record sequence number"
 AGE       "I:Age in years at admission"
 AGEDAY    "I:Age in days (when < 1 year)"
 SEX       "I:Sex"
 RACE      "I:Race"
 DQTR      "I:Discharge quarter"
 LOS       "I:Length of stay (cleaned)"
 DISP      "I:Disposition of patient"
 DIED      "I:Died during hospitalization"
 ATYPE     "I:Admission type"
 ASOURCE   "I:Admission source"
 NDX       "I:Number of diagnoses on this discharge"
 DX1       "I:Principal diagnosis"
 DXV1      "I:Validity flag: principal diagnosis"
 DCCHPR1   "I:CCHPR: principal diagnosis"
 NPR       "I:Number of procedures on this discharge"
 PR1       "I:Principal procedure"
 PRV1      "I:Validity flag: principal procedure"
 PCCHPR1   "I:CCHPR: principal procedure"
 DRG       "I:DRG in effect on discharge date"
 MDC       "I:MDC in effect on discharge date"
 DRGVER    "I:DRG grouper version used on disch date"
 DRG10     "I:DRG, Version 10"
 MDC10     "I:MDC, Version 10"
 PAY1      "I:Primary expected payer, uniform"
 TOTCHG    "I:Total charges (cleaned)"
 PROCESS   "I:HCUP-3 discharge processing ID number"
 YEAR      "Calendar year"
 DSHOSPID  "I:Data source hospital ID number"
 DSNUM     "I:Data source ID number"
 DSTYPE    "I:Data source type"
 HOSPST    "Hospital state postal code"
 MDID_S    "I:Attending physician number (synthetic)"
 SURGID_S  "I:Primary surgeon number (synthetic)"
 ADAYWK    "I:Admission day of week"
 LOS_X     "I:Length of stay (uncleaned)"
 NEOMAT    "I:Neonatal and/or maternal DX and/or PR"
 DXSYS     "I:Diagnosis coding system"
 DSNDX     "I:Max number of diagnoses from source"
 PRSYS     "I:Procedure coding system"
 DSNPR     "I:Max number of procedures from source"
 PRDAY1    "I:No. of days from admission to PR1"
 PAY1_N    "I:Primary expected payer, nonuniform"
 PAY2      "I:Secondary expected payer, uniform"
 PAY2_N    "I:Secondary expected payer, nonuniform"
 TOTCHG_X  "I:Total charges (from data source)"
 DX2       "I:Diagnosis 2"
 DX3       "I:Diagnosis 3"
 DX4       "I:Diagnosis 4"
 DX5       "I:Diagnosis 5"
 DX6       "I:Diagnosis 6"
 DX7       "I:Diagnosis 7"
 DX8       "I:Diagnosis 8"
 DX9       "I:Diagnosis 9"
 DX10      "I:Diagnosis 10"
 DX11      "I:Diagnosis 11"
 DX12      "I:Diagnosis 12"
 DX13      "I:Diagnosis 13"
 DX14      "I:Diagnosis 14"
 DX15      "I:Diagnosis 15"
 DX16      "I:Diagnosis 16"
 DXV2      "I:Validity flag: diagnosis 2"
 DXV3      "I:Validity flag: diagnosis 3"
 DXV4      "I:Validity flag: diagnosis 4"
 DXV5      "I:Validity flag: diagnosis 5"
 DXV6      "I:Validity flag: diagnosis 6"
 DXV7      "I:Validity flag: diagnosis 7"
 DXV8      "I:Validity flag: diagnosis 8"
 DXV9      "I:Validity flag: diagnosis 9"
 DXV10     "I:Validity flag: diagnosis 10"
 DXV11     "I:Validity flag: diagnosis 11"
 DXV12     "I:Validity flag: diagnosis 12"
 DXV13     "I:Validity flag: diagnosis 13"
 DXV14     "I:Validity flag: diagnosis 14"
 DXV15     "I:Validity flag: diagnosis 15"
 DXV16     "I:Validity flag: diagnosis 16"
 DCCHPR2   "I:CCHPR: diagnosis 2"
 DCCHPR3   "I:CCHPR: diagnosis 3"
 DCCHPR4   "I:CCHPR: diagnosis 4"
 DCCHPR5   "I:CCHPR: diagnosis 5"
 DCCHPR6   "I:CCHPR: diagnosis 6"
 DCCHPR7   "I:CCHPR: diagnosis 7"
 DCCHPR8   "I:CCHPR: diagnosis 8"
 DCCHPR9   "I:CCHPR: diagnosis 9"
 DCCHPR10  "I:CCHPR: diagnosis 10"
 DCCHPR11  "I:CCHPR: diagnosis 11"
 DCCHPR12  "I:CCHPR: diagnosis 12"
 DCCHPR13  "I:CCHPR: diagnosis 13"
 DCCHPR14  "I:CCHPR: diagnosis 14"
 DCCHPR15  "I:CCHPR: diagnosis 15"
 DCCHPR16  "I:CCHPR: diagnosis 16"
 PR2       "I:Procedure 2"
 PR3       "I:Procedure 3"
 PR4       "I:Procedure 4"
 PR5       "I:Procedure 5"
 PR6       "I:Procedure 6"
 PR7       "I:Procedure 7"
 PR8       "I:Procedure 8"
 PR9       "I:Procedure 9"
 PR10      "I:Procedure 10"
 PR11      "I:Procedure 11"
 PR12      "I:Procedure 12"
 PR13      "I:Procedure 13"
 PR14      "I:Procedure 14"
 PR15      "I:Procedure 15"
 PRV2      "I:Validity flag: procedure 2"
 PRV3      "I:Validity flag: procedure 3"
 PRV4      "I:Validity flag: procedure 4"
 PRV5      "I:Validity flag: procedure 5"
 PRV6      "I:Validity flag: procedure 6"
 PRV7      "I:Validity flag: procedure 7"
 PRV8      "I:Validity flag: procedure 8"
 PRV9      "I:Validity flag: procedure 9"
 PRV10     "I:Validity flag: procedure 10"
 PRV11     "I:Validity flag: procedure 11"
 PRV12     "I:Validity flag: procedure 12"
 PRV13     "I:Validity flag: procedure 13"
 PRV14     "I:Validity flag: procedure 14"
 PRV15     "I:Validity flag: procedure 15"
 PCCHPR2   "I:CCHPR: procedure 2"
 PCCHPR3   "I:CCHPR: procedure 3"
 PCCHPR4   "I:CCHPR: procedure 4"
 PCCHPR5   "I:CCHPR: procedure 5"
 PCCHPR6   "I:CCHPR: procedure 6"
 PCCHPR7   "I:CCHPR: procedure 7"
 PCCHPR8   "I:CCHPR: procedure 8"
 PCCHPR9   "I:CCHPR: procedure 9"
 PCCHPR10  "I:CCHPR: procedure 10"
 PCCHPR11  "I:CCHPR: procedure 11"
 PCCHPR12  "I:CCHPR: procedure 12"
 PCCHPR13  "I:CCHPR: procedure 13"
 PCCHPR14  "I:CCHPR: procedure 14"
 PCCHPR15  "I:CCHPR: procedure 15"
 PRDAY2    "I:No. of days from admission to PR2"
 PRDAY3    "I:No. of days from admission to PR3"
 PRDAY4    "I:No. of days from admission to PR4"
 PRDAY5    "I:No. of days from admission to PR5"
 PRDAY6    "I:No. of days from admission to PR6"
 PRDAY7    "I:No. of days from admission to PR7"
 PRDAY8    "I:No. of days from admission to PR8"
 PRDAY9    "I:No. of days from admission to PR9"
 PRDAY10   "I:No. of days from admission to PR10"
 PRDAY11   "I:No. of days from admission to PR11"
 PRDAY12   "I:No. of days from admission to PR12"
 PRDAY13   "I:No. of days from admission to PR13"
 PRDAY14   "I:No. of days from admission to PR14"
 PRDAY15   "I:No. of days from admission to PR15"
 MRN_S     "I:Medical record number (synthetic)"
 BWT       "I:Birthweight in grams"
 PAY1_X    "I:Primary exp. payer (from data source)"
 PAY2_X    "I:Secondary exp. payer (from data source" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE SEX
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE DISP
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE DXV1
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PRV1
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE DSNUM
 (-99,-88,-66,-55=SYSMIS).
RECODE DSTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE ADAYWK
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS_X
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE DXSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNDX
 (-99,-88,-66,-55=SYSMIS).
RECODE PRSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNPR
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PAY1_N
 (-99,-88,-66,-55=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2_N
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG_X
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE DXV2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV16
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR11
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR12
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR13
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR14
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR15
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRV2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV15
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MD_SID_1994_CORE.SAV' /COMPRESSED.
