/*******************************************************************
*   MD_SID_2006_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MD_SID_2006_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEDAY                    18-  20
 AGEMONTH                  21-  23
 ASOURCE                   24-  25
 ASOURCE_X                 26-  27 (A)
 ATYPE                     28-  29
 AWEEKEND                  30-  31
 BWT                       32-  35
 DaysBurnUnit              36-  38
 DaysCCU                   39-  41
 DaysICU                   42-  44
 DaysNICU                  45-  47
 DaysPICU                  48-  50
 DaysShockUnit             51-  53
 DIED                      54-  55
 DISP_X                    56-  57 (A)
 DISPUNIFORM               58-  59
 DQTR                      60-  61
 DRG                       62-  64
 DRG18                     65-  67
 DRG24                     68-  70
 DRGVER                    71-  72
 DSHOSPID                  73-  89 (A)
 DX1                       90-  94 (A)
 DX2                       95-  99 (A)
 DX3                      100- 104 (A)
 DX4                      105- 109 (A)
 DX5                      110- 114 (A)
 DX6                      115- 119 (A)
 DX7                      120- 124 (A)
 DX8                      125- 129 (A)
 DX9                      130- 134 (A)
 DX10                     135- 139 (A)
 DX11                     140- 144 (A)
 DX12                     145- 149 (A)
 DX13                     150- 154 (A)
 DX14                     155- 159 (A)
 DX15                     160- 164 (A)
 DXCCS1                   165- 168
 DXCCS2                   169- 172
 DXCCS3                   173- 176
 DXCCS4                   177- 180
 DXCCS5                   181- 184
 DXCCS6                   185- 188
 DXCCS7                   189- 192
 DXCCS8                   193- 196
 DXCCS9                   197- 200
 DXCCS10                  201- 204
 DXCCS11                  205- 208
 DXCCS12                  209- 212
 DXCCS13                  213- 216
 DXCCS14                  217- 220
 DXCCS15                  221- 224
 ECODE1                   225- 229 (A)
 ECODE2                   230- 234 (A)
 ECODE3                   235- 239 (A)
 ECODE4                   240- 244 (A)
 ECODE5                   245- 249 (A)
 ECODE6                   250- 254 (A)
 ECODE7                   255- 259 (A)
 E_CCS1                   260- 263
 E_CCS2                   264- 267
 E_CCS3                   268- 271
 E_CCS4                   272- 275
 E_CCS5                   276- 279
 E_CCS6                   280- 283
 E_CCS7                   284- 287
 FEMALE                   288- 289
 HCUP_ED                  290- 291
 HCUP_OS                  292- 293
 HISPANIC_X               294     (A)
 HOSPBRTH                 295- 297
 HospitalUnit             298- 299
 HOSPST                   300- 301 (A)
 LOS                      302- 306
 LOS_X                    307- 312
 MARITALSTATUS            313     (A)
 MDC                      314- 315
 MDC18                    316- 317
 MDC24                    318- 319
 MDNUM1_R                 320- 328
 MDNUM2_R                 329- 337
 MEDINCSTQ                338- 339
 MRN_R                    340- 348
 NDX                      349- 350
 NECODE                   351- 352
 NEOMAT                   353- 354
 NPR                      355- 356
 PAY1                     357- 358
 PAY2                     359- 360
 PAY1_X                   361- 362 (A)
 PAY2_X                   363- 364 (A)
 PAYER1_X                 365- 366 (A)
 PAYER2_X                 367- 368 (A)
 PL_CBSA                  369- 371
 PL_MSA1993               372- 374
 PL_NHCS2006              375- 376
 PL_RUCA10_2005           377- 378
 PL_RUCA2005              379- 382
 PL_RUCA4_2005            383- 384
 PL_RUCC2003              385- 386
 PL_UIC2003               387- 388
 PL_UR_CAT4               389- 390
 PL_UR_CAT5               391- 392
 PR1                      393- 396 (A)
 PR2                      397- 400 (A)
 PR3                      401- 404 (A)
 PR4                      405- 408 (A)
 PR5                      409- 412 (A)
 PR6                      413- 416 (A)
 PR7                      417- 420 (A)
 PR8                      421- 424 (A)
 PR9                      425- 428 (A)
 PR10                     429- 432 (A)
 PR11                     433- 436 (A)
 PR12                     437- 440 (A)
 PR13                     441- 444 (A)
 PR14                     445- 448 (A)
 PR15                     449- 452 (A)
 PRCCS1                   453- 455
 PRCCS2                   456- 458
 PRCCS3                   459- 461
 PRCCS4                   462- 464
 PRCCS5                   465- 467
 PRCCS6                   468- 470
 PRCCS7                   471- 473
 PRCCS8                   474- 476
 PRCCS9                   477- 479
 PRCCS10                  480- 482
 PRCCS11                  483- 485
 PRCCS12                  486- 488
 PRCCS13                  489- 491
 PRCCS14                  492- 494
 PRCCS15                  495- 497
 PRDAY1                   498- 502
 PRDAY2                   503- 507
 PRDAY3                   508- 512
 PRDAY4                   513- 517
 PRDAY5                   518- 522
 PRDAY6                   523- 527
 PRDAY7                   528- 532
 PRDAY8                   533- 537
 PRDAY9                   538- 542
 PRDAY10                  543- 547
 PRDAY11                  548- 552
 PROCTYPE                 553- 555
 PSTATE                   556- 557 (A)
 PSTCO                    558- 562
 PSTCO2                   563- 567
 RACE                     568- 569
 RACE_X                   570     (A)
 TOTCHG                   571- 580
 TOTCHG_X                 581- 595
 YEAR                     596- 599
 ZIP3                     600- 602 (A)
 ZIPINC_QRTL              603- 605.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 DaysBurnUnit            (F3.0) /
 DaysCCU                 (F3.0) /
 DaysICU                 (F3.0) /
 DaysNICU                (F3.0) /
 DaysPICU                (F3.0) /
 DaysShockUnit           (F3.0) /
 DIED                    (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG18                   (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 HospitalUnit            (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC18                   (F3.0) /
 MDC24                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCSTQ               (F3.0) /
 MRN_R                   (F5.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NHCS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PL_UR_CAT5              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY                     "HCUP record identifier"
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 ASOURCE                 "Admission source (uniform)"
 ASOURCE_X               "Admission source (as received from source)"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BWT                     "Birth weight in grams"
 DaysBurnUnit            "Days in burn care unit (as received from source)"
 DaysCCU                 "Days in coronary care unit (as received from source)"
 DaysICU
"Days in medical/surgical intensive care unit (as received from source)"
 DaysNICU                "Days in neonetal care unit (as received from source)"
 DaysPICU                "Days in pediatric care unit (as received from source)"
 DaysShockUnit           "Days in shock trauma unit (as received from source)"
 DIED                    "Died during hospitalization"
 DISP_X                  "Disposition of patient (as received from source)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG18                   "DRG, version 18"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Principal diagnosis"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DXCCS1                  "CCS: principal diagnosis"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HospitalUnit

"Indicator that patient was discharged from a special unit within an acute care hospital (re
ported by source)"
 HOSPST                  "Hospital state postal code"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MARITALSTATUS           "Patient's marital status"
 MDC                     "MDC in effect on discharge date"
 MDC18                   "MDC, version 18"
 MDC24                   "MDC, version 24"
 MDNUM1_R                "Physician 1 number (re-identified)"
 MDNUM2_R                "Physician 2 number (re-identified)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MRN_R                   "Medical record number (re-identified)"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 PAY1                    "Primary expected payer (uniform)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAYER1_X                "Primary expected payer plan identifier (as received from source)"
 PAYER2_X
"Secondary expected payer plan identifier (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NHCS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CAT5              "Patient Location: Urban-Rural 5 Categories"
 PR1                     "Principal procedure"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PRCCS1                  "CCS: principal procedure"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysBurnUnit
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysCCU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysNICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysPICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysShockUnit
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NHCS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).



SAVE OUTFILE = 'MD_SID_2006_CORE.SAV' /COMPRESSED.
