/*******************************************************************
* Creation Date: 08/12/2025   
*   MD_SID_2024_CORE.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      SID CORE FILE INTO SPSS                                    
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'MD_SID_2024_CORE.asc' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 ATYPE                          10-  11
 AWEEKEND                       12-  13
 BWT                            14-  17
 DaysBurnUnit                   18-  20
 DaysCCU                        21-  23
 DaysICU                        24-  26
 DaysNICU                       27-  29
 DaysPICU                       30-  32
 DaysShockUnit                  33-  35
 DaysToEvent                    36-  41
 DIED                           42-  43
 DISP_X                         44-  45 (A)
 DISPUB04                       46-  47
 DISPUNIFORM                    48-  49
 DQTR                           50-  51
 DRG                            52-  54
 DRG_NoPOA                      55-  57
 DRGVER                         58-  59
 DSHOSPID                       60-  76 (A)
 DXPOA1                         77     (A)
 DXPOA2                         78     (A)
 DXPOA3                         79     (A)
 DXPOA4                         80     (A)
 DXPOA5                         81     (A)
 DXPOA6                         82     (A)
 DXPOA7                         83     (A)
 DXPOA8                         84     (A)
 DXPOA9                         85     (A)
 DXPOA10                        86     (A)
 DXPOA11                        87     (A)
 DXPOA12                        88     (A)
 DXPOA13                        89     (A)
 DXPOA14                        90     (A)
 DXPOA15                        91     (A)
 DXPOA16                        92     (A)
 DXPOA17                        93     (A)
 DXPOA18                        94     (A)
 DXPOA19                        95     (A)
 DXPOA20                        96     (A)
 DXPOA21                        97     (A)
 DXPOA22                        98     (A)
 DXPOA23                        99     (A)
 DXPOA24                       100     (A)
 DXPOA25                       101     (A)
 DXPOA26                       102     (A)
 DXPOA27                       103     (A)
 DXPOA28                       104     (A)
 DXPOA29                       105     (A)
 DXPOA30                       106     (A)
 DXPOA31                       107     (A)
 DXPOA32                       108     (A)
 DXPOA33                       109     (A)
 DXPOA34                       110     (A)
 DXPOA35                       111     (A)
 DXPOA36                       112     (A)
 DXPOA37                       113     (A)
 DXPOA38                       114     (A)
 DXPOA39                       115     (A)
 DXPOA40                       116     (A)
 DXPOA41                       117     (A)
 DXPOA42                       118     (A)
 DXPOA43                       119     (A)
 DXPOA44                       120     (A)
 DXPOA45                       121     (A)
 DXPOA46                       122     (A)
 DXPOA47                       123     (A)
 DXPOA48                       124     (A)
 DXPOA49                       125     (A)
 DXPOA50                       126     (A)
 DXPOA51                       127     (A)
 DXPOA52                       128     (A)
 DXPOA53                       129     (A)
 DXPOA54                       130     (A)
 DXPOA55                       131     (A)
 DXPOA56                       132     (A)
 DXPOA57                       133     (A)
 DXPOA58                       134     (A)
 DXPOA59                       135     (A)
 DXPOA60                       136     (A)
 DXPOA61                       137     (A)
 DXPOA62                       138     (A)
 DXPOA63                       139     (A)
 DXPOA64                       140     (A)
 DXPOA65                       141     (A)
 DXPOA66                       142     (A)
 DXPOA67                       143     (A)
 DXPOA68                       144     (A)
 DXPOA69                       145     (A)
 DXPOA70                       146     (A)
 DXPOA71                       147     (A)
 DXPOA72                       148     (A)
 DXPOA73                       149     (A)
 DXPOA74                       150     (A)
 DXPOA75                       151     (A)
 DXPOA76                       152     (A)
 DXPOA77                       153     (A)
 DXPOA78                       154     (A)
 DXPOA79                       155     (A)
 DXPOA80                       156     (A)
 DXPOA81                       157     (A)
 DXPOA82                       158     (A)
 DXPOA83                       159     (A)
 DXPOA84                       160     (A)
 FEMALE                        161- 162
 HCUP_ED                       163- 164
 HCUP_OS                       165- 166
 HISPANIC                      167- 168
 HISPANIC_X                    169     (A)
 Homeless                      170- 171
 HospitalUnit                  172- 173
 HOSPST                        174- 175 (A)
 I10_BIRTH                     176- 178
 I10_DELIVERY                  179- 181
 I10_DX1                       182- 188 (A)
 I10_DX2                       189- 195 (A)
 I10_DX3                       196- 202 (A)
 I10_DX4                       203- 209 (A)
 I10_DX5                       210- 216 (A)
 I10_DX6                       217- 223 (A)
 I10_DX7                       224- 230 (A)
 I10_DX8                       231- 237 (A)
 I10_DX9                       238- 244 (A)
 I10_DX10                      245- 251 (A)
 I10_DX11                      252- 258 (A)
 I10_DX12                      259- 265 (A)
 I10_DX13                      266- 272 (A)
 I10_DX14                      273- 279 (A)
 I10_DX15                      280- 286 (A)
 I10_DX16                      287- 293 (A)
 I10_DX17                      294- 300 (A)
 I10_DX18                      301- 307 (A)
 I10_DX19                      308- 314 (A)
 I10_DX20                      315- 321 (A)
 I10_DX21                      322- 328 (A)
 I10_DX22                      329- 335 (A)
 I10_DX23                      336- 342 (A)
 I10_DX24                      343- 349 (A)
 I10_DX25                      350- 356 (A)
 I10_DX26                      357- 363 (A)
 I10_DX27                      364- 370 (A)
 I10_DX28                      371- 377 (A)
 I10_DX29                      378- 384 (A)
 I10_DX30                      385- 391 (A)
 I10_DX31                      392- 398 (A)
 I10_DX32                      399- 405 (A)
 I10_DX33                      406- 412 (A)
 I10_DX34                      413- 419 (A)
 I10_DX35                      420- 426 (A)
 I10_DX36                      427- 433 (A)
 I10_DX37                      434- 440 (A)
 I10_DX38                      441- 447 (A)
 I10_DX39                      448- 454 (A)
 I10_DX40                      455- 461 (A)
 I10_DX41                      462- 468 (A)
 I10_DX42                      469- 475 (A)
 I10_DX43                      476- 482 (A)
 I10_DX44                      483- 489 (A)
 I10_DX45                      490- 496 (A)
 I10_DX46                      497- 503 (A)
 I10_DX47                      504- 510 (A)
 I10_DX48                      511- 517 (A)
 I10_DX49                      518- 524 (A)
 I10_DX50                      525- 531 (A)
 I10_DX51                      532- 538 (A)
 I10_DX52                      539- 545 (A)
 I10_DX53                      546- 552 (A)
 I10_DX54                      553- 559 (A)
 I10_DX55                      560- 566 (A)
 I10_DX56                      567- 573 (A)
 I10_DX57                      574- 580 (A)
 I10_DX58                      581- 587 (A)
 I10_DX59                      588- 594 (A)
 I10_DX60                      595- 601 (A)
 I10_DX61                      602- 608 (A)
 I10_DX62                      609- 615 (A)
 I10_DX63                      616- 622 (A)
 I10_DX64                      623- 629 (A)
 I10_DX65                      630- 636 (A)
 I10_DX66                      637- 643 (A)
 I10_DX67                      644- 650 (A)
 I10_DX68                      651- 657 (A)
 I10_DX69                      658- 664 (A)
 I10_DX70                      665- 671 (A)
 I10_DX71                      672- 678 (A)
 I10_DX72                      679- 685 (A)
 I10_DX73                      686- 692 (A)
 I10_DX74                      693- 699 (A)
 I10_DX75                      700- 706 (A)
 I10_DX76                      707- 713 (A)
 I10_DX77                      714- 720 (A)
 I10_DX78                      721- 727 (A)
 I10_DX79                      728- 734 (A)
 I10_DX80                      735- 741 (A)
 I10_DX81                      742- 748 (A)
 I10_DX82                      749- 755 (A)
 I10_DX83                      756- 762 (A)
 I10_DX84                      763- 769 (A)
 I10_NDX                       770- 772
 I10_NPR                       773- 775
 I10_PR1                       776- 782 (A)
 I10_PR2                       783- 789 (A)
 I10_PR3                       790- 796 (A)
 I10_PR4                       797- 803 (A)
 I10_PR5                       804- 810 (A)
 I10_PR6                       811- 817 (A)
 I10_PR7                       818- 824 (A)
 I10_PR8                       825- 831 (A)
 I10_PR9                       832- 838 (A)
 I10_PR10                      839- 845 (A)
 I10_PR11                      846- 852 (A)
 I10_PR12                      853- 859 (A)
 I10_PR13                      860- 866 (A)
 I10_PR14                      867- 873 (A)
 I10_PR15                      874- 880 (A)
 I10_PR16                      881- 887 (A)
 I10_PR17                      888- 894 (A)
 I10_PR18                      895- 901 (A)
 I10_PR19                      902- 908 (A)
 I10_PR20                      909- 915 (A)
 I10_PR21                      916- 922 (A)
 I10_PR22                      923- 929 (A)
 I10_PR23                      930- 936 (A)
 I10_PR24                      937- 943 (A)
 I10_PR25                      944- 950 (A)
 I10_PR26                      951- 957 (A)
 I10_PR27                      958- 964 (A)
 I10_PR28                      965- 971 (A)
 I10_PR29                      972- 978 (A)
 I10_PR30                      979- 985 (A)
 I10_PR31                      986- 992 (A)
 I10_PR32                      993- 999 (A)
 I10_PR33                     1000-1006 (A)
 I10_PR34                     1007-1013 (A)
 I10_PR35                     1014-1020 (A)
 I10_PR36                     1021-1027 (A)
 I10_PR37                     1028-1034 (A)
 I10_PR38                     1035-1041 (A)
 I10_PR39                     1042-1048 (A)
 I10_PR40                     1049-1055 (A)
 I10_PR41                     1056-1062 (A)
 I10_PR42                     1063-1069 (A)
 I10_PR43                     1070-1076 (A)
 I10_PR44                     1077-1083 (A)
 I10_PR45                     1084-1090 (A)
 I10_PR46                     1091-1097 (A)
 I10_PR47                     1098-1104 (A)
 I10_PR48                     1105-1111 (A)
 I10_PR49                     1112-1118 (A)
 I10_PR50                     1119-1125 (A)
 I10_PR51                     1126-1132 (A)
 I10_PR52                     1133-1139 (A)
 I10_PR53                     1140-1146 (A)
 I10_PR54                     1147-1153 (A)
 I10_PR55                     1154-1160 (A)
 I10_PR56                     1161-1167 (A)
 I10_PR57                     1168-1174 (A)
 I10_PR58                     1175-1181 (A)
 I10_PR59                     1182-1188 (A)
 I10_PR60                     1189-1195 (A)
 I10_PR61                     1196-1202 (A)
 I10_PR62                     1203-1209 (A)
 I10_PR63                     1210-1216 (A)
 I10_PR64                     1217-1223 (A)
 I10_PR65                     1224-1230 (A)
 I10_PR66                     1231-1237 (A)
 I10_PR67                     1238-1244 (A)
 I10_PR68                     1245-1251 (A)
 I10_PR69                     1252-1258 (A)
 I10_PR70                     1259-1265 (A)
 I10_PR71                     1266-1272 (A)
 I10_PR72                     1273-1279 (A)
 I10_PR73                     1280-1286 (A)
 I10_PR74                     1287-1293 (A)
 I10_PROCTYPE                 1294-1296
 I10_SERVICELINE              1297-1298
 KEY                          1299-1313
 LOS                          1314-1318
 LOS_X                        1319-1324
 MARITALSTATUS_X              1325     (A)
 MARITALSTATUSUB04            1326     (A)
 MDC                          1327-1328
 MDC_NoPOA                    1329-1330
 MDNUM1_R                     1331-1339
 MDNUM2_R                     1340-1348
 MEDINCSTQ                    1349-1350
 MRN_R                        1351-1359
 OS_TIME                      1360-1370
 P7EDSRC_X                    1371-1372 (A)
 PAY1                         1373-1374
 PAY1_X                       1375-1376 (A)
 PAY2                         1377-1378
 PAY2_X                       1379-1380 (A)
 PAY3                         1381-1382
 PAY3_X                       1383-1384 (A)
 PAYER1_X                     1385-1387 (A)
 PAYER2_X                     1388-1390 (A)
 PAYER3_X                     1391-1393 (A)
 PCLASS_ORPROC                1394-1395
 PL_CBSA                      1396-1398
 PL_NCHS                      1399-1400
 PL_RUCC                      1401-1402
 PL_UIC2023                   1403-1404
 PL_UR_CAT4                   1405-1406
 POA_Disch_Edit1              1407-1408
 POA_Disch_Edit2              1409-1410
 POA_Hosp_Edit1               1411-1412
 POA_Hosp_Edit2               1413-1414
 POA_Hosp_Edit3               1415-1416
 POA_Hosp_Edit3_Value         1417-1424
 PointOfOrigin_X              1425-1426 (A)
 PointOfOriginUB04            1427     (A)
 PRDAY1                       1428-1432
 PRDAY2                       1433-1437
 PRDAY3                       1438-1442
 PRDAY4                       1443-1447
 PRDAY5                       1448-1452
 PRDAY6                       1453-1457
 PRDAY7                       1458-1462
 PRDAY8                       1463-1467
 PRDAY9                       1468-1472
 PRDAY10                      1473-1477
 PRDAY11                      1478-1482
 PRDAY12                      1483-1487
 PRDAY13                      1488-1492
 PRDAY14                      1493-1497
 PRDAY15                      1498-1502
 PRDAY16                      1503-1507
 PRDAY17                      1508-1512
 PRDAY18                      1513-1517
 PRDAY19                      1518-1522
 PRDAY20                      1523-1527
 PRDAY21                      1528-1532
 PRDAY22                      1533-1537
 PRDAY23                      1538-1542
 PRDAY24                      1543-1547
 PRDAY25                      1548-1552
 PRDAY26                      1553-1557
 PRDAY27                      1558-1562
 PRDAY28                      1563-1567
 PRDAY29                      1568-1572
 PRDAY30                      1573-1577
 PRDAY31                      1578-1582
 PRDAY32                      1583-1587
 PRDAY33                      1588-1592
 PRDAY34                      1593-1597
 PRDAY35                      1598-1602
 PRDAY36                      1603-1607
 PRDAY37                      1608-1612
 PRDAY38                      1613-1617
 PRDAY39                      1618-1622
 PRDAY40                      1623-1627
 PRDAY41                      1628-1632
 PRDAY42                      1633-1637
 PRDAY43                      1638-1642
 PRDAY44                      1643-1647
 PRDAY45                      1648-1652
 PRDAY46                      1653-1657
 PRDAY47                      1658-1662
 PRDAY48                      1663-1667
 PRDAY49                      1668-1672
 PRDAY50                      1673-1677
 PRDAY51                      1678-1682
 PRDAY52                      1683-1687
 PRDAY53                      1688-1692
 PRDAY54                      1693-1697
 PRDAY55                      1698-1702
 PRDAY56                      1703-1707
 PRDAY57                      1708-1712
 PRDAY58                      1713-1717
 PRDAY59                      1718-1722
 PRDAY60                      1723-1727
 PRDAY61                      1728-1732
 PRDAY62                      1733-1737
 PRDAY63                      1738-1742
 PRDAY64                      1743-1747
 PRDAY65                      1748-1752
 PRDAY66                      1753-1757
 PRDAY67                      1758-1762
 PRDAY68                      1763-1767
 PRDAY69                      1768-1772
 PRDAY70                      1773-1777
 PRDAY71                      1778-1782
 PRDAY72                      1783-1787
 PRDAY73                      1788-1792
 PRDAY74                      1793-1797
 PrimLang                     1798-1800 (A)
 PSTATE                       1801-1802 (A)
 PSTATE_GEO                   1803-1804 (A)
 PSTCO                        1805-1809
 PSTCO_GEO                    1810-1814
 RACE                         1815-1816
 RACE_PCT_MISS_HOSP           1817-1823
 RACE_X                       1824     (A)
 READMIT                      1825-1826
 TOTCHG                       1827-1836
 TOTCHG_X                     1837-1851
 TRAN_IN                      1852-1853
 TRAN_OUT                     1854-1855
 VisitLink                    1856-1864
 YEAR                         1865-1868
 ZIP                          1869-1873 (A)
 ZIP3                         1874-1876 (A)
 ZIPINC_QRTL                  1877-1879
 AYEAR                        1880-1883.


/***  Specify write formats  ***/
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DaysBurnUnit                 (F3.0) /
 DaysCCU                      (F3.0) /
 DaysICU                      (F3.0) /
 DaysNICU                     (F3.0) /
 DaysPICU                     (F3.0) /
 DaysShockUnit                (F3.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 Homeless                     (F3.0) /
 HospitalUnit                 (F3.0) /
 I10_BIRTH                    (F3.0) /
 I10_DELIVERY                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PCLASS_ORPROC                (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC2023                   (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRDAY31                      (F4.0) /
 PRDAY32                      (F4.0) /
 PRDAY33                      (F4.0) /
 PRDAY34                      (F4.0) /
 PRDAY35                      (F4.0) /
 PRDAY36                      (F4.0) /
 PRDAY37                      (F4.0) /
 PRDAY38                      (F4.0) /
 PRDAY39                      (F4.0) /
 PRDAY40                      (F4.0) /
 PRDAY41                      (F4.0) /
 PRDAY42                      (F4.0) /
 PRDAY43                      (F4.0) /
 PRDAY44                      (F4.0) /
 PRDAY45                      (F4.0) /
 PRDAY46                      (F4.0) /
 PRDAY47                      (F4.0) /
 PRDAY48                      (F4.0) /
 PRDAY49                      (F4.0) /
 PRDAY50                      (F4.0) /
 PRDAY51                      (F4.0) /
 PRDAY52                      (F4.0) /
 PRDAY53                      (F4.0) /
 PRDAY54                      (F4.0) /
 PRDAY55                      (F4.0) /
 PRDAY56                      (F4.0) /
 PRDAY57                      (F4.0) /
 PRDAY58                      (F4.0) /
 PRDAY59                      (F4.0) /
 PRDAY60                      (F4.0) /
 PRDAY61                      (F4.0) /
 PRDAY62                      (F4.0) /
 PRDAY63                      (F4.0) /
 PRDAY64                      (F4.0) /
 PRDAY65                      (F4.0) /
 PRDAY66                      (F4.0) /
 PRDAY67                      (F4.0) /
 PRDAY68                      (F4.0) /
 PRDAY69                      (F4.0) /
 PRDAY70                      (F4.0) /
 PRDAY71                      (F4.0) /
 PRDAY72                      (F4.0) /
 PRDAY73                      (F4.0) /
 PRDAY74                      (F4.0) /
 PSTCO                        (F4.0) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 RACE_PCT_MISS_HOSP           (F4.2) /
 READMIT                      (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) .


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 DaysBurnUnit                 "Days in burn care unit (as received from source)"
 DaysCCU                      "Days in coronary care unit (as received from source)"
 DaysICU                      "Days in medical/surgical intensive care unit (as received from source)"
 DaysNICU                     "Days in neonetal care unit (as received from source)"
 DaysPICU                     "Days in pediatric care unit (as received from source)"
 DaysShockUnit                "Days in shock trauma unit (as received from source"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXPOA61                      "Diagnosis 61, present on admission indicator"
 DXPOA62                      "Diagnosis 62, present on admission indicator"
 DXPOA63                      "Diagnosis 63, present on admission indicator"
 DXPOA64                      "Diagnosis 64, present on admission indicator"
 DXPOA65                      "Diagnosis 65, present on admission indicator"
 DXPOA66                      "Diagnosis 66, present on admission indicator"
 DXPOA67                      "Diagnosis 67, present on admission indicator"
 DXPOA68                      "Diagnosis 68, present on admission indicator"
 DXPOA69                      "Diagnosis 69, present on admission indicator"
 DXPOA70                      "Diagnosis 70, present on admission indicator"
 DXPOA71                      "Diagnosis 71, present on admission indicator"
 DXPOA72                      "Diagnosis 72, present on admission indicator"
 DXPOA73                      "Diagnosis 73, present on admission indicator"
 DXPOA74                      "Diagnosis 74, present on admission indicator"
 DXPOA75                      "Diagnosis 75, present on admission indicator"
 DXPOA76                      "Diagnosis 76, present on admission indicator"
 DXPOA77                      "Diagnosis 77, present on admission indicator"
 DXPOA78                      "Diagnosis 78, present on admission indicator"
 DXPOA79                      "Diagnosis 79, present on admission indicator"
 DXPOA80                      "Diagnosis 80, present on admission indicator"
 DXPOA81                      "Diagnosis 81, present on admission indicator"
 DXPOA82                      "Diagnosis 82, present on admission indicator"
 DXPOA83                      "Diagnosis 83, present on admission indicator"
 DXPOA84                      "Diagnosis 84, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 Homeless                     "Indicator that patient is homeless"
 HospitalUnit
"Patient was discharged from a special unit within an acute care hospital (reported by source)"
 HOSPST                       "Hospital state postal code"
 I10_BIRTH                    "ICD-10-CM Birth Indicator"
 I10_DELIVERY                 "ICD-10-CM Delivery Indicator"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_DX61                     "ICD-10-CM Diagnosis 61"
 I10_DX62                     "ICD-10-CM Diagnosis 62"
 I10_DX63                     "ICD-10-CM Diagnosis 63"
 I10_DX64                     "ICD-10-CM Diagnosis 64"
 I10_DX65                     "ICD-10-CM Diagnosis 65"
 I10_DX66                     "ICD-10-CM Diagnosis 66"
 I10_DX67                     "ICD-10-CM Diagnosis 67"
 I10_DX68                     "ICD-10-CM Diagnosis 68"
 I10_DX69                     "ICD-10-CM Diagnosis 69"
 I10_DX70                     "ICD-10-CM Diagnosis 70"
 I10_DX71                     "ICD-10-CM Diagnosis 71"
 I10_DX72                     "ICD-10-CM Diagnosis 72"
 I10_DX73                     "ICD-10-CM Diagnosis 73"
 I10_DX74                     "ICD-10-CM Diagnosis 74"
 I10_DX75                     "ICD-10-CM Diagnosis 75"
 I10_DX76                     "ICD-10-CM Diagnosis 76"
 I10_DX77                     "ICD-10-CM Diagnosis 77"
 I10_DX78                     "ICD-10-CM Diagnosis 78"
 I10_DX79                     "ICD-10-CM Diagnosis 79"
 I10_DX80                     "ICD-10-CM Diagnosis 80"
 I10_DX81                     "ICD-10-CM Diagnosis 81"
 I10_DX82                     "ICD-10-CM Diagnosis 82"
 I10_DX83                     "ICD-10-CM Diagnosis 83"
 I10_DX84                     "ICD-10-CM Diagnosis 84"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PR51                     "ICD-10-PCS Procedure 51"
 I10_PR52                     "ICD-10-PCS Procedure 52"
 I10_PR53                     "ICD-10-PCS Procedure 53"
 I10_PR54                     "ICD-10-PCS Procedure 54"
 I10_PR55                     "ICD-10-PCS Procedure 55"
 I10_PR56                     "ICD-10-PCS Procedure 56"
 I10_PR57                     "ICD-10-PCS Procedure 57"
 I10_PR58                     "ICD-10-PCS Procedure 58"
 I10_PR59                     "ICD-10-PCS Procedure 59"
 I10_PR60                     "ICD-10-PCS Procedure 60"
 I10_PR61                     "ICD-10-PCS Procedure 61"
 I10_PR62                     "ICD-10-PCS Procedure 62"
 I10_PR63                     "ICD-10-PCS Procedure 63"
 I10_PR64                     "ICD-10-PCS Procedure 64"
 I10_PR65                     "ICD-10-PCS Procedure 65"
 I10_PR66                     "ICD-10-PCS Procedure 66"
 I10_PR67                     "ICD-10-PCS Procedure 67"
 I10_PR68                     "ICD-10-PCS Procedure 68"
 I10_PR69                     "ICD-10-PCS Procedure 69"
 I10_PR70                     "ICD-10-PCS Procedure 70"
 I10_PR71                     "ICD-10-PCS Procedure 71"
 I10_PR72                     "ICD-10-PCS Procedure 72"
 I10_PR73                     "ICD-10-PCS Procedure 73"
 I10_PR74                     "ICD-10-PCS Procedure 74"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUS_X              "Patient's marital status (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 OS_TIME                      "Observation stay time summed from UNITS"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PAYER1_X                     "Primary expected payer plan identifier (as received from source)"
 PAYER2_X                     "Secondary expected payer plan identifier (as received from source)"
 PAYER3_X                     "Tertiary expected payer plan identifier (as received from source)"
 PCLASS_ORPROC                "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC2023                   "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRDAY31                      "Number of days from admission to I10_PR31"
 PRDAY32                      "Number of days from admission to I10_PR32"
 PRDAY33                      "Number of days from admission to I10_PR33"
 PRDAY34                      "Number of days from admission to I10_PR34"
 PRDAY35                      "Number of days from admission to I10_PR35"
 PRDAY36                      "Number of days from admission to I10_PR36"
 PRDAY37                      "Number of days from admission to I10_PR37"
 PRDAY38                      "Number of days from admission to I10_PR38"
 PRDAY39                      "Number of days from admission to I10_PR39"
 PRDAY40                      "Number of days from admission to I10_PR40"
 PRDAY41                      "Number of days from admission to I10_PR41"
 PRDAY42                      "Number of days from admission to I10_PR42"
 PRDAY43                      "Number of days from admission to I10_PR43"
 PRDAY44                      "Number of days from admission to I10_PR44"
 PRDAY45                      "Number of days from admission to I10_PR45"
 PRDAY46                      "Number of days from admission to I10_PR46"
 PRDAY47                      "Number of days from admission to I10_PR47"
 PRDAY48                      "Number of days from admission to I10_PR48"
 PRDAY49                      "Number of days from admission to I10_PR49"
 PRDAY50                      "Number of days from admission to I10_PR50"
 PRDAY51                      "Number of days from admission to I10_PR51"
 PRDAY52                      "Number of days from admission to I10_PR52"
 PRDAY53                      "Number of days from admission to I10_PR53"
 PRDAY54                      "Number of days from admission to I10_PR54"
 PRDAY55                      "Number of days from admission to I10_PR55"
 PRDAY56                      "Number of days from admission to I10_PR56"
 PRDAY57                      "Number of days from admission to I10_PR57"
 PRDAY58                      "Number of days from admission to I10_PR58"
 PRDAY59                      "Number of days from admission to I10_PR59"
 PRDAY60                      "Number of days from admission to I10_PR60"
 PRDAY61                      "Number of days from admission to I10_PR61"
 PRDAY62                      "Number of days from admission to I10_PR62"
 PRDAY63                      "Number of days from admission to I10_PR63"
 PRDAY64                      "Number of days from admission to I10_PR64"
 PRDAY65                      "Number of days from admission to I10_PR65"
 PRDAY66                      "Number of days from admission to I10_PR66"
 PRDAY67                      "Number of days from admission to I10_PR67"
 PRDAY68                      "Number of days from admission to I10_PR68"
 PRDAY69                      "Number of days from admission to I10_PR69"
 PRDAY70                      "Number of days from admission to I10_PR70"
 PRDAY71                      "Number of days from admission to I10_PR71"
 PRDAY72                      "Number of days from admission to I10_PR72"
 PRDAY73                      "Number of days from admission to I10_PR73"
 PRDAY74                      "Number of days from admission to I10_PR74"
 PrimLang                     "Primary language of patient"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 RACE                         "Race (uniform)"
 RACE_PCT_MISS_HOSP           "Hospital percentage of missing or invalid race values"
 RACE_X                       "Race (as received from source)"
 READMIT                      "Readmission"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysBurnUnit
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysCCU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysNICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysPICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysShockUnit
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BIRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_DELIVERY
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2023
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY51
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY52
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY53
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY54
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY55
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY56
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY57
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY58
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY59
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY60
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY61
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY62
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY63
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY64
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY65
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY66
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY67
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY68
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY69
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY70
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY71
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY72
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY73
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY74
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_PCT_MISS_HOSP
 (-999.99,-888.88,-666.66,-555.55=SYSMIS).
RECODE READMIT
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MD_SID_2024_CORE.sav' /COMPRESSED.
