/*******************************************************************
*   ME_SID_2006_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'ME_SID_2006_CORE.ASC' FIXED / 
 KEY                        1-  14
 ADRG                      15-  17
 AHOUR                     18-  21
 AMDC                      22-  23
 AMONTH                    24-  25
 ASOURCE                   26-  27
 ATYPE                     28-  29
 AWEEKEND                  30-  31
 DHOUR                     32-  35
 DIED                      36-  37
 DISPUNIF                  38-  39
 DQTR                      40-  41
 DRG                       42-  44
 DRG18                     45-  47
 DRG24                     48-  50
 DRGVER                    51-  52
 DX1                       53-  57 (A)
 DX2                       58-  62 (A)
 DX3                       63-  67 (A)
 DX4                       68-  72 (A)
 DX5                       73-  77 (A)
 DX6                       78-  82 (A)
 DX7                       83-  87 (A)
 DX8                       88-  92 (A)
 DX9                       93-  97 (A)
 DX10                      98- 102 (A)
 DXCCS1                   103- 106
 DXCCS2                   107- 110
 DXCCS3                   111- 114
 DXCCS4                   115- 118
 DXCCS5                   119- 122
 DXCCS6                   123- 126
 DXCCS7                   127- 130
 DXCCS8                   131- 134
 DXCCS9                   135- 138
 DXCCS10                  139- 142
 ECODE1                   143- 147 (A)
 ECODE2                   148- 152 (A)
 ECODE3                   153- 157 (A)
 ECODE4                   158- 162 (A)
 ECODE5                   163- 167 (A)
 E_CCS1                   168- 171
 E_CCS2                   172- 175
 E_CCS3                   176- 179
 E_CCS4                   180- 183
 E_CCS5                   184- 187
 FEMALE                   188- 189
 HCUP_ED                  190- 191
 HCUP_OS                  192- 193
 HOSPBRTH                 194- 196
 HOSPST                   197- 198 (A)
 LOS                      199- 203
 MDC                      204- 205
 MDC18                    206- 207
 MDC24                    208- 209
 MDSPEC1                  210- 211 (A)
 MDSPEC2                  212- 213 (A)
 MEDINCST                 214- 215
 MRN_R                    216- 224
 NDX                      225- 226
 NECODE                   227- 228
 NEOMAT                   229- 230
 NPR                      231- 232
 PAY1                     233- 234
 PAY2                     235- 236
 PL_CBSA                  237- 239
 PL_MSA19                 240- 242
 PL_NHCS2                 243- 244
 PL_RUCA4                 245- 246
 PL_UIC20                 247- 248
 PL_UR_CA                 249- 250
 PL_UR_CA                 251- 252
 PR1                      253- 256 (A)
 PR2                      257- 260 (A)
 PR3                      261- 264 (A)
 PR4                      265- 268 (A)
 PR5                      269- 272 (A)
 PR6                      273- 276 (A)
 PRCCS1                   277- 279
 PRCCS2                   280- 282
 PRCCS3                   283- 285
 PRCCS4                   286- 288
 PRCCS5                   289- 291
 PRCCS6                   292- 294
 PRDAY1                   295- 299
 PRDAY2                   300- 304
 PRDAY3                   305- 309
 PRDAY4                   310- 314
 PRDAY5                   315- 319
 PRDAY6                   320- 324
 PROCTYPE                 325- 327
 PSTATE                   328- 329 (A)
 PSTCO                    330- 334
 PSTCO2                   335- 339
 YEAR                     340- 343
 ZIP3                     344- 346 (A)
 ZIPINC_Q                 347- 349
 ZIP_S                    350- 354 (A)
 AGEGROUP                 355- 357
 HOSPID                   358- 362
 AYEAR                    363- 366
 DMONTH                   367- 368
 PRMNTH1                  369- 370
 PRMNTH2                  371- 372
 PRMNTH3                  373- 374
 PRMNTH4                  375- 376
 PRMNTH5                  377- 378
 PRMNTH6                  379- 380
 PRYEAR1                  381- 384
 PRYEAR2                  385- 388
 PRYEAR3                  389- 392
 PRYEAR4                  393- 396
 PRYEAR5                  397- 400
 PRYEAR6                  401- 404.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 ADRG                    (F3.0) /
 AHOUR                   (F3.0) /
 AMDC                    (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG18                   (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 LOS                     (F4.0) /
 MDC                     (F3.0) /
 MDC18                   (F3.0) /
 MDC24                   (F3.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NHCS2                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AGEGROUP                (F8.0) /
 HOSPID                  (F4.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 ADRG      "All Patient Refined DRG"
 AHOUR     "Admission Hour"
 AMDC      "All Patient Refined MDC"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 DHOUR     "Discharge Hour"
 DIED      "Died during hospitalization"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRG24     "DRG, version 24"
 DRGVER    "DRG grouper version used on discharge date"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 MDC24     "MDC, version 24"
 MDSPEC1   "Physician 1 specialty (as received from source)"
 MDSPEC2   "Physician 2 specialty (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NHCS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP_S     "Patient ZIP Code (synthetic)"
 AGEGROUP  " "
 HOSPID    "HCUP hospital identification number"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE ADRG
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMDC
 (-9,-8,-6,-5=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NHCS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'ME_SID_2006_CORE.SAV' /COMPRESSED.
