/*******************************************************************
*   ME_SID_2007_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'ME_SID_2007_CHGS.ASC' FIXED / 
 KEY                        1-  14
 NREVCD                    15-  16
 REVCD1                    17-  20 (A)
 REVCD2                    21-  24 (A)
 REVCD3                    25-  28 (A)
 REVCD4                    29-  32 (A)
 REVCD5                    33-  36 (A)
 REVCD6                    37-  40 (A)
 REVCD7                    41-  44 (A)
 REVCD8                    45-  48 (A)
 REVCD9                    49-  52 (A)
 REVCD10                   53-  56 (A)
 REVCD11                   57-  60 (A)
 REVCD12                   61-  64 (A)
 REVCD13                   65-  68 (A)
 REVCD14                   69-  72 (A)
 REVCD15                   73-  76 (A)
 REVCD16                   77-  80 (A)
 REVCD17                   81-  84 (A)
 REVCD18                   85-  88 (A)
 REVCD19                   89-  92 (A)
 REVCD20                   93-  96 (A)
 REVCD21                   97- 100 (A)
 REVCD22                  101- 104 (A)
 REVCD23                  105- 108 (A)
 REVCD24                  109- 112 (A)
 REVCD25                  113- 116 (A)
 REVCD26                  117- 120 (A)
 REVCD27                  121- 124 (A)
 REVCD28                  125- 128 (A)
 REVCD29                  129- 132 (A)
 REVCD30                  133- 136 (A)
 REVCD31                  137- 140 (A)
 REVCD32                  141- 144 (A)
 REVCD33                  145- 148 (A).


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 NREVCD                  (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 NREVCD    "Number of revenue codes for this discharge"
 REVCD1    "Revenue code 1 (as received from source)"
 REVCD2    "Revenue code 2 (as received from source)"
 REVCD3    "Revenue code 3 (as received from source)"
 REVCD4    "Revenue code 4 (as received from source)"
 REVCD5    "Revenue code 5 (as received from source)"
 REVCD6    "Revenue code 6 (as received from source)"
 REVCD7    "Revenue code 7 (as received from source)"
 REVCD8    "Revenue code 8 (as received from source)"
 REVCD9    "Revenue code 9 (as received from source)"
 REVCD10   "Revenue code 10 (as received from source)"
 REVCD11   "Revenue code 11 (as received from source)"
 REVCD12   "Revenue code 12 (as received from source)"
 REVCD13   "Revenue code 13 (as received from source)"
 REVCD14   "Revenue code 14 (as received from source)"
 REVCD15   "Revenue code 15 (as received from source)"
 REVCD16   "Revenue code 16 (as received from source)"
 REVCD17   "Revenue code 17 (as received from source)"
 REVCD18   "Revenue code 18 (as received from source)"
 REVCD19   "Revenue code 19 (as received from source)"
 REVCD20   "Revenue code 20 (as received from source)"
 REVCD21   "Revenue code 21 (as received from source)"
 REVCD22   "Revenue code 22 (as received from source)"
 REVCD23   "Revenue code 23 (as received from source)"
 REVCD24   "Revenue code 24 (as received from source)"
 REVCD25   "Revenue code 25 (as received from source)"
 REVCD26   "Revenue code 26 (as received from source)"
 REVCD27   "Revenue code 27 (as received from source)"
 REVCD28   "Revenue code 28 (as received from source)"
 REVCD29   "Revenue code 29 (as received from source)"
 REVCD30   "Revenue code 30 (as received from source)"
 REVCD31   "Revenue code 31 (as received from source)"
 REVCD32   "Revenue code 32 (as received from source)"
 REVCD33   "Revenue code 33 (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE NREVCD
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'ME_SID_2007_CHGS.SAV' /COMPRESSED.
