/*******************************************************************
* Creation Date: 02/07/2024   
*   ME_SID_2021_CHGS.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'ME_SID_2021_CHGS.asc' FIXED SKIP=2 / 
 KEY                             1-  15
 NREVCD                         16-  18
 REVCD1                         19-  22 (A)
 REVCD2                         23-  26 (A)
 REVCD3                         27-  30 (A)
 REVCD4                         31-  34 (A)
 REVCD5                         35-  38 (A)
 REVCD6                         39-  42 (A)
 REVCD7                         43-  46 (A)
 REVCD8                         47-  50 (A)
 REVCD9                         51-  54 (A)
 REVCD10                        55-  58 (A)
 REVCD11                        59-  62 (A)
 REVCD12                        63-  66 (A)
 REVCD13                        67-  70 (A)
 REVCD14                        71-  74 (A)
 REVCD15                        75-  78 (A)
 REVCD16                        79-  82 (A)
 REVCD17                        83-  86 (A)
 REVCD18                        87-  90 (A)
 REVCD19                        91-  94 (A)
 REVCD20                        95-  98 (A)
 REVCD21                        99- 102 (A)
 REVCD22                       103- 106 (A)
 REVCD23                       107- 110 (A)
 REVCD24                       111- 114 (A)
 REVCD25                       115- 118 (A)
 REVCD26                       119- 122 (A)
 REVCD27                       123- 126 (A)
 REVCD28                       127- 130 (A)
 REVCD29                       131- 134 (A)
 REVCD30                       135- 138 (A)
 REVCD31                       139- 142 (A)
 REVCD32                       143- 146 (A)
 REVCD33                       147- 150 (A)
 REVCD34                       151- 154 (A)
 REVCD35                       155- 158 (A)
 REVCD36                       159- 162 (A)
 REVCD37                       163- 166 (A)
 REVCD38                       167- 170 (A)
 REVCD39                       171- 174 (A)
 REVCD40                       175- 178 (A)
 REVCD41                       179- 182 (A)
 REVCD42                       183- 186 (A)
 REVCD43                       187- 190 (A)
 REVCD44                       191- 194 (A)
 REVCD45                       195- 198 (A)
 REVCD46                       199- 202 (A)
 REVCD47                       203- 206 (A)
 REVCD48                       207- 210 (A)
 REVCD49                       211- 214 (A)
 REVCD50                       215- 218 (A)
 REVCD51                       219- 222 (A)
 REVCD52                       223- 226 (A)
 REVCD53                       227- 230 (A)
 REVCD54                       231- 234 (A)
 REVCD55                       235- 238 (A)
 REVCD56                       239- 242 (A)
 REVCD57                       243- 246 (A)
 REVCD58                       247- 250 (A).


/***  Specify write formats  ***/
FORMATS
 KEY                          (F8.0) /
 NREVCD                       (F3.0) /
.


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 KEY                          "HCUP record identifier"
 NREVCD                       "Number of revenue codes for this discharge"
 REVCD1                       "Revenue code 1 (as received from source)"
 REVCD2                       "Revenue code 2 (as received from source)"
 REVCD3                       "Revenue code 3 (as received from source)"
 REVCD4                       "Revenue code 4 (as received from source)"
 REVCD5                       "Revenue code 5 (as received from source)"
 REVCD6                       "Revenue code 6 (as received from source)"
 REVCD7                       "Revenue code 7 (as received from source)"
 REVCD8                       "Revenue code 8 (as received from source)"
 REVCD9                       "Revenue code 9 (as received from source)"
 REVCD10                      "Revenue code 10 (as received from source)"
 REVCD11                      "Revenue code 11 (as received from source)"
 REVCD12                      "Revenue code 12 (as received from source)"
 REVCD13                      "Revenue code 13 (as received from source)"
 REVCD14                      "Revenue code 14 (as received from source)"
 REVCD15                      "Revenue code 15 (as received from source)"
 REVCD16                      "Revenue code 16 (as received from source)"
 REVCD17                      "Revenue code 17 (as received from source)"
 REVCD18                      "Revenue code 18 (as received from source)"
 REVCD19                      "Revenue code 19 (as received from source)"
 REVCD20                      "Revenue code 20 (as received from source)"
 REVCD21                      "Revenue code 21 (as received from source)"
 REVCD22                      "Revenue code 22 (as received from source)"
 REVCD23                      "Revenue code 23 (as received from source)"
 REVCD24                      "Revenue code 24 (as received from source)"
 REVCD25                      "Revenue code 25 (as received from source)"
 REVCD26                      "Revenue code 26 (as received from source)"
 REVCD27                      "Revenue code 27 (as received from source)"
 REVCD28                      "Revenue code 28 (as received from source)"
 REVCD29                      "Revenue code 29 (as received from source)"
 REVCD30                      "Revenue code 30 (as received from source)"
 REVCD31                      "Revenue code 31 (as received from source)"
 REVCD32                      "Revenue code 32 (as received from source)"
 REVCD33                      "Revenue code 33 (as received from source)"
 REVCD34                      "Revenue code 34 (as received from source)"
 REVCD35                      "Revenue code 35 (as received from source)"
 REVCD36                      "Revenue code 36 (as received from source)"
 REVCD37                      "Revenue code 37 (as received from source)"
 REVCD38                      "Revenue code 38 (as received from source)"
 REVCD39                      "Revenue code 39 (as received from source)"
 REVCD40                      "Revenue code 40 (as received from source)"
 REVCD41                      "Revenue code 41 (as received from source)"
 REVCD42                      "Revenue code 42 (as received from source)"
 REVCD43                      "Revenue code 43 (as received from source)"
 REVCD44                      "Revenue code 44 (as received from source)"
 REVCD45                      "Revenue code 45 (as received from source)"
 REVCD46                      "Revenue code 46 (as received from source)"
 REVCD47                      "Revenue code 47 (as received from source)"
 REVCD48                      "Revenue code 48 (as received from source)"
 REVCD49                      "Revenue code 49 (as received from source)"
 REVCD50                      "Revenue code 50 (as received from source)"
 REVCD51                      "Revenue code 51 (as received from source)"
 REVCD52                      "Revenue code 52 (as received from source)"
 REVCD53                      "Revenue code 53 (as received from source)"
 REVCD54                      "Revenue code 54 (as received from source)"
 REVCD55                      "Revenue code 55 (as received from source)"
 REVCD56                      "Revenue code 56 (as received from source)"
 REVCD57                      "Revenue code 57 (as received from source)"
 REVCD58                      "Revenue code 58 (as received from source)" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE NREVCD
 (-99,-88,-66,-55=SYSMIS).



SAVE OUTFILE = 'ME_SID_2021_CHGS.sav' /COMPRESSED.
