/*******************************************************************
*   MI_SID_2000_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'MI_SID_2000_CORE.ASC' FIXED / 
 HOSPID                1-   5
 HOSPST                6-   7 (A)
 KEY                   8-  21
 AGE                  22-  24
 AGEDAY               25-  27
 AGEMONTH             28-  30
 ASOURCE              31-  32
 ASOURCE_             33-  40 (A)
 ATYPE                41-  42
 AWEEKEND             43-  44
 DaysCCU              45-  47
 DaysICU              48-  50
 DIED                 51-  52
 DISP_X               53-  60 (A)
 DISPUB92             61-  62
 DISPUNIF             63-  64
 DRG                  65-  67
 DRG18                68-  70
 DRGVER               71-  72
 DX1                  73-  77 (A)
 DX2                  78-  82 (A)
 DX3                  83-  87 (A)
 DX4                  88-  92 (A)
 DX5                  93-  97 (A)
 DX6                  98- 102 (A)
 DX7                 103- 107 (A)
 DX8                 108- 112 (A)
 DX9                 113- 117 (A)
 DX10                118- 122 (A)
 DX11                123- 127 (A)
 DX12                128- 132 (A)
 DX13                133- 137 (A)
 DX14                138- 142 (A)
 DX15                143- 147 (A)
 DX16                148- 152 (A)
 DX17                153- 157 (A)
 DX18                158- 162 (A)
 DX19                163- 167 (A)
 DX20                168- 172 (A)
 DX21                173- 177 (A)
 DX22                178- 182 (A)
 DX23                183- 187 (A)
 DX24                188- 192 (A)
 DX25                193- 197 (A)
 DX26                198- 202 (A)
 DX27                203- 207 (A)
 DX28                208- 212 (A)
 DX29                213- 217 (A)
 DX30                218- 222 (A)
 DXCCS1              223- 226
 DXCCS2              227- 230
 DXCCS3              231- 234
 DXCCS4              235- 238
 DXCCS5              239- 242
 DXCCS6              243- 246
 DXCCS7              247- 250
 DXCCS8              251- 254
 DXCCS9              255- 258
 DXCCS10             259- 262
 DXCCS11             263- 266
 DXCCS12             267- 270
 DXCCS13             271- 274
 DXCCS14             275- 278
 DXCCS15             279- 282
 DXCCS16             283- 286
 DXCCS17             287- 290
 DXCCS18             291- 294
 DXCCS19             295- 298
 DXCCS20             299- 302
 DXCCS21             303- 306
 DXCCS22             307- 310
 DXCCS23             311- 314
 DXCCS24             315- 318
 DXCCS25             319- 322
 DXCCS26             323- 326
 DXCCS27             327- 330
 DXCCS28             331- 334
 DXCCS29             335- 338
 DXCCS30             339- 342
 FEMALE              343- 344
 HISPANIC            345- 352 (A)
 LOS                 353- 357
 LOS_X               358- 363
 MDC                 364- 365
 MDC18               366- 367
 MDID_S              368- 383 (A)
 MRN_S               384- 400 (A)
 NDX                 401- 402
 NEOMAT              403- 404
 NPR                 405- 406
 PAY1                407- 408
 PAY2                409- 410
 PAY1_X              411- 418 (A)
 PAY2_X              419- 426 (A)
 PR1                 427- 430 (A)
 PR2                 431- 434 (A)
 PR3                 435- 438 (A)
 PR4                 439- 442 (A)
 PR5                 443- 446 (A)
 PR6                 447- 450 (A)
 PR7                 451- 454 (A)
 PR8                 455- 458 (A)
 PR9                 459- 462 (A)
 PR10                463- 466 (A)
 PR11                467- 470 (A)
 PR12                471- 474 (A)
 PR13                475- 478 (A)
 PR14                479- 482 (A)
 PR15                483- 486 (A)
 PR16                487- 490 (A)
 PR17                491- 494 (A)
 PR18                495- 498 (A)
 PR19                499- 502 (A)
 PR20                503- 506 (A)
 PR21                507- 510 (A)
 PR22                511- 514 (A)
 PR23                515- 518 (A)
 PR24                519- 522 (A)
 PR25                523- 526 (A)
 PR26                527- 530 (A)
 PR27                531- 534 (A)
 PR28                535- 538 (A)
 PR29                539- 542 (A)
 PR30                543- 546 (A)
 PRCCS1              547- 549
 PRCCS2              550- 552
 PRCCS3              553- 555
 PRCCS4              556- 558
 PRCCS5              559- 561
 PRCCS6              562- 564
 PRCCS7              565- 567
 PRCCS8              568- 570
 PRCCS9              571- 573
 PRCCS10             574- 576
 PRCCS11             577- 579
 PRCCS12             580- 582
 PRCCS13             583- 585
 PRCCS14             586- 588
 PRCCS15             589- 591
 PRCCS16             592- 594
 PRCCS17             595- 597
 PRCCS18             598- 600
 PRCCS19             601- 603
 PRCCS20             604- 606
 PRCCS21             607- 609
 PRCCS22             610- 612
 PRCCS23             613- 615
 PRCCS24             616- 618
 PRCCS25             619- 621
 PRCCS26             622- 624
 PRCCS27             625- 627
 PRCCS28             628- 630
 PRCCS29             631- 633
 PRCCS30             634- 636
 PRDAY1              637- 641
 RACE                642- 643
 RACE_X              644- 651 (A)
 SURGID_S            652- 667 (A)
 YEAR                668- 671
 ZIP                 672- 676 (A).


***  Specify write formats  ***.
FORMATS
 HOSPID              (F4.0) /
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 ASOURCE             (F3.0) /
 ATYPE               (F3.0) /
 AWEEKEND            (F3.0) /
 DaysCCU             (F3.0) /
 DaysICU             (F3.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DRG                 (F3.0) /
 DRG18               (F3.0) /
 DRGVER              (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 DXCCS12             (F4.0) /
 DXCCS13             (F4.0) /
 DXCCS14             (F4.0) /
 DXCCS15             (F4.0) /
 DXCCS16             (F4.0) /
 DXCCS17             (F4.0) /
 DXCCS18             (F4.0) /
 DXCCS19             (F4.0) /
 DXCCS20             (F4.0) /
 DXCCS21             (F4.0) /
 DXCCS22             (F4.0) /
 DXCCS23             (F4.0) /
 DXCCS24             (F4.0) /
 DXCCS25             (F4.0) /
 DXCCS26             (F4.0) /
 DXCCS27             (F4.0) /
 DXCCS28             (F4.0) /
 DXCCS29             (F4.0) /
 DXCCS30             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 MDC                 (F3.0) /
 MDC18               (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PAY2                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRCCS7              (F3.0) /
 PRCCS8              (F3.0) /
 PRCCS9              (F3.0) /
 PRCCS10             (F3.0) /
 PRCCS11             (F3.0) /
 PRCCS12             (F3.0) /
 PRCCS13             (F3.0) /
 PRCCS14             (F3.0) /
 PRCCS15             (F3.0) /
 PRCCS16             (F3.0) /
 PRCCS17             (F3.0) /
 PRCCS18             (F3.0) /
 PRCCS19             (F3.0) /
 PRCCS20             (F3.0) /
 PRCCS21             (F3.0) /
 PRCCS22             (F3.0) /
 PRCCS23             (F3.0) /
 PRCCS24             (F3.0) /
 PRCCS25             (F3.0) /
 PRCCS26             (F3.0) /
 PRCCS27             (F3.0) /
 PRCCS28             (F3.0) /
 PRCCS29             (F3.0) /
 PRCCS30             (F3.0) /
 PRDAY1              (F4.0) /
 RACE                (F3.0) /
 YEAR                (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 HOSPID    "HCUP hospital identification number (SSHHH)"
 HOSPST    "Hospital state postal code"
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 DaysCCU   "Days in coronary care unit (as received from the source)"
 DaysICU   "Days in medical/surgical intensive care unit (as received from the source)"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRGVER    "DRG grouper version used on discharge date"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DX26      "Diagnosis 26"
 DX27      "Diagnosis 27"
 DX28      "Diagnosis 28"
 DX29      "Diagnosis 29"
 DX30      "Diagnosis 30"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXCCS26   "CCS: diagnosis 26"
 DXCCS27   "CCS: diagnosis 27"
 DXCCS28   "CCS: diagnosis 28"
 DXCCS29   "CCS: diagnosis 29"
 DXCCS30   "CCS: diagnosis 30"
 FEMALE    "Indicator of sex"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 MDID_S    "Attending physician number (synthetic)"
 MRN_S     "Medical record number (synthetic)"
 NDX       "Number of diagnoses on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PR22      "Procedure 22"
 PR23      "Procedure 23"
 PR24      "Procedure 24"
 PR25      "Procedure 25"
 PR26      "Procedure 26"
 PR27      "Procedure 27"
 PR28      "Procedure 28"
 PR29      "Procedure 29"
 PR30      "Procedure 30"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRCCS22   "CCS: procedure 22"
 PRCCS23   "CCS: procedure 23"
 PRCCS24   "CCS: procedure 24"
 PRCCS25   "CCS: procedure 25"
 PRCCS26   "CCS: procedure 26"
 PRCCS27   "CCS: procedure 27"
 PRCCS28   "CCS: procedure 28"
 PRCCS29   "CCS: procedure 29"
 PRCCS30   "CCS: procedure 30"
 PRDAY1    "Number of days from admission to PR1"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 SURGID_S  "Primary surgeon number (synthetic)"
 YEAR      "Calendar year"
 ZIP       "Patient zip code" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DaysCCU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysICU
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MI_SID_2000_CORE.SAV' /COMPRESSED.
