/*******************************************************************
*   MI_SID_2007_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'MI_SID_2007_CORE.ASC' FIXED / 
 ADRG                       1-   3
 ADRGRISK                   4-   5
 ADRGSEV                    6-   7
 AGE                        8-  10
 AGEDAY                    11-  13
 AGEMONTH                  14-  16
 AMONTH                    17-  18
 ASOURCE                   19-  20
 ASOURCEU                  21     (A)
 ASOURCE_                  22     (A)
 ATYPE                     23-  24
 AWEEKEND                  25-  26
 DIED                      27-  28
 DISPUB04                  29-  30
 DISPUNIF                  31-  32
 DISP_X                    33-  34 (A)
 DQTR                      35-  36
 DRG                       37-  39
 DRG24                     40-  42
 DRGVER                    43-  44
 DX1                       45-  49 (A)
 DX2                       50-  54 (A)
 DX3                       55-  59 (A)
 DX4                       60-  64 (A)
 DX5                       65-  69 (A)
 DX6                       70-  74 (A)
 DX7                       75-  79 (A)
 DX8                       80-  84 (A)
 DX9                       85-  89 (A)
 DX10                      90-  94 (A)
 DX11                      95-  99 (A)
 DX12                     100- 104 (A)
 DX13                     105- 109 (A)
 DX14                     110- 114 (A)
 DX15                     115- 119 (A)
 DX16                     120- 124 (A)
 DX17                     125- 129 (A)
 DX18                     130- 134 (A)
 DX19                     135- 139 (A)
 DX20                     140- 144 (A)
 DX21                     145- 149 (A)
 DX22                     150- 154 (A)
 DX23                     155- 159 (A)
 DX24                     160- 164 (A)
 DX25                     165- 169 (A)
 DX26                     170- 174 (A)
 DX27                     175- 179 (A)
 DX28                     180- 184 (A)
 DX29                     185- 189 (A)
 DX30                     190- 194 (A)
 DXCCS1                   195- 198
 DXCCS2                   199- 202
 DXCCS3                   203- 206
 DXCCS4                   207- 210
 DXCCS5                   211- 214
 DXCCS6                   215- 218
 DXCCS7                   219- 222
 DXCCS8                   223- 226
 DXCCS9                   227- 230
 DXCCS10                  231- 234
 DXCCS11                  235- 238
 DXCCS12                  239- 242
 DXCCS13                  243- 246
 DXCCS14                  247- 250
 DXCCS15                  251- 254
 DXCCS16                  255- 258
 DXCCS17                  259- 262
 DXCCS18                  263- 266
 DXCCS19                  267- 270
 DXCCS20                  271- 274
 DXCCS21                  275- 278
 DXCCS22                  279- 282
 DXCCS23                  283- 286
 DXCCS24                  287- 290
 DXCCS25                  291- 294
 DXCCS26                  295- 298
 DXCCS27                  299- 302
 DXCCS28                  303- 306
 DXCCS29                  307- 310
 DXCCS30                  311- 314
 DaysCCU                  315- 317
 DaysICU                  318- 320
 ECODE1                   321- 325 (A)
 ECODE2                   326- 330 (A)
 ECODE3                   331- 335 (A)
 ECODE4                   336- 340 (A)
 ECODE5                   341- 345 (A)
 ECODE6                   346- 350 (A)
 ECODE7                   351- 355 (A)
 ECODE8                   356- 360 (A)
 ECODE9                   361- 365 (A)
 ECODE10                  366- 370 (A)
 E_CCS1                   371- 374
 E_CCS2                   375- 378
 E_CCS3                   379- 382
 E_CCS4                   383- 386
 E_CCS5                   387- 390
 E_CCS6                   391- 394
 E_CCS7                   395- 398
 E_CCS8                   399- 402
 E_CCS9                   403- 406
 E_CCS10                  407- 410
 FEMALE                   411- 412
 HCUP_ED                  413- 414
 HCUP_OS                  415- 416
 HISPANIC                 417     (A)
 HOSPBRTH                 418- 420
 HOSPST                   421- 422 (A)
 KEY                      423- 436
 LOS                      437- 441
 LOS_X                    442- 447
 MDC                      448- 449
 MDC24                    450- 451
 MDNUM1_R                 452- 460
 MDNUM2_R                 461- 469
 MEDINCST                 470- 471
 MOMNUM_R                 472- 480
 MRN_R                    481- 489
 NDX                      490- 491
 NECODE                   492- 493
 NEOMAT                   494- 495
 NPR                      496- 497
 PAY1                     498- 499
 PAY1_X                   500- 501 (A)
 PAY2                     502- 503
 PAY2_X                   504- 505 (A)
 PL_CBSA                  506- 508
 PL_MSA19                 509- 511
 PL_NCHS2                 512- 513
 PL_RUCA1                 514- 515
 PL_RUCA2                 516- 519
 PL_RUCA4                 520- 521
 PL_RUCC2                 522- 523
 PL_UIC20                 524- 525
 PL_UR_CA                 526- 527
 PR1                      528- 531 (A)
 PR2                      532- 535 (A)
 PR3                      536- 539 (A)
 PR4                      540- 543 (A)
 PR5                      544- 547 (A)
 PR6                      548- 551 (A)
 PR7                      552- 555 (A)
 PR8                      556- 559 (A)
 PR9                      560- 563 (A)
 PR10                     564- 567 (A)
 PR11                     568- 571 (A)
 PR12                     572- 575 (A)
 PR13                     576- 579 (A)
 PR14                     580- 583 (A)
 PR15                     584- 587 (A)
 PR16                     588- 591 (A)
 PR17                     592- 595 (A)
 PR18                     596- 599 (A)
 PR19                     600- 603 (A)
 PR20                     604- 607 (A)
 PR21                     608- 611 (A)
 PR22                     612- 615 (A)
 PR23                     616- 619 (A)
 PR24                     620- 623 (A)
 PR25                     624- 627 (A)
 PR26                     628- 631 (A)
 PR27                     632- 635 (A)
 PR28                     636- 639 (A)
 PR29                     640- 643 (A)
 PR30                     644- 647 (A)
 PRCCS1                   648- 650
 PRCCS2                   651- 653
 PRCCS3                   654- 656
 PRCCS4                   657- 659
 PRCCS5                   660- 662
 PRCCS6                   663- 665
 PRCCS7                   666- 668
 PRCCS8                   669- 671
 PRCCS9                   672- 674
 PRCCS10                  675- 677
 PRCCS11                  678- 680
 PRCCS12                  681- 683
 PRCCS13                  684- 686
 PRCCS14                  687- 689
 PRCCS15                  690- 692
 PRCCS16                  693- 695
 PRCCS17                  696- 698
 PRCCS18                  699- 701
 PRCCS19                  702- 704
 PRCCS20                  705- 707
 PRCCS21                  708- 710
 PRCCS22                  711- 713
 PRCCS23                  714- 716
 PRCCS24                  717- 719
 PRCCS25                  720- 722
 PRCCS26                  723- 725
 PRCCS27                  726- 728
 PRCCS28                  729- 731
 PRCCS29                  732- 734
 PRCCS30                  735- 737
 PRDAY1                   738- 742
 PROCTYPE                 743- 745
 PSTATE                   746- 747 (A)
 PSTCO2                   748- 752
 RACE                     753- 754
 RACE_X                   755     (A)
 TOTCHG                   756- 765
 TOTCHG_X                 766- 780
 YEAR                     781- 784
 ZIPINC_Q                 785- 787
 HOSPID                   788- 792
 ZIP                      793- 797 (A)
 AYEAR                    798- 801
 DMONTH                   802- 803
 BMONTH                   804- 805
 BYEAR                    806- 809
 PRMNTH1                  810- 811
 PRYEAR1                  812- 815.


***  Specify write formats  ***.
FORMATS
 ADRG                    (F3.0) /
 ADRGRISK                (F3.0) /
 ADRGSEV                 (F3.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DaysCCU                 (F3.0) /
 DaysICU                 (F3.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 E_CCS10                 (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCST                (F3.0) /
 MOMNUM_R                (F5.0) /
 MRN_R                   (F5.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRDAY1                  (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 HOSPID                  (F4.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 ADRG      "All Patient Refined DRG"
 ADRGRISK  "All Patient Refined DRG mortality risk"
 ADRGSEV   "All Patient Refined DRG severity level"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG24     "DRG, version 24"
 DRGVER    "DRG grouper version used on discharge date"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DX26      "Diagnosis 26"
 DX27      "Diagnosis 27"
 DX28      "Diagnosis 28"
 DX29      "Diagnosis 29"
 DX30      "Diagnosis 30"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXCCS26   "CCS: diagnosis 26"
 DXCCS27   "CCS: diagnosis 27"
 DXCCS28   "CCS: diagnosis 28"
 DXCCS29   "CCS: diagnosis 29"
 DXCCS30   "CCS: diagnosis 30"
 DaysCCU   "Days in coronary care unit (as received from source)"
 DaysICU   "Days in medical/surgical intensive care unit (as received from source)"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 ECODE8    "E code 8"
 ECODE9    "E code 9"
 ECODE10   "E code 10"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_CCS8    "CCS: E Code 8"
 E_CCS9    "CCS: E Code 9"
 E_CCS10   "CCS: E Code 10"
 FEMALE    "Indicator of sex"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC24     "MDC, version 24"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MOMNUM_R  "Mother's number (re-identified)"
 MRN_R     "Medical record number (re-identified)"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2      "Secondary expected payer (uniform)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PR22      "Procedure 22"
 PR23      "Procedure 23"
 PR24      "Procedure 24"
 PR25      "Procedure 25"
 PR26      "Procedure 26"
 PR27      "Procedure 27"
 PR28      "Procedure 28"
 PR29      "Procedure 29"
 PR30      "Procedure 30"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRCCS22   "CCS: procedure 22"
 PRCCS23   "CCS: procedure 23"
 PRCCS24   "CCS: procedure 24"
 PRCCS25   "CCS: procedure 25"
 PRCCS26   "CCS: procedure 26"
 PRCCS27   "CCS: procedure 27"
 PRCCS28   "CCS: procedure 28"
 PRCCS29   "CCS: procedure 29"
 PRCCS30   "CCS: procedure 30"
 PRDAY1    "Number of days from admission to PR1"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 HOSPID    "HCUP hospital identification number"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE ADRG
 (-99,-88,-66,-55=SYSMIS).
RECODE ADRGRISK
 (-9,-8,-6,-5=SYSMIS).
RECODE ADRGSEV
 (-9,-8,-6,-5=SYSMIS).
RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysCCU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysICU
 (-99,-88,-66,-55=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MOMNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MI_SID_2007_CORE.SAV' /COMPRESSED.
