/*******************************************************************
* Creation Date: 03/03/2015   
*   MI_SID_2013_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MI_SID_2013_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 DIED                           16-  17
 DISPUB04                       18-  19
 DISPUNIFORM                    20-  21
 DISP_X                         22-  23 (A)
 DMONTH                         24-  25
 DQTR                           26-  27
 DRG                            28-  30
 DRG24                          31-  33
 DRGVER                         34-  35
 DRG_NoPOA                      36-  38
 DX1                            39-  43 (A)
 DX2                            44-  48 (A)
 DX3                            49-  53 (A)
 DX4                            54-  58 (A)
 DX5                            59-  63 (A)
 DX6                            64-  68 (A)
 DX7                            69-  73 (A)
 DX8                            74-  78 (A)
 DX9                            79-  83 (A)
 DX10                           84-  88 (A)
 DX11                           89-  93 (A)
 DX12                           94-  98 (A)
 DX13                           99- 103 (A)
 DX14                          104- 108 (A)
 DX15                          109- 113 (A)
 DX16                          114- 118 (A)
 DX17                          119- 123 (A)
 DX18                          124- 128 (A)
 DX19                          129- 133 (A)
 DX20                          134- 138 (A)
 DX21                          139- 143 (A)
 DX22                          144- 148 (A)
 DX23                          149- 153 (A)
 DX24                          154- 158 (A)
 DX25                          159- 163 (A)
 DX26                          164- 168 (A)
 DX27                          169- 173 (A)
 DX28                          174- 178 (A)
 DX29                          179- 183 (A)
 DX30                          184- 188 (A)
 DXCCS1                        189- 192
 DXCCS2                        193- 196
 DXCCS3                        197- 200
 DXCCS4                        201- 204
 DXCCS5                        205- 208
 DXCCS6                        209- 212
 DXCCS7                        213- 216
 DXCCS8                        217- 220
 DXCCS9                        221- 224
 DXCCS10                       225- 228
 DXCCS11                       229- 232
 DXCCS12                       233- 236
 DXCCS13                       237- 240
 DXCCS14                       241- 244
 DXCCS15                       245- 248
 DXCCS16                       249- 252
 DXCCS17                       253- 256
 DXCCS18                       257- 260
 DXCCS19                       261- 264
 DXCCS20                       265- 268
 DXCCS21                       269- 272
 DXCCS22                       273- 276
 DXCCS23                       277- 280
 DXCCS24                       281- 284
 DXCCS25                       285- 288
 DXCCS26                       289- 292
 DXCCS27                       293- 296
 DXCCS28                       297- 300
 DXCCS29                       301- 304
 DXCCS30                       305- 308
 DXPOA1                        309     (A)
 DXPOA2                        310     (A)
 DXPOA3                        311     (A)
 DXPOA4                        312     (A)
 DXPOA5                        313     (A)
 DXPOA6                        314     (A)
 DXPOA7                        315     (A)
 DXPOA8                        316     (A)
 DXPOA9                        317     (A)
 DXPOA10                       318     (A)
 DXPOA11                       319     (A)
 DXPOA12                       320     (A)
 DXPOA13                       321     (A)
 DXPOA14                       322     (A)
 DXPOA15                       323     (A)
 DXPOA16                       324     (A)
 DXPOA17                       325     (A)
 DXPOA18                       326     (A)
 DXPOA19                       327     (A)
 DXPOA20                       328     (A)
 DXPOA21                       329     (A)
 DXPOA22                       330     (A)
 DXPOA23                       331     (A)
 DXPOA24                       332     (A)
 DXPOA25                       333     (A)
 DXPOA26                       334     (A)
 DXPOA27                       335     (A)
 DXPOA28                       336     (A)
 DXPOA29                       337     (A)
 DXPOA30                       338     (A)
 DX_Admitting                  339- 343 (A)
 DaysCCU                       344- 346
 DaysICU                       347- 349
 ECODE1                        350- 354 (A)
 ECODE2                        355- 359 (A)
 ECODE3                        360- 364 (A)
 ECODE4                        365- 369 (A)
 ECODE5                        370- 374 (A)
 ECODE6                        375- 379 (A)
 ECODE7                        380- 384 (A)
 ECODE8                        385- 389 (A)
 ECODE9                        390- 394 (A)
 E_CCS1                        395- 398
 E_CCS2                        399- 402
 E_CCS3                        403- 406
 E_CCS4                        407- 410
 E_CCS5                        411- 414
 E_CCS6                        415- 418
 E_CCS7                        419- 422
 E_CCS8                        423- 426
 E_CCS9                        427- 430
 E_POA1                        431     (A)
 E_POA2                        432     (A)
 E_POA3                        433     (A)
 E_POA4                        434     (A)
 E_POA5                        435     (A)
 E_POA6                        436     (A)
 E_POA7                        437     (A)
 E_POA8                        438     (A)
 E_POA9                        439     (A)
 FEMALE                        440- 441
 HCUP_ED                       442- 443
 HCUP_OS                       444- 445
 HISPANIC_X                    446     (A)
 HOSPBRTH                      447- 449
 HOSPST                        450- 451 (A)
 KEY                           452- 466
 LOS                           467- 471
 LOS_X                         472- 477
 MDC                           478- 479
 MDC24                         480- 481
 MDC_NoPOA                     482- 483
 MDNUM1_R                      484- 492
 MDNUM2_R                      493- 501
 MEDINCSTQ                     502- 503
 MOMNUM_R                      504- 512
 MRN_R                         513- 521
 NCHRONIC                      522- 524
 NDX                           525- 527
 NECODE                        528- 529
 NEOMAT                        530- 531
 NPR                           532- 534
 ORPROC                        535- 536
 PAY1                          537- 538
 PAY1_X                        539- 540 (A)
 PAY2                          541- 542
 PAY2_X                        543- 544 (A)
 PL_CBSA                       545- 547
 PL_NCHS                       548- 549
 PL_RUCA10_2005                550- 551
 PL_RUCA2005                   552- 555
 PL_RUCA4_2005                 556- 557
 PL_RUCC                       558- 559
 PL_UIC                        560- 561
 PL_UR_CAT4                    562- 563
 PR1                           564- 567 (A)
 PR2                           568- 571 (A)
 PR3                           572- 575 (A)
 PR4                           576- 579 (A)
 PR5                           580- 583 (A)
 PR6                           584- 587 (A)
 PR7                           588- 591 (A)
 PR8                           592- 595 (A)
 PR9                           596- 599 (A)
 PR10                          600- 603 (A)
 PR11                          604- 607 (A)
 PR12                          608- 611 (A)
 PR13                          612- 615 (A)
 PR14                          616- 619 (A)
 PR15                          620- 623 (A)
 PR16                          624- 627 (A)
 PR17                          628- 631 (A)
 PR18                          632- 635 (A)
 PR19                          636- 639 (A)
 PR20                          640- 643 (A)
 PR21                          644- 647 (A)
 PR22                          648- 651 (A)
 PR23                          652- 655 (A)
 PR24                          656- 659 (A)
 PR25                          660- 663 (A)
 PR26                          664- 667 (A)
 PR27                          668- 671 (A)
 PR28                          672- 675 (A)
 PR29                          676- 679 (A)
 PR30                          680- 683 (A)
 PRCCS1                        684- 686
 PRCCS2                        687- 689
 PRCCS3                        690- 692
 PRCCS4                        693- 695
 PRCCS5                        696- 698
 PRCCS6                        699- 701
 PRCCS7                        702- 704
 PRCCS8                        705- 707
 PRCCS9                        708- 710
 PRCCS10                       711- 713
 PRCCS11                       714- 716
 PRCCS12                       717- 719
 PRCCS13                       720- 722
 PRCCS14                       723- 725
 PRCCS15                       726- 728
 PRCCS16                       729- 731
 PRCCS17                       732- 734
 PRCCS18                       735- 737
 PRCCS19                       738- 740
 PRCCS20                       741- 743
 PRCCS21                       744- 746
 PRCCS22                       747- 749
 PRCCS23                       750- 752
 PRCCS24                       753- 755
 PRCCS25                       756- 758
 PRCCS26                       759- 761
 PRCCS27                       762- 764
 PRCCS28                       765- 767
 PRCCS29                       768- 770
 PRCCS30                       771- 773
 PRDAY1                        774- 778
 PRDAY2                        779- 783
 PRDAY3                        784- 788
 PRDAY4                        789- 793
 PRDAY5                        794- 798
 PRDAY6                        799- 803
 PRDAY7                        804- 808
 PRDAY8                        809- 813
 PRDAY9                        814- 818
 PRDAY10                       819- 823
 PRDAY11                       824- 828
 PRDAY12                       829- 833
 PRDAY13                       834- 838
 PRDAY14                       839- 843
 PRDAY15                       844- 848
 PRDAY16                       849- 853
 PRDAY17                       854- 858
 PRDAY18                       859- 863
 PRDAY19                       864- 868
 PRDAY20                       869- 873
 PRDAY21                       874- 878
 PRDAY22                       879- 883
 PRDAY23                       884- 888
 PRDAY24                       889- 893
 PRDAY25                       894- 898
 PRDAY26                       899- 903
 PRDAY27                       904- 908
 PRDAY28                       909- 913
 PRDAY29                       914- 918
 PRDAY30                       919- 923
 PROCTYPE                      924- 926
 PSTATE                        927- 928 (A)
 PSTCO2                        929- 933
 PointOfOriginUB04             934     (A)
 PointOfOrigin_X               935     (A)
 RACE                          936- 937
 RACE_X                        938     (A)
 TOTCHG                        939- 948
 TOTCHG_X                      949- 963
 TRAN_IN                       964- 965
 TRAN_OUT                      966- 967
 YEAR                          968- 971
 ZIP3                          972- 974 (A)
 ZIPINC_QRTL                   975- 977
 HOSPID                        978- 982
 ZIP                           983- 987 (A)
 AYEAR                         988- 991
 BMONTH                        992- 993
 BYEAR                         994- 997
 PRMONTH1                      998- 999
 PRMONTH2                     1000-1001
 PRMONTH3                     1002-1003
 PRMONTH4                     1004-1005
 PRMONTH5                     1006-1007
 PRMONTH6                     1008-1009
 PRMONTH7                     1010-1011
 PRMONTH8                     1012-1013
 PRMONTH9                     1014-1015
 PRMONTH10                    1016-1017
 PRMONTH11                    1018-1019
 PRMONTH12                    1020-1021
 PRMONTH13                    1022-1023
 PRMONTH14                    1024-1025
 PRMONTH15                    1026-1027
 PRMONTH16                    1028-1029
 PRMONTH17                    1030-1031
 PRMONTH18                    1032-1033
 PRMONTH19                    1034-1035
 PRMONTH20                    1036-1037
 PRMONTH21                    1038-1039
 PRMONTH22                    1040-1041
 PRMONTH23                    1042-1043
 PRMONTH24                    1044-1045
 PRMONTH25                    1046-1047
 PRMONTH26                    1048-1049
 PRMONTH27                    1050-1051
 PRMONTH28                    1052-1053
 PRMONTH29                    1054-1055
 PRMONTH30                    1056-1057
 PRYEAR1                      1058-1061
 PRYEAR2                      1062-1065
 PRYEAR3                      1066-1069
 PRYEAR4                      1070-1073
 PRYEAR5                      1074-1077
 PRYEAR6                      1078-1081
 PRYEAR7                      1082-1085
 PRYEAR8                      1086-1089
 PRYEAR9                      1090-1093
 PRYEAR10                     1094-1097
 PRYEAR11                     1098-1101
 PRYEAR12                     1102-1105
 PRYEAR13                     1106-1109
 PRYEAR14                     1110-1113
 PRYEAR15                     1114-1117
 PRYEAR16                     1118-1121
 PRYEAR17                     1122-1125
 PRYEAR18                     1126-1129
 PRYEAR19                     1130-1133
 PRYEAR20                     1134-1137
 PRYEAR21                     1138-1141
 PRYEAR22                     1142-1145
 PRYEAR23                     1146-1149
 PRYEAR24                     1150-1153
 PRYEAR25                     1154-1157
 PRYEAR26                     1158-1161
 PRYEAR27                     1162-1165
 PRYEAR28                     1166-1169
 PRYEAR29                     1170-1173
 PRYEAR30                     1174-1177.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG24                        (F3.0) /
 DRGVER                       (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DXCCS16                      (F4.0) /
 DXCCS17                      (F4.0) /
 DXCCS18                      (F4.0) /
 DXCCS19                      (F4.0) /
 DXCCS20                      (F4.0) /
 DXCCS21                      (F4.0) /
 DXCCS22                      (F4.0) /
 DXCCS23                      (F4.0) /
 DXCCS24                      (F4.0) /
 DXCCS25                      (F4.0) /
 DXCCS26                      (F4.0) /
 DXCCS27                      (F4.0) /
 DXCCS28                      (F4.0) /
 DXCCS29                      (F4.0) /
 DXCCS30                      (F4.0) /
 DaysCCU                      (F3.0) /
 DaysICU                      (F3.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 E_CCS9                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HOSPBRTH                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC24                        (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MOMNUM_R                     (F5.0) /
 MRN_R                        (F5.0) /
 NCHRONIC                     (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCA10_2005               (F3.0) /
 PL_RUCA2005                  (F4.1) /
 PL_RUCA4_2005                (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRCCS7                       (F3.0) /
 PRCCS8                       (F3.0) /
 PRCCS9                       (F3.0) /
 PRCCS10                      (F3.0) /
 PRCCS11                      (F3.0) /
 PRCCS12                      (F3.0) /
 PRCCS13                      (F3.0) /
 PRCCS14                      (F3.0) /
 PRCCS15                      (F3.0) /
 PRCCS16                      (F3.0) /
 PRCCS17                      (F3.0) /
 PRCCS18                      (F3.0) /
 PRCCS19                      (F3.0) /
 PRCCS20                      (F3.0) /
 PRCCS21                      (F3.0) /
 PRCCS22                      (F3.0) /
 PRCCS23                      (F3.0) /
 PRCCS24                      (F3.0) /
 PRCCS25                      (F3.0) /
 PRCCS26                      (F3.0) /
 PRCCS27                      (F3.0) /
 PRCCS28                      (F3.0) /
 PRCCS29                      (F3.0) /
 PRCCS30                      (F3.0) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PROCTYPE                     (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG24                        "DRG, version 24"
 DRGVER                       "DRG grouper version used on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DX16                         "Diagnosis 16"
 DX17                         "Diagnosis 17"
 DX18                         "Diagnosis 18"
 DX19                         "Diagnosis 19"
 DX20                         "Diagnosis 20"
 DX21                         "Diagnosis 21"
 DX22                         "Diagnosis 22"
 DX23                         "Diagnosis 23"
 DX24                         "Diagnosis 24"
 DX25                         "Diagnosis 25"
 DX26                         "Diagnosis 26"
 DX27                         "Diagnosis 27"
 DX28                         "Diagnosis 28"
 DX29                         "Diagnosis 29"
 DX30                         "Diagnosis 30"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXCCS16                      "CCS: diagnosis 16"
 DXCCS17                      "CCS: diagnosis 17"
 DXCCS18                      "CCS: diagnosis 18"
 DXCCS19                      "CCS: diagnosis 19"
 DXCCS20                      "CCS: diagnosis 20"
 DXCCS21                      "CCS: diagnosis 21"
 DXCCS22                      "CCS: diagnosis 22"
 DXCCS23                      "CCS: diagnosis 23"
 DXCCS24                      "CCS: diagnosis 24"
 DXCCS25                      "CCS: diagnosis 25"
 DXCCS26                      "CCS: diagnosis 26"
 DXCCS27                      "CCS: diagnosis 27"
 DXCCS28                      "CCS: diagnosis 28"
 DXCCS29                      "CCS: diagnosis 29"
 DXCCS30                      "CCS: diagnosis 30"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DX_Admitting                 "Admitting Diagnosis Code"
 DaysCCU                      "Days in coronary care unit (as received from source)"
 DaysICU
"Days in medical/surgical intensive care unit (as received from source)"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 ECODE9                       "E code 9"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 E_CCS9                       "CCS: E Code 9"
 E_POA1                       "E Code 1, present on admission indicator"
 E_POA2                       "E Code 2, present on admission indicator"
 E_POA3                       "E Code 3, present on admission indicator"
 E_POA4                       "E Code 4, present on admission indicator"
 E_POA5                       "E Code 5, present on admission indicator"
 E_POA6                       "E Code 6, present on admission indicator"
 E_POA7                       "E Code 7, present on admission indicator"
 E_POA8                       "E Code 8, present on admission indicator"
 E_POA9                       "E Code 9, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC24                        "MDC, version 24"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MOMNUM_R                     "Mother's number (re-identified)"
 MRN_R                        "Medical record number (re-identified)"
 NCHRONIC                     "Number of chronic conditions"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 ORPROC                       "Major operating room procedure indicator"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005                  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PR7                          "Procedure 7"
 PR8                          "Procedure 8"
 PR9                          "Procedure 9"
 PR10                         "Procedure 10"
 PR11                         "Procedure 11"
 PR12                         "Procedure 12"
 PR13                         "Procedure 13"
 PR14                         "Procedure 14"
 PR15                         "Procedure 15"
 PR16                         "Procedure 16"
 PR17                         "Procedure 17"
 PR18                         "Procedure 18"
 PR19                         "Procedure 19"
 PR20                         "Procedure 20"
 PR21                         "Procedure 21"
 PR22                         "Procedure 22"
 PR23                         "Procedure 23"
 PR24                         "Procedure 24"
 PR25                         "Procedure 25"
 PR26                         "Procedure 26"
 PR27                         "Procedure 27"
 PR28                         "Procedure 28"
 PR29                         "Procedure 29"
 PR30                         "Procedure 30"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRCCS7                       "CCS: procedure 7"
 PRCCS8                       "CCS: procedure 8"
 PRCCS9                       "CCS: procedure 9"
 PRCCS10                      "CCS: procedure 10"
 PRCCS11                      "CCS: procedure 11"
 PRCCS12                      "CCS: procedure 12"
 PRCCS13                      "CCS: procedure 13"
 PRCCS14                      "CCS: procedure 14"
 PRCCS15                      "CCS: procedure 15"
 PRCCS16                      "CCS: procedure 16"
 PRCCS17                      "CCS: procedure 17"
 PRCCS18                      "CCS: procedure 18"
 PRCCS19                      "CCS: procedure 19"
 PRCCS20                      "CCS: procedure 20"
 PRCCS21                      "CCS: procedure 21"
 PRCCS22                      "CCS: procedure 22"
 PRCCS23                      "CCS: procedure 23"
 PRCCS24                      "CCS: procedure 24"
 PRCCS25                      "CCS: procedure 25"
 PRCCS26                      "CCS: procedure 26"
 PRCCS27                      "CCS: procedure 27"
 PRCCS28                      "CCS: procedure 28"
 PRCCS29                      "CCS: procedure 29"
 PRCCS30                      "CCS: procedure 30"
 PRDAY1                       "Number of days from admission to PR1"
 PRDAY2                       "Number of days from admission to PR2"
 PRDAY3                       "Number of days from admission to PR3"
 PRDAY4                       "Number of days from admission to PR4"
 PRDAY5                       "Number of days from admission to PR5"
 PRDAY6                       "Number of days from admission to PR6"
 PRDAY7                       "Number of days from admission to PR7"
 PRDAY8                       "Number of days from admission to PR8"
 PRDAY9                       "Number of days from admission to PR9"
 PRDAY10                      "Number of days from admission to PR10"
 PRDAY11                      "Number of days from admission to PR11"
 PRDAY12                      "Number of days from admission to PR12"
 PRDAY13                      "Number of days from admission to PR13"
 PRDAY14                      "Number of days from admission to PR14"
 PRDAY15                      "Number of days from admission to PR15"
 PRDAY16                      "Number of days from admission to PR16"
 PRDAY17                      "Number of days from admission to PR17"
 PRDAY18                      "Number of days from admission to PR18"
 PRDAY19                      "Number of days from admission to PR19"
 PRDAY20                      "Number of days from admission to PR20"
 PRDAY21                      "Number of days from admission to PR21"
 PRDAY22                      "Number of days from admission to PR22"
 PRDAY23                      "Number of days from admission to PR23"
 PRDAY24                      "Number of days from admission to PR24"
 PRDAY25                      "Number of days from admission to PR25"
 PRDAY26                      "Number of days from admission to PR26"
 PRDAY27                      "Number of days from admission to PR27"
 PRDAY28                      "Number of days from admission to PR28"
 PRDAY29                      "Number of days from admission to PR29"
 PRDAY30                      "Number of days from admission to PR30"
 PROCTYPE                     "Procedure type indicator"
 PSTATE                       "Patient State postal code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 ZIP                          "Patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysCCU
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysICU
 (-99,-88,-66,-55=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MOMNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MI_SID_2013_CORE.SAV' /COMPRESSED.
