/*******************************************************************
* Creation Date: 07/20/2017   
*   MI_SID_2015q4_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MI_SID_2015q4_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 DIED                           16-  17
 DISP_X                         18-  19 (A)
 DISPUB04                       20-  21
 DISPUNIFORM                    22-  23
 DMONTH                         24-  25
 DQTR                           26-  27
 DRG                            28-  30
 DRG_NoPOA                      31-  33
 DRG32                          34-  36
 DRGVER                         37-  38
 DXPOA1                         39     (A)
 DXPOA2                         40     (A)
 DXPOA3                         41     (A)
 DXPOA4                         42     (A)
 DXPOA5                         43     (A)
 DXPOA6                         44     (A)
 DXPOA7                         45     (A)
 DXPOA8                         46     (A)
 DXPOA9                         47     (A)
 DXPOA10                        48     (A)
 DXPOA11                        49     (A)
 DXPOA12                        50     (A)
 DXPOA13                        51     (A)
 DXPOA14                        52     (A)
 DXPOA15                        53     (A)
 DXPOA16                        54     (A)
 DXPOA17                        55     (A)
 DXPOA18                        56     (A)
 DXPOA19                        57     (A)
 DXPOA20                        58     (A)
 DXPOA21                        59     (A)
 DXPOA22                        60     (A)
 DXPOA23                        61     (A)
 DXPOA24                        62     (A)
 DXPOA25                        63     (A)
 DXPOA26                        64     (A)
 DXPOA27                        65     (A)
 DXPOA28                        66     (A)
 DXPOA29                        67     (A)
 DXPOA30                        68     (A)
 DXVER                          69-  71
 E_POA1                         72     (A)
 E_POA2                         73     (A)
 E_POA3                         74     (A)
 E_POA4                         75     (A)
 E_POA5                         76     (A)
 E_POA6                         77     (A)
 E_POA7                         78     (A)
 E_POA8                         79     (A)
 E_POA9                         80     (A)
 E_POA10                        81     (A)
 FEMALE                         82-  83
 HCUP_ED                        84-  85
 HCUP_OS                        86-  87
 HISPANIC                       88-  89
 HISPANIC_X                     90     (A)
 HOSPST                         91-  92 (A)
 I10_DX_Admitting               93-  99 (A)
 I10_DX1                       100- 106 (A)
 I10_DX2                       107- 113 (A)
 I10_DX3                       114- 120 (A)
 I10_DX4                       121- 127 (A)
 I10_DX5                       128- 134 (A)
 I10_DX6                       135- 141 (A)
 I10_DX7                       142- 148 (A)
 I10_DX8                       149- 155 (A)
 I10_DX9                       156- 162 (A)
 I10_DX10                      163- 169 (A)
 I10_DX11                      170- 176 (A)
 I10_DX12                      177- 183 (A)
 I10_DX13                      184- 190 (A)
 I10_DX14                      191- 197 (A)
 I10_DX15                      198- 204 (A)
 I10_DX16                      205- 211 (A)
 I10_DX17                      212- 218 (A)
 I10_DX18                      219- 225 (A)
 I10_DX19                      226- 232 (A)
 I10_DX20                      233- 239 (A)
 I10_DX21                      240- 246 (A)
 I10_DX22                      247- 253 (A)
 I10_DX23                      254- 260 (A)
 I10_DX24                      261- 267 (A)
 I10_DX25                      268- 274 (A)
 I10_DX26                      275- 281 (A)
 I10_DX27                      282- 288 (A)
 I10_DX28                      289- 295 (A)
 I10_DX29                      296- 302 (A)
 I10_DX30                      303- 309 (A)
 I10_DXCCS1                    310- 313
 I10_DXCCS2                    314- 317
 I10_DXCCS3                    318- 321
 I10_DXCCS4                    322- 325
 I10_DXCCS5                    326- 329
 I10_DXCCS6                    330- 333
 I10_DXCCS7                    334- 337
 I10_DXCCS8                    338- 341
 I10_DXCCS9                    342- 345
 I10_DXCCS10                   346- 349
 I10_DXCCS11                   350- 353
 I10_DXCCS12                   354- 357
 I10_DXCCS13                   358- 361
 I10_DXCCS14                   362- 365
 I10_DXCCS15                   366- 369
 I10_DXCCS16                   370- 373
 I10_DXCCS17                   374- 377
 I10_DXCCS18                   378- 381
 I10_DXCCS19                   382- 385
 I10_DXCCS20                   386- 389
 I10_DXCCS21                   390- 393
 I10_DXCCS22                   394- 397
 I10_DXCCS23                   398- 401
 I10_DXCCS24                   402- 405
 I10_DXCCS25                   406- 409
 I10_DXCCS26                   410- 413
 I10_DXCCS27                   414- 417
 I10_DXCCS28                   418- 421
 I10_DXCCS29                   422- 425
 I10_DXCCS30                   426- 429
 I10_ECAUSE1                   430- 436 (A)
 I10_ECAUSE2                   437- 443 (A)
 I10_ECAUSE3                   444- 450 (A)
 I10_ECAUSE4                   451- 457 (A)
 I10_ECAUSE5                   458- 464 (A)
 I10_ECAUSE6                   465- 471 (A)
 I10_ECAUSE7                   472- 478 (A)
 I10_ECAUSE8                   479- 485 (A)
 I10_ECAUSE9                   486- 492 (A)
 I10_ECAUSE10                  493- 499 (A)
 I10_ECauseCCS1                500- 503
 I10_ECauseCCS2                504- 507
 I10_ECauseCCS3                508- 511
 I10_ECauseCCS4                512- 515
 I10_ECauseCCS5                516- 519
 I10_ECauseCCS6                520- 523
 I10_ECauseCCS7                524- 527
 I10_ECauseCCS8                528- 531
 I10_ECauseCCS9                532- 535
 I10_ECauseCCS10               536- 539
 I10_HOSPBRTH                  540- 542
 I10_NCHRONIC                  543- 545
 I10_NDX                       546- 548
 I10_NECAUSE                   549- 550
 I10_NEOMAT                    551- 552
 I10_NPR                       553- 555
 I10_ORPROC                    556- 557
 I10_PR1                       558- 564 (A)
 I10_PR2                       565- 571 (A)
 I10_PR3                       572- 578 (A)
 I10_PR4                       579- 585 (A)
 I10_PR5                       586- 592 (A)
 I10_PR6                       593- 599 (A)
 I10_PR7                       600- 606 (A)
 I10_PR8                       607- 613 (A)
 I10_PR9                       614- 620 (A)
 I10_PR10                      621- 627 (A)
 I10_PR11                      628- 634 (A)
 I10_PR12                      635- 641 (A)
 I10_PR13                      642- 648 (A)
 I10_PR14                      649- 655 (A)
 I10_PR15                      656- 662 (A)
 I10_PR16                      663- 669 (A)
 I10_PR17                      670- 676 (A)
 I10_PR18                      677- 683 (A)
 I10_PR19                      684- 690 (A)
 I10_PR20                      691- 697 (A)
 I10_PR21                      698- 704 (A)
 I10_PR22                      705- 711 (A)
 I10_PR23                      712- 718 (A)
 I10_PR24                      719- 725 (A)
 I10_PR25                      726- 732 (A)
 I10_PR26                      733- 739 (A)
 I10_PR27                      740- 746 (A)
 I10_PR28                      747- 753 (A)
 I10_PR29                      754- 760 (A)
 I10_PR30                      761- 767 (A)
 I10_PRCCS1                    768- 770
 I10_PRCCS2                    771- 773
 I10_PRCCS3                    774- 776
 I10_PRCCS4                    777- 779
 I10_PRCCS5                    780- 782
 I10_PRCCS6                    783- 785
 I10_PRCCS7                    786- 788
 I10_PRCCS8                    789- 791
 I10_PRCCS9                    792- 794
 I10_PRCCS10                   795- 797
 I10_PRCCS11                   798- 800
 I10_PRCCS12                   801- 803
 I10_PRCCS13                   804- 806
 I10_PRCCS14                   807- 809
 I10_PRCCS15                   810- 812
 I10_PRCCS16                   813- 815
 I10_PRCCS17                   816- 818
 I10_PRCCS18                   819- 821
 I10_PRCCS19                   822- 824
 I10_PRCCS20                   825- 827
 I10_PRCCS21                   828- 830
 I10_PRCCS22                   831- 833
 I10_PRCCS23                   834- 836
 I10_PRCCS24                   837- 839
 I10_PRCCS25                   840- 842
 I10_PRCCS26                   843- 845
 I10_PRCCS27                   846- 848
 I10_PRCCS28                   849- 851
 I10_PRCCS29                   852- 854
 I10_PRCCS30                   855- 857
 I10_PROCTYPE                  858- 860
 I10_SERVICELINE               861- 862
 KEY                           863- 877
 LOS                           878- 882
 LOS_X                         883- 888
 MDC                           889- 890
 MDC_NoPOA                     891- 892
 MDC32                         893- 894
 MDNUM1_R                      895- 903
 MEDINCSTQ                     904- 905
 MOMNUM_R                      906- 914
 MRN_R                         915- 923
 PAY1                          924- 925
 PAY1_X                        926- 927 (A)
 PAY2                          928- 929
 PAY2_X                        930- 931 (A)
 PL_CBSA                       932- 934
 PL_NCHS                       935- 936
 PL_RUCC                       937- 938
 PL_UIC                        939- 940
 PL_UR_CAT4                    941- 942
 POA_Disch_Edit1               943- 944
 POA_Disch_Edit2               945- 946
 POA_Hosp_Edit1                947- 948
 POA_Hosp_Edit2                949- 950
 POA_Hosp_Edit3                951- 952
 POA_Hosp_Edit3_Value          953- 960
 PointOfOrigin_X               961     (A)
 PointOfOriginUB04             962     (A)
 PRDAY1                        963- 967
 PRDAY2                        968- 972
 PRDAY3                        973- 977
 PRDAY4                        978- 982
 PRDAY5                        983- 987
 PRDAY6                        988- 992
 PRDAY7                        993- 997
 PRDAY8                        998-1002
 PRDAY9                       1003-1007
 PRDAY10                      1008-1012
 PRDAY11                      1013-1017
 PRDAY12                      1018-1022
 PRDAY13                      1023-1027
 PRDAY14                      1028-1032
 PRDAY15                      1033-1037
 PRDAY16                      1038-1042
 PRDAY17                      1043-1047
 PRDAY18                      1048-1052
 PRDAY19                      1053-1057
 PRDAY20                      1058-1062
 PRDAY21                      1063-1067
 PRDAY22                      1068-1072
 PRDAY23                      1073-1077
 PRDAY24                      1078-1082
 PRDAY25                      1083-1087
 PRDAY26                      1088-1092
 PRDAY27                      1093-1097
 PRDAY28                      1098-1102
 PRDAY29                      1103-1107
 PRDAY30                      1108-1112
 PRVER                        1113-1115
 PSTATE                       1116-1117 (A)
 PSTCO2                       1118-1122
 RACE                         1123-1124
 RACE_X                       1125     (A)
 TOTCHG                       1126-1135
 TOTCHG_X                     1136-1150
 TRAN_IN                      1151-1152
 TRAN_OUT                     1153-1154
 YEAR                         1155-1158
 ZIP                          1159-1163 (A)
 ZIP3                         1164-1166 (A)
 ZIPINC_QRTL                  1167-1169
 HOSPID                       1170-1174
 AYEAR                        1175-1178
 BMONTH                       1179-1180
 BYEAR                        1181-1184
 PRMONTH1                     1185-1186
 PRMONTH2                     1187-1188
 PRMONTH3                     1189-1190
 PRMONTH4                     1191-1192
 PRMONTH5                     1193-1194
 PRMONTH6                     1195-1196
 PRMONTH7                     1197-1198
 PRMONTH8                     1199-1200
 PRMONTH9                     1201-1202
 PRMONTH10                    1203-1204
 PRMONTH11                    1205-1206
 PRMONTH12                    1207-1208
 PRMONTH13                    1209-1210
 PRMONTH14                    1211-1212
 PRMONTH15                    1213-1214
 PRMONTH16                    1215-1216
 PRMONTH17                    1217-1218
 PRMONTH18                    1219-1220
 PRMONTH19                    1221-1222
 PRMONTH20                    1223-1224
 PRMONTH21                    1225-1226
 PRMONTH22                    1227-1228
 PRMONTH23                    1229-1230
 PRMONTH24                    1231-1232
 PRMONTH25                    1233-1234
 PRMONTH26                    1235-1236
 PRMONTH27                    1237-1238
 PRMONTH28                    1239-1240
 PRMONTH29                    1241-1242
 PRMONTH30                    1243-1244
 PRYEAR1                      1245-1248
 PRYEAR2                      1249-1252
 PRYEAR3                      1253-1256
 PRYEAR4                      1257-1260
 PRYEAR5                      1261-1264
 PRYEAR6                      1265-1268
 PRYEAR7                      1269-1272
 PRYEAR8                      1273-1276
 PRYEAR9                      1277-1280
 PRYEAR10                     1281-1284
 PRYEAR11                     1285-1288
 PRYEAR12                     1289-1292
 PRYEAR13                     1293-1296
 PRYEAR14                     1297-1300
 PRYEAR15                     1301-1304
 PRYEAR16                     1305-1308
 PRYEAR17                     1309-1312
 PRYEAR18                     1313-1316
 PRYEAR19                     1317-1320
 PRYEAR20                     1321-1324
 PRYEAR21                     1325-1328
 PRYEAR22                     1329-1332
 PRYEAR23                     1333-1336
 PRYEAR24                     1337-1340
 PRYEAR25                     1341-1344
 PRYEAR26                     1345-1348
 PRYEAR27                     1349-1352
 PRYEAR28                     1353-1356
 PRYEAR29                     1357-1360
 PRYEAR30                     1361-1364.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRG32                        (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_DXCCS1                   (F4.0) /
 I10_DXCCS2                   (F4.0) /
 I10_DXCCS3                   (F4.0) /
 I10_DXCCS4                   (F4.0) /
 I10_DXCCS5                   (F4.0) /
 I10_DXCCS6                   (F4.0) /
 I10_DXCCS7                   (F4.0) /
 I10_DXCCS8                   (F4.0) /
 I10_DXCCS9                   (F4.0) /
 I10_DXCCS10                  (F4.0) /
 I10_DXCCS11                  (F4.0) /
 I10_DXCCS12                  (F4.0) /
 I10_DXCCS13                  (F4.0) /
 I10_DXCCS14                  (F4.0) /
 I10_DXCCS15                  (F4.0) /
 I10_DXCCS16                  (F4.0) /
 I10_DXCCS17                  (F4.0) /
 I10_DXCCS18                  (F4.0) /
 I10_DXCCS19                  (F4.0) /
 I10_DXCCS20                  (F4.0) /
 I10_DXCCS21                  (F4.0) /
 I10_DXCCS22                  (F4.0) /
 I10_DXCCS23                  (F4.0) /
 I10_DXCCS24                  (F4.0) /
 I10_DXCCS25                  (F4.0) /
 I10_DXCCS26                  (F4.0) /
 I10_DXCCS27                  (F4.0) /
 I10_DXCCS28                  (F4.0) /
 I10_DXCCS29                  (F4.0) /
 I10_DXCCS30                  (F4.0) /
 I10_ECauseCCS1               (F3.0) /
 I10_ECauseCCS2               (F3.0) /
 I10_ECauseCCS3               (F3.0) /
 I10_ECauseCCS4               (F3.0) /
 I10_ECauseCCS5               (F3.0) /
 I10_ECauseCCS6               (F3.0) /
 I10_ECauseCCS7               (F3.0) /
 I10_ECauseCCS8               (F3.0) /
 I10_ECauseCCS9               (F3.0) /
 I10_ECauseCCS10              (F3.0) /
 I10_HOSPBRTH                 (F3.0) /
 I10_NCHRONIC                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NEOMAT                   (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PRCCS1                   (F3.0) /
 I10_PRCCS2                   (F3.0) /
 I10_PRCCS3                   (F3.0) /
 I10_PRCCS4                   (F3.0) /
 I10_PRCCS5                   (F3.0) /
 I10_PRCCS6                   (F3.0) /
 I10_PRCCS7                   (F3.0) /
 I10_PRCCS8                   (F3.0) /
 I10_PRCCS9                   (F3.0) /
 I10_PRCCS10                  (F3.0) /
 I10_PRCCS11                  (F3.0) /
 I10_PRCCS12                  (F3.0) /
 I10_PRCCS13                  (F3.0) /
 I10_PRCCS14                  (F3.0) /
 I10_PRCCS15                  (F3.0) /
 I10_PRCCS16                  (F3.0) /
 I10_PRCCS17                  (F3.0) /
 I10_PRCCS18                  (F3.0) /
 I10_PRCCS19                  (F3.0) /
 I10_PRCCS20                  (F3.0) /
 I10_PRCCS21                  (F3.0) /
 I10_PRCCS22                  (F3.0) /
 I10_PRCCS23                  (F3.0) /
 I10_PRCCS24                  (F3.0) /
 I10_PRCCS25                  (F3.0) /
 I10_PRCCS26                  (F3.0) /
 I10_PRCCS27                  (F3.0) /
 I10_PRCCS28                  (F3.0) /
 I10_PRCCS29                  (F3.0) /
 I10_PRCCS30                  (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDC32                        (F3.0) /
 MDNUM1_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MOMNUM_R                     (F5.0) /
 MRN_R                        (F5.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PRDAY26                      (F4.0) /
 PRDAY27                      (F4.0) /
 PRDAY28                      (F4.0) /
 PRDAY29                      (F4.0) /
 PRDAY30                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRMONTH26                    (F3.0) /
 PRMONTH27                    (F3.0) /
 PRMONTH28                    (F3.0) /
 PRMONTH29                    (F3.0) /
 PRMONTH30                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) /
 PRYEAR26                     (F3.0) /
 PRYEAR27                     (F3.0) /
 PRYEAR28                     (F3.0) /
 PRYEAR29                     (F3.0) /
 PRYEAR30                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRG32                        "DRG, version 32"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "E Cause 1, present on admission indicator"
 E_POA2                       "E Cause 2, present on admission indicator"
 E_POA3                       "E Cause 3, present on admission indicator"
 E_POA4                       "E Cause 4, present on admission indicator"
 E_POA5                       "E Cause 5, present on admission indicator"
 E_POA6                       "E Cause 6, present on admission indicator"
 E_POA7                       "E Cause 7, present on admission indicator"
 E_POA8                       "E Cause 8, present on admission indicator"
 E_POA9                       "E Cause 9, present on admission indicator"
 E_POA10                      "E Cause 10, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DXCCS1                   "ICD-10-CM CCS: diagnosis 1"
 I10_DXCCS2                   "ICD-10-CM CCS: diagnosis 2"
 I10_DXCCS3                   "ICD-10-CM CCS: diagnosis 3"
 I10_DXCCS4                   "ICD-10-CM CCS: diagnosis 4"
 I10_DXCCS5                   "ICD-10-CM CCS: diagnosis 5"
 I10_DXCCS6                   "ICD-10-CM CCS: diagnosis 6"
 I10_DXCCS7                   "ICD-10-CM CCS: diagnosis 7"
 I10_DXCCS8                   "ICD-10-CM CCS: diagnosis 8"
 I10_DXCCS9                   "ICD-10-CM CCS: diagnosis 9"
 I10_DXCCS10                  "ICD-10-CM CCS: diagnosis 10"
 I10_DXCCS11                  "ICD-10-CM CCS: diagnosis 11"
 I10_DXCCS12                  "ICD-10-CM CCS: diagnosis 12"
 I10_DXCCS13                  "ICD-10-CM CCS: diagnosis 13"
 I10_DXCCS14                  "ICD-10-CM CCS: diagnosis 14"
 I10_DXCCS15                  "ICD-10-CM CCS: diagnosis 15"
 I10_DXCCS16                  "ICD-10-CM CCS: diagnosis 16"
 I10_DXCCS17                  "ICD-10-CM CCS: diagnosis 17"
 I10_DXCCS18                  "ICD-10-CM CCS: diagnosis 18"
 I10_DXCCS19                  "ICD-10-CM CCS: diagnosis 19"
 I10_DXCCS20                  "ICD-10-CM CCS: diagnosis 20"
 I10_DXCCS21                  "ICD-10-CM CCS: diagnosis 21"
 I10_DXCCS22                  "ICD-10-CM CCS: diagnosis 22"
 I10_DXCCS23                  "ICD-10-CM CCS: diagnosis 23"
 I10_DXCCS24                  "ICD-10-CM CCS: diagnosis 24"
 I10_DXCCS25                  "ICD-10-CM CCS: diagnosis 25"
 I10_DXCCS26                  "ICD-10-CM CCS: diagnosis 26"
 I10_DXCCS27                  "ICD-10-CM CCS: diagnosis 27"
 I10_DXCCS28                  "ICD-10-CM CCS: diagnosis 28"
 I10_DXCCS29                  "ICD-10-CM CCS: diagnosis 29"
 I10_DXCCS30                  "ICD-10-CM CCS: diagnosis 30"
 I10_ECAUSE1                  "ICD-10-CM E Cause 1"
 I10_ECAUSE2                  "ICD-10-CM E Cause 2"
 I10_ECAUSE3                  "ICD-10-CM E Cause 3"
 I10_ECAUSE4                  "ICD-10-CM E Cause 4"
 I10_ECAUSE5                  "ICD-10-CM E Cause 5"
 I10_ECAUSE6                  "ICD-10-CM E Cause 6"
 I10_ECAUSE7                  "ICD-10-CM E Cause 7"
 I10_ECAUSE8                  "ICD-10-CM E Cause 8"
 I10_ECAUSE9                  "ICD-10-CM E Cause 9"
 I10_ECAUSE10                 "ICD-10-CM E Cause 10"
 I10_ECauseCCS1               "ICD-10-CM CCS: E Cause 1"
 I10_ECauseCCS2               "ICD-10-CM CCS: E Cause 2"
 I10_ECauseCCS3               "ICD-10-CM CCS: E Cause 3"
 I10_ECauseCCS4               "ICD-10-CM CCS: E Cause 4"
 I10_ECauseCCS5               "ICD-10-CM CCS: E Cause 5"
 I10_ECauseCCS6               "ICD-10-CM CCS: E Cause 6"
 I10_ECauseCCS7               "ICD-10-CM CCS: E Cause 7"
 I10_ECauseCCS8               "ICD-10-CM CCS: E Cause 8"
 I10_ECauseCCS9               "ICD-10-CM CCS: E Cause 9"
 I10_ECauseCCS10              "ICD-10-CM CCS: E Cause 10"
 I10_HOSPBRTH                 "ICD-10-CM Indicator of birth in this hospital"
 I10_NCHRONIC                 "ICD-10-CM Number of chronic conditions"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of E Causes on this record"
 I10_NEOMAT                   "ICD-10-CM/PCS Neonatal and/or maternal I10_DX and/or I10_PR"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PRCCS1                   "ICD-10-PCS CCS: procedure 1"
 I10_PRCCS2                   "ICD-10-PCS CCS: procedure 2"
 I10_PRCCS3                   "ICD-10-PCS CCS: procedure 3"
 I10_PRCCS4                   "ICD-10-PCS CCS: procedure 4"
 I10_PRCCS5                   "ICD-10-PCS CCS: procedure 5"
 I10_PRCCS6                   "ICD-10-PCS CCS: procedure 6"
 I10_PRCCS7                   "ICD-10-PCS CCS: procedure 7"
 I10_PRCCS8                   "ICD-10-PCS CCS: procedure 8"
 I10_PRCCS9                   "ICD-10-PCS CCS: procedure 9"
 I10_PRCCS10                  "ICD-10-PCS CCS: procedure 10"
 I10_PRCCS11                  "ICD-10-PCS CCS: procedure 11"
 I10_PRCCS12                  "ICD-10-PCS CCS: procedure 12"
 I10_PRCCS13                  "ICD-10-PCS CCS: procedure 13"
 I10_PRCCS14                  "ICD-10-PCS CCS: procedure 14"
 I10_PRCCS15                  "ICD-10-PCS CCS: procedure 15"
 I10_PRCCS16                  "ICD-10-PCS CCS: procedure 16"
 I10_PRCCS17                  "ICD-10-PCS CCS: procedure 17"
 I10_PRCCS18                  "ICD-10-PCS CCS: procedure 18"
 I10_PRCCS19                  "ICD-10-PCS CCS: procedure 19"
 I10_PRCCS20                  "ICD-10-PCS CCS: procedure 20"
 I10_PRCCS21                  "ICD-10-PCS CCS: procedure 21"
 I10_PRCCS22                  "ICD-10-PCS CCS: procedure 22"
 I10_PRCCS23                  "ICD-10-PCS CCS: procedure 23"
 I10_PRCCS24                  "ICD-10-PCS CCS: procedure 24"
 I10_PRCCS25                  "ICD-10-PCS CCS: procedure 25"
 I10_PRCCS26                  "ICD-10-PCS CCS: procedure 26"
 I10_PRCCS27                  "ICD-10-PCS CCS: procedure 27"
 I10_PRCCS28                  "ICD-10-PCS CCS: procedure 28"
 I10_PRCCS29                  "ICD-10-PCS CCS: procedure 29"
 I10_PRCCS30                  "ICD-10-PCS CCS: procedure 30"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDC32                        "MDC, version 32"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MOMNUM_R                     "Mother's number (re-identified)"
 MRN_R                        "Medical record number (re-identified)"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2
"Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1
"Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2
"Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value
"Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PRDAY26                      "Number of days from admission to I10_PR26"
 PRDAY27                      "Number of days from admission to I10_PR27"
 PRDAY28                      "Number of days from admission to I10_PR28"
 PRDAY29                      "Number of days from admission to I10_PR29"
 PRDAY30                      "Number of days from admission to I10_PR30"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRMONTH26                    "Month of procedure 26"
 PRMONTH27                    "Month of procedure 27"
 PRMONTH28                    "Month of procedure 28"
 PRMONTH29                    "Month of procedure 29"
 PRMONTH30                    "Month of procedure 30"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25"
 PRYEAR26                     "Year of procedure 26"
 PRYEAR27                     "Year of procedure 27"
 PRYEAR28                     "Year of procedure 28"
 PRYEAR29                     "Year of procedure 29"
 PRYEAR30                     "Year of procedure 30" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG32
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC32
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MOMNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'MI_SID_2015q4_CORE.SAV' /COMPRESSED.
