/*******************************************************************
* Creation Date: 04/01/2019   
*   MN_SID_2011_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MN_SID_2011_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 CHRON1                          1-   2
 CHRON2                          3-   4
 CHRON3                          5-   6
 CHRON4                          7-   8
 CHRON5                          9-  10
 CHRON6                         11-  12
 CHRON7                         13-  14
 CHRON8                         15-  16
 CHRON9                         17-  18
 CHRON10                        19-  20
 CHRON11                        21-  22
 CHRON12                        23-  24
 CHRON13                        25-  26
 CHRON14                        27-  28
 CHRON15                        29-  30
 CHRON16                        31-  32
 CHRON17                        33-  34
 CHRON18                        35-  36
 CHRON19                        37-  38
 CHRON20                        39-  40
 CHRON21                        41-  42
 CHRON22                        43-  44
 CHRON23                        45-  46
 CHRON24                        47-  48
 CHRON25                        49-  50
 CHRON26                        51-  52
 CHRON27                        53-  54
 CHRON28                        55-  56
 CHRON29                        57-  58
 CHRON30                        59-  60
 CHRON31                        61-  62
 CHRON32                        63-  64
 CHRON33                        65-  66
 CHRON34                        67-  68
 CHRON35                        69-  70
 CHRON36                        71-  72
 CHRON37                        73-  74
 CHRON38                        75-  76
 CHRON39                        77-  78
 CHRON40                        79-  80
 CHRONB1                        81-  82
 CHRONB2                        83-  84
 CHRONB3                        85-  86
 CHRONB4                        87-  88
 CHRONB5                        89-  90
 CHRONB6                        91-  92
 CHRONB7                        93-  94
 CHRONB8                        95-  96
 CHRONB9                        97-  98
 CHRONB10                       99- 100
 CHRONB11                      101- 102
 CHRONB12                      103- 104
 CHRONB13                      105- 106
 CHRONB14                      107- 108
 CHRONB15                      109- 110
 CHRONB16                      111- 112
 CHRONB17                      113- 114
 CHRONB18                      115- 116
 CHRONB19                      117- 118
 CHRONB20                      119- 120
 CHRONB21                      121- 122
 CHRONB22                      123- 124
 CHRONB23                      125- 126
 CHRONB24                      127- 128
 CHRONB25                      129- 130
 CHRONB26                      131- 132
 CHRONB27                      133- 134
 CHRONB28                      135- 136
 CHRONB29                      137- 138
 CHRONB30                      139- 140
 CHRONB31                      141- 142
 CHRONB32                      143- 144
 CHRONB33                      145- 146
 CHRONB34                      147- 148
 CHRONB35                      149- 150
 CHRONB36                      151- 152
 CHRONB37                      153- 154
 CHRONB38                      155- 156
 CHRONB39                      157- 158
 CHRONB40                      159- 160
 DXMCCS1                       161- 171 (A)
 DXMCCS2                       172- 182 (A)
 DXMCCS3                       183- 193 (A)
 DXMCCS4                       194- 204 (A)
 DXMCCS5                       205- 215 (A)
 DXMCCS6                       216- 226 (A)
 DXMCCS7                       227- 237 (A)
 DXMCCS8                       238- 248 (A)
 DXMCCS9                       249- 259 (A)
 DXMCCS10                      260- 270 (A)
 DXMCCS11                      271- 281 (A)
 DXMCCS12                      282- 292 (A)
 DXMCCS13                      293- 303 (A)
 DXMCCS14                      304- 314 (A)
 DXMCCS15                      315- 325 (A)
 DXMCCS16                      326- 336 (A)
 DXMCCS17                      337- 347 (A)
 DXMCCS18                      348- 358 (A)
 DXMCCS19                      359- 369 (A)
 DXMCCS20                      370- 380 (A)
 DXMCCS21                      381- 391 (A)
 DXMCCS22                      392- 402 (A)
 DXMCCS23                      403- 413 (A)
 DXMCCS24                      414- 424 (A)
 DXMCCS25                      425- 435 (A)
 DXMCCS26                      436- 446 (A)
 DXMCCS27                      447- 457 (A)
 DXMCCS28                      458- 468 (A)
 DXMCCS29                      469- 479 (A)
 DXMCCS30                      480- 490 (A)
 DXMCCS31                      491- 501 (A)
 DXMCCS32                      502- 512 (A)
 DXMCCS33                      513- 523 (A)
 DXMCCS34                      524- 534 (A)
 DXMCCS35                      535- 545 (A)
 DXMCCS36                      546- 556 (A)
 DXMCCS37                      557- 567 (A)
 DXMCCS38                      568- 578 (A)
 DXMCCS39                      579- 589 (A)
 DXMCCS40                      590- 600 (A)
 E_MCCS1                       601- 611 (A)
 E_MCCS2                       612- 622 (A)
 E_MCCS3                       623- 633 (A)
 E_MCCS4                       634- 644 (A)
 E_MCCS5                       645- 655 (A)
 E_MCCS6                       656- 666 (A)
 E_MCCS7                       667- 677 (A)
 E_MCCS8                       678- 688 (A)
 INJURY                        689- 690
 INJURY_CUT                    691- 692
 INJURY_DROWN                  693- 694
 INJURY_FALL                   695- 696
 INJURY_FIRE                   697- 698
 INJURY_FIREARM                699- 700
 INJURY_MACHINERY              701- 702
 INJURY_MVT                    703- 704
 INJURY_NATURE                 705- 706
 INJURY_POISON                 707- 708
 INJURY_STRUCK                 709- 710
 INJURY_SUFFOCATION            711- 712
 INTENT_ASSAULT                713- 714
 INTENT_SELF_HARM              715- 716
 INTENT_UNINTENTIONAL          717- 718
 KEY                           719- 733
 MULTINJURY                    734- 735
 PCLASS1                       736- 737
 PCLASS2                       738- 739
 PCLASS3                       740- 741
 PCLASS4                       742- 743
 PCLASS5                       744- 745
 PCLASS6                       746- 747
 PCLASS7                       748- 749
 PCLASS8                       750- 751
 PCLASS9                       752- 753
 PCLASS10                      754- 755
 PCLASS11                      756- 757
 PCLASS12                      758- 759
 PCLASS13                      760- 761
 PCLASS14                      762- 763
 PCLASS15                      764- 765
 PCLASS16                      766- 767
 PCLASS17                      768- 769
 PCLASS18                      770- 771
 PCLASS19                      772- 773
 PCLASS20                      774- 775
 PCLASS21                      776- 777
 PCLASS22                      778- 779
 PCLASS23                      780- 781
 PCLASS24                      782- 783
 PCLASS25                      784- 785
 PCLASS26                      786- 787
 PCLASS27                      788- 789
 PCLASS28                      790- 791
 PCLASS29                      792- 793
 PCLASS30                      794- 795
 PCLASS31                      796- 797
 PCLASS32                      798- 799
 PCLASS33                      800- 801
 PCLASS34                      802- 803
 PCLASS35                      804- 805
 PCLASS36                      806- 807
 PCLASS37                      808- 809
 PCLASS38                      810- 811
 PCLASS39                      812- 813
 PCLASS40                      814- 815
 PRMCCS1                       816- 823 (A)
 PRMCCS2                       824- 831 (A)
 PRMCCS3                       832- 839 (A)
 PRMCCS4                       840- 847 (A)
 PRMCCS5                       848- 855 (A)
 PRMCCS6                       856- 863 (A)
 PRMCCS7                       864- 871 (A)
 PRMCCS8                       872- 879 (A)
 PRMCCS9                       880- 887 (A)
 PRMCCS10                      888- 895 (A)
 PRMCCS11                      896- 903 (A)
 PRMCCS12                      904- 911 (A)
 PRMCCS13                      912- 919 (A)
 PRMCCS14                      920- 927 (A)
 PRMCCS15                      928- 935 (A)
 PRMCCS16                      936- 943 (A)
 PRMCCS17                      944- 951 (A)
 PRMCCS18                      952- 959 (A)
 PRMCCS19                      960- 967 (A)
 PRMCCS20                      968- 975 (A)
 PRMCCS21                      976- 983 (A)
 PRMCCS22                      984- 991 (A)
 PRMCCS23                      992- 999 (A)
 PRMCCS24                     1000-1007 (A)
 PRMCCS25                     1008-1015 (A)
 PRMCCS26                     1016-1023 (A)
 PRMCCS27                     1024-1031 (A)
 PRMCCS28                     1032-1039 (A)
 PRMCCS29                     1040-1047 (A)
 PRMCCS30                     1048-1055 (A)
 PRMCCS31                     1056-1063 (A)
 PRMCCS32                     1064-1071 (A)
 PRMCCS33                     1072-1079 (A)
 PRMCCS34                     1080-1087 (A)
 PRMCCS35                     1088-1095 (A)
 PRMCCS36                     1096-1103 (A)
 PRMCCS37                     1104-1111 (A)
 PRMCCS38                     1112-1119 (A)
 PRMCCS39                     1120-1127 (A)
 PRMCCS40                     1128-1135 (A)
 U_BLOOD                      1136-1137
 U_CATH                       1138-1139
 U_CCU                        1140-1141
 U_CHESTXRAY                  1142-1143
 U_CTSCAN                     1144-1145
 U_DIALYSIS                   1146-1147
 U_ECHO                       1148-1149
 U_ED                         1150-1151
 U_EEG                        1152-1153
 U_EKG                        1154-1155
 U_EPO                        1156-1157
 U_ICU                        1158-1159
 U_LITHOTRIPSY                1160-1161
 U_MHSA                       1162-1163
 U_MRT                        1164-1165
 U_NEWBN2L                    1166-1167
 U_NEWBN3L                    1168-1169
 U_NEWBN4L                    1170-1171
 U_NUCMED                     1172-1173
 U_OBSERVATION                1174-1175
 U_OCCTHERAPY                 1176-1177
 U_ORGANACQ                   1178-1179
 U_OTHIMPLANTS                1180-1181
 U_PACEMAKER                  1182-1183
 U_PHYTHERAPY                 1184-1185
 U_RADTHERAPY                 1186-1187
 U_RESPTHERAPY                1188-1189
 U_SPEECHTHERAPY              1190-1191
 U_STRESS                     1192-1193
 U_ULTRASOUND                 1194-1195.


***  Specify write formats  ***.
FORMATS
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRON16                      (F3.0) /
 CHRON17                      (F3.0) /
 CHRON18                      (F3.0) /
 CHRON19                      (F3.0) /
 CHRON20                      (F3.0) /
 CHRON21                      (F3.0) /
 CHRON22                      (F3.0) /
 CHRON23                      (F3.0) /
 CHRON24                      (F3.0) /
 CHRON25                      (F3.0) /
 CHRON26                      (F3.0) /
 CHRON27                      (F3.0) /
 CHRON28                      (F3.0) /
 CHRON29                      (F3.0) /
 CHRON30                      (F3.0) /
 CHRON31                      (F3.0) /
 CHRON32                      (F3.0) /
 CHRON33                      (F3.0) /
 CHRON34                      (F3.0) /
 CHRON35                      (F3.0) /
 CHRON36                      (F3.0) /
 CHRON37                      (F3.0) /
 CHRON38                      (F3.0) /
 CHRON39                      (F3.0) /
 CHRON40                      (F3.0) /
 CHRONB1                      (F3.0) /
 CHRONB2                      (F3.0) /
 CHRONB3                      (F3.0) /
 CHRONB4                      (F3.0) /
 CHRONB5                      (F3.0) /
 CHRONB6                      (F3.0) /
 CHRONB7                      (F3.0) /
 CHRONB8                      (F3.0) /
 CHRONB9                      (F3.0) /
 CHRONB10                     (F3.0) /
 CHRONB11                     (F3.0) /
 CHRONB12                     (F3.0) /
 CHRONB13                     (F3.0) /
 CHRONB14                     (F3.0) /
 CHRONB15                     (F3.0) /
 CHRONB16                     (F3.0) /
 CHRONB17                     (F3.0) /
 CHRONB18                     (F3.0) /
 CHRONB19                     (F3.0) /
 CHRONB20                     (F3.0) /
 CHRONB21                     (F3.0) /
 CHRONB22                     (F3.0) /
 CHRONB23                     (F3.0) /
 CHRONB24                     (F3.0) /
 CHRONB25                     (F3.0) /
 CHRONB26                     (F3.0) /
 CHRONB27                     (F3.0) /
 CHRONB28                     (F3.0) /
 CHRONB29                     (F3.0) /
 CHRONB30                     (F3.0) /
 CHRONB31                     (F3.0) /
 CHRONB32                     (F3.0) /
 CHRONB33                     (F3.0) /
 CHRONB34                     (F3.0) /
 CHRONB35                     (F3.0) /
 CHRONB36                     (F3.0) /
 CHRONB37                     (F3.0) /
 CHRONB38                     (F3.0) /
 CHRONB39                     (F3.0) /
 CHRONB40                     (F3.0) /
 INJURY                       (F3.0) /
 INJURY_CUT                   (F3.0) /
 INJURY_DROWN                 (F3.0) /
 INJURY_FALL                  (F3.0) /
 INJURY_FIRE                  (F3.0) /
 INJURY_FIREARM               (F3.0) /
 INJURY_MACHINERY             (F3.0) /
 INJURY_MVT                   (F3.0) /
 INJURY_NATURE                (F3.0) /
 INJURY_POISON                (F3.0) /
 INJURY_STRUCK                (F3.0) /
 INJURY_SUFFOCATION           (F3.0) /
 INTENT_ASSAULT               (F3.0) /
 INTENT_SELF_HARM             (F3.0) /
 INTENT_UNINTENTIONAL         (F3.0) /
 KEY                          (F8.0) /
 MULTINJURY                   (F3.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 PCLASS7                      (F3.0) /
 PCLASS8                      (F3.0) /
 PCLASS9                      (F3.0) /
 PCLASS10                     (F3.0) /
 PCLASS11                     (F3.0) /
 PCLASS12                     (F3.0) /
 PCLASS13                     (F3.0) /
 PCLASS14                     (F3.0) /
 PCLASS15                     (F3.0) /
 PCLASS16                     (F3.0) /
 PCLASS17                     (F3.0) /
 PCLASS18                     (F3.0) /
 PCLASS19                     (F3.0) /
 PCLASS20                     (F3.0) /
 PCLASS21                     (F3.0) /
 PCLASS22                     (F3.0) /
 PCLASS23                     (F3.0) /
 PCLASS24                     (F3.0) /
 PCLASS25                     (F3.0) /
 PCLASS26                     (F3.0) /
 PCLASS27                     (F3.0) /
 PCLASS28                     (F3.0) /
 PCLASS29                     (F3.0) /
 PCLASS30                     (F3.0) /
 PCLASS31                     (F3.0) /
 PCLASS32                     (F3.0) /
 PCLASS33                     (F3.0) /
 PCLASS34                     (F3.0) /
 PCLASS35                     (F3.0) /
 PCLASS36                     (F3.0) /
 PCLASS37                     (F3.0) /
 PCLASS38                     (F3.0) /
 PCLASS39                     (F3.0) /
 PCLASS40                     (F3.0) /
 U_BLOOD                      (F3.0) /
 U_CATH                       (F3.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_CTSCAN                     (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EKG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_MHSA                       (F3.0) /
 U_MRT                        (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_PACEMAKER                  (F3.0) /
 U_PHYTHERAPY                 (F3.0) /
 U_RADTHERAPY                 (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_STRESS                     (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRON16                      "Chronic condition indicator 16"
 CHRON17                      "Chronic condition indicator 17"
 CHRON18                      "Chronic condition indicator 18"
 CHRON19                      "Chronic condition indicator 19"
 CHRON20                      "Chronic condition indicator 20"
 CHRON21                      "Chronic condition indicator 21"
 CHRON22                      "Chronic condition indicator 22"
 CHRON23                      "Chronic condition indicator 23"
 CHRON24                      "Chronic condition indicator 24"
 CHRON25                      "Chronic condition indicator 25"
 CHRON26                      "Chronic condition indicator 26"
 CHRON27                      "Chronic condition indicator 27"
 CHRON28                      "Chronic condition indicator 28"
 CHRON29                      "Chronic condition indicator 29"
 CHRON30                      "Chronic condition indicator 30"
 CHRON31                      "Chronic condition indicator 31"
 CHRON32                      "Chronic condition indicator 32"
 CHRON33                      "Chronic condition indicator 33"
 CHRON34                      "Chronic condition indicator 34"
 CHRON35                      "Chronic condition indicator 35"
 CHRON36                      "Chronic condition indicator 36"
 CHRON37                      "Chronic condition indicator 37"
 CHRON38                      "Chronic condition indicator 38"
 CHRON39                      "Chronic condition indicator 39"
 CHRON40                      "Chronic condition indicator 40"
 CHRONB1                      "Chronic condition body system 1"
 CHRONB2                      "Chronic condition body system 2"
 CHRONB3                      "Chronic condition body system 3"
 CHRONB4                      "Chronic condition body system 4"
 CHRONB5                      "Chronic condition body system 5"
 CHRONB6                      "Chronic condition body system 6"
 CHRONB7                      "Chronic condition body system 7"
 CHRONB8                      "Chronic condition body system 8"
 CHRONB9                      "Chronic condition body system 9"
 CHRONB10                     "Chronic condition body system 10"
 CHRONB11                     "Chronic condition body system 11"
 CHRONB12                     "Chronic condition body system 12"
 CHRONB13                     "Chronic condition body system 13"
 CHRONB14                     "Chronic condition body system 14"
 CHRONB15                     "Chronic condition body system 15"
 CHRONB16                     "Chronic condition body system 16"
 CHRONB17                     "Chronic condition body system 17"
 CHRONB18                     "Chronic condition body system 18"
 CHRONB19                     "Chronic condition body system 19"
 CHRONB20                     "Chronic condition body system 20"
 CHRONB21                     "Chronic condition body system 21"
 CHRONB22                     "Chronic condition body system 22"
 CHRONB23                     "Chronic condition body system 23"
 CHRONB24                     "Chronic condition body system 24"
 CHRONB25                     "Chronic condition body system 25"
 CHRONB26                     "Chronic condition body system 26"
 CHRONB27                     "Chronic condition body system 27"
 CHRONB28                     "Chronic condition body system 28"
 CHRONB29                     "Chronic condition body system 29"
 CHRONB30                     "Chronic condition body system 30"
 CHRONB31                     "Chronic condition body system 31"
 CHRONB32                     "Chronic condition body system 32"
 CHRONB33                     "Chronic condition body system 33"
 CHRONB34                     "Chronic condition body system 34"
 CHRONB35                     "Chronic condition body system 35"
 CHRONB36                     "Chronic condition body system 36"
 CHRONB37                     "Chronic condition body system 37"
 CHRONB38                     "Chronic condition body system 38"
 CHRONB39                     "Chronic condition body system 39"
 CHRONB40                     "Chronic condition body system 40"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                     "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                     "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                     "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                     "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                     "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                     "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                     "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                     "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                     "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                     "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                     "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                     "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                     "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                     "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                     "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                     "Multi-Level CCS:  Diagnosis 31"
 DXMCCS32                     "Multi-Level CCS:  Diagnosis 32"
 DXMCCS33                     "Multi-Level CCS:  Diagnosis 33"
 DXMCCS34                     "Multi-Level CCS:  Diagnosis 34"
 DXMCCS35                     "Multi-Level CCS:  Diagnosis 35"
 DXMCCS36                     "Multi-Level CCS:  Diagnosis 36"
 DXMCCS37                     "Multi-Level CCS:  Diagnosis 37"
 DXMCCS38                     "Multi-Level CCS:  Diagnosis 38"
 DXMCCS39                     "Multi-Level CCS:  Diagnosis 39"
 DXMCCS40                     "Multi-Level CCS:  Diagnosis 40"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT                   "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN                 "Injury by drowning or submersion (by E codes)"
 INJURY_FALL                  "Injury by falling (by E codes)"
 INJURY_FIRE                  "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM               "Injury by firearm (by E codes)"
 INJURY_MACHINERY             "Injury by machinery (by E codes)"
 INJURY_MVT                   "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE                "Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON                "Injury by poison (by E codes)"
 INJURY_STRUCK                "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION           "Injury by suffocation (by E codes)"
 INTENT_ASSAULT               "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM             "Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL         "Unintentional injury indicated on the record (by E codes)"
 KEY                          "HCUP record identifier"
 MULTINJURY                   "More than one injury diagnosis reported on record"
 PCLASS1                      "Procedure class 1"
 PCLASS2                      "Procedure class 2"
 PCLASS3                      "Procedure class 3"
 PCLASS4                      "Procedure class 4"
 PCLASS5                      "Procedure class 5"
 PCLASS6                      "Procedure class 6"
 PCLASS7                      "Procedure class 7"
 PCLASS8                      "Procedure class 8"
 PCLASS9                      "Procedure class 9"
 PCLASS10                     "Procedure class 10"
 PCLASS11                     "Procedure class 11"
 PCLASS12                     "Procedure class 12"
 PCLASS13                     "Procedure class 13"
 PCLASS14                     "Procedure class 14"
 PCLASS15                     "Procedure class 15"
 PCLASS16                     "Procedure class 16"
 PCLASS17                     "Procedure class 17"
 PCLASS18                     "Procedure class 18"
 PCLASS19                     "Procedure class 19"
 PCLASS20                     "Procedure class 20"
 PCLASS21                     "Procedure class 21"
 PCLASS22                     "Procedure class 22"
 PCLASS23                     "Procedure class 23"
 PCLASS24                     "Procedure class 24"
 PCLASS25                     "Procedure class 25"
 PCLASS26                     "Procedure class 26"
 PCLASS27                     "Procedure class 27"
 PCLASS28                     "Procedure class 28"
 PCLASS29                     "Procedure class 29"
 PCLASS30                     "Procedure class 30"
 PCLASS31                     "Procedure class 31"
 PCLASS32                     "Procedure class 32"
 PCLASS33                     "Procedure class 33"
 PCLASS34                     "Procedure class 34"
 PCLASS35                     "Procedure class 35"
 PCLASS36                     "Procedure class 36"
 PCLASS37                     "Procedure class 37"
 PCLASS38                     "Procedure class 38"
 PCLASS39                     "Procedure class 39"
 PCLASS40                     "Procedure class 40"
 PRMCCS1                      "Multi-Level CCS:  Procedure 1"
 PRMCCS2                      "Multi-Level CCS:  Procedure 2"
 PRMCCS3                      "Multi-Level CCS:  Procedure 3"
 PRMCCS4                      "Multi-Level CCS:  Procedure 4"
 PRMCCS5                      "Multi-Level CCS:  Procedure 5"
 PRMCCS6                      "Multi-Level CCS:  Procedure 6"
 PRMCCS7                      "Multi-Level CCS:  Procedure 7"
 PRMCCS8                      "Multi-Level CCS:  Procedure 8"
 PRMCCS9                      "Multi-Level CCS:  Procedure 9"
 PRMCCS10                     "Multi-Level CCS:  Procedure 10"
 PRMCCS11                     "Multi-Level CCS:  Procedure 11"
 PRMCCS12                     "Multi-Level CCS:  Procedure 12"
 PRMCCS13                     "Multi-Level CCS:  Procedure 13"
 PRMCCS14                     "Multi-Level CCS:  Procedure 14"
 PRMCCS15                     "Multi-Level CCS:  Procedure 15"
 PRMCCS16                     "Multi-Level CCS:  Procedure 16"
 PRMCCS17                     "Multi-Level CCS:  Procedure 17"
 PRMCCS18                     "Multi-Level CCS:  Procedure 18"
 PRMCCS19                     "Multi-Level CCS:  Procedure 19"
 PRMCCS20                     "Multi-Level CCS:  Procedure 20"
 PRMCCS21                     "Multi-Level CCS:  Procedure 21"
 PRMCCS22                     "Multi-Level CCS:  Procedure 22"
 PRMCCS23                     "Multi-Level CCS:  Procedure 23"
 PRMCCS24                     "Multi-Level CCS:  Procedure 24"
 PRMCCS25                     "Multi-Level CCS:  Procedure 25"
 PRMCCS26                     "Multi-Level CCS:  Procedure 26"
 PRMCCS27                     "Multi-Level CCS:  Procedure 27"
 PRMCCS28                     "Multi-Level CCS:  Procedure 28"
 PRMCCS29                     "Multi-Level CCS:  Procedure 29"
 PRMCCS30                     "Multi-Level CCS:  Procedure 30"
 PRMCCS31                     "Multi-Level CCS:  Procedure 31"
 PRMCCS32                     "Multi-Level CCS:  Procedure 32"
 PRMCCS33                     "Multi-Level CCS:  Procedure 33"
 PRMCCS34                     "Multi-Level CCS:  Procedure 34"
 PRMCCS35                     "Multi-Level CCS:  Procedure 35"
 PRMCCS36                     "Multi-Level CCS:  Procedure 36"
 PRMCCS37                     "Multi-Level CCS:  Procedure 37"
 PRMCCS38                     "Multi-Level CCS:  Procedure 38"
 PRMCCS39                     "Multi-Level CCS:  Procedure 39"
 PRMCCS40                     "Multi-Level CCS:  Procedure 40"
 U_BLOOD                      "Utilization Flag: Blood"
 U_CATH                       "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_CTSCAN                     "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EKG                        "Utilization Flag: Electrocardiogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_MHSA                       "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                        "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_PACEMAKER                  "Utilization Flag: Pacemaker"
 U_PHYTHERAPY                 "Utilization Flag: Physical Therapy"
 U_RADTHERAPY                 "Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_STRESS                     "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON35
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON36
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON37
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON38
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON39
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON40
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB35
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB36
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB37
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB38
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB39
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB40
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS26
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS27
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS28
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS29
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS30
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS31
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS32
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS33
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS34
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS35
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS36
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS37
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS38
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS39
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS40
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MN_SID_2011_DX_PR_GRPS.SAV' /COMPRESSED.
