/*******************************************************************
* Creation Date: 10/18/2016   
*   MN_SID_2014_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MN_SID_2014_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 BODYSYSTEM1                     1-   2
 BODYSYSTEM2                     3-   4
 BODYSYSTEM3                     5-   6
 BODYSYSTEM4                     7-   8
 BODYSYSTEM5                     9-  10
 BODYSYSTEM6                    11-  12
 BODYSYSTEM7                    13-  14
 BODYSYSTEM8                    15-  16
 BODYSYSTEM9                    17-  18
 BODYSYSTEM10                   19-  20
 BODYSYSTEM11                   21-  22
 BODYSYSTEM12                   23-  24
 BODYSYSTEM13                   25-  26
 BODYSYSTEM14                   27-  28
 BODYSYSTEM15                   29-  30
 BODYSYSTEM16                   31-  32
 BODYSYSTEM17                   33-  34
 BODYSYSTEM18                   35-  36
 BODYSYSTEM19                   37-  38
 BODYSYSTEM20                   39-  40
 BODYSYSTEM21                   41-  42
 BODYSYSTEM22                   43-  44
 BODYSYSTEM23                   45-  46
 BODYSYSTEM24                   47-  48
 BODYSYSTEM25                   49-  50
 BODYSYSTEM26                   51-  52
 BODYSYSTEM27                   53-  54
 BODYSYSTEM28                   55-  56
 BODYSYSTEM29                   57-  58
 BODYSYSTEM30                   59-  60
 BODYSYSTEM31                   61-  62
 BODYSYSTEM32                   63-  64
 BODYSYSTEM33                   65-  66
 BODYSYSTEM34                   67-  68
 BODYSYSTEM35                   69-  70
 BODYSYSTEM36                   71-  72
 BODYSYSTEM37                   73-  74
 BODYSYSTEM38                   75-  76
 BODYSYSTEM39                   77-  78
 BODYSYSTEM40                   79-  80
 BODYSYSTEM41                   81-  82
 BODYSYSTEM42                   83-  84
 BODYSYSTEM43                   85-  86
 BODYSYSTEM44                   87-  88
 BODYSYSTEM45                   89-  90
 BODYSYSTEM46                   91-  92
 BODYSYSTEM47                   93-  94
 BODYSYSTEM48                   95-  96
 BODYSYSTEM49                   97-  98
 BODYSYSTEM50                   99- 100
 CHRON1                        101- 102
 CHRON2                        103- 104
 CHRON3                        105- 106
 CHRON4                        107- 108
 CHRON5                        109- 110
 CHRON6                        111- 112
 CHRON7                        113- 114
 CHRON8                        115- 116
 CHRON9                        117- 118
 CHRON10                       119- 120
 CHRON11                       121- 122
 CHRON12                       123- 124
 CHRON13                       125- 126
 CHRON14                       127- 128
 CHRON15                       129- 130
 CHRON16                       131- 132
 CHRON17                       133- 134
 CHRON18                       135- 136
 CHRON19                       137- 138
 CHRON20                       139- 140
 CHRON21                       141- 142
 CHRON22                       143- 144
 CHRON23                       145- 146
 CHRON24                       147- 148
 CHRON25                       149- 150
 CHRON26                       151- 152
 CHRON27                       153- 154
 CHRON28                       155- 156
 CHRON29                       157- 158
 CHRON30                       159- 160
 CHRON31                       161- 162
 CHRON32                       163- 164
 CHRON33                       165- 166
 CHRON34                       167- 168
 CHRON35                       169- 170
 CHRON36                       171- 172
 CHRON37                       173- 174
 CHRON38                       175- 176
 CHRON39                       177- 178
 CHRON40                       179- 180
 CHRON41                       181- 182
 CHRON42                       183- 184
 CHRON43                       185- 186
 CHRON44                       187- 188
 CHRON45                       189- 190
 CHRON46                       191- 192
 CHRON47                       193- 194
 CHRON48                       195- 196
 CHRON49                       197- 198
 CHRON50                       199- 200
 DXMCCS1                       201- 211 (A)
 DXMCCS2                       212- 222 (A)
 DXMCCS3                       223- 233 (A)
 DXMCCS4                       234- 244 (A)
 DXMCCS5                       245- 255 (A)
 DXMCCS6                       256- 266 (A)
 DXMCCS7                       267- 277 (A)
 DXMCCS8                       278- 288 (A)
 DXMCCS9                       289- 299 (A)
 DXMCCS10                      300- 310 (A)
 DXMCCS11                      311- 321 (A)
 DXMCCS12                      322- 332 (A)
 DXMCCS13                      333- 343 (A)
 DXMCCS14                      344- 354 (A)
 DXMCCS15                      355- 365 (A)
 DXMCCS16                      366- 376 (A)
 DXMCCS17                      377- 387 (A)
 DXMCCS18                      388- 398 (A)
 DXMCCS19                      399- 409 (A)
 DXMCCS20                      410- 420 (A)
 DXMCCS21                      421- 431 (A)
 DXMCCS22                      432- 442 (A)
 DXMCCS23                      443- 453 (A)
 DXMCCS24                      454- 464 (A)
 DXMCCS25                      465- 475 (A)
 DXMCCS26                      476- 486 (A)
 DXMCCS27                      487- 497 (A)
 DXMCCS28                      498- 508 (A)
 DXMCCS29                      509- 519 (A)
 DXMCCS30                      520- 530 (A)
 DXMCCS31                      531- 541 (A)
 DXMCCS32                      542- 552 (A)
 DXMCCS33                      553- 563 (A)
 DXMCCS34                      564- 574 (A)
 DXMCCS35                      575- 585 (A)
 DXMCCS36                      586- 596 (A)
 DXMCCS37                      597- 607 (A)
 DXMCCS38                      608- 618 (A)
 DXMCCS39                      619- 629 (A)
 DXMCCS40                      630- 640 (A)
 DXMCCS41                      641- 651 (A)
 DXMCCS42                      652- 662 (A)
 DXMCCS43                      663- 673 (A)
 DXMCCS44                      674- 684 (A)
 DXMCCS45                      685- 695 (A)
 DXMCCS46                      696- 706 (A)
 DXMCCS47                      707- 717 (A)
 DXMCCS48                      718- 728 (A)
 DXMCCS49                      729- 739 (A)
 DXMCCS50                      740- 750 (A)
 E_MCCS1                       751- 761 (A)
 E_MCCS2                       762- 772 (A)
 E_MCCS3                       773- 783 (A)
 E_MCCS4                       784- 794 (A)
 E_MCCS5                       795- 805 (A)
 E_MCCS6                       806- 816 (A)
 E_MCCS7                       817- 827 (A)
 E_MCCS8                       828- 838 (A)
 INJURY                        839- 840
 INJURY_CUT                    841- 842
 INJURY_DROWN                  843- 844
 INJURY_FALL                   845- 846
 INJURY_FIRE                   847- 848
 INJURY_FIREARM                849- 850
 INJURY_MACHINERY              851- 852
 INJURY_MVT                    853- 854
 INJURY_NATURE                 855- 856
 INJURY_POISON                 857- 858
 INJURY_STRUCK                 859- 860
 INJURY_SUFFOCATION            861- 862
 INTENT_ASSAULT                863- 864
 INTENT_SELF_HARM              865- 866
 INTENT_UNINTENTIONAL          867- 868
 KEY                           869- 883
 MULTINJURY                    884- 885
 PCLASS1                       886- 887
 PCLASS2                       888- 889
 PCLASS3                       890- 891
 PCLASS4                       892- 893
 PCLASS5                       894- 895
 PCLASS6                       896- 897
 PCLASS7                       898- 899
 PCLASS8                       900- 901
 PCLASS9                       902- 903
 PCLASS10                      904- 905
 PCLASS11                      906- 907
 PCLASS12                      908- 909
 PCLASS13                      910- 911
 PCLASS14                      912- 913
 PCLASS15                      914- 915
 PCLASS16                      916- 917
 PCLASS17                      918- 919
 PCLASS18                      920- 921
 PCLASS19                      922- 923
 PCLASS20                      924- 925
 PCLASS21                      926- 927
 PCLASS22                      928- 929
 PCLASS23                      930- 931
 PCLASS24                      932- 933
 PCLASS25                      934- 935
 PCLASS26                      936- 937
 PCLASS27                      938- 939
 PCLASS28                      940- 941
 PCLASS29                      942- 943
 PCLASS30                      944- 945
 PCLASS31                      946- 947
 PCLASS32                      948- 949
 PCLASS33                      950- 951
 PCLASS34                      952- 953
 PCLASS35                      954- 955
 PCLASS36                      956- 957
 PCLASS37                      958- 959
 PCLASS38                      960- 961
 PCLASS39                      962- 963
 PCLASS40                      964- 965
 PCLASS41                      966- 967
 PCLASS42                      968- 969
 PCLASS43                      970- 971
 PCLASS44                      972- 973
 PCLASS45                      974- 975
 PCLASS46                      976- 977
 PCLASS47                      978- 979
 PCLASS48                      980- 981
 PCLASS49                      982- 983
 PCLASS50                      984- 985
 PRMCCS1                       986- 993 (A)
 PRMCCS2                       994-1001 (A)
 PRMCCS3                      1002-1009 (A)
 PRMCCS4                      1010-1017 (A)
 PRMCCS5                      1018-1025 (A)
 PRMCCS6                      1026-1033 (A)
 PRMCCS7                      1034-1041 (A)
 PRMCCS8                      1042-1049 (A)
 PRMCCS9                      1050-1057 (A)
 PRMCCS10                     1058-1065 (A)
 PRMCCS11                     1066-1073 (A)
 PRMCCS12                     1074-1081 (A)
 PRMCCS13                     1082-1089 (A)
 PRMCCS14                     1090-1097 (A)
 PRMCCS15                     1098-1105 (A)
 PRMCCS16                     1106-1113 (A)
 PRMCCS17                     1114-1121 (A)
 PRMCCS18                     1122-1129 (A)
 PRMCCS19                     1130-1137 (A)
 PRMCCS20                     1138-1145 (A)
 PRMCCS21                     1146-1153 (A)
 PRMCCS22                     1154-1161 (A)
 PRMCCS23                     1162-1169 (A)
 PRMCCS24                     1170-1177 (A)
 PRMCCS25                     1178-1185 (A)
 PRMCCS26                     1186-1193 (A)
 PRMCCS27                     1194-1201 (A)
 PRMCCS28                     1202-1209 (A)
 PRMCCS29                     1210-1217 (A)
 PRMCCS30                     1218-1225 (A)
 PRMCCS31                     1226-1233 (A)
 PRMCCS32                     1234-1241 (A)
 PRMCCS33                     1242-1249 (A)
 PRMCCS34                     1250-1257 (A)
 PRMCCS35                     1258-1265 (A)
 PRMCCS36                     1266-1273 (A)
 PRMCCS37                     1274-1281 (A)
 PRMCCS38                     1282-1289 (A)
 PRMCCS39                     1290-1297 (A)
 PRMCCS40                     1298-1305 (A)
 PRMCCS41                     1306-1313 (A)
 PRMCCS42                     1314-1321 (A)
 PRMCCS43                     1322-1329 (A)
 PRMCCS44                     1330-1337 (A)
 PRMCCS45                     1338-1345 (A)
 PRMCCS46                     1346-1353 (A)
 PRMCCS47                     1354-1361 (A)
 PRMCCS48                     1362-1369 (A)
 PRMCCS49                     1370-1377 (A)
 PRMCCS50                     1378-1385 (A)
 U_BLOOD                      1386-1387
 U_CATH                       1388-1389
 U_CCU                        1390-1391
 U_CHESTXRAY                  1392-1393
 U_CTSCAN                     1394-1395
 U_DIALYSIS                   1396-1397
 U_ECHO                       1398-1399
 U_ED                         1400-1401
 U_EEG                        1402-1403
 U_EKG                        1404-1405
 U_EPO                        1406-1407
 U_ICU                        1408-1409
 U_LITHOTRIPSY                1410-1411
 U_MHSA                       1412-1413
 U_MRT                        1414-1415
 U_NEWBN2L                    1416-1417
 U_NEWBN3L                    1418-1419
 U_NEWBN4L                    1420-1421
 U_NUCMED                     1422-1423
 U_OBSERVATION                1424-1425
 U_OCCTHERAPY                 1426-1427
 U_ORGANACQ                   1428-1429
 U_OTHIMPLANTS                1430-1431
 U_PACEMAKER                  1432-1433
 U_PHYTHERAPY                 1434-1435
 U_RADTHERAPY                 1436-1437
 U_RESPTHERAPY                1438-1439
 U_SPEECHTHERAPY              1440-1441
 U_STRESS                     1442-1443
 U_ULTRASOUND                 1444-1445.


***  Specify write formats  ***.
FORMATS
 BODYSYSTEM1                  (F3.0) /
 BODYSYSTEM2                  (F3.0) /
 BODYSYSTEM3                  (F3.0) /
 BODYSYSTEM4                  (F3.0) /
 BODYSYSTEM5                  (F3.0) /
 BODYSYSTEM6                  (F3.0) /
 BODYSYSTEM7                  (F3.0) /
 BODYSYSTEM8                  (F3.0) /
 BODYSYSTEM9                  (F3.0) /
 BODYSYSTEM10                 (F3.0) /
 BODYSYSTEM11                 (F3.0) /
 BODYSYSTEM12                 (F3.0) /
 BODYSYSTEM13                 (F3.0) /
 BODYSYSTEM14                 (F3.0) /
 BODYSYSTEM15                 (F3.0) /
 BODYSYSTEM16                 (F3.0) /
 BODYSYSTEM17                 (F3.0) /
 BODYSYSTEM18                 (F3.0) /
 BODYSYSTEM19                 (F3.0) /
 BODYSYSTEM20                 (F3.0) /
 BODYSYSTEM21                 (F3.0) /
 BODYSYSTEM22                 (F3.0) /
 BODYSYSTEM23                 (F3.0) /
 BODYSYSTEM24                 (F3.0) /
 BODYSYSTEM25                 (F3.0) /
 BODYSYSTEM26                 (F3.0) /
 BODYSYSTEM27                 (F3.0) /
 BODYSYSTEM28                 (F3.0) /
 BODYSYSTEM29                 (F3.0) /
 BODYSYSTEM30                 (F3.0) /
 BODYSYSTEM31                 (F3.0) /
 BODYSYSTEM32                 (F3.0) /
 BODYSYSTEM33                 (F3.0) /
 BODYSYSTEM34                 (F3.0) /
 BODYSYSTEM35                 (F3.0) /
 BODYSYSTEM36                 (F3.0) /
 BODYSYSTEM37                 (F3.0) /
 BODYSYSTEM38                 (F3.0) /
 BODYSYSTEM39                 (F3.0) /
 BODYSYSTEM40                 (F3.0) /
 BODYSYSTEM41                 (F3.0) /
 BODYSYSTEM42                 (F3.0) /
 BODYSYSTEM43                 (F3.0) /
 BODYSYSTEM44                 (F3.0) /
 BODYSYSTEM45                 (F3.0) /
 BODYSYSTEM46                 (F3.0) /
 BODYSYSTEM47                 (F3.0) /
 BODYSYSTEM48                 (F3.0) /
 BODYSYSTEM49                 (F3.0) /
 BODYSYSTEM50                 (F3.0) /
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRON16                      (F3.0) /
 CHRON17                      (F3.0) /
 CHRON18                      (F3.0) /
 CHRON19                      (F3.0) /
 CHRON20                      (F3.0) /
 CHRON21                      (F3.0) /
 CHRON22                      (F3.0) /
 CHRON23                      (F3.0) /
 CHRON24                      (F3.0) /
 CHRON25                      (F3.0) /
 CHRON26                      (F3.0) /
 CHRON27                      (F3.0) /
 CHRON28                      (F3.0) /
 CHRON29                      (F3.0) /
 CHRON30                      (F3.0) /
 CHRON31                      (F3.0) /
 CHRON32                      (F3.0) /
 CHRON33                      (F3.0) /
 CHRON34                      (F3.0) /
 CHRON35                      (F3.0) /
 CHRON36                      (F3.0) /
 CHRON37                      (F3.0) /
 CHRON38                      (F3.0) /
 CHRON39                      (F3.0) /
 CHRON40                      (F3.0) /
 CHRON41                      (F3.0) /
 CHRON42                      (F3.0) /
 CHRON43                      (F3.0) /
 CHRON44                      (F3.0) /
 CHRON45                      (F3.0) /
 CHRON46                      (F3.0) /
 CHRON47                      (F3.0) /
 CHRON48                      (F3.0) /
 CHRON49                      (F3.0) /
 CHRON50                      (F3.0) /
 INJURY                       (F3.0) /
 INJURY_CUT                   (F3.0) /
 INJURY_DROWN                 (F3.0) /
 INJURY_FALL                  (F3.0) /
 INJURY_FIRE                  (F3.0) /
 INJURY_FIREARM               (F3.0) /
 INJURY_MACHINERY             (F3.0) /
 INJURY_MVT                   (F3.0) /
 INJURY_NATURE                (F3.0) /
 INJURY_POISON                (F3.0) /
 INJURY_STRUCK                (F3.0) /
 INJURY_SUFFOCATION           (F3.0) /
 INTENT_ASSAULT               (F3.0) /
 INTENT_SELF_HARM             (F3.0) /
 INTENT_UNINTENTIONAL         (F3.0) /
 KEY                          (F8.0) /
 MULTINJURY                   (F3.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 PCLASS7                      (F3.0) /
 PCLASS8                      (F3.0) /
 PCLASS9                      (F3.0) /
 PCLASS10                     (F3.0) /
 PCLASS11                     (F3.0) /
 PCLASS12                     (F3.0) /
 PCLASS13                     (F3.0) /
 PCLASS14                     (F3.0) /
 PCLASS15                     (F3.0) /
 PCLASS16                     (F3.0) /
 PCLASS17                     (F3.0) /
 PCLASS18                     (F3.0) /
 PCLASS19                     (F3.0) /
 PCLASS20                     (F3.0) /
 PCLASS21                     (F3.0) /
 PCLASS22                     (F3.0) /
 PCLASS23                     (F3.0) /
 PCLASS24                     (F3.0) /
 PCLASS25                     (F3.0) /
 PCLASS26                     (F3.0) /
 PCLASS27                     (F3.0) /
 PCLASS28                     (F3.0) /
 PCLASS29                     (F3.0) /
 PCLASS30                     (F3.0) /
 PCLASS31                     (F3.0) /
 PCLASS32                     (F3.0) /
 PCLASS33                     (F3.0) /
 PCLASS34                     (F3.0) /
 PCLASS35                     (F3.0) /
 PCLASS36                     (F3.0) /
 PCLASS37                     (F3.0) /
 PCLASS38                     (F3.0) /
 PCLASS39                     (F3.0) /
 PCLASS40                     (F3.0) /
 PCLASS41                     (F3.0) /
 PCLASS42                     (F3.0) /
 PCLASS43                     (F3.0) /
 PCLASS44                     (F3.0) /
 PCLASS45                     (F3.0) /
 PCLASS46                     (F3.0) /
 PCLASS47                     (F3.0) /
 PCLASS48                     (F3.0) /
 PCLASS49                     (F3.0) /
 PCLASS50                     (F3.0) /
 U_BLOOD                      (F3.0) /
 U_CATH                       (F3.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_CTSCAN                     (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EKG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_MHSA                       (F3.0) /
 U_MRT                        (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_PACEMAKER                  (F3.0) /
 U_PHYTHERAPY                 (F3.0) /
 U_RADTHERAPY                 (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_STRESS                     (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 BODYSYSTEM1                  "Body system 1"
 BODYSYSTEM2                  "Body system 2"
 BODYSYSTEM3                  "Body system 3"
 BODYSYSTEM4                  "Body system 4"
 BODYSYSTEM5                  "Body system 5"
 BODYSYSTEM6                  "Body system 6"
 BODYSYSTEM7                  "Body system 7"
 BODYSYSTEM8                  "Body system 8"
 BODYSYSTEM9                  "Body system 9"
 BODYSYSTEM10                 "Body system 10"
 BODYSYSTEM11                 "Body system 11"
 BODYSYSTEM12                 "Body system 12"
 BODYSYSTEM13                 "Body system 13"
 BODYSYSTEM14                 "Body system 14"
 BODYSYSTEM15                 "Body system 15"
 BODYSYSTEM16                 "Body system 16"
 BODYSYSTEM17                 "Body system 17"
 BODYSYSTEM18                 "Body system 18"
 BODYSYSTEM19                 "Body system 19"
 BODYSYSTEM20                 "Body system 20"
 BODYSYSTEM21                 "Body system 21"
 BODYSYSTEM22                 "Body system 22"
 BODYSYSTEM23                 "Body system 23"
 BODYSYSTEM24                 "Body system 24"
 BODYSYSTEM25                 "Body system 25"
 BODYSYSTEM26                 "Body system 26"
 BODYSYSTEM27                 "Body system 27"
 BODYSYSTEM28                 "Body system 28"
 BODYSYSTEM29                 "Body system 29"
 BODYSYSTEM30                 "Body system 30"
 BODYSYSTEM31                 "Body system 31"
 BODYSYSTEM32                 "Body system 32"
 BODYSYSTEM33                 "Body system 33"
 BODYSYSTEM34                 "Body system 34"
 BODYSYSTEM35                 "Body system 35"
 BODYSYSTEM36                 "Body system 36"
 BODYSYSTEM37                 "Body system 37"
 BODYSYSTEM38                 "Body system 38"
 BODYSYSTEM39                 "Body system 39"
 BODYSYSTEM40                 "Body system 40"
 BODYSYSTEM41                 "Body system 41"
 BODYSYSTEM42                 "Body system 42"
 BODYSYSTEM43                 "Body system 43"
 BODYSYSTEM44                 "Body system 44"
 BODYSYSTEM45                 "Body system 45"
 BODYSYSTEM46                 "Body system 46"
 BODYSYSTEM47                 "Body system 47"
 BODYSYSTEM48                 "Body system 48"
 BODYSYSTEM49                 "Body system 49"
 BODYSYSTEM50                 "Body system 50"
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRON16                      "Chronic condition indicator 16"
 CHRON17                      "Chronic condition indicator 17"
 CHRON18                      "Chronic condition indicator 18"
 CHRON19                      "Chronic condition indicator 19"
 CHRON20                      "Chronic condition indicator 20"
 CHRON21                      "Chronic condition indicator 21"
 CHRON22                      "Chronic condition indicator 22"
 CHRON23                      "Chronic condition indicator 23"
 CHRON24                      "Chronic condition indicator 24"
 CHRON25                      "Chronic condition indicator 25"
 CHRON26                      "Chronic condition indicator 26"
 CHRON27                      "Chronic condition indicator 27"
 CHRON28                      "Chronic condition indicator 28"
 CHRON29                      "Chronic condition indicator 29"
 CHRON30                      "Chronic condition indicator 30"
 CHRON31                      "Chronic condition indicator 31"
 CHRON32                      "Chronic condition indicator 32"
 CHRON33                      "Chronic condition indicator 33"
 CHRON34                      "Chronic condition indicator 34"
 CHRON35                      "Chronic condition indicator 35"
 CHRON36                      "Chronic condition indicator 36"
 CHRON37                      "Chronic condition indicator 37"
 CHRON38                      "Chronic condition indicator 38"
 CHRON39                      "Chronic condition indicator 39"
 CHRON40                      "Chronic condition indicator 40"
 CHRON41                      "Chronic condition indicator 41"
 CHRON42                      "Chronic condition indicator 42"
 CHRON43                      "Chronic condition indicator 43"
 CHRON44                      "Chronic condition indicator 44"
 CHRON45                      "Chronic condition indicator 45"
 CHRON46                      "Chronic condition indicator 46"
 CHRON47                      "Chronic condition indicator 47"
 CHRON48                      "Chronic condition indicator 48"
 CHRON49                      "Chronic condition indicator 49"
 CHRON50                      "Chronic condition indicator 50"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 DXMCCS16                     "Multi-Level CCS:  Diagnosis 16"
 DXMCCS17                     "Multi-Level CCS:  Diagnosis 17"
 DXMCCS18                     "Multi-Level CCS:  Diagnosis 18"
 DXMCCS19                     "Multi-Level CCS:  Diagnosis 19"
 DXMCCS20                     "Multi-Level CCS:  Diagnosis 20"
 DXMCCS21                     "Multi-Level CCS:  Diagnosis 21"
 DXMCCS22                     "Multi-Level CCS:  Diagnosis 22"
 DXMCCS23                     "Multi-Level CCS:  Diagnosis 23"
 DXMCCS24                     "Multi-Level CCS:  Diagnosis 24"
 DXMCCS25                     "Multi-Level CCS:  Diagnosis 25"
 DXMCCS26                     "Multi-Level CCS:  Diagnosis 26"
 DXMCCS27                     "Multi-Level CCS:  Diagnosis 27"
 DXMCCS28                     "Multi-Level CCS:  Diagnosis 28"
 DXMCCS29                     "Multi-Level CCS:  Diagnosis 29"
 DXMCCS30                     "Multi-Level CCS:  Diagnosis 30"
 DXMCCS31                     "Multi-Level CCS:  Diagnosis 31"
 DXMCCS32                     "Multi-Level CCS:  Diagnosis 32"
 DXMCCS33                     "Multi-Level CCS:  Diagnosis 33"
 DXMCCS34                     "Multi-Level CCS:  Diagnosis 34"
 DXMCCS35                     "Multi-Level CCS:  Diagnosis 35"
 DXMCCS36                     "Multi-Level CCS:  Diagnosis 36"
 DXMCCS37                     "Multi-Level CCS:  Diagnosis 37"
 DXMCCS38                     "Multi-Level CCS:  Diagnosis 38"
 DXMCCS39                     "Multi-Level CCS:  Diagnosis 39"
 DXMCCS40                     "Multi-Level CCS:  Diagnosis 40"
 DXMCCS41                     "Multi-Level CCS:  Diagnosis 41"
 DXMCCS42                     "Multi-Level CCS:  Diagnosis 42"
 DXMCCS43                     "Multi-Level CCS:  Diagnosis 43"
 DXMCCS44                     "Multi-Level CCS:  Diagnosis 44"
 DXMCCS45                     "Multi-Level CCS:  Diagnosis 45"
 DXMCCS46                     "Multi-Level CCS:  Diagnosis 46"
 DXMCCS47                     "Multi-Level CCS:  Diagnosis 47"
 DXMCCS48                     "Multi-Level CCS:  Diagnosis 48"
 DXMCCS49                     "Multi-Level CCS:  Diagnosis 49"
 DXMCCS50                     "Multi-Level CCS:  Diagnosis 50"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 INJURY
"Injury diagnosis reported on record (1:DX1 is an injury; 2:DX2+ is an injury; 0:No injury)"
 INJURY_CUT                   "Injury by cutting or piercing (by E codes)"
 INJURY_DROWN                 "Injury by drowning or submersion (by E codes)"
 INJURY_FALL                  "Injury by falling (by E codes)"
 INJURY_FIRE                  "Injury by fire, flame or hot object (by E codes)"
 INJURY_FIREARM               "Injury by firearm (by E codes)"
 INJURY_MACHINERY             "Injury by machinery (by E codes)"
 INJURY_MVT                   "Injury involving motor vehicle traffic (by E codes)"
 INJURY_NATURE
"Injury involving nature or environmental factors (by E codes)"
 INJURY_POISON                "Injury by poison (by E codes)"
 INJURY_STRUCK                "Injury from being struck by or against (by E codes)"
 INJURY_SUFFOCATION           "Injury by suffocation (by E codes)"
 INTENT_ASSAULT               "Injury by assault indicated on the record (by E codes)"
 INTENT_SELF_HARM
"Intentional self harm indicated on the record (by diagnosis and/or E codes)"
 INTENT_UNINTENTIONAL         "Unintentional injury indicated on the record (by E codes)"
 KEY                          "HCUP record identifier"
 MULTINJURY                   "More than one injury diagnosis reported on record"
 PCLASS1                      "Procedure class 1"
 PCLASS2                      "Procedure class 2"
 PCLASS3                      "Procedure class 3"
 PCLASS4                      "Procedure class 4"
 PCLASS5                      "Procedure class 5"
 PCLASS6                      "Procedure class 6"
 PCLASS7                      "Procedure class 7"
 PCLASS8                      "Procedure class 8"
 PCLASS9                      "Procedure class 9"
 PCLASS10                     "Procedure class 10"
 PCLASS11                     "Procedure class 11"
 PCLASS12                     "Procedure class 12"
 PCLASS13                     "Procedure class 13"
 PCLASS14                     "Procedure class 14"
 PCLASS15                     "Procedure class 15"
 PCLASS16                     "Procedure class 16"
 PCLASS17                     "Procedure class 17"
 PCLASS18                     "Procedure class 18"
 PCLASS19                     "Procedure class 19"
 PCLASS20                     "Procedure class 20"
 PCLASS21                     "Procedure class 21"
 PCLASS22                     "Procedure class 22"
 PCLASS23                     "Procedure class 23"
 PCLASS24                     "Procedure class 24"
 PCLASS25                     "Procedure class 25"
 PCLASS26                     "Procedure class 26"
 PCLASS27                     "Procedure class 27"
 PCLASS28                     "Procedure class 28"
 PCLASS29                     "Procedure class 29"
 PCLASS30                     "Procedure class 30"
 PCLASS31                     "Procedure class 31"
 PCLASS32                     "Procedure class 32"
 PCLASS33                     "Procedure class 33"
 PCLASS34                     "Procedure class 34"
 PCLASS35                     "Procedure class 35"
 PCLASS36                     "Procedure class 36"
 PCLASS37                     "Procedure class 37"
 PCLASS38                     "Procedure class 38"
 PCLASS39                     "Procedure class 39"
 PCLASS40                     "Procedure class 40"
 PCLASS41                     "Procedure class 41"
 PCLASS42                     "Procedure class 42"
 PCLASS43                     "Procedure class 43"
 PCLASS44                     "Procedure class 44"
 PCLASS45                     "Procedure class 45"
 PCLASS46                     "Procedure class 46"
 PCLASS47                     "Procedure class 47"
 PCLASS48                     "Procedure class 48"
 PCLASS49                     "Procedure class 49"
 PCLASS50                     "Procedure class 50"
 PRMCCS1                      "Multi-Level CCS:  Procedure 1"
 PRMCCS2                      "Multi-Level CCS:  Procedure 2"
 PRMCCS3                      "Multi-Level CCS:  Procedure 3"
 PRMCCS4                      "Multi-Level CCS:  Procedure 4"
 PRMCCS5                      "Multi-Level CCS:  Procedure 5"
 PRMCCS6                      "Multi-Level CCS:  Procedure 6"
 PRMCCS7                      "Multi-Level CCS:  Procedure 7"
 PRMCCS8                      "Multi-Level CCS:  Procedure 8"
 PRMCCS9                      "Multi-Level CCS:  Procedure 9"
 PRMCCS10                     "Multi-Level CCS:  Procedure 10"
 PRMCCS11                     "Multi-Level CCS:  Procedure 11"
 PRMCCS12                     "Multi-Level CCS:  Procedure 12"
 PRMCCS13                     "Multi-Level CCS:  Procedure 13"
 PRMCCS14                     "Multi-Level CCS:  Procedure 14"
 PRMCCS15                     "Multi-Level CCS:  Procedure 15"
 PRMCCS16                     "Multi-Level CCS:  Procedure 16"
 PRMCCS17                     "Multi-Level CCS:  Procedure 17"
 PRMCCS18                     "Multi-Level CCS:  Procedure 18"
 PRMCCS19                     "Multi-Level CCS:  Procedure 19"
 PRMCCS20                     "Multi-Level CCS:  Procedure 20"
 PRMCCS21                     "Multi-Level CCS:  Procedure 21"
 PRMCCS22                     "Multi-Level CCS:  Procedure 22"
 PRMCCS23                     "Multi-Level CCS:  Procedure 23"
 PRMCCS24                     "Multi-Level CCS:  Procedure 24"
 PRMCCS25                     "Multi-Level CCS:  Procedure 25"
 PRMCCS26                     "Multi-Level CCS:  Procedure 26"
 PRMCCS27                     "Multi-Level CCS:  Procedure 27"
 PRMCCS28                     "Multi-Level CCS:  Procedure 28"
 PRMCCS29                     "Multi-Level CCS:  Procedure 29"
 PRMCCS30                     "Multi-Level CCS:  Procedure 30"
 PRMCCS31                     "Multi-Level CCS:  Procedure 31"
 PRMCCS32                     "Multi-Level CCS:  Procedure 32"
 PRMCCS33                     "Multi-Level CCS:  Procedure 33"
 PRMCCS34                     "Multi-Level CCS:  Procedure 34"
 PRMCCS35                     "Multi-Level CCS:  Procedure 35"
 PRMCCS36                     "Multi-Level CCS:  Procedure 36"
 PRMCCS37                     "Multi-Level CCS:  Procedure 37"
 PRMCCS38                     "Multi-Level CCS:  Procedure 38"
 PRMCCS39                     "Multi-Level CCS:  Procedure 39"
 PRMCCS40                     "Multi-Level CCS:  Procedure 40"
 PRMCCS41                     "Multi-Level CCS:  Procedure 41"
 PRMCCS42                     "Multi-Level CCS:  Procedure 42"
 PRMCCS43                     "Multi-Level CCS:  Procedure 43"
 PRMCCS44                     "Multi-Level CCS:  Procedure 44"
 PRMCCS45                     "Multi-Level CCS:  Procedure 45"
 PRMCCS46                     "Multi-Level CCS:  Procedure 46"
 PRMCCS47                     "Multi-Level CCS:  Procedure 47"
 PRMCCS48                     "Multi-Level CCS:  Procedure 48"
 PRMCCS49                     "Multi-Level CCS:  Procedure 49"
 PRMCCS50                     "Multi-Level CCS:  Procedure 50"
 U_BLOOD                      "Utilization Flag: Blood"
 U_CATH                       "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_CTSCAN                     "Utilization Flag: Computed Tomography Scan"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EKG                        "Utilization Flag: Electrocardiogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_MHSA                       "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT                        "Utilization Flag: Magnetic Resonance Technology"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_PACEMAKER                  "Utilization Flag: Pacemaker"
 U_PHYTHERAPY                 "Utilization Flag: Physical Therapy"
 U_RADTHERAPY
"Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_STRESS                     "Utilization Flag: Cardiac Stress Test"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM12
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM13
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM14
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM15
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM16
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM17
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM18
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM19
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM20
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM21
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM22
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM23
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM24
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM25
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM26
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM27
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM28
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM29
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM30
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM31
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM32
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM33
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM34
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM35
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM36
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM37
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM38
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM39
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM40
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM41
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM42
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM43
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM44
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM45
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM46
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM47
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM48
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM49
 (-9,-8,-6,-5=SYSMIS).
RECODE BODYSYSTEM50
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON21
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON22
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON23
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON24
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON25
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON26
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON27
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON28
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON29
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON30
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON31
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON32
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON33
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON34
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON35
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON36
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON37
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON38
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON39
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON40
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON41
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON42
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON43
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON44
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON45
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON46
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON47
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON48
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON49
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON50
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS21
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS22
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS23
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS24
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS25
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS26
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS27
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS28
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS29
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS30
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS31
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS32
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS33
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS34
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS35
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS36
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS37
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS38
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS39
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS40
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS41
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS42
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS43
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS44
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS45
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS46
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS47
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS48
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS49
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS50
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MN_SID_2014_DX_PR_GRPS.SAV' /COMPRESSED.
