/*******************************************************************
*   NJ_SID_2009_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NJ_SID_2009_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AHOUR                     10-  13
 AMONTH                    14-  15
 ASOURCE                   16-  17
 ASOURCEUB92               18     (A)
 ASOURCE_X                 19     (A)
 ATYPE                     20-  21
 AWEEKEND                  22-  23
 BWT                       24-  27
 CPT1                      28-  32 (A)
 CPT2                      33-  37 (A)
 CPT3                      38-  42 (A)
 CPT4                      43-  47 (A)
 CPT5                      48-  52 (A)
 CPT6                      53-  57 (A)
 CPT7                      58-  62 (A)
 CPT8                      63-  67 (A)
 CPT9                      68-  72 (A)
 CPT10                     73-  77 (A)
 CPT11                     78-  82 (A)
 CPT12                     83-  87 (A)
 CPT13                     88-  92 (A)
 CPT14                     93-  97 (A)
 CPT15                     98- 102 (A)
 CPT16                    103- 107 (A)
 CPT17                    108- 112 (A)
 CPT18                    113- 117 (A)
 CPT19                    118- 122 (A)
 CPT20                    123- 127 (A)
 CPT21                    128- 132 (A)
 CPT22                    133- 137 (A)
 CPT23                    138- 142 (A)
 CPT24                    143- 147 (A)
 CPT25                    148- 152 (A)
 CPT26                    153- 157 (A)
 CPT27                    158- 162 (A)
 CPT28                    163- 167 (A)
 CPT29                    168- 172 (A)
 CPT30                    173- 177 (A)
 CPTCCS1                  178- 180
 CPTCCS2                  181- 183
 CPTCCS3                  184- 186
 CPTCCS4                  187- 189
 CPTCCS5                  190- 192
 CPTCCS6                  193- 195
 CPTCCS7                  196- 198
 CPTCCS8                  199- 201
 CPTCCS9                  202- 204
 CPTCCS10                 205- 207
 CPTCCS11                 208- 210
 CPTCCS12                 211- 213
 CPTCCS13                 214- 216
 CPTCCS14                 217- 219
 CPTCCS15                 220- 222
 CPTCCS16                 223- 225
 CPTCCS17                 226- 228
 CPTCCS18                 229- 231
 CPTCCS19                 232- 234
 CPTCCS20                 235- 237
 CPTCCS21                 238- 240
 CPTCCS22                 241- 243
 CPTCCS23                 244- 246
 CPTCCS24                 247- 249
 CPTCCS25                 250- 252
 CPTCCS26                 253- 255
 CPTCCS27                 256- 258
 CPTCCS28                 259- 261
 CPTCCS29                 262- 264
 CPTCCS30                 265- 267
 CPTM1_1                  268- 269 (A)
 CPTM1_2                  270- 271 (A)
 CPTM1_3                  272- 273 (A)
 CPTM1_4                  274- 275 (A)
 CPTM1_5                  276- 277 (A)
 CPTM1_6                  278- 279 (A)
 CPTM1_7                  280- 281 (A)
 CPTM1_8                  282- 283 (A)
 CPTM1_9                  284- 285 (A)
 CPTM1_10                 286- 287 (A)
 CPTM1_11                 288- 289 (A)
 CPTM1_12                 290- 291 (A)
 CPTM1_13                 292- 293 (A)
 CPTM1_14                 294- 295 (A)
 CPTM1_15                 296- 297 (A)
 CPTM1_16                 298- 299 (A)
 CPTM1_17                 300- 301 (A)
 CPTM1_18                 302- 303 (A)
 CPTM1_19                 304- 305 (A)
 CPTM1_20                 306- 307 (A)
 CPTM1_21                 308- 309 (A)
 CPTM1_22                 310- 311 (A)
 CPTM1_23                 312- 313 (A)
 CPTM1_24                 314- 315 (A)
 CPTM1_25                 316- 317 (A)
 CPTM1_26                 318- 319 (A)
 CPTM1_27                 320- 321 (A)
 CPTM1_28                 322- 323 (A)
 CPTM1_29                 324- 325 (A)
 CPTM1_30                 326- 327 (A)
 CPTM2_1                  328- 329 (A)
 CPTM2_2                  330- 331 (A)
 CPTM2_3                  332- 333 (A)
 CPTM2_4                  334- 335 (A)
 CPTM2_5                  336- 337 (A)
 CPTM2_6                  338- 339 (A)
 CPTM2_7                  340- 341 (A)
 CPTM2_8                  342- 343 (A)
 CPTM2_9                  344- 345 (A)
 CPTM2_10                 346- 347 (A)
 CPTM2_11                 348- 349 (A)
 CPTM2_12                 350- 351 (A)
 CPTM2_13                 352- 353 (A)
 CPTM2_14                 354- 355 (A)
 CPTM2_15                 356- 357 (A)
 CPTM2_16                 358- 359 (A)
 CPTM2_17                 360- 361 (A)
 CPTM2_18                 362- 363 (A)
 CPTM2_19                 364- 365 (A)
 CPTM2_20                 366- 367 (A)
 CPTM2_21                 368- 369 (A)
 CPTM2_22                 370- 371 (A)
 CPTM2_23                 372- 373 (A)
 CPTM2_24                 374- 375 (A)
 CPTM2_25                 376- 377 (A)
 CPTM2_26                 378- 379 (A)
 CPTM2_27                 380- 381 (A)
 CPTM2_28                 382- 383 (A)
 CPTM2_29                 384- 385 (A)
 CPTM2_30                 386- 387 (A)
 DHOUR                    388- 391
 DIED                     392- 393
 DISPUB04                 394- 395
 DISPUNIFORM              396- 397
 DISP_X                   398- 399 (A)
 DQTR                     400- 401
 DRG                      402- 404
 DRG24                    405- 407
 DRGVER                   408- 409
 DRG_NoPOA                410- 412
 DSHOSPID                 413- 429 (A)
 DX1                      430- 434 (A)
 DX2                      435- 439 (A)
 DX3                      440- 444 (A)
 DX4                      445- 449 (A)
 DX5                      450- 454 (A)
 DX6                      455- 459 (A)
 DX7                      460- 464 (A)
 DX8                      465- 469 (A)
 DX9                      470- 474 (A)
 DX10                     475- 479 (A)
 DX11                     480- 484 (A)
 DX12                     485- 489 (A)
 DX13                     490- 494 (A)
 DX14                     495- 499 (A)
 DX15                     500- 504 (A)
 DX16                     505- 509 (A)
 DX17                     510- 514 (A)
 DX18                     515- 519 (A)
 DX19                     520- 524 (A)
 DX20                     525- 529 (A)
 DX21                     530- 534 (A)
 DX22                     535- 539 (A)
 DX23                     540- 544 (A)
 DX24                     545- 549 (A)
 DXCCS1                   550- 553
 DXCCS2                   554- 557
 DXCCS3                   558- 561
 DXCCS4                   562- 565
 DXCCS5                   566- 569
 DXCCS6                   570- 573
 DXCCS7                   574- 577
 DXCCS8                   578- 581
 DXCCS9                   582- 585
 DXCCS10                  586- 589
 DXCCS11                  590- 593
 DXCCS12                  594- 597
 DXCCS13                  598- 601
 DXCCS14                  602- 605
 DXCCS15                  606- 609
 DXCCS16                  610- 613
 DXCCS17                  614- 617
 DXCCS18                  618- 621
 DXCCS19                  622- 625
 DXCCS20                  626- 629
 DXCCS21                  630- 633
 DXCCS22                  634- 637
 DXCCS23                  638- 641
 DXCCS24                  642- 645
 DXPOA1                   646     (A)
 DXPOA2                   647     (A)
 DXPOA3                   648     (A)
 DXPOA4                   649     (A)
 DXPOA5                   650     (A)
 DXPOA6                   651     (A)
 DXPOA7                   652     (A)
 DXPOA8                   653     (A)
 DXPOA9                   654     (A)
 DXPOA10                  655     (A)
 DXPOA11                  656     (A)
 DXPOA12                  657     (A)
 DXPOA13                  658     (A)
 DXPOA14                  659     (A)
 DXPOA15                  660     (A)
 DXPOA16                  661     (A)
 DXPOA17                  662     (A)
 DXPOA18                  663     (A)
 DXPOA19                  664     (A)
 DXPOA20                  665     (A)
 DXPOA21                  666     (A)
 DXPOA22                  667     (A)
 DXPOA23                  668     (A)
 DXPOA24                  669     (A)
 ECODE1                   670- 674 (A)
 ECODE2                   675- 679 (A)
 ECODE3                   680- 684 (A)
 ECODE4                   685- 689 (A)
 ECODE5                   690- 694 (A)
 ECODE6                   695- 699 (A)
 ECODE7                   700- 704 (A)
 ECODE8                   705- 709 (A)
 ECODE9                   710- 714 (A)
 E_CCS1                   715- 718
 E_CCS2                   719- 722
 E_CCS3                   723- 726
 E_CCS4                   727- 730
 E_CCS5                   731- 734
 E_CCS6                   735- 738
 E_CCS7                   739- 742
 E_CCS8                   743- 746
 E_CCS9                   747- 750
 E_POA1                   751     (A)
 E_POA2                   752     (A)
 E_POA3                   753     (A)
 E_POA4                   754     (A)
 E_POA5                   755     (A)
 E_POA6                   756     (A)
 E_POA7                   757     (A)
 E_POA8                   758     (A)
 E_POA9                   759     (A)
 FEMALE                   760- 761
 HCUP_ED                  762- 763
 HCUP_OS                  764- 765
 HISPANIC_X               766- 770 (A)
 HOSPBRTH                 771- 773
 HOSPST                   774- 775 (A)
 KEY                      776- 789
 LOS                      790- 794
 LOS_X                    795- 800
 MARITALSTATUSUB04        801     (A)
 MDC                      802- 803
 MDC24                    804- 805
 MDC_NoPOA                806- 807
 MDNUM1_R                 808- 816
 MDNUM2_R                 817- 825
 MEDINCSTQ                826- 827
 MOMNUM_R                 828- 836
 MRN_R                    837- 845
 NCHRONIC                 846- 848
 NCPT                     849- 851
 NDX                      852- 853
 NECODE                   854- 855
 NEOMAT                   856- 857
 NPR                      858- 859
 ORPROC                   860- 861
 PAY1                     862- 863
 PAY1_X                   864- 866 (A)
 PAY2                     867- 868
 PAY2_X                   869- 871 (A)
 PAY3_X                   872- 874 (A)
 PL_CBSA                  875- 877
 PL_MSA1993               878- 880
 PL_NCHS2006              881- 882
 PL_RUCA10_2005           883- 884
 PL_RUCA2005              885- 888
 PL_RUCA4_2005            889- 890
 PL_RUCC2003              891- 892
 PL_UIC2003               893- 894
 PL_UR_CAT4               895- 896
 PR1                      897- 900 (A)
 PR2                      901- 904 (A)
 PR3                      905- 908 (A)
 PR4                      909- 912 (A)
 PR5                      913- 916 (A)
 PR6                      917- 920 (A)
 PR7                      921- 924 (A)
 PR8                      925- 928 (A)
 PR9                      929- 932 (A)
 PR10                     933- 936 (A)
 PR11                     937- 940 (A)
 PR12                     941- 944 (A)
 PR13                     945- 948 (A)
 PR14                     949- 952 (A)
 PR15                     953- 956 (A)
 PR16                     957- 960 (A)
 PR17                     961- 964 (A)
 PR18                     965- 968 (A)
 PR19                     969- 972 (A)
 PR20                     973- 976 (A)
 PR21                     977- 980 (A)
 PR22                     981- 984 (A)
 PR23                     985- 988 (A)
 PR24                     989- 992 (A)
 PR25                     993- 996 (A)
 PRCCS1                   997- 999
 PRCCS2                  1000-1002
 PRCCS3                  1003-1005
 PRCCS4                  1006-1008
 PRCCS5                  1009-1011
 PRCCS6                  1012-1014
 PRCCS7                  1015-1017
 PRCCS8                  1018-1020
 PRCCS9                  1021-1023
 PRCCS10                 1024-1026
 PRCCS11                 1027-1029
 PRCCS12                 1030-1032
 PRCCS13                 1033-1035
 PRCCS14                 1036-1038
 PRCCS15                 1039-1041
 PRCCS16                 1042-1044
 PRCCS17                 1045-1047
 PRCCS18                 1048-1050
 PRCCS19                 1051-1053
 PRCCS20                 1054-1056
 PRCCS21                 1057-1059
 PRCCS22                 1060-1062
 PRCCS23                 1063-1065
 PRCCS24                 1066-1068
 PRCCS25                 1069-1071
 PRDAY1                  1072-1076
 PRDAY2                  1077-1081
 PRDAY3                  1082-1086
 PRDAY4                  1087-1091
 PRDAY5                  1092-1096
 PRDAY6                  1097-1101
 PRDAY7                  1102-1106
 PRDAY8                  1107-1111
 PRDAY9                  1112-1116
 PRDAY10                 1117-1121
 PRDAY11                 1122-1126
 PRDAY12                 1127-1131
 PRDAY13                 1132-1136
 PRDAY14                 1137-1141
 PRDAY15                 1142-1146
 PRDAY16                 1147-1151
 PRDAY17                 1152-1156
 PRDAY18                 1157-1161
 PRDAY19                 1162-1166
 PRDAY20                 1167-1171
 PRDAY21                 1172-1176
 PRDAY22                 1177-1181
 PRDAY23                 1182-1186
 PRDAY24                 1187-1191
 PRDAY25                 1192-1196
 PROCTYPE                1197-1199
 PSTATE                  1200-1201 (A)
 PSTCO                   1202-1206
 PSTCO2                  1207-1211
 PointOfOriginUB04       1212     (A)
 PointOfOrigin_X         1213     (A)
 PrimLang                1214-1216 (A)
 RACE                    1217-1218
 RACE_X                  1219-1223 (A)
 READMIT                 1224-1225
 TOTCHG                  1226-1235
 TOTCHG_X                1236-1250
 TRAN_IN                 1251-1252
 TRAN_OUT                1253-1254
 YEAR                    1255-1258
 ZIP3                    1259-1261 (A)
 ZIPINC_QRTL             1262-1264
 TOWN                    1265-1268 (A)
 ZIP                     1269-1273 (A)
 AYEAR                   1274-1277
 BMONTH                  1278-1279
 BYEAR                   1280-1283
 PRMONTH1                1284-1285
 PRMONTH2                1286-1287
 PRMONTH3                1288-1289
 PRMONTH4                1290-1291
 PRMONTH5                1292-1293
 PRMONTH6                1294-1295
 PRMONTH7                1296-1297
 PRMONTH8                1298-1299
 PRMONTH9                1300-1301
 PRMONTH10               1302-1303
 PRMONTH11               1304-1305
 PRMONTH12               1306-1307
 PRMONTH13               1308-1309
 PRMONTH14               1310-1311
 PRMONTH15               1312-1313
 PRMONTH16               1314-1315
 PRMONTH17               1316-1317
 PRMONTH18               1318-1319
 PRMONTH19               1320-1321
 PRMONTH20               1322-1323
 PRMONTH21               1324-1325
 PRMONTH22               1326-1327
 PRMONTH23               1328-1329
 PRMONTH24               1330-1331
 PRYEAR1                 1332-1335
 PRYEAR2                 1336-1339
 PRYEAR3                 1340-1343
 PRYEAR4                 1344-1347
 PRYEAR5                 1348-1351
 PRYEAR6                 1352-1355
 PRYEAR7                 1356-1359
 PRYEAR8                 1360-1363
 PRYEAR9                 1364-1367
 PRYEAR10                1368-1371
 PRYEAR11                1372-1375
 PRYEAR12                1376-1379
 PRYEAR13                1380-1383
 PRYEAR14                1384-1387
 PRYEAR15                1388-1391
 PRYEAR16                1392-1395
 PRYEAR17                1396-1399
 PRYEAR18                1400-1403
 PRYEAR19                1404-1407
 PRYEAR20                1408-1411
 PRYEAR21                1412-1415
 PRYEAR22                1416-1419
 PRYEAR23                1420-1423
 PRYEAR24                1424-1427.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPOA               (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDC_NoPOA               (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCSTQ               (F3.0) /
 MOMNUM_R                (F5.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PRDAY24                 (F4.0) /
 PRDAY25                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 READMIT                 (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TRAN_IN                 (F3.0) /
 TRAN_OUT                (F3.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRMONTH16               (F3.0) /
 PRMONTH17               (F3.0) /
 PRMONTH18               (F3.0) /
 PRMONTH19               (F3.0) /
 PRMONTH20               (F3.0) /
 PRMONTH21               (F3.0) /
 PRMONTH22               (F3.0) /
 PRMONTH23               (F3.0) /
 PRMONTH24               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) /
 PRYEAR24                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AHOUR                   "Admission Hour"
 AMONTH                  "Admission month"
 ASOURCE                 "Admission source (uniform)"
 ASOURCEUB92             "Admission source (UB-92 standard coding)"
 ASOURCE_X               "Admission source (as received from source)"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BWT                     "Birth weight in grams"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPT26                   "CPT/HCPCS procedure code 26"
 CPT27                   "CPT/HCPCS procedure code 27"
 CPT28                   "CPT/HCPCS procedure code 28"
 CPT29                   "CPT/HCPCS procedure code 29"
 CPT30                   "CPT/HCPCS procedure code 30"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTCCS26                "CCS: CPT 26"
 CPTCCS27                "CCS: CPT 27"
 CPTCCS28                "CCS: CPT 28"
 CPTCCS29                "CCS: CPT 29"
 CPTCCS30                "CCS: CPT 30"
 CPTM1_1                 "First CPT-4/HCPCS modifier 1"
 CPTM1_2                 "First CPT-4/HCPCS modifier 2"
 CPTM1_3                 "First CPT-4/HCPCS modifier 3"
 CPTM1_4                 "First CPT-4/HCPCS modifier 4"
 CPTM1_5                 "First CPT-4/HCPCS modifier 5"
 CPTM1_6                 "First CPT-4/HCPCS modifier 6"
 CPTM1_7                 "First CPT-4/HCPCS modifier 7"
 CPTM1_8                 "First CPT-4/HCPCS modifier 8"
 CPTM1_9                 "First CPT-4/HCPCS modifier 9"
 CPTM1_10                "First CPT-4/HCPCS modifier 10"
 CPTM1_11                "First CPT-4/HCPCS modifier 11"
 CPTM1_12                "First CPT-4/HCPCS modifier 12"
 CPTM1_13                "First CPT-4/HCPCS modifier 13"
 CPTM1_14                "First CPT-4/HCPCS modifier 14"
 CPTM1_15                "First CPT-4/HCPCS modifier 15"
 CPTM1_16                "First CPT-4/HCPCS modifier 16"
 CPTM1_17                "First CPT-4/HCPCS modifier 17"
 CPTM1_18                "First CPT-4/HCPCS modifier 18"
 CPTM1_19                "First CPT-4/HCPCS modifier 19"
 CPTM1_20                "First CPT-4/HCPCS modifier 20"
 CPTM1_21                "First CPT-4/HCPCS modifier 21"
 CPTM1_22                "First CPT-4/HCPCS modifier 22"
 CPTM1_23                "First CPT-4/HCPCS modifier 23"
 CPTM1_24                "First CPT-4/HCPCS modifier 24"
 CPTM1_25                "First CPT-4/HCPCS modifier 25"
 CPTM1_26                "First CPT-4/HCPCS modifier 26"
 CPTM1_27                "First CPT-4/HCPCS modifier 27"
 CPTM1_28                "First CPT-4/HCPCS modifier 28"
 CPTM1_29                "First CPT-4/HCPCS modifier 29"
 CPTM1_30                "First CPT-4/HCPCS modifier 30"
 CPTM2_1                 "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                 "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                 "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                 "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                 "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                 "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                 "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                 "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                 "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                "Second CPT-4/HCPCS modifier 30"
 DHOUR                   "Discharge Hour"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DRG_NoPOA               "DRG in use on discharge date, calculated without POA"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DXPOA7                  "Diagnosis 7, present on admission indicator"
 DXPOA8                  "Diagnosis 8, present on admission indicator"
 DXPOA9                  "Diagnosis 9, present on admission indicator"
 DXPOA10                 "Diagnosis 10, present on admission indicator"
 DXPOA11                 "Diagnosis 11, present on admission indicator"
 DXPOA12                 "Diagnosis 12, present on admission indicator"
 DXPOA13                 "Diagnosis 13, present on admission indicator"
 DXPOA14                 "Diagnosis 14, present on admission indicator"
 DXPOA15                 "Diagnosis 15, present on admission indicator"
 DXPOA16                 "Diagnosis 16, present on admission indicator"
 DXPOA17                 "Diagnosis 17, present on admission indicator"
 DXPOA18                 "Diagnosis 18, present on admission indicator"
 DXPOA19                 "Diagnosis 19, present on admission indicator"
 DXPOA20                 "Diagnosis 20, present on admission indicator"
 DXPOA21                 "Diagnosis 21, present on admission indicator"
 DXPOA22                 "Diagnosis 22, present on admission indicator"
 DXPOA23                 "Diagnosis 23, present on admission indicator"
 DXPOA24                 "Diagnosis 24, present on admission indicator"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 ECODE9                  "E code 9"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 E_CCS9                  "CCS: E Code 9"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 E_POA5                  "E Code 5, present on admission indicator"
 E_POA6                  "E Code 6, present on admission indicator"
 E_POA7                  "E Code 7, present on admission indicator"
 E_POA8                  "E Code 8, present on admission indicator"
 E_POA9                  "E Code 9, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MARITALSTATUSUB04       "Patient's marital status, UB-04 standard coding"
 MDC                     "MDC in effect on discharge date"
 MDC24                   "MDC, version 24"
 MDC_NoPOA               "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                "Physician 1 number (re-identified)"
 MDNUM2_R                "Physician 2 number (re-identified)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MOMNUM_R                "Mother's number (re-identified)"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAY3_X                  "Tertiary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PR21                    "Procedure 21"
 PR22                    "Procedure 22"
 PR23                    "Procedure 23"
 PR24                    "Procedure 24"
 PR25                    "Procedure 25"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRCCS21                 "CCS: procedure 21"
 PRCCS22                 "CCS: procedure 22"
 PRCCS23                 "CCS: procedure 23"
 PRCCS24                 "CCS: procedure 24"
 PRCCS25                 "CCS: procedure 25"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PRDAY16                 "Number of days from admission to PR16"
 PRDAY17                 "Number of days from admission to PR17"
 PRDAY18                 "Number of days from admission to PR18"
 PRDAY19                 "Number of days from admission to PR19"
 PRDAY20                 "Number of days from admission to PR20"
 PRDAY21                 "Number of days from admission to PR21"
 PRDAY22                 "Number of days from admission to PR22"
 PRDAY23                 "Number of days from admission to PR23"
 PRDAY24                 "Number of days from admission to PR24"
 PRDAY25                 "Number of days from admission to PR25"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 PrimLang                "Primary language of patient"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 READMIT                 "Readmission"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TRAN_IN                 "Transfer in indicator"
 TRAN_OUT                "Transfer out indicator"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 TOWN                    "Patient town of residence (as received from source)"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRMONTH16               "Month of procedure 16"
 PRMONTH17               "Month of procedure 17"
 PRMONTH18               "Month of procedure 18"
 PRMONTH19               "Month of procedure 19"
 PRMONTH20               "Month of procedure 20"
 PRMONTH21               "Month of procedure 21"
 PRMONTH22               "Month of procedure 22"
 PRMONTH23               "Month of procedure 23"
 PRMONTH24               "Month of procedure 24"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15"
 PRYEAR16                "Year of procedure 16"
 PRYEAR17                "Year of procedure 17"
 PRYEAR18                "Year of procedure 18"
 PRYEAR19                "Year of procedure 19"
 PRYEAR20                "Year of procedure 20"
 PRYEAR21                "Year of procedure 21"
 PRYEAR22                "Year of procedure 22"
 PRYEAR23                "Year of procedure 23"
 PRYEAR24                "Year of procedure 24" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MOMNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE READMIT
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NJ_SID_2009_CORE.SAV' /COMPRESSED.
