/*******************************************************************
* Creation Date: 10/01/2018   
*   NM_SID_2016_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NM_SID_2016_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BWT                            20-  23
 DaysToEvent                    24-  29
 DHOUR                          30-  33
 DIED                           34-  35
 DISP_X                         36-  37 (A)
 DISPUB04                       38-  39
 DISPUNIFORM                    40-  41
 DMONTH                         42-  43
 DQTR                           44-  45
 DRG                            46-  48
 DRG_NoPOA                      49-  51
 DRGVER                         52-  53
 DXPOA1                         54     (A)
 DXPOA2                         55     (A)
 DXPOA3                         56     (A)
 DXPOA4                         57     (A)
 DXPOA5                         58     (A)
 DXPOA6                         59     (A)
 DXPOA7                         60     (A)
 DXPOA8                         61     (A)
 DXPOA9                         62     (A)
 DXPOA10                        63     (A)
 DXPOA11                        64     (A)
 DXPOA12                        65     (A)
 DXPOA13                        66     (A)
 DXPOA14                        67     (A)
 DXPOA15                        68     (A)
 DXPOA16                        69     (A)
 DXPOA17                        70     (A)
 DXPOA18                        71     (A)
 DXVER                          72-  74
 E_POA1                         75     (A)
 E_POA2                         76     (A)
 E_POA3                         77     (A)
 E_POA4                         78     (A)
 E_POA5                         79     (A)
 E_POA6                         80     (A)
 E_POA7                         81     (A)
 FEMALE                         82-  83
 HCUP_ED                        84-  85
 HCUP_OS                        86-  87
 HISPANIC                       88-  89
 HISPANIC_X                     90-  91 (A)
 HOSPST                         92-  93 (A)
 I10_DX_Admitting               94- 100 (A)
 I10_DX1                       101- 107 (A)
 I10_DX2                       108- 114 (A)
 I10_DX3                       115- 121 (A)
 I10_DX4                       122- 128 (A)
 I10_DX5                       129- 135 (A)
 I10_DX6                       136- 142 (A)
 I10_DX7                       143- 149 (A)
 I10_DX8                       150- 156 (A)
 I10_DX9                       157- 163 (A)
 I10_DX10                      164- 170 (A)
 I10_DX11                      171- 177 (A)
 I10_DX12                      178- 184 (A)
 I10_DX13                      185- 191 (A)
 I10_DX14                      192- 198 (A)
 I10_DX15                      199- 205 (A)
 I10_DX16                      206- 212 (A)
 I10_DX17                      213- 219 (A)
 I10_DX18                      220- 226 (A)
 I10_ECAUSE1                   227- 233 (A)
 I10_ECAUSE2                   234- 240 (A)
 I10_ECAUSE3                   241- 247 (A)
 I10_ECAUSE4                   248- 254 (A)
 I10_ECAUSE5                   255- 261 (A)
 I10_ECAUSE6                   262- 268 (A)
 I10_ECAUSE7                   269- 275 (A)
 I10_NDX                       276- 278
 I10_NECAUSE                   279- 280
 I10_NPR                       281- 283
 I10_PR1                       284- 290 (A)
 I10_PR2                       291- 297 (A)
 I10_PR3                       298- 304 (A)
 I10_PR4                       305- 311 (A)
 I10_PR5                       312- 318 (A)
 I10_PR6                       319- 325 (A)
 I10_PROCTYPE                  326- 328
 KEY                           329- 343
 LOS                           344- 348
 LOS_X                         349- 354
 MDC                           355- 356
 MDC_NoPOA                     357- 358
 MDNUM1_R                      359- 367
 MDNUM2_R                      368- 376
 MEDINCSTQ                     377- 378
 OS_TIME                       379- 389
 PAY1                          390- 391
 PAY1_X                        392- 393 (A)
 PAY2                          394- 395
 PAY2_X                        396- 397 (A)
 PAY3                          398- 399
 PAY3_X                        400- 401 (A)
 PL_CBSA                       402- 404
 PL_NCHS                       405- 406
 PL_RUCC                       407- 408
 PL_UIC                        409- 410
 PL_UR_CAT4                    411- 412
 POA_Disch_Edit1               413- 414
 POA_Disch_Edit2               415- 416
 POA_Hosp_Edit1                417- 418
 POA_Hosp_Edit2                419- 420
 POA_Hosp_Edit3                421- 422
 POA_Hosp_Edit3_Value          423- 430
 PointOfOrigin_X               431     (A)
 PointOfOriginUB04             432     (A)
 PRDAY1                        433- 437
 PRDAY2                        438- 442
 PRDAY3                        443- 447
 PRDAY4                        448- 452
 PRDAY5                        453- 457
 PRDAY6                        458- 462
 PRVER                         463- 465
 PSTATE                        466- 467 (A)
 PSTCO                         468- 472
 PSTCO2                        473- 477
 RACE                          478- 479
 RACE_X                        480- 481 (A)
 TOTCHG                        482- 491
 TOTCHG_X                      492- 506
 TRAN_IN                       507- 508
 TRAN_OUT                      509- 510
 VisitLink                     511- 519
 YEAR                          520- 523
 ZIP3                          524- 526 (A)
 ZIPINC_QRTL                   527- 529
 HOSPID                        530- 534
 AYEAR                         535- 538
 BMONTH                        539- 540
 BYEAR                         541- 544
 PRMONTH1                      545- 546
 PRMONTH2                      547- 548
 PRMONTH3                      549- 550
 PRMONTH4                      551- 552
 PRMONTH5                      553- 554
 PRMONTH6                      555- 556
 PRYEAR1                       557- 560
 PRYEAR2                       561- 564
 PRYEAR3                       565- 568
 PRYEAR4                       569- 572
 PRYEAR5                       573- 576
 PRYEAR6                       577- 580.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DaysToEvent                  (F8.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 DaysToEvent                  "Days from 'start date' to admission"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "External cause 1, present on admission indicator"
 E_POA2                       "External cause 2, present on admission indicator"
 E_POA3                       "External cause 3, present on admission indicator"
 E_POA4                       "External cause 4, present on admission indicator"
 E_POA5                       "External cause 5, present on admission indicator"
 E_POA6                       "External cause 6, present on admission indicator"
 E_POA7                       "External cause 7, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_ECAUSE1                  "ICD-10-CM External cause 1"
 I10_ECAUSE2                  "ICD-10-CM External cause 2"
 I10_ECAUSE3                  "ICD-10-CM External cause 3"
 I10_ECAUSE4                  "ICD-10-CM External cause 4"
 I10_ECAUSE5                  "ICD-10-CM External cause 5"
 I10_ECAUSE6                  "ICD-10-CM External cause 6"
 I10_ECAUSE7                  "ICD-10-CM External cause 7"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of External cause codes on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NM_SID_2016_CORE.SAV' /COMPRESSED.
