/*******************************************************************
* Creation Date: 03/31/2022   
*   NM_SID_2020_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NM_SID_2020_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BWT                            20-  23
 DaysToEvent                    24-  29
 DHOUR                          30-  33
 DIED                           34-  35
 DISP_X                         36-  37 (A)
 DISPUB04                       38-  39
 DISPUNIFORM                    40-  41
 DMONTH                         42-  43
 DQTR                           44-  45
 DRG                            46-  48
 DRG_NoPOA                      49-  51
 DRGVER                         52-  53
 DXPOA1                         54     (A)
 DXPOA2                         55     (A)
 DXPOA3                         56     (A)
 DXPOA4                         57     (A)
 DXPOA5                         58     (A)
 DXPOA6                         59     (A)
 DXPOA7                         60     (A)
 DXPOA8                         61     (A)
 DXPOA9                         62     (A)
 DXPOA10                        63     (A)
 DXPOA11                        64     (A)
 DXPOA12                        65     (A)
 DXPOA13                        66     (A)
 DXPOA14                        67     (A)
 DXPOA15                        68     (A)
 DXPOA16                        69     (A)
 DXPOA17                        70     (A)
 DXPOA18                        71     (A)
 DXPOA19                        72     (A)
 DXPOA20                        73     (A)
 DXPOA21                        74     (A)
 FEMALE                         75-  76
 HCUP_ED                        77-  78
 HCUP_OS                        79-  80
 HISPANIC                       81-  82
 HISPANIC_X                     83-  84 (A)
 HOSPST                         85-  86 (A)
 I10_BIRTH                      87-  89
 I10_DELIVERY                   90-  92
 I10_DX_Admitting               93-  99 (A)
 I10_DX1                       100- 106 (A)
 I10_DX2                       107- 113 (A)
 I10_DX3                       114- 120 (A)
 I10_DX4                       121- 127 (A)
 I10_DX5                       128- 134 (A)
 I10_DX6                       135- 141 (A)
 I10_DX7                       142- 148 (A)
 I10_DX8                       149- 155 (A)
 I10_DX9                       156- 162 (A)
 I10_DX10                      163- 169 (A)
 I10_DX11                      170- 176 (A)
 I10_DX12                      177- 183 (A)
 I10_DX13                      184- 190 (A)
 I10_DX14                      191- 197 (A)
 I10_DX15                      198- 204 (A)
 I10_DX16                      205- 211 (A)
 I10_DX17                      212- 218 (A)
 I10_DX18                      219- 225 (A)
 I10_DX19                      226- 232 (A)
 I10_DX20                      233- 239 (A)
 I10_DX21                      240- 246 (A)
 I10_NDX                       247- 249
 I10_NPR                       250- 252
 I10_PR1                       253- 259 (A)
 I10_PR2                       260- 266 (A)
 I10_PR3                       267- 273 (A)
 I10_PR4                       274- 280 (A)
 I10_PR5                       281- 287 (A)
 I10_PR6                       288- 294 (A)
 I10_PROCTYPE                  295- 297
 I10_SERVICELINE               298- 299
 KEY                           300- 314
 LOS                           315- 319
 LOS_X                         320- 325
 MDC                           326- 327
 MDC_NoPOA                     328- 329
 MDNUM1_R                      330- 338
 MDNUM2_R                      339- 347
 MEDINCSTQ                     348- 349
 OS_TIME                       350- 360
 P7EDSRC_X                     361- 362 (A)
 PAY1                          363- 364
 PAY1_X                        365- 366 (A)
 PAY2                          367- 368
 PAY2_X                        369- 370 (A)
 PAY3                          371- 372
 PAY3_X                        373- 374 (A)
 PCLASS_ORPROC                 375- 376
 PL_CBSA                       377- 379
 PL_NCHS                       380- 381
 PL_RUCC                       382- 383
 PL_UIC                        384- 385
 PL_UR_CAT4                    386- 387
 POA_Disch_Edit1               388- 389
 POA_Disch_Edit2               390- 391
 POA_Hosp_Edit1                392- 393
 POA_Hosp_Edit2                394- 395
 POA_Hosp_Edit3                396- 397
 POA_Hosp_Edit3_Value          398- 405
 PointOfOrigin_X               406     (A)
 PointOfOriginUB04             407     (A)
 PRDAY1                        408- 412
 PRDAY2                        413- 417
 PRDAY3                        418- 422
 PRDAY4                        423- 427
 PRDAY5                        428- 432
 PRDAY6                        433- 437
 PSTATE                        438- 439 (A)
 PSTATE_GEO                    440- 441 (A)
 PSTCO                         442- 446
 PSTCO_GEO                     447- 451
 RACE                          452- 453
 RACE_PCT_MISS_HOSP            454- 460
 RACE_X                        461- 462 (A)
 TOTCHG                        463- 472
 TOTCHG_X                      473- 487
 TRAN_IN                       488- 489
 TRAN_OUT                      490- 491
 VisitLink                     492- 500
 YEAR                          501- 504
 ZIP3                          505- 507 (A)
 ZIPINC_QRTL                   508- 510
 HOSPID                        511- 515
 AYEAR                         516- 519
 BMONTH                        520- 521
 BYEAR                         522- 525
 PRMONTH1                      526- 527
 PRMONTH2                      528- 529
 PRMONTH3                      530- 531
 PRMONTH4                      532- 533
 PRMONTH5                      534- 535
 PRMONTH6                      536- 537
 PRYEAR1                       538- 541
 PRYEAR2                       542- 545
 PRYEAR3                       546- 549
 PRYEAR4                       550- 553
 PRYEAR5                       554- 557
 PRYEAR6                       558- 561.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DaysToEvent                  (F8.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_BIRTH                    (F3.0) /
 I10_DELIVERY                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PCLASS_ORPROC                (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PSTCO                        (F4.0) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 RACE_PCT_MISS_HOSP           (F4.2) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 HOSPID                       (F4.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 DaysToEvent                  "Days from 'start date' to admission"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_BIRTH                    "ICD-10-CM Birth Indicator"
 I10_DELIVERY                 "ICD-10-CM Delivery Indicator"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 OS_TIME                      "Observation stay time summed from UNITS"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PCLASS_ORPROC                "Indicates operating room (major diagnostic or therapeutic) procedure on the record"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 RACE                         "Race (uniform)"
 RACE_PCT_MISS_HOSP           "Hospital percentage of missing or invalid race values"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 HOSPID                       "HCUP hospital identification number"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BIRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_DELIVERY
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_PCT_MISS_HOSP
 (-999.99,-888.88,-666.66,-555.55=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NM_SID_2020_CORE.SAV' /COMPRESSED.
