/*******************************************************************
*   NV_SID_2007_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'NV_SID_2007_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AHOUR                     10-  13
 AMONTH                    14-  15
 ASOURCE                   16-  17
 ASOURCEU                  18     (A)
 ASOURCE_                  19-  20 (A)
 ATYPE                     21-  22
 AWEEKEND                  23-  24
 DHOUR                     25-  28
 DIED                      29-  30
 DISPUB04                  31-  32
 DISPUNIF                  33-  34
 DISP_X                    35-  36 (A)
 DQTR                      37-  38
 DRG                       39-  41
 DRG24                     42-  44
 DRGVER                    45-  46
 DSHOSPID                  47-  59 (A)
 DX1                       60-  64 (A)
 DX2                       65-  69 (A)
 DX3                       70-  74 (A)
 DX4                       75-  79 (A)
 DX5                       80-  84 (A)
 DX6                       85-  89 (A)
 DX7                       90-  94 (A)
 DX8                       95-  99 (A)
 DX9                      100- 104 (A)
 DX10                     105- 109 (A)
 DX11                     110- 114 (A)
 DX12                     115- 119 (A)
 DX13                     120- 124 (A)
 DX14                     125- 129 (A)
 DX15                     130- 134 (A)
 DXCCS1                   135- 138
 DXCCS2                   139- 142
 DXCCS3                   143- 146
 DXCCS4                   147- 150
 DXCCS5                   151- 154
 DXCCS6                   155- 158
 DXCCS7                   159- 162
 DXCCS8                   163- 166
 DXCCS9                   167- 170
 DXCCS10                  171- 174
 DXCCS11                  175- 178
 DXCCS12                  179- 182
 DXCCS13                  183- 186
 DXCCS14                  187- 190
 DXCCS15                  191- 194
 ECODE1                   195- 199 (A)
 ECODE2                   200- 204 (A)
 ECODE3                   205- 209 (A)
 ECODE4                   210- 214 (A)
 ECODE5                   215- 219 (A)
 ECODE6                   220- 224 (A)
 ECODE7                   225- 229 (A)
 ECODE8                   230- 234 (A)
 E_CCS1                   235- 238
 E_CCS2                   239- 242
 E_CCS3                   243- 246
 E_CCS4                   247- 250
 E_CCS5                   251- 254
 E_CCS6                   255- 258
 E_CCS7                   259- 262
 E_CCS8                   263- 266
 FEMALE                   267- 268
 HCUP_ED                  269- 270
 HCUP_OS                  271- 272
 HOSPBRTH                 273- 275
 HOSPST                   276- 277 (A)
 INTENSIV                 278- 279
 KEY                      280- 293
 LOS                      294- 298
 LOS_X                    299- 304
 MARITALS                 305     (A)
 MDC                      306- 307
 MDC24                    308- 309
 MDNUM1_R                 310- 318
 MDNUM2_R                 319- 327
 MEDINCST                 328- 329
 NDX                      330- 331
 NECODE                   332- 333
 NEOMAT                   334- 335
 NPR                      336- 337
 PAY1                     338- 339
 PAY1_X                   340- 341 (A)
 PAY2                     342- 343
 PAY2_X                   344- 345 (A)
 PAY3_X                   346- 347 (A)
 PL_NCHS2                 348- 349
 PL_RUCA1                 350- 351
 PL_RUCA2                 352- 355
 PL_RUCA4                 356- 357
 PL_RUCC2                 358- 359
 PL_UIC20                 360- 361
 PL_UR_CA                 362- 363
 PNUM_R                   364- 372
 PR1                      373- 376 (A)
 PR2                      377- 380 (A)
 PR3                      381- 384 (A)
 PR4                      385- 388 (A)
 PR5                      389- 392 (A)
 PR6                      393- 396 (A)
 PR7                      397- 400 (A)
 PR8                      401- 404 (A)
 PR9                      405- 408 (A)
 PR10                     409- 412 (A)
 PRCCS1                   413- 415
 PRCCS2                   416- 418
 PRCCS3                   419- 421
 PRCCS4                   422- 424
 PRCCS5                   425- 427
 PRCCS6                   428- 430
 PRCCS7                   431- 433
 PRCCS8                   434- 436
 PRCCS9                   437- 439
 PRCCS10                  440- 442
 PRDAY1                   443- 447
 PROCTYPE                 448- 450
 PSTATE                   451- 452 (A)
 POFOUB04                 453     (A)
 POFO_X                   454- 455 (A)
 TOTCHG                   456- 465
 TOTCHG_X                 466- 480
 YEAR                     481- 484
 ZIPINC_Q                 485- 487
 AYEAR                    488- 491
 DMONTH                   492- 493
 PRMNTH1                  494- 495
 PRYEAR1                  496- 499.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 INTENSIV                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCST                (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PNUM_R                  (F5.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRDAY1                  (F4.0) /
 PROCTYPE                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 PRMNTH1                 (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AHOUR     "Admission Hour"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 DHOUR     "Discharge Hour"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG24     "DRG, version 24"
 DRGVER    "DRG grouper version used on discharge date"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 ECODE8    "E code 8"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_CCS8    "CCS: E Code 8"
 FEMALE    "Indicator of sex"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 INTENSIV
"Indicator of type of intensive care received by patient (as received from source)"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MARITALS  "Patient's marital status"
 MDC       "MDC in effect on discharge date"
 MDC24     "MDC, version 24"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2      "Secondary expected payer (uniform)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PAY3_X    "Tertiary expected payer (as received from source)"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PNUM_R    "Person number (re-identified)"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRDAY1    "Number of days from admission to PR1"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 POFOUB04  "Point of origin for admission or visit, UB-04 standard coding"
 POFO_X    "Point of origin for admission or visit, as received from source"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE INTENSIV
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NV_SID_2007_CORE.SAV' /COMPRESSED.
