/*******************************************************************
*   NY_SID_1991_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NY_SID_1991_CHGS.ASC' FIXED / 
 PROCESS               1-  11
 REVCD1               12-  15 (A)
 REVCD2               16-  19 (A)
 REVCD3               20-  23 (A)
 REVCD4               24-  27 (A)
 REVCD5               28-  31 (A)
 REVCD6               32-  35 (A)
 REVCD7               36-  39 (A)
 REVCD8               40-  43 (A)
 REVCD9               44-  47 (A)
 REVCD10              48-  51 (A)
 REVCD11              52-  55 (A)
 REVCD12              56-  59 (A)
 REVCD13              60-  63 (A)
 REVCD14              64-  67 (A)
 REVCD15              68-  71 (A)
 REVCD16              72-  75 (A)
 REVCD17              76-  79 (A)
 REVCD18              80-  83 (A)
 REVCD19              84-  87 (A)
 REVCD20              88-  91 (A)
 REVCD21              92-  95 (A)
 REVCD22              96-  99 (A)
 REVCD23             100- 103 (A)
 REVCD24             104- 107 (A)
 REVCD25             108- 111 (A)
 UNIT1               112- 119
 UNIT2               120- 127
 UNIT3               128- 135
 UNIT4               136- 143
 UNIT5               144- 151
 CHG1                152- 163
 CHG2                164- 175
 CHG3                176- 187
 CHG4                188- 199
 CHG5                200- 211
 CHG6                212- 223
 CHG7                224- 235
 CHG8                236- 247
 CHG9                248- 259
 CHG10               260- 271
 CHG11               272- 283
 CHG12               284- 295
 CHG13               296- 307
 CHG14               308- 319
 CHG15               320- 331
 CHG16               332- 343
 CHG17               344- 355
 CHG18               356- 367
 CHG19               368- 379
 CHG20               380- 391
 CHG21               392- 403
 CHG22               404- 415
 CHG23               416- 427
 CHG24               428- 439
 CHG25               440- 451
 CHG26               452- 463
 RATE1               464- 471
 RATE2               472- 479
 RATE3               480- 487
 RATE4               488- 495
 RATE5               496- 503.


***  Specify write formats  ***.
FORMATS
 PROCESS             (F6.0) /
 UNIT1               (F3.0) /
 UNIT2               (F3.0) /
 UNIT3               (F3.0) /
 UNIT4               (F3.0) /
 UNIT5               (F3.0) /
 CHG1                (F5.2) /
 CHG2                (F5.2) /
 CHG3                (F5.2) /
 CHG4                (F5.2) /
 CHG5                (F5.2) /
 CHG6                (F5.2) /
 CHG7                (F5.2) /
 CHG8                (F5.2) /
 CHG9                (F5.2) /
 CHG10               (F5.2) /
 CHG11               (F5.2) /
 CHG12               (F5.2) /
 CHG13               (F5.2) /
 CHG14               (F5.2) /
 CHG15               (F5.2) /
 CHG16               (F5.2) /
 CHG17               (F5.2) /
 CHG18               (F5.2) /
 CHG19               (F5.2) /
 CHG20               (F5.2) /
 CHG21               (F5.2) /
 CHG22               (F5.2) /
 CHG23               (F5.2) /
 CHG24               (F5.2) /
 CHG25               (F5.2) /
 CHG26               (F5.2) /
 RATE1               (F5.2) /
 RATE2               (F5.2) /
 RATE3               (F5.2) /
 RATE4               (F5.2) /
 RATE5               (F5.2) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 PROCESS   "I:HCUP-3 discharge processing ID number"
 REVCD1    "I:Revenue code 1 (from data source)"
 REVCD2    "I:Revenue code 2 (from data source)"
 REVCD3    "I:Revenue code 3 (from data source)"
 REVCD4    "I:Revenue code 4 (from data source)"
 REVCD5    "I:Revenue code 5 (from data source)"
 REVCD6    "I:Revenue code 6 (from data source)"
 REVCD7    "I:Revenue code 7 (from data source)"
 REVCD8    "I:Revenue code 8 (from data source)"
 REVCD9    "I:Revenue code 9 (from data source)"
 REVCD10   "I:Revenue code 10 (from data source)"
 REVCD11   "I:Revenue code 11 (from data source)"
 REVCD12   "I:Revenue code 12 (from data source)"
 REVCD13   "I:Revenue code 13 (from data source)"
 REVCD14   "I:Revenue code 14 (from data source)"
 REVCD15   "I:Revenue code 15 (from data source)"
 REVCD16   "I:Revenue code 16 (from data source)"
 REVCD17   "I:Revenue code 17 (from data source)"
 REVCD18   "I:Revenue code 18 (from data source)"
 REVCD19   "I:Revenue code 19 (from data source)"
 REVCD20   "I:Revenue code 20 (from data source)"
 REVCD21   "I:Revenue code 21 (from data source)"
 REVCD22   "I:Revenue code 22 (from data source)"
 REVCD23   "I:Revenue code 23 (from data source)"
 REVCD24   "I:Revenue code 24 (from data source)"
 REVCD25   "I:Revenue code 25 (from data source)"
 UNIT1     "I:Units of service 1 (from data source)"
 UNIT2     "I:Units of service 2 (from data source)"
 UNIT3     "I:Units of service 3 (from data source)"
 UNIT4     "I:Units of service 4 (from data source)"
 UNIT5     "I:Units of service 5 (from data source)"
 CHG1      "I:Detailed charges 1 (from data source)"
 CHG2      "I:Detailed charges 2 (from data source)"
 CHG3      "I:Detailed charges 3 (from data source)"
 CHG4      "I:Detailed charges 4 (from data source)"
 CHG5      "I:Detailed charges 5 (from data source)"
 CHG6      "I:Detailed charges 6 (from data source)"
 CHG7      "I:Detailed charges 7 (from data source)"
 CHG8      "I:Detailed charges 8 (from data source)"
 CHG9      "I:Detailed charges 9 (from data source)"
 CHG10     "I:Detailed charges 10 (from data source)"
 CHG11     "I:Detailed charges 11 (from data source)"
 CHG12     "I:Detailed charges 12 (from data source)"
 CHG13     "I:Detailed charges 13 (from data source)"
 CHG14     "I:Detailed charges 14 (from data source)"
 CHG15     "I:Detailed charges 15 (from data source)"
 CHG16     "I:Detailed charges 16 (from data source)"
 CHG17     "I:Detailed charges 17 (from data source)"
 CHG18     "I:Detailed charges 18 (from data source)"
 CHG19     "I:Detailed charges 19 (from data source)"
 CHG20     "I:Detailed charges 20 (from data source)"
 CHG21     "I:Detailed charges 21 (from data source)"
 CHG22     "I:Detailed charges 22 (from data source)"
 CHG23     "I:Detailed charges 23 (from data source)"
 CHG24     "I:Detailed charges 24 (from data source)"
 CHG25     "I:Detailed charges 25 (from data source)"
 CHG26     "I:Detailed charges 26 (from data source)"
 RATE1     "I:Daily rate 1 (from data source)"
 RATE2     "I:Daily rate 2 (from data source)"
 RATE3     "I:Daily rate 3 (from data source)"
 RATE4     "I:Daily rate 4 (from data source)"
 RATE5     "I:Daily rate 5 (from data source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE UNIT1
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT2
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT3
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT4
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT5
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG4
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG5
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG6
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG7
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG8
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG9
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG10
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG11
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG12
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG13
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG14
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG15
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG16
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG17
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG18
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG19
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG20
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG21
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG22
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG23
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG24
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG25
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG26
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE RATE1
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE RATE2
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE RATE3
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE RATE4
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE RATE5
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).



SAVE OUTFILE = 'NY_SID_1991_CHGS.SAV' /COMPRESSED.
