/*******************************************************************
*   NY_SID_1994_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NY_SID_1994_CHGS.ASC' FIXED / 
 SEQ_SID               1-  13
 PROCESS              14-  24
 REVCD1               25-  28 (A)
 REVCD2               29-  32 (A)
 REVCD3               33-  36 (A)
 REVCD4               37-  40 (A)
 REVCD5               41-  44 (A)
 REVCD6               45-  48 (A)
 REVCD7               49-  52 (A)
 REVCD8               53-  56 (A)
 REVCD9               57-  60 (A)
 REVCD10              61-  64 (A)
 REVCD11              65-  68 (A)
 REVCD12              69-  72 (A)
 REVCD13              73-  76 (A)
 REVCD14              77-  80 (A)
 REVCD15              81-  84 (A)
 REVCD16              85-  88 (A)
 REVCD17              89-  92 (A)
 REVCD18              93-  96 (A)
 REVCD19              97- 100 (A)
 REVCD20             101- 104 (A)
 REVCD21             105- 108 (A)
 REVCD22             109- 112 (A)
 REVCD23             113- 116 (A)
 REVCD24             117- 120 (A)
 REVCD25             121- 124 (A)
 UNIT1               125- 132
 UNIT2               133- 140
 UNIT3               141- 148
 UNIT4               149- 156
 UNIT5               157- 164
 CHG1                165- 176
 CHG2                177- 188
 CHG3                189- 200
 CHG4                201- 212
 CHG5                213- 224
 CHG6                225- 236
 CHG7                237- 248
 CHG8                249- 260
 CHG9                261- 272
 CHG10               273- 284
 CHG11               285- 296
 CHG12               297- 308
 CHG13               309- 320
 CHG14               321- 332
 CHG15               333- 344
 CHG16               345- 356
 CHG17               357- 368
 CHG18               369- 380
 CHG19               381- 392
 CHG20               393- 404
 CHG21               405- 416
 CHG22               417- 428
 CHG23               429- 440
 CHG24               441- 452
 CHG25               453- 464
 RATE1               465- 472
 RATE2               473- 480
 RATE3               481- 488
 RATE4               489- 496
 RATE5               497- 504.


***  Specify write formats  ***.
FORMATS
 SEQ_SID             (F8.0) /
 PROCESS             (F7.0) /
 UNIT1               (F4.0) /
 UNIT2               (F4.0) /
 UNIT3               (F4.0) /
 UNIT4               (F4.0) /
 UNIT5               (F4.0) /
 CHG1                (F6.2) /
 CHG2                (F6.2) /
 CHG3                (F6.2) /
 CHG4                (F6.2) /
 CHG5                (F6.2) /
 CHG6                (F6.2) /
 CHG7                (F6.2) /
 CHG8                (F6.2) /
 CHG9                (F6.2) /
 CHG10               (F6.2) /
 CHG11               (F6.2) /
 CHG12               (F6.2) /
 CHG13               (F6.2) /
 CHG14               (F6.2) /
 CHG15               (F6.2) /
 CHG16               (F6.2) /
 CHG17               (F6.2) /
 CHG18               (F6.2) /
 CHG19               (F6.2) /
 CHG20               (F6.2) /
 CHG21               (F6.2) /
 CHG22               (F6.2) /
 CHG23               (F6.2) /
 CHG24               (F6.2) /
 CHG25               (F6.2) /
 RATE1               (F6.2) /
 RATE2               (F6.2) /
 RATE3               (F6.2) /
 RATE4               (F6.2) /
 RATE5               (F6.2) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 SEQ_SID   "I:HCUP-3 SID record sequence number"
 PROCESS   "I:HCUP-3 discharge processing ID number"
 REVCD1    "I:Revenue code 1 (from data source)"
 REVCD2    "I:Revenue code 2 (from data source)"
 REVCD3    "I:Revenue code 3 (from data source)"
 REVCD4    "I:Revenue code 4 (from data source)"
 REVCD5    "I:Revenue code 5 (from data source)"
 REVCD6    "I:Revenue code 6 (from data source)"
 REVCD7    "I:Revenue code 7 (from data source)"
 REVCD8    "I:Revenue code 8 (from data source)"
 REVCD9    "I:Revenue code 9 (from data source)"
 REVCD10   "I:Revenue code 10 (from data source)"
 REVCD11   "I:Revenue code 11 (from data source)"
 REVCD12   "I:Revenue code 12 (from data source)"
 REVCD13   "I:Revenue code 13 (from data source)"
 REVCD14   "I:Revenue code 14 (from data source)"
 REVCD15   "I:Revenue code 15 (from data source)"
 REVCD16   "I:Revenue code 16 (from data source)"
 REVCD17   "I:Revenue code 17 (from data source)"
 REVCD18   "I:Revenue code 18 (from data source)"
 REVCD19   "I:Revenue code 19 (from data source)"
 REVCD20   "I:Revenue code 20 (from data source)"
 REVCD21   "I:Revenue code 21 (from data source)"
 REVCD22   "I:Revenue code 22 (from data source)"
 REVCD23   "I:Revenue code 23 (from data source)"
 REVCD24   "I:Revenue code 24 (from data source)"
 REVCD25   "I:Revenue code 25 (from data source)"
 UNIT1     "I:Units of service 1 (from data source)"
 UNIT2     "I:Units of service 2 (from data source)"
 UNIT3     "I:Units of service 3 (from data source)"
 UNIT4     "I:Units of service 4 (from data source)"
 UNIT5     "I:Units of service 5 (from data source)"
 CHG1      "I:Detailed charges 1 (from data source)"
 CHG2      "I:Detailed charges 2 (from data source)"
 CHG3      "I:Detailed charges 3 (from data source)"
 CHG4      "I:Detailed charges 4 (from data source)"
 CHG5      "I:Detailed charges 5 (from data source)"
 CHG6      "I:Detailed charges 6 (from data source)"
 CHG7      "I:Detailed charges 7 (from data source)"
 CHG8      "I:Detailed charges 8 (from data source)"
 CHG9      "I:Detailed charges 9 (from data source)"
 CHG10     "I:Detailed charges 10 (from data source)"
 CHG11     "I:Detailed charges 11 (from data source)"
 CHG12     "I:Detailed charges 12 (from data source)"
 CHG13     "I:Detailed charges 13 (from data source)"
 CHG14     "I:Detailed charges 14 (from data source)"
 CHG15     "I:Detailed charges 15 (from data source)"
 CHG16     "I:Detailed charges 16 (from data source)"
 CHG17     "I:Detailed charges 17 (from data source)"
 CHG18     "I:Detailed charges 18 (from data source)"
 CHG19     "I:Detailed charges 19 (from data source)"
 CHG20     "I:Detailed charges 20 (from data source)"
 CHG21     "I:Detailed charges 21 (from data source)"
 CHG22     "I:Detailed charges 22 (from data source)"
 CHG23     "I:Detailed charges 23 (from data source)"
 CHG24     "I:Detailed charges 24 (from data source)"
 CHG25     "I:Detailed charges 25 (from data source)"
 RATE1     "I:Daily rate 1 (from data source)"
 RATE2     "I:Daily rate 2 (from data source)"
 RATE3     "I:Daily rate 3 (from data source)"
 RATE4     "I:Daily rate 4 (from data source)"
 RATE5     "I:Daily rate 5 (from data source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE UNIT1
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT2
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT3
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT4
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE UNIT5
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG4
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG5
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG6
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG7
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG8
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG9
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG10
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG11
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG12
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG13
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG14
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG15
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG16
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG17
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG18
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG19
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG20
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG21
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG22
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG23
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG24
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG25
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE RATE1
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE RATE2
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE RATE3
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE RATE4
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE RATE5
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).



SAVE OUTFILE = 'NY_SID_1994_CHGS.SAV' /COMPRESSED.
