/*******************************************************************
*   NY_SID_2005_AHAL.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY AHAL FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'NY_SID_2005_AHAL.ASC' FIXED / 
 AHAID                      1-   7 (A)
 DSHOSPID                   8-  20 (A)
 HOSPID                    21-  25
 HOSPST                    26-  27 (A)
 HOSPSTCO                  28-  32
 YEAR                      33-  36.


***  Specify write formats  ***.
FORMATS
 HOSPID                  (F4.0) /
 HOSPSTCO                (F4.0) /
 YEAR                    (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AHAID     "AHA hospital identifier with the leading 6"
 DSHOSPID  "Data source hospital identifier"
 HOSPID    "HCUP hospital identification number"
 HOSPST    "Hospital state postal code"
 HOSPSTCO  "Hospital modified FIPS state/county code"
 YEAR      "Calendar year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE HOSPSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).



SAVE OUTFILE = 'NY_SID_2005_AHAL.SAV' /COMPRESSED.
