/*******************************************************************
*   NY_SID_2006_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'NY_SID_2006_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEDAY                    18-  20
 AGEMONTH                  21-  23
 AHOUR                     24-  27
 AMONTH                    28-  29
 ANESTH                    30-  32
 ASCHED                    33-  34
 ASOURCE                   35-  36
 ASOURCE_                  37     (A)
 ASOURCEU                  38     (A)
 ATYPE                     39-  40
 AWEEKEND                  41-  42
 BLOOD                     43-  48
 BWT                       49-  52
 DHOUR                     53-  56
 DIED                      57-  58
 DISP_X                    59-  60 (A)
 DISPUB92                  61-  62
 DISPUNIF                  63-  64
 DQTR                      65-  66
 DRG                       67-  69
 DRG18                     70-  72
 DRG24                     73-  75
 DRGVER                    76-  77
 DSHOSPID                  78-  90 (A)
 DX1                       91-  95 (A)
 DX2                       96- 100 (A)
 DX3                      101- 105 (A)
 DX4                      106- 110 (A)
 DX5                      111- 115 (A)
 DX6                      116- 120 (A)
 DX7                      121- 125 (A)
 DX8                      126- 130 (A)
 DX9                      131- 135 (A)
 DX10                     136- 140 (A)
 DX11                     141- 145 (A)
 DX12                     146- 150 (A)
 DX13                     151- 155 (A)
 DX14                     156- 160 (A)
 DX15                     161- 165 (A)
 DXATAD1                  166- 167
 DXATAD2                  168- 169
 DXATAD3                  170- 171
 DXATAD4                  172- 173
 DXATAD5                  174- 175
 DXATAD6                  176- 177
 DXATAD7                  178- 179
 DXATAD8                  180- 181
 DXATAD9                  182- 183
 DXATAD10                 184- 185
 DXATAD11                 186- 187
 DXATAD12                 188- 189
 DXATAD13                 190- 191
 DXATAD14                 192- 193
 DXATAD15                 194- 195
 DXCCS1                   196- 199
 DXCCS2                   200- 203
 DXCCS3                   204- 207
 DXCCS4                   208- 211
 DXCCS5                   212- 215
 DXCCS6                   216- 219
 DXCCS7                   220- 223
 DXCCS8                   224- 227
 DXCCS9                   228- 231
 DXCCS10                  232- 235
 DXCCS11                  236- 239
 DXCCS12                  240- 243
 DXCCS13                  244- 247
 DXCCS14                  248- 251
 DXCCS15                  252- 255
 ECODE1                   256- 260 (A)
 ECODE2                   261- 265 (A)
 ECODE3                   266- 270 (A)
 ECODE4                   271- 275 (A)
 ECODE5                   276- 280 (A)
 ECODE6                   281- 285 (A)
 ECODE7                   286- 290 (A)
 ECODE8                   291- 295 (A)
 E_CCS1                   296- 299
 E_CCS2                   300- 303
 E_CCS3                   304- 307
 E_CCS4                   308- 311
 E_CCS5                   312- 315
 E_CCS6                   316- 319
 E_CCS7                   320- 323
 E_CCS8                   324- 327
 FEMALE                   328- 329
 HCUP_ED                  330- 331
 HCUP_OS                  332- 333
 HISPANIC                 334     (A)
 Homeless                 335- 336
 HOSPBRTH                 337- 339
 HOSPST                   340- 341 (A)
 LOS                      342- 346
 LOS_X                    347- 352
 MDC                      353- 354
 MDC18                    355- 356
 MDC24                    357- 358
 MDNUM1_R                 359- 367
 MDNUM2_R                 368- 376
 MEDINCST                 377- 378
 NDX                      379- 380
 NECODE                   381- 382
 NEOMAT                   383- 384
 NPR                      385- 386
 PAY1                     387- 388
 PAY2                     389- 390
 PAY1_X                   391- 392 (A)
 PAY2_X                   393- 394 (A)
 PAY3_X                   395- 396 (A)
 PL_CBSA                  397- 399
 PL_MSA19                 400- 402
 PL_NHCS2                 403- 404
 PL_RUCA1                 405- 406
 PL_RUCA2                 407- 410
 PL_RUCA4                 411- 412
 PL_RUCC2                 413- 414
 PL_UIC20                 415- 416
 PL_UR_CA                 417- 418
 PL_UR_CA                 419- 420
 PR1                      421- 424 (A)
 PR2                      425- 428 (A)
 PR3                      429- 432 (A)
 PR4                      433- 436 (A)
 PR5                      437- 440 (A)
 PR6                      441- 444 (A)
 PR7                      445- 448 (A)
 PR8                      449- 452 (A)
 PR9                      453- 456 (A)
 PR10                     457- 460 (A)
 PR11                     461- 464 (A)
 PR12                     465- 468 (A)
 PR13                     469- 472 (A)
 PR14                     473- 476 (A)
 PR15                     477- 480 (A)
 PRCCS1                   481- 483
 PRCCS2                   484- 486
 PRCCS3                   487- 489
 PRCCS4                   490- 492
 PRCCS5                   493- 495
 PRCCS6                   496- 498
 PRCCS7                   499- 501
 PRCCS8                   502- 504
 PRCCS9                   505- 507
 PRCCS10                  508- 510
 PRCCS11                  511- 513
 PRCCS12                  514- 516
 PRCCS13                  517- 519
 PRCCS14                  520- 522
 PRCCS15                  523- 525
 PRDAY1                   526- 530
 PRDAY2                   531- 535
 PRDAY3                   536- 540
 PRDAY4                   541- 545
 PRDAY5                   546- 550
 PRDAY6                   551- 555
 PRDAY7                   556- 560
 PRDAY8                   561- 565
 PRDAY9                   566- 570
 PRDAY10                  571- 575
 PRDAY11                  576- 580
 PRDAY12                  581- 585
 PRDAY13                  586- 590
 PRDAY14                  591- 595
 PRDAY15                  596- 600
 PROCTYPE                 601- 603
 PSTATE                   604- 605 (A)
 PSTCO                    606- 610
 PSTCO2                   611- 615
 RACE                     616- 617
 RACE_X                   618- 619 (A)
 TOTCHG                   620- 629
 TOTCHG_X                 630- 644
 YEAR                     645- 648
 ZIPINC_Q                 649- 651
 ZIP                      652- 656 (A)
 AYEAR                    657- 660
 DMONTH                   661- 662
 BMONTH                   663- 664
 BYEAR                    665- 668
 PRMNTH1                  669- 670
 PRMNTH2                  671- 672
 PRMNTH3                  673- 674
 PRMNTH4                  675- 676
 PRMNTH5                  677- 678
 PRMNTH6                  679- 680
 PRMNTH7                  681- 682
 PRMNTH8                  683- 684
 PRMNTH9                  685- 686
 PRMNTH10                 687- 688
 PRMNTH11                 689- 690
 PRMNTH12                 691- 692
 PRMNTH13                 693- 694
 PRMNTH14                 695- 696
 PRMNTH15                 697- 698
 PRYEAR1                  699- 702
 PRYEAR2                  703- 706
 PRYEAR3                  707- 710
 PRYEAR4                  711- 714
 PRYEAR5                  715- 718
 PRYEAR6                  719- 722
 PRYEAR7                  723- 726
 PRYEAR8                  727- 730
 PRYEAR9                  731- 734
 PRYEAR10                 735- 738
 PRYEAR11                 739- 742
 PRYEAR12                 743- 746
 PRYEAR13                 747- 750
 PRYEAR14                 751- 754
 PRYEAR15                 755- 758.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ANESTH                  (F3.0) /
 ASCHED                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BLOOD                   (F4.0) /
 BWT                     (F4.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB92                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG18                   (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DXATAD1                 (F3.0) /
 DXATAD2                 (F3.0) /
 DXATAD3                 (F3.0) /
 DXATAD4                 (F3.0) /
 DXATAD5                 (F3.0) /
 DXATAD6                 (F3.0) /
 DXATAD7                 (F3.0) /
 DXATAD8                 (F3.0) /
 DXATAD9                 (F3.0) /
 DXATAD10                (F3.0) /
 DXATAD11                (F3.0) /
 DXATAD12                (F3.0) /
 DXATAD13                (F3.0) /
 DXATAD14                (F3.0) /
 DXATAD15                (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 Homeless                (F3.0) /
 HOSPBRTH                (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC18                   (F3.0) /
 MDC24                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MEDINCST                (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NHCS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRMNTH7                 (F3.0) /
 PRMNTH8                 (F3.0) /
 PRMNTH9                 (F3.0) /
 PRMNTH10                (F3.0) /
 PRMNTH11                (F3.0) /
 PRMNTH12                (F3.0) /
 PRMNTH13                (F3.0) /
 PRMNTH14                (F3.0) /
 PRMNTH15                (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AHOUR     "Admission Hour"
 AMONTH    "Admission month"
 ANESTH    "Method of anesthesia"
 ASCHED    "Admission scheduled vs. unscheduled"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 BLOOD     "Pints of blood furnished to the patient"
 BWT       "Birth weight in grams"
 DHOUR     "Discharge Hour"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRG24     "DRG, version 24"
 DRGVER    "DRG grouper version used on discharge date"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DXATAD1   "Principal diagnosis present at admission"
 DXATAD2   "Diagnosis 2 present at admission"
 DXATAD3   "Diagnosis 3 present at admission"
 DXATAD4   "Diagnosis 4 present at admission"
 DXATAD5   "Diagnosis 5 present at admission"
 DXATAD6   "Diagnosis 6 present at admission"
 DXATAD7   "Diagnosis 7 present at admission"
 DXATAD8   "Diagnosis 8 present at admission"
 DXATAD9   "Diagnosis 9 present at admission"
 DXATAD10  "Diagnosis 10 present at admission"
 DXATAD11  "Diagnosis 11 present at admission"
 DXATAD12  "Diagnosis 12 present at admission"
 DXATAD13  "Diagnosis 13 present at admission"
 DXATAD14  "Diagnosis 14 present at admission"
 DXATAD15  "Diagnosis 15 present at admission"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 ECODE8    "E code 8"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_CCS8    "CCS: E Code 8"
 FEMALE    "Indicator of sex"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 Homeless  "Indicator that patient is homeless"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 MDC24     "MDC, version 24"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY2      "Secondary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PAY3_X    "Tertiary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NHCS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRMNTH11  "Month of procedure 11"
 PRMNTH12  "Month of procedure 12"
 PRMNTH13  "Month of procedure 13"
 PRMNTH14  "Month of procedure 14"
 PRMNTH15  "Month of procedure 15"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10"
 PRYEAR11  "Year of procedure 11"
 PRYEAR12  "Year of procedure 12"
 PRYEAR13  "Year of procedure 13"
 PRYEAR14  "Year of procedure 14"
 PRYEAR15  "Year of procedure 15" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ANESTH
 (-99,-88,-66,-55=SYSMIS).
RECODE ASCHED
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BLOOD
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD1
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD2
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD3
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD4
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD5
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD6
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD7
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD8
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD9
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD10
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD11
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD12
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD13
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD14
 (-9,-8,-6,-5=SYSMIS).
RECODE DXATAD15
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NHCS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NY_SID_2006_CORE.SAV' /COMPRESSED.
