/*******************************************************************
* Creation Date: 01/07/2019   
*   OR_SID_2017_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'OR_SID_2017_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BWT                            20-  23
 DHOUR                          24-  27
 DIED                           28-  29
 DISP_X                         30-  31 (A)
 DISPUB04                       32-  33
 DISPUNIFORM                    34-  35
 DMONTH                         36-  37
 DNR                            38-  39
 DQTR                           40-  41
 DRG                            42-  44
 DRG_NoPOA                      45-  47
 DRGVER                         48-  49
 DSHOSPID                       50-  66 (A)
 DXPOA1                         67     (A)
 DXPOA2                         68     (A)
 DXPOA3                         69     (A)
 DXPOA4                         70     (A)
 DXPOA5                         71     (A)
 DXPOA6                         72     (A)
 DXPOA7                         73     (A)
 DXPOA8                         74     (A)
 DXPOA9                         75     (A)
 DXPOA10                        76     (A)
 DXPOA11                        77     (A)
 DXPOA12                        78     (A)
 DXPOA13                        79     (A)
 DXPOA14                        80     (A)
 DXPOA15                        81     (A)
 DXPOA16                        82     (A)
 DXPOA17                        83     (A)
 DXPOA18                        84     (A)
 DXPOA19                        85     (A)
 DXPOA20                        86     (A)
 DXPOA21                        87     (A)
 DXPOA22                        88     (A)
 DXPOA23                        89     (A)
 DXPOA24                        90     (A)
 DXPOA25                        91     (A)
 DXPOA26                        92     (A)
 DXPOA27                        93     (A)
 DXPOA28                        94     (A)
 DXPOA29                        95     (A)
 DXPOA30                        96     (A)
 DXPOA31                        97     (A)
 DXPOA32                        98     (A)
 DXPOA33                        99     (A)
 DXVER                         100- 102
 FEMALE                        103- 104
 HCUP_ED                       105- 106
 HCUP_OS                       107- 108
 HISPANIC                      109- 110
 HISPANIC_X                    111- 112 (A)
 HospitalUnit                  113- 114
 HOSPST                        115- 116 (A)
 I10_DX_Admitting              117- 123 (A)
 I10_DX1                       124- 130 (A)
 I10_DX2                       131- 137 (A)
 I10_DX3                       138- 144 (A)
 I10_DX4                       145- 151 (A)
 I10_DX5                       152- 158 (A)
 I10_DX6                       159- 165 (A)
 I10_DX7                       166- 172 (A)
 I10_DX8                       173- 179 (A)
 I10_DX9                       180- 186 (A)
 I10_DX10                      187- 193 (A)
 I10_DX11                      194- 200 (A)
 I10_DX12                      201- 207 (A)
 I10_DX13                      208- 214 (A)
 I10_DX14                      215- 221 (A)
 I10_DX15                      222- 228 (A)
 I10_DX16                      229- 235 (A)
 I10_DX17                      236- 242 (A)
 I10_DX18                      243- 249 (A)
 I10_DX19                      250- 256 (A)
 I10_DX20                      257- 263 (A)
 I10_DX21                      264- 270 (A)
 I10_DX22                      271- 277 (A)
 I10_DX23                      278- 284 (A)
 I10_DX24                      285- 291 (A)
 I10_DX25                      292- 298 (A)
 I10_DX26                      299- 305 (A)
 I10_DX27                      306- 312 (A)
 I10_DX28                      313- 319 (A)
 I10_DX29                      320- 326 (A)
 I10_DX30                      327- 333 (A)
 I10_DX31                      334- 340 (A)
 I10_DX32                      341- 347 (A)
 I10_DX33                      348- 354 (A)
 I10_NDX                       355- 357
 I10_NPR                       358- 360
 I10_PR1                       361- 367 (A)
 I10_PR2                       368- 374 (A)
 I10_PR3                       375- 381 (A)
 I10_PR4                       382- 388 (A)
 I10_PR5                       389- 395 (A)
 I10_PR6                       396- 402 (A)
 I10_PR7                       403- 409 (A)
 I10_PR8                       410- 416 (A)
 I10_PR9                       417- 423 (A)
 I10_PR10                      424- 430 (A)
 I10_PR11                      431- 437 (A)
 I10_PR12                      438- 444 (A)
 I10_PR13                      445- 451 (A)
 I10_PR14                      452- 458 (A)
 I10_PR15                      459- 465 (A)
 I10_PR16                      466- 472 (A)
 I10_PR17                      473- 479 (A)
 I10_PR18                      480- 486 (A)
 I10_PR19                      487- 493 (A)
 I10_PR20                      494- 500 (A)
 I10_PR21                      501- 507 (A)
 I10_PR22                      508- 514 (A)
 I10_PR23                      515- 521 (A)
 I10_PR24                      522- 528 (A)
 I10_PROCTYPE                  529- 531
 KEY                           532- 546
 LOS                           547- 551
 LOS_X                         552- 557
 MDC                           558- 559
 MDC_NoPOA                     560- 561
 MDNUM1_R                      562- 570
 MDNUM2_R                      571- 579
 MDNUM3_R                      580- 588
 MDNUM4_R                      589- 597
 MEDINCSTQ                     598- 599
 OS_TIME                       600- 610
 PAY1                          611- 612
 PAY1_X                        613- 621 (A)
 PAY2                          622- 623
 PAY2_X                        624- 632 (A)
 PAY3                          633- 634
 PAY3_X                        635- 643 (A)
 PL_CBSA                       644- 646
 PL_NCHS                       647- 648
 PL_RUCC                       649- 650
 PL_UIC                        651- 652
 PL_UR_CAT4                    653- 654
 POA_Disch_Edit1               655- 656
 POA_Disch_Edit2               657- 658
 POA_Hosp_Edit1                659- 660
 POA_Hosp_Edit2                661- 662
 POA_Hosp_Edit3                663- 664
 POA_Hosp_Edit3_Value          665- 672
 PointOfOrigin_X               673- 674 (A)
 PointOfOriginUB04             675     (A)
 PRDAY1                        676- 680
 PRDAY2                        681- 685
 PRDAY3                        686- 690
 PRDAY4                        691- 695
 PRDAY5                        696- 700
 PRDAY6                        701- 705
 PRDAY7                        706- 710
 PRDAY8                        711- 715
 PRDAY9                        716- 720
 PRDAY10                       721- 725
 PRDAY11                       726- 730
 PRDAY12                       731- 735
 PRDAY13                       736- 740
 PRDAY14                       741- 745
 PRDAY15                       746- 750
 PRDAY16                       751- 755
 PRDAY17                       756- 760
 PRDAY18                       761- 765
 PRDAY19                       766- 770
 PRDAY20                       771- 775
 PRDAY21                       776- 780
 PRDAY22                       781- 785
 PRDAY23                       786- 790
 PRDAY24                       791- 795
 PRVER                         796- 798
 PSTATE                        799- 800 (A)
 PSTCO                         801- 805
 PSTCO2                        806- 810
 RACE                          811- 812
 RACE_EDIT                     813- 814
 RACE_X                        815- 816 (A)
 TOTCHG                        817- 826
 TOTCHG_X                      827- 841
 TRAN_IN                       842- 843
 TRAN_OUT                      844- 845
 YEAR                          846- 849
 ZIP                           850- 854 (A)
 ZIP3                          855- 857 (A)
 ZIPINC_QRTL                   858- 860
 AYEAR                         861- 864
 BMONTH                        865- 866
 BYEAR                         867- 870
 PRMONTH1                      871- 872
 PRMONTH2                      873- 874
 PRMONTH3                      875- 876
 PRMONTH4                      877- 878
 PRMONTH5                      879- 880
 PRMONTH6                      881- 882
 PRMONTH7                      883- 884
 PRMONTH8                      885- 886
 PRMONTH9                      887- 888
 PRMONTH10                     889- 890
 PRMONTH11                     891- 892
 PRMONTH12                     893- 894
 PRMONTH13                     895- 896
 PRMONTH14                     897- 898
 PRMONTH15                     899- 900
 PRMONTH16                     901- 902
 PRMONTH17                     903- 904
 PRMONTH18                     905- 906
 PRMONTH19                     907- 908
 PRMONTH20                     909- 910
 PRMONTH21                     911- 912
 PRMONTH22                     913- 914
 PRMONTH23                     915- 916
 PRMONTH24                     917- 918
 PRYEAR1                       919- 922
 PRYEAR2                       923- 926
 PRYEAR3                       927- 930
 PRYEAR4                       931- 934
 PRYEAR5                       935- 938
 PRYEAR6                       939- 942
 PRYEAR7                       943- 946
 PRYEAR8                       947- 950
 PRYEAR9                       951- 954
 PRYEAR10                      955- 958
 PRYEAR11                      959- 962
 PRYEAR12                      963- 966
 PRYEAR13                      967- 970
 PRYEAR14                      971- 974
 PRYEAR15                      975- 978
 PRYEAR16                      979- 982
 PRYEAR17                      983- 986
 PRYEAR18                      987- 990
 PRYEAR19                      991- 994
 PRYEAR20                      995- 998
 PRYEAR21                      999-1002
 PRYEAR22                     1003-1006
 PRYEAR23                     1007-1010
 PRYEAR24                     1011-1014.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DNR                          (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 HospitalUnit                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 RACE_EDIT                    (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BWT                          "Birth weight in grams"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DNR                          "Do not resuscitate indicator"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXVER                        "Diagnosis Version"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HospitalUnit
"Patient was discharged from a special unit within an acute care hospital (reported by source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_EDIT                    "Race Edit Checks"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_EDIT
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'OR_SID_2017_CORE.SAV' /COMPRESSED.
