/*******************************************************************
* Creation Date: 09/16/2016   
*   SC_SID_2009_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'SC_SID_2009_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 CHRON1                          1-   2
 CHRON2                          3-   4
 CHRON3                          5-   6
 CHRON4                          7-   8
 CHRON5                          9-  10
 CHRON6                         11-  12
 CHRON7                         13-  14
 CHRON8                         15-  16
 CHRON9                         17-  18
 CHRON10                        19-  20
 CHRON11                        21-  22
 CHRON12                        23-  24
 CHRON13                        25-  26
 CHRON14                        27-  28
 CHRON15                        29-  30
 CHRONB1                        31-  32
 CHRONB2                        33-  34
 CHRONB3                        35-  36
 CHRONB4                        37-  38
 CHRONB5                        39-  40
 CHRONB6                        41-  42
 CHRONB7                        43-  44
 CHRONB8                        45-  46
 CHRONB9                        47-  48
 CHRONB10                       49-  50
 CHRONB11                       51-  52
 CHRONB12                       53-  54
 CHRONB13                       55-  56
 CHRONB14                       57-  58
 CHRONB15                       59-  60
 DXMCCS1                        61-  71 (A)
 DXMCCS2                        72-  82 (A)
 DXMCCS3                        83-  93 (A)
 DXMCCS4                        94- 104 (A)
 DXMCCS5                       105- 115 (A)
 DXMCCS6                       116- 126 (A)
 DXMCCS7                       127- 137 (A)
 DXMCCS8                       138- 148 (A)
 DXMCCS9                       149- 159 (A)
 DXMCCS10                      160- 170 (A)
 DXMCCS11                      171- 181 (A)
 DXMCCS12                      182- 192 (A)
 DXMCCS13                      193- 203 (A)
 DXMCCS14                      204- 214 (A)
 DXMCCS15                      215- 225 (A)
 E_MCCS1                       226- 236 (A)
 E_MCCS2                       237- 247 (A)
 E_MCCS3                       248- 258 (A)
 E_MCCS4                       259- 269 (A)
 E_MCCS5                       270- 280 (A)
 E_MCCS6                       281- 291 (A)
 E_MCCS7                       292- 302 (A)
 E_MCCS8                       303- 313 (A)
 KEY                           314- 328
 PCLASS1                       329- 330
 PCLASS2                       331- 332
 PCLASS3                       333- 334
 PCLASS4                       335- 336
 PCLASS5                       337- 338
 PCLASS6                       339- 340
 PCLASS7                       341- 342
 PCLASS8                       343- 344
 PCLASS9                       345- 346
 PCLASS10                      347- 348
 PCLASS11                      349- 350
 PCLASS12                      351- 352
 PCLASS13                      353- 354
 PRMCCS1                       355- 362 (A)
 PRMCCS2                       363- 370 (A)
 PRMCCS3                       371- 378 (A)
 PRMCCS4                       379- 386 (A)
 PRMCCS5                       387- 394 (A)
 PRMCCS6                       395- 402 (A)
 PRMCCS7                       403- 410 (A)
 PRMCCS8                       411- 418 (A)
 PRMCCS9                       419- 426 (A)
 PRMCCS10                      427- 434 (A)
 PRMCCS11                      435- 442 (A)
 PRMCCS12                      443- 450 (A)
 PRMCCS13                      451- 458 (A).


***  Specify write formats  ***.
FORMATS
 CHRON1                       (F3.0) /
 CHRON2                       (F3.0) /
 CHRON3                       (F3.0) /
 CHRON4                       (F3.0) /
 CHRON5                       (F3.0) /
 CHRON6                       (F3.0) /
 CHRON7                       (F3.0) /
 CHRON8                       (F3.0) /
 CHRON9                       (F3.0) /
 CHRON10                      (F3.0) /
 CHRON11                      (F3.0) /
 CHRON12                      (F3.0) /
 CHRON13                      (F3.0) /
 CHRON14                      (F3.0) /
 CHRON15                      (F3.0) /
 CHRONB1                      (F3.0) /
 CHRONB2                      (F3.0) /
 CHRONB3                      (F3.0) /
 CHRONB4                      (F3.0) /
 CHRONB5                      (F3.0) /
 CHRONB6                      (F3.0) /
 CHRONB7                      (F3.0) /
 CHRONB8                      (F3.0) /
 CHRONB9                      (F3.0) /
 CHRONB10                     (F3.0) /
 CHRONB11                     (F3.0) /
 CHRONB12                     (F3.0) /
 CHRONB13                     (F3.0) /
 CHRONB14                     (F3.0) /
 CHRONB15                     (F3.0) /
 KEY                          (F8.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 PCLASS7                      (F3.0) /
 PCLASS8                      (F3.0) /
 PCLASS9                      (F3.0) /
 PCLASS10                     (F3.0) /
 PCLASS11                     (F3.0) /
 PCLASS12                     (F3.0) /
 PCLASS13                     (F3.0) /
.


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1                       "Chronic condition indicator 1"
 CHRON2                       "Chronic condition indicator 2"
 CHRON3                       "Chronic condition indicator 3"
 CHRON4                       "Chronic condition indicator 4"
 CHRON5                       "Chronic condition indicator 5"
 CHRON6                       "Chronic condition indicator 6"
 CHRON7                       "Chronic condition indicator 7"
 CHRON8                       "Chronic condition indicator 8"
 CHRON9                       "Chronic condition indicator 9"
 CHRON10                      "Chronic condition indicator 10"
 CHRON11                      "Chronic condition indicator 11"
 CHRON12                      "Chronic condition indicator 12"
 CHRON13                      "Chronic condition indicator 13"
 CHRON14                      "Chronic condition indicator 14"
 CHRON15                      "Chronic condition indicator 15"
 CHRONB1                      "Chronic condition body system 1"
 CHRONB2                      "Chronic condition body system 2"
 CHRONB3                      "Chronic condition body system 3"
 CHRONB4                      "Chronic condition body system 4"
 CHRONB5                      "Chronic condition body system 5"
 CHRONB6                      "Chronic condition body system 6"
 CHRONB7                      "Chronic condition body system 7"
 CHRONB8                      "Chronic condition body system 8"
 CHRONB9                      "Chronic condition body system 9"
 CHRONB10                     "Chronic condition body system 10"
 CHRONB11                     "Chronic condition body system 11"
 CHRONB12                     "Chronic condition body system 12"
 CHRONB13                     "Chronic condition body system 13"
 CHRONB14                     "Chronic condition body system 14"
 CHRONB15                     "Chronic condition body system 15"
 DXMCCS1                      "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2                      "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3                      "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4                      "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5                      "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6                      "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7                      "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8                      "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9                      "Multi-Level CCS:  Diagnosis 9"
 DXMCCS10                     "Multi-Level CCS:  Diagnosis 10"
 DXMCCS11                     "Multi-Level CCS:  Diagnosis 11"
 DXMCCS12                     "Multi-Level CCS:  Diagnosis 12"
 DXMCCS13                     "Multi-Level CCS:  Diagnosis 13"
 DXMCCS14                     "Multi-Level CCS:  Diagnosis 14"
 DXMCCS15                     "Multi-Level CCS:  Diagnosis 15"
 E_MCCS1                      "Multi-Level CCS:  E Code 1"
 E_MCCS2                      "Multi-Level CCS:  E Code 2"
 E_MCCS3                      "Multi-Level CCS:  E Code 3"
 E_MCCS4                      "Multi-Level CCS:  E Code 4"
 E_MCCS5                      "Multi-Level CCS:  E Code 5"
 E_MCCS6                      "Multi-Level CCS:  E Code 6"
 E_MCCS7                      "Multi-Level CCS:  E Code 7"
 E_MCCS8                      "Multi-Level CCS:  E Code 8"
 KEY                          "HCUP record identifier"
 PCLASS1                      "Procedure class 1"
 PCLASS2                      "Procedure class 2"
 PCLASS3                      "Procedure class 3"
 PCLASS4                      "Procedure class 4"
 PCLASS5                      "Procedure class 5"
 PCLASS6                      "Procedure class 6"
 PCLASS7                      "Procedure class 7"
 PCLASS8                      "Procedure class 8"
 PCLASS9                      "Procedure class 9"
 PCLASS10                     "Procedure class 10"
 PCLASS11                     "Procedure class 11"
 PCLASS12                     "Procedure class 12"
 PCLASS13                     "Procedure class 13"
 PRMCCS1                      "Multi-Level CCS:  Procedure 1"
 PRMCCS2                      "Multi-Level CCS:  Procedure 2"
 PRMCCS3                      "Multi-Level CCS:  Procedure 3"
 PRMCCS4                      "Multi-Level CCS:  Procedure 4"
 PRMCCS5                      "Multi-Level CCS:  Procedure 5"
 PRMCCS6                      "Multi-Level CCS:  Procedure 6"
 PRMCCS7                      "Multi-Level CCS:  Procedure 7"
 PRMCCS8                      "Multi-Level CCS:  Procedure 8"
 PRMCCS9                      "Multi-Level CCS:  Procedure 9"
 PRMCCS10                     "Multi-Level CCS:  Procedure 10"
 PRMCCS11                     "Multi-Level CCS:  Procedure 11"
 PRMCCS12                     "Multi-Level CCS:  Procedure 12"
 PRMCCS13                     "Multi-Level CCS:  Procedure 13" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB10
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB11
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB12
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB13
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB14
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB15
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS13
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'SC_SID_2009_DX_PR_GRPS.SAV' /COMPRESSED.
