/*******************************************************************
*   SD_SID_2008_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'SD_SID_2008_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ATYPE                     12-  13
 AWEEKEND                  14-  15
 DIED                      16-  17
 DISPUB04                  18-  19
 DISPUNIF                  20-  21
 DISP_X                    22-  25 (A)
 DQTR                      26-  27
 DRG                       28-  30
 DRG24                     31-  33
 DRGVER                    34-  35
 DRG_NoPO                  36-  38
 DX1                       39-  43 (A)
 DX2                       44-  48 (A)
 DX3                       49-  53 (A)
 DX4                       54-  58 (A)
 DX5                       59-  63 (A)
 DX6                       64-  68 (A)
 DX7                       69-  73 (A)
 DX8                       74-  78 (A)
 DX9                       79-  83 (A)
 DX10                      84-  88 (A)
 DX11                      89-  93 (A)
 DX12                      94-  98 (A)
 DX13                      99- 103 (A)
 DX14                     104- 108 (A)
 DX15                     109- 113 (A)
 DX16                     114- 118 (A)
 DX17                     119- 123 (A)
 DX18                     124- 128 (A)
 DX19                     129- 133 (A)
 DX20                     134- 138 (A)
 DX21                     139- 143 (A)
 DX22                     144- 148 (A)
 DX23                     149- 153 (A)
 DX24                     154- 158 (A)
 DX25                     159- 163 (A)
 DX26                     164- 168 (A)
 DX27                     169- 173 (A)
 DX28                     174- 178 (A)
 DX29                     179- 183 (A)
 DX30                     184- 188 (A)
 DX31                     189- 193 (A)
 DX32                     194- 198 (A)
 DX33                     199- 203 (A)
 DX34                     204- 208 (A)
 DX35                     209- 213 (A)
 DX36                     214- 218 (A)
 DX37                     219- 223 (A)
 DX38                     224- 228 (A)
 DX39                     229- 233 (A)
 DX40                     234- 238 (A)
 DX41                     239- 243 (A)
 DX42                     244- 248 (A)
 DX43                     249- 253 (A)
 DX44                     254- 258 (A)
 DX45                     259- 263 (A)
 DX46                     264- 268 (A)
 DX47                     269- 273 (A)
 DX48                     274- 278 (A)
 DX49                     279- 283 (A)
 DX50                     284- 288 (A)
 DX51                     289- 293 (A)
 DX52                     294- 298 (A)
 DX53                     299- 303 (A)
 DX54                     304- 308 (A)
 DX55                     309- 313 (A)
 DX56                     314- 318 (A)
 DX57                     319- 323 (A)
 DX58                     324- 328 (A)
 DX59                     329- 333 (A)
 DX60                     334- 338 (A)
 DX61                     339- 343 (A)
 DXCCS1                   344- 347
 DXCCS2                   348- 351
 DXCCS3                   352- 355
 DXCCS4                   356- 359
 DXCCS5                   360- 363
 DXCCS6                   364- 367
 DXCCS7                   368- 371
 DXCCS8                   372- 375
 DXCCS9                   376- 379
 DXCCS10                  380- 383
 DXCCS11                  384- 387
 DXCCS12                  388- 391
 DXCCS13                  392- 395
 DXCCS14                  396- 399
 DXCCS15                  400- 403
 DXCCS16                  404- 407
 DXCCS17                  408- 411
 DXCCS18                  412- 415
 DXCCS19                  416- 419
 DXCCS20                  420- 423
 DXCCS21                  424- 427
 DXCCS22                  428- 431
 DXCCS23                  432- 435
 DXCCS24                  436- 439
 DXCCS25                  440- 443
 DXCCS26                  444- 447
 DXCCS27                  448- 451
 DXCCS28                  452- 455
 DXCCS29                  456- 459
 DXCCS30                  460- 463
 DXCCS31                  464- 467
 DXCCS32                  468- 471
 DXCCS33                  472- 475
 DXCCS34                  476- 479
 DXCCS35                  480- 483
 DXCCS36                  484- 487
 DXCCS37                  488- 491
 DXCCS38                  492- 495
 DXCCS39                  496- 499
 DXCCS40                  500- 503
 DXCCS41                  504- 507
 DXCCS42                  508- 511
 DXCCS43                  512- 515
 DXCCS44                  516- 519
 DXCCS45                  520- 523
 DXCCS46                  524- 527
 DXCCS47                  528- 531
 DXCCS48                  532- 535
 DXCCS49                  536- 539
 DXCCS50                  540- 543
 DXCCS51                  544- 547
 DXCCS52                  548- 551
 DXCCS53                  552- 555
 DXCCS54                  556- 559
 DXCCS55                  560- 563
 DXCCS56                  564- 567
 DXCCS57                  568- 571
 DXCCS58                  572- 575
 DXCCS59                  576- 579
 DXCCS60                  580- 583
 DXCCS61                  584- 587
 DXPOA1                   588     (A)
 DXPOA2                   589     (A)
 DXPOA3                   590     (A)
 DXPOA4                   591     (A)
 DXPOA5                   592     (A)
 DXPOA6                   593     (A)
 DXPOA7                   594     (A)
 DXPOA8                   595     (A)
 DXPOA9                   596     (A)
 DXPOA10                  597     (A)
 DXPOA11                  598     (A)
 DXPOA12                  599     (A)
 DXPOA13                  600     (A)
 DXPOA14                  601     (A)
 DXPOA15                  602     (A)
 DXPOA16                  603     (A)
 DXPOA17                  604     (A)
 DXPOA18                  605     (A)
 DXPOA19                  606     (A)
 DXPOA20                  607     (A)
 DXPOA21                  608     (A)
 DXPOA22                  609     (A)
 DXPOA23                  610     (A)
 DXPOA24                  611     (A)
 DXPOA25                  612     (A)
 DXPOA26                  613     (A)
 DXPOA27                  614     (A)
 DXPOA28                  615     (A)
 DXPOA29                  616     (A)
 DXPOA30                  617     (A)
 DXPOA31                  618     (A)
 DXPOA32                  619     (A)
 DXPOA33                  620     (A)
 DXPOA34                  621     (A)
 DXPOA35                  622     (A)
 DXPOA36                  623     (A)
 DXPOA37                  624     (A)
 DXPOA38                  625     (A)
 DXPOA39                  626     (A)
 DXPOA40                  627     (A)
 DXPOA41                  628     (A)
 DXPOA42                  629     (A)
 DXPOA43                  630     (A)
 DXPOA44                  631     (A)
 DXPOA45                  632     (A)
 DXPOA46                  633     (A)
 DXPOA47                  634     (A)
 DXPOA48                  635     (A)
 DXPOA49                  636     (A)
 DXPOA50                  637     (A)
 DXPOA51                  638     (A)
 DXPOA52                  639     (A)
 DXPOA53                  640     (A)
 DXPOA54                  641     (A)
 DXPOA55                  642     (A)
 DXPOA56                  643     (A)
 DXPOA57                  644     (A)
 DXPOA58                  645     (A)
 DXPOA59                  646     (A)
 DXPOA60                  647     (A)
 DXPOA61                  648     (A)
 ECODE1                   649- 653 (A)
 ECODE2                   654- 658 (A)
 ECODE3                   659- 663 (A)
 ECODE4                   664- 668 (A)
 ECODE5                   669- 673 (A)
 ECODE6                   674- 678 (A)
 E_CCS1                   679- 682
 E_CCS2                   683- 686
 E_CCS3                   687- 690
 E_CCS4                   691- 694
 E_CCS5                   695- 698
 E_CCS6                   699- 702
 E_POA1                   703     (A)
 E_POA2                   704     (A)
 E_POA3                   705     (A)
 E_POA4                   706     (A)
 E_POA5                   707     (A)
 E_POA6                   708     (A)
 FEMALE                   709- 710
 HCUP_ED                  711- 712
 HCUP_OS                  713- 714
 HOSPBRTH                 715- 717
 HOSPST                   718- 719 (A)
 Hospital                 720- 721
 KEY                      722- 735
 LOS                      736- 740
 LOS_X                    741- 746
 MDC                      747- 748
 MDC24                    749- 750
 MDNUM1_R                 751- 759
 MDNUM2_R                 760- 768
 MDNUM3_R                 769- 777
 MEDINCST                 778- 779
 MRN_R                    780- 788
 NDX                      789- 790
 NECODE                   791- 792
 NEOMAT                   793- 794
 NPR                      795- 796
 PAY1                     797- 798
 PL_CBSA                  799- 801
 PL_MSA19                 802- 804
 PL_NCHS2                 805- 806
 PL_RUCA1                 807- 808
 PL_RUCA2                 809- 812
 PL_RUCA4                 813- 814
 PL_RUCC2                 815- 816
 PL_UIC20                 817- 818
 PL_UR_CA                 819- 820
 PR1                      821- 824 (A)
 PR2                      825- 828 (A)
 PR3                      829- 832 (A)
 PR4                      833- 836 (A)
 PR5                      837- 840 (A)
 PR6                      841- 844 (A)
 PR7                      845- 848 (A)
 PR8                      849- 852 (A)
 PR9                      853- 856 (A)
 PR10                     857- 860 (A)
 PR11                     861- 864 (A)
 PR12                     865- 868 (A)
 PR13                     869- 872 (A)
 PR14                     873- 876 (A)
 PR15                     877- 880 (A)
 PR16                     881- 884 (A)
 PR17                     885- 888 (A)
 PR18                     889- 892 (A)
 PR19                     893- 896 (A)
 PR20                     897- 900 (A)
 PR21                     901- 904 (A)
 PR22                     905- 908 (A)
 PR23                     909- 912 (A)
 PR24                     913- 916 (A)
 PR25                     917- 920 (A)
 PR26                     921- 924 (A)
 PR27                     925- 928 (A)
 PR28                     929- 932 (A)
 PR29                     933- 936 (A)
 PR30                     937- 940 (A)
 PR31                     941- 944 (A)
 PR32                     945- 948 (A)
 PR33                     949- 952 (A)
 PR34                     953- 956 (A)
 PR35                     957- 960 (A)
 PR36                     961- 964 (A)
 PR37                     965- 968 (A)
 PR38                     969- 972 (A)
 PR39                     973- 976 (A)
 PR40                     977- 980 (A)
 PR41                     981- 984 (A)
 PR42                     985- 988 (A)
 PR43                     989- 992 (A)
 PR44                     993- 996 (A)
 PR45                     997-1000 (A)
 PR46                    1001-1004 (A)
 PRCCS1                  1005-1007
 PRCCS2                  1008-1010
 PRCCS3                  1011-1013
 PRCCS4                  1014-1016
 PRCCS5                  1017-1019
 PRCCS6                  1020-1022
 PRCCS7                  1023-1025
 PRCCS8                  1026-1028
 PRCCS9                  1029-1031
 PRCCS10                 1032-1034
 PRCCS11                 1035-1037
 PRCCS12                 1038-1040
 PRCCS13                 1041-1043
 PRCCS14                 1044-1046
 PRCCS15                 1047-1049
 PRCCS16                 1050-1052
 PRCCS17                 1053-1055
 PRCCS18                 1056-1058
 PRCCS19                 1059-1061
 PRCCS20                 1062-1064
 PRCCS21                 1065-1067
 PRCCS22                 1068-1070
 PRCCS23                 1071-1073
 PRCCS24                 1074-1076
 PRCCS25                 1077-1079
 PRCCS26                 1080-1082
 PRCCS27                 1083-1085
 PRCCS28                 1086-1088
 PRCCS29                 1089-1091
 PRCCS30                 1092-1094
 PRCCS31                 1095-1097
 PRCCS32                 1098-1100
 PRCCS33                 1101-1103
 PRCCS34                 1104-1106
 PRCCS35                 1107-1109
 PRCCS36                 1110-1112
 PRCCS37                 1113-1115
 PRCCS38                 1116-1118
 PRCCS39                 1119-1121
 PRCCS40                 1122-1124
 PRCCS41                 1125-1127
 PRCCS42                 1128-1130
 PRCCS43                 1131-1133
 PRCCS44                 1134-1136
 PRCCS45                 1137-1139
 PRCCS46                 1140-1142
 PRDAY1                  1143-1147
 PRDAY2                  1148-1152
 PRDAY3                  1153-1157
 PRDAY4                  1158-1162
 PRDAY5                  1163-1167
 PRDAY6                  1168-1172
 PRDAY7                  1173-1177
 PRDAY8                  1178-1182
 PRDAY9                  1183-1187
 PRDAY10                 1188-1192
 PRDAY11                 1193-1197
 PRDAY12                 1198-1202
 PRDAY13                 1203-1207
 PRDAY14                 1208-1212
 PRDAY15                 1213-1217
 PRDAY16                 1218-1222
 PRDAY17                 1223-1227
 PRDAY18                 1228-1232
 PRDAY19                 1233-1237
 PRDAY20                 1238-1242
 PRDAY21                 1243-1247
 PRDAY22                 1248-1252
 PRDAY23                 1253-1257
 PRDAY24                 1258-1262
 PRDAY25                 1263-1267
 PRDAY26                 1268-1272
 PRDAY27                 1273-1277
 PRDAY28                 1278-1282
 PRDAY29                 1283-1287
 PRDAY30                 1288-1292
 PRDAY31                 1293-1297
 PRDAY32                 1298-1302
 PRDAY33                 1303-1307
 PRDAY34                 1308-1312
 PRDAY35                 1313-1317
 PRDAY36                 1318-1322
 PRDAY37                 1323-1327
 PRDAY38                 1328-1332
 PRDAY39                 1333-1337
 PRDAY40                 1338-1342
 PRDAY41                 1343-1347
 PRDAY42                 1348-1352
 PRDAY43                 1353-1357
 PRDAY44                 1358-1362
 PRDAY45                 1363-1367
 PRDAY46                 1368-1372
 PROCTYPE                1373-1375
 PSTATE                  1376-1377 (A)
 PSTCO                   1378-1382
 PSTCO2                  1383-1387
 POFOUB04                1388     (A)
 POFO_X                  1389     (A)
 RACE                    1390-1391
 RACE_X                  1392-1395 (A)
 TOTCHG                  1396-1405
 TOTCHG_X                1406-1420
 YEAR                    1421-1424
 ZIP3                    1425-1427 (A)
 ZIPINC_Q                1428-1430
 HOSPID                  1431-1435
 ZIP                     1436-1440 (A)
 AYEAR                   1441-1444
 DMONTH                  1445-1446
 BMONTH                  1447-1448
 BYEAR                   1449-1452
 PRMNTH1                 1453-1454
 PRMNTH2                 1455-1456
 PRMNTH3                 1457-1458
 PRMNTH4                 1459-1460
 PRMNTH5                 1461-1462
 PRMNTH6                 1463-1464
 PRMNTH7                 1465-1466
 PRMNTH8                 1467-1468
 PRMNTH9                 1469-1470
 PRMNTH10                1471-1472
 PRMNTH11                1473-1474
 PRMNTH12                1475-1476
 PRMNTH13                1477-1478
 PRMNTH14                1479-1480
 PRMNTH15                1481-1482
 PRMNTH16                1483-1484
 PRMNTH17                1485-1486
 PRMNTH18                1487-1488
 PRMNTH19                1489-1490
 PRMNTH20                1491-1492
 PRMNTH21                1493-1494
 PRMNTH22                1495-1496
 PRMNTH23                1497-1498
 PRMNTH24                1499-1500
 PRMNTH25                1501-1502
 PRMNTH26                1503-1504
 PRMNTH27                1505-1506
 PRMNTH28                1507-1508
 PRMNTH29                1509-1510
 PRMNTH30                1511-1512
 PRMNTH31                1513-1514
 PRMNTH32                1515-1516
 PRMNTH33                1517-1518
 PRMNTH34                1519-1520
 PRMNTH35                1521-1522
 PRMNTH36                1523-1524
 PRMNTH37                1525-1526
 PRMNTH38                1527-1528
 PRMNTH39                1529-1530
 PRMNTH40                1531-1532
 PRMNTH41                1533-1534
 PRMNTH42                1535-1536
 PRMNTH43                1537-1538
 PRMNTH44                1539-1540
 PRMNTH45                1541-1542
 PRMNTH46                1543-1544
 PRYEAR1                 1545-1548
 PRYEAR2                 1549-1552
 PRYEAR3                 1553-1556
 PRYEAR4                 1557-1560
 PRYEAR5                 1561-1564
 PRYEAR6                 1565-1568
 PRYEAR7                 1569-1572
 PRYEAR8                 1573-1576
 PRYEAR9                 1577-1580
 PRYEAR10                1581-1584
 PRYEAR11                1585-1588
 PRYEAR12                1589-1592
 PRYEAR13                1593-1596
 PRYEAR14                1597-1600
 PRYEAR15                1601-1604
 PRYEAR16                1605-1608
 PRYEAR17                1609-1612
 PRYEAR18                1613-1616
 PRYEAR19                1617-1620
 PRYEAR20                1621-1624
 PRYEAR21                1625-1628
 PRYEAR22                1629-1632
 PRYEAR23                1633-1636
 PRYEAR24                1637-1640
 PRYEAR25                1641-1644
 PRYEAR26                1645-1648
 PRYEAR27                1649-1652
 PRYEAR28                1653-1656
 PRYEAR29                1657-1660
 PRYEAR30                1661-1664
 PRYEAR31                1665-1668
 PRYEAR32                1669-1672
 PRYEAR33                1673-1676
 PRYEAR34                1677-1680
 PRYEAR35                1681-1684
 PRYEAR36                1685-1688
 PRYEAR37                1689-1692
 PRYEAR38                1693-1696
 PRYEAR39                1697-1700
 PRYEAR40                1701-1704
 PRYEAR41                1705-1708
 PRYEAR42                1709-1712
 PRYEAR43                1713-1716
 PRYEAR44                1717-1720
 PRYEAR45                1721-1724
 PRYEAR46                1725-1728.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPO                (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 DXCCS34                 (F4.0) /
 DXCCS35                 (F4.0) /
 DXCCS36                 (F4.0) /
 DXCCS37                 (F4.0) /
 DXCCS38                 (F4.0) /
 DXCCS39                 (F4.0) /
 DXCCS40                 (F4.0) /
 DXCCS41                 (F4.0) /
 DXCCS42                 (F4.0) /
 DXCCS43                 (F4.0) /
 DXCCS44                 (F4.0) /
 DXCCS45                 (F4.0) /
 DXCCS46                 (F4.0) /
 DXCCS47                 (F4.0) /
 DXCCS48                 (F4.0) /
 DXCCS49                 (F4.0) /
 DXCCS50                 (F4.0) /
 DXCCS51                 (F4.0) /
 DXCCS52                 (F4.0) /
 DXCCS53                 (F4.0) /
 DXCCS54                 (F4.0) /
 DXCCS55                 (F4.0) /
 DXCCS56                 (F4.0) /
 DXCCS57                 (F4.0) /
 DXCCS58                 (F4.0) /
 DXCCS59                 (F4.0) /
 DXCCS60                 (F4.0) /
 DXCCS61                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Hospital                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MDNUM3_R                (F5.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRCCS31                 (F3.0) /
 PRCCS32                 (F3.0) /
 PRCCS33                 (F3.0) /
 PRCCS34                 (F3.0) /
 PRCCS35                 (F3.0) /
 PRCCS36                 (F3.0) /
 PRCCS37                 (F3.0) /
 PRCCS38                 (F3.0) /
 PRCCS39                 (F3.0) /
 PRCCS40                 (F3.0) /
 PRCCS41                 (F3.0) /
 PRCCS42                 (F3.0) /
 PRCCS43                 (F3.0) /
 PRCCS44                 (F3.0) /
 PRCCS45                 (F3.0) /
 PRCCS46                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PRDAY24                 (F4.0) /
 PRDAY25                 (F4.0) /
 PRDAY26                 (F4.0) /
 PRDAY27                 (F4.0) /
 PRDAY28                 (F4.0) /
 PRDAY29                 (F4.0) /
 PRDAY30                 (F4.0) /
 PRDAY31                 (F4.0) /
 PRDAY32                 (F4.0) /
 PRDAY33                 (F4.0) /
 PRDAY34                 (F4.0) /
 PRDAY35                 (F4.0) /
 PRDAY36                 (F4.0) /
 PRDAY37                 (F4.0) /
 PRDAY38                 (F4.0) /
 PRDAY39                 (F4.0) /
 PRDAY40                 (F4.0) /
 PRDAY41                 (F4.0) /
 PRDAY42                 (F4.0) /
 PRDAY43                 (F4.0) /
 PRDAY44                 (F4.0) /
 PRDAY45                 (F4.0) /
 PRDAY46                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 HOSPID                  (F4.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRMNTH7                 (F3.0) /
 PRMNTH8                 (F3.0) /
 PRMNTH9                 (F3.0) /
 PRMNTH10                (F3.0) /
 PRMNTH11                (F3.0) /
 PRMNTH12                (F3.0) /
 PRMNTH13                (F3.0) /
 PRMNTH14                (F3.0) /
 PRMNTH15                (F3.0) /
 PRMNTH16                (F3.0) /
 PRMNTH17                (F3.0) /
 PRMNTH18                (F3.0) /
 PRMNTH19                (F3.0) /
 PRMNTH20                (F3.0) /
 PRMNTH21                (F3.0) /
 PRMNTH22                (F3.0) /
 PRMNTH23                (F3.0) /
 PRMNTH24                (F3.0) /
 PRMNTH25                (F3.0) /
 PRMNTH26                (F3.0) /
 PRMNTH27                (F3.0) /
 PRMNTH28                (F3.0) /
 PRMNTH29                (F3.0) /
 PRMNTH30                (F3.0) /
 PRMNTH31                (F3.0) /
 PRMNTH32                (F3.0) /
 PRMNTH33                (F3.0) /
 PRMNTH34                (F3.0) /
 PRMNTH35                (F3.0) /
 PRMNTH36                (F3.0) /
 PRMNTH37                (F3.0) /
 PRMNTH38                (F3.0) /
 PRMNTH39                (F3.0) /
 PRMNTH40                (F3.0) /
 PRMNTH41                (F3.0) /
 PRMNTH42                (F3.0) /
 PRMNTH43                (F3.0) /
 PRMNTH44                (F3.0) /
 PRMNTH45                (F3.0) /
 PRMNTH46                (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) /
 PRYEAR24                (F3.0) /
 PRYEAR25                (F3.0) /
 PRYEAR26                (F3.0) /
 PRYEAR27                (F3.0) /
 PRYEAR28                (F3.0) /
 PRYEAR29                (F3.0) /
 PRYEAR30                (F3.0) /
 PRYEAR31                (F3.0) /
 PRYEAR32                (F3.0) /
 PRYEAR33                (F3.0) /
 PRYEAR34                (F3.0) /
 PRYEAR35                (F3.0) /
 PRYEAR36                (F3.0) /
 PRYEAR37                (F3.0) /
 PRYEAR38                (F3.0) /
 PRYEAR39                (F3.0) /
 PRYEAR40                (F3.0) /
 PRYEAR41                (F3.0) /
 PRYEAR42                (F3.0) /
 PRYEAR43                (F3.0) /
 PRYEAR44                (F3.0) /
 PRYEAR45                (F3.0) /
 PRYEAR46                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG24     "DRG, version 24"
 DRGVER    "DRG grouper version used on discharge date"
 DRG_NoPO  "DRG in use on discharge date, calculated without POA"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DX26      "Diagnosis 26"
 DX27      "Diagnosis 27"
 DX28      "Diagnosis 28"
 DX29      "Diagnosis 29"
 DX30      "Diagnosis 30"
 DX31      "Diagnosis 31"
 DX32      "Diagnosis 32"
 DX33      "Diagnosis 33"
 DX34      "Diagnosis 34"
 DX35      "Diagnosis 35"
 DX36      "Diagnosis 36"
 DX37      "Diagnosis 37"
 DX38      "Diagnosis 38"
 DX39      "Diagnosis 39"
 DX40      "Diagnosis 40"
 DX41      "Diagnosis 41"
 DX42      "Diagnosis 42"
 DX43      "Diagnosis 43"
 DX44      "Diagnosis 44"
 DX45      "Diagnosis 45"
 DX46      "Diagnosis 46"
 DX47      "Diagnosis 47"
 DX48      "Diagnosis 48"
 DX49      "Diagnosis 49"
 DX50      "Diagnosis 50"
 DX51      "Diagnosis 51"
 DX52      "Diagnosis 52"
 DX53      "Diagnosis 53"
 DX54      "Diagnosis 54"
 DX55      "Diagnosis 55"
 DX56      "Diagnosis 56"
 DX57      "Diagnosis 57"
 DX58      "Diagnosis 58"
 DX59      "Diagnosis 59"
 DX60      "Diagnosis 60"
 DX61      "Diagnosis 61"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXCCS26   "CCS: diagnosis 26"
 DXCCS27   "CCS: diagnosis 27"
 DXCCS28   "CCS: diagnosis 28"
 DXCCS29   "CCS: diagnosis 29"
 DXCCS30   "CCS: diagnosis 30"
 DXCCS31   "CCS: diagnosis 31"
 DXCCS32   "CCS: diagnosis 32"
 DXCCS33   "CCS: diagnosis 33"
 DXCCS34   "CCS: diagnosis 34"
 DXCCS35   "CCS: diagnosis 35"
 DXCCS36   "CCS: diagnosis 36"
 DXCCS37   "CCS: diagnosis 37"
 DXCCS38   "CCS: diagnosis 38"
 DXCCS39   "CCS: diagnosis 39"
 DXCCS40   "CCS: diagnosis 40"
 DXCCS41   "CCS: diagnosis 41"
 DXCCS42   "CCS: diagnosis 42"
 DXCCS43   "CCS: diagnosis 43"
 DXCCS44   "CCS: diagnosis 44"
 DXCCS45   "CCS: diagnosis 45"
 DXCCS46   "CCS: diagnosis 46"
 DXCCS47   "CCS: diagnosis 47"
 DXCCS48   "CCS: diagnosis 48"
 DXCCS49   "CCS: diagnosis 49"
 DXCCS50   "CCS: diagnosis 50"
 DXCCS51   "CCS: diagnosis 51"
 DXCCS52   "CCS: diagnosis 52"
 DXCCS53   "CCS: diagnosis 53"
 DXCCS54   "CCS: diagnosis 54"
 DXCCS55   "CCS: diagnosis 55"
 DXCCS56   "CCS: diagnosis 56"
 DXCCS57   "CCS: diagnosis 57"
 DXCCS58   "CCS: diagnosis 58"
 DXCCS59   "CCS: diagnosis 59"
 DXCCS60   "CCS: diagnosis 60"
 DXCCS61   "CCS: diagnosis 61"
 DXPOA1    "Diagnosis 1, present on admission indicator"
 DXPOA2    "Diagnosis 2, present on admission indicator"
 DXPOA3    "Diagnosis 3, present on admission indicator"
 DXPOA4    "Diagnosis 4, present on admission indicator"
 DXPOA5    "Diagnosis 5, present on admission indicator"
 DXPOA6    "Diagnosis 6, present on admission indicator"
 DXPOA7    "Diagnosis 7, present on admission indicator"
 DXPOA8    "Diagnosis 8, present on admission indicator"
 DXPOA9    "Diagnosis 9, present on admission indicator"
 DXPOA10   "Diagnosis 10, present on admission indicator"
 DXPOA11   "Diagnosis 11, present on admission indicator"
 DXPOA12   "Diagnosis 12, present on admission indicator"
 DXPOA13   "Diagnosis 13, present on admission indicator"
 DXPOA14   "Diagnosis 14, present on admission indicator"
 DXPOA15   "Diagnosis 15, present on admission indicator"
 DXPOA16   "Diagnosis 16, present on admission indicator"
 DXPOA17   "Diagnosis 17, present on admission indicator"
 DXPOA18   "Diagnosis 18, present on admission indicator"
 DXPOA19   "Diagnosis 19, present on admission indicator"
 DXPOA20   "Diagnosis 20, present on admission indicator"
 DXPOA21   "Diagnosis 21, present on admission indicator"
 DXPOA22   "Diagnosis 22, present on admission indicator"
 DXPOA23   "Diagnosis 23, present on admission indicator"
 DXPOA24   "Diagnosis 24, present on admission indicator"
 DXPOA25   "Diagnosis 25, present on admission indicator"
 DXPOA26   "Diagnosis 26, present on admission indicator"
 DXPOA27   "Diagnosis 27, present on admission indicator"
 DXPOA28   "Diagnosis 28, present on admission indicator"
 DXPOA29   "Diagnosis 29, present on admission indicator"
 DXPOA30   "Diagnosis 30, present on admission indicator"
 DXPOA31   "Diagnosis 31, present on admission indicator"
 DXPOA32   "Diagnosis 32, present on admission indicator"
 DXPOA33   "Diagnosis 33, present on admission indicator"
 DXPOA34   "Diagnosis 34, present on admission indicator"
 DXPOA35   "Diagnosis 35, present on admission indicator"
 DXPOA36   "Diagnosis 36, present on admission indicator"
 DXPOA37   "Diagnosis 37, present on admission indicator"
 DXPOA38   "Diagnosis 38, present on admission indicator"
 DXPOA39   "Diagnosis 39, present on admission indicator"
 DXPOA40   "Diagnosis 40, present on admission indicator"
 DXPOA41   "Diagnosis 41, present on admission indicator"
 DXPOA42   "Diagnosis 42, present on admission indicator"
 DXPOA43   "Diagnosis 43, present on admission indicator"
 DXPOA44   "Diagnosis 44, present on admission indicator"
 DXPOA45   "Diagnosis 45, present on admission indicator"
 DXPOA46   "Diagnosis 46, present on admission indicator"
 DXPOA47   "Diagnosis 47, present on admission indicator"
 DXPOA48   "Diagnosis 48, present on admission indicator"
 DXPOA49   "Diagnosis 49, present on admission indicator"
 DXPOA50   "Diagnosis 50, present on admission indicator"
 DXPOA51   "Diagnosis 51, present on admission indicator"
 DXPOA52   "Diagnosis 52, present on admission indicator"
 DXPOA53   "Diagnosis 53, present on admission indicator"
 DXPOA54   "Diagnosis 54, present on admission indicator"
 DXPOA55   "Diagnosis 55, present on admission indicator"
 DXPOA56   "Diagnosis 56, present on admission indicator"
 DXPOA57   "Diagnosis 57, present on admission indicator"
 DXPOA58   "Diagnosis 58, present on admission indicator"
 DXPOA59   "Diagnosis 59, present on admission indicator"
 DXPOA60   "Diagnosis 60, present on admission indicator"
 DXPOA61   "Diagnosis 61, present on admission indicator"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_POA1    "E Code 1, present on admission indicator"
 E_POA2    "E Code 2, present on admission indicator"
 E_POA3    "E Code 3, present on admission indicator"
 E_POA4    "E Code 4, present on admission indicator"
 E_POA5    "E Code 5, present on admission indicator"
 E_POA6    "E Code 6, present on admission indicator"
 FEMALE    "Indicator of sex"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 Hospital
"Indicator that patient was discharged from a special unit within an acute care hospital (re
ported by source)"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC24     "MDC, version 24"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MDNUM3_R  "Physician 3 number (re-identified)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PR22      "Procedure 22"
 PR23      "Procedure 23"
 PR24      "Procedure 24"
 PR25      "Procedure 25"
 PR26      "Procedure 26"
 PR27      "Procedure 27"
 PR28      "Procedure 28"
 PR29      "Procedure 29"
 PR30      "Procedure 30"
 PR31      "Procedure 31"
 PR32      "Procedure 32"
 PR33      "Procedure 33"
 PR34      "Procedure 34"
 PR35      "Procedure 35"
 PR36      "Procedure 36"
 PR37      "Procedure 37"
 PR38      "Procedure 38"
 PR39      "Procedure 39"
 PR40      "Procedure 40"
 PR41      "Procedure 41"
 PR42      "Procedure 42"
 PR43      "Procedure 43"
 PR44      "Procedure 44"
 PR45      "Procedure 45"
 PR46      "Procedure 46"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRCCS22   "CCS: procedure 22"
 PRCCS23   "CCS: procedure 23"
 PRCCS24   "CCS: procedure 24"
 PRCCS25   "CCS: procedure 25"
 PRCCS26   "CCS: procedure 26"
 PRCCS27   "CCS: procedure 27"
 PRCCS28   "CCS: procedure 28"
 PRCCS29   "CCS: procedure 29"
 PRCCS30   "CCS: procedure 30"
 PRCCS31   "CCS: procedure 31"
 PRCCS32   "CCS: procedure 32"
 PRCCS33   "CCS: procedure 33"
 PRCCS34   "CCS: procedure 34"
 PRCCS35   "CCS: procedure 35"
 PRCCS36   "CCS: procedure 36"
 PRCCS37   "CCS: procedure 37"
 PRCCS38   "CCS: procedure 38"
 PRCCS39   "CCS: procedure 39"
 PRCCS40   "CCS: procedure 40"
 PRCCS41   "CCS: procedure 41"
 PRCCS42   "CCS: procedure 42"
 PRCCS43   "CCS: procedure 43"
 PRCCS44   "CCS: procedure 44"
 PRCCS45   "CCS: procedure 45"
 PRCCS46   "CCS: procedure 46"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 PRDAY16   "Number of days from admission to PR16"
 PRDAY17   "Number of days from admission to PR17"
 PRDAY18   "Number of days from admission to PR18"
 PRDAY19   "Number of days from admission to PR19"
 PRDAY20   "Number of days from admission to PR20"
 PRDAY21   "Number of days from admission to PR21"
 PRDAY22   "Number of days from admission to PR22"
 PRDAY23   "Number of days from admission to PR23"
 PRDAY24   "Number of days from admission to PR24"
 PRDAY25   "Number of days from admission to PR25"
 PRDAY26   "Number of days from admission to PR26"
 PRDAY27   "Number of days from admission to PR27"
 PRDAY28   "Number of days from admission to PR28"
 PRDAY29   "Number of days from admission to PR29"
 PRDAY30   "Number of days from admission to PR30"
 PRDAY31   "Number of days from admission to PR31"
 PRDAY32   "Number of days from admission to PR32"
 PRDAY33   "Number of days from admission to PR33"
 PRDAY34   "Number of days from admission to PR34"
 PRDAY35   "Number of days from admission to PR35"
 PRDAY36   "Number of days from admission to PR36"
 PRDAY37   "Number of days from admission to PR37"
 PRDAY38   "Number of days from admission to PR38"
 PRDAY39   "Number of days from admission to PR39"
 PRDAY40   "Number of days from admission to PR40"
 PRDAY41   "Number of days from admission to PR41"
 PRDAY42   "Number of days from admission to PR42"
 PRDAY43   "Number of days from admission to PR43"
 PRDAY44   "Number of days from admission to PR44"
 PRDAY45   "Number of days from admission to PR45"
 PRDAY46   "Number of days from admission to PR46"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 POFOUB04  "Point of origin for admission or visit, UB-04 standard coding"
 POFO_X    "Point of origin for admission or visit, as received from source"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 HOSPID    "HCUP hospital identification number"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRMNTH11  "Month of procedure 11"
 PRMNTH12  "Month of procedure 12"
 PRMNTH13  "Month of procedure 13"
 PRMNTH14  "Month of procedure 14"
 PRMNTH15  "Month of procedure 15"
 PRMNTH16  "Month of procedure 16"
 PRMNTH17  "Month of procedure 17"
 PRMNTH18  "Month of procedure 18"
 PRMNTH19  "Month of procedure 19"
 PRMNTH20  "Month of procedure 20"
 PRMNTH21  "Month of procedure 21"
 PRMNTH22  "Month of procedure 22"
 PRMNTH23  "Month of procedure 23"
 PRMNTH24  "Month of procedure 24"
 PRMNTH25  "Month of procedure 25"
 PRMNTH26  "Month of procedure 26"
 PRMNTH27  "Month of procedure 27"
 PRMNTH28  "Month of procedure 28"
 PRMNTH29  "Month of procedure 29"
 PRMNTH30  "Month of procedure 30"
 PRMNTH31  "Month of procedure 31"
 PRMNTH32  "Month of procedure 32"
 PRMNTH33  "Month of procedure 33"
 PRMNTH34  "Month of procedure 34"
 PRMNTH35  "Month of procedure 35"
 PRMNTH36  "Month of procedure 36"
 PRMNTH37  "Month of procedure 37"
 PRMNTH38  "Month of procedure 38"
 PRMNTH39  "Month of procedure 39"
 PRMNTH40  "Month of procedure 40"
 PRMNTH41  "Month of procedure 41"
 PRMNTH42  "Month of procedure 42"
 PRMNTH43  "Month of procedure 43"
 PRMNTH44  "Month of procedure 44"
 PRMNTH45  "Month of procedure 45"
 PRMNTH46  "Month of procedure 46"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10"
 PRYEAR11  "Year of procedure 11"
 PRYEAR12  "Year of procedure 12"
 PRYEAR13  "Year of procedure 13"
 PRYEAR14  "Year of procedure 14"
 PRYEAR15  "Year of procedure 15"
 PRYEAR16  "Year of procedure 16"
 PRYEAR17  "Year of procedure 17"
 PRYEAR18  "Year of procedure 18"
 PRYEAR19  "Year of procedure 19"
 PRYEAR20  "Year of procedure 20"
 PRYEAR21  "Year of procedure 21"
 PRYEAR22  "Year of procedure 22"
 PRYEAR23  "Year of procedure 23"
 PRYEAR24  "Year of procedure 24"
 PRYEAR25  "Year of procedure 25"
 PRYEAR26  "Year of procedure 26"
 PRYEAR27  "Year of procedure 27"
 PRYEAR28  "Year of procedure 28"
 PRYEAR29  "Year of procedure 29"
 PRYEAR30  "Year of procedure 30"
 PRYEAR31  "Year of procedure 31"
 PRYEAR32  "Year of procedure 32"
 PRYEAR33  "Year of procedure 33"
 PRYEAR34  "Year of procedure 34"
 PRYEAR35  "Year of procedure 35"
 PRYEAR36  "Year of procedure 36"
 PRYEAR37  "Year of procedure 37"
 PRYEAR38  "Year of procedure 38"
 PRYEAR39  "Year of procedure 39"
 PRYEAR40  "Year of procedure 40"
 PRYEAR41  "Year of procedure 41"
 PRYEAR42  "Year of procedure 42"
 PRYEAR43  "Year of procedure 43"
 PRYEAR44  "Year of procedure 44"
 PRYEAR45  "Year of procedure 45"
 PRYEAR46  "Year of procedure 46" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPO
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS51
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS52
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS53
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS54
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS55
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS56
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS57
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS58
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS59
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS60
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS61
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Hospital
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH45
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH46
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR45
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR46
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'SD_SID_2008_CORE.SAV' /COMPRESSED.
