/*******************************************************************
*   SD_SID_2008_SEVERITY.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY SEVERITY FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'SD_SID_2008_SEVERITY.ASC' FIXED / 
 KEY                        1-  14
 CM_AIDS                   15-  16
 CM_ALCOH                  17-  18
 CM_ANEMD                  19-  20
 CM_ARTH                   21-  22
 CM_BLDLO                  23-  24
 CM_CHF                    25-  26
 CM_CHRNL                  27-  28
 CM_COAG                   29-  30
 CM_DEPRE                  31-  32
 CM_DM                     33-  34
 CM_DMCX                   35-  36
 CM_DRUG                   37-  38
 CM_HTN_C                  39-  40
 CM_HYPOT                  41-  42
 CM_LIVER                  43-  44
 CM_LYMPH                  45-  46
 CM_LYTES                  47-  48
 CM_METS                   49-  50
 CM_NEURO                  51-  52
 CM_OBESE                  53-  54
 CM_PARA                   55-  56
 CM_PERIV                  57-  58
 CM_PSYCH                  59-  60
 CM_PULMC                  61-  62
 CM_RENLF                  63-  64
 CM_TUMOR                  65-  66
 CM_ULCER                  67-  68
 CM_VALVE                  69-  70
 CM_WGHTL                  71-  72.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 CM_AIDS                 (F3.0) /
 CM_ALCOH                (F3.0) /
 CM_ANEMD                (F3.0) /
 CM_ARTH                 (F3.0) /
 CM_BLDLO                (F3.0) /
 CM_CHF                  (F3.0) /
 CM_CHRNL                (F3.0) /
 CM_COAG                 (F3.0) /
 CM_DEPRE                (F3.0) /
 CM_DM                   (F3.0) /
 CM_DMCX                 (F3.0) /
 CM_DRUG                 (F3.0) /
 CM_HTN_C                (F3.0) /
 CM_HYPOT                (F3.0) /
 CM_LIVER                (F3.0) /
 CM_LYMPH                (F3.0) /
 CM_LYTES                (F3.0) /
 CM_METS                 (F3.0) /
 CM_NEURO                (F3.0) /
 CM_OBESE                (F3.0) /
 CM_PARA                 (F3.0) /
 CM_PERIV                (F3.0) /
 CM_PSYCH                (F3.0) /
 CM_PULMC                (F3.0) /
 CM_RENLF                (F3.0) /
 CM_TUMOR                (F3.0) /
 CM_ULCER                (F3.0) /
 CM_VALVE                (F3.0) /
 CM_WGHTL                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CM_AIDS   "AHRQ comorbidity measure: Acquired immune deficiency syndrome"
 CM_ALCOH  "AHRQ comorbidity measure: Alcohol abuse"
 CM_ANEMD  "AHRQ comorbidity measure: Deficiency anemias"
 CM_ARTH   "AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular diseases"
 CM_BLDLO  "AHRQ comorbidity measure: Chronic blood loss anemia"
 CM_CHF    "AHRQ comorbidity measure: Congestive heart failure"
 CM_CHRNL  "AHRQ comorbidity measure: Chronic pulmonary disease"
 CM_COAG   "AHRQ comorbidity measure: Coagulopathy"
 CM_DEPRE  "AHRQ comorbidity measure: Depression"
 CM_DM     "AHRQ comorbidity measure: Diabetes, uncomplicated"
 CM_DMCX   "AHRQ comorbidity measure: Diabetes with chronic complications"
 CM_DRUG   "AHRQ comorbidity measure: Drug abuse"
 CM_HTN_C  "AHRQ comorbidity measure: Hypertension (combine uncomplicated and complicated)"
 CM_HYPOT  "AHRQ comorbidity measure: Hypothyroidism"
 CM_LIVER  "AHRQ comorbidity measure: Liver disease"
 CM_LYMPH  "AHRQ comorbidity measure: Lymphoma"
 CM_LYTES  "AHRQ comorbidity measure: Fluid and electrolyte disorders"
 CM_METS   "AHRQ comorbidity measure: Metastatic cancer"
 CM_NEURO  "AHRQ comorbidity measure: Other neurological disorders"
 CM_OBESE  "AHRQ comorbidity measure: Obesity"
 CM_PARA   "AHRQ comorbidity measure: Paralysis"
 CM_PERIV  "AHRQ comorbidity measure: Peripheral vascular disorders"
 CM_PSYCH  "AHRQ comorbidity measure: Psychoses"
 CM_PULMC  "AHRQ comorbidity measure: Pulmonary circulation disorders"
 CM_RENLF  "AHRQ comorbidity measure: Renal failure"
 CM_TUMOR  "AHRQ comorbidity measure: Solid tumor without metastasis"
 CM_ULCER  "AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding"
 CM_VALVE  "AHRQ comorbidity measure: Valvular disease"
 CM_WGHTL  "AHRQ comorbidity measure: Weight loss" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CM_AIDS
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ALCOH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ANEMD
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ARTH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_BLDLO
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_CHF
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_CHRNL
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_COAG
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DEPRE
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DM
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DMCX
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DRUG
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_HTN_C
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_HYPOT
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LIVER
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LYMPH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LYTES
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_METS
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_NEURO
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_OBESE
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PARA
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PERIV
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PSYCH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PULMC
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_RENLF
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_TUMOR
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ULCER
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_VALVE
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_WGHTL
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'SD_SID_2008_SEVERITY.SAV' /COMPRESSED.
