/*******************************************************************
*   SD_SID_2010_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'SD_SID_2010_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ATYPE                     12-  13
 AWEEKEND                  14-  15
 DIED                      16-  17
 DISPUB04                  18-  19
 DISPUNIFORM               20-  21
 DISP_X                    22-  25 (A)
 DQTR                      26-  27
 DRG                       28-  30
 DRG24                     31-  33
 DRGVER                    34-  35
 DRG_NoPOA                 36-  38
 DX1                       39-  43 (A)
 DX2                       44-  48 (A)
 DX3                       49-  53 (A)
 DX4                       54-  58 (A)
 DX5                       59-  63 (A)
 DX6                       64-  68 (A)
 DX7                       69-  73 (A)
 DX8                       74-  78 (A)
 DX9                       79-  83 (A)
 DX10                      84-  88 (A)
 DX11                      89-  93 (A)
 DX12                      94-  98 (A)
 DX13                      99- 103 (A)
 DX14                     104- 108 (A)
 DX15                     109- 113 (A)
 DX16                     114- 118 (A)
 DX17                     119- 123 (A)
 DX18                     124- 128 (A)
 DX19                     129- 133 (A)
 DX20                     134- 138 (A)
 DX21                     139- 143 (A)
 DX22                     144- 148 (A)
 DX23                     149- 153 (A)
 DX24                     154- 158 (A)
 DX25                     159- 163 (A)
 DX26                     164- 168 (A)
 DX27                     169- 173 (A)
 DX28                     174- 178 (A)
 DX29                     179- 183 (A)
 DX30                     184- 188 (A)
 DX31                     189- 193 (A)
 DX32                     194- 198 (A)
 DX33                     199- 203 (A)
 DX34                     204- 208 (A)
 DX35                     209- 213 (A)
 DX36                     214- 218 (A)
 DX37                     219- 223 (A)
 DX38                     224- 228 (A)
 DX39                     229- 233 (A)
 DX40                     234- 238 (A)
 DX41                     239- 243 (A)
 DX42                     244- 248 (A)
 DX43                     249- 253 (A)
 DX44                     254- 258 (A)
 DX45                     259- 263 (A)
 DX46                     264- 268 (A)
 DX47                     269- 273 (A)
 DX48                     274- 278 (A)
 DX49                     279- 283 (A)
 DX50                     284- 288 (A)
 DX51                     289- 293 (A)
 DX52                     294- 298 (A)
 DX53                     299- 303 (A)
 DX54                     304- 308 (A)
 DX55                     309- 313 (A)
 DX56                     314- 318 (A)
 DX57                     319- 323 (A)
 DX58                     324- 328 (A)
 DX59                     329- 333 (A)
 DX60                     334- 338 (A)
 DX61                     339- 343 (A)
 DX62                     344- 348 (A)
 DX63                     349- 353 (A)
 DX64                     354- 358 (A)
 DX65                     359- 363 (A)
 DX66                     364- 368 (A)
 DX67                     369- 373 (A)
 DX68                     374- 378 (A)
 DX69                     379- 383 (A)
 DX70                     384- 388 (A)
 DX71                     389- 393 (A)
 DX72                     394- 398 (A)
 DX73                     399- 403 (A)
 DX74                     404- 408 (A)
 DX75                     409- 413 (A)
 DX76                     414- 418 (A)
 DX77                     419- 423 (A)
 DX78                     424- 428 (A)
 DX79                     429- 433 (A)
 DX80                     434- 438 (A)
 DX81                     439- 443 (A)
 DX82                     444- 448 (A)
 DX83                     449- 453 (A)
 DXCCS1                   454- 457
 DXCCS2                   458- 461
 DXCCS3                   462- 465
 DXCCS4                   466- 469
 DXCCS5                   470- 473
 DXCCS6                   474- 477
 DXCCS7                   478- 481
 DXCCS8                   482- 485
 DXCCS9                   486- 489
 DXCCS10                  490- 493
 DXCCS11                  494- 497
 DXCCS12                  498- 501
 DXCCS13                  502- 505
 DXCCS14                  506- 509
 DXCCS15                  510- 513
 DXCCS16                  514- 517
 DXCCS17                  518- 521
 DXCCS18                  522- 525
 DXCCS19                  526- 529
 DXCCS20                  530- 533
 DXCCS21                  534- 537
 DXCCS22                  538- 541
 DXCCS23                  542- 545
 DXCCS24                  546- 549
 DXCCS25                  550- 553
 DXCCS26                  554- 557
 DXCCS27                  558- 561
 DXCCS28                  562- 565
 DXCCS29                  566- 569
 DXCCS30                  570- 573
 DXCCS31                  574- 577
 DXCCS32                  578- 581
 DXCCS33                  582- 585
 DXCCS34                  586- 589
 DXCCS35                  590- 593
 DXCCS36                  594- 597
 DXCCS37                  598- 601
 DXCCS38                  602- 605
 DXCCS39                  606- 609
 DXCCS40                  610- 613
 DXCCS41                  614- 617
 DXCCS42                  618- 621
 DXCCS43                  622- 625
 DXCCS44                  626- 629
 DXCCS45                  630- 633
 DXCCS46                  634- 637
 DXCCS47                  638- 641
 DXCCS48                  642- 645
 DXCCS49                  646- 649
 DXCCS50                  650- 653
 DXCCS51                  654- 657
 DXCCS52                  658- 661
 DXCCS53                  662- 665
 DXCCS54                  666- 669
 DXCCS55                  670- 673
 DXCCS56                  674- 677
 DXCCS57                  678- 681
 DXCCS58                  682- 685
 DXCCS59                  686- 689
 DXCCS60                  690- 693
 DXCCS61                  694- 697
 DXCCS62                  698- 701
 DXCCS63                  702- 705
 DXCCS64                  706- 709
 DXCCS65                  710- 713
 DXCCS66                  714- 717
 DXCCS67                  718- 721
 DXCCS68                  722- 725
 DXCCS69                  726- 729
 DXCCS70                  730- 733
 DXCCS71                  734- 737
 DXCCS72                  738- 741
 DXCCS73                  742- 745
 DXCCS74                  746- 749
 DXCCS75                  750- 753
 DXCCS76                  754- 757
 DXCCS77                  758- 761
 DXCCS78                  762- 765
 DXCCS79                  766- 769
 DXCCS80                  770- 773
 DXCCS81                  774- 777
 DXCCS82                  778- 781
 DXCCS83                  782- 785
 DXPOA1                   786     (A)
 DXPOA2                   787     (A)
 DXPOA3                   788     (A)
 DXPOA4                   789     (A)
 DXPOA5                   790     (A)
 DXPOA6                   791     (A)
 DXPOA7                   792     (A)
 DXPOA8                   793     (A)
 DXPOA9                   794     (A)
 DXPOA10                  795     (A)
 DXPOA11                  796     (A)
 DXPOA12                  797     (A)
 DXPOA13                  798     (A)
 DXPOA14                  799     (A)
 DXPOA15                  800     (A)
 DXPOA16                  801     (A)
 DXPOA17                  802     (A)
 DXPOA18                  803     (A)
 DXPOA19                  804     (A)
 DXPOA20                  805     (A)
 DXPOA21                  806     (A)
 DXPOA22                  807     (A)
 DXPOA23                  808     (A)
 DXPOA24                  809     (A)
 DXPOA25                  810     (A)
 DXPOA26                  811     (A)
 DXPOA27                  812     (A)
 DXPOA28                  813     (A)
 DXPOA29                  814     (A)
 DXPOA30                  815     (A)
 DXPOA31                  816     (A)
 DXPOA32                  817     (A)
 DXPOA33                  818     (A)
 DXPOA34                  819     (A)
 DXPOA35                  820     (A)
 DXPOA36                  821     (A)
 DXPOA37                  822     (A)
 DXPOA38                  823     (A)
 DXPOA39                  824     (A)
 DXPOA40                  825     (A)
 DXPOA41                  826     (A)
 DXPOA42                  827     (A)
 DXPOA43                  828     (A)
 DXPOA44                  829     (A)
 DXPOA45                  830     (A)
 DXPOA46                  831     (A)
 DXPOA47                  832     (A)
 DXPOA48                  833     (A)
 DXPOA49                  834     (A)
 DXPOA50                  835     (A)
 DXPOA51                  836     (A)
 DXPOA52                  837     (A)
 DXPOA53                  838     (A)
 DXPOA54                  839     (A)
 DXPOA55                  840     (A)
 DXPOA56                  841     (A)
 DXPOA57                  842     (A)
 DXPOA58                  843     (A)
 DXPOA59                  844     (A)
 DXPOA60                  845     (A)
 DXPOA61                  846     (A)
 DXPOA62                  847     (A)
 DXPOA63                  848     (A)
 DXPOA64                  849     (A)
 DXPOA65                  850     (A)
 DXPOA66                  851     (A)
 DXPOA67                  852     (A)
 DXPOA68                  853     (A)
 DXPOA69                  854     (A)
 DXPOA70                  855     (A)
 DXPOA71                  856     (A)
 DXPOA72                  857     (A)
 DXPOA73                  858     (A)
 DXPOA74                  859     (A)
 DXPOA75                  860     (A)
 DXPOA76                  861     (A)
 DXPOA77                  862     (A)
 DXPOA78                  863     (A)
 DXPOA79                  864     (A)
 DXPOA80                  865     (A)
 DXPOA81                  866     (A)
 DXPOA82                  867     (A)
 DXPOA83                  868     (A)
 ECODE1                   869- 873 (A)
 ECODE2                   874- 878 (A)
 ECODE3                   879- 883 (A)
 ECODE4                   884- 888 (A)
 ECODE5                   889- 893 (A)
 ECODE6                   894- 898 (A)
 ECODE7                   899- 903 (A)
 ECODE8                   904- 908 (A)
 E_CCS1                   909- 912
 E_CCS2                   913- 916
 E_CCS3                   917- 920
 E_CCS4                   921- 924
 E_CCS5                   925- 928
 E_CCS6                   929- 932
 E_CCS7                   933- 936
 E_CCS8                   937- 940
 E_POA1                   941     (A)
 E_POA2                   942     (A)
 E_POA3                   943     (A)
 E_POA4                   944     (A)
 E_POA5                   945     (A)
 E_POA6                   946     (A)
 E_POA7                   947     (A)
 E_POA8                   948     (A)
 FEMALE                   949- 950
 HCUP_ED                  951- 952
 HCUP_OS                  953- 954
 HOSPBRTH                 955- 957
 HOSPST                   958- 959 (A)
 HospitalUnit             960- 961
 KEY                      962- 979
 LOS                      980- 984
 LOS_X                    985- 990
 MDC                      991- 992
 MDC24                    993- 994
 MDC_NoPOA                995- 996
 MDNUM1_R                 997-1005
 MDNUM2_R                1006-1014
 MDNUM3_R                1015-1023
 MEDINCSTQ               1024-1025
 MRN_R                   1026-1034
 NCHRONIC                1035-1037
 NDX                     1038-1039
 NECODE                  1040-1041
 NEOMAT                  1042-1043
 NPR                     1044-1045
 ORPROC                  1046-1047
 PAY1                    1048-1049
 PL_CBSA                 1050-1052
 PL_MSA1993              1053-1055
 PL_NCHS2006             1056-1057
 PL_RUCA10_2005          1058-1059
 PL_RUCA2005             1060-1063
 PL_RUCA4_2005           1064-1065
 PL_RUCC2003             1066-1067
 PL_UIC2003              1068-1069
 PL_UR_CAT4              1070-1071
 PR1                     1072-1075 (A)
 PR2                     1076-1079 (A)
 PR3                     1080-1083 (A)
 PR4                     1084-1087 (A)
 PR5                     1088-1091 (A)
 PR6                     1092-1095 (A)
 PR7                     1096-1099 (A)
 PR8                     1100-1103 (A)
 PR9                     1104-1107 (A)
 PR10                    1108-1111 (A)
 PR11                    1112-1115 (A)
 PR12                    1116-1119 (A)
 PR13                    1120-1123 (A)
 PR14                    1124-1127 (A)
 PR15                    1128-1131 (A)
 PR16                    1132-1135 (A)
 PR17                    1136-1139 (A)
 PR18                    1140-1143 (A)
 PR19                    1144-1147 (A)
 PR20                    1148-1151 (A)
 PR21                    1152-1155 (A)
 PR22                    1156-1159 (A)
 PR23                    1160-1163 (A)
 PR24                    1164-1167 (A)
 PR25                    1168-1171 (A)
 PR26                    1172-1175 (A)
 PR27                    1176-1179 (A)
 PR28                    1180-1183 (A)
 PR29                    1184-1187 (A)
 PR30                    1188-1191 (A)
 PR31                    1192-1195 (A)
 PR32                    1196-1199 (A)
 PR33                    1200-1203 (A)
 PR34                    1204-1207 (A)
 PR35                    1208-1211 (A)
 PR36                    1212-1215 (A)
 PR37                    1216-1219 (A)
 PR38                    1220-1223 (A)
 PR39                    1224-1227 (A)
 PR40                    1228-1231 (A)
 PR41                    1232-1235 (A)
 PR42                    1236-1239 (A)
 PR43                    1240-1243 (A)
 PR44                    1244-1247 (A)
 PR45                    1248-1251 (A)
 PR46                    1252-1255 (A)
 PR47                    1256-1259 (A)
 PRCCS1                  1260-1262
 PRCCS2                  1263-1265
 PRCCS3                  1266-1268
 PRCCS4                  1269-1271
 PRCCS5                  1272-1274
 PRCCS6                  1275-1277
 PRCCS7                  1278-1280
 PRCCS8                  1281-1283
 PRCCS9                  1284-1286
 PRCCS10                 1287-1289
 PRCCS11                 1290-1292
 PRCCS12                 1293-1295
 PRCCS13                 1296-1298
 PRCCS14                 1299-1301
 PRCCS15                 1302-1304
 PRCCS16                 1305-1307
 PRCCS17                 1308-1310
 PRCCS18                 1311-1313
 PRCCS19                 1314-1316
 PRCCS20                 1317-1319
 PRCCS21                 1320-1322
 PRCCS22                 1323-1325
 PRCCS23                 1326-1328
 PRCCS24                 1329-1331
 PRCCS25                 1332-1334
 PRCCS26                 1335-1337
 PRCCS27                 1338-1340
 PRCCS28                 1341-1343
 PRCCS29                 1344-1346
 PRCCS30                 1347-1349
 PRCCS31                 1350-1352
 PRCCS32                 1353-1355
 PRCCS33                 1356-1358
 PRCCS34                 1359-1361
 PRCCS35                 1362-1364
 PRCCS36                 1365-1367
 PRCCS37                 1368-1370
 PRCCS38                 1371-1373
 PRCCS39                 1374-1376
 PRCCS40                 1377-1379
 PRCCS41                 1380-1382
 PRCCS42                 1383-1385
 PRCCS43                 1386-1388
 PRCCS44                 1389-1391
 PRCCS45                 1392-1394
 PRCCS46                 1395-1397
 PRCCS47                 1398-1400
 PRDAY1                  1401-1405
 PRDAY2                  1406-1410
 PRDAY3                  1411-1415
 PRDAY4                  1416-1420
 PRDAY5                  1421-1425
 PRDAY6                  1426-1430
 PRDAY7                  1431-1435
 PRDAY8                  1436-1440
 PRDAY9                  1441-1445
 PRDAY10                 1446-1450
 PRDAY11                 1451-1455
 PRDAY12                 1456-1460
 PRDAY13                 1461-1465
 PRDAY14                 1466-1470
 PRDAY15                 1471-1475
 PRDAY16                 1476-1480
 PRDAY17                 1481-1485
 PRDAY18                 1486-1490
 PRDAY19                 1491-1495
 PRDAY20                 1496-1500
 PRDAY21                 1501-1505
 PRDAY22                 1506-1510
 PRDAY23                 1511-1515
 PRDAY24                 1516-1520
 PRDAY25                 1521-1525
 PRDAY26                 1526-1530
 PRDAY27                 1531-1535
 PRDAY28                 1536-1540
 PRDAY29                 1541-1545
 PRDAY30                 1546-1550
 PRDAY31                 1551-1555
 PRDAY32                 1556-1560
 PRDAY33                 1561-1565
 PRDAY34                 1566-1570
 PRDAY35                 1571-1575
 PRDAY36                 1576-1580
 PRDAY37                 1581-1585
 PRDAY38                 1586-1590
 PRDAY39                 1591-1595
 PRDAY40                 1596-1600
 PRDAY41                 1601-1605
 PRDAY42                 1606-1610
 PRDAY43                 1611-1615
 PRDAY44                 1616-1620
 PRDAY45                 1621-1625
 PRDAY46                 1626-1630
 PRDAY47                 1631-1635
 PROCTYPE                1636-1638
 PSTATE                  1639-1640 (A)
 PSTCO                   1641-1645
 PSTCO2                  1646-1650
 PointOfOriginUB04       1651     (A)
 PointOfOrigin_X         1652     (A)
 RACE                    1653-1654
 RACE_X                  1655-1658 (A)
 TOTCHG                  1659-1668
 TOTCHG_X                1669-1683
 TRAN_IN                 1684-1685
 TRAN_OUT                1686-1687
 YEAR                    1688-1691
 ZIP3                    1692-1694 (A)
 ZIPINC_QRTL             1695-1697
 HOSPID                  1698-1702
 ZIP                     1703-1707 (A)
 AYEAR                   1708-1711
 DMONTH                  1712-1713
 BMONTH                  1714-1715
 BYEAR                   1716-1719
 PRMONTH1                1720-1721
 PRMONTH2                1722-1723
 PRMONTH3                1724-1725
 PRMONTH4                1726-1727
 PRMONTH5                1728-1729
 PRMONTH6                1730-1731
 PRMONTH7                1732-1733
 PRMONTH8                1734-1735
 PRMONTH9                1736-1737
 PRMONTH10               1738-1739
 PRMONTH11               1740-1741
 PRMONTH12               1742-1743
 PRMONTH13               1744-1745
 PRMONTH14               1746-1747
 PRMONTH15               1748-1749
 PRMONTH16               1750-1751
 PRMONTH17               1752-1753
 PRMONTH18               1754-1755
 PRMONTH19               1756-1757
 PRMONTH20               1758-1759
 PRMONTH21               1760-1761
 PRMONTH22               1762-1763
 PRMONTH23               1764-1765
 PRMONTH24               1766-1767
 PRMONTH25               1768-1769
 PRMONTH26               1770-1771
 PRMONTH27               1772-1773
 PRMONTH28               1774-1775
 PRMONTH29               1776-1777
 PRMONTH30               1778-1779
 PRMONTH31               1780-1781
 PRMONTH32               1782-1783
 PRMONTH33               1784-1785
 PRMONTH34               1786-1787
 PRMONTH35               1788-1789
 PRMONTH36               1790-1791
 PRMONTH37               1792-1793
 PRMONTH38               1794-1795
 PRMONTH39               1796-1797
 PRMONTH40               1798-1799
 PRMONTH41               1800-1801
 PRMONTH42               1802-1803
 PRMONTH43               1804-1805
 PRMONTH44               1806-1807
 PRMONTH45               1808-1809
 PRMONTH46               1810-1811
 PRMONTH47               1812-1813
 PRYEAR1                 1814-1817
 PRYEAR2                 1818-1821
 PRYEAR3                 1822-1825
 PRYEAR4                 1826-1829
 PRYEAR5                 1830-1833
 PRYEAR6                 1834-1837
 PRYEAR7                 1838-1841
 PRYEAR8                 1842-1845
 PRYEAR9                 1846-1849
 PRYEAR10                1850-1853
 PRYEAR11                1854-1857
 PRYEAR12                1858-1861
 PRYEAR13                1862-1865
 PRYEAR14                1866-1869
 PRYEAR15                1870-1873
 PRYEAR16                1874-1877
 PRYEAR17                1878-1881
 PRYEAR18                1882-1885
 PRYEAR19                1886-1889
 PRYEAR20                1890-1893
 PRYEAR21                1894-1897
 PRYEAR22                1898-1901
 PRYEAR23                1902-1905
 PRYEAR24                1906-1909
 PRYEAR25                1910-1913
 PRYEAR26                1914-1917
 PRYEAR27                1918-1921
 PRYEAR28                1922-1925
 PRYEAR29                1926-1929
 PRYEAR30                1930-1933
 PRYEAR31                1934-1937
 PRYEAR32                1938-1941
 PRYEAR33                1942-1945
 PRYEAR34                1946-1949
 PRYEAR35                1950-1953
 PRYEAR36                1954-1957
 PRYEAR37                1958-1961
 PRYEAR38                1962-1965
 PRYEAR39                1966-1969
 PRYEAR40                1970-1973
 PRYEAR41                1974-1977
 PRYEAR42                1978-1981
 PRYEAR43                1982-1985
 PRYEAR44                1986-1989
 PRYEAR45                1990-1993
 PRYEAR46                1994-1997
 PRYEAR47                1998-2001.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPOA               (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 DXCCS34                 (F4.0) /
 DXCCS35                 (F4.0) /
 DXCCS36                 (F4.0) /
 DXCCS37                 (F4.0) /
 DXCCS38                 (F4.0) /
 DXCCS39                 (F4.0) /
 DXCCS40                 (F4.0) /
 DXCCS41                 (F4.0) /
 DXCCS42                 (F4.0) /
 DXCCS43                 (F4.0) /
 DXCCS44                 (F4.0) /
 DXCCS45                 (F4.0) /
 DXCCS46                 (F4.0) /
 DXCCS47                 (F4.0) /
 DXCCS48                 (F4.0) /
 DXCCS49                 (F4.0) /
 DXCCS50                 (F4.0) /
 DXCCS51                 (F4.0) /
 DXCCS52                 (F4.0) /
 DXCCS53                 (F4.0) /
 DXCCS54                 (F4.0) /
 DXCCS55                 (F4.0) /
 DXCCS56                 (F4.0) /
 DXCCS57                 (F4.0) /
 DXCCS58                 (F4.0) /
 DXCCS59                 (F4.0) /
 DXCCS60                 (F4.0) /
 DXCCS61                 (F4.0) /
 DXCCS62                 (F4.0) /
 DXCCS63                 (F4.0) /
 DXCCS64                 (F4.0) /
 DXCCS65                 (F4.0) /
 DXCCS66                 (F4.0) /
 DXCCS67                 (F4.0) /
 DXCCS68                 (F4.0) /
 DXCCS69                 (F4.0) /
 DXCCS70                 (F4.0) /
 DXCCS71                 (F4.0) /
 DXCCS72                 (F4.0) /
 DXCCS73                 (F4.0) /
 DXCCS74                 (F4.0) /
 DXCCS75                 (F4.0) /
 DXCCS76                 (F4.0) /
 DXCCS77                 (F4.0) /
 DXCCS78                 (F4.0) /
 DXCCS79                 (F4.0) /
 DXCCS80                 (F4.0) /
 DXCCS81                 (F4.0) /
 DXCCS82                 (F4.0) /
 DXCCS83                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 HospitalUnit            (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDC_NoPOA               (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MDNUM3_R                (F5.0) /
 MEDINCSTQ               (F3.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRCCS31                 (F3.0) /
 PRCCS32                 (F3.0) /
 PRCCS33                 (F3.0) /
 PRCCS34                 (F3.0) /
 PRCCS35                 (F3.0) /
 PRCCS36                 (F3.0) /
 PRCCS37                 (F3.0) /
 PRCCS38                 (F3.0) /
 PRCCS39                 (F3.0) /
 PRCCS40                 (F3.0) /
 PRCCS41                 (F3.0) /
 PRCCS42                 (F3.0) /
 PRCCS43                 (F3.0) /
 PRCCS44                 (F3.0) /
 PRCCS45                 (F3.0) /
 PRCCS46                 (F3.0) /
 PRCCS47                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PRDAY24                 (F4.0) /
 PRDAY25                 (F4.0) /
 PRDAY26                 (F4.0) /
 PRDAY27                 (F4.0) /
 PRDAY28                 (F4.0) /
 PRDAY29                 (F4.0) /
 PRDAY30                 (F4.0) /
 PRDAY31                 (F4.0) /
 PRDAY32                 (F4.0) /
 PRDAY33                 (F4.0) /
 PRDAY34                 (F4.0) /
 PRDAY35                 (F4.0) /
 PRDAY36                 (F4.0) /
 PRDAY37                 (F4.0) /
 PRDAY38                 (F4.0) /
 PRDAY39                 (F4.0) /
 PRDAY40                 (F4.0) /
 PRDAY41                 (F4.0) /
 PRDAY42                 (F4.0) /
 PRDAY43                 (F4.0) /
 PRDAY44                 (F4.0) /
 PRDAY45                 (F4.0) /
 PRDAY46                 (F4.0) /
 PRDAY47                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TRAN_IN                 (F3.0) /
 TRAN_OUT                (F3.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 HOSPID                  (F4.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRMONTH16               (F3.0) /
 PRMONTH17               (F3.0) /
 PRMONTH18               (F3.0) /
 PRMONTH19               (F3.0) /
 PRMONTH20               (F3.0) /
 PRMONTH21               (F3.0) /
 PRMONTH22               (F3.0) /
 PRMONTH23               (F3.0) /
 PRMONTH24               (F3.0) /
 PRMONTH25               (F3.0) /
 PRMONTH26               (F3.0) /
 PRMONTH27               (F3.0) /
 PRMONTH28               (F3.0) /
 PRMONTH29               (F3.0) /
 PRMONTH30               (F3.0) /
 PRMONTH31               (F3.0) /
 PRMONTH32               (F3.0) /
 PRMONTH33               (F3.0) /
 PRMONTH34               (F3.0) /
 PRMONTH35               (F3.0) /
 PRMONTH36               (F3.0) /
 PRMONTH37               (F3.0) /
 PRMONTH38               (F3.0) /
 PRMONTH39               (F3.0) /
 PRMONTH40               (F3.0) /
 PRMONTH41               (F3.0) /
 PRMONTH42               (F3.0) /
 PRMONTH43               (F3.0) /
 PRMONTH44               (F3.0) /
 PRMONTH45               (F3.0) /
 PRMONTH46               (F3.0) /
 PRMONTH47               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) /
 PRYEAR24                (F3.0) /
 PRYEAR25                (F3.0) /
 PRYEAR26                (F3.0) /
 PRYEAR27                (F3.0) /
 PRYEAR28                (F3.0) /
 PRYEAR29                (F3.0) /
 PRYEAR30                (F3.0) /
 PRYEAR31                (F3.0) /
 PRYEAR32                (F3.0) /
 PRYEAR33                (F3.0) /
 PRYEAR34                (F3.0) /
 PRYEAR35                (F3.0) /
 PRYEAR36                (F3.0) /
 PRYEAR37                (F3.0) /
 PRYEAR38                (F3.0) /
 PRYEAR39                (F3.0) /
 PRYEAR40                (F3.0) /
 PRYEAR41                (F3.0) /
 PRYEAR42                (F3.0) /
 PRYEAR43                (F3.0) /
 PRYEAR44                (F3.0) /
 PRYEAR45                (F3.0) /
 PRYEAR46                (F3.0) /
 PRYEAR47                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMONTH                  "Admission month"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DRG_NoPOA               "DRG in use on discharge date, calculated without POA"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DX26                    "Diagnosis 26"
 DX27                    "Diagnosis 27"
 DX28                    "Diagnosis 28"
 DX29                    "Diagnosis 29"
 DX30                    "Diagnosis 30"
 DX31                    "Diagnosis 31"
 DX32                    "Diagnosis 32"
 DX33                    "Diagnosis 33"
 DX34                    "Diagnosis 34"
 DX35                    "Diagnosis 35"
 DX36                    "Diagnosis 36"
 DX37                    "Diagnosis 37"
 DX38                    "Diagnosis 38"
 DX39                    "Diagnosis 39"
 DX40                    "Diagnosis 40"
 DX41                    "Diagnosis 41"
 DX42                    "Diagnosis 42"
 DX43                    "Diagnosis 43"
 DX44                    "Diagnosis 44"
 DX45                    "Diagnosis 45"
 DX46                    "Diagnosis 46"
 DX47                    "Diagnosis 47"
 DX48                    "Diagnosis 48"
 DX49                    "Diagnosis 49"
 DX50                    "Diagnosis 50"
 DX51                    "Diagnosis 51"
 DX52                    "Diagnosis 52"
 DX53                    "Diagnosis 53"
 DX54                    "Diagnosis 54"
 DX55                    "Diagnosis 55"
 DX56                    "Diagnosis 56"
 DX57                    "Diagnosis 57"
 DX58                    "Diagnosis 58"
 DX59                    "Diagnosis 59"
 DX60                    "Diagnosis 60"
 DX61                    "Diagnosis 61"
 DX62                    "Diagnosis 62"
 DX63                    "Diagnosis 63"
 DX64                    "Diagnosis 64"
 DX65                    "Diagnosis 65"
 DX66                    "Diagnosis 66"
 DX67                    "Diagnosis 67"
 DX68                    "Diagnosis 68"
 DX69                    "Diagnosis 69"
 DX70                    "Diagnosis 70"
 DX71                    "Diagnosis 71"
 DX72                    "Diagnosis 72"
 DX73                    "Diagnosis 73"
 DX74                    "Diagnosis 74"
 DX75                    "Diagnosis 75"
 DX76                    "Diagnosis 76"
 DX77                    "Diagnosis 77"
 DX78                    "Diagnosis 78"
 DX79                    "Diagnosis 79"
 DX80                    "Diagnosis 80"
 DX81                    "Diagnosis 81"
 DX82                    "Diagnosis 82"
 DX83                    "Diagnosis 83"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXCCS26                 "CCS: diagnosis 26"
 DXCCS27                 "CCS: diagnosis 27"
 DXCCS28                 "CCS: diagnosis 28"
 DXCCS29                 "CCS: diagnosis 29"
 DXCCS30                 "CCS: diagnosis 30"
 DXCCS31                 "CCS: diagnosis 31"
 DXCCS32                 "CCS: diagnosis 32"
 DXCCS33                 "CCS: diagnosis 33"
 DXCCS34                 "CCS: diagnosis 34"
 DXCCS35                 "CCS: diagnosis 35"
 DXCCS36                 "CCS: diagnosis 36"
 DXCCS37                 "CCS: diagnosis 37"
 DXCCS38                 "CCS: diagnosis 38"
 DXCCS39                 "CCS: diagnosis 39"
 DXCCS40                 "CCS: diagnosis 40"
 DXCCS41                 "CCS: diagnosis 41"
 DXCCS42                 "CCS: diagnosis 42"
 DXCCS43                 "CCS: diagnosis 43"
 DXCCS44                 "CCS: diagnosis 44"
 DXCCS45                 "CCS: diagnosis 45"
 DXCCS46                 "CCS: diagnosis 46"
 DXCCS47                 "CCS: diagnosis 47"
 DXCCS48                 "CCS: diagnosis 48"
 DXCCS49                 "CCS: diagnosis 49"
 DXCCS50                 "CCS: diagnosis 50"
 DXCCS51                 "CCS: diagnosis 51"
 DXCCS52                 "CCS: diagnosis 52"
 DXCCS53                 "CCS: diagnosis 53"
 DXCCS54                 "CCS: diagnosis 54"
 DXCCS55                 "CCS: diagnosis 55"
 DXCCS56                 "CCS: diagnosis 56"
 DXCCS57                 "CCS: diagnosis 57"
 DXCCS58                 "CCS: diagnosis 58"
 DXCCS59                 "CCS: diagnosis 59"
 DXCCS60                 "CCS: diagnosis 60"
 DXCCS61                 "CCS: diagnosis 61"
 DXCCS62                 "CCS: diagnosis 62"
 DXCCS63                 "CCS: diagnosis 63"
 DXCCS64                 "CCS: diagnosis 64"
 DXCCS65                 "CCS: diagnosis 65"
 DXCCS66                 "CCS: diagnosis 66"
 DXCCS67                 "CCS: diagnosis 67"
 DXCCS68                 "CCS: diagnosis 68"
 DXCCS69                 "CCS: diagnosis 69"
 DXCCS70                 "CCS: diagnosis 70"
 DXCCS71                 "CCS: diagnosis 71"
 DXCCS72                 "CCS: diagnosis 72"
 DXCCS73                 "CCS: diagnosis 73"
 DXCCS74                 "CCS: diagnosis 74"
 DXCCS75                 "CCS: diagnosis 75"
 DXCCS76                 "CCS: diagnosis 76"
 DXCCS77                 "CCS: diagnosis 77"
 DXCCS78                 "CCS: diagnosis 78"
 DXCCS79                 "CCS: diagnosis 79"
 DXCCS80                 "CCS: diagnosis 80"
 DXCCS81                 "CCS: diagnosis 81"
 DXCCS82                 "CCS: diagnosis 82"
 DXCCS83                 "CCS: diagnosis 83"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DXPOA7                  "Diagnosis 7, present on admission indicator"
 DXPOA8                  "Diagnosis 8, present on admission indicator"
 DXPOA9                  "Diagnosis 9, present on admission indicator"
 DXPOA10                 "Diagnosis 10, present on admission indicator"
 DXPOA11                 "Diagnosis 11, present on admission indicator"
 DXPOA12                 "Diagnosis 12, present on admission indicator"
 DXPOA13                 "Diagnosis 13, present on admission indicator"
 DXPOA14                 "Diagnosis 14, present on admission indicator"
 DXPOA15                 "Diagnosis 15, present on admission indicator"
 DXPOA16                 "Diagnosis 16, present on admission indicator"
 DXPOA17                 "Diagnosis 17, present on admission indicator"
 DXPOA18                 "Diagnosis 18, present on admission indicator"
 DXPOA19                 "Diagnosis 19, present on admission indicator"
 DXPOA20                 "Diagnosis 20, present on admission indicator"
 DXPOA21                 "Diagnosis 21, present on admission indicator"
 DXPOA22                 "Diagnosis 22, present on admission indicator"
 DXPOA23                 "Diagnosis 23, present on admission indicator"
 DXPOA24                 "Diagnosis 24, present on admission indicator"
 DXPOA25                 "Diagnosis 25, present on admission indicator"
 DXPOA26                 "Diagnosis 26, present on admission indicator"
 DXPOA27                 "Diagnosis 27, present on admission indicator"
 DXPOA28                 "Diagnosis 28, present on admission indicator"
 DXPOA29                 "Diagnosis 29, present on admission indicator"
 DXPOA30                 "Diagnosis 30, present on admission indicator"
 DXPOA31                 "Diagnosis 31, present on admission indicator"
 DXPOA32                 "Diagnosis 32, present on admission indicator"
 DXPOA33                 "Diagnosis 33, present on admission indicator"
 DXPOA34                 "Diagnosis 34, present on admission indicator"
 DXPOA35                 "Diagnosis 35, present on admission indicator"
 DXPOA36                 "Diagnosis 36, present on admission indicator"
 DXPOA37                 "Diagnosis 37, present on admission indicator"
 DXPOA38                 "Diagnosis 38, present on admission indicator"
 DXPOA39                 "Diagnosis 39, present on admission indicator"
 DXPOA40                 "Diagnosis 40, present on admission indicator"
 DXPOA41                 "Diagnosis 41, present on admission indicator"
 DXPOA42                 "Diagnosis 42, present on admission indicator"
 DXPOA43                 "Diagnosis 43, present on admission indicator"
 DXPOA44                 "Diagnosis 44, present on admission indicator"
 DXPOA45                 "Diagnosis 45, present on admission indicator"
 DXPOA46                 "Diagnosis 46, present on admission indicator"
 DXPOA47                 "Diagnosis 47, present on admission indicator"
 DXPOA48                 "Diagnosis 48, present on admission indicator"
 DXPOA49                 "Diagnosis 49, present on admission indicator"
 DXPOA50                 "Diagnosis 50, present on admission indicator"
 DXPOA51                 "Diagnosis 51, present on admission indicator"
 DXPOA52                 "Diagnosis 52, present on admission indicator"
 DXPOA53                 "Diagnosis 53, present on admission indicator"
 DXPOA54                 "Diagnosis 54, present on admission indicator"
 DXPOA55                 "Diagnosis 55, present on admission indicator"
 DXPOA56                 "Diagnosis 56, present on admission indicator"
 DXPOA57                 "Diagnosis 57, present on admission indicator"
 DXPOA58                 "Diagnosis 58, present on admission indicator"
 DXPOA59                 "Diagnosis 59, present on admission indicator"
 DXPOA60                 "Diagnosis 60, present on admission indicator"
 DXPOA61                 "Diagnosis 61, present on admission indicator"
 DXPOA62                 "Diagnosis 62, present on admission indicator"
 DXPOA63                 "Diagnosis 63, present on admission indicator"
 DXPOA64                 "Diagnosis 64, present on admission indicator"
 DXPOA65                 "Diagnosis 65, present on admission indicator"
 DXPOA66                 "Diagnosis 66, present on admission indicator"
 DXPOA67                 "Diagnosis 67, present on admission indicator"
 DXPOA68                 "Diagnosis 68, present on admission indicator"
 DXPOA69                 "Diagnosis 69, present on admission indicator"
 DXPOA70                 "Diagnosis 70, present on admission indicator"
 DXPOA71                 "Diagnosis 71, present on admission indicator"
 DXPOA72                 "Diagnosis 72, present on admission indicator"
 DXPOA73                 "Diagnosis 73, present on admission indicator"
 DXPOA74                 "Diagnosis 74, present on admission indicator"
 DXPOA75                 "Diagnosis 75, present on admission indicator"
 DXPOA76                 "Diagnosis 76, present on admission indicator"
 DXPOA77                 "Diagnosis 77, present on admission indicator"
 DXPOA78                 "Diagnosis 78, present on admission indicator"
 DXPOA79                 "Diagnosis 79, present on admission indicator"
 DXPOA80                 "Diagnosis 80, present on admission indicator"
 DXPOA81                 "Diagnosis 81, present on admission indicator"
 DXPOA82                 "Diagnosis 82, present on admission indicator"
 DXPOA83                 "Diagnosis 83, present on admission indicator"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 E_POA5                  "E Code 5, present on admission indicator"
 E_POA6                  "E Code 6, present on admission indicator"
 E_POA7                  "E Code 7, present on admission indicator"
 E_POA8                  "E Code 8, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 HospitalUnit

"Indicator that patient was discharged from a special unit within an acute care hospital (re
ported by source)"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MDC                     "MDC in effect on discharge date"
 MDC24                   "MDC, version 24"
 MDC_NoPOA               "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                "Physician 1 number (re-identified)"
 MDNUM2_R                "Physician 2 number (re-identified)"
 MDNUM3_R                "Physician 3 number (re-identified)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PR21                    "Procedure 21"
 PR22                    "Procedure 22"
 PR23                    "Procedure 23"
 PR24                    "Procedure 24"
 PR25                    "Procedure 25"
 PR26                    "Procedure 26"
 PR27                    "Procedure 27"
 PR28                    "Procedure 28"
 PR29                    "Procedure 29"
 PR30                    "Procedure 30"
 PR31                    "Procedure 31"
 PR32                    "Procedure 32"
 PR33                    "Procedure 33"
 PR34                    "Procedure 34"
 PR35                    "Procedure 35"
 PR36                    "Procedure 36"
 PR37                    "Procedure 37"
 PR38                    "Procedure 38"
 PR39                    "Procedure 39"
 PR40                    "Procedure 40"
 PR41                    "Procedure 41"
 PR42                    "Procedure 42"
 PR43                    "Procedure 43"
 PR44                    "Procedure 44"
 PR45                    "Procedure 45"
 PR46                    "Procedure 46"
 PR47                    "Procedure 47"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRCCS21                 "CCS: procedure 21"
 PRCCS22                 "CCS: procedure 22"
 PRCCS23                 "CCS: procedure 23"
 PRCCS24                 "CCS: procedure 24"
 PRCCS25                 "CCS: procedure 25"
 PRCCS26                 "CCS: procedure 26"
 PRCCS27                 "CCS: procedure 27"
 PRCCS28                 "CCS: procedure 28"
 PRCCS29                 "CCS: procedure 29"
 PRCCS30                 "CCS: procedure 30"
 PRCCS31                 "CCS: procedure 31"
 PRCCS32                 "CCS: procedure 32"
 PRCCS33                 "CCS: procedure 33"
 PRCCS34                 "CCS: procedure 34"
 PRCCS35                 "CCS: procedure 35"
 PRCCS36                 "CCS: procedure 36"
 PRCCS37                 "CCS: procedure 37"
 PRCCS38                 "CCS: procedure 38"
 PRCCS39                 "CCS: procedure 39"
 PRCCS40                 "CCS: procedure 40"
 PRCCS41                 "CCS: procedure 41"
 PRCCS42                 "CCS: procedure 42"
 PRCCS43                 "CCS: procedure 43"
 PRCCS44                 "CCS: procedure 44"
 PRCCS45                 "CCS: procedure 45"
 PRCCS46                 "CCS: procedure 46"
 PRCCS47                 "CCS: procedure 47"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PRDAY16                 "Number of days from admission to PR16"
 PRDAY17                 "Number of days from admission to PR17"
 PRDAY18                 "Number of days from admission to PR18"
 PRDAY19                 "Number of days from admission to PR19"
 PRDAY20                 "Number of days from admission to PR20"
 PRDAY21                 "Number of days from admission to PR21"
 PRDAY22                 "Number of days from admission to PR22"
 PRDAY23                 "Number of days from admission to PR23"
 PRDAY24                 "Number of days from admission to PR24"
 PRDAY25                 "Number of days from admission to PR25"
 PRDAY26                 "Number of days from admission to PR26"
 PRDAY27                 "Number of days from admission to PR27"
 PRDAY28                 "Number of days from admission to PR28"
 PRDAY29                 "Number of days from admission to PR29"
 PRDAY30                 "Number of days from admission to PR30"
 PRDAY31                 "Number of days from admission to PR31"
 PRDAY32                 "Number of days from admission to PR32"
 PRDAY33                 "Number of days from admission to PR33"
 PRDAY34                 "Number of days from admission to PR34"
 PRDAY35                 "Number of days from admission to PR35"
 PRDAY36                 "Number of days from admission to PR36"
 PRDAY37                 "Number of days from admission to PR37"
 PRDAY38                 "Number of days from admission to PR38"
 PRDAY39                 "Number of days from admission to PR39"
 PRDAY40                 "Number of days from admission to PR40"
 PRDAY41                 "Number of days from admission to PR41"
 PRDAY42                 "Number of days from admission to PR42"
 PRDAY43                 "Number of days from admission to PR43"
 PRDAY44                 "Number of days from admission to PR44"
 PRDAY45                 "Number of days from admission to PR45"
 PRDAY46                 "Number of days from admission to PR46"
 PRDAY47                 "Number of days from admission to PR47"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TRAN_IN                 "Transfer in indicator"
 TRAN_OUT                "Transfer out indicator"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 HOSPID                  "HCUP hospital identification number"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRMONTH16               "Month of procedure 16"
 PRMONTH17               "Month of procedure 17"
 PRMONTH18               "Month of procedure 18"
 PRMONTH19               "Month of procedure 19"
 PRMONTH20               "Month of procedure 20"
 PRMONTH21               "Month of procedure 21"
 PRMONTH22               "Month of procedure 22"
 PRMONTH23               "Month of procedure 23"
 PRMONTH24               "Month of procedure 24"
 PRMONTH25               "Month of procedure 25"
 PRMONTH26               "Month of procedure 26"
 PRMONTH27               "Month of procedure 27"
 PRMONTH28               "Month of procedure 28"
 PRMONTH29               "Month of procedure 29"
 PRMONTH30               "Month of procedure 30"
 PRMONTH31               "Month of procedure 31"
 PRMONTH32               "Month of procedure 32"
 PRMONTH33               "Month of procedure 33"
 PRMONTH34               "Month of procedure 34"
 PRMONTH35               "Month of procedure 35"
 PRMONTH36               "Month of procedure 36"
 PRMONTH37               "Month of procedure 37"
 PRMONTH38               "Month of procedure 38"
 PRMONTH39               "Month of procedure 39"
 PRMONTH40               "Month of procedure 40"
 PRMONTH41               "Month of procedure 41"
 PRMONTH42               "Month of procedure 42"
 PRMONTH43               "Month of procedure 43"
 PRMONTH44               "Month of procedure 44"
 PRMONTH45               "Month of procedure 45"
 PRMONTH46               "Month of procedure 46"
 PRMONTH47               "Month of procedure 47"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15"
 PRYEAR16                "Year of procedure 16"
 PRYEAR17                "Year of procedure 17"
 PRYEAR18                "Year of procedure 18"
 PRYEAR19                "Year of procedure 19"
 PRYEAR20                "Year of procedure 20"
 PRYEAR21                "Year of procedure 21"
 PRYEAR22                "Year of procedure 22"
 PRYEAR23                "Year of procedure 23"
 PRYEAR24                "Year of procedure 24"
 PRYEAR25                "Year of procedure 25"
 PRYEAR26                "Year of procedure 26"
 PRYEAR27                "Year of procedure 27"
 PRYEAR28                "Year of procedure 28"
 PRYEAR29                "Year of procedure 29"
 PRYEAR30                "Year of procedure 30"
 PRYEAR31                "Year of procedure 31"
 PRYEAR32                "Year of procedure 32"
 PRYEAR33                "Year of procedure 33"
 PRYEAR34                "Year of procedure 34"
 PRYEAR35                "Year of procedure 35"
 PRYEAR36                "Year of procedure 36"
 PRYEAR37                "Year of procedure 37"
 PRYEAR38                "Year of procedure 38"
 PRYEAR39                "Year of procedure 39"
 PRYEAR40                "Year of procedure 40"
 PRYEAR41                "Year of procedure 41"
 PRYEAR42                "Year of procedure 42"
 PRYEAR43                "Year of procedure 43"
 PRYEAR44                "Year of procedure 44"
 PRYEAR45                "Year of procedure 45"
 PRYEAR46                "Year of procedure 46"
 PRYEAR47                "Year of procedure 47" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS51
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS52
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS53
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS54
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS55
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS56
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS57
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS58
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS59
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS60
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS61
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS62
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS63
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS64
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS65
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS66
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS67
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS68
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS69
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS70
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS71
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS72
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS73
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS74
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS75
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS76
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS77
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS78
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS79
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS80
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS81
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS82
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS83
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH45
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH46
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH47
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR45
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR46
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR47
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'SD_SID_2010_CORE.SAV' /COMPRESSED.
