/*******************************************************************
* Creation Date: 03/03/2015   
*   SD_SID_2013_SEVERITY.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY SEVERITY FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'SD_SID_2013_SEVERITY.ASC' FIXED SKIP=2 / 
 KEY                             1-  15
 CM_AIDS                        16-  17
 CM_ALCOHOL                     18-  19
 CM_ANEMDEF                     20-  21
 CM_ARTH                        22-  23
 CM_BLDLOSS                     24-  25
 CM_CHF                         26-  27
 CM_CHRNLUNG                    28-  29
 CM_COAG                        30-  31
 CM_DEPRESS                     32-  33
 CM_DM                          34-  35
 CM_DMCX                        36-  37
 CM_DRUG                        38-  39
 CM_HTN_C                       40-  41
 CM_HYPOTHY                     42-  43
 CM_LIVER                       44-  45
 CM_LYMPH                       46-  47
 CM_LYTES                       48-  49
 CM_METS                        50-  51
 CM_NEURO                       52-  53
 CM_OBESE                       54-  55
 CM_PARA                        56-  57
 CM_PERIVASC                    58-  59
 CM_PSYCH                       60-  61
 CM_PULMCIRC                    62-  63
 CM_RENLFAIL                    64-  65
 CM_TUMOR                       66-  67
 CM_ULCER                       68-  69
 CM_VALVE                       70-  71
 CM_WGHTLOSS                    72-  73.


***  Specify write formats  ***.
FORMATS
 KEY                          (F8.0) /
 CM_AIDS                      (F3.0) /
 CM_ALCOHOL                   (F3.0) /
 CM_ANEMDEF                   (F3.0) /
 CM_ARTH                      (F3.0) /
 CM_BLDLOSS                   (F3.0) /
 CM_CHF                       (F3.0) /
 CM_CHRNLUNG                  (F3.0) /
 CM_COAG                      (F3.0) /
 CM_DEPRESS                   (F3.0) /
 CM_DM                        (F3.0) /
 CM_DMCX                      (F3.0) /
 CM_DRUG                      (F3.0) /
 CM_HTN_C                     (F3.0) /
 CM_HYPOTHY                   (F3.0) /
 CM_LIVER                     (F3.0) /
 CM_LYMPH                     (F3.0) /
 CM_LYTES                     (F3.0) /
 CM_METS                      (F3.0) /
 CM_NEURO                     (F3.0) /
 CM_OBESE                     (F3.0) /
 CM_PARA                      (F3.0) /
 CM_PERIVASC                  (F3.0) /
 CM_PSYCH                     (F3.0) /
 CM_PULMCIRC                  (F3.0) /
 CM_RENLFAIL                  (F3.0) /
 CM_TUMOR                     (F3.0) /
 CM_ULCER                     (F3.0) /
 CM_VALVE                     (F3.0) /
 CM_WGHTLOSS                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY                          "HCUP record identifier"
 CM_AIDS
"AHRQ comorbidity measure: Acquired immune deficiency syndrome"
 CM_ALCOHOL                   "AHRQ comorbidity measure: Alcohol abuse"
 CM_ANEMDEF                   "AHRQ comorbidity measure: Deficiency anemias"
 CM_ARTH
"AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular diseases"
 CM_BLDLOSS                   "AHRQ comorbidity measure: Chronic blood loss anemia"
 CM_CHF                       "AHRQ comorbidity measure: Congestive heart failure"
 CM_CHRNLUNG                  "AHRQ comorbidity measure: Chronic pulmonary disease"
 CM_COAG                      "AHRQ comorbidity measure: Coagulopathy"
 CM_DEPRESS                   "AHRQ comorbidity measure: Depression"
 CM_DM                        "AHRQ comorbidity measure: Diabetes, uncomplicated"
 CM_DMCX
"AHRQ comorbidity measure: Diabetes with chronic complications"
 CM_DRUG                      "AHRQ comorbidity measure: Drug abuse"
 CM_HTN_C
"AHRQ comorbidity measure: Hypertension (combine uncomplicated and complicated)"
 CM_HYPOTHY                   "AHRQ comorbidity measure: Hypothyroidism"
 CM_LIVER                     "AHRQ comorbidity measure: Liver disease"
 CM_LYMPH                     "AHRQ comorbidity measure: Lymphoma"
 CM_LYTES                     "AHRQ comorbidity measure: Fluid and electrolyte disorders"
 CM_METS                      "AHRQ comorbidity measure: Metastatic cancer"
 CM_NEURO                     "AHRQ comorbidity measure: Other neurological disorders"
 CM_OBESE                     "AHRQ comorbidity measure: Obesity"
 CM_PARA                      "AHRQ comorbidity measure: Paralysis"
 CM_PERIVASC                  "AHRQ comorbidity measure: Peripheral vascular disorders"
 CM_PSYCH                     "AHRQ comorbidity measure: Psychoses"
 CM_PULMCIRC                  "AHRQ comorbidity measure: Pulmonary circulation disorders"
 CM_RENLFAIL                  "AHRQ comorbidity measure: Renal failure"
 CM_TUMOR                     "AHRQ comorbidity measure: Solid tumor without metastasis"
 CM_ULCER
"AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding"
 CM_VALVE                     "AHRQ comorbidity measure: Valvular disease"
 CM_WGHTLOSS                  "AHRQ comorbidity measure: Weight loss" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CM_AIDS
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ALCOHOL
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ANEMDEF
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ARTH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_BLDLOSS
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_CHF
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_CHRNLUNG
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_COAG
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DEPRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DM
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DMCX
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_DRUG
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_HTN_C
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_HYPOTHY
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LIVER
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LYMPH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_LYTES
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_METS
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_NEURO
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_OBESE
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PARA
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PERIVASC
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PSYCH
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_PULMCIRC
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_RENLFAIL
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_TUMOR
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_ULCER
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_VALVE
 (-9,-8,-6,-5=SYSMIS).
RECODE CM_WGHTLOSS
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'SD_SID_2013_SEVERITY.SAV' /COMPRESSED.
