/*******************************************************************
* Creation Date: 11/17/2016   
*   UT_SID_2014_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'UT_SID_2014_CHGS.ASC' FIXED SKIP=2 / 
 CHG1                            1-  12
 CHG2                           13-  24
 CHG3                           25-  36
 CHG4                           37-  48
 KEY                            49-  63.


***  Specify write formats  ***.
FORMATS
 CHG1                         (F6.2) /
 CHG2                         (F6.2) /
 CHG3                         (F6.2) /
 CHG4                         (F6.2) /
 KEY                          (F8.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHG1                         "Detailed charges 1 (as received from source)"
 CHG2                         "Detailed charges 2 (as received from source)"
 CHG3                         "Detailed charges 3 (as received from source)"
 CHG4                         "Detailed charges 4 (as received from source)"
 KEY                          "HCUP record identifier" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG4
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).



SAVE OUTFILE = 'UT_SID_2014_CHGS.SAV' /COMPRESSED.
