/*******************************************************************
* Creation Date: 05/05/2025   
*   UT_SID_2023_DX_PR_GRPS.sps:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      SID DX_PR_GRPS FILE INTO SPSS                                    
*******************************************************************/


/***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************/


/********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************/

DATA LIST FILE = 'UT_SID_2023_DX_PR_GRPS.asc' FIXED SKIP=2 / 
 CCIR_VERSION                    1-   6 (A)
 CCIR1                           7-   9
 CCIR2                          10-  12
 CCIR3                          13-  15
 CCIR4                          16-  18
 CCIR5                          19-  21
 CCIR6                          22-  24
 CCIR7                          25-  27
 CCIR8                          28-  30
 CCIR9                          31-  33
 CCIR10                         34-  36
 CCIR11                         37-  39
 CCIR12                         40-  42
 CCIR13                         43-  45
 CCIR14                         46-  48
 CCIR15                         49-  51
 CCIR16                         52-  54
 CCIR17                         55-  57
 CCIR18                         58-  60
 CCIR19                         61-  63
 CCIR20                         64-  66
 CMR_AIDS                       67-  68
 CMR_ALCOHOL                    69-  70
 CMR_ANEMDEF                    71-  72
 CMR_AUTOIMMUNE                 73-  74
 CMR_BLDLOSS                    75-  76
 CMR_CANCER_LEUK                77-  78
 CMR_CANCER_LYMPH               79-  80
 CMR_CANCER_METS                81-  82
 CMR_CANCER_NSITU               83-  84
 CMR_CANCER_SOLID               85-  86
 CMR_CBVD                       87-  88
 CMR_COAG                       89-  90
 CMR_DEMENTIA                   91-  92
 CMR_DEPRESS                    93-  94
 CMR_DIAB_CX                    95-  96
 CMR_DIAB_UNCX                  97-  98
 CMR_DRUG_ABUSE                 99- 100
 CMR_HF                        101- 102
 CMR_HTN_CX                    103- 104
 CMR_HTN_UNCX                  105- 106
 CMR_LIVER_MLD                 107- 108
 CMR_LIVER_SEV                 109- 110
 CMR_LUNG_CHRONIC              111- 112
 CMR_NEURO_MOVT                113- 114
 CMR_NEURO_OTH                 115- 116
 CMR_NEURO_SEIZ                117- 118
 CMR_OBESE                     119- 120
 CMR_PARALYSIS                 121- 122
 CMR_PERIVASC                  123- 124
 CMR_PSYCHOSES                 125- 126
 CMR_PULMCIRC                  127- 128
 CMR_RENLFL_MOD                129- 130
 CMR_RENLFL_SEV                131- 132
 CMR_THYROID_HYPO              133- 134
 CMR_THYROID_OTH               135- 136
 CMR_ULCER_PEPTIC              137- 138
 CMR_VALVE                     139- 140
 CMR_VERSION                   141- 146 (A)
 CMR_WGHTLOSS                  147- 148
 I10_INJURY                    149- 150
 I10_INJURY_CUT                151- 152
 I10_INJURY_DROWN              153- 154
 I10_INJURY_FALL               155- 156
 I10_INJURY_FIRE               157- 158
 I10_INJURY_FIREARM            159- 160
 I10_INJURY_MACHINERY          161- 162
 I10_INJURY_MVT                163- 164
 I10_INJURY_NATURE             165- 166
 I10_INJURY_OVEREXERTION       167- 168
 I10_INJURY_POISON             169- 170
 I10_INJURY_STRUCK             171- 172
 I10_INJURY_SUFFOCATION        173- 174
 I10_INTENT_ASSAULT            175- 176
 I10_INTENT_SELF_HARM          177- 178
 I10_INTENT_UNINTENTIONAL      179- 180
 I10_MULTINJURY                181- 182
 KEY                           183- 197
 PCLASS_VERSION                198- 203 (A)
 PCLASS1                       204- 205
 PCLASS2                       206- 207
 PCLASS3                       208- 209
 PCLASS4                       210- 211
 PCLASS5                       212- 213
 PCLASS6                       214- 215
 DXCCSR_Default_DX1            216- 221 (A)
 DXCCSR_BLD001                 222- 224
 DXCCSR_BLD002                 225- 227
 DXCCSR_BLD003                 228- 230
 DXCCSR_BLD004                 231- 233
 DXCCSR_BLD005                 234- 236
 DXCCSR_BLD006                 237- 239
 DXCCSR_BLD007                 240- 242
 DXCCSR_BLD008                 243- 245
 DXCCSR_BLD009                 246- 248
 DXCCSR_BLD010                 249- 251
 DXCCSR_CIR001                 252- 254
 DXCCSR_CIR002                 255- 257
 DXCCSR_CIR003                 258- 260
 DXCCSR_CIR004                 261- 263
 DXCCSR_CIR005                 264- 266
 DXCCSR_CIR006                 267- 269
 DXCCSR_CIR007                 270- 272
 DXCCSR_CIR008                 273- 275
 DXCCSR_CIR009                 276- 278
 DXCCSR_CIR010                 279- 281
 DXCCSR_CIR011                 282- 284
 DXCCSR_CIR012                 285- 287
 DXCCSR_CIR013                 288- 290
 DXCCSR_CIR014                 291- 293
 DXCCSR_CIR015                 294- 296
 DXCCSR_CIR016                 297- 299
 DXCCSR_CIR017                 300- 302
 DXCCSR_CIR018                 303- 305
 DXCCSR_CIR019                 306- 308
 DXCCSR_CIR020                 309- 311
 DXCCSR_CIR021                 312- 314
 DXCCSR_CIR022                 315- 317
 DXCCSR_CIR023                 318- 320
 DXCCSR_CIR024                 321- 323
 DXCCSR_CIR025                 324- 326
 DXCCSR_CIR026                 327- 329
 DXCCSR_CIR027                 330- 332
 DXCCSR_CIR028                 333- 335
 DXCCSR_CIR029                 336- 338
 DXCCSR_CIR030                 339- 341
 DXCCSR_CIR031                 342- 344
 DXCCSR_CIR032                 345- 347
 DXCCSR_CIR033                 348- 350
 DXCCSR_CIR034                 351- 353
 DXCCSR_CIR035                 354- 356
 DXCCSR_CIR036                 357- 359
 DXCCSR_CIR037                 360- 362
 DXCCSR_CIR038                 363- 365
 DXCCSR_CIR039                 366- 368
 DXCCSR_DEN001                 369- 371
 DXCCSR_DEN002                 372- 374
 DXCCSR_DEN003                 375- 377
 DXCCSR_DIG001                 378- 380
 DXCCSR_DIG002                 381- 383
 DXCCSR_DIG003                 384- 386
 DXCCSR_DIG004                 387- 389
 DXCCSR_DIG005                 390- 392
 DXCCSR_DIG006                 393- 395
 DXCCSR_DIG007                 396- 398
 DXCCSR_DIG008                 399- 401
 DXCCSR_DIG009                 402- 404
 DXCCSR_DIG010                 405- 407
 DXCCSR_DIG011                 408- 410
 DXCCSR_DIG012                 411- 413
 DXCCSR_DIG013                 414- 416
 DXCCSR_DIG014                 417- 419
 DXCCSR_DIG015                 420- 422
 DXCCSR_DIG016                 423- 425
 DXCCSR_DIG017                 426- 428
 DXCCSR_DIG018                 429- 431
 DXCCSR_DIG019                 432- 434
 DXCCSR_DIG020                 435- 437
 DXCCSR_DIG021                 438- 440
 DXCCSR_DIG022                 441- 443
 DXCCSR_DIG023                 444- 446
 DXCCSR_DIG024                 447- 449
 DXCCSR_DIG025                 450- 452
 DXCCSR_EAR001                 453- 455
 DXCCSR_EAR002                 456- 458
 DXCCSR_EAR003                 459- 461
 DXCCSR_EAR004                 462- 464
 DXCCSR_EAR005                 465- 467
 DXCCSR_EAR006                 468- 470
 DXCCSR_END001                 471- 473
 DXCCSR_END002                 474- 476
 DXCCSR_END003                 477- 479
 DXCCSR_END004                 480- 482
 DXCCSR_END005                 483- 485
 DXCCSR_END006                 486- 488
 DXCCSR_END007                 489- 491
 DXCCSR_END008                 492- 494
 DXCCSR_END009                 495- 497
 DXCCSR_END010                 498- 500
 DXCCSR_END011                 501- 503
 DXCCSR_END012                 504- 506
 DXCCSR_END013                 507- 509
 DXCCSR_END014                 510- 512
 DXCCSR_END015                 513- 515
 DXCCSR_END016                 516- 518
 DXCCSR_END017                 519- 521
 DXCCSR_EXT001                 522- 524
 DXCCSR_EXT002                 525- 527
 DXCCSR_EXT003                 528- 530
 DXCCSR_EXT004                 531- 533
 DXCCSR_EXT005                 534- 536
 DXCCSR_EXT006                 537- 539
 DXCCSR_EXT007                 540- 542
 DXCCSR_EXT008                 543- 545
 DXCCSR_EXT009                 546- 548
 DXCCSR_EXT010                 549- 551
 DXCCSR_EXT011                 552- 554
 DXCCSR_EXT012                 555- 557
 DXCCSR_EXT013                 558- 560
 DXCCSR_EXT014                 561- 563
 DXCCSR_EXT015                 564- 566
 DXCCSR_EXT016                 567- 569
 DXCCSR_EXT017                 570- 572
 DXCCSR_EXT018                 573- 575
 DXCCSR_EXT019                 576- 578
 DXCCSR_EXT020                 579- 581
 DXCCSR_EXT021                 582- 584
 DXCCSR_EXT022                 585- 587
 DXCCSR_EXT023                 588- 590
 DXCCSR_EXT024                 591- 593
 DXCCSR_EXT025                 594- 596
 DXCCSR_EXT026                 597- 599
 DXCCSR_EXT027                 600- 602
 DXCCSR_EXT028                 603- 605
 DXCCSR_EXT029                 606- 608
 DXCCSR_EXT030                 609- 611
 DXCCSR_EYE001                 612- 614
 DXCCSR_EYE002                 615- 617
 DXCCSR_EYE003                 618- 620
 DXCCSR_EYE004                 621- 623
 DXCCSR_EYE005                 624- 626
 DXCCSR_EYE006                 627- 629
 DXCCSR_EYE007                 630- 632
 DXCCSR_EYE008                 633- 635
 DXCCSR_EYE009                 636- 638
 DXCCSR_EYE010                 639- 641
 DXCCSR_EYE011                 642- 644
 DXCCSR_EYE012                 645- 647
 DXCCSR_FAC001                 648- 650
 DXCCSR_FAC002                 651- 653
 DXCCSR_FAC003                 654- 656
 DXCCSR_FAC004                 657- 659
 DXCCSR_FAC005                 660- 662
 DXCCSR_FAC006                 663- 665
 DXCCSR_FAC007                 666- 668
 DXCCSR_FAC008                 669- 671
 DXCCSR_FAC009                 672- 674
 DXCCSR_FAC010                 675- 677
 DXCCSR_FAC011                 678- 680
 DXCCSR_FAC012                 681- 683
 DXCCSR_FAC013                 684- 686
 DXCCSR_FAC014                 687- 689
 DXCCSR_FAC015                 690- 692
 DXCCSR_FAC016                 693- 695
 DXCCSR_FAC017                 696- 698
 DXCCSR_FAC018                 699- 701
 DXCCSR_FAC019                 702- 704
 DXCCSR_FAC020                 705- 707
 DXCCSR_FAC021                 708- 710
 DXCCSR_FAC022                 711- 713
 DXCCSR_FAC023                 714- 716
 DXCCSR_FAC024                 717- 719
 DXCCSR_FAC025                 720- 722
 DXCCSR_GEN001                 723- 725
 DXCCSR_GEN002                 726- 728
 DXCCSR_GEN003                 729- 731
 DXCCSR_GEN004                 732- 734
 DXCCSR_GEN005                 735- 737
 DXCCSR_GEN006                 738- 740
 DXCCSR_GEN007                 741- 743
 DXCCSR_GEN008                 744- 746
 DXCCSR_GEN009                 747- 749
 DXCCSR_GEN010                 750- 752
 DXCCSR_GEN011                 753- 755
 DXCCSR_GEN012                 756- 758
 DXCCSR_GEN013                 759- 761
 DXCCSR_GEN014                 762- 764
 DXCCSR_GEN015                 765- 767
 DXCCSR_GEN016                 768- 770
 DXCCSR_GEN017                 771- 773
 DXCCSR_GEN018                 774- 776
 DXCCSR_GEN019                 777- 779
 DXCCSR_GEN020                 780- 782
 DXCCSR_GEN021                 783- 785
 DXCCSR_GEN022                 786- 788
 DXCCSR_GEN023                 789- 791
 DXCCSR_GEN024                 792- 794
 DXCCSR_GEN025                 795- 797
 DXCCSR_GEN026                 798- 800
 DXCCSR_INF001                 801- 803
 DXCCSR_INF002                 804- 806
 DXCCSR_INF003                 807- 809
 DXCCSR_INF004                 810- 812
 DXCCSR_INF005                 813- 815
 DXCCSR_INF006                 816- 818
 DXCCSR_INF007                 819- 821
 DXCCSR_INF008                 822- 824
 DXCCSR_INF009                 825- 827
 DXCCSR_INF010                 828- 830
 DXCCSR_INF011                 831- 833
 DXCCSR_INF012                 834- 836
 DXCCSR_INJ001                 837- 839
 DXCCSR_INJ002                 840- 842
 DXCCSR_INJ003                 843- 845
 DXCCSR_INJ004                 846- 848
 DXCCSR_INJ005                 849- 851
 DXCCSR_INJ006                 852- 854
 DXCCSR_INJ007                 855- 857
 DXCCSR_INJ008                 858- 860
 DXCCSR_INJ009                 861- 863
 DXCCSR_INJ010                 864- 866
 DXCCSR_INJ011                 867- 869
 DXCCSR_INJ012                 870- 872
 DXCCSR_INJ013                 873- 875
 DXCCSR_INJ014                 876- 878
 DXCCSR_INJ015                 879- 881
 DXCCSR_INJ016                 882- 884
 DXCCSR_INJ017                 885- 887
 DXCCSR_INJ018                 888- 890
 DXCCSR_INJ019                 891- 893
 DXCCSR_INJ020                 894- 896
 DXCCSR_INJ021                 897- 899
 DXCCSR_INJ022                 900- 902
 DXCCSR_INJ023                 903- 905
 DXCCSR_INJ024                 906- 908
 DXCCSR_INJ025                 909- 911
 DXCCSR_INJ026                 912- 914
 DXCCSR_INJ027                 915- 917
 DXCCSR_INJ028                 918- 920
 DXCCSR_INJ029                 921- 923
 DXCCSR_INJ030                 924- 926
 DXCCSR_INJ031                 927- 929
 DXCCSR_INJ032                 930- 932
 DXCCSR_INJ033                 933- 935
 DXCCSR_INJ034                 936- 938
 DXCCSR_INJ035                 939- 941
 DXCCSR_INJ036                 942- 944
 DXCCSR_INJ037                 945- 947
 DXCCSR_INJ038                 948- 950
 DXCCSR_INJ039                 951- 953
 DXCCSR_INJ040                 954- 956
 DXCCSR_INJ041                 957- 959
 DXCCSR_INJ042                 960- 962
 DXCCSR_INJ043                 963- 965
 DXCCSR_INJ044                 966- 968
 DXCCSR_INJ045                 969- 971
 DXCCSR_INJ046                 972- 974
 DXCCSR_INJ047                 975- 977
 DXCCSR_INJ048                 978- 980
 DXCCSR_INJ049                 981- 983
 DXCCSR_INJ050                 984- 986
 DXCCSR_INJ051                 987- 989
 DXCCSR_INJ052                 990- 992
 DXCCSR_INJ053                 993- 995
 DXCCSR_INJ054                 996- 998
 DXCCSR_INJ055                 999-1001
 DXCCSR_INJ056                1002-1004
 DXCCSR_INJ057                1005-1007
 DXCCSR_INJ058                1008-1010
 DXCCSR_INJ059                1011-1013
 DXCCSR_INJ060                1014-1016
 DXCCSR_INJ061                1017-1019
 DXCCSR_INJ062                1020-1022
 DXCCSR_INJ063                1023-1025
 DXCCSR_INJ064                1026-1028
 DXCCSR_INJ065                1029-1031
 DXCCSR_INJ066                1032-1034
 DXCCSR_INJ067                1035-1037
 DXCCSR_INJ068                1038-1040
 DXCCSR_INJ069                1041-1043
 DXCCSR_INJ070                1044-1046
 DXCCSR_INJ071                1047-1049
 DXCCSR_INJ072                1050-1052
 DXCCSR_INJ073                1053-1055
 DXCCSR_INJ074                1056-1058
 DXCCSR_INJ075                1059-1061
 DXCCSR_INJ076                1062-1064
 DXCCSR_MAL001                1065-1067
 DXCCSR_MAL002                1068-1070
 DXCCSR_MAL003                1071-1073
 DXCCSR_MAL004                1074-1076
 DXCCSR_MAL005                1077-1079
 DXCCSR_MAL006                1080-1082
 DXCCSR_MAL007                1083-1085
 DXCCSR_MAL008                1086-1088
 DXCCSR_MAL009                1089-1091
 DXCCSR_MAL010                1092-1094
 DXCCSR_MBD001                1095-1097
 DXCCSR_MBD002                1098-1100
 DXCCSR_MBD003                1101-1103
 DXCCSR_MBD004                1104-1106
 DXCCSR_MBD005                1107-1109
 DXCCSR_MBD006                1110-1112
 DXCCSR_MBD007                1113-1115
 DXCCSR_MBD008                1116-1118
 DXCCSR_MBD009                1119-1121
 DXCCSR_MBD010                1122-1124
 DXCCSR_MBD011                1125-1127
 DXCCSR_MBD012                1128-1130
 DXCCSR_MBD013                1131-1133
 DXCCSR_MBD014                1134-1136
 DXCCSR_MBD017                1137-1139
 DXCCSR_MBD018                1140-1142
 DXCCSR_MBD019                1143-1145
 DXCCSR_MBD020                1146-1148
 DXCCSR_MBD021                1149-1151
 DXCCSR_MBD022                1152-1154
 DXCCSR_MBD023                1155-1157
 DXCCSR_MBD024                1158-1160
 DXCCSR_MBD025                1161-1163
 DXCCSR_MBD026                1164-1166
 DXCCSR_MBD027                1167-1169
 DXCCSR_MBD028                1170-1172
 DXCCSR_MBD029                1173-1175
 DXCCSR_MBD030                1176-1178
 DXCCSR_MBD031                1179-1181
 DXCCSR_MBD032                1182-1184
 DXCCSR_MBD033                1185-1187
 DXCCSR_MBD034                1188-1190
 DXCCSR_MUS001                1191-1193
 DXCCSR_MUS002                1194-1196
 DXCCSR_MUS003                1197-1199
 DXCCSR_MUS004                1200-1202
 DXCCSR_MUS005                1203-1205
 DXCCSR_MUS006                1206-1208
 DXCCSR_MUS007                1209-1211
 DXCCSR_MUS008                1212-1214
 DXCCSR_MUS009                1215-1217
 DXCCSR_MUS010                1218-1220
 DXCCSR_MUS011                1221-1223
 DXCCSR_MUS012                1224-1226
 DXCCSR_MUS013                1227-1229
 DXCCSR_MUS014                1230-1232
 DXCCSR_MUS015                1233-1235
 DXCCSR_MUS016                1236-1238
 DXCCSR_MUS017                1239-1241
 DXCCSR_MUS018                1242-1244
 DXCCSR_MUS019                1245-1247
 DXCCSR_MUS020                1248-1250
 DXCCSR_MUS021                1251-1253
 DXCCSR_MUS022                1254-1256
 DXCCSR_MUS023                1257-1259
 DXCCSR_MUS024                1260-1262
 DXCCSR_MUS025                1263-1265
 DXCCSR_MUS026                1266-1268
 DXCCSR_MUS027                1269-1271
 DXCCSR_MUS028                1272-1274
 DXCCSR_MUS029                1275-1277
 DXCCSR_MUS030                1278-1280
 DXCCSR_MUS031                1281-1283
 DXCCSR_MUS032                1284-1286
 DXCCSR_MUS033                1287-1289
 DXCCSR_MUS034                1290-1292
 DXCCSR_MUS035                1293-1295
 DXCCSR_MUS036                1296-1298
 DXCCSR_MUS037                1299-1301
 DXCCSR_MUS038                1302-1304
 DXCCSR_NEO001                1305-1307
 DXCCSR_NEO002                1308-1310
 DXCCSR_NEO003                1311-1313
 DXCCSR_NEO004                1314-1316
 DXCCSR_NEO005                1317-1319
 DXCCSR_NEO006                1320-1322
 DXCCSR_NEO007                1323-1325
 DXCCSR_NEO008                1326-1328
 DXCCSR_NEO009                1329-1331
 DXCCSR_NEO010                1332-1334
 DXCCSR_NEO011                1335-1337
 DXCCSR_NEO012                1338-1340
 DXCCSR_NEO013                1341-1343
 DXCCSR_NEO014                1344-1346
 DXCCSR_NEO015                1347-1349
 DXCCSR_NEO016                1350-1352
 DXCCSR_NEO017                1353-1355
 DXCCSR_NEO018                1356-1358
 DXCCSR_NEO019                1359-1361
 DXCCSR_NEO020                1362-1364
 DXCCSR_NEO021                1365-1367
 DXCCSR_NEO022                1368-1370
 DXCCSR_NEO023                1371-1373
 DXCCSR_NEO024                1374-1376
 DXCCSR_NEO025                1377-1379
 DXCCSR_NEO026                1380-1382
 DXCCSR_NEO027                1383-1385
 DXCCSR_NEO028                1386-1388
 DXCCSR_NEO029                1389-1391
 DXCCSR_NEO030                1392-1394
 DXCCSR_NEO031                1395-1397
 DXCCSR_NEO032                1398-1400
 DXCCSR_NEO033                1401-1403
 DXCCSR_NEO034                1404-1406
 DXCCSR_NEO035                1407-1409
 DXCCSR_NEO036                1410-1412
 DXCCSR_NEO037                1413-1415
 DXCCSR_NEO038                1416-1418
 DXCCSR_NEO039                1419-1421
 DXCCSR_NEO040                1422-1424
 DXCCSR_NEO041                1425-1427
 DXCCSR_NEO042                1428-1430
 DXCCSR_NEO043                1431-1433
 DXCCSR_NEO044                1434-1436
 DXCCSR_NEO045                1437-1439
 DXCCSR_NEO046                1440-1442
 DXCCSR_NEO047                1443-1445
 DXCCSR_NEO048                1446-1448
 DXCCSR_NEO049                1449-1451
 DXCCSR_NEO050                1452-1454
 DXCCSR_NEO051                1455-1457
 DXCCSR_NEO052                1458-1460
 DXCCSR_NEO053                1461-1463
 DXCCSR_NEO054                1464-1466
 DXCCSR_NEO055                1467-1469
 DXCCSR_NEO056                1470-1472
 DXCCSR_NEO057                1473-1475
 DXCCSR_NEO058                1476-1478
 DXCCSR_NEO059                1479-1481
 DXCCSR_NEO060                1482-1484
 DXCCSR_NEO061                1485-1487
 DXCCSR_NEO062                1488-1490
 DXCCSR_NEO063                1491-1493
 DXCCSR_NEO064                1494-1496
 DXCCSR_NEO065                1497-1499
 DXCCSR_NEO066                1500-1502
 DXCCSR_NEO067                1503-1505
 DXCCSR_NEO068                1506-1508
 DXCCSR_NEO069                1509-1511
 DXCCSR_NEO070                1512-1514
 DXCCSR_NEO071                1515-1517
 DXCCSR_NEO072                1518-1520
 DXCCSR_NEO073                1521-1523
 DXCCSR_NEO074                1524-1526
 DXCCSR_NVS001                1527-1529
 DXCCSR_NVS002                1530-1532
 DXCCSR_NVS003                1533-1535
 DXCCSR_NVS004                1536-1538
 DXCCSR_NVS005                1539-1541
 DXCCSR_NVS006                1542-1544
 DXCCSR_NVS007                1545-1547
 DXCCSR_NVS008                1548-1550
 DXCCSR_NVS009                1551-1553
 DXCCSR_NVS010                1554-1556
 DXCCSR_NVS011                1557-1559
 DXCCSR_NVS012                1560-1562
 DXCCSR_NVS013                1563-1565
 DXCCSR_NVS014                1566-1568
 DXCCSR_NVS015                1569-1571
 DXCCSR_NVS016                1572-1574
 DXCCSR_NVS017                1575-1577
 DXCCSR_NVS018                1578-1580
 DXCCSR_NVS019                1581-1583
 DXCCSR_NVS020                1584-1586
 DXCCSR_NVS021                1587-1589
 DXCCSR_NVS022                1590-1592
 DXCCSR_PNL001                1593-1595
 DXCCSR_PNL002                1596-1598
 DXCCSR_PNL003                1599-1601
 DXCCSR_PNL004                1602-1604
 DXCCSR_PNL005                1605-1607
 DXCCSR_PNL006                1608-1610
 DXCCSR_PNL007                1611-1613
 DXCCSR_PNL008                1614-1616
 DXCCSR_PNL009                1617-1619
 DXCCSR_PNL010                1620-1622
 DXCCSR_PNL011                1623-1625
 DXCCSR_PNL012                1626-1628
 DXCCSR_PNL013                1629-1631
 DXCCSR_PNL014                1632-1634
 DXCCSR_PNL015                1635-1637
 DXCCSR_PRG001                1638-1640
 DXCCSR_PRG002                1641-1643
 DXCCSR_PRG003                1644-1646
 DXCCSR_PRG004                1647-1649
 DXCCSR_PRG005                1650-1652
 DXCCSR_PRG006                1653-1655
 DXCCSR_PRG007                1656-1658
 DXCCSR_PRG008                1659-1661
 DXCCSR_PRG009                1662-1664
 DXCCSR_PRG010                1665-1667
 DXCCSR_PRG011                1668-1670
 DXCCSR_PRG012                1671-1673
 DXCCSR_PRG013                1674-1676
 DXCCSR_PRG014                1677-1679
 DXCCSR_PRG015                1680-1682
 DXCCSR_PRG016                1683-1685
 DXCCSR_PRG017                1686-1688
 DXCCSR_PRG018                1689-1691
 DXCCSR_PRG019                1692-1694
 DXCCSR_PRG020                1695-1697
 DXCCSR_PRG021                1698-1700
 DXCCSR_PRG022                1701-1703
 DXCCSR_PRG023                1704-1706
 DXCCSR_PRG024                1707-1709
 DXCCSR_PRG025                1710-1712
 DXCCSR_PRG026                1713-1715
 DXCCSR_PRG027                1716-1718
 DXCCSR_PRG028                1719-1721
 DXCCSR_PRG029                1722-1724
 DXCCSR_PRG030                1725-1727
 DXCCSR_RSP001                1728-1730
 DXCCSR_RSP002                1731-1733
 DXCCSR_RSP003                1734-1736
 DXCCSR_RSP004                1737-1739
 DXCCSR_RSP005                1740-1742
 DXCCSR_RSP006                1743-1745
 DXCCSR_RSP007                1746-1748
 DXCCSR_RSP008                1749-1751
 DXCCSR_RSP009                1752-1754
 DXCCSR_RSP010                1755-1757
 DXCCSR_RSP011                1758-1760
 DXCCSR_RSP012                1761-1763
 DXCCSR_RSP013                1764-1766
 DXCCSR_RSP014                1767-1769
 DXCCSR_RSP015                1770-1772
 DXCCSR_RSP016                1773-1775
 DXCCSR_RSP017                1776-1778
 DXCCSR_SKN001                1779-1781
 DXCCSR_SKN002                1782-1784
 DXCCSR_SKN003                1785-1787
 DXCCSR_SKN004                1788-1790
 DXCCSR_SKN005                1791-1793
 DXCCSR_SKN006                1794-1796
 DXCCSR_SKN007                1797-1799
 DXCCSR_SYM001                1800-1802
 DXCCSR_SYM002                1803-1805
 DXCCSR_SYM003                1806-1808
 DXCCSR_SYM004                1809-1811
 DXCCSR_SYM005                1812-1814
 DXCCSR_SYM006                1815-1817
 DXCCSR_SYM007                1818-1820
 DXCCSR_SYM008                1821-1823
 DXCCSR_SYM009                1824-1826
 DXCCSR_SYM010                1827-1829
 DXCCSR_SYM011                1830-1832
 DXCCSR_SYM012                1833-1835
 DXCCSR_SYM013                1836-1838
 DXCCSR_SYM014                1839-1841
 DXCCSR_SYM015                1842-1844
 DXCCSR_SYM016                1845-1847
 DXCCSR_SYM017                1848-1850
 DXCCSR_VERSION               1851-1856 (A)
 PRCCSR_ADM001                1857-1859
 PRCCSR_ADM002                1860-1862
 PRCCSR_ADM003                1863-1865
 PRCCSR_ADM004                1866-1868
 PRCCSR_ADM005                1869-1871
 PRCCSR_ADM006                1872-1874
 PRCCSR_ADM007                1875-1877
 PRCCSR_ADM008                1878-1880
 PRCCSR_ADM009                1881-1883
 PRCCSR_ADM010                1884-1886
 PRCCSR_ADM011                1887-1889
 PRCCSR_ADM012                1890-1892
 PRCCSR_ADM013                1893-1895
 PRCCSR_ADM014                1896-1898
 PRCCSR_ADM015                1899-1901
 PRCCSR_ADM016                1902-1904
 PRCCSR_ADM017                1905-1907
 PRCCSR_ADM018                1908-1910
 PRCCSR_ADM019                1911-1913
 PRCCSR_ADM020                1914-1916
 PRCCSR_ADM021                1917-1919
 PRCCSR_ADM022                1920-1922
 PRCCSR_CAR001                1923-1925
 PRCCSR_CAR002                1926-1928
 PRCCSR_CAR003                1929-1931
 PRCCSR_CAR004                1932-1934
 PRCCSR_CAR005                1935-1937
 PRCCSR_CAR006                1938-1940
 PRCCSR_CAR007                1941-1943
 PRCCSR_CAR008                1944-1946
 PRCCSR_CAR009                1947-1949
 PRCCSR_CAR010                1950-1952
 PRCCSR_CAR011                1953-1955
 PRCCSR_CAR012                1956-1958
 PRCCSR_CAR013                1959-1961
 PRCCSR_CAR014                1962-1964
 PRCCSR_CAR015                1965-1967
 PRCCSR_CAR016                1968-1970
 PRCCSR_CAR017                1971-1973
 PRCCSR_CAR018                1974-1976
 PRCCSR_CAR019                1977-1979
 PRCCSR_CAR020                1980-1982
 PRCCSR_CAR021                1983-1985
 PRCCSR_CAR022                1986-1988
 PRCCSR_CAR023                1989-1991
 PRCCSR_CAR024                1992-1994
 PRCCSR_CAR025                1995-1997
 PRCCSR_CAR026                1998-2000
 PRCCSR_CAR027                2001-2003
 PRCCSR_CAR028                2004-2006
 PRCCSR_CAR029                2007-2009
 PRCCSR_CHP001                2010-2012
 PRCCSR_CNS001                2013-2015
 PRCCSR_CNS002                2016-2018
 PRCCSR_CNS003                2019-2021
 PRCCSR_CNS004                2022-2024
 PRCCSR_CNS005                2025-2027
 PRCCSR_CNS006                2028-2030
 PRCCSR_CNS007                2031-2033
 PRCCSR_CNS008                2034-2036
 PRCCSR_CNS009                2037-2039
 PRCCSR_CNS010                2040-2042
 PRCCSR_CNS011                2043-2045
 PRCCSR_CNS012                2046-2048
 PRCCSR_CNS013                2049-2051
 PRCCSR_CNS014                2052-2054
 PRCCSR_ENP001                2055-2057
 PRCCSR_ENP002                2058-2060
 PRCCSR_ENP003                2061-2063
 PRCCSR_ENP004                2064-2066
 PRCCSR_ENP005                2067-2069
 PRCCSR_ENP006                2070-2072
 PRCCSR_ENT001                2073-2075
 PRCCSR_ENT002                2076-2078
 PRCCSR_ENT003                2079-2081
 PRCCSR_ENT004                2082-2084
 PRCCSR_ENT005                2085-2087
 PRCCSR_ENT006                2088-2090
 PRCCSR_ENT007                2091-2093
 PRCCSR_ENT008                2094-2096
 PRCCSR_ENT009                2097-2099
 PRCCSR_ENT010                2100-2102
 PRCCSR_ENT011                2103-2105
 PRCCSR_ENT012                2106-2108
 PRCCSR_ENT013                2109-2111
 PRCCSR_ENT014                2112-2114
 PRCCSR_ENT015                2115-2117
 PRCCSR_ENT016                2118-2120
 PRCCSR_ENT017                2121-2123
 PRCCSR_ESA001                2124-2126
 PRCCSR_ESA002                2127-2129
 PRCCSR_ESA003                2130-2132
 PRCCSR_ESA004                2133-2135
 PRCCSR_ESA005                2136-2138
 PRCCSR_ESA006                2139-2141
 PRCCSR_ESA007                2142-2144
 PRCCSR_ESA008                2145-2147
 PRCCSR_ESA009                2148-2150
 PRCCSR_ESA010                2151-2153
 PRCCSR_ESA011                2154-2156
 PRCCSR_EST001                2157-2159
 PRCCSR_EST002                2160-2162
 PRCCSR_EST003                2163-2165
 PRCCSR_EST004                2166-2168
 PRCCSR_EST005                2169-2171
 PRCCSR_EYP001                2172-2174
 PRCCSR_EYP002                2175-2177
 PRCCSR_FRS001                2178-2180
 PRCCSR_FRS002                2181-2183
 PRCCSR_FRS003                2184-2186
 PRCCSR_FRS004                2187-2189
 PRCCSR_FRS005                2190-2192
 PRCCSR_FRS006                2193-2195
 PRCCSR_FRS007                2196-2198
 PRCCSR_FRS008                2199-2201
 PRCCSR_FRS009                2202-2204
 PRCCSR_FRS010                2205-2207
 PRCCSR_FRS011                2208-2210
 PRCCSR_FRS012                2211-2213
 PRCCSR_FRS013                2214-2216
 PRCCSR_FRS014                2217-2219
 PRCCSR_FRS015                2220-2222
 PRCCSR_GIS001                2223-2225
 PRCCSR_GIS002                2226-2228
 PRCCSR_GIS003                2229-2231
 PRCCSR_GIS004                2232-2234
 PRCCSR_GIS005                2235-2237
 PRCCSR_GIS006                2238-2240
 PRCCSR_GIS007                2241-2243
 PRCCSR_GIS008                2244-2246
 PRCCSR_GIS009                2247-2249
 PRCCSR_GIS010                2250-2252
 PRCCSR_GIS011                2253-2255
 PRCCSR_GIS012                2256-2258
 PRCCSR_GIS013                2259-2261
 PRCCSR_GIS014                2262-2264
 PRCCSR_GIS015                2265-2267
 PRCCSR_GIS016                2268-2270
 PRCCSR_GIS017                2271-2273
 PRCCSR_GIS018                2274-2276
 PRCCSR_GIS019                2277-2279
 PRCCSR_GIS020                2280-2282
 PRCCSR_GIS021                2283-2285
 PRCCSR_GIS022                2286-2288
 PRCCSR_GIS023                2289-2291
 PRCCSR_GIS024                2292-2294
 PRCCSR_GIS025                2295-2297
 PRCCSR_GIS026                2298-2300
 PRCCSR_GIS027                2301-2303
 PRCCSR_GIS028                2304-2306
 PRCCSR_GIS029                2307-2309
 PRCCSR_GNR001                2310-2312
 PRCCSR_GNR002                2313-2315
 PRCCSR_GNR003                2316-2318
 PRCCSR_GNR004                2319-2321
 PRCCSR_GNR005                2322-2324
 PRCCSR_GNR006                2325-2327
 PRCCSR_GNR007                2328-2330
 PRCCSR_GNR008                2331-2333
 PRCCSR_GNR009                2334-2336
 PRCCSR_GNR010                2337-2339
 PRCCSR_HEP001                2340-2342
 PRCCSR_HEP002                2343-2345
 PRCCSR_HEP003                2346-2348
 PRCCSR_HEP004                2349-2351
 PRCCSR_HEP005                2352-2354
 PRCCSR_HEP006                2355-2357
 PRCCSR_HEP007                2358-2360
 PRCCSR_HEP008                2361-2363
 PRCCSR_HEP009                2364-2366
 PRCCSR_HEP010                2367-2369
 PRCCSR_HEP011                2370-2372
 PRCCSR_HEP012                2373-2375
 PRCCSR_HEP013                2376-2378
 PRCCSR_IMG001                2379-2381
 PRCCSR_IMG002                2382-2384
 PRCCSR_IMG003                2385-2387
 PRCCSR_IMG004                2388-2390
 PRCCSR_IMG005                2391-2393
 PRCCSR_IMG006                2394-2396
 PRCCSR_IMG007                2397-2399
 PRCCSR_IMG008                2400-2402
 PRCCSR_IMG009                2403-2405
 PRCCSR_IMG010                2406-2408
 PRCCSR_LYM001                2409-2411
 PRCCSR_LYM002                2412-2414
 PRCCSR_LYM003                2415-2417
 PRCCSR_LYM004                2418-2420
 PRCCSR_LYM005                2421-2423
 PRCCSR_LYM006                2424-2426
 PRCCSR_LYM007                2427-2429
 PRCCSR_LYM008                2430-2432
 PRCCSR_LYM009                2433-2435
 PRCCSR_LYM010                2436-2438
 PRCCSR_LYM011                2439-2441
 PRCCSR_MAM001                2442-2444
 PRCCSR_MAM002                2445-2447
 PRCCSR_MAM003                2448-2450
 PRCCSR_MAM004                2451-2453
 PRCCSR_MAM005                2454-2456
 PRCCSR_MAM006                2457-2459
 PRCCSR_MAM007                2460-2462
 PRCCSR_MAM008                2463-2465
 PRCCSR_MAM009                2466-2468
 PRCCSR_MAM010                2469-2471
 PRCCSR_MAM011                2472-2474
 PRCCSR_MAM012                2475-2477
 PRCCSR_MAM013                2478-2480
 PRCCSR_MAM014                2481-2483
 PRCCSR_MAM015                2484-2486
 PRCCSR_MHT001                2487-2489
 PRCCSR_MHT002                2490-2492
 PRCCSR_MHT003                2493-2495
 PRCCSR_MHT004                2496-2498
 PRCCSR_MHT005                2499-2501
 PRCCSR_MRS001                2502-2504
 PRCCSR_MRS002                2505-2507
 PRCCSR_MRS003                2508-2510
 PRCCSR_MRS004                2511-2513
 PRCCSR_MRS005                2514-2516
 PRCCSR_MRS006                2517-2519
 PRCCSR_MRS007                2520-2522
 PRCCSR_MST001                2523-2525
 PRCCSR_MST002                2526-2528
 PRCCSR_MST003                2529-2531
 PRCCSR_MST004                2532-2534
 PRCCSR_MST005                2535-2537
 PRCCSR_MST006                2538-2540
 PRCCSR_MST007                2541-2543
 PRCCSR_MST008                2544-2546
 PRCCSR_MST009                2547-2549
 PRCCSR_MST010                2550-2552
 PRCCSR_MST011                2553-2555
 PRCCSR_MST012                2556-2558
 PRCCSR_MST013                2559-2561
 PRCCSR_MST014                2562-2564
 PRCCSR_MST015                2565-2567
 PRCCSR_MST016                2568-2570
 PRCCSR_MST017                2571-2573
 PRCCSR_MST018                2574-2576
 PRCCSR_MST019                2577-2579
 PRCCSR_MST020                2580-2582
 PRCCSR_MST021                2583-2585
 PRCCSR_MST022                2586-2588
 PRCCSR_MST023                2589-2591
 PRCCSR_MST024                2592-2594
 PRCCSR_MST025                2595-2597
 PRCCSR_MST026                2598-2600
 PRCCSR_MST027                2601-2603
 PRCCSR_MST028                2604-2606
 PRCCSR_MST029                2607-2609
 PRCCSR_MST030                2610-2612
 PRCCSR_NCM001                2613-2615
 PRCCSR_NCM002                2616-2618
 PRCCSR_NCM003                2619-2621
 PRCCSR_NCM004                2622-2624
 PRCCSR_OST001                2625-2627
 PRCCSR_OTR001                2628-2630
 PRCCSR_OTR002                2631-2633
 PRCCSR_OTR003                2634-2636
 PRCCSR_OTR004                2637-2639
 PRCCSR_OTR005                2640-2642
 PRCCSR_PGN001                2643-2645
 PRCCSR_PGN002                2646-2648
 PRCCSR_PGN003                2649-2651
 PRCCSR_PGN004                2652-2654
 PRCCSR_PGN005                2655-2657
 PRCCSR_PGN006                2658-2660
 PRCCSR_PGN007                2661-2663
 PRCCSR_PGN008                2664-2666
 PRCCSR_PGN009                2667-2669
 PRCCSR_PLC001                2670-2672
 PRCCSR_PLC002                2673-2675
 PRCCSR_PNS001                2676-2678
 PRCCSR_PNS002                2679-2681
 PRCCSR_PNS003                2682-2684
 PRCCSR_PNS004                2685-2687
 PRCCSR_PNS005                2688-2690
 PRCCSR_PNS006                2691-2693
 PRCCSR_RAD001                2694-2696
 PRCCSR_RAD002                2697-2699
 PRCCSR_RAD003                2700-2702
 PRCCSR_RAD004                2703-2705
 PRCCSR_RES001                2706-2708
 PRCCSR_RES002                2709-2711
 PRCCSR_RES003                2712-2714
 PRCCSR_RES004                2715-2717
 PRCCSR_RES005                2718-2720
 PRCCSR_RES006                2721-2723
 PRCCSR_RES007                2724-2726
 PRCCSR_RES008                2727-2729
 PRCCSR_RES009                2730-2732
 PRCCSR_RES010                2733-2735
 PRCCSR_RES011                2736-2738
 PRCCSR_RES012                2739-2741
 PRCCSR_RES013                2742-2744
 PRCCSR_RES014                2745-2747
 PRCCSR_RHB001                2748-2750
 PRCCSR_RHB002                2751-2753
 PRCCSR_RHB003                2754-2756
 PRCCSR_RHB004                2757-2759
 PRCCSR_SKB001                2760-2762
 PRCCSR_SKB002                2763-2765
 PRCCSR_SKB003                2766-2768
 PRCCSR_SKB004                2769-2771
 PRCCSR_SKB005                2772-2774
 PRCCSR_SKB006                2775-2777
 PRCCSR_SKB007                2778-2780
 PRCCSR_SKB008                2781-2783
 PRCCSR_SKB009                2784-2786
 PRCCSR_SKB010                2787-2789
 PRCCSR_SUD001                2790-2792
 PRCCSR_SUD002                2793-2795
 PRCCSR_SUD003                2796-2798
 PRCCSR_SUD004                2799-2801
 PRCCSR_URN001                2802-2804
 PRCCSR_URN002                2805-2807
 PRCCSR_URN003                2808-2810
 PRCCSR_URN004                2811-2813
 PRCCSR_URN005                2814-2816
 PRCCSR_URN006                2817-2819
 PRCCSR_URN007                2820-2822
 PRCCSR_URN008                2823-2825
 PRCCSR_URN009                2826-2828
 PRCCSR_URN010                2829-2831
 PRCCSR_URN011                2832-2834
 PRCCSR_URN012                2835-2837
 PRCCSR_VERSION               2838-2843 (A).


/***  Specify write formats  ***/
FORMATS
 CCIR1                        (F3.0) /
 CCIR2                        (F3.0) /
 CCIR3                        (F3.0) /
 CCIR4                        (F3.0) /
 CCIR5                        (F3.0) /
 CCIR6                        (F3.0) /
 CCIR7                        (F3.0) /
 CCIR8                        (F3.0) /
 CCIR9                        (F3.0) /
 CCIR10                       (F3.0) /
 CCIR11                       (F3.0) /
 CCIR12                       (F3.0) /
 CCIR13                       (F3.0) /
 CCIR14                       (F3.0) /
 CCIR15                       (F3.0) /
 CCIR16                       (F3.0) /
 CCIR17                       (F3.0) /
 CCIR18                       (F3.0) /
 CCIR19                       (F3.0) /
 CCIR20                       (F3.0) /
 CMR_AIDS                     (F3.0) /
 CMR_ALCOHOL                  (F3.0) /
 CMR_ANEMDEF                  (F3.0) /
 CMR_AUTOIMMUNE               (F3.0) /
 CMR_BLDLOSS                  (F3.0) /
 CMR_CANCER_LEUK              (F3.0) /
 CMR_CANCER_LYMPH             (F3.0) /
 CMR_CANCER_METS              (F3.0) /
 CMR_CANCER_NSITU             (F3.0) /
 CMR_CANCER_SOLID             (F3.0) /
 CMR_CBVD                     (F3.0) /
 CMR_COAG                     (F3.0) /
 CMR_DEMENTIA                 (F3.0) /
 CMR_DEPRESS                  (F3.0) /
 CMR_DIAB_CX                  (F3.0) /
 CMR_DIAB_UNCX                (F3.0) /
 CMR_DRUG_ABUSE               (F3.0) /
 CMR_HF                       (F3.0) /
 CMR_HTN_CX                   (F3.0) /
 CMR_HTN_UNCX                 (F3.0) /
 CMR_LIVER_MLD                (F3.0) /
 CMR_LIVER_SEV                (F3.0) /
 CMR_LUNG_CHRONIC             (F3.0) /
 CMR_NEURO_MOVT               (F3.0) /
 CMR_NEURO_OTH                (F3.0) /
 CMR_NEURO_SEIZ               (F3.0) /
 CMR_OBESE                    (F3.0) /
 CMR_PARALYSIS                (F3.0) /
 CMR_PERIVASC                 (F3.0) /
 CMR_PSYCHOSES                (F3.0) /
 CMR_PULMCIRC                 (F3.0) /
 CMR_RENLFL_MOD               (F3.0) /
 CMR_RENLFL_SEV               (F3.0) /
 CMR_THYROID_HYPO             (F3.0) /
 CMR_THYROID_OTH              (F3.0) /
 CMR_ULCER_PEPTIC             (F3.0) /
 CMR_VALVE                    (F3.0) /
 CMR_WGHTLOSS                 (F3.0) /
 I10_INJURY                   (F3.0) /
 I10_INJURY_CUT               (F3.0) /
 I10_INJURY_DROWN             (F3.0) /
 I10_INJURY_FALL              (F3.0) /
 I10_INJURY_FIRE              (F3.0) /
 I10_INJURY_FIREARM           (F3.0) /
 I10_INJURY_MACHINERY         (F3.0) /
 I10_INJURY_MVT               (F3.0) /
 I10_INJURY_NATURE            (F3.0) /
 I10_INJURY_OVEREXERTION      (F3.0) /
 I10_INJURY_POISON            (F3.0) /
 I10_INJURY_STRUCK            (F3.0) /
 I10_INJURY_SUFFOCATION       (F3.0) /
 I10_INTENT_ASSAULT           (F3.0) /
 I10_INTENT_SELF_HARM         (F3.0) /
 I10_INTENT_UNINTENTIONAL     (F3.0) /
 I10_MULTINJURY               (F3.0) /
 KEY                          (F8.0) /
 PCLASS1                      (F3.0) /
 PCLASS2                      (F3.0) /
 PCLASS3                      (F3.0) /
 PCLASS4                      (F3.0) /
 PCLASS5                      (F3.0) /
 PCLASS6                      (F3.0) /
 DXCCSR_BLD001                (F3.0) /
 DXCCSR_BLD002                (F3.0) /
 DXCCSR_BLD003                (F3.0) /
 DXCCSR_BLD004                (F3.0) /
 DXCCSR_BLD005                (F3.0) /
 DXCCSR_BLD006                (F3.0) /
 DXCCSR_BLD007                (F3.0) /
 DXCCSR_BLD008                (F3.0) /
 DXCCSR_BLD009                (F3.0) /
 DXCCSR_BLD010                (F3.0) /
 DXCCSR_CIR001                (F3.0) /
 DXCCSR_CIR002                (F3.0) /
 DXCCSR_CIR003                (F3.0) /
 DXCCSR_CIR004                (F3.0) /
 DXCCSR_CIR005                (F3.0) /
 DXCCSR_CIR006                (F3.0) /
 DXCCSR_CIR007                (F3.0) /
 DXCCSR_CIR008                (F3.0) /
 DXCCSR_CIR009                (F3.0) /
 DXCCSR_CIR010                (F3.0) /
 DXCCSR_CIR011                (F3.0) /
 DXCCSR_CIR012                (F3.0) /
 DXCCSR_CIR013                (F3.0) /
 DXCCSR_CIR014                (F3.0) /
 DXCCSR_CIR015                (F3.0) /
 DXCCSR_CIR016                (F3.0) /
 DXCCSR_CIR017                (F3.0) /
 DXCCSR_CIR018                (F3.0) /
 DXCCSR_CIR019                (F3.0) /
 DXCCSR_CIR020                (F3.0) /
 DXCCSR_CIR021                (F3.0) /
 DXCCSR_CIR022                (F3.0) /
 DXCCSR_CIR023                (F3.0) /
 DXCCSR_CIR024                (F3.0) /
 DXCCSR_CIR025                (F3.0) /
 DXCCSR_CIR026                (F3.0) /
 DXCCSR_CIR027                (F3.0) /
 DXCCSR_CIR028                (F3.0) /
 DXCCSR_CIR029                (F3.0) /
 DXCCSR_CIR030                (F3.0) /
 DXCCSR_CIR031                (F3.0) /
 DXCCSR_CIR032                (F3.0) /
 DXCCSR_CIR033                (F3.0) /
 DXCCSR_CIR034                (F3.0) /
 DXCCSR_CIR035                (F3.0) /
 DXCCSR_CIR036                (F3.0) /
 DXCCSR_CIR037                (F3.0) /
 DXCCSR_CIR038                (F3.0) /
 DXCCSR_CIR039                (F3.0) /
 DXCCSR_DEN001                (F3.0) /
 DXCCSR_DEN002                (F3.0) /
 DXCCSR_DEN003                (F3.0) /
 DXCCSR_DIG001                (F3.0) /
 DXCCSR_DIG002                (F3.0) /
 DXCCSR_DIG003                (F3.0) /
 DXCCSR_DIG004                (F3.0) /
 DXCCSR_DIG005                (F3.0) /
 DXCCSR_DIG006                (F3.0) /
 DXCCSR_DIG007                (F3.0) /
 DXCCSR_DIG008                (F3.0) /
 DXCCSR_DIG009                (F3.0) /
 DXCCSR_DIG010                (F3.0) /
 DXCCSR_DIG011                (F3.0) /
 DXCCSR_DIG012                (F3.0) /
 DXCCSR_DIG013                (F3.0) /
 DXCCSR_DIG014                (F3.0) /
 DXCCSR_DIG015                (F3.0) /
 DXCCSR_DIG016                (F3.0) /
 DXCCSR_DIG017                (F3.0) /
 DXCCSR_DIG018                (F3.0) /
 DXCCSR_DIG019                (F3.0) /
 DXCCSR_DIG020                (F3.0) /
 DXCCSR_DIG021                (F3.0) /
 DXCCSR_DIG022                (F3.0) /
 DXCCSR_DIG023                (F3.0) /
 DXCCSR_DIG024                (F3.0) /
 DXCCSR_DIG025                (F3.0) /
 DXCCSR_EAR001                (F3.0) /
 DXCCSR_EAR002                (F3.0) /
 DXCCSR_EAR003                (F3.0) /
 DXCCSR_EAR004                (F3.0) /
 DXCCSR_EAR005                (F3.0) /
 DXCCSR_EAR006                (F3.0) /
 DXCCSR_END001                (F3.0) /
 DXCCSR_END002                (F3.0) /
 DXCCSR_END003                (F3.0) /
 DXCCSR_END004                (F3.0) /
 DXCCSR_END005                (F3.0) /
 DXCCSR_END006                (F3.0) /
 DXCCSR_END007                (F3.0) /
 DXCCSR_END008                (F3.0) /
 DXCCSR_END009                (F3.0) /
 DXCCSR_END010                (F3.0) /
 DXCCSR_END011                (F3.0) /
 DXCCSR_END012                (F3.0) /
 DXCCSR_END013                (F3.0) /
 DXCCSR_END014                (F3.0) /
 DXCCSR_END015                (F3.0) /
 DXCCSR_END016                (F3.0) /
 DXCCSR_END017                (F3.0) /
 DXCCSR_EXT001                (F3.0) /
 DXCCSR_EXT002                (F3.0) /
 DXCCSR_EXT003                (F3.0) /
 DXCCSR_EXT004                (F3.0) /
 DXCCSR_EXT005                (F3.0) /
 DXCCSR_EXT006                (F3.0) /
 DXCCSR_EXT007                (F3.0) /
 DXCCSR_EXT008                (F3.0) /
 DXCCSR_EXT009                (F3.0) /
 DXCCSR_EXT010                (F3.0) /
 DXCCSR_EXT011                (F3.0) /
 DXCCSR_EXT012                (F3.0) /
 DXCCSR_EXT013                (F3.0) /
 DXCCSR_EXT014                (F3.0) /
 DXCCSR_EXT015                (F3.0) /
 DXCCSR_EXT016                (F3.0) /
 DXCCSR_EXT017                (F3.0) /
 DXCCSR_EXT018                (F3.0) /
 DXCCSR_EXT019                (F3.0) /
 DXCCSR_EXT020                (F3.0) /
 DXCCSR_EXT021                (F3.0) /
 DXCCSR_EXT022                (F3.0) /
 DXCCSR_EXT023                (F3.0) /
 DXCCSR_EXT024                (F3.0) /
 DXCCSR_EXT025                (F3.0) /
 DXCCSR_EXT026                (F3.0) /
 DXCCSR_EXT027                (F3.0) /
 DXCCSR_EXT028                (F3.0) /
 DXCCSR_EXT029                (F3.0) /
 DXCCSR_EXT030                (F3.0) /
 DXCCSR_EYE001                (F3.0) /
 DXCCSR_EYE002                (F3.0) /
 DXCCSR_EYE003                (F3.0) /
 DXCCSR_EYE004                (F3.0) /
 DXCCSR_EYE005                (F3.0) /
 DXCCSR_EYE006                (F3.0) /
 DXCCSR_EYE007                (F3.0) /
 DXCCSR_EYE008                (F3.0) /
 DXCCSR_EYE009                (F3.0) /
 DXCCSR_EYE010                (F3.0) /
 DXCCSR_EYE011                (F3.0) /
 DXCCSR_EYE012                (F3.0) /
 DXCCSR_FAC001                (F3.0) /
 DXCCSR_FAC002                (F3.0) /
 DXCCSR_FAC003                (F3.0) /
 DXCCSR_FAC004                (F3.0) /
 DXCCSR_FAC005                (F3.0) /
 DXCCSR_FAC006                (F3.0) /
 DXCCSR_FAC007                (F3.0) /
 DXCCSR_FAC008                (F3.0) /
 DXCCSR_FAC009                (F3.0) /
 DXCCSR_FAC010                (F3.0) /
 DXCCSR_FAC011                (F3.0) /
 DXCCSR_FAC012                (F3.0) /
 DXCCSR_FAC013                (F3.0) /
 DXCCSR_FAC014                (F3.0) /
 DXCCSR_FAC015                (F3.0) /
 DXCCSR_FAC016                (F3.0) /
 DXCCSR_FAC017                (F3.0) /
 DXCCSR_FAC018                (F3.0) /
 DXCCSR_FAC019                (F3.0) /
 DXCCSR_FAC020                (F3.0) /
 DXCCSR_FAC021                (F3.0) /
 DXCCSR_FAC022                (F3.0) /
 DXCCSR_FAC023                (F3.0) /
 DXCCSR_FAC024                (F3.0) /
 DXCCSR_FAC025                (F3.0) /
 DXCCSR_GEN001                (F3.0) /
 DXCCSR_GEN002                (F3.0) /
 DXCCSR_GEN003                (F3.0) /
 DXCCSR_GEN004                (F3.0) /
 DXCCSR_GEN005                (F3.0) /
 DXCCSR_GEN006                (F3.0) /
 DXCCSR_GEN007                (F3.0) /
 DXCCSR_GEN008                (F3.0) /
 DXCCSR_GEN009                (F3.0) /
 DXCCSR_GEN010                (F3.0) /
 DXCCSR_GEN011                (F3.0) /
 DXCCSR_GEN012                (F3.0) /
 DXCCSR_GEN013                (F3.0) /
 DXCCSR_GEN014                (F3.0) /
 DXCCSR_GEN015                (F3.0) /
 DXCCSR_GEN016                (F3.0) /
 DXCCSR_GEN017                (F3.0) /
 DXCCSR_GEN018                (F3.0) /
 DXCCSR_GEN019                (F3.0) /
 DXCCSR_GEN020                (F3.0) /
 DXCCSR_GEN021                (F3.0) /
 DXCCSR_GEN022                (F3.0) /
 DXCCSR_GEN023                (F3.0) /
 DXCCSR_GEN024                (F3.0) /
 DXCCSR_GEN025                (F3.0) /
 DXCCSR_GEN026                (F3.0) /
 DXCCSR_INF001                (F3.0) /
 DXCCSR_INF002                (F3.0) /
 DXCCSR_INF003                (F3.0) /
 DXCCSR_INF004                (F3.0) /
 DXCCSR_INF005                (F3.0) /
 DXCCSR_INF006                (F3.0) /
 DXCCSR_INF007                (F3.0) /
 DXCCSR_INF008                (F3.0) /
 DXCCSR_INF009                (F3.0) /
 DXCCSR_INF010                (F3.0) /
 DXCCSR_INF011                (F3.0) /
 DXCCSR_INF012                (F3.0) /
 DXCCSR_INJ001                (F3.0) /
 DXCCSR_INJ002                (F3.0) /
 DXCCSR_INJ003                (F3.0) /
 DXCCSR_INJ004                (F3.0) /
 DXCCSR_INJ005                (F3.0) /
 DXCCSR_INJ006                (F3.0) /
 DXCCSR_INJ007                (F3.0) /
 DXCCSR_INJ008                (F3.0) /
 DXCCSR_INJ009                (F3.0) /
 DXCCSR_INJ010                (F3.0) /
 DXCCSR_INJ011                (F3.0) /
 DXCCSR_INJ012                (F3.0) /
 DXCCSR_INJ013                (F3.0) /
 DXCCSR_INJ014                (F3.0) /
 DXCCSR_INJ015                (F3.0) /
 DXCCSR_INJ016                (F3.0) /
 DXCCSR_INJ017                (F3.0) /
 DXCCSR_INJ018                (F3.0) /
 DXCCSR_INJ019                (F3.0) /
 DXCCSR_INJ020                (F3.0) /
 DXCCSR_INJ021                (F3.0) /
 DXCCSR_INJ022                (F3.0) /
 DXCCSR_INJ023                (F3.0) /
 DXCCSR_INJ024                (F3.0) /
 DXCCSR_INJ025                (F3.0) /
 DXCCSR_INJ026                (F3.0) /
 DXCCSR_INJ027                (F3.0) /
 DXCCSR_INJ028                (F3.0) /
 DXCCSR_INJ029                (F3.0) /
 DXCCSR_INJ030                (F3.0) /
 DXCCSR_INJ031                (F3.0) /
 DXCCSR_INJ032                (F3.0) /
 DXCCSR_INJ033                (F3.0) /
 DXCCSR_INJ034                (F3.0) /
 DXCCSR_INJ035                (F3.0) /
 DXCCSR_INJ036                (F3.0) /
 DXCCSR_INJ037                (F3.0) /
 DXCCSR_INJ038                (F3.0) /
 DXCCSR_INJ039                (F3.0) /
 DXCCSR_INJ040                (F3.0) /
 DXCCSR_INJ041                (F3.0) /
 DXCCSR_INJ042                (F3.0) /
 DXCCSR_INJ043                (F3.0) /
 DXCCSR_INJ044                (F3.0) /
 DXCCSR_INJ045                (F3.0) /
 DXCCSR_INJ046                (F3.0) /
 DXCCSR_INJ047                (F3.0) /
 DXCCSR_INJ048                (F3.0) /
 DXCCSR_INJ049                (F3.0) /
 DXCCSR_INJ050                (F3.0) /
 DXCCSR_INJ051                (F3.0) /
 DXCCSR_INJ052                (F3.0) /
 DXCCSR_INJ053                (F3.0) /
 DXCCSR_INJ054                (F3.0) /
 DXCCSR_INJ055                (F3.0) /
 DXCCSR_INJ056                (F3.0) /
 DXCCSR_INJ057                (F3.0) /
 DXCCSR_INJ058                (F3.0) /
 DXCCSR_INJ059                (F3.0) /
 DXCCSR_INJ060                (F3.0) /
 DXCCSR_INJ061                (F3.0) /
 DXCCSR_INJ062                (F3.0) /
 DXCCSR_INJ063                (F3.0) /
 DXCCSR_INJ064                (F3.0) /
 DXCCSR_INJ065                (F3.0) /
 DXCCSR_INJ066                (F3.0) /
 DXCCSR_INJ067                (F3.0) /
 DXCCSR_INJ068                (F3.0) /
 DXCCSR_INJ069                (F3.0) /
 DXCCSR_INJ070                (F3.0) /
 DXCCSR_INJ071                (F3.0) /
 DXCCSR_INJ072                (F3.0) /
 DXCCSR_INJ073                (F3.0) /
 DXCCSR_INJ074                (F3.0) /
 DXCCSR_INJ075                (F3.0) /
 DXCCSR_INJ076                (F3.0) /
 DXCCSR_MAL001                (F3.0) /
 DXCCSR_MAL002                (F3.0) /
 DXCCSR_MAL003                (F3.0) /
 DXCCSR_MAL004                (F3.0) /
 DXCCSR_MAL005                (F3.0) /
 DXCCSR_MAL006                (F3.0) /
 DXCCSR_MAL007                (F3.0) /
 DXCCSR_MAL008                (F3.0) /
 DXCCSR_MAL009                (F3.0) /
 DXCCSR_MAL010                (F3.0) /
 DXCCSR_MBD001                (F3.0) /
 DXCCSR_MBD002                (F3.0) /
 DXCCSR_MBD003                (F3.0) /
 DXCCSR_MBD004                (F3.0) /
 DXCCSR_MBD005                (F3.0) /
 DXCCSR_MBD006                (F3.0) /
 DXCCSR_MBD007                (F3.0) /
 DXCCSR_MBD008                (F3.0) /
 DXCCSR_MBD009                (F3.0) /
 DXCCSR_MBD010                (F3.0) /
 DXCCSR_MBD011                (F3.0) /
 DXCCSR_MBD012                (F3.0) /
 DXCCSR_MBD013                (F3.0) /
 DXCCSR_MBD014                (F3.0) /
 DXCCSR_MBD017                (F3.0) /
 DXCCSR_MBD018                (F3.0) /
 DXCCSR_MBD019                (F3.0) /
 DXCCSR_MBD020                (F3.0) /
 DXCCSR_MBD021                (F3.0) /
 DXCCSR_MBD022                (F3.0) /
 DXCCSR_MBD023                (F3.0) /
 DXCCSR_MBD024                (F3.0) /
 DXCCSR_MBD025                (F3.0) /
 DXCCSR_MBD026                (F3.0) /
 DXCCSR_MBD027                (F3.0) /
 DXCCSR_MBD028                (F3.0) /
 DXCCSR_MBD029                (F3.0) /
 DXCCSR_MBD030                (F3.0) /
 DXCCSR_MBD031                (F3.0) /
 DXCCSR_MBD032                (F3.0) /
 DXCCSR_MBD033                (F3.0) /
 DXCCSR_MBD034                (F3.0) /
 DXCCSR_MUS001                (F3.0) /
 DXCCSR_MUS002                (F3.0) /
 DXCCSR_MUS003                (F3.0) /
 DXCCSR_MUS004                (F3.0) /
 DXCCSR_MUS005                (F3.0) /
 DXCCSR_MUS006                (F3.0) /
 DXCCSR_MUS007                (F3.0) /
 DXCCSR_MUS008                (F3.0) /
 DXCCSR_MUS009                (F3.0) /
 DXCCSR_MUS010                (F3.0) /
 DXCCSR_MUS011                (F3.0) /
 DXCCSR_MUS012                (F3.0) /
 DXCCSR_MUS013                (F3.0) /
 DXCCSR_MUS014                (F3.0) /
 DXCCSR_MUS015                (F3.0) /
 DXCCSR_MUS016                (F3.0) /
 DXCCSR_MUS017                (F3.0) /
 DXCCSR_MUS018                (F3.0) /
 DXCCSR_MUS019                (F3.0) /
 DXCCSR_MUS020                (F3.0) /
 DXCCSR_MUS021                (F3.0) /
 DXCCSR_MUS022                (F3.0) /
 DXCCSR_MUS023                (F3.0) /
 DXCCSR_MUS024                (F3.0) /
 DXCCSR_MUS025                (F3.0) /
 DXCCSR_MUS026                (F3.0) /
 DXCCSR_MUS027                (F3.0) /
 DXCCSR_MUS028                (F3.0) /
 DXCCSR_MUS029                (F3.0) /
 DXCCSR_MUS030                (F3.0) /
 DXCCSR_MUS031                (F3.0) /
 DXCCSR_MUS032                (F3.0) /
 DXCCSR_MUS033                (F3.0) /
 DXCCSR_MUS034                (F3.0) /
 DXCCSR_MUS035                (F3.0) /
 DXCCSR_MUS036                (F3.0) /
 DXCCSR_MUS037                (F3.0) /
 DXCCSR_MUS038                (F3.0) /
 DXCCSR_NEO001                (F3.0) /
 DXCCSR_NEO002                (F3.0) /
 DXCCSR_NEO003                (F3.0) /
 DXCCSR_NEO004                (F3.0) /
 DXCCSR_NEO005                (F3.0) /
 DXCCSR_NEO006                (F3.0) /
 DXCCSR_NEO007                (F3.0) /
 DXCCSR_NEO008                (F3.0) /
 DXCCSR_NEO009                (F3.0) /
 DXCCSR_NEO010                (F3.0) /
 DXCCSR_NEO011                (F3.0) /
 DXCCSR_NEO012                (F3.0) /
 DXCCSR_NEO013                (F3.0) /
 DXCCSR_NEO014                (F3.0) /
 DXCCSR_NEO015                (F3.0) /
 DXCCSR_NEO016                (F3.0) /
 DXCCSR_NEO017                (F3.0) /
 DXCCSR_NEO018                (F3.0) /
 DXCCSR_NEO019                (F3.0) /
 DXCCSR_NEO020                (F3.0) /
 DXCCSR_NEO021                (F3.0) /
 DXCCSR_NEO022                (F3.0) /
 DXCCSR_NEO023                (F3.0) /
 DXCCSR_NEO024                (F3.0) /
 DXCCSR_NEO025                (F3.0) /
 DXCCSR_NEO026                (F3.0) /
 DXCCSR_NEO027                (F3.0) /
 DXCCSR_NEO028                (F3.0) /
 DXCCSR_NEO029                (F3.0) /
 DXCCSR_NEO030                (F3.0) /
 DXCCSR_NEO031                (F3.0) /
 DXCCSR_NEO032                (F3.0) /
 DXCCSR_NEO033                (F3.0) /
 DXCCSR_NEO034                (F3.0) /
 DXCCSR_NEO035                (F3.0) /
 DXCCSR_NEO036                (F3.0) /
 DXCCSR_NEO037                (F3.0) /
 DXCCSR_NEO038                (F3.0) /
 DXCCSR_NEO039                (F3.0) /
 DXCCSR_NEO040                (F3.0) /
 DXCCSR_NEO041                (F3.0) /
 DXCCSR_NEO042                (F3.0) /
 DXCCSR_NEO043                (F3.0) /
 DXCCSR_NEO044                (F3.0) /
 DXCCSR_NEO045                (F3.0) /
 DXCCSR_NEO046                (F3.0) /
 DXCCSR_NEO047                (F3.0) /
 DXCCSR_NEO048                (F3.0) /
 DXCCSR_NEO049                (F3.0) /
 DXCCSR_NEO050                (F3.0) /
 DXCCSR_NEO051                (F3.0) /
 DXCCSR_NEO052                (F3.0) /
 DXCCSR_NEO053                (F3.0) /
 DXCCSR_NEO054                (F3.0) /
 DXCCSR_NEO055                (F3.0) /
 DXCCSR_NEO056                (F3.0) /
 DXCCSR_NEO057                (F3.0) /
 DXCCSR_NEO058                (F3.0) /
 DXCCSR_NEO059                (F3.0) /
 DXCCSR_NEO060                (F3.0) /
 DXCCSR_NEO061                (F3.0) /
 DXCCSR_NEO062                (F3.0) /
 DXCCSR_NEO063                (F3.0) /
 DXCCSR_NEO064                (F3.0) /
 DXCCSR_NEO065                (F3.0) /
 DXCCSR_NEO066                (F3.0) /
 DXCCSR_NEO067                (F3.0) /
 DXCCSR_NEO068                (F3.0) /
 DXCCSR_NEO069                (F3.0) /
 DXCCSR_NEO070                (F3.0) /
 DXCCSR_NEO071                (F3.0) /
 DXCCSR_NEO072                (F3.0) /
 DXCCSR_NEO073                (F3.0) /
 DXCCSR_NEO074                (F3.0) /
 DXCCSR_NVS001                (F3.0) /
 DXCCSR_NVS002                (F3.0) /
 DXCCSR_NVS003                (F3.0) /
 DXCCSR_NVS004                (F3.0) /
 DXCCSR_NVS005                (F3.0) /
 DXCCSR_NVS006                (F3.0) /
 DXCCSR_NVS007                (F3.0) /
 DXCCSR_NVS008                (F3.0) /
 DXCCSR_NVS009                (F3.0) /
 DXCCSR_NVS010                (F3.0) /
 DXCCSR_NVS011                (F3.0) /
 DXCCSR_NVS012                (F3.0) /
 DXCCSR_NVS013                (F3.0) /
 DXCCSR_NVS014                (F3.0) /
 DXCCSR_NVS015                (F3.0) /
 DXCCSR_NVS016                (F3.0) /
 DXCCSR_NVS017                (F3.0) /
 DXCCSR_NVS018                (F3.0) /
 DXCCSR_NVS019                (F3.0) /
 DXCCSR_NVS020                (F3.0) /
 DXCCSR_NVS021                (F3.0) /
 DXCCSR_NVS022                (F3.0) /
 DXCCSR_PNL001                (F3.0) /
 DXCCSR_PNL002                (F3.0) /
 DXCCSR_PNL003                (F3.0) /
 DXCCSR_PNL004                (F3.0) /
 DXCCSR_PNL005                (F3.0) /
 DXCCSR_PNL006                (F3.0) /
 DXCCSR_PNL007                (F3.0) /
 DXCCSR_PNL008                (F3.0) /
 DXCCSR_PNL009                (F3.0) /
 DXCCSR_PNL010                (F3.0) /
 DXCCSR_PNL011                (F3.0) /
 DXCCSR_PNL012                (F3.0) /
 DXCCSR_PNL013                (F3.0) /
 DXCCSR_PNL014                (F3.0) /
 DXCCSR_PNL015                (F3.0) /
 DXCCSR_PRG001                (F3.0) /
 DXCCSR_PRG002                (F3.0) /
 DXCCSR_PRG003                (F3.0) /
 DXCCSR_PRG004                (F3.0) /
 DXCCSR_PRG005                (F3.0) /
 DXCCSR_PRG006                (F3.0) /
 DXCCSR_PRG007                (F3.0) /
 DXCCSR_PRG008                (F3.0) /
 DXCCSR_PRG009                (F3.0) /
 DXCCSR_PRG010                (F3.0) /
 DXCCSR_PRG011                (F3.0) /
 DXCCSR_PRG012                (F3.0) /
 DXCCSR_PRG013                (F3.0) /
 DXCCSR_PRG014                (F3.0) /
 DXCCSR_PRG015                (F3.0) /
 DXCCSR_PRG016                (F3.0) /
 DXCCSR_PRG017                (F3.0) /
 DXCCSR_PRG018                (F3.0) /
 DXCCSR_PRG019                (F3.0) /
 DXCCSR_PRG020                (F3.0) /
 DXCCSR_PRG021                (F3.0) /
 DXCCSR_PRG022                (F3.0) /
 DXCCSR_PRG023                (F3.0) /
 DXCCSR_PRG024                (F3.0) /
 DXCCSR_PRG025                (F3.0) /
 DXCCSR_PRG026                (F3.0) /
 DXCCSR_PRG027                (F3.0) /
 DXCCSR_PRG028                (F3.0) /
 DXCCSR_PRG029                (F3.0) /
 DXCCSR_PRG030                (F3.0) /
 DXCCSR_RSP001                (F3.0) /
 DXCCSR_RSP002                (F3.0) /
 DXCCSR_RSP003                (F3.0) /
 DXCCSR_RSP004                (F3.0) /
 DXCCSR_RSP005                (F3.0) /
 DXCCSR_RSP006                (F3.0) /
 DXCCSR_RSP007                (F3.0) /
 DXCCSR_RSP008                (F3.0) /
 DXCCSR_RSP009                (F3.0) /
 DXCCSR_RSP010                (F3.0) /
 DXCCSR_RSP011                (F3.0) /
 DXCCSR_RSP012                (F3.0) /
 DXCCSR_RSP013                (F3.0) /
 DXCCSR_RSP014                (F3.0) /
 DXCCSR_RSP015                (F3.0) /
 DXCCSR_RSP016                (F3.0) /
 DXCCSR_RSP017                (F3.0) /
 DXCCSR_SKN001                (F3.0) /
 DXCCSR_SKN002                (F3.0) /
 DXCCSR_SKN003                (F3.0) /
 DXCCSR_SKN004                (F3.0) /
 DXCCSR_SKN005                (F3.0) /
 DXCCSR_SKN006                (F3.0) /
 DXCCSR_SKN007                (F3.0) /
 DXCCSR_SYM001                (F3.0) /
 DXCCSR_SYM002                (F3.0) /
 DXCCSR_SYM003                (F3.0) /
 DXCCSR_SYM004                (F3.0) /
 DXCCSR_SYM005                (F3.0) /
 DXCCSR_SYM006                (F3.0) /
 DXCCSR_SYM007                (F3.0) /
 DXCCSR_SYM008                (F3.0) /
 DXCCSR_SYM009                (F3.0) /
 DXCCSR_SYM010                (F3.0) /
 DXCCSR_SYM011                (F3.0) /
 DXCCSR_SYM012                (F3.0) /
 DXCCSR_SYM013                (F3.0) /
 DXCCSR_SYM014                (F3.0) /
 DXCCSR_SYM015                (F3.0) /
 DXCCSR_SYM016                (F3.0) /
 DXCCSR_SYM017                (F3.0) /
 PRCCSR_ADM001                (F3.0) /
 PRCCSR_ADM002                (F3.0) /
 PRCCSR_ADM003                (F3.0) /
 PRCCSR_ADM004                (F3.0) /
 PRCCSR_ADM005                (F3.0) /
 PRCCSR_ADM006                (F3.0) /
 PRCCSR_ADM007                (F3.0) /
 PRCCSR_ADM008                (F3.0) /
 PRCCSR_ADM009                (F3.0) /
 PRCCSR_ADM010                (F3.0) /
 PRCCSR_ADM011                (F3.0) /
 PRCCSR_ADM012                (F3.0) /
 PRCCSR_ADM013                (F3.0) /
 PRCCSR_ADM014                (F3.0) /
 PRCCSR_ADM015                (F3.0) /
 PRCCSR_ADM016                (F3.0) /
 PRCCSR_ADM017                (F3.0) /
 PRCCSR_ADM018                (F3.0) /
 PRCCSR_ADM019                (F3.0) /
 PRCCSR_ADM020                (F3.0) /
 PRCCSR_ADM021                (F3.0) /
 PRCCSR_ADM022                (F3.0) /
 PRCCSR_CAR001                (F3.0) /
 PRCCSR_CAR002                (F3.0) /
 PRCCSR_CAR003                (F3.0) /
 PRCCSR_CAR004                (F3.0) /
 PRCCSR_CAR005                (F3.0) /
 PRCCSR_CAR006                (F3.0) /
 PRCCSR_CAR007                (F3.0) /
 PRCCSR_CAR008                (F3.0) /
 PRCCSR_CAR009                (F3.0) /
 PRCCSR_CAR010                (F3.0) /
 PRCCSR_CAR011                (F3.0) /
 PRCCSR_CAR012                (F3.0) /
 PRCCSR_CAR013                (F3.0) /
 PRCCSR_CAR014                (F3.0) /
 PRCCSR_CAR015                (F3.0) /
 PRCCSR_CAR016                (F3.0) /
 PRCCSR_CAR017                (F3.0) /
 PRCCSR_CAR018                (F3.0) /
 PRCCSR_CAR019                (F3.0) /
 PRCCSR_CAR020                (F3.0) /
 PRCCSR_CAR021                (F3.0) /
 PRCCSR_CAR022                (F3.0) /
 PRCCSR_CAR023                (F3.0) /
 PRCCSR_CAR024                (F3.0) /
 PRCCSR_CAR025                (F3.0) /
 PRCCSR_CAR026                (F3.0) /
 PRCCSR_CAR027                (F3.0) /
 PRCCSR_CAR028                (F3.0) /
 PRCCSR_CAR029                (F3.0) /
 PRCCSR_CHP001                (F3.0) /
 PRCCSR_CNS001                (F3.0) /
 PRCCSR_CNS002                (F3.0) /
 PRCCSR_CNS003                (F3.0) /
 PRCCSR_CNS004                (F3.0) /
 PRCCSR_CNS005                (F3.0) /
 PRCCSR_CNS006                (F3.0) /
 PRCCSR_CNS007                (F3.0) /
 PRCCSR_CNS008                (F3.0) /
 PRCCSR_CNS009                (F3.0) /
 PRCCSR_CNS010                (F3.0) /
 PRCCSR_CNS011                (F3.0) /
 PRCCSR_CNS012                (F3.0) /
 PRCCSR_CNS013                (F3.0) /
 PRCCSR_CNS014                (F3.0) /
 PRCCSR_ENP001                (F3.0) /
 PRCCSR_ENP002                (F3.0) /
 PRCCSR_ENP003                (F3.0) /
 PRCCSR_ENP004                (F3.0) /
 PRCCSR_ENP005                (F3.0) /
 PRCCSR_ENP006                (F3.0) /
 PRCCSR_ENT001                (F3.0) /
 PRCCSR_ENT002                (F3.0) /
 PRCCSR_ENT003                (F3.0) /
 PRCCSR_ENT004                (F3.0) /
 PRCCSR_ENT005                (F3.0) /
 PRCCSR_ENT006                (F3.0) /
 PRCCSR_ENT007                (F3.0) /
 PRCCSR_ENT008                (F3.0) /
 PRCCSR_ENT009                (F3.0) /
 PRCCSR_ENT010                (F3.0) /
 PRCCSR_ENT011                (F3.0) /
 PRCCSR_ENT012                (F3.0) /
 PRCCSR_ENT013                (F3.0) /
 PRCCSR_ENT014                (F3.0) /
 PRCCSR_ENT015                (F3.0) /
 PRCCSR_ENT016                (F3.0) /
 PRCCSR_ENT017                (F3.0) /
 PRCCSR_ESA001                (F3.0) /
 PRCCSR_ESA002                (F3.0) /
 PRCCSR_ESA003                (F3.0) /
 PRCCSR_ESA004                (F3.0) /
 PRCCSR_ESA005                (F3.0) /
 PRCCSR_ESA006                (F3.0) /
 PRCCSR_ESA007                (F3.0) /
 PRCCSR_ESA008                (F3.0) /
 PRCCSR_ESA009                (F3.0) /
 PRCCSR_ESA010                (F3.0) /
 PRCCSR_ESA011                (F3.0) /
 PRCCSR_EST001                (F3.0) /
 PRCCSR_EST002                (F3.0) /
 PRCCSR_EST003                (F3.0) /
 PRCCSR_EST004                (F3.0) /
 PRCCSR_EST005                (F3.0) /
 PRCCSR_EYP001                (F3.0) /
 PRCCSR_EYP002                (F3.0) /
 PRCCSR_FRS001                (F3.0) /
 PRCCSR_FRS002                (F3.0) /
 PRCCSR_FRS003                (F3.0) /
 PRCCSR_FRS004                (F3.0) /
 PRCCSR_FRS005                (F3.0) /
 PRCCSR_FRS006                (F3.0) /
 PRCCSR_FRS007                (F3.0) /
 PRCCSR_FRS008                (F3.0) /
 PRCCSR_FRS009                (F3.0) /
 PRCCSR_FRS010                (F3.0) /
 PRCCSR_FRS011                (F3.0) /
 PRCCSR_FRS012                (F3.0) /
 PRCCSR_FRS013                (F3.0) /
 PRCCSR_FRS014                (F3.0) /
 PRCCSR_FRS015                (F3.0) /
 PRCCSR_GIS001                (F3.0) /
 PRCCSR_GIS002                (F3.0) /
 PRCCSR_GIS003                (F3.0) /
 PRCCSR_GIS004                (F3.0) /
 PRCCSR_GIS005                (F3.0) /
 PRCCSR_GIS006                (F3.0) /
 PRCCSR_GIS007                (F3.0) /
 PRCCSR_GIS008                (F3.0) /
 PRCCSR_GIS009                (F3.0) /
 PRCCSR_GIS010                (F3.0) /
 PRCCSR_GIS011                (F3.0) /
 PRCCSR_GIS012                (F3.0) /
 PRCCSR_GIS013                (F3.0) /
 PRCCSR_GIS014                (F3.0) /
 PRCCSR_GIS015                (F3.0) /
 PRCCSR_GIS016                (F3.0) /
 PRCCSR_GIS017                (F3.0) /
 PRCCSR_GIS018                (F3.0) /
 PRCCSR_GIS019                (F3.0) /
 PRCCSR_GIS020                (F3.0) /
 PRCCSR_GIS021                (F3.0) /
 PRCCSR_GIS022                (F3.0) /
 PRCCSR_GIS023                (F3.0) /
 PRCCSR_GIS024                (F3.0) /
 PRCCSR_GIS025                (F3.0) /
 PRCCSR_GIS026                (F3.0) /
 PRCCSR_GIS027                (F3.0) /
 PRCCSR_GIS028                (F3.0) /
 PRCCSR_GIS029                (F3.0) /
 PRCCSR_GNR001                (F3.0) /
 PRCCSR_GNR002                (F3.0) /
 PRCCSR_GNR003                (F3.0) /
 PRCCSR_GNR004                (F3.0) /
 PRCCSR_GNR005                (F3.0) /
 PRCCSR_GNR006                (F3.0) /
 PRCCSR_GNR007                (F3.0) /
 PRCCSR_GNR008                (F3.0) /
 PRCCSR_GNR009                (F3.0) /
 PRCCSR_GNR010                (F3.0) /
 PRCCSR_HEP001                (F3.0) /
 PRCCSR_HEP002                (F3.0) /
 PRCCSR_HEP003                (F3.0) /
 PRCCSR_HEP004                (F3.0) /
 PRCCSR_HEP005                (F3.0) /
 PRCCSR_HEP006                (F3.0) /
 PRCCSR_HEP007                (F3.0) /
 PRCCSR_HEP008                (F3.0) /
 PRCCSR_HEP009                (F3.0) /
 PRCCSR_HEP010                (F3.0) /
 PRCCSR_HEP011                (F3.0) /
 PRCCSR_HEP012                (F3.0) /
 PRCCSR_HEP013                (F3.0) /
 PRCCSR_IMG001                (F3.0) /
 PRCCSR_IMG002                (F3.0) /
 PRCCSR_IMG003                (F3.0) /
 PRCCSR_IMG004                (F3.0) /
 PRCCSR_IMG005                (F3.0) /
 PRCCSR_IMG006                (F3.0) /
 PRCCSR_IMG007                (F3.0) /
 PRCCSR_IMG008                (F3.0) /
 PRCCSR_IMG009                (F3.0) /
 PRCCSR_IMG010                (F3.0) /
 PRCCSR_LYM001                (F3.0) /
 PRCCSR_LYM002                (F3.0) /
 PRCCSR_LYM003                (F3.0) /
 PRCCSR_LYM004                (F3.0) /
 PRCCSR_LYM005                (F3.0) /
 PRCCSR_LYM006                (F3.0) /
 PRCCSR_LYM007                (F3.0) /
 PRCCSR_LYM008                (F3.0) /
 PRCCSR_LYM009                (F3.0) /
 PRCCSR_LYM010                (F3.0) /
 PRCCSR_LYM011                (F3.0) /
 PRCCSR_MAM001                (F3.0) /
 PRCCSR_MAM002                (F3.0) /
 PRCCSR_MAM003                (F3.0) /
 PRCCSR_MAM004                (F3.0) /
 PRCCSR_MAM005                (F3.0) /
 PRCCSR_MAM006                (F3.0) /
 PRCCSR_MAM007                (F3.0) /
 PRCCSR_MAM008                (F3.0) /
 PRCCSR_MAM009                (F3.0) /
 PRCCSR_MAM010                (F3.0) /
 PRCCSR_MAM011                (F3.0) /
 PRCCSR_MAM012                (F3.0) /
 PRCCSR_MAM013                (F3.0) /
 PRCCSR_MAM014                (F3.0) /
 PRCCSR_MAM015                (F3.0) /
 PRCCSR_MHT001                (F3.0) /
 PRCCSR_MHT002                (F3.0) /
 PRCCSR_MHT003                (F3.0) /
 PRCCSR_MHT004                (F3.0) /
 PRCCSR_MHT005                (F3.0) /
 PRCCSR_MRS001                (F3.0) /
 PRCCSR_MRS002                (F3.0) /
 PRCCSR_MRS003                (F3.0) /
 PRCCSR_MRS004                (F3.0) /
 PRCCSR_MRS005                (F3.0) /
 PRCCSR_MRS006                (F3.0) /
 PRCCSR_MRS007                (F3.0) /
 PRCCSR_MST001                (F3.0) /
 PRCCSR_MST002                (F3.0) /
 PRCCSR_MST003                (F3.0) /
 PRCCSR_MST004                (F3.0) /
 PRCCSR_MST005                (F3.0) /
 PRCCSR_MST006                (F3.0) /
 PRCCSR_MST007                (F3.0) /
 PRCCSR_MST008                (F3.0) /
 PRCCSR_MST009                (F3.0) /
 PRCCSR_MST010                (F3.0) /
 PRCCSR_MST011                (F3.0) /
 PRCCSR_MST012                (F3.0) /
 PRCCSR_MST013                (F3.0) /
 PRCCSR_MST014                (F3.0) /
 PRCCSR_MST015                (F3.0) /
 PRCCSR_MST016                (F3.0) /
 PRCCSR_MST017                (F3.0) /
 PRCCSR_MST018                (F3.0) /
 PRCCSR_MST019                (F3.0) /
 PRCCSR_MST020                (F3.0) /
 PRCCSR_MST021                (F3.0) /
 PRCCSR_MST022                (F3.0) /
 PRCCSR_MST023                (F3.0) /
 PRCCSR_MST024                (F3.0) /
 PRCCSR_MST025                (F3.0) /
 PRCCSR_MST026                (F3.0) /
 PRCCSR_MST027                (F3.0) /
 PRCCSR_MST028                (F3.0) /
 PRCCSR_MST029                (F3.0) /
 PRCCSR_MST030                (F3.0) /
 PRCCSR_NCM001                (F3.0) /
 PRCCSR_NCM002                (F3.0) /
 PRCCSR_NCM003                (F3.0) /
 PRCCSR_NCM004                (F3.0) /
 PRCCSR_OST001                (F3.0) /
 PRCCSR_OTR001                (F3.0) /
 PRCCSR_OTR002                (F3.0) /
 PRCCSR_OTR003                (F3.0) /
 PRCCSR_OTR004                (F3.0) /
 PRCCSR_OTR005                (F3.0) /
 PRCCSR_PGN001                (F3.0) /
 PRCCSR_PGN002                (F3.0) /
 PRCCSR_PGN003                (F3.0) /
 PRCCSR_PGN004                (F3.0) /
 PRCCSR_PGN005                (F3.0) /
 PRCCSR_PGN006                (F3.0) /
 PRCCSR_PGN007                (F3.0) /
 PRCCSR_PGN008                (F3.0) /
 PRCCSR_PGN009                (F3.0) /
 PRCCSR_PLC001                (F3.0) /
 PRCCSR_PLC002                (F3.0) /
 PRCCSR_PNS001                (F3.0) /
 PRCCSR_PNS002                (F3.0) /
 PRCCSR_PNS003                (F3.0) /
 PRCCSR_PNS004                (F3.0) /
 PRCCSR_PNS005                (F3.0) /
 PRCCSR_PNS006                (F3.0) /
 PRCCSR_RAD001                (F3.0) /
 PRCCSR_RAD002                (F3.0) /
 PRCCSR_RAD003                (F3.0) /
 PRCCSR_RAD004                (F3.0) /
 PRCCSR_RES001                (F3.0) /
 PRCCSR_RES002                (F3.0) /
 PRCCSR_RES003                (F3.0) /
 PRCCSR_RES004                (F3.0) /
 PRCCSR_RES005                (F3.0) /
 PRCCSR_RES006                (F3.0) /
 PRCCSR_RES007                (F3.0) /
 PRCCSR_RES008                (F3.0) /
 PRCCSR_RES009                (F3.0) /
 PRCCSR_RES010                (F3.0) /
 PRCCSR_RES011                (F3.0) /
 PRCCSR_RES012                (F3.0) /
 PRCCSR_RES013                (F3.0) /
 PRCCSR_RES014                (F3.0) /
 PRCCSR_RHB001                (F3.0) /
 PRCCSR_RHB002                (F3.0) /
 PRCCSR_RHB003                (F3.0) /
 PRCCSR_RHB004                (F3.0) /
 PRCCSR_SKB001                (F3.0) /
 PRCCSR_SKB002                (F3.0) /
 PRCCSR_SKB003                (F3.0) /
 PRCCSR_SKB004                (F3.0) /
 PRCCSR_SKB005                (F3.0) /
 PRCCSR_SKB006                (F3.0) /
 PRCCSR_SKB007                (F3.0) /
 PRCCSR_SKB008                (F3.0) /
 PRCCSR_SKB009                (F3.0) /
 PRCCSR_SKB010                (F3.0) /
 PRCCSR_SUD001                (F3.0) /
 PRCCSR_SUD002                (F3.0) /
 PRCCSR_SUD003                (F3.0) /
 PRCCSR_SUD004                (F3.0) /
 PRCCSR_URN001                (F3.0) /
 PRCCSR_URN002                (F3.0) /
 PRCCSR_URN003                (F3.0) /
 PRCCSR_URN004                (F3.0) /
 PRCCSR_URN005                (F3.0) /
 PRCCSR_URN006                (F3.0) /
 PRCCSR_URN007                (F3.0) /
 PRCCSR_URN008                (F3.0) /
 PRCCSR_URN009                (F3.0) /
 PRCCSR_URN010                (F3.0) /
 PRCCSR_URN011                (F3.0) /
 PRCCSR_URN012                (F3.0) /
.


/***  Assign labels to the variables ***/
VARIABLE LABELS 
 CCIR_VERSION                 "Version of Chronic Condition Indicator Refined for ICD-10-CM"
 CCIR1                        "ICD-10-CM Chronic Condition Indicator Refined 1"
 CCIR2                        "ICD-10-CM Chronic Condition Indicator Refined 2"
 CCIR3                        "ICD-10-CM Chronic Condition Indicator Refined 3"
 CCIR4                        "ICD-10-CM Chronic Condition Indicator Refined 4"
 CCIR5                        "ICD-10-CM Chronic Condition Indicator Refined 5"
 CCIR6                        "ICD-10-CM Chronic Condition Indicator Refined 6"
 CCIR7                        "ICD-10-CM Chronic Condition Indicator Refined 7"
 CCIR8                        "ICD-10-CM Chronic Condition Indicator Refined 8"
 CCIR9                        "ICD-10-CM Chronic Condition Indicator Refined 9"
 CCIR10                       "ICD-10-CM Chronic Condition Indicator Refined 10"
 CCIR11                       "ICD-10-CM Chronic Condition Indicator Refined 11"
 CCIR12                       "ICD-10-CM Chronic Condition Indicator Refined 12"
 CCIR13                       "ICD-10-CM Chronic Condition Indicator Refined 13"
 CCIR14                       "ICD-10-CM Chronic Condition Indicator Refined 14"
 CCIR15                       "ICD-10-CM Chronic Condition Indicator Refined 15"
 CCIR16                       "ICD-10-CM Chronic Condition Indicator Refined 16"
 CCIR17                       "ICD-10-CM Chronic Condition Indicator Refined 17"
 CCIR18                       "ICD-10-CM Chronic Condition Indicator Refined 18"
 CCIR19                       "ICD-10-CM Chronic Condition Indicator Refined 19"
 CCIR20                       "ICD-10-CM Chronic Condition Indicator Refined 20"
 CMR_AIDS                     "Acquired immune deficiency syndrome"
 CMR_ALCOHOL                  "Alcohol abuse"
 CMR_ANEMDEF                  "Anemias due to other nutritional deficiencies"
 CMR_AUTOIMMUNE               "Autoimmune conditions"
 CMR_BLDLOSS                  "Chronic blood loss anemia (iron deficiency)"
 CMR_CANCER_LEUK              "Leukemia"
 CMR_CANCER_LYMPH             "Lymphoma"
 CMR_CANCER_METS              "Metastatic cancer"
 CMR_CANCER_NSITU             "Solid tumor without metastasis, in situ"
 CMR_CANCER_SOLID             "Solid tumor without metastasis, malignant"
 CMR_CBVD                     "Cerebrovascular disease"
 CMR_COAG                     "Coagulopathy"
 CMR_DEMENTIA                 "Dementia"
 CMR_DEPRESS                  "Depression"
 CMR_DIAB_CX                  "Diabetes with chronic complications"
 CMR_DIAB_UNCX                "Diabetes without chronic complications"
 CMR_DRUG_ABUSE               "Drug abuse"
 CMR_HF                       "Heart failure"
 CMR_HTN_CX                   "Hypertension, complicated"
 CMR_HTN_UNCX                 "Hypertension, uncomplicated"
 CMR_LIVER_MLD                "Liver disease, mild"
 CMR_LIVER_SEV                "Liver disease, moderate to severe"
 CMR_LUNG_CHRONIC             "Chronic pulmonary disease"
 CMR_NEURO_MOVT               "Neurological disorders affecting movement"
 CMR_NEURO_OTH                "Other neurological disorders"
 CMR_NEURO_SEIZ               "Seizures and epilepsy"
 CMR_OBESE                    "Obesity"
 CMR_PARALYSIS                "Paralysis"
 CMR_PERIVASC                 "Peripheral vascular disease"
 CMR_PSYCHOSES                "Psychoses"
 CMR_PULMCIRC                 "Pulmonary circulation disease"
 CMR_RENLFL_MOD               "Renal failure, moderate"
 CMR_RENLFL_SEV               "Renal failure, severe"
 CMR_THYROID_HYPO             "Hypothyroidism"
 CMR_THYROID_OTH              "Other thyroid disorders"
 CMR_ULCER_PEPTIC             "Peptic ulcer disease x bleeding"
 CMR_VALVE                    "Valvular disease"
 CMR_VERSION                  "Version of Elixhauser Comorbidity Software Refined"
 CMR_WGHTLOSS                 "Weight loss"
 I10_INJURY

"Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)
"
 I10_INJURY_CUT               "Mechanism of injury: cut or pierce"
 I10_INJURY_DROWN             "Mechanism of injury: drowning or submersion"
 I10_INJURY_FALL              "Mechanism of injury: fall"
 I10_INJURY_FIRE              "Mechanism of injury: fire, flame, hot object, or hot substance"
 I10_INJURY_FIREARM           "Mechanism of injury: firearm"
 I10_INJURY_MACHINERY         "Mechanism of injury: machinery"
 I10_INJURY_MVT

"Mechanism of injury: motor vehicle traffic, including the occupant of a car, motorcyclist, pedal cyclist, pedestrian, o
ther, or unspecified"
 I10_INJURY_NATURE
"Mechanism of injury: natural or environmental, included venomous and nonvenomous bites and stings"
 I10_INJURY_OVEREXERTION      "Mechanism of injury: overexertion"
 I10_INJURY_POISON            "Mechanism of injury: poisoning, including drugs and nondrugs"
 I10_INJURY_STRUCK            "Mechanism of injury: struck by or against"
 I10_INJURY_SUFFOCATION       "Mechanism of injury: suffocation"
 I10_INTENT_ASSAULT           "Intent of injury: assault"
 I10_INTENT_SELF_HARM         "Intent of injury: intentional self-harm"
 I10_INTENT_UNINTENTIONAL     "Intent of injury: unintentional"
 I10_MULTINJURY               "Multiple ICD-10-CM injuries reported on record"
 KEY                          "HCUP record identifier"
 PCLASS_VERSION               "Version of ICD-10-PCS Procedure class"
 PCLASS1                      "ICD-10-PCS Procedure class 1"
 PCLASS2                      "ICD-10-PCS Procedure class 2"
 PCLASS3                      "ICD-10-PCS Procedure class 3"
 PCLASS4                      "ICD-10-PCS Procedure class 4"
 PCLASS5                      "ICD-10-PCS Procedure class 5"
 PCLASS6                      "ICD-10-PCS Procedure class 6"
 DXCCSR_Default_DX1           "Default CCSR for principal/first-listed ICD-10-CM diagnosis"
 DXCCSR_BLD001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD001"
 DXCCSR_BLD002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD002"
 DXCCSR_BLD003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD003"
 DXCCSR_BLD004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD004"
 DXCCSR_BLD005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD005"
 DXCCSR_BLD006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD006"
 DXCCSR_BLD007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD007"
 DXCCSR_BLD008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD008"
 DXCCSR_BLD009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD009"
 DXCCSR_BLD010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR BLD010"
 DXCCSR_CIR001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR001"
 DXCCSR_CIR002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR002"
 DXCCSR_CIR003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR003"
 DXCCSR_CIR004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR004"
 DXCCSR_CIR005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR005"
 DXCCSR_CIR006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR006"
 DXCCSR_CIR007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR007"
 DXCCSR_CIR008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR008"
 DXCCSR_CIR009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR009"
 DXCCSR_CIR010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR010"
 DXCCSR_CIR011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR011"
 DXCCSR_CIR012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR012"
 DXCCSR_CIR013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR013"
 DXCCSR_CIR014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR014"
 DXCCSR_CIR015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR015"
 DXCCSR_CIR016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR016"
 DXCCSR_CIR017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR017"
 DXCCSR_CIR018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR018"
 DXCCSR_CIR019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR019"
 DXCCSR_CIR020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR020"
 DXCCSR_CIR021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR021"
 DXCCSR_CIR022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR022"
 DXCCSR_CIR023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR023"
 DXCCSR_CIR024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR024"
 DXCCSR_CIR025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR025"
 DXCCSR_CIR026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR026"
 DXCCSR_CIR027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR027"
 DXCCSR_CIR028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR028"
 DXCCSR_CIR029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR029"
 DXCCSR_CIR030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR030"
 DXCCSR_CIR031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR031"
 DXCCSR_CIR032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR032"
 DXCCSR_CIR033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR033"
 DXCCSR_CIR034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR034"
 DXCCSR_CIR035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR035"
 DXCCSR_CIR036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR036"
 DXCCSR_CIR037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR037"
 DXCCSR_CIR038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR038"
 DXCCSR_CIR039
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR CIR039"
 DXCCSR_DEN001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN001"
 DXCCSR_DEN002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN002"
 DXCCSR_DEN003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DEN003"
 DXCCSR_DIG001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG001"
 DXCCSR_DIG002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG002"
 DXCCSR_DIG003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG003"
 DXCCSR_DIG004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG004"
 DXCCSR_DIG005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG005"
 DXCCSR_DIG006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG006"
 DXCCSR_DIG007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG007"
 DXCCSR_DIG008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG008"
 DXCCSR_DIG009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG009"
 DXCCSR_DIG010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG010"
 DXCCSR_DIG011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG011"
 DXCCSR_DIG012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG012"
 DXCCSR_DIG013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG013"
 DXCCSR_DIG014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG014"
 DXCCSR_DIG015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG015"
 DXCCSR_DIG016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG016"
 DXCCSR_DIG017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG017"
 DXCCSR_DIG018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG018"
 DXCCSR_DIG019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG019"
 DXCCSR_DIG020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG020"
 DXCCSR_DIG021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG021"
 DXCCSR_DIG022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG022"
 DXCCSR_DIG023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG023"
 DXCCSR_DIG024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG024"
 DXCCSR_DIG025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR DIG025"
 DXCCSR_EAR001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR001"
 DXCCSR_EAR002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR002"
 DXCCSR_EAR003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR003"
 DXCCSR_EAR004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR004"
 DXCCSR_EAR005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR005"
 DXCCSR_EAR006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EAR006"
 DXCCSR_END001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END001"
 DXCCSR_END002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END002"
 DXCCSR_END003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END003"
 DXCCSR_END004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END004"
 DXCCSR_END005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END005"
 DXCCSR_END006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END006"
 DXCCSR_END007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END007"
 DXCCSR_END008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END008"
 DXCCSR_END009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END009"
 DXCCSR_END010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END010"
 DXCCSR_END011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END011"
 DXCCSR_END012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END012"
 DXCCSR_END013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END013"
 DXCCSR_END014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END014"
 DXCCSR_END015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END015"
 DXCCSR_END016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END016"
 DXCCSR_END017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR END017"
 DXCCSR_EXT001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT001"
 DXCCSR_EXT002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT002"
 DXCCSR_EXT003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT003"
 DXCCSR_EXT004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT004"
 DXCCSR_EXT005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT005"
 DXCCSR_EXT006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT006"
 DXCCSR_EXT007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT007"
 DXCCSR_EXT008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT008"
 DXCCSR_EXT009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT009"
 DXCCSR_EXT010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT010"
 DXCCSR_EXT011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT011"
 DXCCSR_EXT012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT012"
 DXCCSR_EXT013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT013"
 DXCCSR_EXT014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT014"
 DXCCSR_EXT015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT015"
 DXCCSR_EXT016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT016"
 DXCCSR_EXT017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT017"
 DXCCSR_EXT018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT018"
 DXCCSR_EXT019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT019"
 DXCCSR_EXT020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT020"
 DXCCSR_EXT021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT021"
 DXCCSR_EXT022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT022"
 DXCCSR_EXT023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT023"
 DXCCSR_EXT024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT024"
 DXCCSR_EXT025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT025"
 DXCCSR_EXT026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT026"
 DXCCSR_EXT027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT027"
 DXCCSR_EXT028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT028"
 DXCCSR_EXT029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT029"
 DXCCSR_EXT030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EXT030"
 DXCCSR_EYE001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE001"
 DXCCSR_EYE002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE002"
 DXCCSR_EYE003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE003"
 DXCCSR_EYE004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE004"
 DXCCSR_EYE005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE005"
 DXCCSR_EYE006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE006"
 DXCCSR_EYE007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE007"
 DXCCSR_EYE008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE008"
 DXCCSR_EYE009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE009"
 DXCCSR_EYE010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE010"
 DXCCSR_EYE011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE011"
 DXCCSR_EYE012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR EYE012"
 DXCCSR_FAC001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC001"
 DXCCSR_FAC002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC002"
 DXCCSR_FAC003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC003"
 DXCCSR_FAC004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC004"
 DXCCSR_FAC005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC005"
 DXCCSR_FAC006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC006"
 DXCCSR_FAC007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC007"
 DXCCSR_FAC008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC008"
 DXCCSR_FAC009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC009"
 DXCCSR_FAC010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC010"
 DXCCSR_FAC011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC011"
 DXCCSR_FAC012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC012"
 DXCCSR_FAC013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC013"
 DXCCSR_FAC014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC014"
 DXCCSR_FAC015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC015"
 DXCCSR_FAC016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC016"
 DXCCSR_FAC017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC017"
 DXCCSR_FAC018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC018"
 DXCCSR_FAC019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC019"
 DXCCSR_FAC020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC020"
 DXCCSR_FAC021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC021"
 DXCCSR_FAC022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC022"
 DXCCSR_FAC023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC023"
 DXCCSR_FAC024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC024"
 DXCCSR_FAC025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR FAC025"
 DXCCSR_GEN001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN001"
 DXCCSR_GEN002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN002"
 DXCCSR_GEN003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN003"
 DXCCSR_GEN004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN004"
 DXCCSR_GEN005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN005"
 DXCCSR_GEN006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN006"
 DXCCSR_GEN007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN007"
 DXCCSR_GEN008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN008"
 DXCCSR_GEN009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN009"
 DXCCSR_GEN010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN010"
 DXCCSR_GEN011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN011"
 DXCCSR_GEN012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN012"
 DXCCSR_GEN013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN013"
 DXCCSR_GEN014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN014"
 DXCCSR_GEN015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN015"
 DXCCSR_GEN016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN016"
 DXCCSR_GEN017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN017"
 DXCCSR_GEN018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN018"
 DXCCSR_GEN019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN019"
 DXCCSR_GEN020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN020"
 DXCCSR_GEN021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN021"
 DXCCSR_GEN022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN022"
 DXCCSR_GEN023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN023"
 DXCCSR_GEN024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN024"
 DXCCSR_GEN025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN025"
 DXCCSR_GEN026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR GEN026"
 DXCCSR_INF001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF001"
 DXCCSR_INF002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF002"
 DXCCSR_INF003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF003"
 DXCCSR_INF004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF004"
 DXCCSR_INF005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF005"
 DXCCSR_INF006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF006"
 DXCCSR_INF007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF007"
 DXCCSR_INF008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF008"
 DXCCSR_INF009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF009"
 DXCCSR_INF010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF010"
 DXCCSR_INF011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF011"
 DXCCSR_INF012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INF012"
 DXCCSR_INJ001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ001"
 DXCCSR_INJ002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ002"
 DXCCSR_INJ003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ003"
 DXCCSR_INJ004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ004"
 DXCCSR_INJ005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ005"
 DXCCSR_INJ006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ006"
 DXCCSR_INJ007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ007"
 DXCCSR_INJ008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ008"
 DXCCSR_INJ009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ009"
 DXCCSR_INJ010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ010"
 DXCCSR_INJ011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ011"
 DXCCSR_INJ012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ012"
 DXCCSR_INJ013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ013"
 DXCCSR_INJ014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ014"
 DXCCSR_INJ015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ015"
 DXCCSR_INJ016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ016"
 DXCCSR_INJ017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ017"
 DXCCSR_INJ018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ018"
 DXCCSR_INJ019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ019"
 DXCCSR_INJ020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ020"
 DXCCSR_INJ021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ021"
 DXCCSR_INJ022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ022"
 DXCCSR_INJ023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ023"
 DXCCSR_INJ024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ024"
 DXCCSR_INJ025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ025"
 DXCCSR_INJ026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ026"
 DXCCSR_INJ027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ027"
 DXCCSR_INJ028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ028"
 DXCCSR_INJ029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ029"
 DXCCSR_INJ030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ030"
 DXCCSR_INJ031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ031"
 DXCCSR_INJ032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ032"
 DXCCSR_INJ033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ033"
 DXCCSR_INJ034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ034"
 DXCCSR_INJ035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ035"
 DXCCSR_INJ036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ036"
 DXCCSR_INJ037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ037"
 DXCCSR_INJ038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ038"
 DXCCSR_INJ039
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ039"
 DXCCSR_INJ040
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ040"
 DXCCSR_INJ041
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ041"
 DXCCSR_INJ042
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ042"
 DXCCSR_INJ043
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ043"
 DXCCSR_INJ044
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ044"
 DXCCSR_INJ045
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ045"
 DXCCSR_INJ046
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ046"
 DXCCSR_INJ047
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ047"
 DXCCSR_INJ048
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ048"
 DXCCSR_INJ049
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ049"
 DXCCSR_INJ050
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ050"
 DXCCSR_INJ051
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ051"
 DXCCSR_INJ052
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ052"
 DXCCSR_INJ053
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ053"
 DXCCSR_INJ054
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ054"
 DXCCSR_INJ055
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ055"
 DXCCSR_INJ056
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ056"
 DXCCSR_INJ057
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ057"
 DXCCSR_INJ058
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ058"
 DXCCSR_INJ059
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ059"
 DXCCSR_INJ060
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ060"
 DXCCSR_INJ061
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ061"
 DXCCSR_INJ062
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ062"
 DXCCSR_INJ063
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ063"
 DXCCSR_INJ064
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ064"
 DXCCSR_INJ065
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ065"
 DXCCSR_INJ066
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ066"
 DXCCSR_INJ067
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ067"
 DXCCSR_INJ068
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ068"
 DXCCSR_INJ069
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ069"
 DXCCSR_INJ070
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ070"
 DXCCSR_INJ071
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ071"
 DXCCSR_INJ072
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ072"
 DXCCSR_INJ073
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ073"
 DXCCSR_INJ074
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ074"
 DXCCSR_INJ075
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ075"
 DXCCSR_INJ076
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR INJ076"
 DXCCSR_MAL001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL001"
 DXCCSR_MAL002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL002"
 DXCCSR_MAL003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL003"
 DXCCSR_MAL004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL004"
 DXCCSR_MAL005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL005"
 DXCCSR_MAL006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL006"
 DXCCSR_MAL007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL007"
 DXCCSR_MAL008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL008"
 DXCCSR_MAL009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL009"
 DXCCSR_MAL010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MAL010"
 DXCCSR_MBD001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD001"
 DXCCSR_MBD002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD002"
 DXCCSR_MBD003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD003"
 DXCCSR_MBD004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD004"
 DXCCSR_MBD005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD005"
 DXCCSR_MBD006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD006"
 DXCCSR_MBD007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD007"
 DXCCSR_MBD008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD008"
 DXCCSR_MBD009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD009"
 DXCCSR_MBD010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD010"
 DXCCSR_MBD011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD011"
 DXCCSR_MBD012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD012"
 DXCCSR_MBD013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD013"
 DXCCSR_MBD014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD014"
 DXCCSR_MBD017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD017"
 DXCCSR_MBD018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD018"
 DXCCSR_MBD019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD019"
 DXCCSR_MBD020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD020"
 DXCCSR_MBD021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD021"
 DXCCSR_MBD022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD022"
 DXCCSR_MBD023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD023"
 DXCCSR_MBD024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD024"
 DXCCSR_MBD025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD025"
 DXCCSR_MBD026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD026"
 DXCCSR_MBD027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD027"
 DXCCSR_MBD028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD028"
 DXCCSR_MBD029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD029"
 DXCCSR_MBD030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD030"
 DXCCSR_MBD031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD031"
 DXCCSR_MBD032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD032"
 DXCCSR_MBD033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD033"
 DXCCSR_MBD034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MBD034"
 DXCCSR_MUS001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS001"
 DXCCSR_MUS002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS002"
 DXCCSR_MUS003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS003"
 DXCCSR_MUS004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS004"
 DXCCSR_MUS005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS005"
 DXCCSR_MUS006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS006"
 DXCCSR_MUS007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS007"
 DXCCSR_MUS008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS008"
 DXCCSR_MUS009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS009"
 DXCCSR_MUS010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS010"
 DXCCSR_MUS011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS011"
 DXCCSR_MUS012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS012"
 DXCCSR_MUS013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS013"
 DXCCSR_MUS014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS014"
 DXCCSR_MUS015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS015"
 DXCCSR_MUS016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS016"
 DXCCSR_MUS017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS017"
 DXCCSR_MUS018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS018"
 DXCCSR_MUS019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS019"
 DXCCSR_MUS020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS020"
 DXCCSR_MUS021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS021"
 DXCCSR_MUS022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS022"
 DXCCSR_MUS023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS023"
 DXCCSR_MUS024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS024"
 DXCCSR_MUS025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS025"
 DXCCSR_MUS026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS026"
 DXCCSR_MUS027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS027"
 DXCCSR_MUS028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS028"
 DXCCSR_MUS029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS029"
 DXCCSR_MUS030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS030"
 DXCCSR_MUS031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS031"
 DXCCSR_MUS032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS032"
 DXCCSR_MUS033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS033"
 DXCCSR_MUS034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS034"
 DXCCSR_MUS035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS035"
 DXCCSR_MUS036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS036"
 DXCCSR_MUS037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS037"
 DXCCSR_MUS038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR MUS038"
 DXCCSR_NEO001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO001"
 DXCCSR_NEO002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO002"
 DXCCSR_NEO003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO003"
 DXCCSR_NEO004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO004"
 DXCCSR_NEO005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO005"
 DXCCSR_NEO006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO006"
 DXCCSR_NEO007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO007"
 DXCCSR_NEO008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO008"
 DXCCSR_NEO009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO009"
 DXCCSR_NEO010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO010"
 DXCCSR_NEO011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO011"
 DXCCSR_NEO012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO012"
 DXCCSR_NEO013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO013"
 DXCCSR_NEO014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO014"
 DXCCSR_NEO015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO015"
 DXCCSR_NEO016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO016"
 DXCCSR_NEO017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO017"
 DXCCSR_NEO018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO018"
 DXCCSR_NEO019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO019"
 DXCCSR_NEO020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO020"
 DXCCSR_NEO021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO021"
 DXCCSR_NEO022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO022"
 DXCCSR_NEO023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO023"
 DXCCSR_NEO024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO024"
 DXCCSR_NEO025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO025"
 DXCCSR_NEO026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO026"
 DXCCSR_NEO027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO027"
 DXCCSR_NEO028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO028"
 DXCCSR_NEO029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO029"
 DXCCSR_NEO030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO030"
 DXCCSR_NEO031
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO031"
 DXCCSR_NEO032
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO032"
 DXCCSR_NEO033
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO033"
 DXCCSR_NEO034
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO034"
 DXCCSR_NEO035
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO035"
 DXCCSR_NEO036
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO036"
 DXCCSR_NEO037
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO037"
 DXCCSR_NEO038
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO038"
 DXCCSR_NEO039
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO039"
 DXCCSR_NEO040
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO040"
 DXCCSR_NEO041
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO041"
 DXCCSR_NEO042
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO042"
 DXCCSR_NEO043
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO043"
 DXCCSR_NEO044
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO044"
 DXCCSR_NEO045
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO045"
 DXCCSR_NEO046
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO046"
 DXCCSR_NEO047
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO047"
 DXCCSR_NEO048
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO048"
 DXCCSR_NEO049
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO049"
 DXCCSR_NEO050
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO050"
 DXCCSR_NEO051
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO051"
 DXCCSR_NEO052
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO052"
 DXCCSR_NEO053
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO053"
 DXCCSR_NEO054
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO054"
 DXCCSR_NEO055
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO055"
 DXCCSR_NEO056
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO056"
 DXCCSR_NEO057
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO057"
 DXCCSR_NEO058
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO058"
 DXCCSR_NEO059
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO059"
 DXCCSR_NEO060
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO060"
 DXCCSR_NEO061
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO061"
 DXCCSR_NEO062
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO062"
 DXCCSR_NEO063
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO063"
 DXCCSR_NEO064
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO064"
 DXCCSR_NEO065
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO065"
 DXCCSR_NEO066
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO066"
 DXCCSR_NEO067
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO067"
 DXCCSR_NEO068
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO068"
 DXCCSR_NEO069
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO069"
 DXCCSR_NEO070
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO070"
 DXCCSR_NEO071
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO071"
 DXCCSR_NEO072
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO072"
 DXCCSR_NEO073
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO073"
 DXCCSR_NEO074
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NEO074"
 DXCCSR_NVS001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS001"
 DXCCSR_NVS002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS002"
 DXCCSR_NVS003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS003"
 DXCCSR_NVS004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS004"
 DXCCSR_NVS005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS005"
 DXCCSR_NVS006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS006"
 DXCCSR_NVS007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS007"
 DXCCSR_NVS008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS008"
 DXCCSR_NVS009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS009"
 DXCCSR_NVS010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS010"
 DXCCSR_NVS011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS011"
 DXCCSR_NVS012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS012"
 DXCCSR_NVS013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS013"
 DXCCSR_NVS014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS014"
 DXCCSR_NVS015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS015"
 DXCCSR_NVS016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS016"
 DXCCSR_NVS017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS017"
 DXCCSR_NVS018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS018"
 DXCCSR_NVS019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS019"
 DXCCSR_NVS020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS020"
 DXCCSR_NVS021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS021"
 DXCCSR_NVS022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR NVS022"
 DXCCSR_PNL001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL001"
 DXCCSR_PNL002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL002"
 DXCCSR_PNL003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL003"
 DXCCSR_PNL004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL004"
 DXCCSR_PNL005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL005"
 DXCCSR_PNL006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL006"
 DXCCSR_PNL007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL007"
 DXCCSR_PNL008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL008"
 DXCCSR_PNL009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL009"
 DXCCSR_PNL010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL010"
 DXCCSR_PNL011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL011"
 DXCCSR_PNL012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL012"
 DXCCSR_PNL013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL013"
 DXCCSR_PNL014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL014"
 DXCCSR_PNL015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PNL015"
 DXCCSR_PRG001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG001"
 DXCCSR_PRG002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG002"
 DXCCSR_PRG003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG003"
 DXCCSR_PRG004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG004"
 DXCCSR_PRG005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG005"
 DXCCSR_PRG006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG006"
 DXCCSR_PRG007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG007"
 DXCCSR_PRG008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG008"
 DXCCSR_PRG009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG009"
 DXCCSR_PRG010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG010"
 DXCCSR_PRG011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG011"
 DXCCSR_PRG012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG012"
 DXCCSR_PRG013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG013"
 DXCCSR_PRG014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG014"
 DXCCSR_PRG015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG015"
 DXCCSR_PRG016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG016"
 DXCCSR_PRG017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG017"
 DXCCSR_PRG018
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG018"
 DXCCSR_PRG019
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG019"
 DXCCSR_PRG020
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG020"
 DXCCSR_PRG021
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG021"
 DXCCSR_PRG022
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG022"
 DXCCSR_PRG023
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG023"
 DXCCSR_PRG024
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG024"
 DXCCSR_PRG025
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG025"
 DXCCSR_PRG026
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG026"
 DXCCSR_PRG027
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG027"
 DXCCSR_PRG028
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG028"
 DXCCSR_PRG029
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG029"
 DXCCSR_PRG030
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR PRG030"
 DXCCSR_RSP001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP001"
 DXCCSR_RSP002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP002"
 DXCCSR_RSP003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP003"
 DXCCSR_RSP004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP004"
 DXCCSR_RSP005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP005"
 DXCCSR_RSP006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP006"
 DXCCSR_RSP007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP007"
 DXCCSR_RSP008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP008"
 DXCCSR_RSP009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP009"
 DXCCSR_RSP010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP010"
 DXCCSR_RSP011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP011"
 DXCCSR_RSP012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP012"
 DXCCSR_RSP013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP013"
 DXCCSR_RSP014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP014"
 DXCCSR_RSP015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP015"
 DXCCSR_RSP016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP016"
 DXCCSR_RSP017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR RSP017"
 DXCCSR_SKN001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN001"
 DXCCSR_SKN002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN002"
 DXCCSR_SKN003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN003"
 DXCCSR_SKN004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN004"
 DXCCSR_SKN005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN005"
 DXCCSR_SKN006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN006"
 DXCCSR_SKN007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SKN007"
 DXCCSR_SYM001
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM001"
 DXCCSR_SYM002
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM002"
 DXCCSR_SYM003
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM003"
 DXCCSR_SYM004
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM004"
 DXCCSR_SYM005
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM005"
 DXCCSR_SYM006
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM006"
 DXCCSR_SYM007
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM007"
 DXCCSR_SYM008
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM008"
 DXCCSR_SYM009
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM009"
 DXCCSR_SYM010
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM010"
 DXCCSR_SYM011
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM011"
 DXCCSR_SYM012
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM012"
 DXCCSR_SYM013
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM013"
 DXCCSR_SYM014
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM014"
 DXCCSR_SYM015
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM015"
 DXCCSR_SYM016
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM016"
 DXCCSR_SYM017
"Indication that at least one ICD-10-CM diagnosis on the record is included in CCSR SYM017"
 DXCCSR_VERSION               "Version of CCSR for ICD-10-CM diagnoses"
 PRCCSR_ADM001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM001"
 PRCCSR_ADM002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM002"
 PRCCSR_ADM003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM003"
 PRCCSR_ADM004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM004"
 PRCCSR_ADM005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM005"
 PRCCSR_ADM006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM006"
 PRCCSR_ADM007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM007"
 PRCCSR_ADM008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM008"
 PRCCSR_ADM009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM009"
 PRCCSR_ADM010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM010"
 PRCCSR_ADM011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM011"
 PRCCSR_ADM012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM012"
 PRCCSR_ADM013
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM013"
 PRCCSR_ADM014
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM014"
 PRCCSR_ADM015
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM015"
 PRCCSR_ADM016
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM016"
 PRCCSR_ADM017
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM017"
 PRCCSR_ADM018
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM018"
 PRCCSR_ADM019
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM019"
 PRCCSR_ADM020
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM020"
 PRCCSR_ADM021
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM021"
 PRCCSR_ADM022
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ADM022"
 PRCCSR_CAR001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR001"
 PRCCSR_CAR002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR002"
 PRCCSR_CAR003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR003"
 PRCCSR_CAR004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR004"
 PRCCSR_CAR005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR005"
 PRCCSR_CAR006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR006"
 PRCCSR_CAR007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR007"
 PRCCSR_CAR008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR008"
 PRCCSR_CAR009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR009"
 PRCCSR_CAR010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR010"
 PRCCSR_CAR011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR011"
 PRCCSR_CAR012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR012"
 PRCCSR_CAR013
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR013"
 PRCCSR_CAR014
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR014"
 PRCCSR_CAR015
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR015"
 PRCCSR_CAR016
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR016"
 PRCCSR_CAR017
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR017"
 PRCCSR_CAR018
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR018"
 PRCCSR_CAR019
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR019"
 PRCCSR_CAR020
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR020"
 PRCCSR_CAR021
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR021"
 PRCCSR_CAR022
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR022"
 PRCCSR_CAR023
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR023"
 PRCCSR_CAR024
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR024"
 PRCCSR_CAR025
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR025"
 PRCCSR_CAR026
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR026"
 PRCCSR_CAR027
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR027"
 PRCCSR_CAR028
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR028"
 PRCCSR_CAR029
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CAR029"
 PRCCSR_CHP001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CHP001"
 PRCCSR_CNS001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS001"
 PRCCSR_CNS002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS002"
 PRCCSR_CNS003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS003"
 PRCCSR_CNS004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS004"
 PRCCSR_CNS005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS005"
 PRCCSR_CNS006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS006"
 PRCCSR_CNS007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS007"
 PRCCSR_CNS008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS008"
 PRCCSR_CNS009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS009"
 PRCCSR_CNS010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS010"
 PRCCSR_CNS011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS011"
 PRCCSR_CNS012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS012"
 PRCCSR_CNS013
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS013"
 PRCCSR_CNS014
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR CNS014"
 PRCCSR_ENP001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP001"
 PRCCSR_ENP002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP002"
 PRCCSR_ENP003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP003"
 PRCCSR_ENP004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP004"
 PRCCSR_ENP005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP005"
 PRCCSR_ENP006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENP006"
 PRCCSR_ENT001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT001"
 PRCCSR_ENT002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT002"
 PRCCSR_ENT003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT003"
 PRCCSR_ENT004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT004"
 PRCCSR_ENT005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT005"
 PRCCSR_ENT006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT006"
 PRCCSR_ENT007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT007"
 PRCCSR_ENT008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT008"
 PRCCSR_ENT009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT009"
 PRCCSR_ENT010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT010"
 PRCCSR_ENT011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT011"
 PRCCSR_ENT012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT012"
 PRCCSR_ENT013
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT013"
 PRCCSR_ENT014
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT014"
 PRCCSR_ENT015
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT015"
 PRCCSR_ENT016
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT016"
 PRCCSR_ENT017
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ENT017"
 PRCCSR_ESA001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA001"
 PRCCSR_ESA002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA002"
 PRCCSR_ESA003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA003"
 PRCCSR_ESA004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA004"
 PRCCSR_ESA005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA005"
 PRCCSR_ESA006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA006"
 PRCCSR_ESA007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA007"
 PRCCSR_ESA008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA008"
 PRCCSR_ESA009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA009"
 PRCCSR_ESA010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA010"
 PRCCSR_ESA011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR ESA011"
 PRCCSR_EST001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST001"
 PRCCSR_EST002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST002"
 PRCCSR_EST003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST003"
 PRCCSR_EST004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST004"
 PRCCSR_EST005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EST005"
 PRCCSR_EYP001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP001"
 PRCCSR_EYP002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR EYP002"
 PRCCSR_FRS001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS001"
 PRCCSR_FRS002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS002"
 PRCCSR_FRS003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS003"
 PRCCSR_FRS004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS004"
 PRCCSR_FRS005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS005"
 PRCCSR_FRS006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS006"
 PRCCSR_FRS007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS007"
 PRCCSR_FRS008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS008"
 PRCCSR_FRS009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS009"
 PRCCSR_FRS010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS010"
 PRCCSR_FRS011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS011"
 PRCCSR_FRS012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS012"
 PRCCSR_FRS013
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS013"
 PRCCSR_FRS014
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS014"
 PRCCSR_FRS015
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR FRS015"
 PRCCSR_GIS001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS001"
 PRCCSR_GIS002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS002"
 PRCCSR_GIS003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS003"
 PRCCSR_GIS004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS004"
 PRCCSR_GIS005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS005"
 PRCCSR_GIS006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS006"
 PRCCSR_GIS007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS007"
 PRCCSR_GIS008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS008"
 PRCCSR_GIS009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS009"
 PRCCSR_GIS010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS010"
 PRCCSR_GIS011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS011"
 PRCCSR_GIS012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS012"
 PRCCSR_GIS013
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS013"
 PRCCSR_GIS014
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS014"
 PRCCSR_GIS015
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS015"
 PRCCSR_GIS016
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS016"
 PRCCSR_GIS017
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS017"
 PRCCSR_GIS018
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS018"
 PRCCSR_GIS019
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS019"
 PRCCSR_GIS020
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS020"
 PRCCSR_GIS021
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS021"
 PRCCSR_GIS022
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS022"
 PRCCSR_GIS023
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS023"
 PRCCSR_GIS024
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS024"
 PRCCSR_GIS025
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS025"
 PRCCSR_GIS026
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS026"
 PRCCSR_GIS027
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS027"
 PRCCSR_GIS028
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS028"
 PRCCSR_GIS029
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GIS029"
 PRCCSR_GNR001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR001"
 PRCCSR_GNR002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR002"
 PRCCSR_GNR003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR003"
 PRCCSR_GNR004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR004"
 PRCCSR_GNR005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR005"
 PRCCSR_GNR006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR006"
 PRCCSR_GNR007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR007"
 PRCCSR_GNR008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR008"
 PRCCSR_GNR009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR009"
 PRCCSR_GNR010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR GNR010"
 PRCCSR_HEP001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP001"
 PRCCSR_HEP002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP002"
 PRCCSR_HEP003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP003"
 PRCCSR_HEP004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP004"
 PRCCSR_HEP005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP005"
 PRCCSR_HEP006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP006"
 PRCCSR_HEP007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP007"
 PRCCSR_HEP008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP008"
 PRCCSR_HEP009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP009"
 PRCCSR_HEP010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP010"
 PRCCSR_HEP011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP011"
 PRCCSR_HEP012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP012"
 PRCCSR_HEP013
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR HEP013"
 PRCCSR_IMG001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG001"
 PRCCSR_IMG002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG002"
 PRCCSR_IMG003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG003"
 PRCCSR_IMG004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG004"
 PRCCSR_IMG005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG005"
 PRCCSR_IMG006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG006"
 PRCCSR_IMG007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG007"
 PRCCSR_IMG008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG008"
 PRCCSR_IMG009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG009"
 PRCCSR_IMG010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR IMG010"
 PRCCSR_LYM001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM001"
 PRCCSR_LYM002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM002"
 PRCCSR_LYM003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM003"
 PRCCSR_LYM004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM004"
 PRCCSR_LYM005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM005"
 PRCCSR_LYM006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM006"
 PRCCSR_LYM007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM007"
 PRCCSR_LYM008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM008"
 PRCCSR_LYM009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM009"
 PRCCSR_LYM010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM010"
 PRCCSR_LYM011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR LYM011"
 PRCCSR_MAM001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM001"
 PRCCSR_MAM002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM002"
 PRCCSR_MAM003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM003"
 PRCCSR_MAM004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM004"
 PRCCSR_MAM005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM005"
 PRCCSR_MAM006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM006"
 PRCCSR_MAM007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM007"
 PRCCSR_MAM008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM008"
 PRCCSR_MAM009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM009"
 PRCCSR_MAM010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM010"
 PRCCSR_MAM011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM011"
 PRCCSR_MAM012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM012"
 PRCCSR_MAM013
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM013"
 PRCCSR_MAM014
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM014"
 PRCCSR_MAM015
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MAM015"
 PRCCSR_MHT001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT001"
 PRCCSR_MHT002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT002"
 PRCCSR_MHT003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT003"
 PRCCSR_MHT004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT004"
 PRCCSR_MHT005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MHT005"
 PRCCSR_MRS001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS001"
 PRCCSR_MRS002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS002"
 PRCCSR_MRS003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS003"
 PRCCSR_MRS004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS004"
 PRCCSR_MRS005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS005"
 PRCCSR_MRS006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS006"
 PRCCSR_MRS007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MRS007"
 PRCCSR_MST001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST001"
 PRCCSR_MST002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST002"
 PRCCSR_MST003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST003"
 PRCCSR_MST004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST004"
 PRCCSR_MST005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST005"
 PRCCSR_MST006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST006"
 PRCCSR_MST007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST007"
 PRCCSR_MST008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST008"
 PRCCSR_MST009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST009"
 PRCCSR_MST010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST010"
 PRCCSR_MST011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST011"
 PRCCSR_MST012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST012"
 PRCCSR_MST013
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST013"
 PRCCSR_MST014
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST014"
 PRCCSR_MST015
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST015"
 PRCCSR_MST016
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST016"
 PRCCSR_MST017
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST017"
 PRCCSR_MST018
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST018"
 PRCCSR_MST019
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST019"
 PRCCSR_MST020
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST020"
 PRCCSR_MST021
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST021"
 PRCCSR_MST022
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST022"
 PRCCSR_MST023
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST023"
 PRCCSR_MST024
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST024"
 PRCCSR_MST025
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST025"
 PRCCSR_MST026
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST026"
 PRCCSR_MST027
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST027"
 PRCCSR_MST028
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST028"
 PRCCSR_MST029
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST029"
 PRCCSR_MST030
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR MST030"
 PRCCSR_NCM001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM001"
 PRCCSR_NCM002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM002"
 PRCCSR_NCM003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM003"
 PRCCSR_NCM004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR NCM004"
 PRCCSR_OST001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OST001"
 PRCCSR_OTR001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR001"
 PRCCSR_OTR002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR002"
 PRCCSR_OTR003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR003"
 PRCCSR_OTR004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR004"
 PRCCSR_OTR005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR OTR005"
 PRCCSR_PGN001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN001"
 PRCCSR_PGN002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN002"
 PRCCSR_PGN003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN003"
 PRCCSR_PGN004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN004"
 PRCCSR_PGN005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN005"
 PRCCSR_PGN006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN006"
 PRCCSR_PGN007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN007"
 PRCCSR_PGN008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN008"
 PRCCSR_PGN009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PGN009"
 PRCCSR_PLC001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC001"
 PRCCSR_PLC002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PLC002"
 PRCCSR_PNS001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS001"
 PRCCSR_PNS002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS002"
 PRCCSR_PNS003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS003"
 PRCCSR_PNS004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS004"
 PRCCSR_PNS005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS005"
 PRCCSR_PNS006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR PNS006"
 PRCCSR_RAD001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD001"
 PRCCSR_RAD002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD002"
 PRCCSR_RAD003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD003"
 PRCCSR_RAD004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RAD004"
 PRCCSR_RES001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES001"
 PRCCSR_RES002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES002"
 PRCCSR_RES003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES003"
 PRCCSR_RES004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES004"
 PRCCSR_RES005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES005"
 PRCCSR_RES006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES006"
 PRCCSR_RES007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES007"
 PRCCSR_RES008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES008"
 PRCCSR_RES009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES009"
 PRCCSR_RES010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES010"
 PRCCSR_RES011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES011"
 PRCCSR_RES012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES012"
 PRCCSR_RES013
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES013"
 PRCCSR_RES014
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RES014"
 PRCCSR_RHB001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB001"
 PRCCSR_RHB002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB002"
 PRCCSR_RHB003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB003"
 PRCCSR_RHB004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR RHB004"
 PRCCSR_SKB001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB001"
 PRCCSR_SKB002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB002"
 PRCCSR_SKB003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB003"
 PRCCSR_SKB004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB004"
 PRCCSR_SKB005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB005"
 PRCCSR_SKB006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB006"
 PRCCSR_SKB007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB007"
 PRCCSR_SKB008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB008"
 PRCCSR_SKB009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB009"
 PRCCSR_SKB010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SKB010"
 PRCCSR_SUD001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD001"
 PRCCSR_SUD002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD002"
 PRCCSR_SUD003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD003"
 PRCCSR_SUD004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR SUD004"
 PRCCSR_URN001
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN001"
 PRCCSR_URN002
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN002"
 PRCCSR_URN003
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN003"
 PRCCSR_URN004
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN004"
 PRCCSR_URN005
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN005"
 PRCCSR_URN006
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN006"
 PRCCSR_URN007
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN007"
 PRCCSR_URN008
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN008"
 PRCCSR_URN009
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN009"
 PRCCSR_URN010
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN010"
 PRCCSR_URN011
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN011"
 PRCCSR_URN012
"Indication that at least one ICD-10-PCS procedure on the record is included in CCSR URN012"
 PRCCSR_VERSION               "Version of CCSR for ICD-10-PCS procedures" .


/**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************/

RECODE CCIR1
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR2
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR3
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR4
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR5
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR6
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR7
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR8
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR9
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR10
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR11
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR12
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR13
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR14
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR15
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR16
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR17
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR18
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR19
 (-99,-88,-66,-55=SYSMIS).
RECODE CCIR20
 (-99,-88,-66,-55=SYSMIS).
RECODE CMR_AIDS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_ALCOHOL
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_ANEMDEF
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_AUTOIMMUNE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_BLDLOSS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_LEUK
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_LYMPH
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_METS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_NSITU
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CANCER_SOLID
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_CBVD
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_COAG
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DEMENTIA
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DEPRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DIAB_CX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DIAB_UNCX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_DRUG_ABUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_HF
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_HTN_CX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_HTN_UNCX
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_LIVER_MLD
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_LIVER_SEV
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_LUNG_CHRONIC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_NEURO_MOVT
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_NEURO_OTH
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_NEURO_SEIZ
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_OBESE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PARALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PERIVASC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PSYCHOSES
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_PULMCIRC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_RENLFL_MOD
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_RENLFL_SEV
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_THYROID_HYPO
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_THYROID_OTH
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_ULCER_PEPTIC
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_VALVE
 (-9,-8,-6,-5=SYSMIS).
RECODE CMR_WGHTLOSS
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_CUT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_DROWN
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FALL
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FIRE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_FIREARM
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_MACHINERY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_MVT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_NATURE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_OVEREXERTION
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_POISON
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_STRUCK
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY_SUFFOCATION
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_ASSAULT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_SELF_HARM
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INTENT_UNINTENTIONAL
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCSR_BLD001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_BLD010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_CIR039
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DEN001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DEN002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DEN003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_DIG025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EAR006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_END017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EXT030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_EYE012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_FAC025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_GEN026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INF012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ039
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ040
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ041
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ042
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ043
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ044
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ045
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ046
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ047
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ048
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ049
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ050
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ051
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ052
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ053
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ054
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ055
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ056
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ057
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ058
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ059
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ060
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ061
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ062
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ063
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ064
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ065
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ066
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ067
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ068
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ069
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ070
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ071
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ072
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ073
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ074
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ075
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_INJ076
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MAL010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MBD034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_MUS038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO031
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO032
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO033
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO034
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO035
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO036
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO037
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO038
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO039
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO040
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO041
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO042
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO043
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO044
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO045
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO046
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO047
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO048
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO049
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO050
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO051
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO052
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO053
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO054
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO055
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO056
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO057
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO058
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO059
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO060
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO061
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO062
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO063
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO064
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO065
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO066
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO067
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO068
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO069
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO070
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO071
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO072
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO073
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NEO074
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_NVS022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PNL015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG018
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG019
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG020
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG021
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG022
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG023
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG024
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG025
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG026
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG027
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG028
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG029
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_PRG030
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_RSP017
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SKN007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM001
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM002
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM003
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM004
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM005
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM006
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM007
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM008
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM009
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM010
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM011
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM012
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM013
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM014
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM015
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM016
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCSR_SYM017
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM012
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM013
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM014
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM015
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM016
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM017
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM018
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM019
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM020
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM021
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ADM022
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR012
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR013
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR014
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR015
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR016
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR017
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR018
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR019
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR020
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR021
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR022
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR023
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR024
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR025
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR026
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR027
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR028
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CAR029
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CHP001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS012
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS013
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_CNS014
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENP001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENP002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENP003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENP004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENP005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENP006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT012
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT013
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT014
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT015
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT016
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ENT017
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_ESA011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_EST001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_EST002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_EST003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_EST004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_EST005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_EYP001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_EYP002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS012
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS013
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS014
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_FRS015
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS012
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS013
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS014
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS015
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS016
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS017
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS018
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS019
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS020
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS021
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS022
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS023
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS024
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS025
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS026
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS027
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS028
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GIS029
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GNR001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GNR002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GNR003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GNR004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GNR005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GNR006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GNR007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GNR008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GNR009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_GNR010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP012
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_HEP013
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_IMG001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_IMG002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_IMG003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_IMG004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_IMG005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_IMG006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_IMG007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_IMG008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_IMG009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_IMG010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_LYM011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM012
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM013
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM014
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MAM015
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MHT001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MHT002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MHT003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MHT004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MHT005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MRS001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MRS002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MRS003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MRS004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MRS005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MRS006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MRS007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST012
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST013
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST014
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST015
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST016
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST017
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST018
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST019
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST020
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST021
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST022
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST023
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST024
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST025
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST026
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST027
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST028
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST029
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_MST030
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_NCM001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_NCM002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_NCM003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_NCM004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_OST001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_OTR001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_OTR002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_OTR003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_OTR004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_OTR005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PGN001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PGN002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PGN003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PGN004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PGN005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PGN006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PGN007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PGN008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PGN009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PLC001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PLC002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PNS001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PNS002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PNS003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PNS004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PNS005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_PNS006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RAD001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RAD002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RAD003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RAD004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES012
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES013
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RES014
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RHB001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RHB002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RHB003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_RHB004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SKB001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SKB002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SKB003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SKB004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SKB005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SKB006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SKB007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SKB008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SKB009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SKB010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SUD001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SUD002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SUD003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_SUD004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN001
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN002
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN003
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN004
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN005
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN006
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN007
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN008
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN009
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN010
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN011
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCSR_URN012
 (-99,-88,-66,-55=SYSMIS).



SAVE OUTFILE = 'UT_SID_2023_DX_PR_GRPS.sav' /COMPRESSED.
