/*******************************************************************
*   VT_SID_2011_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'VT_SID_2011_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AHOUR                     10-  13
 AMONTH                    14-  15
 ATYPE                     16-  17
 AWEEKEND                  18-  19
 BWT                       20-  23
 CPT1                      24-  28 (A)
 CPT2                      29-  33 (A)
 CPT3                      34-  38 (A)
 CPT4                      39-  43 (A)
 CPT5                      44-  48 (A)
 CPT6                      49-  53 (A)
 CPT7                      54-  58 (A)
 CPT8                      59-  63 (A)
 CPT9                      64-  68 (A)
 CPT10                     69-  73 (A)
 CPT11                     74-  78 (A)
 CPT12                     79-  83 (A)
 CPT13                     84-  88 (A)
 CPT14                     89-  93 (A)
 CPT15                     94-  98 (A)
 CPT16                     99- 103 (A)
 CPT17                    104- 108 (A)
 CPT18                    109- 113 (A)
 CPT19                    114- 118 (A)
 CPT20                    119- 123 (A)
 CPT21                    124- 128 (A)
 CPT22                    129- 133 (A)
 CPT23                    134- 138 (A)
 CPT24                    139- 143 (A)
 CPT25                    144- 148 (A)
 CPT26                    149- 153 (A)
 CPT27                    154- 158 (A)
 CPT28                    159- 163 (A)
 CPT29                    164- 168 (A)
 CPT30                    169- 173 (A)
 CPTCCS1                  174- 176
 CPTCCS2                  177- 179
 CPTCCS3                  180- 182
 CPTCCS4                  183- 185
 CPTCCS5                  186- 188
 CPTCCS6                  189- 191
 CPTCCS7                  192- 194
 CPTCCS8                  195- 197
 CPTCCS9                  198- 200
 CPTCCS10                 201- 203
 CPTCCS11                 204- 206
 CPTCCS12                 207- 209
 CPTCCS13                 210- 212
 CPTCCS14                 213- 215
 CPTCCS15                 216- 218
 CPTCCS16                 219- 221
 CPTCCS17                 222- 224
 CPTCCS18                 225- 227
 CPTCCS19                 228- 230
 CPTCCS20                 231- 233
 CPTCCS21                 234- 236
 CPTCCS22                 237- 239
 CPTCCS23                 240- 242
 CPTCCS24                 243- 245
 CPTCCS25                 246- 248
 CPTCCS26                 249- 251
 CPTCCS27                 252- 254
 CPTCCS28                 255- 257
 CPTCCS29                 258- 260
 CPTCCS30                 261- 263
 CPTDAY1                  264- 266
 CPTDAY2                  267- 269
 CPTDAY3                  270- 272
 CPTDAY4                  273- 275
 CPTDAY5                  276- 278
 CPTDAY6                  279- 281
 CPTDAY7                  282- 284
 CPTDAY8                  285- 287
 CPTDAY9                  288- 290
 CPTDAY10                 291- 293
 CPTDAY11                 294- 296
 CPTDAY12                 297- 299
 CPTDAY13                 300- 302
 CPTDAY14                 303- 305
 CPTDAY15                 306- 308
 CPTDAY16                 309- 311
 CPTDAY17                 312- 314
 CPTDAY18                 315- 317
 CPTDAY19                 318- 320
 CPTDAY20                 321- 323
 CPTDAY21                 324- 326
 CPTDAY22                 327- 329
 CPTDAY23                 330- 332
 CPTDAY24                 333- 335
 CPTDAY25                 336- 338
 CPTDAY26                 339- 341
 CPTDAY27                 342- 344
 CPTDAY28                 345- 347
 CPTDAY29                 348- 350
 CPTDAY30                 351- 353
 DIED                     354- 355
 DISPUB04                 356- 357
 DISPUNIFORM              358- 359
 DISP_X                   360- 361 (A)
 DQTR                     362- 363
 DRG                      364- 366
 DRG24                    367- 369
 DRGVER                   370- 371
 DRG_NoPOA                372- 374
 DSHOSPID                 375- 391 (A)
 DX1                      392- 396 (A)
 DX2                      397- 401 (A)
 DX3                      402- 406 (A)
 DX4                      407- 411 (A)
 DX5                      412- 416 (A)
 DX6                      417- 421 (A)
 DX7                      422- 426 (A)
 DX8                      427- 431 (A)
 DX9                      432- 436 (A)
 DX10                     437- 441 (A)
 DX11                     442- 446 (A)
 DX12                     447- 451 (A)
 DX13                     452- 456 (A)
 DX14                     457- 461 (A)
 DX15                     462- 466 (A)
 DX16                     467- 471 (A)
 DX17                     472- 476 (A)
 DX18                     477- 481 (A)
 DX19                     482- 486 (A)
 DX20                     487- 491 (A)
 DXCCS1                   492- 495
 DXCCS2                   496- 499
 DXCCS3                   500- 503
 DXCCS4                   504- 507
 DXCCS5                   508- 511
 DXCCS6                   512- 515
 DXCCS7                   516- 519
 DXCCS8                   520- 523
 DXCCS9                   524- 527
 DXCCS10                  528- 531
 DXCCS11                  532- 535
 DXCCS12                  536- 539
 DXCCS13                  540- 543
 DXCCS14                  544- 547
 DXCCS15                  548- 551
 DXCCS16                  552- 555
 DXCCS17                  556- 559
 DXCCS18                  560- 563
 DXCCS19                  564- 567
 DXCCS20                  568- 571
 DXPOA1                   572     (A)
 DXPOA2                   573     (A)
 DXPOA3                   574     (A)
 DXPOA4                   575     (A)
 DXPOA5                   576     (A)
 DXPOA6                   577     (A)
 DXPOA7                   578     (A)
 DXPOA8                   579     (A)
 DXPOA9                   580     (A)
 DXPOA10                  581     (A)
 DXPOA11                  582     (A)
 DXPOA12                  583     (A)
 DXPOA13                  584     (A)
 DXPOA14                  585     (A)
 DXPOA15                  586     (A)
 DXPOA16                  587     (A)
 DXPOA17                  588     (A)
 DXPOA18                  589     (A)
 DXPOA19                  590     (A)
 DXPOA20                  591     (A)
 DaysToEvent              592- 597
 ECODE1                   598- 602 (A)
 ECODE2                   603- 607 (A)
 ECODE3                   608- 612 (A)
 ECODE4                   613- 617 (A)
 ECODE5                   618- 622 (A)
 ECODE6                   623- 627 (A)
 ECODE7                   628- 632 (A)
 ECODE8                   633- 637 (A)
 ECODE9                   638- 642 (A)
 E_CCS1                   643- 646
 E_CCS2                   647- 650
 E_CCS3                   651- 654
 E_CCS4                   655- 658
 E_CCS5                   659- 662
 E_CCS6                   663- 666
 E_CCS7                   667- 670
 E_CCS8                   671- 674
 E_CCS9                   675- 678
 E_POA1                   679     (A)
 E_POA2                   680     (A)
 E_POA3                   681     (A)
 E_POA4                   682     (A)
 E_POA5                   683     (A)
 E_POA6                   684     (A)
 E_POA7                   685     (A)
 E_POA8                   686     (A)
 E_POA9                   687     (A)
 FEMALE                   688- 689
 HCUP_ED                  690- 691
 HCUP_OS                  692- 693
 HCUP_SURGERY_BROAD       694- 695
 HCUP_SURGERY_NARROW      696- 697
 HISPANIC_X               698- 705 (A)
 HOSPBRTH                 706- 708
 HOSPST                   709- 710 (A)
 HOSP_NPI                 711- 720 (A)
 KEY                      721- 735
 LOS                      736- 740
 LOS_X                    741- 746
 MDC                      747- 748
 MDC24                    749- 750
 MDC_NoPOA                751- 752
 MEDINCSTQ                753- 754
 MRN_R                    755- 763
 NCHRONIC                 764- 766
 NCPT                     767- 769
 NDX                      770- 771
 NECODE                   772- 773
 NEOMAT                   774- 775
 NPR                      776- 777
 ORPROC                   778- 779
 PAY1                     780- 781
 PAY1_X                   782- 789 (A)
 PAY2                     790- 791
 PAY2_X                   792- 799 (A)
 PAY3                     800- 801
 PAY3_X                   802- 809 (A)
 PAYER1_X                 810- 825 (A)
 PAYER2_X                 826- 841 (A)
 PL_CBSA                  842- 844
 PL_MSA1993               845- 847
 PL_NCHS2006              848- 849
 PL_RUCA10_2005           850- 851
 PL_RUCA2005              852- 855
 PL_RUCA4_2005            856- 857
 PL_RUCC2003              858- 859
 PL_UIC2003               860- 861
 PL_UR_CAT4               862- 863
 PNUM_R                   864- 872
 PR1                      873- 876 (A)
 PR2                      877- 880 (A)
 PR3                      881- 884 (A)
 PR4                      885- 888 (A)
 PR5                      889- 892 (A)
 PR6                      893- 896 (A)
 PR7                      897- 900 (A)
 PR8                      901- 904 (A)
 PR9                      905- 908 (A)
 PR10                     909- 912 (A)
 PR11                     913- 916 (A)
 PR12                     917- 920 (A)
 PR13                     921- 924 (A)
 PR14                     925- 928 (A)
 PR15                     929- 932 (A)
 PR16                     933- 936 (A)
 PR17                     937- 940 (A)
 PR18                     941- 944 (A)
 PR19                     945- 948 (A)
 PR20                     949- 952 (A)
 PRCCS1                   953- 955
 PRCCS2                   956- 958
 PRCCS3                   959- 961
 PRCCS4                   962- 964
 PRCCS5                   965- 967
 PRCCS6                   968- 970
 PRCCS7                   971- 973
 PRCCS8                   974- 976
 PRCCS9                   977- 979
 PRCCS10                  980- 982
 PRCCS11                  983- 985
 PRCCS12                  986- 988
 PRCCS13                  989- 991
 PRCCS14                  992- 994
 PRCCS15                  995- 997
 PRCCS16                  998-1000
 PRCCS17                 1001-1003
 PRCCS18                 1004-1006
 PRCCS19                 1007-1009
 PRCCS20                 1010-1012
 PRDAY1                  1013-1017
 PRDAY2                  1018-1022
 PRDAY3                  1023-1027
 PRDAY4                  1028-1032
 PRDAY5                  1033-1037
 PRDAY6                  1038-1042
 PRDAY7                  1043-1047
 PRDAY8                  1048-1052
 PRDAY9                  1053-1057
 PRDAY10                 1058-1062
 PRDAY11                 1063-1067
 PRDAY12                 1068-1072
 PRDAY13                 1073-1077
 PRDAY14                 1078-1082
 PRDAY15                 1083-1087
 PRDAY16                 1088-1092
 PRDAY17                 1093-1097
 PRDAY18                 1098-1102
 PRDAY19                 1103-1107
 PRDAY20                 1108-1112
 PROCTYPE                1113-1115
 PSTATE                  1116-1117 (A)
 PSTCO                   1118-1122
 PSTCO2                  1123-1127
 PointOfOriginUB04       1128     (A)
 PointOfOrigin_X         1129-1136 (A)
 RACE                    1137-1138
 RACE_X                  1139-1146 (A)
 READMIT                 1147-1148
 TOTCHG                  1149-1158
 TOTCHG_X                1159-1173
 TRAN_IN                 1174-1175
 TRAN_OUT                1176-1177
 VisitLink               1178-1186
 YEAR                    1187-1190
 ZIP3                    1191-1193 (A)
 ZIPINC_QRTL             1194-1196
 TOWN                    1197-1204 (A)
 ZIP                     1205-1209 (A)
 AYEAR                   1210-1213
 DMONTH                  1214-1215
 BMONTH                  1216-1217
 BYEAR                   1218-1221
 PRMONTH1                1222-1223
 PRMONTH2                1224-1225
 PRMONTH3                1226-1227
 PRMONTH4                1228-1229
 PRMONTH5                1230-1231
 PRMONTH6                1232-1233
 PRMONTH7                1234-1235
 PRMONTH8                1236-1237
 PRMONTH9                1238-1239
 PRMONTH10               1240-1241
 PRMONTH11               1242-1243
 PRMONTH12               1244-1245
 PRMONTH13               1246-1247
 PRMONTH14               1248-1249
 PRMONTH15               1250-1251
 PRMONTH16               1252-1253
 PRMONTH17               1254-1255
 PRMONTH18               1256-1257
 PRMONTH19               1258-1259
 PRMONTH20               1260-1261
 PRYEAR1                 1262-1265
 PRYEAR2                 1266-1269
 PRYEAR3                 1270-1273
 PRYEAR4                 1274-1277
 PRYEAR5                 1278-1281
 PRYEAR6                 1282-1285
 PRYEAR7                 1286-1289
 PRYEAR8                 1290-1293
 PRYEAR9                 1294-1297
 PRYEAR10                1298-1301
 PRYEAR11                1302-1305
 PRYEAR12                1306-1309
 PRYEAR13                1310-1313
 PRYEAR14                1314-1317
 PRYEAR15                1318-1321
 PRYEAR16                1322-1325
 PRYEAR17                1326-1329
 PRYEAR18                1330-1333
 PRYEAR19                1334-1337
 PRYEAR20                1338-1341.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 CPTDAY1                 (F4.0) /
 CPTDAY2                 (F4.0) /
 CPTDAY3                 (F4.0) /
 CPTDAY4                 (F4.0) /
 CPTDAY5                 (F4.0) /
 CPTDAY6                 (F4.0) /
 CPTDAY7                 (F4.0) /
 CPTDAY8                 (F4.0) /
 CPTDAY9                 (F4.0) /
 CPTDAY10                (F4.0) /
 CPTDAY11                (F4.0) /
 CPTDAY12                (F4.0) /
 CPTDAY13                (F4.0) /
 CPTDAY14                (F4.0) /
 CPTDAY15                (F4.0) /
 CPTDAY16                (F4.0) /
 CPTDAY17                (F4.0) /
 CPTDAY18                (F4.0) /
 CPTDAY19                (F4.0) /
 CPTDAY20                (F4.0) /
 CPTDAY21                (F4.0) /
 CPTDAY22                (F4.0) /
 CPTDAY23                (F4.0) /
 CPTDAY24                (F4.0) /
 CPTDAY25                (F4.0) /
 CPTDAY26                (F4.0) /
 CPTDAY27                (F4.0) /
 CPTDAY28                (F4.0) /
 CPTDAY29                (F4.0) /
 CPTDAY30                (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPOA               (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DaysToEvent             (F8.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HCUP_SURGERY_BROAD      (F3.0) /
 HCUP_SURGERY_NARROW     (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDC_NoPOA               (F3.0) /
 MEDINCSTQ               (F3.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PAY3                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PNUM_R                  (F5.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 READMIT                 (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TRAN_IN                 (F3.0) /
 TRAN_OUT                (F3.0) /
 VisitLink               (F8.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRMONTH16               (F3.0) /
 PRMONTH17               (F3.0) /
 PRMONTH18               (F3.0) /
 PRMONTH19               (F3.0) /
 PRMONTH20               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AHOUR                   "Admission Hour"
 AMONTH                  "Admission month"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BWT                     "Birth weight in grams"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPT26                   "CPT/HCPCS procedure code 26"
 CPT27                   "CPT/HCPCS procedure code 27"
 CPT28                   "CPT/HCPCS procedure code 28"
 CPT29                   "CPT/HCPCS procedure code 29"
 CPT30                   "CPT/HCPCS procedure code 30"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTCCS26                "CCS: CPT 26"
 CPTCCS27                "CCS: CPT 27"
 CPTCCS28                "CCS: CPT 28"
 CPTCCS29                "CCS: CPT 29"
 CPTCCS30                "CCS: CPT 30"
 CPTDAY1                 "Number of days from admission to CPT1"
 CPTDAY2                 "Number of days from admission to CPT2"
 CPTDAY3                 "Number of days from admission to CPT3"
 CPTDAY4                 "Number of days from admission to CPT4"
 CPTDAY5                 "Number of days from admission to CPT5"
 CPTDAY6                 "Number of days from admission to CPT6"
 CPTDAY7                 "Number of days from admission to CPT7"
 CPTDAY8                 "Number of days from admission to CPT8"
 CPTDAY9                 "Number of days from admission to CPT9"
 CPTDAY10                "Number of days from admission to CPT10"
 CPTDAY11                "Number of days from admission to CPT11"
 CPTDAY12                "Number of days from admission to CPT12"
 CPTDAY13                "Number of days from admission to CPT13"
 CPTDAY14                "Number of days from admission to CPT14"
 CPTDAY15                "Number of days from admission to CPT15"
 CPTDAY16                "Number of days from admission to CPT16"
 CPTDAY17                "Number of days from admission to CPT17"
 CPTDAY18                "Number of days from admission to CPT18"
 CPTDAY19                "Number of days from admission to CPT19"
 CPTDAY20                "Number of days from admission to CPT20"
 CPTDAY21                "Number of days from admission to CPT21"
 CPTDAY22                "Number of days from admission to CPT22"
 CPTDAY23                "Number of days from admission to CPT23"
 CPTDAY24                "Number of days from admission to CPT24"
 CPTDAY25                "Number of days from admission to CPT25"
 CPTDAY26                "Number of days from admission to CPT26"
 CPTDAY27                "Number of days from admission to CPT27"
 CPTDAY28                "Number of days from admission to CPT28"
 CPTDAY29                "Number of days from admission to CPT29"
 CPTDAY30                "Number of days from admission to CPT30"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DRG_NoPOA               "DRG in use on discharge date, calculated without POA"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DXPOA7                  "Diagnosis 7, present on admission indicator"
 DXPOA8                  "Diagnosis 8, present on admission indicator"
 DXPOA9                  "Diagnosis 9, present on admission indicator"
 DXPOA10                 "Diagnosis 10, present on admission indicator"
 DXPOA11                 "Diagnosis 11, present on admission indicator"
 DXPOA12                 "Diagnosis 12, present on admission indicator"
 DXPOA13                 "Diagnosis 13, present on admission indicator"
 DXPOA14                 "Diagnosis 14, present on admission indicator"
 DXPOA15                 "Diagnosis 15, present on admission indicator"
 DXPOA16                 "Diagnosis 16, present on admission indicator"
 DXPOA17                 "Diagnosis 17, present on admission indicator"
 DXPOA18                 "Diagnosis 18, present on admission indicator"
 DXPOA19                 "Diagnosis 19, present on admission indicator"
 DXPOA20                 "Diagnosis 20, present on admission indicator"
 DaysToEvent             "Days from 'start date' to admission"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 ECODE9                  "E code 9"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 E_CCS9                  "CCS: E Code 9"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 E_POA5                  "E Code 5, present on admission indicator"
 E_POA6                  "E Code 6, present on admission indicator"
 E_POA7                  "E Code 7, present on admission indicator"
 E_POA8                  "E Code 8, present on admission indicator"
 E_POA9                  "E Code 9, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HCUP_SURGERY_BROAD      "Revised HCUP_AS (PCLASSn=3 or 4, or broad definition)"
 HCUP_SURGERY_NARROW     "Revised HCUP_AS (PCLASSn=4, or narrow definition)"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 HOSP_NPI                "Hospital NPI"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MDC                     "MDC in effect on discharge date"
 MDC24                   "MDC, version 24"
 MDC_NoPOA               "MDC in use on discharge date, calculated without POA"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAY3                    "Tertiary expected payer (uniform)"
 PAY3_X                  "Tertiary expected payer (as received from source)"
 PAYER1_X                "Primary expected payer plan identifier (as received from source)"
 PAYER2_X
"Secondary expected payer plan identifier (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PNUM_R                  "Person number (re-identified)"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PRDAY16                 "Number of days from admission to PR16"
 PRDAY17                 "Number of days from admission to PR17"
 PRDAY18                 "Number of days from admission to PR18"
 PRDAY19                 "Number of days from admission to PR19"
 PRDAY20                 "Number of days from admission to PR20"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 READMIT                 "Readmission"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TRAN_IN                 "Transfer in indicator"
 TRAN_OUT                "Transfer out indicator"
 VisitLink               "Visit linkage variable"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 TOWN                    "Patient town of residence (as received from source)"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRMONTH16               "Month of procedure 16"
 PRMONTH17               "Month of procedure 17"
 PRMONTH18               "Month of procedure 18"
 PRMONTH19               "Month of procedure 19"
 PRMONTH20               "Month of procedure 20"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15"
 PRYEAR16                "Year of procedure 16"
 PRYEAR17                "Year of procedure 17"
 PRYEAR18                "Year of procedure 18"
 PRYEAR19                "Year of procedure 19"
 PRYEAR20                "Year of procedure 20" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_BROAD
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_SURGERY_NARROW
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE READMIT
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'VT_SID_2011_CORE.SAV' /COMPRESSED.
